/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.ages;

import ancestris.reports.FormatAgeOptions;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.utils.PropUtils;
import genj.fo.Document;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.option.Multiline;
import genj.report.Report;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;

public class ReportAges
extends Report {
    private static List<String> EVENTS = new ArrayList<String>(PropUtils.getEventNames());
    public FormattingOptions formattingOptions;
    public ScopeIndiMiniOptions scope;
    @Multiline
    public int[] eventSelector;
    public String[] eventSelectors;
    public boolean reportAgeCalculated;
    public boolean reportAge;
    public boolean reportDifference;
    public boolean reportDate;
    public MyDataFormatOptions dataFormatOptions;
    public SimpleColorsOptions colors;
    private Document doc;
    private Indi indi;
    private boolean reportAgeAtChildBirth;
    private boolean reportAgeSinceBirth;
    private boolean reportAgeSinceDeath;
    private static Delta DELTA0 = new Delta(0, 0, 0);

    public ReportAges() {
        EVENTS.add(this.translate("reportAgeAtChildBirth"));
        EVENTS.add(this.translate("reportAgeSinceBirth"));
        EVENTS.add(this.translate("reportAgeSinceDeath"));
        this.formattingOptions = new FormattingOptions();
        this.scope = new ScopeIndiMiniOptions();
        this.eventSelector = IntStream.range(0, ((String[])EVENTS.toArray(String[]::new)).length).toArray();
        this.eventSelectors = (String[])EVENTS.toArray(String[]::new);
        this.reportAgeCalculated = true;
        this.reportAge = true;
        this.reportDifference = true;
        this.reportDate = true;
        this.dataFormatOptions = new MyDataFormatOptions();
        this.colors = new SimpleColorsOptions();
        this.reportAgeAtChildBirth = false;
        this.reportAgeSinceBirth = false;
        this.reportAgeSinceDeath = false;
    }

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        Indi indi = this.scope.getScope(gedcom, this);
        return indi != null ? this.start(indi) : null;
    }

    public Document start(Indi indi) {
        ArrayList events = new ArrayList();
        events.addAll(indi.getEvents());
        this.indi = indi;
        return this.main(events);
    }

    private Document main(List<? extends Property> events) {
        Delta delta;
        PropertyDate death;
        PointInTime now;
        Delta delta2;
        String ageCalculatedLabel = this.translate("calcAge");
        String ageLabel = Gedcom.getName((String)"AGE");
        String differenceLabel = this.translate("difference");
        String dateLabel = Gedcom.getName((String)"DATE");
        String eventLabel = Gedcom.getName((String)"EVEN");
        String header_row = this.colors.getHeaderRowColor();
        String even_row = this.colors.getEvenRowColor();
        String odd_row = this.colors.getOddRowColor();
        String textColor = this.colors.getTextColor();
        String backColor = this.colors.getBackgroundColor();
        int cellHeight = this.formattingOptions.getTextSize() * 2;
        String cellAttr = "text-align=center, height=" + cellHeight + "px, display-align=center";
        int[] selection = new int[PropUtils.getEventNames().size()];
        for (int i = 0; i < this.eventSelector.length; ++i) {
            if (this.eventSelector[i] == EVENTS.size() - 3) {
                this.reportAgeAtChildBirth = true;
                continue;
            }
            if (this.eventSelector[i] == EVENTS.size() - 2) {
                this.reportAgeSinceBirth = true;
                continue;
            }
            if (this.eventSelector[i] == EVENTS.size() - 1) {
                this.reportAgeSinceDeath = true;
                continue;
            }
            selection[i] = this.eventSelector[i];
        }
        ArrayList<Event> records = new ArrayList<Event>();
        String selectedEventsFilter = PropUtils.getEventTags(selection);
        for (Property property : events) {
            if (!property.isEvent() || !(property instanceof PropertyEventDetails)) continue;
            PropertyEventDetails pEvent = (PropertyEventDetails)property;
            if (!property.getTag().matches(selectedEventsFilter)) continue;
            records.add(new Event(pEvent));
        }
        if (this.reportAgeAtChildBirth) {
            records.addAll(this.getChildrenBirthEvents());
        }
        Collections.sort(records);
        int nbEvents = records.size();
        if (this.reportAgeSinceBirth && (delta2 = this.indi.getAge(now = PointInTime.getNow())) != null) {
            Event asbEvent = new Event(delta2, "reportAgeSinceBirth");
            records.add(asbEvent);
            ++nbEvents;
        }
        if (this.reportAgeSinceDeath && (death = this.indi.getDeathDateOption()) != null && (delta = death.getAnniversary()) != null) {
            Event asdEvent = new Event(delta, "reportAgeSinceDeath");
            records.add(asdEvent);
        }
        String title = this.translate("title", new Object[]{this.indi.getName(), nbEvents});
        this.doc = this.formattingOptions.createDocument(this.translate("name"), textColor, backColor);
        this.doc.startSection(title, "title", 1, false, false, "font-size=" + this.formattingOptions.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        this.doc.startTable("genj:csv=true, width=100%, border-style=none, border-color=black, border=0, space-before=1cm");
        int width = 100;
        int wAge = this.dataFormatOptions.age.reportAgeOnlyYears ? 10 : 20;
        String attrAge = "column-width=" + String.valueOf(wAge) + "%";
        if (this.reportAgeCalculated) {
            this.doc.addTableColumn(attrAge);
            width -= wAge;
        }
        if (this.reportAge) {
            this.doc.addTableColumn(attrAge);
            width -= wAge;
        }
        if (this.reportDifference) {
            this.doc.addTableColumn("column-width=5%");
            width -= 5;
        }
        if (this.reportDate) {
            int w = this.dataFormatOptions.date.reportDatesOnlyYears ? 10 : 20;
            this.doc.addTableColumn("column-width=" + String.valueOf(w) + "%");
            width -= w;
        }
        this.doc.addTableColumn("column-width=" + String.valueOf(width) + "%");
        this.doc.nextTableRow("font-size=" + this.formattingOptions.getTextSize() + ", text-align=center, font-weight=bold, background-color=" + header_row);
        if (this.reportAgeCalculated) {
            this.doc.nextTableCell(cellAttr + ",display-align=center");
            this.doc.addText(ageCalculatedLabel);
        }
        if (this.reportAge) {
            this.doc.nextTableCell(cellAttr + ",display-align=center");
            this.doc.addText(ageLabel);
        }
        if (this.reportDifference) {
            this.doc.nextTableCell(cellAttr + ",display-align=center");
            this.doc.addText(differenceLabel);
        }
        if (this.reportDate) {
            this.doc.nextTableCell(cellAttr + ",display-align=center");
            this.doc.addText(dateLabel);
        }
        this.doc.nextTableCell(cellAttr + ",display-align=center");
        this.doc.addText(eventLabel);
        int row = 0;
        for (Event event : records) {
            String bgColor = row % 2 == 0 ? even_row : odd_row;
            ++row;
            this.doc.nextTableRow("text-align=center, background-color=" + bgColor);
            if (this.reportAgeCalculated) {
                this.doc.nextTableCell(cellAttr);
                this.doc.addText(event.ageCalculated);
            }
            if (this.reportAge) {
                this.doc.nextTableCell(cellAttr);
                this.doc.addText(event.ageRead);
            }
            if (this.reportDifference) {
                this.doc.nextTableCell(cellAttr);
                this.doc.addText(event.difference);
            }
            if (this.reportDate) {
                this.doc.nextTableCell(cellAttr);
                this.doc.addText(event.date);
            }
            this.doc.nextTableCell(cellAttr + ", text-align=left");
            this.doc.addLink(event.name, event.event.getLinkAnchor());
        }
        this.doc.endTable();
        return this.doc;
    }

    private List<Event> getChildrenBirthEvents() {
        ArrayList<Event> ret = new ArrayList<Event>();
        Indi[] children = this.indi.getChildren();
        if (children.length > 0) {
            for (Indi child : children) {
                PropertyDate cbirth = child.getBirthDateOption();
                if (cbirth == null) continue;
                Event childEvent = new Event(child, cbirth);
                ret.add(childEvent);
            }
        }
        return ret;
    }

    public class MyDataFormatOptions {
        public FormatDateOptions date = new FormatDateOptions();
        public FormatAgeOptions age = new FormatAgeOptions();
    }

    public class Event
    implements Comparable<Event> {
        private PropertyEventDetails event;
        private String ageRead;
        private String ageCalculated;
        private final Delta ageReadD;
        private final Delta ageCalculatedD;
        private String difference;
        private String date;
        private String name;

        private Event(PropertyEventDetails event) {
            this.event = event;
            this.ageRead = ReportAges.this.dataFormatOptions.age.getAge((Property)event);
            this.ageReadD = ReportAges.this.dataFormatOptions.age.getDoubleAge((Property)event);
            this.ageCalculated = ReportAges.this.dataFormatOptions.age.getCalculatedAge(ReportAges.this.indi, event.getDate());
            this.ageCalculatedD = ReportAges.this.dataFormatOptions.age.getCalculatedDoubleAge(ReportAges.this.indi, event.getDate());
            int diff = this.ageReadD != null && this.ageCalculatedD != null ? this.ageReadD.compareTo(this.ageCalculatedD) : 0;
            this.difference = diff != 0 ? String.valueOf(diff) : "";
            this.date = ReportAges.this.dataFormatOptions.date.getDate((Property)event.getDate());
            Object tmp = "";
            Property pType = event.getProperty("TYPE");
            if (pType != null) {
                tmp = pType.getDisplayValue();
            }
            String desc = event.getDisplayValue();
            if (!((String)tmp).isBlank() && !desc.isBlank()) {
                tmp = (String)tmp + " - " + desc;
            } else if (((String)tmp).isBlank()) {
                tmp = desc;
            }
            this.name = Gedcom.getName((String)event.getTag()) + (String)(!((String)tmp).isBlank() ? ": " + (String)tmp : "");
        }

        private Event(Indi child, PropertyDate bdate) {
            this.event = (PropertyEventDetails)bdate.getParent();
            this.ageRead = "";
            this.ageCalculated = ReportAges.this.dataFormatOptions.age.getCalculatedAge(ReportAges.this.indi, this.event.getDate());
            this.ageReadD = DELTA0;
            this.ageCalculatedD = ReportAges.this.dataFormatOptions.age.getCalculatedDoubleAge(ReportAges.this.indi, this.event.getDate());
            this.difference = "";
            this.date = ReportAges.this.dataFormatOptions.date.getDate((Property)bdate);
            this.name = ReportAges.this.translate("childBirth", new Object[]{child.getName()});
        }

        private Event(Delta age, String specialEvent) {
            this.ageRead = "";
            this.ageCalculated = ReportAges.this.dataFormatOptions.age.reportAgeOnlyYears ? String.valueOf(age.getYears()) : age.toReportString();
            this.ageReadD = DELTA0;
            this.ageCalculatedD = DELTA0;
            this.difference = "";
            this.date = ReportAges.this.dataFormatOptions.date.reportDatesOnlyYears ? String.valueOf(PointInTime.getNow().getYear()) : PointInTime.getNow().toReportString();
            if (specialEvent.equals("reportAgeSinceBirth")) {
                this.event = (PropertyEventDetails)ReportAges.this.indi.getBirthDateOption().getParent();
                this.name = ReportAges.this.translate("sinceBirth");
            } else if (specialEvent.equals("reportAgeSinceDeath")) {
                this.event = (PropertyEventDetails)ReportAges.this.indi.getDeathDateOption().getParent();
                this.name = ReportAges.this.translate("sinceDeath");
            }
        }

        @Override
        public int compareTo(Event o) {
            int c = this.ageCalculatedD != null && o.ageCalculatedD != null ? this.ageCalculatedD.compareTo(o.ageCalculatedD) : 0;
            return c != 0 ? c : this.date.compareTo(o.date);
        }
    }
}

