/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.graphstream.graph.Graph;

public class GraphFactory {
    private static final Logger logger = Logger.getLogger(GraphFactory.class.getSimpleName());

    public Graph newInstance(String id, String graphClass) {
        try {
            String completeGraphClass = graphClass.split("[.]").length < 2 ? "org.graphstream.graph.implementations." + graphClass : graphClass;
            Class<?> clazz = Class.forName(completeGraphClass);
            Graph res = (Graph)clazz.getConstructor(String.class).newInstance(id);
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error executing GraphFactory#newInstance.", e);
            return null;
        }
    }
}

