/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.BasicTreeBuilder;
import ancestris.report.svgtree.ColorManager;
import ancestris.report.svgtree.FlipTreeElements;
import ancestris.report.svgtree.GraphicsOutputFactory;
import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.LayoutFactory;
import ancestris.report.svgtree.RotateRenderer;
import ancestris.report.svgtree.build.TreeBuilder;
import ancestris.report.svgtree.filter.DetermineBoxSizes;
import ancestris.report.svgtree.filter.TreeFilter;
import ancestris.report.svgtree.graphics.GraphicsOutput;
import ancestris.report.svgtree.graphics.GraphicsRenderer;
import ancestris.report.svgtree.output.RendererFactory;
import ancestris.report.svgtree.output.TreeElements;
import ancestris.report.svgtree.output.TreeElementsFactory;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.report.Report;
import genj.report.Translator;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

public class ReportGraphicalTree
extends Report {
    private static final Logger LOG = Logger.getLogger("ancestris.report.svgtree", null);
    private final Translator translator = new Translator((Report)this);
    public RendererFactory renderers = new RendererFactory(this.translator);
    public GraphicsOutputFactory outputs = new GraphicsOutputFactory(this.translator);
    public ScopeIndiMiniOptions scope = new ScopeIndiMiniOptions();
    public LayoutFactory layouts = new LayoutFactory(this.translator);
    public TreeBuilder builder = new BasicTreeBuilder(this.translator);
    public TreeElementsFactory treeElements = new TreeElementsFactory(this.translator);
    public ColorManager colorManager = new ColorManager();

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi) {
            return super.getName();
        }
        return null;
    }

    public Object start(Gedcom gedcom) {
        Indi indi = this.scope.getScope((Object)gedcom, (Report)this);
        return indi != null ? this.start(indi) : null;
    }

    public Object start(Indi indi) {
        ((FlipTreeElements)this.treeElements.flipElements).setFlip(this.layouts.flip);
        ((BasicTreeBuilder)this.builder).setHusbandFirst(this.layouts.husband_first);
        ((RotateRenderer)this.renderers.rotateRenderer).setRotation(this.layouts.rotation);
        this.treeElements.setColors(this.colorManager);
        indi.getGedcom().getPlaceDisplayFormat();
        LOG.info("WIP: Enter report");
        IndiBox.setTotalBoxes(0);
        LOG.info("WIP: Enter build report");
        IndiBox indibox = this.builder.build(indi);
        LOG.info("WIP: Exit build report");
        int totalBoxes = IndiBox.getNetTotalBoxes();
        LOG.info("WIP: Resulting in " + totalBoxes + " indi boxes net of " + IndiBox.getTotalBoxes());
        if (totalBoxes > 1000 && DialogManager.OK_OPTION != DialogManager.create((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_SizeWarning"), (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_SizeWarning", (Object)totalBoxes)).setMessageType(2).setOptionType(2).setDialogId("report.ReportGraphicalTree").show()) {
            return null;
        }
        LOG.info("WIP: Enter create layout");
        TreeElements elements = this.treeElements.createElements();
        new DetermineBoxSizes(elements).filter(indibox);
        LOG.info("WIP: Exit create layout");
        TreeFilter arranger = this.layouts.createLayout();
        arranger.filter(indibox);
        LOG.info("WIP: Enter render");
        GraphicsRenderer renderer = this.renderers.createRenderer(indibox, elements, ((BasicTreeBuilder)this.builder).getLegendData());
        LOG.info("WIP: Exit render");
        GraphicsOutput output = this.outputs.createOutput(this);
        if (output == null) {
            return null;
        }
        try {
            output.output(renderer);
        }
        catch (OutOfMemoryError e) {
            this.println("ERROR! The report ran out of memory.\n");
            this.println("Increase the memory limit for Ancestris or build a smaller tree.");
        }
        catch (IOException e) {
            this.println("Error generating output: " + e.getMessage());
        }
        File file = (File)output.result(this);
        LOG.info("WIP: Saved into " + file.getAbsolutePath());
        if (this.outputs.output_type != this.outputs.preview_type) {
            this.println(this.translate("output.success.svgFile", new Object[]{file.getAbsolutePath()}));
        }
        return file;
    }
}

