/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchdupes;

import ancestris.util.swing.DialogManager;
import genj.gedcom.AbstractNote;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NonDuplicates {
    public static String REFN_NAME = "Non_Duplicates";

    protected static boolean store(Entity ent1, Entity ent2) {
        String message;
        String title;
        String reason;
        String id2;
        if (ent1 == null || ent2 == null) {
            return false;
        }
        Gedcom gedcom = ent1.getGedcom();
        if (gedcom == null) {
            return false;
        }
        if (ent1.getId().equals(ent2.getId())) {
            return false;
        }
        TreeMap<String, String> list = NonDuplicates.getList(gedcom);
        if (list == null) {
            return false;
        }
        String id1 = ent1.getId();
        String key = NonDuplicates.getKey(id1, id2 = ent2.getId());
        String existingReason = list.get(key);
        if (existingReason == null) {
            existingReason = NbBundle.getMessage(NonDuplicates.class, (String)"SearchDuplicatesPlugin.nonDupReasonPrompt");
        }
        if ((reason = DialogManager.create((String)(title = NbBundle.getMessage(NonDuplicates.class, (String)"SearchDuplicatesPlugin.nonDupReasonTitle")), (String)(message = NbBundle.getMessage(NonDuplicates.class, (String)"SearchDuplicatesPlugin.nonDupReasonMessage")), (String)existingReason).show()) == null) {
            return false;
        }
        list.put(key, reason);
        return NonDuplicates.saveList(list, gedcom);
    }

    public static String getKey(String id1, String id2) {
        return id1.compareTo(id2) < 0 ? id1 + "+" + id2 : id2 + "+" + id1;
    }

    public static Set<String> getNonDupKeys(Gedcom gedcom) {
        return NonDuplicates.getList(gedcom).keySet();
    }

    protected static TreeMap<String, String> getList(Gedcom gedcom) {
        AbstractNote refNote = NonDuplicates.getNote(gedcom);
        return refNote != null ? NonDuplicates.getListFromText(refNote.getValue()) : null;
    }

    protected static boolean saveList(TreeMap<String, String> list, Gedcom gedcom) {
        AbstractNote refNote = NonDuplicates.getNote(gedcom);
        if (refNote == null) {
            return false;
        }
        refNote.setValue(NonDuplicates.getTextFromList(list));
        return true;
    }

    protected static TreeMap<String, String> getListFromText(String multilineString) {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        try (Scanner scanner = new Scanner(multilineString);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                int i = line.indexOf("=");
                if (i == -1) continue;
                String key = line.substring(0, i);
                String reason = line.substring(i + 1);
                ret.put(key, reason);
            }
        }
        return ret;
    }

    protected static String getTextFromList(TreeMap<String, String> list) {
        StringBuilder ret = new StringBuilder();
        for (String key : list.keySet()) {
            ret.append(key);
            ret.append("=");
            ret.append(list.get(key));
            ret.append(System.getProperty("line.separator"));
        }
        return ret.toString();
    }

    protected static AbstractNote getNote(Gedcom gedcom) {
        AbstractNote refNote = null;
        boolean isG7 = gedcom.isGrammar7();
        String tag = isG7 ? "SNOTE" : "NOTE";
        for (Entity entity : gedcom.getEntities(tag)) {
            Property pRefn = entity.getProperty("REFN");
            if (pRefn == null || !pRefn.getValue().equals(REFN_NAME)) continue;
            return (AbstractNote)entity;
        }
        if (refNote == null) {
            try {
                refNote = (AbstractNote)gedcom.createEntity(tag);
                refNote.addProperty("REFN", REFN_NAME);
                refNote.addProperty("_VALID", "Y");
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
        return refNote;
    }
}

