/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import ancestris.core.TextOptions;
import ancestris.gedcom.GedcomDirectory;
import ancestris.util.swing.DialogManager;
import genj.gedcom.AbstractNote;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyCreate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.util.Origin;
import genj.util.ReferenceSet;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.SafeProxy;
import genj.util.swing.ImageIcon;
import genj.view.ViewContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.WordUtils;

public class Gedcom
implements Comparable<Gedcom> {
    static final Logger LOG = Logger.getLogger("ancestris.gedcom");
    static final Resources resources = Resources.get(Gedcom.class);
    private static final ImageIcon image = new ImageIcon(Gedcom.class, "images/Gedcom");
    private Submitter submitter;
    private Grammar grammar = Grammar.V55;
    private boolean isGrammar7 = false;
    private String destination = "ANY";
    private Origin origin;
    private List<ViewContext> warnings;
    private PropertyChange lastChange = null;
    private int maxIDLength = 0;
    private final LinkedList<Entity> allEntities = new LinkedList();
    private final Map<String, Map<String, Entity>> tag2id2entity = new HashMap<String, Map<String, Entity>>();
    private boolean isDirty = false;
    private final List<List<Undo>> undoHistory = new ArrayList<List<Undo>>();
    private final List<List<Undo>> redoHistory = new ArrayList<List<Undo>>();
    private boolean undoRedoInProgress = false;
    private final Object writeSemaphore = new Object();
    private Lock lock = null;
    private final List<GedcomListener> listeners = new CopyOnWriteArrayList<GedcomListener>();
    private final Map<String, ReferenceSet<String, Property>> tags2refsets = new HashMap<String, ReferenceSet<String, Property>>();
    private final Map<String, Integer> propertyTag2valueCount = new HashMap<String, Integer>();
    private GedcomConstants.Encodings encoding;
    private int nbLines;
    private String language = null;
    private Locale cachedLocale = null;
    private Collator cachedCollator = null;
    private String password = null;
    private String noName = null;
    private Registry registry = null;

    public Gedcom() {
        this(null);
    }

    public Gedcom(Origin origin) {
        this.origin = origin;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public int getLines() {
        return this.nbLines;
    }

    public void setLines(int nbLines) {
        this.nbLines = nbLines;
    }

    public List<ViewContext> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<ViewContext> warnings) {
        this.warnings = warnings;
    }

    public void setGrammar(Grammar grammar) {
        final Grammar old = this.grammar;
        this.grammar = grammar;
        this.isGrammar7 = Grammar.V70.equals(grammar);
        if (this.lock != null) {
            this.lock.addChange(new Undo(){

                @Override
                void undo() {
                    Gedcom.this.setGrammar(old);
                }
            });
        }
        for (GedcomListener listener : this.listeners) {
            if (!(listener instanceof GedcomMetaListener)) continue;
            GedcomMetaListener gedcomMetaListener = (GedcomMetaListener)listener;
            gedcomMetaListener.gedcomHeaderChanged(this);
        }
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public boolean isGrammar7() {
        return this.isGrammar7;
    }

    public String[] getEntitiesType() {
        return this.isGrammar7 ? GedcomConstants.ENTITIES_7 : GedcomConstants.ENTITIES_5;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public String getDestination() {
        return this.destination;
    }

    public Submitter getSubmitter() {
        if (this.submitter == null) {
            return (Submitter)this.getFirstEntity("SUBM");
        }
        return this.submitter;
    }

    public void setSubmitter(Submitter set) {
        if (set != null && !this.getEntityMap("SUBM").containsValue(set)) {
            throw new IllegalArgumentException("Submitter is not part of this gedcom");
        }
        final Submitter old = this.submitter;
        this.submitter = set;
        if (this.lock != null) {
            this.lock.addChange(new Undo(){

                @Override
                void undo() {
                    Gedcom.this.setSubmitter(old);
                }
            });
        }
        for (GedcomListener listener : this.listeners) {
            if (!(listener instanceof GedcomMetaListener)) continue;
            GedcomMetaListener gedcomMetaListener = (GedcomMetaListener)listener;
            gedcomMetaListener.gedcomHeaderChanged(this);
        }
    }

    public String toString() {
        return this.getName();
    }

    public void addGedcomListener(GedcomListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener can't be null");
        }
        if (!this.listeners.add(SafeProxy.harden(listener))) {
            throw new IllegalArgumentException("can't add gedcom listener " + listener + "twice");
        }
        LOG.log(Level.FINER, "addGedcomListener() from {0} (now {1})", new Object[]{new Throwable().getStackTrace()[1], this.listeners.size()});
    }

    public void removeGedcomListener(GedcomListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(SafeProxy.harden(listener));
            LOG.log(Level.FINER, "removeGedcomListener() from {0} (now {1})", new Object[]{new Throwable().getStackTrace()[1], this.listeners.size()});
        }
    }

    public boolean isUndoRedoInProgress() {
        return this.undoRedoInProgress;
    }

    public void setUndoRedoInProgress(boolean set) {
        this.undoRedoInProgress = set;
    }

    protected void propagateXRefLinked(final PropertyXRef property1, PropertyXRef property2) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Property {0} and {1} linked", new Object[]{property1.getTag(), property2.getTag()});
        }
        if (this.lock != null) {
            this.lock.addChange(new Undo(){

                @Override
                void undo() {
                    property1.unlink();
                }
            });
        }
        for (GedcomListener listener : this.listeners) {
            listener.gedcomPropertyChanged(this, property1);
            listener.gedcomPropertyChanged(this, property2);
        }
    }

    protected void propagateXRefUnlinked(final PropertyXRef property1, final PropertyXRef property2) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Property {0} and {1} unlinked", new Object[]{property1.getTag(), property2.getTag()});
        }
        if (this.lock != null) {
            this.lock.addChange(new Undo(){

                @Override
                void undo() {
                    property1.link(property2);
                }
            });
        }
        for (GedcomListener listener : this.listeners) {
            listener.gedcomPropertyChanged(this, property1);
            listener.gedcomPropertyChanged(this, property2);
        }
    }

    protected void propagateEntityAdded(final Entity entity) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Entity {0} added", entity.getId());
        }
        if (this.lock != null) {
            this.lock.addChange(new Undo(){

                @Override
                void undo() {
                    Gedcom.this.deleteEntity(entity);
                }
            });
        }
        for (GedcomListener listener : this.listeners) {
            listener.gedcomEntityAdded(this, entity);
        }
    }

    protected void propagateEntityDeleted(final Entity entity) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Entity {0} deleted", entity.getId());
        }
        if (this.lock != null) {
            this.lock.addChange(new Undo(){

                @Override
                void undo() throws GedcomException {
                    Gedcom.this.addEntity(entity);
                }
            });
        }
        for (GedcomListener listener : this.listeners) {
            listener.gedcomEntityDeleted(this, entity);
        }
    }

    protected void propagatePropertyAdded(Entity entity, final Property container, final int pos, Property added) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Property {0} added to {1} at position {2} (entity {3})", new Object[]{added.getTag(), container.getTag(), pos, entity.getId()});
        }
        if (!(added instanceof PropertyXRef)) {
            Integer count = this.propertyTag2valueCount.get(added.getTag());
            this.propertyTag2valueCount.put(added.getTag(), count == null ? 1 : count + 1);
        }
        if (this.lock != null) {
            this.lock.addChange(new Undo(){

                @Override
                void undo() {
                    container.delProperty(pos);
                }
            });
        }
        for (GedcomListener listener : this.listeners) {
            listener.gedcomPropertyAdded(this, container, pos, added);
        }
    }

    protected void propagatePropertyDeleted(Entity entity, final Property container, final int pos, final Property deleted) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Property {0} deleted from {1} at position {2} (entity {3})", new Object[]{deleted.getTag(), container.getTag(), pos, entity.getId()});
        }
        if (!(deleted instanceof PropertyXRef)) {
            this.propertyTag2valueCount.put(deleted.getTag(), this.propertyTag2valueCount.get(deleted.getTag()) - 1);
        }
        if (this.lock != null) {
            this.lock.addChange(new Undo(){

                @Override
                void undo() {
                    container.addProperty(deleted, pos);
                }
            });
        }
        for (GedcomListener listener : this.listeners) {
            listener.gedcomPropertyDeleted(this, container, pos, deleted);
        }
    }

    protected void propagatePropertyChanged(Entity entity, final Property property, final String oldValue) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Property {0} changed in (entity {1})", new Object[]{property.getTag(), entity.getId()});
        }
        if (this.lock != null) {
            this.lock.addChange(new Undo(){

                @Override
                void undo() {
                    property.setValue(oldValue);
                }
            });
        }
        for (GedcomListener listener : this.listeners) {
            listener.gedcomPropertyChanged(this, property);
        }
    }

    protected void propagatePropertyMoved(final Property property, final Property moved, final int from, final int to) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Property {0} moved from {1} to {2} (entity {3})", new Object[]{property.getTag(), from, to, property.getEntity().getId()});
        }
        if (this.lock != null) {
            this.lock.addChange(new Undo(){

                @Override
                void undo() {
                    property.moveProperty(moved, from < to ? from : from + 1);
                }
            });
        }
        for (GedcomListener listener : this.listeners) {
            listener.gedcomPropertyDeleted(this, property, from, moved);
            listener.gedcomPropertyAdded(this, property, to, moved);
        }
    }

    protected void propagateWriteLockAqcuired() {
        for (GedcomListener listener : this.listeners) {
            if (!(listener instanceof GedcomMetaListener)) continue;
            GedcomMetaListener gedcomMetaListener = (GedcomMetaListener)listener;
            gedcomMetaListener.gedcomWriteLockAcquired(this);
        }
    }

    protected void propagateBeforeUnitOfWork() {
        for (GedcomListener listener : this.listeners) {
            if (!(listener instanceof GedcomMetaListener)) continue;
            GedcomMetaListener gedcomMetaListener = (GedcomMetaListener)listener;
            gedcomMetaListener.gedcomBeforeUnitOfWork(this);
        }
    }

    protected void propagateAfterUnitOfWork() {
        for (GedcomListener listener : this.listeners) {
            if (!(listener instanceof GedcomMetaListener)) continue;
            GedcomMetaListener gedcomMetaListener = (GedcomMetaListener)listener;
            gedcomMetaListener.gedcomAfterUnitOfWork(this);
        }
    }

    protected void propagateWriteLockReleased() {
        for (GedcomListener listener : this.listeners) {
            if (!(listener instanceof GedcomMetaListener)) continue;
            GedcomMetaListener gedcomMetaListener = (GedcomMetaListener)listener;
            gedcomMetaListener.gedcomWriteLockReleased(this);
        }
    }

    protected void propagateEntityIDChanged(final Entity entity, final String old) throws GedcomException {
        Map<String, Entity> id2entity = this.getEntityMap(entity.getTag());
        if (!id2entity.containsValue(entity)) {
            throw new GedcomException("Can't change ID of entity not part of this Gedcom instance");
        }
        String id = entity.getId();
        if (id == null || id.length() == 0) {
            throw new GedcomException("Need valid ID length");
        }
        if (this.getEntity(id) != null) {
            throw new GedcomException("Duplicate ID is not allowed");
        }
        id2entity.remove(old);
        id2entity.put(entity.getId(), entity);
        this.maxIDLength = Math.max(id.length(), this.maxIDLength);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Entity''s ID changed from  {0} to {1}", new Object[]{old, entity.getId()});
        }
        if (this.lock != null) {
            this.lock.addChange(new Undo(){

                @Override
                void undo() throws GedcomException {
                    entity.setId(old);
                }
            });
        }
        for (GedcomListener listener : this.listeners) {
            listener.gedcomPropertyChanged(this, entity);
        }
    }

    private void addEntity(Entity entity) throws GedcomException {
        String id = entity.getId();
        if (id.length() > 0) {
            Map<String, Entity> id2entity = this.getEntityMap(entity.getTag());
            if (id2entity.containsKey(id)) {
                throw new GedcomException(resources.getString("error.entity.dupe", id));
            }
            id2entity.put(id, entity);
        }
        this.allEntities.add(entity);
        entity.addNotify(this);
    }

    public PropertyChange getLastChange() {
        return this.lastChange;
    }

    protected void updateLastChange(PropertyChange change) {
        if (this.lastChange == null || this.lastChange.compareTo(change) < 0) {
            this.lastChange = change;
        }
    }

    public Entity createEntity(String tag) throws GedcomException {
        return this.createEntity(tag, null);
    }

    public Entity createEntity(String tag, String id) throws GedcomException {
        Entity result;
        if (id == null || id.isEmpty() && !"HEAD".equals(tag) && !"TRTL".equals(tag)) {
            id = this.getNextAvailableID(tag);
        }
        this.maxIDLength = Math.max(id.length(), this.maxIDLength);
        Class<? extends Entity> clazz = GedcomConstants.E2TYPE.get(tag);
        if (clazz != null) {
            if (id.length() == 0) {
                throw new GedcomException(resources.getString("error.entity.noid", tag));
            }
        } else {
            clazz = Entity.class;
        }
        try {
            result = clazz.getDeclaredConstructor(String.class, String.class).newInstance(tag, id);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException t) {
            throw new RuntimeException("Can't instantiate " + clazz, t);
        }
        result.setNew();
        this.addEntity(result);
        if (this.isGrammar7() && GedcomDirectory.getDefault().isGedcomRegistered(this)) {
            Property crea = result.getProperty("CREA");
            if (crea == null) {
                crea = result.addProperty("CREA", "");
            } else {
                ((PropertyCreate)crea).setTime();
            }
        }
        return result;
    }

    public void deleteEntity(Entity which) {
        if (which instanceof Indi && this.getEntities("INDI").size() == 1) {
            DialogManager.createError(resources.getString("error.entity.cannotdelete.title"), resources.getString("error.entity.cannotdelete.msg")).setDialogId("error.entity.cannotdelete").show();
            return;
        }
        String id = which.getId();
        if (id.length() > 0) {
            Map<String, Entity> id2entity = this.getEntityMap(which.getTag());
            if (!id2entity.containsKey(id)) {
                throw new IllegalArgumentException("Unknown entity with id " + which.getId());
            }
            id2entity.remove(id);
        }
        which.beforeDelNotify();
        this.allEntities.remove(which);
        if (this.submitter == which) {
            this.submitter = null;
        }
    }

    private Map<String, Entity> getEntityMap(String tag) {
        Map<String, Entity> id2entity = this.tag2id2entity.get(tag);
        if (id2entity == null) {
            id2entity = new HashMap<String, Entity>();
            this.tag2id2entity.put(tag, id2entity);
        }
        return id2entity;
    }

    public Property[] getProperties(TagPath path) {
        ArrayList<Property> result = new ArrayList<Property>(100);
        for (Entity entity : this.getEntities(path.getFirst())) {
            Property[] props;
            for (Property prop : props = entity.getProperties(path)) {
                result.add(prop);
            }
        }
        return Property.toArray(result);
    }

    public <T extends Property> List<T> getPropertiesByClass(Class<T> clazz) {
        ArrayList<T> props = new ArrayList<T>();
        Collection<Entity> entities = Collections.unmodifiableCollection(this.allEntities.stream().filter(e -> !"HEAD".equals(e.getTag())).collect(Collectors.toList()));
        for (Entity ent : entities) {
            props.addAll(ent.getProperties(clazz));
        }
        return props;
    }

    public int getPropertyCount(String tag) {
        Integer result = this.propertyTag2valueCount.get(tag);
        return result == null ? 0 : result;
    }

    public Map<String, Integer> getPropertiesCount() {
        return this.propertyTag2valueCount;
    }

    public List<Entity> getEntities() {
        return Collections.unmodifiableList(this.allEntities);
    }

    public Collection<? extends Entity> getEntities(String tag) {
        Map<String, Entity> map = this.getEntityMap(tag);
        if (map.isEmpty()) {
            return Collections.unmodifiableCollection(this.allEntities.stream().filter(e -> tag.equals(e.getTag())).collect(Collectors.toList()));
        }
        return Collections.unmodifiableCollection(this.getEntityMap(tag).values());
    }

    public Collection<Fam> getFamilies() {
        return this.getEntities("FAM");
    }

    public Collection<Indi> getIndis() {
        return this.getEntities("INDI");
    }

    public Collection<AbstractNote> getNotes() {
        if (this.isGrammar7) {
            return this.getEntities("SNOTE");
        }
        return this.getEntities("NOTE");
    }

    public Collection<Source> getSources() {
        return this.getEntities("SOUR");
    }

    public Collection<Media> getMedias() {
        return this.getEntities("OBJE");
    }

    public Collection<Repository> getRepositories() {
        return this.getEntities("REPO");
    }

    public Entity[] getEntities(String tag, String sortPath) {
        return this.getEntities(tag, sortPath != null && sortPath.length() > 0 ? new PropertyComparator(sortPath) : null);
    }

    public Entity[] getEntities(String tag, Comparator<Property> comparator) {
        Collection<Entity> ents = this.getEntityMap(tag).values();
        Object[] result = (Entity[])ents.toArray(Entity[]::new);
        if (comparator != null) {
            Arrays.sort(result, comparator);
        } else {
            Arrays.sort(result);
        }
        return result;
    }

    public Entity getEntity(String id) {
        for (Map<String, Entity> ents : this.tag2id2entity.values()) {
            Entity result = ents.get(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Entity getEntity(String tag, String id) {
        return this.getEntityMap(tag).get(id);
    }

    public Indi getDeCujusIndi() {
        if (this.isWriteLocked()) {
            return null;
        }
        Collection<? extends Entity> entities = this.getEntities("INDI");
        Property[] props = null;
        String sosaStr = "";
        for (Indi indi : entities) {
            props = indi.getProperties("_SOSA");
            if (props != null) {
                for (Property prop : props) {
                    sosaStr = prop.getDisplayValue();
                    if (!"1".equals(sosaStr) && !"1 G1".equals(sosaStr)) continue;
                    return indi;
                }
            }
            if ((props = indi.getProperties("_SOSADABOVILLE")) == null) continue;
            for (Property prop : props) {
                sosaStr = prop.getDisplayValue();
                if (!"1".equals(sosaStr) && !"1 G1".equals(sosaStr)) continue;
                return indi;
            }
        }
        return null;
    }

    public static Class<? extends Entity> getEntityType(String tag) {
        return GedcomConstants.E2TYPE.get(tag);
    }

    public Entity getFirstEntity(String tag) {
        for (Entity e : this.allEntities) {
            if (!e.getTag().equals(tag)) continue;
            return e;
        }
        return null;
    }

    public String getNextAvailableID(String entity) {
        Map<String, Entity> id2entity = this.getEntityMap(entity);
        int id = GedcomOptions.getInstance().isFillGapsInIDs() ? 1 : (id2entity.isEmpty() ? 1 : id2entity.size());
        StringBuilder buf = new StringBuilder(this.maxIDLength);
        block0: while (true) {
            buf.setLength(0);
            buf.append(Gedcom.getEntityPrefix(entity));
            buf.append(id);
            while (!id2entity.containsKey(buf.toString())) {
                if (buf.length() >= this.maxIDLength) break block0;
                buf.insert(1, '0');
            }
            ++id;
        }
        buf.setLength(0);
        buf.append(id);
        while (buf.length() < this.idLength(entity)) {
            buf.insert(0, '0');
        }
        return Gedcom.getEntityPrefix(entity) + buf;
    }

    private int idLength(String tag) {
        int length = GedcomOptions.getInstance().getEntityIdLength();
        Entity first = this.getFirstEntity(tag);
        if (first != null && first.getId().matches("[a-zA-Z][0-9]*")) {
            length = first.getId().length() - 1;
        }
        return length;
    }

    public boolean hasChanged() {
        return this.isDirty || !this.undoHistory.isEmpty();
    }

    public void setUnchanged() {
        if (!this.hasChanged()) {
            return;
        }
        this.undoHistory.clear();
        this.isDirty = false;
        if (this.lock != null) {
            for (GedcomListener listener : this.listeners) {
                if (!(listener instanceof GedcomMetaListener)) continue;
                GedcomMetaListener gedcomMetaListener = (GedcomMetaListener)listener;
                gedcomMetaListener.gedcomHeaderChanged(this);
            }
        }
    }

    public boolean isWriteLocked() {
        return this.lock != null;
    }

    public void doMuteUnitOfWork(UnitOfWork uow) {
        try {
            this.doUnitOfWork(uow);
        }
        catch (GedcomException e) {
            LOG.log(Level.WARNING, "Unexpected gedcom exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnitOfWork(UnitOfWork uow) throws GedcomException {
        PropertyChange.Monitor updater;
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (this.lock != null) {
                throw new GedcomException("Cannot obtain write lock");
            }
            this.lock = new Lock();
            updater = new PropertyChange.Monitor();
            this.addGedcomListener(updater);
            this.redoHistory.clear();
        }
        this.propagateWriteLockAqcuired();
        Throwable rethrow = null;
        try {
            uow.perform(this);
        }
        catch (Throwable t) {
            rethrow = t;
        }
        Object t = this.writeSemaphore;
        synchronized (t) {
            if (!this.lock.undos.isEmpty()) {
                this.undoHistory.add(this.lock.undos);
                while (this.undoHistory.size() > GedcomOptions.getInstance().getNumberOfUndos()) {
                    this.undoHistory.remove(0);
                    this.isDirty = true;
                }
            }
            this.propagateWriteLockReleased();
            this.lock = null;
            this.removeGedcomListener(updater);
        }
        LOG.log(Level.FINE, "End of UOW, property counts {0}", this.propertyTag2valueCount);
        if (rethrow != null) {
            if (rethrow instanceof GedcomException) {
                GedcomException gedcomException = (GedcomException)rethrow;
                throw gedcomException;
            }
            throw new RuntimeException(rethrow);
        }
    }

    public boolean canUndo() {
        return !this.undoHistory.isEmpty();
    }

    public int getUndoNb() {
        return this.undoHistory.size();
    }

    public void undoUnitOfWork() {
        this.undoUnitOfWork(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoUnitOfWork(boolean keepRedo) {
        if (this.undoHistory.isEmpty()) {
            throw new IllegalArgumentException("undo n/a");
        }
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (this.lock != null) {
                throw new IllegalStateException("Cannot obtain write lock");
            }
            this.lock = new Lock();
        }
        this.propagateWriteLockAqcuired();
        this.setUndoRedoInProgress(true);
        List<Undo> todo = this.undoHistory.remove(this.undoHistory.size() - 1);
        for (int i = todo.size() - 1; i >= 0; --i) {
            Undo undo = todo.remove(i);
            try {
                undo.undo();
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Unexpected throwable during undo()", t);
            }
        }
        this.setUndoRedoInProgress(false);
        Object object2 = this.writeSemaphore;
        synchronized (object2) {
            if (keepRedo) {
                this.redoHistory.add(this.lock.undos);
            }
            this.propagateWriteLockReleased();
            this.lock = null;
        }
    }

    public boolean canRedo() {
        return !this.redoHistory.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoUnitOfWork() {
        if (this.redoHistory.isEmpty()) {
            throw new IllegalArgumentException("redo n/a");
        }
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (this.lock != null) {
                throw new IllegalStateException("Cannot obtain write lock");
            }
            this.lock = new Lock();
        }
        this.propagateWriteLockAqcuired();
        this.setUndoRedoInProgress(true);
        List<Undo> todo = this.redoHistory.remove(this.redoHistory.size() - 1);
        for (int i = todo.size() - 1; i >= 0; --i) {
            Undo undo = todo.remove(i);
            try {
                undo.undo();
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Unexpected throwable during undo()", t);
            }
        }
        this.setUndoRedoInProgress(false);
        Object object2 = this.writeSemaphore;
        synchronized (object2) {
            this.undoHistory.add(this.lock.undos);
            this.propagateWriteLockReleased();
            this.lock = null;
        }
    }

    public ReferenceSet<String, Property> getReferenceSet(String tag) {
        ReferenceSet<String, Property> result;
        ReferenceSet defaultSet = new ReferenceSet();
        String defaults = resources.getString(tag + ".vals", false);
        if (defaults != null) {
            StringTokenizer tokens = new StringTokenizer(defaults, ",");
            while (tokens.hasMoreElements()) {
                defaultSet.add(tokens.nextToken().trim(), null);
            }
        }
        if ((result = this.tags2refsets.get(tag)) == null) {
            result = defaultSet;
            this.tags2refsets.put(tag, result);
        } else {
            for (String item : defaultSet.getKeys()) {
                result.add(item, null);
            }
        }
        return result;
    }

    public String getName() {
        return this.origin == null ? this.noName : this.origin.getName();
    }

    public void setName(String noName) {
        this.noName = noName;
    }

    public String getDisplayName() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return "";
        }
        name = name.replace("_", " ");
        char[] delimiters = new char[]{' ', '-'};
        return WordUtils.capitalize((String)name.substring(0, name.lastIndexOf(".") == -1 ? name.length() : name.lastIndexOf(".")), (char[])delimiters);
    }

    public String getFilePath() {
        if (this.origin == null) {
            return this.noName;
        }
        File file = this.origin.getFile();
        if (file != null) {
            try {
                return this.origin.getFile().getCanonicalPath();
            }
            catch (IOException e) {
                LOG.log(Level.FINE, "Unexpected IOException during name retrieval", e);
            }
        }
        return this.noName;
    }

    public static String getName(String tag) {
        return Gedcom.getName(tag, false);
    }

    public static String getName(String tag, boolean plural) {
        String name;
        if (plural && (name = resources.getString(tag + ".s.name", false)) != null) {
            return name;
        }
        name = resources.getString(tag + ".name", false);
        return name != null ? name : tag;
    }

    public static String getReportName(String tag) {
        String name = Resources.get(Gedcom.class, TextOptions.getInstance().getOutputLocale()).getString(tag + ".name", false);
        return name != null ? name : tag;
    }

    public static String getInfo(String tag) {
        return resources.getString(tag + ".info", false);
    }

    public static String getEntityPrefix(String tag) {
        String result = GedcomConstants.E2PREFIX.get(tag);
        if (result == null) {
            result = "X";
        }
        return result;
    }

    public static ImageIcon getImage() {
        return image;
    }

    public static Resources getResources() {
        return resources;
    }

    public Registry getRegistry() {
        if (this.registry == null) {
            this.registry = Registry.get("gedcoms/settings/" + this.getName());
        }
        return this.registry;
    }

    public GedcomConstants.Encodings getEncoding() {
        return this.encoding;
    }

    public void setEncoding(GedcomConstants.Encodings set) {
        this.encoding = set;
    }

    public String getPlaceFormat() {
        Entity head = this.getFirstEntity("HEAD");
        if (head == null) {
            return "";
        }
        Property placeProperty = head.getProperty("PLAC");
        if (placeProperty == null) {
            return "";
        }
        Property formatProperty = placeProperty.getProperty("FORM");
        if (formatProperty == null) {
            return "";
        }
        return formatProperty.getValue();
    }

    public void setPlaceFormat(String set) {
        Property formatProperty;
        Entity head = this.getFirstEntity("HEAD");
        Property placeProperty = head.getProperty("PLAC");
        if (placeProperty == null) {
            placeProperty = head.addProperty("PLAC", "");
        }
        if ((formatProperty = placeProperty.getProperty("FORM")) == null) {
            formatProperty = placeProperty.addProperty("FORM", "");
        }
        formatProperty.setValue(PropertyPlace.formatSpaces(set.trim()));
    }

    public void setHeaderNote(String note) {
        Entity head = this.getFirstEntity("HEAD");
        Property noteProperty = head.getProperty("NOTE");
        if (noteProperty == null) {
            noteProperty = head.addProperty("NOTE", "");
        }
        noteProperty.setValue(note);
    }

    public String getHeaderNote() {
        Entity head = this.getFirstEntity("HEAD");
        Property noteProperty = head.getProperty("NOTE");
        if (noteProperty != null) {
            return noteProperty.getDisplayValue();
        }
        return "";
    }

    public void setShowJuridictions(Boolean[] showFormat) {
        this.getRegistry().put("gedcom.showJuridictions", showFormat);
    }

    public Boolean[] getShowJuridictions() {
        return this.getRegistry().get("gedcom.showJuridictions", (Boolean[])null);
    }

    public void setPlaceSortOrder(String placeSortOrder) {
        this.getRegistry().put("gedcom.placeSortOrder", placeSortOrder);
    }

    public String getPlaceSortOrder() {
        return this.getRegistry().get("gedcom.placeSortOrder", GedcomOptions.getInstance().getPlaceSortOrder());
    }

    public void setPlaceDisplayFormat(String placeDisplayFormat) {
        this.getRegistry().put("gedcom.placeDisplayFormat", placeDisplayFormat);
    }

    public String getPlaceDisplayFormatStartingWithCity() {
        int i;
        Object displayFormat = "";
        String city = PropertyPlace.getCityTag(this);
        String[] jurisdictions = PropertyPlace.getFormat(this);
        for (i = 0; i < jurisdictions.length; ++i) {
            if (!jurisdictions[i].equals(city)) continue;
            displayFormat = (String)displayFormat + i + ",";
        }
        for (i = 0; i < jurisdictions.length; ++i) {
            if (jurisdictions[i].equals(city)) continue;
            displayFormat = (String)displayFormat + i + ",";
        }
        return displayFormat;
    }

    public String getPlaceDisplayFormat() {
        return this.getRegistry().get("gedcom.placeDisplayFormat", GedcomOptions.getInstance().getPlaceDisplayFormat());
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String set) {
        this.language = set;
    }

    public void setPassword(String set) {
        this.password = set;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public boolean contains(Entity entity) {
        return this.getEntityMap(entity.getTag()).containsValue(entity);
    }

    public Locale getLocale() {
        if (this.cachedLocale == null) {
            if (this.language != null) {
                Locale[] locales;
                for (Locale locale : locales = Locale.getAvailableLocales()) {
                    if (!locale.getDisplayLanguage(Locale.ENGLISH).equalsIgnoreCase(this.language)) continue;
                    this.cachedLocale = new Locale(locale.getLanguage(), Locale.getDefault().getCountry());
                    break;
                }
            }
            if (this.cachedLocale == null) {
                this.cachedLocale = Locale.getDefault();
            }
        }
        return this.cachedLocale;
    }

    public Collator getCollator() {
        if (this.cachedCollator == null) {
            this.cachedCollator = Collator.getInstance(this.getLocale());
            this.cachedCollator.setStrength(0);
        }
        return this.cachedCollator;
    }

    @Override
    public int compareTo(Gedcom that) {
        if (that == null || that.getName() == null) {
            return 1;
        }
        if (this.getName() == null) {
            return -1;
        }
        return this.getName().compareTo(that.getName());
    }

    public void eraseAll() {
        SwingUtilities.invokeLater(() -> this.freeUpMemory());
    }

    private void eraseProperties(Property parent) {
        try {
            for (Property child : parent.getProperties()) {
                this.eraseProperties(child);
            }
            parent.eraseAll();
            parent = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void freeUpMemory() {
        Iterator it2;
        for (Entity ent : this.allEntities) {
            this.eraseProperties(ent);
            ent.eraseAll();
        }
        this.allEntities.clear();
        Iterator<Object> it = this.propertyTag2valueCount.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        it = this.tag2id2entity.entrySet().iterator();
        while (it.hasNext()) {
            Map map = (Map)it.next().getValue();
            Iterator it22 = map.entrySet().iterator();
            while (it22.hasNext()) {
                it22.next();
                it22.remove();
            }
            it.remove();
        }
        it = this.tags2refsets.entrySet().iterator();
        while (it.hasNext()) {
            ReferenceSet refset = (ReferenceSet)it.next().getValue();
            refset.eraseAll();
            refset = null;
            it.remove();
        }
        it = this.undoHistory.iterator();
        while (it.hasNext()) {
            it2 = ((List)it.next()).iterator();
            while (it2.hasNext()) {
                it2.next();
                it2.remove();
            }
            it.remove();
        }
        it = this.redoHistory.iterator();
        while (it.hasNext()) {
            it2 = ((List)it.next()).iterator();
            while (it2.hasNext()) {
                it2.next();
                it2.remove();
            }
            it.remove();
        }
    }

    private class Lock {
        List<Undo> undos = new ArrayList<Undo>();

        private Lock() {
        }

        void addChange(Undo run) {
            this.undos.add(run);
        }
    }

    private abstract class Undo {
        private Undo() {
        }

        abstract void undo() throws GedcomException;
    }
}

