/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.io;

import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.mysqla.io.MysqlaSocketConnection;
import com.mysql.cj.mysqlx.io.AsyncMessageReader;
import com.mysql.cj.mysqlx.io.AsyncMessageWriter;
import com.mysql.cj.mysqlx.io.MysqlxProtocol;
import com.mysql.cj.mysqlx.io.SyncMessageReader;
import com.mysql.cj.mysqlx.io.SyncMessageWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class MysqlxProtocolFactory {
    public static MysqlxProtocol getInstance(String host, int port, PropertySet propertySet) {
        if (propertySet.getBooleanReadableProperty("mysqlx.useAsyncProtocol").getValue().booleanValue()) {
            return MysqlxProtocolFactory.getAsyncInstance(host, port, propertySet);
        }
        MysqlaSocketConnection socketConnection = new MysqlaSocketConnection();
        Properties socketFactoryProperties = new Properties();
        socketConnection.connect(host, port, socketFactoryProperties, propertySet, null, null, 0);
        SyncMessageReader messageReader = new SyncMessageReader(socketConnection.getMysqlInput());
        SyncMessageWriter messageWriter = new SyncMessageWriter(socketConnection.getMysqlOutput());
        return new MysqlxProtocol(messageReader, messageWriter, socketConnection.getMysqlSocket(), propertySet);
    }

    public static MysqlxProtocol getAsyncInstance(String host, int port, PropertySet propertySet) {
        try {
            AsynchronousSocketChannel sockChan = AsynchronousSocketChannel.open();
            sockChan.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)131072);
            sockChan.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)131072);
            Future<Void> connectPromise = sockChan.connect(new InetSocketAddress(host, port));
            connectPromise.get();
            AsyncMessageReader messageReader = new AsyncMessageReader(sockChan);
            messageReader.start();
            AsyncMessageWriter messageWriter = new AsyncMessageWriter(sockChan);
            return new MysqlxProtocol(messageReader, messageWriter, sockChan, propertySet);
        }
        catch (IOException | InterruptedException | ExecutionException ex) {
            throw new CJCommunicationsException(ex);
        }
    }
}

