/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Savepoint;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={Savepoint.class, SQLOutput.class, OracleSavepoint.class})
public abstract class NonTxnReplayableOthers
extends NonTxnReplayableBase
implements Replayable {
    private static final String OTHERS_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.NonTxnReplayableOthers";
    private static Logger OTHERS_REPLAY_LOGGER = null;

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        OTHERS_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, entering preForAll({1})", new Object[]{this, method.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        } else {
            OTHERS_REPLAY_LOGGER.log(Level.SEVERE, "On proxy {0}, failover manager not set", this);
        }
        OTHERS_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, exiting preForAll()", this);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    static {
        if (OTHERS_REPLAY_LOGGER == null) {
            OTHERS_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(OTHERS_FEATURE_LOGGER_NAME);
        }
    }
}

