if(MINIUPNPC_PREFER_STATIC_LIB)
    set(MINIUPNPC_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES})
    if(WIN32)
        set(CMAKE_FIND_LIBRARY_SUFFIXES .a .lib ${CMAKE_FIND_LIBRARY_SUFFIXES})
    else()
        set(CMAKE_FIND_LIBRARY_SUFFIXES .a ${CMAKE_FIND_LIBRARY_SUFFIXES})
    endif()
endif()

if(UNIX)
    find_package(PkgConfig QUIET)
    pkg_check_modules(_MINIUPNPC QUIET libminiupnpc)
endif()

find_path(MINIUPNPC_INCLUDE_DIR
    NAMES miniupnpc/miniupnpc.h
    HINTS ${_MINIUPNPC_INCLUDEDIR})
find_library(MINIUPNPC_LIBRARY
    NAMES
        miniupnpc
        libminiupnpc
    HINTS ${_MINIUPNPC_LIBDIR})

set(MINIUPNPC_INCLUDE_DIRS ${MINIUPNPC_INCLUDE_DIR})
set(MINIUPNPC_LIBRARIES ${MINIUPNPC_LIBRARY})

include(FindPackageHandleStandardArgs)

find_package_handle_standard_args(MINIUPNPC
    REQUIRED_VARS
        MINIUPNPC_LIBRARY
        MINIUPNPC_INCLUDE_DIR)

mark_as_advanced(MINIUPNPC_INCLUDE_DIR MINIUPNPC_LIBRARY)

if(MINIUPNPC_PREFER_STATIC_LIB)
    set(CMAKE_FIND_LIBRARY_SUFFIXES ${MINIUPNPC_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES})
    unset(MINIUPNPC_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES)
endif()
