
# Make a tabbed notebook for Preferences
proc prefdialog {} {
  global cvscfg
  
  if {[winfo exists .prefdlg]} {
    destroy .prefdlg
  }
  
  set pd .prefdlg
  toplevel $pd
  wm title $pd "TkRev Preferences"
  wm protocol $pd WM_DELETE_WINDOW { prefs_close }
  wm withdraw .prefdlg
  
  lassign [winfo pointerxy .] x y
  incr x -150
  wm geometry .prefdlg +$x+$y
  
  ttk::notebook $pd.prefnb
  ttk::notebook::enableTraversal $pd.prefnb
  
  frame $pd.bot -relief raised -bd 2
  button $pd.bot.save -text "Save" -command { set cvsglb(vcspref) $cvscfg(vcspref); save_options }
  button $pd.bot.close -text "Close" -command { prefs_close }
  
  pack $pd.bot.save -side left -padx 4 -pady 2
  pack $pd.bot.close -side right -padx 4 -pady 2
  pack $pd.bot -side bottom -expand 0 -fill x
  
  # Build the pages
  prefs_general $pd.prefnb
  prefs_diagram $pd.prefnb
  prefs_git $pd.prefnb
  prefs_subversion $pd.prefnb
  prefs_cvs $pd.prefnb
  
  pack $pd.prefnb -side top -expand y -fill both
  
  if {[info exists cvscfg(preftab)]} {
    .prefdlg.prefnb select $cvscfg(preftab)
  }
  if {! [winfo ismapped .prefdlg]} {
    wm deiconify .prefdlg
  }
  
  bind .prefdlg.prefnb <<NotebookTabChanged>> {set cvscfg(preftab) [.prefdlg.prefnb select]}
  raise $pd
}

# General preferences
proc prefs_general {w} {
  global cvscfg
  global colorglb

  frame $w.general -background $colorglb(menubg)
  $w add $w.general -text "General" -sticky nsew
  
  ttk::checkbutton $w.general.allfiles -style Tabs.TCheckbutton \
      -text "Show Dotfiles" -variable cvscfg(allfiles) -onvalue true -offvalue false
  ttk::checkbutton $w.general.confirmation -style Tabs.TCheckbutton \
      -text "Show Confirmation Dialogs" \
      -variable cvscfg(confirm_prompt) -onvalue true -offvalue false
  ttk::checkbutton $w.general.auto -style Tabs.TCheckbutton \
      -text "Automatic Workdir Status" \
      -variable cvscfg(auto_status) -onvalue true -offvalue false
  label $w.general.lshell -text "Terminal" \
      -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.general.eshell -textvariable cvscfg(shell)
  label $w.general.leditor -text "Text Editor" \
      -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.general.eeditor -textvariable cvscfg(editor)
  ttk::checkbutton $w.general.ext_editor -style Tabs.TCheckbutton \
     -text "Use Native Editor for Check In" \
     -variable cvscfg(use_cvseditor) -onvalue true -offvalue false
  label $w.general.ldiff -text "Diff Visualizer" \
      -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.general.ediff -textvariable cvscfg(tkdiff)
  label $w.general.lvcsorder -text "VCS Precedence" \
      -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.general.evcsorder -textvariable cvscfg(vcspref)
  
  grid columnconf $w.general 1 -weight 1
  grid $w.general.allfiles -padx 4 -sticky w -column 0 -row 0 -columnspan 2
  grid $w.general.confirmation -padx 4 -sticky w -column 0 -row 1 -columnspan 2
  grid $w.general.auto -padx 4 -sticky w -column 0 -row 2 -columnspan 2
  grid $w.general.ext_editor -padx 4 -sticky w -column 0 -row 3 -columnspan 2
  grid $w.general.leditor -sticky w -column 0 -row 4
  grid $w.general.eeditor -sticky ew -column 1 -row 4 -padx 2
  grid $w.general.ldiff -sticky w -column 0 -row 5
  grid $w.general.ediff -sticky ew -column 1 -row 5 -padx 2
  grid $w.general.lshell -sticky w -column 0 -row 6
  grid $w.general.eshell -sticky ew -column 1 -row 6 -padx 2
  grid $w.general.lvcsorder -sticky w -column 0 -row 7
  grid $w.general.evcsorder -sticky ew -column 1 -row 7 -padx 2

  if {[tk windowingsystem] eq "x11"} {
    ttk::separator $w.general.sep1
    label $w.general.x11lbl -text "X11" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
    ttk::checkbutton $w.general.match_desk -style Tabs.TCheckbutton \
      -text "Match GTK or CDE colors (requires restart)" \
      -variable cvscfg(match_desktop) -onvalue true -offvalue false
    grid $w.general.sep1 -sticky ew -column 0 -row 8 -columnspan 3 -pady 4
    grid $w.general.x11lbl -sticky w -column 0 -row 9 -pady 2
    grid $w.general.match_desk -sticky w -column 0 -row 10 -padx 4 -columnspan 3
  }
}

# For the Branch diagrams
proc prefs_diagram {w} {
  global logcfg
  global colorglb
  
  frame $w.logcanv -bg $colorglb(menubg)
  $w add $w.logcanv -text "Branch Browser" -sticky nsew
  
  frame $w.logcanv.layout -bg $colorglb(menubg)
  ttk::checkbutton $w.logcanv.layout.showtags -style Tabs.TCheckbutton \
      -text "Show Tags" \
      -variable logcfg(show_tags) -onvalue 1 -offvalue 0
  ttk::checkbutton $w.logcanv.layout.showbranches -style Tabs.TCheckbutton \
      -text "Show Branches" \
      -variable logcfg(show_branches) -onvalue 1 -offvalue 0
  ttk::checkbutton $w.logcanv.layout.showempty -style Tabs.TCheckbutton \
      -text "Show Empty Branches (CVS)" \
      -variable logcfg(show_empty_branches) -onvalue 1 -offvalue 0
  ttk::checkbutton $w.logcanv.layout.showintermed -style Tabs.TCheckbutton \
      -text "Show Intermediate Revisions" \
      -variable logcfg(show_inter_revs) -onvalue 1 -offvalue 0
  ttk::checkbutton $w.logcanv.layout.showmerg -style Tabs.TCheckbutton \
      -text "Show Merges" \
      -variable logcfg(show_merges) -onvalue 1 -offvalue 0
  
  pack $w.logcanv.layout -side top -fill x
  grid columnconf $w.logcanv.layout 1 -weight 1
  grid $w.logcanv.layout.showtags -padx 4 -sticky w -column 0 -row 0 -columnspan 2
  grid $w.logcanv.layout.showbranches -padx 4 -sticky w -column 0 -row 1 -columnspan 2
  grid $w.logcanv.layout.showempty -padx 4 -sticky w -column 0 -row 2 -columnspan 2
  grid $w.logcanv.layout.showintermed -padx 4 -sticky w -column 0 -row 3 -columnspan 2
  grid $w.logcanv.layout.showmerg -padx 4 -sticky w -column 0 -row 4 -columnspan 2
  
  ttk::separator $w.logcanv.sep1
  pack $w.logcanv.sep1 -side top -fill x -pady 3
  
  frame $w.logcanv.scale -bg $colorglb(menubg)
  label $w.logcanv.scale.lspin -text "Scale" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  ttk::spinbox $w.logcanv.scale.sspin -from .2 -to 1.5 -increment .1 \
      -textvariable logcfg(scale)
  
  pack  $w.logcanv.scale
  grid columnconf $w.logcanv.scale 1 -weight 1
  grid $w.logcanv.scale.lspin -sticky w -column 0 -row 0
  grid $w.logcanv.scale.sspin -sticky w -column 1 -row 0
  
  ttk::separator $w.logcanv.sep2
  pack $w.logcanv.sep2 -side top -fill x -pady 3
  
  frame $w.logcanv.revs -bg $colorglb(menubg)
  ttk::checkbutton $w.logcanv.revs.showrev -style Tabs.TCheckbutton \
      -text "Show Revision #" \
      -variable logcfg(show_box_rev) -onvalue 1 -offvalue 0
  ttk::checkbutton $w.logcanv.revs.showrevwho -style Tabs.TCheckbutton \
      -text "Show Author" \
      -variable logcfg(show_box_revwho) -onvalue 1 -offvalue 0
  ttk::checkbutton $w.logcanv.revs.showrevdate -style Tabs.TCheckbutton \
      -text "Show Date" \
      -variable logcfg(show_box_revdate) -onvalue 1 -offvalue 0
  ttk::checkbutton $w.logcanv.revs.showrevtime -style Tabs.TCheckbutton \
      -text "Show Time" \
      -variable logcfg(show_box_revtime) -onvalue 1 -offvalue 0
      
  pack $w.logcanv.revs -side top -fill x
  grid columnconf $w.logcanv.revs 1 -weight 1
  grid $w.logcanv.revs.showrev -padx 4 -sticky w -column 0 -row 0 -columnspan 2
  grid $w.logcanv.revs.showrevwho -padx 4 -sticky w -column 0 -row 1 -columnspan 2
  grid $w.logcanv.revs.showrevdate -padx 4 -sticky w -column 0 -row 2 -columnspan 2
  grid $w.logcanv.revs.showrevtime -padx 4 -sticky w -column 0 -row 3 -columnspan 2
  
}

# For CVS
proc prefs_cvs {w} {
  global colorglb

  frame $w.cvs -bg $colorglb(menubg)
  $w add $w.cvs -text "CVS" -sticky nsew
  
  ttk::checkbutton $w.cvs.editing -style Tabs.TCheckbutton \
      -text "Allow cvs edit" \
      -variable cvscfg(econtrol) -onvalue true -offvalue false -state disabled
  ttk::checkbutton $w.cvs.locking -style Tabs.TCheckbutton \
      -text "Allow cvs lock" \
      -variable cvscfg(cvslock) -onvalue true -offvalue false -state disabled
  
  grid columnconf $w.cvs 1 -weight 1
  grid $w.cvs.editing -padx 4 -sticky w -column 0 -row 0
  grid $w.cvs.locking -padx 4 -sticky w -column 0 -row 1
}

# For Subversion
proc prefs_subversion {w} {
  global colorglb

  frame $w.svn -bg $colorglb(menubg)
  $w add $w.svn -text "Subversion" -sticky nsew
  
  frame $w.svn.dirnames -bg $colorglb(menubg)
  label $w.svn.dirnames.ltrunkdir -text "Trunk Directory" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.svn.dirnames.etrunkdir -textvariable cvscfg(svn_trunkdir)
  label $w.svn.dirnames.lbranchdir -text "Branches Directory" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.svn.dirnames.ebranchdir -textvariable cvscfg(svn_branchdir)
  label $w.svn.dirnames.ltagdir -text "Tags Directory" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.svn.dirnames.etagdir -textvariable cvscfg(svn_tagdir)
  
  pack $w.svn.dirnames -side top -fill x
  grid columnconf $w.svn.dirnames 1 -weight 1
  grid $w.svn.dirnames.ltrunkdir -sticky w -column 0 -row 0
  grid $w.svn.dirnames.etrunkdir -sticky ew -column 1 -row 0 -padx 2
  grid $w.svn.dirnames.lbranchdir -sticky w -column 0 -row 1
  grid $w.svn.dirnames.ebranchdir -sticky ew -column 1 -row 1 -padx 2
  grid $w.svn.dirnames.ltagdir -sticky w -column 0 -row 2
  grid $w.svn.dirnames.etagdir -sticky ew -column 1 -row 2 -padx 2
  
  ttk::separator $w.svn.sep1
  pack $w.svn.sep1 -side top -fill x -pady 3
  
  frame $w.svn.branchbr -bg $colorglb(menubg)
  label $w.svn.branchbr.lmaxtag -text "Maximum SVN Tags" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.svn.branchbr.emaxtag -textvariable cvscfg(toomany_tags)
  
  pack $w.svn.branchbr -side top -fill x
  grid columnconf $w.svn.branchbr 1 -weight 1
  grid $w.svn.branchbr.lmaxtag -sticky w -column 0 -row 0
  grid $w.svn.branchbr.emaxtag -sticky ew -column 1 -row 0 -padx 2
}

# For Git
proc prefs_git {w} {
  global colorglb

  frame $w.git -bg $colorglb(menubg)
  $w add $w.git -text "Git" -sticky nsew
  
  frame $w.git.workdir -bg $colorglb(menubg)
  ttk::checkbutton $w.git.workdir.detail -style Tabs.TCheckbutton \
      -text "Detailed Workdir Status" \
      -variable cvscfg(gitdetail) -onvalue true -offvalue false
  
  pack $w.git.workdir -side top -fill x
  grid columnconf $w.git.workdir 1 -weight 1
  grid $w.git.workdir.detail -padx 4 -sticky w -column 0 -row 0 -columnspan 2
  
  ttk::separator $w.git.sep1
  pack $w.git.sep1 -side top -fill x -pady 3
  
  frame $w.git.blame -bg $colorglb(menubg)
  label $w.git.blame.blamelbl -text "Annotate/Blame" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  label $w.git.blame.lgitblame_since -text "Since" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.git.blame.egitblame_since -textvariable cvscfg(gitblame_since)
  
  pack $w.git.blame -side top -fill x
  grid columnconf $w.git.blame 1 -weight 1
  grid $w.git.blame.blamelbl -sticky w -column 0 -row 0 -columnspan 2
  grid $w.git.blame.lgitblame_since -sticky w -column 0 -row 1
  grid $w.git.blame.egitblame_since -sticky ew -column 1 -row 1 -padx 2
  
  ttk::separator $w.git.sep2
  pack $w.git.sep2 -side top -fill x -pady 3
  
  frame $w.git.branchbr -bg $colorglb(menubg)
  label $w.git.branchbr.blamelbl -text "Log Browser" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  label $w.git.branchbr.lgitlog_since -text "Since" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.git.branchbr.egitlog_since -textvariable cvscfg(gitlog_since)
  label $w.git.branchbr.lmaxhist -text "Maximum Git History" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.git.branchbr.emaxhist -textvariable cvscfg(gitmaxhist)
  label $w.git.branchbr.lmaxbranches -text "Maximum Git Branches" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.git.branchbr.emaxbranches -textvariable cvscfg(gitmaxbranch)
  label $w.git.branchbr.llogopts -text "Git Log Options" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.git.branchbr.elogopts -textvariable cvscfg(gitlog_opts)
  
  ttk::radiobutton  $w.git.branchbr.br_file -style Tabs.TCheckbutton \
      -text " File-specific branches only" \
      -variable cvscfg(gitbranchgroups) -value "F"
  ttk::radiobutton  $w.git.branchbr.br_local -style Tabs.TCheckbutton \
      -text " All local branches" \
      -variable cvscfg(gitbranchgroups) -value "FL"
  ttk::radiobutton  $w.git.branchbr.br_remote -style Tabs.TCheckbutton \
      -text " Local + Remote branches" \
      -variable cvscfg(gitbranchgroups) -value "FLR"
      
  label $w.git.branchbr.lbrglob -text "Git Branch Filter (regex)" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  entry $w.git.branchbr.ebrglob -textvariable cvscfg(gitbranchregex)
  label $w.git.branchbr.hbrglob -text "master and current always included" \
         -background $colorglb(menubg) -foreground $colorglb(menufg)
  
  pack $w.git.branchbr -side top -fill x
  grid columnconf $w.git.branchbr 1 -weight 1
  grid $w.git.branchbr.blamelbl -sticky w -column 0 -row 0 -columnspan 2
  grid $w.git.branchbr.lgitlog_since -sticky w -column 0 -row 1
  grid $w.git.branchbr.egitlog_since -sticky ew -column 1 -row 1 -padx 2
  grid $w.git.branchbr.lmaxhist -sticky w -column 0 -row 2
  grid $w.git.branchbr.emaxhist -sticky ew -column 1 -row 2 -padx 2
  grid $w.git.branchbr.lmaxbranches -sticky w -column 0 -row 3
  grid $w.git.branchbr.emaxbranches -sticky ew -column 1 -row 3 -padx 2
  grid $w.git.branchbr.llogopts -sticky w -column 0 -row 4
  grid $w.git.branchbr.elogopts -sticky ew -column 1 -row 4 -padx 2
  
  grid $w.git.branchbr.br_file -padx 4 -sticky w -column 1 -row 5
  grid $w.git.branchbr.br_local -padx 4 -sticky w -column 1 -row 6
  grid $w.git.branchbr.br_remote -padx 4 -sticky w -column 1 -row 7
  
  grid $w.git.branchbr.lbrglob -sticky w -column 0 -row 8
  grid $w.git.branchbr.ebrglob -sticky ew -column 1 -row 8 -padx 2
  grid $w.git.branchbr.hbrglob -sticky w -column 1 -row 9
}

proc prefs_close { } {
  global cvscfg
  
  gen_log:log D "Preferences Tab $cvscfg(preftab)"
  
  destroy .prefdlg
  exit_cleanup 0
}

