// Code generated by re2go, DO NOT EDIT.
//line "codegen/go/loop_switch/advanced.re":1
//go:generate re2go $INPUT -o $OUTPUT -cf --loop-switch -Wno-nondeterministic-tags
package main

import (
	"fmt"
	"os"
)

//line "codegen/go/loop_switch/advanced.go":12
const (
	yycmedia_type = 0
	yycheader = 22
)
//line "codegen/go/loop_switch/advanced.re":9


const debug bool = true

// Intentionally small to trigger buffer refill.
const SIZE int = 4095

const (
	mtagRoot int = -1
	tagNone int = -1
)

// An m-tag tree is a way to store histories with an O(1) copy operation.
// Histories naturally form a tree, as they have common start and fork at some
// point. The tree is stored as an array of pairs (tag value, link to parent).
// An m-tag is represented with a single link in the tree (array index).
type mtagElem struct {
	elem int
	pred int
}
type mtagTrie = []mtagElem

// Append a single value to an m-tag history.
func add_mtag(trie *mtagTrie, mtag int, value int) int {
	*trie = append(*trie, mtagElem{value, mtag})
	return len(*trie) - 1
}

// Recursively unwind tag histories and collect version components.
func unwind(trie mtagTrie, x int, y int, str []byte) []string {
	// Reached the root of the m-tag tree, stop recursion.
	if x == mtagRoot && y == mtagRoot {
		return []string{}
	}

	// Unwind history further.
	result := unwind(trie, trie[x].pred, trie[y].pred, str)

	// Get tag values. Tag histories must have equal length.
	if x == mtagRoot || y == mtagRoot {
		panic("tag histories have different length")
	}
	ex := trie[x].elem
	ey := trie[y].elem

	if ex != tagNone && ey != tagNone {
		// Both tags are valid string indices, extract component.
		result = append(result, string(str[ex:ey]))
	} else if !(ex == tagNone && ey == tagNone) {
		panic("both tags should be tagNone")
	}
	return result
}

type State struct {
	file     *os.File
	data     []byte
	cur      int
	mar      int
	tok      int
	lim      int
	cond     int
	state    int
	trie     mtagTrie
	
//line "codegen/go/loop_switch/advanced.go":83

	yyt1 int
	yyt2 int
//line "codegen/go/loop_switch/advanced.re":73

	
//line "codegen/go/loop_switch/advanced.go":90

	yytm1 int
	yytm10 int
	yytm2 int
	yytm3 int
	yytm4 int
	yytm5 int
	yytm6 int
	yytm7 int
	yytm8 int
	yytm9 int
//line "codegen/go/loop_switch/advanced.re":74

	accept   int
}

const (
	lexEnd = iota
	lexReady
	lexWaiting
	lexBadPacket
	lexBigPacket
)

func fill(st *State) int {
	shift := st.tok
	used := st.lim - st.tok
	free := SIZE - used

	// Error: no space. In real life can reallocate a larger buffer.
	if free < 1 { return lexBigPacket }

	// Shift buffer contents (discard already processed data).
	copy(st.data[0:], st.data[shift:shift+used])
	st.cur -= shift
	st.mar -= shift
	st.lim -= shift
	st.tok -= shift
	
//line "codegen/go/loop_switch/advanced.go":130

	if st.yyt1 != tagNone { st.yyt1 -= shift };
	if st.yyt2 != tagNone { st.yyt2 -= shift };
//line "codegen/go/loop_switch/advanced.re":100


	// Fill free space at the end of buffer with new data.
	n, _ := st.file.Read(st.data[st.lim:SIZE])
	st.lim += n
	st.data[st.lim] = 0 // append sentinel symbol

	return lexReady
}

func lex(st *State) int {
	var yych byte
	var l1, l2, f1, f2, p1, p2, p3, p4 int
loop:
	
//line "codegen/go/loop_switch/advanced.go":150
{
	yystate := st.state
yyl:
	for {
		switch (yystate) {
		case -1,0:
			yych = st.data[st.cur]
			switch (yych) {
			case '!':
				fallthrough
			case '#','$','%','&','\'':
				fallthrough
			case '*','+':
				fallthrough
			case '-','.':
				fallthrough
			case '0','1','2','3','4','5','6','7','8','9':
				fallthrough
			case 'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z':
				fallthrough
			case '^','_','`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z':
				fallthrough
			case '|':
				fallthrough
			case '~':
				st.yyt1 = st.cur
				st.cur += 1
				yystate = 3
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 44
					return lexWaiting
				}
				st.cur += 1
				yystate = 1
				continue yyl
			}
		case 1:
			yystate = 2
			continue yyl
		case 2:
			st.state = yycmedia_type
//line "codegen/go/loop_switch/advanced.re":184
			{ return lexBadPacket }
//line "codegen/go/loop_switch/advanced.go":196
		case 3:
			st.mar = st.cur
			yych = st.data[st.cur]
			switch (yych) {
			case '!':
				fallthrough
			case '#','$','%','&','\'':
				fallthrough
			case '*','+':
				fallthrough
			case '-','.','/','0','1','2','3','4','5','6','7','8','9':
				fallthrough
			case 'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z':
				fallthrough
			case '^','_','`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z':
				fallthrough
			case '|':
				fallthrough
			case '~':
				yystate = 5
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 45
					return lexWaiting
				}
				yystate = 2
				continue yyl
			}
		case 4:
			yych = st.data[st.cur]
			yystate = 5
			continue yyl
		case 5:
			switch (yych) {
			case '!':
				fallthrough
			case '#','$','%','&','\'':
				fallthrough
			case '*','+':
				fallthrough
			case '-','.':
				fallthrough
			case '0','1','2','3','4','5','6','7','8','9':
				fallthrough
			case 'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z':
				fallthrough
			case '^','_','`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z':
				fallthrough
			case '|':
				fallthrough
			case '~':
				st.cur += 1
				yystate = 4
				continue yyl
			case '/':
				st.cur += 1
				yystate = 7
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 46
					return lexWaiting
				}
				yystate = 6
				continue yyl
			}
		case 6:
			st.cur = st.mar
			yystate = 2
			continue yyl
		case 7:
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case '\t':
				fallthrough
			case '\r':
				fallthrough
			case ' ':
				fallthrough
			case ';':
				if (st.cur >= st.lim) {
					st.state = 47
					return lexWaiting
				}
				yystate = 6
				continue yyl
			default:
				yystate = 9
				continue yyl
			}
		case 8:
			yych = st.data[st.cur]
			yystate = 9
			continue yyl
		case 9:
			switch (yych) {
			case '\t':
				fallthrough
			case ' ':
				st.yytm6 = st.yytm10
				st.yytm6 = add_mtag(&st.trie, st.yytm6, tagNone)
				st.yytm5 = st.yytm9
				st.yytm5 = add_mtag(&st.trie, st.yytm5, tagNone)
				st.yytm4 = st.yytm8
				st.yytm4 = add_mtag(&st.trie, st.yytm4, tagNone)
				st.yytm3 = st.yytm7
				st.yytm3 = add_mtag(&st.trie, st.yytm3, tagNone)
				st.yyt2 = st.cur
				st.cur += 1
				yystate = 10
				continue yyl
			case '\r':
				st.yytm6 = st.yytm10
				st.yytm6 = add_mtag(&st.trie, st.yytm6, tagNone)
				st.yytm5 = st.yytm9
				st.yytm5 = add_mtag(&st.trie, st.yytm5, tagNone)
				st.yytm4 = st.yytm8
				st.yytm4 = add_mtag(&st.trie, st.yytm4, tagNone)
				st.yytm3 = st.yytm7
				st.yytm3 = add_mtag(&st.trie, st.yytm3, tagNone)
				st.yyt2 = st.cur
				st.cur += 1
				yystate = 11
				continue yyl
			case '!':
				fallthrough
			case '#','$','%','&','\'':
				fallthrough
			case '*','+':
				fallthrough
			case '-','.':
				fallthrough
			case '0','1','2','3','4','5','6','7','8','9':
				fallthrough
			case 'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z':
				fallthrough
			case '^','_','`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z':
				fallthrough
			case '|':
				fallthrough
			case '~':
				st.cur += 1
				yystate = 8
				continue yyl
			case ';':
				st.yyt2 = st.cur
				st.cur += 1
				yystate = 12
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 48
					return lexWaiting
				}
				yystate = 6
				continue yyl
			}
		case 10:
			yych = st.data[st.cur]
			switch (yych) {
			case '\t':
				fallthrough
			case ' ':
				st.cur += 1
				yystate = 10
				continue yyl
			case '\r':
				st.cur += 1
				yystate = 11
				continue yyl
			case ';':
				st.cur += 1
				yystate = 12
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 49
					return lexWaiting
				}
				yystate = 6
				continue yyl
			}
		case 11:
			yych = st.data[st.cur]
			switch (yych) {
			case '\n':
				st.cur += 1
				yystate = 13
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 50
					return lexWaiting
				}
				yystate = 6
				continue yyl
			}
		case 12:
			yych = st.data[st.cur]
			switch (yych) {
			case '\t':
				fallthrough
			case ' ':
				st.cur += 1
				yystate = 12
				continue yyl
			case '!':
				fallthrough
			case '#','$','%','&','\'':
				fallthrough
			case '*','+':
				fallthrough
			case '-','.':
				fallthrough
			case '0','1','2','3','4','5','6','7','8','9':
				fallthrough
			case 'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z':
				fallthrough
			case '^','_','`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z':
				fallthrough
			case '|':
				fallthrough
			case '~':
				st.yytm7 = add_mtag(&st.trie, st.yytm7, st.cur)
				st.cur += 1
				yystate = 14
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 51
					return lexWaiting
				}
				yystate = 6
				continue yyl
			}
		case 13:
			l1 = st.yyt1
			l2 = st.yyt2
			p1 = st.yytm3
			p2 = st.yytm4
			p3 = st.yytm5
			p4 = st.yytm6
			st.state = yycmedia_type
//line "codegen/go/loop_switch/advanced.re":162
			{
			if debug {fmt.Printf("media type: %v\n", string(st.data[l1:l2]))}

			pnames := unwind(st.trie, p1, p2, st.data)
			if debug {fmt.Printf("pnames: %v\n", pnames)}
    
			pvals := unwind(st.trie, p3, p4, st.data)
			if debug {fmt.Printf("pvals: %v\n", pvals)}

			st.tok = st.cur
			goto loop
		}
//line "codegen/go/loop_switch/advanced.go":456
		case 14:
			yych = st.data[st.cur]
			switch (yych) {
			case '!':
				fallthrough
			case '#','$','%','&','\'':
				fallthrough
			case '*','+':
				fallthrough
			case '-','.':
				fallthrough
			case '0','1','2','3','4','5','6','7','8','9':
				fallthrough
			case 'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z':
				fallthrough
			case '^','_','`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z':
				fallthrough
			case '|':
				fallthrough
			case '~':
				st.cur += 1
				yystate = 14
				continue yyl
			case '=':
				st.yytm8 = add_mtag(&st.trie, st.yytm8, st.cur)
				st.cur += 1
				yystate = 15
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 52
					return lexWaiting
				}
				yystate = 6
				continue yyl
			}
		case 15:
			yych = st.data[st.cur]
			switch (yych) {
			case '!':
				fallthrough
			case '#','$','%','&','\'':
				fallthrough
			case '*','+':
				fallthrough
			case '-','.':
				fallthrough
			case '0','1','2','3','4','5','6','7','8','9':
				fallthrough
			case 'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z':
				fallthrough
			case '^','_','`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z':
				fallthrough
			case '|':
				fallthrough
			case '~':
				st.yytm9 = add_mtag(&st.trie, st.yytm9, st.cur)
				st.cur += 1
				yystate = 16
				continue yyl
			case '"':
				st.yytm9 = add_mtag(&st.trie, st.yytm9, st.cur)
				st.cur += 1
				yystate = 17
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 53
					return lexWaiting
				}
				yystate = 6
				continue yyl
			}
		case 16:
			yych = st.data[st.cur]
			switch (yych) {
			case '\t':
				fallthrough
			case ' ':
				st.yytm10 = add_mtag(&st.trie, st.yytm10, st.cur)
				st.cur += 1
				yystate = 18
				continue yyl
			case '\r':
				st.yytm3 = st.yytm7
				st.yytm4 = st.yytm8
				st.yytm5 = st.yytm9
				st.yytm6 = st.yytm10
				st.yytm6 = add_mtag(&st.trie, st.yytm6, st.cur)
				st.cur += 1
				yystate = 11
				continue yyl
			case '!':
				fallthrough
			case '#','$','%','&','\'':
				fallthrough
			case '*','+':
				fallthrough
			case '-','.':
				fallthrough
			case '0','1','2','3','4','5','6','7','8','9':
				fallthrough
			case 'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z':
				fallthrough
			case '^','_','`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z':
				fallthrough
			case '|':
				fallthrough
			case '~':
				st.cur += 1
				yystate = 16
				continue yyl
			case ';':
				st.yytm10 = add_mtag(&st.trie, st.yytm10, st.cur)
				st.cur += 1
				yystate = 12
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 54
					return lexWaiting
				}
				yystate = 6
				continue yyl
			}
		case 17:
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08:
				fallthrough
			case '\n','\v','\f','\r',0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F:
				fallthrough
			case 0x7F:
				if (st.cur >= st.lim) {
					st.state = 55
					return lexWaiting
				}
				yystate = 6
				continue yyl
			case '"':
				st.cur += 1
				yystate = 19
				continue yyl
			case '\\':
				st.cur += 1
				yystate = 20
				continue yyl
			default:
				st.cur += 1
				yystate = 17
				continue yyl
			}
		case 18:
			yych = st.data[st.cur]
			switch (yych) {
			case '\t':
				fallthrough
			case ' ':
				st.cur += 1
				yystate = 18
				continue yyl
			case '\r':
				st.yytm3 = st.yytm7
				st.yytm4 = st.yytm8
				st.yytm5 = st.yytm9
				st.yytm6 = st.yytm10
				st.cur += 1
				yystate = 11
				continue yyl
			case ';':
				st.cur += 1
				yystate = 12
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 56
					return lexWaiting
				}
				yystate = 6
				continue yyl
			}
		case 19:
			yych = st.data[st.cur]
			switch (yych) {
			case '\t':
				fallthrough
			case ' ':
				st.yytm10 = add_mtag(&st.trie, st.yytm10, st.cur)
				st.cur += 1
				yystate = 18
				continue yyl
			case '\r':
				st.yytm3 = st.yytm7
				st.yytm4 = st.yytm8
				st.yytm5 = st.yytm9
				st.yytm6 = st.yytm10
				st.yytm6 = add_mtag(&st.trie, st.yytm6, st.cur)
				st.cur += 1
				yystate = 11
				continue yyl
			case ';':
				st.yytm10 = add_mtag(&st.trie, st.yytm10, st.cur)
				st.cur += 1
				yystate = 12
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 57
					return lexWaiting
				}
				yystate = 6
				continue yyl
			}
		case 20:
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08:
				fallthrough
			case '\n','\v','\f','\r',0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E:
				fallthrough
			case 0x7F:
				if (st.cur >= st.lim) {
					st.state = 58
					return lexWaiting
				}
				yystate = 6
				continue yyl
			default:
				st.cur += 1
				yystate = 17
				continue yyl
			}
		case 21:
			st.state = yycmedia_type
//line "codegen/go/loop_switch/advanced.re":183
			{ return lexEnd }
//line "codegen/go/loop_switch/advanced.go":697
		case 22:
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,'\t','\n','\v','\f':
				fallthrough
			case 0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E:
				fallthrough
			case 0x7F:
				if (st.cur >= st.lim) {
					st.state = 59
					return lexWaiting
				}
				st.cur += 1
				yystate = 23
				continue yyl
			case '\r':
				st.yytm3 = add_mtag(&st.trie, st.yytm3, st.cur)
				st.cur += 1
				yystate = 25
				continue yyl
			default:
				st.cur += 1
				yystate = 26
				continue yyl
			}
		case 23:
			yystate = 24
			continue yyl
		case 24:
			st.state = yycheader
//line "codegen/go/loop_switch/advanced.re":184
			{ return lexBadPacket }
//line "codegen/go/loop_switch/advanced.go":732
		case 25:
			st.accept = 0
			st.mar = st.cur
			yych = st.data[st.cur]
			switch (yych) {
			case '\n':
				st.cur += 1
				yystate = 27
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 60
					return lexWaiting
				}
				yystate = 24
				continue yyl
			}
		case 26:
			st.accept = 0
			st.mar = st.cur
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08:
				fallthrough
			case '\n','\v','\f':
				fallthrough
			case 0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E:
				fallthrough
			case 0x7F:
				if (st.cur >= st.lim) {
					st.state = 61
					return lexWaiting
				}
				yystate = 24
				continue yyl
			case '\t':
				st.cur += 1
				yystate = 29
				continue yyl
			case '\r':
				st.yytm3 = add_mtag(&st.trie, st.yytm3, st.cur)
				st.cur += 1
				yystate = 30
				continue yyl
			default:
				st.cur += 1
				yystate = 31
				continue yyl
			}
		case 27:
			yych = st.data[st.cur]
			switch (yych) {
			case '\t':
				fallthrough
			case ' ':
				st.cur += 1
				yystate = 32
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 62
					return lexWaiting
				}
				yystate = 28
				continue yyl
			}
		case 28:
			st.cur = st.mar
			if (st.accept == 0) {
				yystate = 24
				continue yyl
			} else {
				yystate = 37
				continue yyl
			}
		case 29:
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08:
				fallthrough
			case '\n','\v','\f','\r',0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E:
				fallthrough
			case 0x7F:
				if (st.cur >= st.lim) {
					st.state = 63
					return lexWaiting
				}
				yystate = 28
				continue yyl
			case '\t':
				st.cur += 1
				yystate = 29
				continue yyl
			case ' ':
				st.cur += 1
				yystate = 31
				continue yyl
			default:
				st.cur += 1
				yystate = 33
				continue yyl
			}
		case 30:
			yych = st.data[st.cur]
			switch (yych) {
			case '\n':
				st.cur += 1
				yystate = 27
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 64
					return lexWaiting
				}
				yystate = 28
				continue yyl
			}
		case 31:
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08:
				fallthrough
			case '\n','\v','\f':
				fallthrough
			case 0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E:
				fallthrough
			case 0x7F:
				if (st.cur >= st.lim) {
					st.state = 65
					return lexWaiting
				}
				yystate = 28
				continue yyl
			case '\t':
				st.cur += 1
				yystate = 29
				continue yyl
			case '\r':
				st.yytm3 = add_mtag(&st.trie, st.yytm3, st.cur)
				st.cur += 1
				yystate = 30
				continue yyl
			default:
				st.cur += 1
				yystate = 31
				continue yyl
			}
		case 32:
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08:
				fallthrough
			case '\n','\v','\f':
				fallthrough
			case 0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E:
				fallthrough
			case 0x7F:
				if (st.cur >= st.lim) {
					st.state = 66
					return lexWaiting
				}
				yystate = 28
				continue yyl
			case '\t':
				fallthrough
			case ' ':
				st.cur += 1
				yystate = 32
				continue yyl
			case '\r':
				st.yytm5 = add_mtag(&st.trie, st.yytm5, st.cur)
				st.yytm4 = st.yytm3
				st.yytm4 = add_mtag(&st.trie, st.yytm4, st.cur)
				st.cur += 1
				yystate = 34
				continue yyl
			default:
				st.yytm5 = add_mtag(&st.trie, st.yytm5, st.cur)
				st.cur += 1
				yystate = 35
				continue yyl
			}
		case 33:
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,'\t','\n','\v','\f':
				fallthrough
			case 0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E:
				fallthrough
			case 0x7F:
				if (st.cur >= st.lim) {
					st.state = 67
					return lexWaiting
				}
				yystate = 28
				continue yyl
			case '\r':
				st.yytm3 = add_mtag(&st.trie, st.yytm3, st.cur)
				st.cur += 1
				yystate = 30
				continue yyl
			default:
				st.cur += 1
				yystate = 31
				continue yyl
			}
		case 34:
			yych = st.data[st.cur]
			switch (yych) {
			case '\n':
				st.cur += 1
				yystate = 36
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 68
					return lexWaiting
				}
				yystate = 28
				continue yyl
			}
		case 35:
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08:
				fallthrough
			case '\n','\v','\f':
				fallthrough
			case 0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E:
				fallthrough
			case 0x7F:
				if (st.cur >= st.lim) {
					st.state = 69
					return lexWaiting
				}
				yystate = 28
				continue yyl
			case '\t':
				st.cur += 1
				yystate = 38
				continue yyl
			case '\r':
				st.yytm4 = st.yytm3
				st.yytm4 = add_mtag(&st.trie, st.yytm4, st.cur)
				st.cur += 1
				yystate = 34
				continue yyl
			default:
				st.cur += 1
				yystate = 35
				continue yyl
			}
		case 36:
			st.accept = 1
			st.mar = st.cur
			yych = st.data[st.cur]
			switch (yych) {
			case '\t':
				fallthrough
			case ' ':
				st.yytm1 = st.yytm3
				st.yytm2 = st.yytm5
				st.yytm3 = st.yytm4
				st.cur += 1
				yystate = 32
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 70
					return lexWaiting
				}
				st.yytm1 = st.yytm3
				st.yytm2 = st.yytm5
				yystate = 37
				continue yyl
			}
		case 37:
			f1 = st.yytm1
			f2 = st.yytm2
			st.state = yycheader
//line "codegen/go/loop_switch/advanced.re":175
			{
			folds := unwind(st.trie, f1, f2, st.data)
			if debug {fmt.Printf("folds: %v\n", folds)}

			st.tok = st.cur
			goto loop
		}
//line "codegen/go/loop_switch/advanced.go":1033
		case 38:
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08:
				fallthrough
			case '\n','\v','\f':
				fallthrough
			case 0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E:
				fallthrough
			case 0x7F:
				if (st.cur >= st.lim) {
					st.state = 71
					return lexWaiting
				}
				yystate = 28
				continue yyl
			case '\t':
				st.cur += 1
				yystate = 38
				continue yyl
			case '\r':
				st.cur += 1
				yystate = 39
				continue yyl
			case ' ':
				st.cur += 1
				yystate = 35
				continue yyl
			default:
				st.cur += 1
				yystate = 40
				continue yyl
			}
		case 39:
			yych = st.data[st.cur]
			switch (yych) {
			case '\n':
				st.cur += 1
				yystate = 41
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 72
					return lexWaiting
				}
				yystate = 28
				continue yyl
			}
		case 40:
			yych = st.data[st.cur]
			switch (yych) {
			case 0x00:
				fallthrough
			case 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08:
				fallthrough
			case '\n','\v','\f':
				fallthrough
			case 0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E:
				fallthrough
			case 0x7F:
				if (st.cur >= st.lim) {
					st.state = 73
					return lexWaiting
				}
				yystate = 28
				continue yyl
			case '\t':
				st.cur += 1
				yystate = 42
				continue yyl
			case '\r':
				st.yytm4 = st.yytm3
				st.yytm4 = add_mtag(&st.trie, st.yytm4, st.cur)
				st.cur += 1
				yystate = 34
				continue yyl
			default:
				st.cur += 1
				yystate = 35
				continue yyl
			}
		case 41:
			st.yytm1 = st.yytm3
			st.yytm2 = st.yytm5
			yystate = 37
			continue yyl
		case 42:
			yych = st.data[st.cur]
			switch (yych) {
			case '\t':
				fallthrough
			case ' ':
				st.cur += 1
				yystate = 42
				continue yyl
			case '\r':
				st.cur += 1
				yystate = 39
				continue yyl
			default:
				if (st.cur >= st.lim) {
					st.state = 74
					return lexWaiting
				}
				yystate = 28
				continue yyl
			}
		case 43:
			st.state = yycheader
//line "codegen/go/loop_switch/advanced.re":183
			{ return lexEnd }
//line "codegen/go/loop_switch/advanced.go":1147
		case 44:
			if (st.cur >= st.lim) {
				yystate = 21
				continue yyl
			}
			yystate = 0
			continue yyl
		case 45:
			if (st.cur >= st.lim) {
				yystate = 2
				continue yyl
			}
			yystate = 3
			continue yyl
		case 46:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 4
			continue yyl
		case 47:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 7
			continue yyl
		case 48:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 8
			continue yyl
		case 49:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 10
			continue yyl
		case 50:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 11
			continue yyl
		case 51:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 12
			continue yyl
		case 52:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 14
			continue yyl
		case 53:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 15
			continue yyl
		case 54:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 16
			continue yyl
		case 55:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 17
			continue yyl
		case 56:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 18
			continue yyl
		case 57:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 19
			continue yyl
		case 58:
			if (st.cur >= st.lim) {
				yystate = 6
				continue yyl
			}
			yystate = 20
			continue yyl
		case 59:
			if (st.cur >= st.lim) {
				yystate = 43
				continue yyl
			}
			yystate = 22
			continue yyl
		case 60:
			if (st.cur >= st.lim) {
				yystate = 24
				continue yyl
			}
			yystate = 25
			continue yyl
		case 61:
			if (st.cur >= st.lim) {
				yystate = 24
				continue yyl
			}
			yystate = 26
			continue yyl
		case 62:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 27
			continue yyl
		case 63:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 29
			continue yyl
		case 64:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 30
			continue yyl
		case 65:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 31
			continue yyl
		case 66:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 32
			continue yyl
		case 67:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 33
			continue yyl
		case 68:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 34
			continue yyl
		case 69:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 35
			continue yyl
		case 70:
			if (st.cur >= st.lim) {
				st.yytm1 = st.yytm3
				st.yytm2 = st.yytm5
				yystate = 37
				continue yyl
			}
			yystate = 36
			continue yyl
		case 71:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 38
			continue yyl
		case 72:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 39
			continue yyl
		case 73:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 40
			continue yyl
		case 74:
			if (st.cur >= st.lim) {
				yystate = 28
				continue yyl
			}
			yystate = 42
			continue yyl
		default:
			panic("internal lexer error")
		}
	}
}
//line "codegen/go/loop_switch/advanced.re":185

}

func test(packets []string) int {
	fname := "pipe"
	fw, _ := os.Create(fname);
	fr, _ := os.Open(fname);

	st := &State{
		file:   fr,
		data:   make([]byte, SIZE+1),
		cur:    SIZE,
		mar:    SIZE,
		tok:    SIZE,
		lim:    SIZE,
		cond:   yycmedia_type,
		state:  -1,
		trie:   make([]mtagElem, 0),
		
//line "codegen/go/loop_switch/advanced.go":1392

		yyt1: tagNone,
		yyt2: tagNone,
//line "codegen/go/loop_switch/advanced.re":203

		
//line "codegen/go/loop_switch/advanced.go":1399

		yytm1: mtagRoot,
		yytm10: mtagRoot,
		yytm2: mtagRoot,
		yytm3: mtagRoot,
		yytm4: mtagRoot,
		yytm5: mtagRoot,
		yytm6: mtagRoot,
		yytm7: mtagRoot,
		yytm8: mtagRoot,
		yytm9: mtagRoot,
//line "codegen/go/loop_switch/advanced.re":204

		accept: 0,
	}
	// data is zero-initialized, no need to write sentinel

	var status int
	send := 0
loop:
	for {
		status = lex(st)
		if status == lexEnd {
			//fmt.Printf("ok, done\n")
			break loop
		} else if status == lexWaiting {
			//fmt.Printf("need more input\n")
			if send < len(packets) {
				//fmt.Printf("sending %d-th packet '%s'\n", send, packets[send])
				fw.WriteString(packets[send])
				send += 1
			}
			status = fill(st)
			if status != lexReady {
				break loop
			}
			//fmt.Printf("refilled buffer, ready to continue\n")
		} else if status == lexBadPacket {
			//fmt.Printf("bad packet\n")
			break loop
		} else {
			panic("unexpected status")
		}
	}

	fr.Close()
	fw.Close()
	os.Remove(fname)

	return status
}

func main() {
	packets := []string{"ap", "plication/j", "son;", " charset=\"", "utf\\\"-8\"\r", "\n", ""}
	if test(packets) != lexEnd { panic("error") }
}
