% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsne.R
\name{tsne}
\alias{tsne}
\title{t-SNE Embedding}
\usage{
tsne(data, ndim = 2, ...)
}
\arguments{
\item{data}{an \eqn{(n\times p)} matrix whose rows are observations.}

\item{ndim}{an integer-valued target dimension.}

\item{...}{extra parameters to be used in \code{\link[Rtsne]{Rtsne}} function.}
}
\value{
a named list containing
\describe{
\item{embed}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{stress}{discrepancy between embedded and origianl data as a measure of error.}
}
}
\description{
This function is a simple wrapper of \code{\link[Rtsne]{Rtsne}} function for 
t-Stochastic Neighbor Embedding for finding low-dimensional structure of 
the data embedded in the high-dimensional space.
}
\examples{
\donttest{
## use simple example of iris dataset 
data(iris) 
mydat = as.matrix(iris[,1:4])
mylab = as.factor(iris[,5])

## run t-SNE and MDS for comparison
iris.cmds = cmds(mydat, ndim=2)
iris.tsne = tsne(mydat, ndim=2)

## extract coordinates and class information
cx = iris.cmds$embed # embedded coordinates of CMDS
tx = iris.tsne$embed #                         t-SNE

## visualize
#  main title
mc = paste("CMDS with STRESS=",round(iris.cmds$stress,4),sep="")
mt = paste("tSNE with STRESS=",round(iris.tsne$stress,4),sep="")

#  draw a figure
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(cx, col=mylab, pch=19, main=mc)
plot(tx, col=mylab, pch=19, main=mt)
par(opar)
}

}
