/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */

/* -- THIS FILE IS AUTO-GENERATED -- */

#include "mpiimpl.h"

/* -- Begin Profiling Symbol Block for routine MPI_Abi_set_fortran_info */
#if defined(HAVE_PRAGMA_WEAK)
#pragma weak MPI_Abi_set_fortran_info = PMPI_Abi_set_fortran_info
#elif defined(HAVE_PRAGMA_HP_SEC_DEF)
#pragma _HP_SECONDARY_DEF PMPI_Abi_set_fortran_info  MPI_Abi_set_fortran_info
#elif defined(HAVE_PRAGMA_CRI_DUP)
#pragma _CRI duplicate MPI_Abi_set_fortran_info as PMPI_Abi_set_fortran_info
#elif defined(HAVE_WEAK_ATTRIBUTE)
int MPI_Abi_set_fortran_info(MPI_Info info)
     __attribute__ ((weak, alias("PMPI_Abi_set_fortran_info")));
#endif
/* -- End Profiling Symbol Block */

/* Define MPICH_MPI_FROM_PMPI if weak symbols are not supported to build
   the MPI routines */
#ifndef MPICH_MPI_FROM_PMPI
#undef MPI_Abi_set_fortran_info
#define MPI_Abi_set_fortran_info PMPI_Abi_set_fortran_info
#endif /* MPICH_MPI_FROM_PMPI */

static int internal_Abi_set_fortran_info(MPI_Info info)
{
    int mpi_errno = MPI_SUCCESS;
    MPIR_Info *info_ptr ATTRIBUTE((unused)) = NULL;

    MPIR_ERRTEST_INITIALIZED_ORDIE();

    MPID_THREAD_CS_ENTER(GLOBAL, MPIR_THREAD_GLOBAL_ALLFUNC_MUTEX);
    MPIR_FUNC_TERSE_ENTER;

#ifdef HAVE_ERROR_CHECKING
    {
        MPID_BEGIN_ERROR_CHECKS;
        {
            MPIR_ERRTEST_INFO_OR_NULL(info, mpi_errno);
        }
        MPID_END_ERROR_CHECKS;
    }
#endif /* HAVE_ERROR_CHECKING */

    if (info != MPI_INFO_NULL) {
        MPIR_Info_get_ptr(info, info_ptr);
    }

#ifdef HAVE_ERROR_CHECKING
    {
        MPID_BEGIN_ERROR_CHECKS;
        {
            if (info != MPI_INFO_NULL) {
                MPIR_Info_valid_ptr(info_ptr, mpi_errno);
                if (mpi_errno) {
                    goto fn_fail;
                }
            }
        }
        MPID_END_ERROR_CHECKS;
    }
#endif /* HAVE_ERROR_CHECKING */

    /* ... body of routine ... */
    mpi_errno = MPIR_Abi_set_fortran_info_impl(info_ptr);
    if (mpi_errno) {
        goto fn_fail;
    }
    /* ... end of body of routine ... */

  fn_exit:
    MPIR_FUNC_TERSE_EXIT;

    MPID_THREAD_CS_EXIT(GLOBAL, MPIR_THREAD_GLOBAL_ALLFUNC_MUTEX);
    return mpi_errno;

  fn_fail:
    /* --BEGIN ERROR HANDLINE-- */
#ifdef HAVE_ERROR_CHECKING
    mpi_errno = MPIR_Err_create_code(mpi_errno, MPIR_ERR_RECOVERABLE, __func__, __LINE__, MPI_ERR_OTHER,
                                     "**mpi_abi_set_fortran_info", "**mpi_abi_set_fortran_info %I",
                                     info);
#endif
    mpi_errno = MPIR_Err_return_comm(0, __func__, mpi_errno);
    /* --END ERROR HANDLING-- */
    goto fn_exit;
}

#ifdef ENABLE_QMPI
#ifndef MPICH_MPI_FROM_PMPI
int QMPI_Abi_set_fortran_info(QMPI_Context context, int tool_id, MPI_Info info)
{
    return internal_Abi_set_fortran_info(info);
}
#endif /* MPICH_MPI_FROM_PMPI */
int MPI_Abi_set_fortran_info(MPI_Info info)
{
    QMPI_Context context;
    QMPI_Abi_set_fortran_info_t *fn_ptr;

    context.storage_stack = NULL;

    if (MPIR_QMPI_num_tools == 0)
        return QMPI_Abi_set_fortran_info(context, 0, info);

    fn_ptr = (QMPI_Abi_set_fortran_info_t *) MPIR_QMPI_first_fn_ptrs[MPI_ABI_SET_FORTRAN_INFO_T];

    return (*fn_ptr) (context, MPIR_QMPI_first_tool_ids[MPI_ABI_SET_FORTRAN_INFO_T], info);
}
#else /* ENABLE_QMPI */
int MPI_Abi_set_fortran_info(MPI_Info info)
{
    return internal_Abi_set_fortran_info(info);
}

#endif /* ENABLE_QMPI */
