<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'TopicSubscriptions' => [ 'TopicSubscriptions' ],
	'FindComment' => [ 'FindComment' ],
	'GoToComment' => [ 'GoToComment' ],
	'DiscussionToolsDebug' => [ 'DiscussionToolsDebug' ],
];

/** Bengali (বাংলা) */
$specialPageAliases['bn'] = [
	'TopicSubscriptions' => [ 'আলোচনা_অনুসরণ' ],
	'FindComment' => [ 'মন্তব্য_খুঁজুন' ],
	'GoToComment' => [ 'মন্তব্যে_চলুন' ],
];

/** Czech (čeština) */
$specialPageAliases['cs'] = [
	'TopicSubscriptions' => [ 'Odebíraná_témata' ],
	'FindComment' => [ 'Najít_komentář' ],
	'GoToComment' => [ 'Přejít_na_komentář' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'TopicSubscriptions' => [ 'Themenbezogene_Abonnements' ],
	'FindComment' => [ 'Kommentar_finden' ],
	'GoToComment' => [ 'Gehe_zu_Kommentar' ],
];

/** Spanish (español) */
$specialPageAliases['es'] = [
	'TopicSubscriptions' => [ 'Suscripciones_a_temas' ],
	'FindComment' => [ 'Encontrar_comentario' ],
	'GoToComment' => [ 'Ir_a_comentario' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'TopicSubscriptions' => [ 'מינויים_לנושאים' ],
	'FindComment' => [ 'מציאת_תגובה' ],
	'GoToComment' => [ 'מעבר_לתגובה' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'TopicSubscriptions' => [ '구독하는주제' ],
	'FindComment' => [ '댓글찾기' ],
	'GoToComment' => [ '댓글로가기' ],
];

/** Polish (polski) */
$specialPageAliases['pl'] = [
	'TopicSubscriptions' => [ 'Subskrypcje_wątków', 'Subskrybowane_wątki' ],
	'FindComment' => [ 'Znajdź_komentarz' ],
	'GoToComment' => [ 'Przejdź_do_komentarza' ],
];

/** Urdu (اردو) */
$specialPageAliases['ur'] = [
	'TopicSubscriptions' => [ 'گفتگو_میں_شرکت' ],
	'FindComment' => [ 'تلاش_تبصرہ' ],
	'GoToComment' => [ 'تبصرہ_پر_جائیں' ],
	'DiscussionToolsDebug' => [ 'آلات_گفتگو_کی_خرابی_کا_ازالہ' ],
];

/** Simplified Chinese (中文（简体）) */
$specialPageAliases['zh-hans'] = [
	'TopicSubscriptions' => [ '话题订阅' ],
	'FindComment' => [ '查找留言' ],
	'GoToComment' => [ '转到留言' ],
	'DiscussionToolsDebug' => [ '讨论工具调试' ],
];
