/*
 * Copyright 2017 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
/*****************************************************************************************
 ******************** This file was generated by sksllex. Do not edit. *******************
 *****************************************************************************************/
#include "src/sksl/SkSLLexer.h"

namespace SkSL {

using State = uint16_t;
static constexpr uint8_t kInvalidChar = 18;
static constexpr uint8_t kMappings[118] = {
        1,  2,  3,  3,  1,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
        3,  3,  3,  1,  4,  3,  5,  6,  7,  8,  3,  9,  10, 11, 12, 13, 14, 15, 16, 17,
        18, 19, 20, 21, 22, 22, 22, 23, 23, 24, 25, 26, 27, 28, 29, 3,  30, 31, 32, 33,
        34, 35, 36, 36, 37, 36, 36, 36, 38, 36, 36, 36, 36, 39, 40, 36, 41, 36, 36, 42,
        36, 36, 43, 3,  44, 45, 46, 3,  47, 48, 49, 50, 51, 52, 53, 54, 55, 36, 56, 57,
        58, 59, 60, 61, 36, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
};
using IndexEntry = int16_t;
struct FullEntry {
    State data[75];
};
struct CompactEntry {
    uint32_t values;
    uint8_t data[19];
};
static constexpr FullEntry kFull[] = {
        {
                0,   2,   3,   4,   5,   7,   9,   23,  25,  28,  29,  30,  32,  35,  36,
                39,  44,  50,  69,  69,  69,  69,  69,  69,  71,  72,  73,  77,  79,  83,
                84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  86,  87,
                88,  84,  91,  104, 114, 130, 155, 167, 183, 188, 196, 84,  287, 297, 304,
                330, 335, 361, 373, 484, 527, 558, 570, 84,  84,  84,  591, 592, 595, 596,
        },
        {
                0,  0,  0,  0,  0,  0, 0, 0, 0,  0, 0, 0,  0, 0,  0, 51, 0, 59, 59,
                59, 59, 59, 59, 60, 0, 0, 0, 0,  0, 0, 0,  0, 0,  0, 61, 0, 0,  0,
                0,  0,  0,  66, 67, 0, 0, 0, 0,  0, 0, 0,  0, 61, 0, 0,  0, 0,  0,
                0,  0,  0,  0,  0,  0, 0, 0, 66, 0, 0, 67, 0, 0,  0, 0,  0, 0,
        },
        {
                0,  0,  0,  0,  0,  0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 51, 0, 59, 59,
                59, 59, 59, 59, 60, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 61, 0, 0,  0,
                0,  0,  0,  65, 0,  0, 0, 0, 0,  0, 0, 0, 0, 61, 0, 0,  0, 0,  0,
                0,  0,  0,  0,  0,  0, 0, 0, 65, 0, 0, 0, 0, 0,  0, 0,  0, 0,
        },
        {
                0,  0,  0,  0,  0,  0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 51, 0, 60, 60,
                60, 60, 60, 60, 60, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 61, 0, 0,  0,
                0,  0,  0,  64, 0,  0, 0, 0, 0,  0, 0, 0, 0, 61, 0, 0,  0, 0,  0,
                0,  0,  0,  0,  0,  0, 0, 0, 64, 0, 0, 0, 0, 0,  0, 0,  0, 0,
        },
        {
                0,  0,  0,  0,  0,  0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 51, 0, 70, 70,
                70, 70, 70, 70, 70, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 61, 0, 0,  0,
                0,  0,  0,  66, 0,  0, 0, 0, 0,  0, 0, 0, 0, 61, 0, 0,  0, 0,  0,
                0,  0,  0,  0,  0,  0, 0, 0, 66, 0, 0, 0, 0, 0,  0, 0,  0, 0,
        },
        {
                0,   0,  0,  0,   0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  85, 85,
                85,  85, 85, 85,  85, 0,  0,  0,  0,  0,   0,  85, 85, 85, 85, 85, 85, 85, 85,
                85,  85, 85, 85,  85, 0,  0,  0,  85, 115, 85, 85, 85, 85, 85, 85, 85, 85, 85,
                118, 85, 85, 121, 85, 85, 85, 85, 85, 85,  85, 85, 85, 85, 0,  0,  0,  0,
        },
        {
                0,  0,   0,  0,   0,  0,  0,  0,  0,  0,   0,  0,  0,  0,   0,  0,  0,  85,  85,
                85, 85,  85, 85,  85, 0,  0,  0,  0,  0,   0,  85, 85, 85,  85, 85, 85, 85,  85,
                85, 85,  85, 85,  85, 0,  0,  0,  85, 85,  85, 85, 85, 131, 85, 85, 85, 137, 85,
                85, 143, 85, 148, 85, 85, 85, 85, 85, 152, 85, 85, 85, 85,  0,  0,  0,  0,
        },
        {
                0,   0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  85, 85,
                85,  85, 85,  85, 85, 0,  0,  0,  0,  0,  0,  85,  85, 85, 85, 85, 85, 85, 85,
                85,  85, 85,  85, 85, 0,  0,  0,  85, 85, 85, 85,  85, 85, 85, 85, 85, 85, 85,
                156, 85, 159, 85, 85, 85, 85, 85, 85, 85, 85, 161, 85, 85, 0,  0,  0,  0,
        },
        {
                0,   0,  0,  0,   0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  85,  85,
                85,  85, 85, 85,  85, 0,  0,  0,  0,  0,   0,  85, 85, 85, 85, 85, 85, 85,  85,
                85,  85, 85, 85,  85, 0,  0,  0,  85, 168, 85, 85, 85, 85, 85, 85, 85, 172, 85,
                175, 85, 85, 178, 85, 85, 85, 85, 85, 180, 85, 85, 85, 85, 0,  0,  0,  0,
        },
        {
                0,  0,   0,   0,  0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,   0,  0,  85,  85,
                85, 85,  85,  85, 85, 0,  0,   0,   0,  0,  0,  85, 85, 85, 85,  85, 85, 85,  85,
                85, 85,  85,  85, 85, 0,  0,   0,   85, 85, 85, 85, 85, 85, 197, 85, 85, 198, 85,
                85, 238, 241, 85, 85, 85, 263, 281, 85, 85, 85, 85, 85, 85, 0,   0,  0,  0,
        },
        {
                0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0,  0,  85, 203,
                209, 224, 85, 85, 85, 0,  0,  0,  0,  0,  0,  85, 225, 230, 85, 85, 85, 85, 85,
                85,  85,  85, 85, 85, 0,  0,  0,  85, 85, 85, 85, 85,  85,  85, 85, 85, 85, 85,
                85,  85,  85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,  85,  0,  0,  0,  0,
        },
        {
                0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  85, 85,
                85,  85,  85, 85, 85, 0,  0,  0,  0,  0,  0,  211, 85, 85, 85, 85, 85, 85, 85,
                215, 221, 85, 85, 85, 0,  0,  0,  85, 85, 85, 85,  85, 85, 85, 85, 85, 85, 85,
                85,  85,  85, 85, 85, 85, 85, 85, 85, 85, 85, 85,  85, 85, 0,  0,  0,  0,
        },
        {
                0,   0,  0,  0,   0,   0,  0,  0,   0,  0,   0,  0,  0,  0,  0,  0,  0,  85, 85,
                85,  85, 85, 85,  85,  0,  0,  0,   0,  0,   0,  85, 85, 85, 85, 85, 85, 85, 85,
                85,  85, 85, 85,  85,  0,  0,  0,   85, 85,  85, 85, 85, 85, 85, 85, 85, 85, 85,
                242, 85, 85, 246, 249, 85, 85, 251, 85, 257, 85, 85, 85, 85, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,  0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,  85,  85,
                85, 85, 85, 85, 85, 0,   0,  0,  0,   0,   0,  85, 85, 85, 85, 85, 85, 85,  85,
                85, 85, 85, 85, 85, 0,   0,  0,  85,  336, 85, 85, 85, 85, 85, 85, 85, 340, 85,
                85, 85, 85, 85, 85, 350, 85, 85, 357, 85,  85, 85, 85, 85, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0,  0,  85,  85,
                85, 85, 85, 85, 85, 0,  0,  0,   0,   0,   0,   85, 85, 85, 85, 85, 85, 85,  85,
                85, 85, 85, 85, 85, 0,  0,  0,   85,  374, 85,  85, 85, 85, 85, 85, 85, 463, 85,
                85, 85, 85, 85, 85, 85, 85, 467, 475, 85,  479, 85, 85, 85, 0,  0,  0,  0,
        },
        {
                0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0,  0,  85, 380,
                397, 429, 85,  85, 85, 0,  0,  0,  0,  0,  0,  85, 434, 439, 85, 85, 85, 85, 85,
                85,  85,  458, 85, 85, 0,  0,  0,  85, 85, 85, 85, 85,  85,  85, 85, 85, 85, 85,
                85,  85,  85,  85, 85, 85, 85, 85, 85, 85, 85, 85, 85,  85,  0,  0,  0,  0,
        },
        {
                0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  85, 85,
                85,  85,  85,  85, 85, 0,  0,  0,  0,  0,  0,  399, 85, 85, 85, 85, 85, 85, 85,
                409, 415, 424, 85, 85, 0,  0,  0,  85, 85, 85, 85,  85, 85, 85, 85, 85, 85, 85,
                85,  85,  85,  85, 85, 85, 85, 85, 85, 85, 85, 85,  85, 85, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,   0,   0,  0,  0,   85, 85,
                85, 85, 85, 85, 85, 0,   0,  0,  0,  0,  0,  85, 85,  85,  85, 85, 85,  85, 85,
                85, 85, 85, 85, 85, 0,   0,  0,  85, 85, 85, 85, 85,  485, 85, 85, 517, 85, 85,
                85, 85, 85, 85, 85, 519, 85, 85, 85, 85, 85, 85, 522, 85,  0,  0,  0,   0,
        },
        {
                0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0,  0,  85, 496,
                502, 508, 85, 85, 85, 0,  0,  0,  0,  0,  0,  85, 434, 509, 85, 85, 85, 85, 85,
                85,  85,  85, 85, 85, 0,  0,  0,  85, 85, 85, 85, 85,  85,  85, 85, 85, 85, 85,
                85,  85,  85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,  85,  0,  0,  0,  0,
        },
        {
                0,  0,  0,   0,  0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  85,  85,
                85, 85, 85,  85, 85, 0,  0,   0,   0,  0,  0,  85, 85, 85, 85, 85, 85, 85,  85,
                85, 85, 85,  85, 85, 0,  0,   0,   85, 85, 85, 85, 85, 85, 85, 85, 85, 528, 85,
                85, 85, 532, 85, 85, 85, 544, 552, 85, 85, 85, 85, 85, 85, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,  85,  85,
                85, 85, 85, 85, 85, 0,  0,  0,  0,   0,   0,  85, 85, 85, 85, 85, 85, 85,  85,
                85, 85, 85, 85, 85, 0,  0,  0,  85,  545, 85, 85, 85, 85, 85, 85, 85, 550, 85,
                85, 85, 85, 85, 85, 85, 85, 85, 269, 85,  85, 85, 85, 85, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,   0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   85, 85,
                85, 85, 85, 85,  85, 0,   0,  0,  0,  0,  0,  85, 85, 85, 85, 85, 85,  85, 85,
                85, 85, 85, 85,  85, 0,   0,  0,  85, 85, 85, 85, 85, 85, 85, 85, 571, 85, 85,
                85, 85, 85, 575, 85, 583, 85, 85, 85, 85, 85, 85, 85, 85, 0,  0,  0,   0,
        },
};
static constexpr CompactEntry kCompact[] = {
        {0,
         {255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {3,
         {195,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {6,
         {255,
          255,
          255,
          255,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {8, {255, 255, 255, 255, 255, 255, 255, 15, 0, 0, 192, 15, 0, 0, 0, 0, 0, 192, 63}},
        {8, {255, 255, 255, 255, 3, 0, 255, 15, 0, 0, 192, 15, 0, 0, 0, 0, 0, 192, 63}},
        {19 | (11 << 10) | (10 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          106,
          170,
          170,
          162,
          170,
          234,
          63}},
        {10, {255, 255, 255, 255, 3, 0, 255, 15, 0, 0, 192, 15, 0, 0, 0, 0, 0, 192, 63}},
        {14 | (12 << 10) | (10 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          170,
          170,
          106,
          170,
          232,
          63}},
        {13 | (10 << 10),
         {255, 255, 255, 255, 87, 84, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {15 | (10 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {16 | (10 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {17 | (10 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {18 | (10 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {20 | (10 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {21 | (10 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {22 | (10 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {24,
         {255,
          255,
          255,
          255,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {27 | (26 << 10),
         {255,
          255,
          253,
          255,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {31,
         {255,
          255,
          255,
          255,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {34 | (33 << 10),
         {255,
          255,
          255,
          253,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {38 | (37 << 10),
         {255,
          255,
          255,
          223,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {40,
         {255,
          255,
          255,
          255,
          3,
          0,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {41 | (40 << 10),
         {255,
          255,
          255,
          255,
          87,
          85,
          255,
          255,
          207,
          255,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          63}},
        {43 | (42 << 10),
         {255,
          255,
          255,
          221,
          3,
          0,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {43,
         {255,
          255,
          255,
          255,
          3,
          0,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {49 | (48 << 10) | (45 << 20),
         {255,
          255,
          191,
          255,
          253,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {46 | (45 << 10),
         {87, 85, 21, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 21}},
        {47 | (45 << 10),
         {87, 85, 85, 85, 84, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 21}},
        {48, {51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
        {56 | (52 << 10),
         {255,
          255,
          255,
          255,
          87,
          85,
          255,
          255,
          207,
          255,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          63}},
        {53 | (52 << 10),
         {255,
          255,
          255,
          255,
          87,
          85,
          255,
          255,
          207,
          255,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          63}},
        {55 | (54 << 10),
         {255,
          255,
          255,
          221,
          3,
          0,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {55,
         {255,
          255,
          255,
          255,
          3,
          0,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {58 | (57 << 10),
         {255,
          255,
          255,
          221,
          3,
          0,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {58,
         {255,
          255,
          255,
          255,
          3,
          0,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {63 | (62 << 10),
         {255,
          255,
          255,
          221,
          3,
          0,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {63,
         {255,
          255,
          255,
          255,
          3,
          0,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {68, {255, 255, 255, 255, 3, 0, 255, 15, 0, 255, 255, 63, 0, 252, 255, 255, 255, 255, 63}},
        {68 | (66 << 10),
         {255, 255, 255, 255, 3, 0, 255, 15, 0, 255, 247, 63, 0, 252, 255, 255, 247, 255, 63}},
        {76 | (74 << 10),
         {255,
          255,
          255,
          255,
          255,
          255,
          31,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {75,
         {255,
          255,
          255,
          255,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {78,
         {255,
          255,
          255,
          255,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {81 | (80 << 10),
         {255,
          255,
          255,
          255,
          255,
          255,
          127,
          252,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {82,
         {255,
          255,
          255,
          255,
          255,
          255,
          63,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {85, {255, 255, 255, 255, 3, 0, 255, 15, 0, 0, 192, 15, 0, 0, 0, 0, 0, 192, 63}},
        {90 | (89 << 10),
         {255,
          255,
          255,
          255,
          255,
          255,
          127,
          255,
          255,
          255,
          255,
          243,
          255,
          255,
          255,
          255,
          255,
          255,
          63}},
        {94 | (92 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          170,
          170,
          106,
          168,
          234,
          63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {98 | (95 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          170,
          170,
          169,
          168,
          234,
          63}},
        {96 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {97 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {99 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {100 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {101 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 84, 85, 85, 85, 85, 213, 63}},
        {102 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {103 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {109 | (105 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          170,
          170,
          154,
          162,
          234,
          63}},
        {106 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {107 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {108 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 84, 85, 85, 213, 63}},
        {110 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {111 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {112 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {113 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {116 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {117 | (93 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          42,
          170,
          170,
          170,
          169,
          234,
          63}},
        {119 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {120 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {122 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {125 | (123 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          170,
          170,
          106,
          168,
          234,
          63}},
        {124 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {126 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {127 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {128 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {129 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {132 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {133 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {134 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {135 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {136 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {138 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {139 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {140 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {141 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {142 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {144 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {145 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {146 | (85 << 10),
         {255, 255, 255, 255, 23, 80, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {147 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 212, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 23, 80, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {149 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {150 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 84, 85, 85, 85, 85, 213, 63}},
        {151 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {153 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {154 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {157 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {158 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {160 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {162 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {163 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {164 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {165 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {166 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {169 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {170 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {171 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {173 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 212, 63}},
        {174 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {176 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {177 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {179 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {181 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {182 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {186 | (184 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          170,
          166,
          168,
          170,
          234,
          63}},
        {185 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 79, 85, 85, 85, 85, 85, 213, 63}},
        {185, {255, 255, 255, 255, 3, 0, 255, 15, 0, 0, 192, 15, 0, 0, 0, 0, 0, 192, 63}},
        {187 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {193 | (189 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          106,
          170,
          170,
          138,
          234,
          63}},
        {190 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 81, 85, 85, 85, 213, 63}},
        {191 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {192 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {194 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {195 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {199 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {200 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {201 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 81, 85, 85, 85, 213, 63}},
        {202 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {204 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 81, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {205 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 79, 85, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {206 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {207 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {208 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {210 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 81, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {212 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {213 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {214 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {216 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 212, 95, 85, 85, 85, 85, 85, 213, 63}},
        {217 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 79, 85, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {218 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {219 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {220 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {222 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {223 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 81, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {226 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {227 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {228 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {229 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {231 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {232 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 84, 85, 85, 85, 85, 213, 63}},
        {233 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {234 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 79, 85, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {235 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {236 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {237 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {239 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {240 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 81, 85, 85, 85, 213, 63}},
        {243 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {244 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {245 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {247 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {248 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {250 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {252 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {253 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {254 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {255 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {256 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {258 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {259 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {260 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {261 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {262 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {269 | (264 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          111,
          170,
          170,
          170,
          170,
          162,
          234,
          63}},
        {265 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {266 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {267 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {268 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {202 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {270 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 84, 85, 85, 85, 85, 213, 63}},
        {271 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {272 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {273 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {274 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {275 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 81, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {276 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {277 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {278 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {279 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {280 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 69, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 212, 95, 85, 85, 85, 85, 85, 213, 63}},
        {282 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {283 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 212, 63}},
        {284 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {285 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {286 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {293 | (288 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          111,
          170,
          170,
          170,
          168,
          170,
          234,
          63}},
        {289 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {290 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {291 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {292 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {295 | (294 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          170,
          106,
          170,
          42,
          234,
          63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 81, 85, 85, 85, 213, 63}},
        {296 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {298 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {299 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {300 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {301 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {302 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {303 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {312 | (305 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          111,
          170,
          170,
          170,
          168,
          170,
          234,
          63}},
        {306 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {307 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {308 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {309 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {310 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {311 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {319 | (313 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          106,
          170,
          162,
          170,
          234,
          63}},
        {314 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {315 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {316 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {317 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {318 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {320 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {321 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {322 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {323 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {324 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {325 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {326 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {327 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {328 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 69, 213, 63}},
        {329 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {331 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {332 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {333 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {334 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {337 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {338 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 84, 85, 85, 213, 63}},
        {339 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {341 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 212, 63}},
        {342 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {343 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {344 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 79, 85, 85, 85, 85, 85, 213, 63}},
        {345 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {346 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {347 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {348 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {349 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {351 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {352 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {353 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {354 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {355 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {356 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {358 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 84, 85, 85, 85, 85, 213, 63}},
        {359 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {360 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {362 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {369 | (363 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          111,
          170,
          170,
          170,
          170,
          168,
          234,
          63}},
        {364 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {365 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {366 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {367 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {368 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {370 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {371 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {372 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {375 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {376 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {377 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {378 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {379 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {381 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 81, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {392 | (382 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          159,
          170,
          170,
          232,
          175,
          170,
          170,
          170,
          170,
          170,
          234,
          63}},
        {383 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {384 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {385 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {386 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {387 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 212, 95, 85, 85, 85, 85, 85, 213, 63}},
        {388 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {389 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {390 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {391 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 21, 213, 63}},
        {393 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {394 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {395 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {396 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {398 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 81, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {400 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {401 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {402 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {403 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {404 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 212, 95, 85, 85, 85, 85, 85, 213, 63}},
        {405 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {406 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {407 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {408 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {410 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 212, 95, 85, 85, 85, 85, 85, 213, 63}},
        {411 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 79, 85, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {412 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {413 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {414 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {416 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {417 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {418 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {419 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 212, 95, 85, 85, 85, 85, 85, 213, 63}},
        {420 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {421 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {422 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {423 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {425 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {426 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {427 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {428 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {430 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 81, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {431 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 21, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {432 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {433 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {435 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {436 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {437 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {438 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {440 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {441 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 84, 85, 85, 85, 85, 213, 63}},
        {442 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {453 | (443 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          159,
          170,
          170,
          232,
          175,
          170,
          170,
          170,
          170,
          170,
          234,
          63}},
        {444 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {445 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {446 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {447 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {448 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 212, 95, 85, 85, 85, 85, 85, 213, 63}},
        {449 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {450 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {451 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {452 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {454 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {455 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {456 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {457 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {459 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {460 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {461 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {462 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {464 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 197, 63}},
        {465 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {466 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {471 | (468 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          111,
          170,
          170,
          170,
          138,
          170,
          234,
          63}},
        {469 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {470 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {472 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {473 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {474 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {476 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {477 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {478 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {93 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {480 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {481 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {482 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {483 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {491 | (486 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          170,
          154,
          170,
          170,
          232,
          63}},
        {487 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {488 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {489 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {490 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {492 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {493 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {494 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {495 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {497 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 81, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {498 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 79, 85, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {499 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {500 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {501 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {503 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 81, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {504 | (409 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          143,
          170,
          154,
          234,
          175,
          170,
          170,
          170,
          170,
          170,
          234,
          63}},
        {505 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {506 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {507 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {510 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {511 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 84, 85, 85, 85, 85, 213, 63}},
        {512 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {513 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 79, 85, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {514 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {515 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {516 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {518 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {520 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {521 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {523 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {524 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {525 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {526 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {529 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {530 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {531 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 81, 85, 85, 85, 213, 63}},
        {539 | (533 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          106,
          170,
          42,
          170,
          234,
          63}},
        {538 | (534 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          175,
          170,
          169,
          170,
          168,
          170,
          234,
          63}},
        {535 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {536 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {537 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {540 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {541 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 81, 85, 85, 85, 213, 63}},
        {542 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {543 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {546 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {547 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {548 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {549 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {551 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {553 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {554 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 212, 63}},
        {555 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {556 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {557 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {564 | (559 << 10) | (85 << 20),
         {255,
          255,
          255,
          255,
          171,
          170,
          255,
          175,
          170,
          170,
          234,
          111,
          170,
          170,
          170,
          168,
          170,
          234,
          63}},
        {560 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {561 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {562 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {563 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {565 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {566 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {567 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {568 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {569 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {572 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {573 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {574 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {576 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {577 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 84, 85, 85, 213, 63}},
        {578 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 81, 85, 85, 85, 213, 63}},
        {579 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {580 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {581 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {582 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {584 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {585 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {586 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {587 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {588 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {589 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {590 | (85 << 10),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {594 | (593 << 10),
         {255,
          255,
          255,
          255,
          255,
          255,
          127,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          255,
          60}},
};
static constexpr IndexEntry kIndices[] = {
        0,   -1,  1,   1,   0,   2,   0,   3,   4,   5,   6,   7,   8,   6,   9,   10,  11,  12,
        6,   13,  14,  15,  6,   16,  0,   17,  0,   0,   0,   0,   18,  0,   19,  0,   0,   0,
        20,  0,   0,   21,  22,  23,  24,  24,  25,  26,  27,  0,   28,  0,   -2,  29,  30,  31,
        32,  32,  33,  34,  34,  -3,  -4,  35,  36,  36,  0,   0,   0,   37,  38,  -5,  -5,  0,
        0,   39,  40,  0,   0,   41,  0,   42,  0,   43,  0,   0,   44,  44,  0,   0,   45,  0,
        0,   46,  47,  44,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,
        44,  62,  63,  64,  65,  44,  -6,  66,  67,  44,  68,  69,  70,  71,  72,  73,  44,  74,
        75,  76,  77,  44,  -7,  78,  79,  80,  81,  82,  44,  83,  84,  85,  86,  87,  44,  88,
        89,  90,  91,  92,  93,  94,  95,  57,  96,  97,  92,  -8,  98,  99,  44,  100, 47,  101,
        102, 103, 104, 105, 106, -9,  107, 108, 109, 44,  110, 111, 112, 113, 114, 44,  115, 44,
        116, 117, 92,  118, 119, 120, 121, 122, 123, 124, 125, 126, 44,  127, 128, 92,  -10, 44,
        129, 130, 131, 132, -11, 133, 134, 135, 136, 137, 138, 139, -12, 140, 141, 142, 138, 143,
        144, 145, 146, 147, 138, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160,
        161, 162, 163, 138, 164, 165, 132, -13, 166, 167, 168, 44,  169, 170, 44,  171, 150, 172,
        173, 174, 175, 176, 57,  177, 178, 179, 180, 181, 150, 182, 183, 184, 185, 186, 187, 188,
        189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 132, 205,
        206, 207, 208, 209, 44,  210, 211, 212, 44,  213, 214, 215, 216, 217, 218, 44,  219, 220,
        221, 222, 223, 224, 225, 57,  226, 227, 228, 229, 230, 231, 44,  232, 233, 234, 235, 236,
        237, 238, 239, 240, 241, 44,  242, 243, 244, 245, 150, -14, 246, 247, 248, 112, 249, 250,
        251, 252, 253, 254, 255, 256, 257, 44,  258, 259, 260, 261, 262, 263, 264, 265, 266, 267,
        51,  268, 269, 270, 271, 272, 273, 274, 44,  275, 276, 277, 44,  -15, 278, 279, 280, 281,
        282, -16, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298,
        294, 299, -17, 300, 301, 302, 303, 304, 305, 306, 307, 308, 294, 309, 310, 311, 312, 313,
        138, 314, 315, 316, 317, 318, 319, 320, 321, 294, 322, 323, 324, 325, 294, 326, 327, 328,
        329, 150, 330, 331, 332, 333, 156, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
        345, 346, 294, 347, 348, 349, 350, 294, 351, 352, 353, 354, 294, 355, 356, 357, 358, 359,
        360, 361, 51,  362, 363, 364, 44,  365, 366, 367, 368, 369, 370, 371, 372, 44,  -18, 373,
        374, 375, 376, 377, 57,  378, 379, 380, 381, -19, 382, 383, 384, 385, 386, 138, 387, 388,
        389, 390, 391, 138, 151, 392, 393, 394, 395, 396, 397, 398, 138, 399, 70,  400, 401, 44,
        402, 403, 404, 405, 358, -20, 406, 407, 408, 132, 409, 410, 411, 412, 413, 44,  264, 414,
        415, 416, 417, 112, -21, 418, 419, 420, 421, 187, 422, 211, 423, 424, 425, 426, 427, 132,
        428, 429, 430, 431, 432, 211, 433, 434, 435, 436, 437, 57,  -22, 438, 439, 440, 44,  441,
        442, 443, 444, 445, 446, 447, 44,  448, 449, 450, 451, 452, 453, 454, 44,  0,   455, 0,
        0,   0,   0,
};
static State get_transition(uint8_t transition, State state) {
    IndexEntry index = kIndices[state];
    if (index < 0) {
        return kFull[~index].data[transition];
    }
    const CompactEntry& entry = kCompact[index];
    int v = entry.data[transition >> 2];
    v >>= 2 * (transition & 3);
    v &= 3;
    v *= 10;
    return (entry.values >> v) & 1023;
}
static const uint8_t kAccepts[597] = {
        255, 255, 89,  89, 92, 68,  73,  92,  43, 41, 41, 41, 41, 36,  41,  41, 41,  41,  37, 41,
        41,  41,  27,  58, 82, 63,  67,  87,  44, 45, 56, 80, 54, 52,  78,  51, 55,  53,  79, 50,
        1,   255, 255, 1,  57, 255, 255, 91,  90, 81, 2,  1,  1,  255, 255, 1,  255, 255, 1,  2,
        3,   255, 255, 1,  3,  2,   2,   255, 2,  2,  2,  70, 88, 75,  59,  83, 77,  71,  72, 74,
        76,  60,  84,  69, 42, 42,  48,  49,  62, 86, 66, 42, 42, 40,  42,  42, 42,  42,  42, 42,
        42,  42,  42,  42, 42, 42,  42,  42,  14, 42, 42, 42, 42, 30,  42,  42, 42,  12,  42, 42,
        42,  42,  42,  42, 22, 42,  42,  42,  42, 15, 42, 42, 42, 42,  42,  42, 13,  42,  42, 42,
        42,  42,  16,  42, 42, 42,  40,  42,  10, 42, 42, 42, 42, 42,  42,  42, 42,  42,  7,  42,
        42,  42,  42,  42, 42, 40,  42,  42,  42, 42, 42, 5,  42, 42,  42,  42, 42,  23,  42, 8,
        42,  42,  42,  42, 42, 40,  42,  42,  42, 42, 42, 42, 33, 42,  42,  42, 42,  6,   42, 42,
        42,  42,  42,  42, 40, 42,  42,  42,  42, 42, 40, 42, 42, 42,  42,  42, 40,  42,  42, 42,
        42,  42,  42,  42, 42, 42,  42,  42,  42, 42, 42, 42, 42, 40,  42,  42, 42,  42,  42, 42,
        42,  18,  42,  42, 42, 25,  42,  42,  20, 42, 42, 42, 42, 42,  42,  42, 42,  42,  42, 42,
        42,  42,  42,  42, 42, 42,  42,  42,  42, 42, 42, 42, 42, 42,  42,  42, 42,  42,  42, 40,
        42,  42,  42,  42, 42, 42,  42,  42,  42, 42, 42, 42, 32, 42,  42,  42, 35,  42,  42, 42,
        42,  42,  42,  34, 42, 42,  42,  42,  42, 42, 42, 42, 42, 42,  42,  42, 42,  42,  26, 42,
        42,  42,  42,  42, 42, 42,  42,  42,  42, 24, 42, 42, 19, 42,  42,  42, 42,  42,  42, 42,
        42,  42,  42,  42, 42, 42,  42,  42,  42, 39, 42, 42, 42, 42,  42,  42, 42,  42,  42, 42,
        42,  42,  42,  42, 42, 42,  42,  42,  28, 42, 42, 42, 17, 42,  42,  42, 42,  42,  42, 42,
        42,  40,  42,  42, 42, 42,  40,  42,  42, 42, 42, 42, 42, 42,  42,  42, 42,  42,  42, 42,
        42,  42,  42,  40, 42, 42,  42,  42,  42, 42, 40, 42, 42, 42,  42,  42, 42,  42,  42, 42,
        42,  42,  42,  42, 42, 42,  42,  42,  42, 42, 40, 42, 42, 42,  42,  42, 42,  42,  42, 42,
        42,  42,  40,  42, 42, 42,  42,  40,  42, 42, 42, 42, 42, 42,  42,  42, 42,  42,  42, 42,
        42,  42,  42,  42, 42, 42,  42,  42,  42, 42, 42, 42, 42, 42,  31,  42, 42,  42,  42, 42,
        42,  42,  42,  11, 42, 42,  42,  42,  42, 42, 42, 42, 42, 42,  42,  42, 42,  40,  42, 42,
        42,  42,  42,  42, 42, 42,  42,  42,  42, 42, 42, 42, 40, 42,  42,  42, 42,  42,  42, 42,
        42,  4,   42,  42, 42, 42,  42,  42,  42, 42, 42, 42, 42, 42,  42,  42, 42,  21,  42, 42,
        42,  42,  42,  42, 42, 42,  42,  42,  42, 42, 42, 42, 42, 42,  42,  42, 42,  42,  42, 42,
        42,  42,  42,  42, 42, 42,  42,  42,  42, 42, 42, 42, 42, 42,  9,   42, 42,  42,  42, 42,
        42,  42,  38,  42, 42, 42,  42,  42,  42, 42, 29, 46, 61, 85,  65,  47, 64,
};

Token Lexer::next() {
    // Note that we cheat here: normally a lexer needs to worry about the case
    // where a token has a prefix which is not itself a valid token - for instance,
    // maybe we have a valid token 'while', but 'w', 'wh', etc. are not valid
    // tokens. Our grammar doesn't have this property, so we can simplify the logic
    // a bit.
    int32_t startOffset = fOffset;
    State state = 1;
    for (;;) {
        if (fOffset >= (int32_t)fText.length()) {
            if (startOffset == (int32_t)fText.length() || kAccepts[state] == 255) {
                return Token(Token::Kind::TK_END_OF_FILE, startOffset, 0);
            }
            break;
        }
        uint8_t c = (uint8_t)(fText[fOffset] - 9);
        if (c >= 118) {
            c = kInvalidChar;
        }
        State newState = get_transition(kMappings[c], state);
        if (!newState) {
            break;
        }
        state = newState;
        ++fOffset;
    }
    Token::Kind kind = (Token::Kind)kAccepts[state];
    return Token(kind, startOffset, fOffset - startOffset);
}

}  // namespace SkSL
