/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tinytree.TinyDocumentImpl;
import com.icl.saxon.tinytree.TinyNodeImpl;

final class PrecedingEnumeration
implements AxisEnumeration {
    TinyDocumentImpl document;
    TinyNodeImpl startNode;
    NodeTest test;
    int nextNodeNr;
    int nextAncestorDepth;
    boolean includeAncestors;
    int last = -1;

    public PrecedingEnumeration(TinyDocumentImpl tinyDocumentImpl, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.includeAncestors = bl;
        this.test = nodeTest;
        this.document = tinyDocumentImpl;
        this.startNode = tinyNodeImpl;
        this.nextNodeNr = tinyNodeImpl.nodeNr;
        this.nextAncestorDepth = tinyDocumentImpl.depth[this.nextNodeNr] - 1;
        this.advance();
    }

    public boolean hasMoreElements() {
        return this.nextNodeNr >= 0;
    }

    public NodeInfo nextElement() {
        TinyNodeImpl tinyNodeImpl = this.document.getNode(this.nextNodeNr);
        this.advance();
        return tinyNodeImpl;
    }

    private void advance() {
        do {
            --this.nextNodeNr;
            if (this.includeAncestors) continue;
            while (this.nextNodeNr >= 0 && this.document.depth[this.nextNodeNr] == this.nextAncestorDepth) {
                --this.nextAncestorDepth;
                --this.nextNodeNr;
            }
        } while (this.nextNodeNr >= 0 && !this.test.matches(this.document.nodeType[this.nextNodeNr], this.document.nameCode[this.nextNodeNr]));
    }

    public boolean isSorted() {
        return false;
    }

    public boolean isReverseSorted() {
        return true;
    }

    public boolean isPeer() {
        return false;
    }

    public int getLastPosition() {
        if (this.last >= 0) {
            return this.last;
        }
        PrecedingEnumeration precedingEnumeration = new PrecedingEnumeration(this.document, this.startNode, this.test, this.includeAncestors);
        this.last = 0;
        while (precedingEnumeration.hasMoreElements()) {
            precedingEnumeration.nextElement();
            ++this.last;
        }
        return this.last;
    }
}

