; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=wasm32 -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -mattr=+simd128 | FileCheck %s --check-prefix=SIMD128

define i64 @pairwise_add_v2i64(<2 x i64> %arg) {
; SIMD128-LABEL: pairwise_add_v2i64:
; SIMD128:         .functype pairwise_add_v2i64 (v128) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    i64x2.add $push1=, $0, $pop0
; SIMD128-NEXT:    i64x2.extract_lane $push2=, $pop1, 0
; SIMD128-NEXT:    return $pop2
  %res = tail call i64 @llvm.vector.reduce.add.i64.v4i64(<2 x i64> %arg)
  ret i64 %res
}

define i32 @pairwise_add_v4i32(<4 x i32> %arg) {
; SIMD128-LABEL: pairwise_add_v4i32:
; SIMD128:         .functype pairwise_add_v4i32 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.add $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.add $push2=, $pop4, $pop1
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %arg)
  ret i32 %res
}

define i16 @pairwise_add_v8i16(<8 x i16> %arg) {
; SIMD128-LABEL: pairwise_add_v8i16:
; SIMD128:         .functype pairwise_add_v8i16 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.add $push8=, $0, $pop0
; SIMD128-NEXT:    local.tee $push7=, $0=, $pop8
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.add $push6=, $pop7, $pop1
; SIMD128-NEXT:    local.tee $push5=, $0=, $pop6
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.add $push3=, $pop5, $pop2
; SIMD128-NEXT:    i16x8.extract_lane_u $push4=, $pop3, 0
; SIMD128-NEXT:    return $pop4
  %res = tail call i16 @llvm.vector.reduce.add.v8i16(<8 x i16> %arg)
  ret i16 %res
}

define i8 @pairwise_add_v16i8(<16 x i8> %arg) {
; SIMD128-LABEL: pairwise_add_v16i8:
; SIMD128:         .functype pairwise_add_v16i8 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.add $push11=, $0, $pop0
; SIMD128-NEXT:    local.tee $push10=, $0=, $pop11
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.add $push9=, $pop10, $pop1
; SIMD128-NEXT:    local.tee $push8=, $0=, $pop9
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.add $push7=, $pop8, $pop2
; SIMD128-NEXT:    local.tee $push6=, $0=, $pop7
; SIMD128-NEXT:    i8x16.shuffle $push3=, $0, $0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.add $push4=, $pop6, $pop3
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $pop4, 0
; SIMD128-NEXT:    return $pop5
  %res = tail call i8 @llvm.vector.reduce.add.v16i8(<16 x i8> %arg)
  ret i8 %res
}

define i64 @pairwise_mul_v2i64(<2 x i64> %arg) {
; SIMD128-LABEL: pairwise_mul_v2i64:
; SIMD128:         .functype pairwise_mul_v2i64 (v128) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    i64x2.mul $push1=, $0, $pop0
; SIMD128-NEXT:    i64x2.extract_lane $push2=, $pop1, 0
; SIMD128-NEXT:    return $pop2
  %res = tail call i64 @llvm.vector.reduce.mul.v2i64(<2 x i64> %arg)
  ret i64 %res
}

define i32 @pairwise_mul_v4i32(<4 x i32> %arg) {
; SIMD128-LABEL: pairwise_mul_v4i32:
; SIMD128:         .functype pairwise_mul_v4i32 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.mul $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.mul $push2=, $pop4, $pop1
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call i32 @llvm.vector.reduce.mul.v4i32(<4 x i32> %arg)
  ret i32 %res
}

define i16 @pairwise_mul_v8i16(<8 x i16> %arg) {
; SIMD128-LABEL: pairwise_mul_v8i16:
; SIMD128:         .functype pairwise_mul_v8i16 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.mul $push8=, $0, $pop0
; SIMD128-NEXT:    local.tee $push7=, $0=, $pop8
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.mul $push6=, $pop7, $pop1
; SIMD128-NEXT:    local.tee $push5=, $0=, $pop6
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.mul $push3=, $pop5, $pop2
; SIMD128-NEXT:    i16x8.extract_lane_u $push4=, $pop3, 0
; SIMD128-NEXT:    return $pop4
  %res = tail call i16 @llvm.vector.reduce.mul.v8i16(<8 x i16> %arg)
  ret i16 %res
}

define i8 @pairwise_mul_v16i8(<16 x i8> %arg) {
; SIMD128-LABEL: pairwise_mul_v16i8:
; SIMD128:         .functype pairwise_mul_v16i8 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push20=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    local.tee $push19=, $1=, $pop20
; SIMD128-NEXT:    i16x8.extmul_low_i8x16_u $push1=, $0, $pop19
; SIMD128-NEXT:    i16x8.extmul_high_i8x16_u $push0=, $0, $1
; SIMD128-NEXT:    i8x16.shuffle $push18=, $pop1, $pop0, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30
; SIMD128-NEXT:    local.tee $push17=, $0=, $pop18
; SIMD128-NEXT:    i8x16.shuffle $push16=, $0, $0, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    local.tee $push15=, $1=, $pop16
; SIMD128-NEXT:    i16x8.extmul_low_i8x16_u $push3=, $pop17, $pop15
; SIMD128-NEXT:    i16x8.extmul_high_i8x16_u $push2=, $0, $1
; SIMD128-NEXT:    i8x16.shuffle $push14=, $pop3, $pop2, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30
; SIMD128-NEXT:    local.tee $push13=, $0=, $pop14
; SIMD128-NEXT:    i8x16.shuffle $push12=, $0, $0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    local.tee $push11=, $1=, $pop12
; SIMD128-NEXT:    i16x8.extmul_low_i8x16_u $push5=, $pop13, $pop11
; SIMD128-NEXT:    i16x8.extmul_high_i8x16_u $push4=, $0, $1
; SIMD128-NEXT:    i8x16.shuffle $push10=, $pop5, $pop4, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30
; SIMD128-NEXT:    local.tee $push9=, $0=, $pop10
; SIMD128-NEXT:    i8x16.shuffle $push6=, $0, $0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i16x8.extmul_low_i8x16_u $push7=, $pop9, $pop6
; SIMD128-NEXT:    i8x16.extract_lane_u $push8=, $pop7, 0
; SIMD128-NEXT:    return $pop8
  %res = tail call i8 @llvm.vector.reduce.mul.v16i8(<16 x i8> %arg)
  ret i8 %res
}

define i64 @pairwise_and_v2i64(<2 x i64> %arg) {
; SIMD128-LABEL: pairwise_and_v2i64:
; SIMD128:         .functype pairwise_and_v2i64 (v128) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    v128.and $push1=, $0, $pop0
; SIMD128-NEXT:    i64x2.extract_lane $push2=, $pop1, 0
; SIMD128-NEXT:    return $pop2
  %res = tail call i64 @llvm.vector.reduce.and.v2i64(<2 x i64> %arg)
  ret i64 %res
}

define i32 @pairwise_and_v4i32(<4 x i32> %arg) {
; SIMD128-LABEL: pairwise_and_v4i32:
; SIMD128:         .functype pairwise_and_v4i32 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    v128.and $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    v128.and $push2=, $pop4, $pop1
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call i32 @llvm.vector.reduce.and.v4i32(<4 x i32> %arg)
  ret i32 %res
}

define i16 @pairwise_and_v8i16(<8 x i16> %arg) {
; SIMD128-LABEL: pairwise_and_v8i16:
; SIMD128:         .functype pairwise_and_v8i16 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    v128.and $push8=, $0, $pop0
; SIMD128-NEXT:    local.tee $push7=, $0=, $pop8
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    v128.and $push6=, $pop7, $pop1
; SIMD128-NEXT:    local.tee $push5=, $0=, $pop6
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    v128.and $push3=, $pop5, $pop2
; SIMD128-NEXT:    i16x8.extract_lane_u $push4=, $pop3, 0
; SIMD128-NEXT:    return $pop4
  %res = tail call i16 @llvm.vector.reduce.and.v8i16(<8 x i16> %arg)
  ret i16 %res
}

define i8 @pairwise_and_v16i8(<16 x i8> %arg) {
; SIMD128-LABEL: pairwise_and_v16i8:
; SIMD128:         .functype pairwise_and_v16i8 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.and $push11=, $0, $pop0
; SIMD128-NEXT:    local.tee $push10=, $0=, $pop11
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.and $push9=, $pop10, $pop1
; SIMD128-NEXT:    local.tee $push8=, $0=, $pop9
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.and $push7=, $pop8, $pop2
; SIMD128-NEXT:    local.tee $push6=, $0=, $pop7
; SIMD128-NEXT:    i8x16.shuffle $push3=, $0, $0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.and $push4=, $pop6, $pop3
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $pop4, 0
; SIMD128-NEXT:    return $pop5
  %res = tail call i8 @llvm.vector.reduce.and.v16i8(<16 x i8> %arg)
  ret i8 %res
}

define i64 @pairwise_or_v2i64(<2 x i64> %arg) {
; SIMD128-LABEL: pairwise_or_v2i64:
; SIMD128:         .functype pairwise_or_v2i64 (v128) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    v128.or $push1=, $0, $pop0
; SIMD128-NEXT:    i64x2.extract_lane $push2=, $pop1, 0
; SIMD128-NEXT:    return $pop2
  %res = tail call i64 @llvm.vector.reduce.or.v2i64(<2 x i64> %arg)
  ret i64 %res
}

define i32 @pairwise_or_v4i32(<4 x i32> %arg) {
; SIMD128-LABEL: pairwise_or_v4i32:
; SIMD128:         .functype pairwise_or_v4i32 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    v128.or $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    v128.or $push2=, $pop4, $pop1
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call i32 @llvm.vector.reduce.or.v4i32(<4 x i32> %arg)
  ret i32 %res
}

define i16 @pairwise_or_v8i16(<8 x i16> %arg) {
; SIMD128-LABEL: pairwise_or_v8i16:
; SIMD128:         .functype pairwise_or_v8i16 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    v128.or $push8=, $0, $pop0
; SIMD128-NEXT:    local.tee $push7=, $0=, $pop8
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    v128.or $push6=, $pop7, $pop1
; SIMD128-NEXT:    local.tee $push5=, $0=, $pop6
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    v128.or $push3=, $pop5, $pop2
; SIMD128-NEXT:    i16x8.extract_lane_u $push4=, $pop3, 0
; SIMD128-NEXT:    return $pop4
  %res = tail call i16 @llvm.vector.reduce.or.v8i16(<8 x i16> %arg)
  ret i16 %res
}

define i8 @pairwise_or_v16i8(<16 x i8> %arg) {
; SIMD128-LABEL: pairwise_or_v16i8:
; SIMD128:         .functype pairwise_or_v16i8 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.or $push11=, $0, $pop0
; SIMD128-NEXT:    local.tee $push10=, $0=, $pop11
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.or $push9=, $pop10, $pop1
; SIMD128-NEXT:    local.tee $push8=, $0=, $pop9
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.or $push7=, $pop8, $pop2
; SIMD128-NEXT:    local.tee $push6=, $0=, $pop7
; SIMD128-NEXT:    i8x16.shuffle $push3=, $0, $0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.or $push4=, $pop6, $pop3
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $pop4, 0
; SIMD128-NEXT:    return $pop5
  %res = tail call i8 @llvm.vector.reduce.or.v16i8(<16 x i8> %arg)
  ret i8 %res
}

define i64 @pairwise_xor_v2i64(<2 x i64> %arg) {
; SIMD128-LABEL: pairwise_xor_v2i64:
; SIMD128:         .functype pairwise_xor_v2i64 (v128) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    v128.xor $push1=, $0, $pop0
; SIMD128-NEXT:    i64x2.extract_lane $push2=, $pop1, 0
; SIMD128-NEXT:    return $pop2
  %res = tail call i64 @llvm.vector.reduce.xor.v2i64(<2 x i64> %arg)
  ret i64 %res
}

define i32 @pairwise_xor_v4i32(<4 x i32> %arg) {
; SIMD128-LABEL: pairwise_xor_v4i32:
; SIMD128:         .functype pairwise_xor_v4i32 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    v128.xor $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    v128.xor $push2=, $pop4, $pop1
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call i32 @llvm.vector.reduce.xor.v4i32(<4 x i32> %arg)
  ret i32 %res
}

define i16 @pairwise_xor_v8i16(<8 x i16> %arg) {
; SIMD128-LABEL: pairwise_xor_v8i16:
; SIMD128:         .functype pairwise_xor_v8i16 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    v128.xor $push8=, $0, $pop0
; SIMD128-NEXT:    local.tee $push7=, $0=, $pop8
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    v128.xor $push6=, $pop7, $pop1
; SIMD128-NEXT:    local.tee $push5=, $0=, $pop6
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    v128.xor $push3=, $pop5, $pop2
; SIMD128-NEXT:    i16x8.extract_lane_u $push4=, $pop3, 0
; SIMD128-NEXT:    return $pop4
  %res = tail call i16 @llvm.vector.reduce.xor.v8i16(<8 x i16> %arg)
  ret i16 %res
}

define i8 @pairwise_xor_v16i8(<16 x i8> %arg) {
; SIMD128-LABEL: pairwise_xor_v16i8:
; SIMD128:         .functype pairwise_xor_v16i8 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.xor $push11=, $0, $pop0
; SIMD128-NEXT:    local.tee $push10=, $0=, $pop11
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.xor $push9=, $pop10, $pop1
; SIMD128-NEXT:    local.tee $push8=, $0=, $pop9
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.xor $push7=, $pop8, $pop2
; SIMD128-NEXT:    local.tee $push6=, $0=, $pop7
; SIMD128-NEXT:    i8x16.shuffle $push3=, $0, $0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    v128.xor $push4=, $pop6, $pop3
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $pop4, 0
; SIMD128-NEXT:    return $pop5
  %res = tail call i8 @llvm.vector.reduce.xor.v16i8(<16 x i8> %arg)
  ret i8 %res
}

define i64 @pairwise_smax_v2i64(<2 x i64> %arg) {
; SIMD128-LABEL: pairwise_smax_v2i64:
; SIMD128:         .functype pairwise_smax_v2i64 (v128) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push4=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    local.tee $push3=, $1=, $pop4
; SIMD128-NEXT:    i64x2.gt_s $push0=, $0, $1
; SIMD128-NEXT:    v128.bitselect $push1=, $0, $pop3, $pop0
; SIMD128-NEXT:    i64x2.extract_lane $push2=, $pop1, 0
; SIMD128-NEXT:    return $pop2
  %res = tail call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> %arg)
  ret i64 %res
}

define i32 @pairwise_smax_v4i32(<4 x i32> %arg) {
; SIMD128-LABEL: pairwise_smax_v4i32:
; SIMD128:         .functype pairwise_smax_v4i32 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.max_s $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.max_s $push2=, $pop4, $pop1
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> %arg)
  ret i32 %res
}

define i16 @pairwise_smax_v8i16(<8 x i16> %arg) {
; SIMD128-LABEL: pairwise_smax_v8i16:
; SIMD128:         .functype pairwise_smax_v8i16 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.max_s $push8=, $0, $pop0
; SIMD128-NEXT:    local.tee $push7=, $0=, $pop8
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.max_s $push6=, $pop7, $pop1
; SIMD128-NEXT:    local.tee $push5=, $0=, $pop6
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.max_s $push3=, $pop5, $pop2
; SIMD128-NEXT:    i16x8.extract_lane_u $push4=, $pop3, 0
; SIMD128-NEXT:    return $pop4
  %res = tail call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> %arg)
  ret i16 %res
}

define i8 @pairwise_smax_v16i8(<16 x i8> %arg) {
; SIMD128-LABEL: pairwise_smax_v16i8:
; SIMD128:         .functype pairwise_smax_v16i8 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.max_s $push11=, $0, $pop0
; SIMD128-NEXT:    local.tee $push10=, $0=, $pop11
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.max_s $push9=, $pop10, $pop1
; SIMD128-NEXT:    local.tee $push8=, $0=, $pop9
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.max_s $push7=, $pop8, $pop2
; SIMD128-NEXT:    local.tee $push6=, $0=, $pop7
; SIMD128-NEXT:    i8x16.shuffle $push3=, $0, $0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.max_s $push4=, $pop6, $pop3
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $pop4, 0
; SIMD128-NEXT:    return $pop5
  %res = tail call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> %arg)
  ret i8 %res
}

define i64 @pairwise_smin_v2i64(<2 x i64> %arg) {
; SIMD128-LABEL: pairwise_smin_v2i64:
; SIMD128:         .functype pairwise_smin_v2i64 (v128) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push4=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    local.tee $push3=, $1=, $pop4
; SIMD128-NEXT:    i64x2.lt_s $push0=, $0, $1
; SIMD128-NEXT:    v128.bitselect $push1=, $0, $pop3, $pop0
; SIMD128-NEXT:    i64x2.extract_lane $push2=, $pop1, 0
; SIMD128-NEXT:    return $pop2
  %res = tail call i64 @llvm.vector.reduce.smin.v2i64(<2 x i64> %arg)
  ret i64 %res
}

define i32 @pairwise_smin_v4i32(<4 x i32> %arg) {
; SIMD128-LABEL: pairwise_smin_v4i32:
; SIMD128:         .functype pairwise_smin_v4i32 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.min_s $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.min_s $push2=, $pop4, $pop1
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call i32 @llvm.vector.reduce.smin.v4i32(<4 x i32> %arg)
  ret i32 %res
}

define i16 @pairwise_smin_v8i16(<8 x i16> %arg) {
; SIMD128-LABEL: pairwise_smin_v8i16:
; SIMD128:         .functype pairwise_smin_v8i16 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.min_s $push8=, $0, $pop0
; SIMD128-NEXT:    local.tee $push7=, $0=, $pop8
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.min_s $push6=, $pop7, $pop1
; SIMD128-NEXT:    local.tee $push5=, $0=, $pop6
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.min_s $push3=, $pop5, $pop2
; SIMD128-NEXT:    i16x8.extract_lane_u $push4=, $pop3, 0
; SIMD128-NEXT:    return $pop4
  %res = tail call i16 @llvm.vector.reduce.smin.v8i16(<8 x i16> %arg)
  ret i16 %res
}

define i8 @pairwise_smin_v16i8(<16 x i8> %arg) {
; SIMD128-LABEL: pairwise_smin_v16i8:
; SIMD128:         .functype pairwise_smin_v16i8 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.min_s $push11=, $0, $pop0
; SIMD128-NEXT:    local.tee $push10=, $0=, $pop11
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.min_s $push9=, $pop10, $pop1
; SIMD128-NEXT:    local.tee $push8=, $0=, $pop9
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.min_s $push7=, $pop8, $pop2
; SIMD128-NEXT:    local.tee $push6=, $0=, $pop7
; SIMD128-NEXT:    i8x16.shuffle $push3=, $0, $0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.min_s $push4=, $pop6, $pop3
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $pop4, 0
; SIMD128-NEXT:    return $pop5
  %res = tail call i8 @llvm.vector.reduce.smin.v16i8(<16 x i8> %arg)
  ret i8 %res
}

define i64 @pairwise_umax_v2i64(<2 x i64> %arg) {
; SIMD128-LABEL: pairwise_umax_v2i64:
; SIMD128:         .functype pairwise_umax_v2i64 (v128) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push10=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    local.tee $push9=, $1=, $pop10
; SIMD128-NEXT:    i64.const $push4=, -1
; SIMD128-NEXT:    i64.const $push3=, 0
; SIMD128-NEXT:    i64x2.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    i64x2.extract_lane $push0=, $1, 0
; SIMD128-NEXT:    i64.gt_u $push2=, $pop1, $pop0
; SIMD128-NEXT:    i64.select $push5=, $pop4, $pop3, $pop2
; SIMD128-NEXT:    i64x2.replace_lane $push6=, $0, 0, $pop5
; SIMD128-NEXT:    v128.bitselect $push7=, $0, $pop9, $pop6
; SIMD128-NEXT:    i64x2.extract_lane $push8=, $pop7, 0
; SIMD128-NEXT:    return $pop8
  %res = tail call i64 @llvm.vector.reduce.umax.v2i64(<2 x i64> %arg)
  ret i64 %res
}

define i32 @pairwise_umax_v4i32(<4 x i32> %arg) {
; SIMD128-LABEL: pairwise_umax_v4i32:
; SIMD128:         .functype pairwise_umax_v4i32 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.max_u $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.max_u $push2=, $pop4, $pop1
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call i32 @llvm.vector.reduce.umax.v4i32(<4 x i32> %arg)
  ret i32 %res
}

define i16 @pairwise_umax_v8i16(<8 x i16> %arg) {
; SIMD128-LABEL: pairwise_umax_v8i16:
; SIMD128:         .functype pairwise_umax_v8i16 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.max_u $push8=, $0, $pop0
; SIMD128-NEXT:    local.tee $push7=, $0=, $pop8
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.max_u $push6=, $pop7, $pop1
; SIMD128-NEXT:    local.tee $push5=, $0=, $pop6
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.max_u $push3=, $pop5, $pop2
; SIMD128-NEXT:    i16x8.extract_lane_u $push4=, $pop3, 0
; SIMD128-NEXT:    return $pop4
  %res = tail call i16 @llvm.vector.reduce.umax.v8i16(<8 x i16> %arg)
  ret i16 %res
}

define i8 @pairwise_umax_v16i8(<16 x i8> %arg) {
; SIMD128-LABEL: pairwise_umax_v16i8:
; SIMD128:         .functype pairwise_umax_v16i8 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.max_u $push11=, $0, $pop0
; SIMD128-NEXT:    local.tee $push10=, $0=, $pop11
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.max_u $push9=, $pop10, $pop1
; SIMD128-NEXT:    local.tee $push8=, $0=, $pop9
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.max_u $push7=, $pop8, $pop2
; SIMD128-NEXT:    local.tee $push6=, $0=, $pop7
; SIMD128-NEXT:    i8x16.shuffle $push3=, $0, $0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.max_u $push4=, $pop6, $pop3
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $pop4, 0
; SIMD128-NEXT:    return $pop5
  %res = tail call i8 @llvm.vector.reduce.umax.v16i8(<16 x i8> %arg)
  ret i8 %res
}

define i64 @pairwise_umin_v2i64(<2 x i64> %arg) {
; SIMD128-LABEL: pairwise_umin_v2i64:
; SIMD128:         .functype pairwise_umin_v2i64 (v128) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push10=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    local.tee $push9=, $1=, $pop10
; SIMD128-NEXT:    i64.const $push4=, -1
; SIMD128-NEXT:    i64.const $push3=, 0
; SIMD128-NEXT:    i64x2.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    i64x2.extract_lane $push0=, $1, 0
; SIMD128-NEXT:    i64.lt_u $push2=, $pop1, $pop0
; SIMD128-NEXT:    i64.select $push5=, $pop4, $pop3, $pop2
; SIMD128-NEXT:    i64x2.replace_lane $push6=, $0, 0, $pop5
; SIMD128-NEXT:    v128.bitselect $push7=, $0, $pop9, $pop6
; SIMD128-NEXT:    i64x2.extract_lane $push8=, $pop7, 0
; SIMD128-NEXT:    return $pop8
  %res = tail call i64 @llvm.vector.reduce.umin.v2i64(<2 x i64> %arg)
  ret i64 %res
}

define i32 @pairwise_umin_v4i32(<4 x i32> %arg) {
; SIMD128-LABEL: pairwise_umin_v4i32:
; SIMD128:         .functype pairwise_umin_v4i32 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.min_u $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    i32x4.min_u $push2=, $pop4, $pop1
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call i32 @llvm.vector.reduce.umin.v4i32(<4 x i32> %arg)
  ret i32 %res
}

define i16 @pairwise_umin_v8i16(<8 x i16> %arg) {
; SIMD128-LABEL: pairwise_umin_v8i16:
; SIMD128:         .functype pairwise_umin_v8i16 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.min_u $push8=, $0, $pop0
; SIMD128-NEXT:    local.tee $push7=, $0=, $pop8
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.min_u $push6=, $pop7, $pop1
; SIMD128-NEXT:    local.tee $push5=, $0=, $pop6
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i16x8.min_u $push3=, $pop5, $pop2
; SIMD128-NEXT:    i16x8.extract_lane_u $push4=, $pop3, 0
; SIMD128-NEXT:    return $pop4
  %res = tail call i16 @llvm.vector.reduce.umin.v8i16(<8 x i16> %arg)
  ret i16 %res
}

define i8 @pairwise_umin_v16i8(<16 x i8> %arg) {
; SIMD128-LABEL: pairwise_umin_v16i8:
; SIMD128:         .functype pairwise_umin_v16i8 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.min_u $push11=, $0, $pop0
; SIMD128-NEXT:    local.tee $push10=, $0=, $pop11
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.min_u $push9=, $pop10, $pop1
; SIMD128-NEXT:    local.tee $push8=, $0=, $pop9
; SIMD128-NEXT:    i8x16.shuffle $push2=, $0, $0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.min_u $push7=, $pop8, $pop2
; SIMD128-NEXT:    local.tee $push6=, $0=, $pop7
; SIMD128-NEXT:    i8x16.shuffle $push3=, $0, $0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i8x16.min_u $push4=, $pop6, $pop3
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $pop4, 0
; SIMD128-NEXT:    return $pop5
  %res = tail call i8 @llvm.vector.reduce.umin.v16i8(<16 x i8> %arg)
  ret i8 %res
}

define double @pairwise_add_v2f64(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_add_v2f64:
; SIMD128:         .functype pairwise_add_v2f64 (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f64x2.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f64.add $push2=, $pop1, $pop0
; SIMD128-NEXT:    return $pop2
  %res = tail call double @llvm.vector.reduce.fadd.v2f64(double -0.0, <2 x double> %arg)
  ret double%res
}

define double @pairwise_add_v2f64_fast(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_add_v2f64_fast:
; SIMD128:         .functype pairwise_add_v2f64_fast (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    f64x2.add $push1=, $0, $pop0
; SIMD128-NEXT:    f64x2.extract_lane $push2=, $pop1, 0
; SIMD128-NEXT:    return $pop2
  %res = tail call fast double @llvm.vector.reduce.fadd.v2f64(double -0.0, <2 x double> %arg)
  ret double%res
}

define float @pairwise_add_v4f32(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_add_v4f32:
; SIMD128:         .functype pairwise_add_v4f32 (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f32.add $push2=, $pop1, $pop0
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 2
; SIMD128-NEXT:    f32.add $push4=, $pop2, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push5=, $0, 3
; SIMD128-NEXT:    f32.add $push6=, $pop4, $pop5
; SIMD128-NEXT:    return $pop6
  %res = tail call float @llvm.vector.reduce.fadd.v4f32(float -0.0, <4 x float> %arg)
  ret float %res
}

define float @pairwise_add_v4f32_fast(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_add_v4f32_fast:
; SIMD128:         .functype pairwise_add_v4f32_fast (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 12, 13, 14, 15, 0, 1, 2, 3
; SIMD128-NEXT:    f32x4.add $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 8, 9, 10, 11, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    f32x4.add $push2=, $pop4, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call fast float @llvm.vector.reduce.fadd.v4f32(float -0.0, <4 x float> %arg)
  ret float %res
}

define float @pairwise_add_v4f32_reassoc(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_add_v4f32_reassoc:
; SIMD128:         .functype pairwise_add_v4f32_reassoc (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 12, 13, 14, 15, 0, 1, 2, 3
; SIMD128-NEXT:    f32x4.add $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 8, 9, 10, 11, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    f32x4.add $push2=, $pop4, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call reassoc float @llvm.vector.reduce.fadd.v4f32(float -0.0, <4 x float> %arg)
  ret float %res
}

define double @pairwise_mul_v2f64(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_mul_v2f64:
; SIMD128:         .functype pairwise_mul_v2f64 (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.extract_lane $push0=, $0, 0
; SIMD128-NEXT:    f64.const $push1=, -0x0p0
; SIMD128-NEXT:    f64.mul $push2=, $pop0, $pop1
; SIMD128-NEXT:    f64x2.extract_lane $push3=, $0, 1
; SIMD128-NEXT:    f64.mul $push4=, $pop2, $pop3
; SIMD128-NEXT:    return $pop4
  %res = tail call double @llvm.vector.reduce.fmul.v2f64(double -0.0, <2 x double> %arg)
  ret double%res
}

define double @pairwise_mul_v2f64_fast(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_mul_v2f64_fast:
; SIMD128:         .functype pairwise_mul_v2f64_fast (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64.const $push0=, 0x0p0
; SIMD128-NEXT:    return $pop0
  %res = tail call fast double @llvm.vector.reduce.fmul.v2f64(double -0.0, <2 x double> %arg)
  ret double%res
}

define float @pairwise_mul_v4f32(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_mul_v4f32:
; SIMD128:         .functype pairwise_mul_v4f32 (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 0
; SIMD128-NEXT:    f32.const $push1=, -0x0p0
; SIMD128-NEXT:    f32.mul $push2=, $pop0, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 1
; SIMD128-NEXT:    f32.mul $push4=, $pop2, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push5=, $0, 2
; SIMD128-NEXT:    f32.mul $push6=, $pop4, $pop5
; SIMD128-NEXT:    f32x4.extract_lane $push7=, $0, 3
; SIMD128-NEXT:    f32.mul $push8=, $pop6, $pop7
; SIMD128-NEXT:    return $pop8
  %res = tail call float @llvm.vector.reduce.fmul.v4f32(float -0.0, <4 x float> %arg)
  ret float %res
}

define float @pairwise_mul_v4f32_fast(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_mul_v4f32_fast:
; SIMD128:         .functype pairwise_mul_v4f32_fast (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32.const $push0=, 0x0p0
; SIMD128-NEXT:    return $pop0
  %res = tail call fast float @llvm.vector.reduce.fmul.v4f32(float -0.0, <4 x float> %arg)
  ret float %res
}

define float @pairwise_mul_v4f32_reassoc(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_mul_v4f32_reassoc:
; SIMD128:         .functype pairwise_mul_v4f32_reassoc (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    f32x4.mul $push7=, $0, $pop0
; SIMD128-NEXT:    local.tee $push6=, $0=, $pop7
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    f32x4.mul $push2=, $pop6, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    f32.const $push4=, -0x0p0
; SIMD128-NEXT:    f32.mul $push5=, $pop3, $pop4
; SIMD128-NEXT:    return $pop5
  %res = tail call reassoc float @llvm.vector.reduce.fmul.v4f32(float -0.0, <4 x float> %arg)
  ret float %res
}

define double @pairwise_max_v2f64(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_max_v2f64:
; SIMD128:         .functype pairwise_max_v2f64 (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f64x2.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    call $push2=, fmax, $pop1, $pop0
; SIMD128-NEXT:    return $pop2
  %res = tail call double @llvm.vector.reduce.fmax.v2f64(<2 x double> %arg)
  ret double%res
}

define double @pairwise_max_v2f64_fast(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_max_v2f64_fast:
; SIMD128:         .functype pairwise_max_v2f64_fast (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    f64x2.pmax $push1=, $0, $pop0
; SIMD128-NEXT:    f64x2.extract_lane $push2=, $pop1, 0
; SIMD128-NEXT:    return $pop2
  %res = tail call fast double @llvm.vector.reduce.fmax.v2f64(<2 x double> %arg)
  ret double%res
}

define float @pairwise_max_v4f32(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_max_v4f32:
; SIMD128:         .functype pairwise_max_v4f32 (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 0
; SIMD128-NEXT:    f32x4.extract_lane $push2=, $0, 1
; SIMD128-NEXT:    call $push4=, fmaxf, $pop3, $pop2
; SIMD128-NEXT:    f32x4.extract_lane $push1=, $0, 2
; SIMD128-NEXT:    call $push5=, fmaxf, $pop4, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 3
; SIMD128-NEXT:    call $push6=, fmaxf, $pop5, $pop0
; SIMD128-NEXT:    return $pop6
  %res = tail call float @llvm.vector.reduce.fmax.v4f32(<4 x float> %arg)
  ret float %res
}

define float @pairwise_max_v4f32_fast(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_max_v4f32_fast:
; SIMD128:         .functype pairwise_max_v4f32_fast (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    f32x4.pmax $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    f32x4.pmax $push2=, $pop4, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call fast float @llvm.vector.reduce.fmax.v4f32(<4 x float> %arg)
  ret float %res
}

define float @pairwise_max_v4f32_reassoc(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_max_v4f32_reassoc:
; SIMD128:         .functype pairwise_max_v4f32_reassoc (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 0
; SIMD128-NEXT:    f32x4.extract_lane $push2=, $0, 1
; SIMD128-NEXT:    call $push4=, fmaxf, $pop3, $pop2
; SIMD128-NEXT:    f32x4.extract_lane $push1=, $0, 2
; SIMD128-NEXT:    call $push5=, fmaxf, $pop4, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 3
; SIMD128-NEXT:    call $push6=, fmaxf, $pop5, $pop0
; SIMD128-NEXT:    return $pop6
  %res = tail call reassoc float @llvm.vector.reduce.fmax.v4f32(<4 x float> %arg)
  ret float %res
}

define double @pairwise_min_v2f64(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_min_v2f64:
; SIMD128:         .functype pairwise_min_v2f64 (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f64x2.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    call $push2=, fmin, $pop1, $pop0
; SIMD128-NEXT:    return $pop2
  %res = tail call double @llvm.vector.reduce.fmin.v2f64(<2 x double> %arg)
  ret double%res
}

define double @pairwise_min_v2f64_fast(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_min_v2f64_fast:
; SIMD128:         .functype pairwise_min_v2f64_fast (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    f64x2.pmin $push1=, $0, $pop0
; SIMD128-NEXT:    f64x2.extract_lane $push2=, $pop1, 0
; SIMD128-NEXT:    return $pop2
  %res = tail call fast double @llvm.vector.reduce.fmin.v2f64(<2 x double> %arg)
  ret double%res
}

define float @pairwise_min_v4f32(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_min_v4f32:
; SIMD128:         .functype pairwise_min_v4f32 (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 0
; SIMD128-NEXT:    f32x4.extract_lane $push2=, $0, 1
; SIMD128-NEXT:    call $push4=, fminf, $pop3, $pop2
; SIMD128-NEXT:    f32x4.extract_lane $push1=, $0, 2
; SIMD128-NEXT:    call $push5=, fminf, $pop4, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 3
; SIMD128-NEXT:    call $push6=, fminf, $pop5, $pop0
; SIMD128-NEXT:    return $pop6
  %res = tail call float @llvm.vector.reduce.fmin.v4f32(<4 x float> %arg)
  ret float %res
}

define float @pairwise_min_v4f32_fast(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_min_v4f32_fast:
; SIMD128:         .functype pairwise_min_v4f32_fast (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    f32x4.pmin $push5=, $0, $pop0
; SIMD128-NEXT:    local.tee $push4=, $0=, $pop5
; SIMD128-NEXT:    i8x16.shuffle $push1=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    f32x4.pmin $push2=, $pop4, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $pop2, 0
; SIMD128-NEXT:    return $pop3
  %res = tail call fast float @llvm.vector.reduce.fmin.v4f32(<4 x float> %arg)
  ret float %res
}

define float @pairwise_min_v4f32_reassoc(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_min_v4f32_reassoc:
; SIMD128:         .functype pairwise_min_v4f32_reassoc (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 0
; SIMD128-NEXT:    f32x4.extract_lane $push2=, $0, 1
; SIMD128-NEXT:    call $push4=, fminf, $pop3, $pop2
; SIMD128-NEXT:    f32x4.extract_lane $push1=, $0, 2
; SIMD128-NEXT:    call $push5=, fminf, $pop4, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 3
; SIMD128-NEXT:    call $push6=, fminf, $pop5, $pop0
; SIMD128-NEXT:    return $pop6
  %res = tail call reassoc float @llvm.vector.reduce.fmin.v4f32(<4 x float> %arg)
  ret float %res
}

define double @pairwise_maximum_v2f64(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_maximum_v2f64:
; SIMD128:         .functype pairwise_maximum_v2f64 (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f64x2.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f64.max $push2=, $pop1, $pop0
; SIMD128-NEXT:    return $pop2
  %res = tail call double @llvm.vector.reduce.fmaximum.v2f64(<2 x double> %arg)
  ret double%res
}

define double @pairwise_maximum_v2f64_fast(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_maximum_v2f64_fast:
; SIMD128:         .functype pairwise_maximum_v2f64_fast (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f64x2.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f64.max $push2=, $pop1, $pop0
; SIMD128-NEXT:    return $pop2
  %res = tail call fast double @llvm.vector.reduce.fmaximum.v2f64(<2 x double> %arg)
  ret double%res
}

define float @pairwise_maximum_v4f32(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_maximum_v4f32:
; SIMD128:         .functype pairwise_maximum_v4f32 (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f32.max $push2=, $pop1, $pop0
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 2
; SIMD128-NEXT:    f32.max $push4=, $pop2, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push5=, $0, 3
; SIMD128-NEXT:    f32.max $push6=, $pop4, $pop5
; SIMD128-NEXT:    return $pop6
  %res = tail call float @llvm.vector.reduce.fmaximum.v4f32(<4 x float> %arg)
  ret float %res
}

define float @pairwise_maximum_v4f32_fast(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_maximum_v4f32_fast:
; SIMD128:         .functype pairwise_maximum_v4f32_fast (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f32.max $push2=, $pop1, $pop0
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 2
; SIMD128-NEXT:    f32.max $push4=, $pop2, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push5=, $0, 3
; SIMD128-NEXT:    f32.max $push6=, $pop4, $pop5
; SIMD128-NEXT:    return $pop6
  %res = tail call fast float @llvm.vector.reduce.fmaximum.v4f32(<4 x float> %arg)
  ret float %res
}

define float @pairwise_maximum_v4f32_reassoc(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_maximum_v4f32_reassoc:
; SIMD128:         .functype pairwise_maximum_v4f32_reassoc (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f32.max $push2=, $pop1, $pop0
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 2
; SIMD128-NEXT:    f32.max $push4=, $pop2, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push5=, $0, 3
; SIMD128-NEXT:    f32.max $push6=, $pop4, $pop5
; SIMD128-NEXT:    return $pop6
  %res = tail call reassoc float @llvm.vector.reduce.fmaximum.v4f32(<4 x float> %arg)
  ret float %res
}

define double @pairwise_minimum_v2f64(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_minimum_v2f64:
; SIMD128:         .functype pairwise_minimum_v2f64 (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f64x2.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f64.min $push2=, $pop1, $pop0
; SIMD128-NEXT:    return $pop2
  %res = tail call double @llvm.vector.reduce.fminimum.v2f64(<2 x double> %arg)
  ret double%res
}

define double @pairwise_minimum_v2f64_fast(<2 x double> %arg) {
; SIMD128-LABEL: pairwise_minimum_v2f64_fast:
; SIMD128:         .functype pairwise_minimum_v2f64_fast (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f64x2.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f64.min $push2=, $pop1, $pop0
; SIMD128-NEXT:    return $pop2
  %res = tail call fast double @llvm.vector.reduce.fminimum.v2f64(<2 x double> %arg)
  ret double%res
}

define float @pairwise_minimum_v4f32(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_minimum_v4f32:
; SIMD128:         .functype pairwise_minimum_v4f32 (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f32.min $push2=, $pop1, $pop0
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 2
; SIMD128-NEXT:    f32.min $push4=, $pop2, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push5=, $0, 3
; SIMD128-NEXT:    f32.min $push6=, $pop4, $pop5
; SIMD128-NEXT:    return $pop6
  %res = tail call float @llvm.vector.reduce.fminimum.v4f32(<4 x float> %arg)
  ret float %res
}

define float @pairwise_minimum_v4f32_fast(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_minimum_v4f32_fast:
; SIMD128:         .functype pairwise_minimum_v4f32_fast (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f32.min $push2=, $pop1, $pop0
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 2
; SIMD128-NEXT:    f32.min $push4=, $pop2, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push5=, $0, 3
; SIMD128-NEXT:    f32.min $push6=, $pop4, $pop5
; SIMD128-NEXT:    return $pop6
  %res = tail call fast float @llvm.vector.reduce.fminimum.v4f32(<4 x float> %arg)
  ret float %res
}

define float @pairwise_minimum_v4f32_reassoc(<4 x float> %arg) {
; SIMD128-LABEL: pairwise_minimum_v4f32_reassoc:
; SIMD128:         .functype pairwise_minimum_v4f32_reassoc (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push1=, $0, 0
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    f32.min $push2=, $pop1, $pop0
; SIMD128-NEXT:    f32x4.extract_lane $push3=, $0, 2
; SIMD128-NEXT:    f32.min $push4=, $pop2, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push5=, $0, 3
; SIMD128-NEXT:    f32.min $push6=, $pop4, $pop5
; SIMD128-NEXT:    return $pop6
  %res = tail call reassoc float @llvm.vector.reduce.fminimum.v4f32(<4 x float> %arg)
  ret float %res
}
