; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers  -mattr=+fp16,+simd128,+relaxed-simd | FileCheck %s --check-prefix=RELAXED
; RUN: llc < %s -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers  -mattr=+fp16,+simd128,              | FileCheck %s --check-prefix=STRICT

target triple = "wasm32"

define double @fsub_fmul_contract_f64(double %a, double %b, double %c) {
; RELAXED-LABEL: fsub_fmul_contract_f64:
; RELAXED:         .functype fsub_fmul_contract_f64 (f64, f64, f64) -> (f64)
; RELAXED-NEXT:  # %bb.0:
; RELAXED-NEXT:    f64.mul $push0=, $1, $0
; RELAXED-NEXT:    f64.sub $push1=, $2, $pop0
; RELAXED-NEXT:    return $pop1
;
; STRICT-LABEL: fsub_fmul_contract_f64:
; STRICT:         .functype fsub_fmul_contract_f64 (f64, f64, f64) -> (f64)
; STRICT-NEXT:  # %bb.0:
; STRICT-NEXT:    f64.mul $push0=, $1, $0
; STRICT-NEXT:    f64.sub $push1=, $2, $pop0
; STRICT-NEXT:    return $pop1
  %mul = fmul contract double %b, %a
  %sub = fsub contract double %c, %mul
  ret double %sub
}

define <4 x float> @fsub_fmul_contract_4xf32(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; RELAXED-LABEL: fsub_fmul_contract_4xf32:
; RELAXED:         .functype fsub_fmul_contract_4xf32 (v128, v128, v128) -> (v128)
; RELAXED-NEXT:  # %bb.0:
; RELAXED-NEXT:    f32x4.relaxed_nmadd $push0=, $1, $0, $2
; RELAXED-NEXT:    return $pop0
;
; STRICT-LABEL: fsub_fmul_contract_4xf32:
; STRICT:         .functype fsub_fmul_contract_4xf32 (v128, v128, v128) -> (v128)
; STRICT-NEXT:  # %bb.0:
; STRICT-NEXT:    f32x4.mul $push0=, $1, $0
; STRICT-NEXT:    f32x4.sub $push1=, $2, $pop0
; STRICT-NEXT:    return $pop1
  %mul = fmul contract <4 x float> %b, %a
  %sub = fsub contract <4 x float> %c, %mul
  ret <4 x float> %sub
}


define <8 x half> @fsub_fmul_contract_8xf16(<8 x half> %a, <8 x half> %b, <8 x half> %c) {
; RELAXED-LABEL: fsub_fmul_contract_8xf16:
; RELAXED:         .functype fsub_fmul_contract_8xf16 (v128, v128, v128) -> (v128)
; RELAXED-NEXT:  # %bb.0:
; RELAXED-NEXT:    f16x8.nmadd $push0=, $1, $0, $2
; RELAXED-NEXT:    return $pop0
;
; STRICT-LABEL: fsub_fmul_contract_8xf16:
; STRICT:         .functype fsub_fmul_contract_8xf16 (v128, v128, v128) -> (v128)
; STRICT-NEXT:  # %bb.0:
; STRICT-NEXT:    f16x8.nmadd $push0=, $1, $0, $2
; STRICT-NEXT:    return $pop0
  %mul = fmul contract <8 x half> %b, %a
  %sub = fsub contract <8 x half> %c, %mul
  ret <8 x half> %sub
}


define <4 x float> @fsub_fmul_4xf32(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; RELAXED-LABEL: fsub_fmul_4xf32:
; RELAXED:         .functype fsub_fmul_4xf32 (v128, v128, v128) -> (v128)
; RELAXED-NEXT:  # %bb.0:
; RELAXED-NEXT:    f32x4.mul $push0=, $1, $0
; RELAXED-NEXT:    f32x4.sub $push1=, $2, $pop0
; RELAXED-NEXT:    return $pop1
;
; STRICT-LABEL: fsub_fmul_4xf32:
; STRICT:         .functype fsub_fmul_4xf32 (v128, v128, v128) -> (v128)
; STRICT-NEXT:  # %bb.0:
; STRICT-NEXT:    f32x4.mul $push0=, $1, $0
; STRICT-NEXT:    f32x4.sub $push1=, $2, $pop0
; STRICT-NEXT:    return $pop1
  %mul = fmul <4 x float> %b, %a
  %sub = fsub contract <4 x float> %c, %mul
  ret <4 x float> %sub
}

define <8 x float> @fsub_fmul_contract_8xf32(<8 x float> %a, <8 x float> %b, <8 x float> %c) {
; RELAXED-LABEL: fsub_fmul_contract_8xf32:
; RELAXED:         .functype fsub_fmul_contract_8xf32 (i32, v128, v128, v128, v128, v128, v128) -> ()
; RELAXED-NEXT:  # %bb.0:
; RELAXED-NEXT:    f32x4.relaxed_nmadd $push0=, $4, $2, $6
; RELAXED-NEXT:    v128.store 16($0), $pop0
; RELAXED-NEXT:    f32x4.relaxed_nmadd $push1=, $3, $1, $5
; RELAXED-NEXT:    v128.store 0($0), $pop1
; RELAXED-NEXT:    return
;
; STRICT-LABEL: fsub_fmul_contract_8xf32:
; STRICT:         .functype fsub_fmul_contract_8xf32 (i32, v128, v128, v128, v128, v128, v128) -> ()
; STRICT-NEXT:  # %bb.0:
; STRICT-NEXT:    f32x4.mul $push0=, $4, $2
; STRICT-NEXT:    f32x4.sub $push1=, $6, $pop0
; STRICT-NEXT:    v128.store 16($0), $pop1
; STRICT-NEXT:    f32x4.mul $push2=, $3, $1
; STRICT-NEXT:    f32x4.sub $push3=, $5, $pop2
; STRICT-NEXT:    v128.store 0($0), $pop3
; STRICT-NEXT:    return
  %mul = fmul contract <8 x float> %b, %a
  %sub = fsub contract <8 x float> %c, %mul
  ret <8 x float> %sub
}


define <2 x double> @fsub_fmul_contract_2xf64(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; RELAXED-LABEL: fsub_fmul_contract_2xf64:
; RELAXED:         .functype fsub_fmul_contract_2xf64 (v128, v128, v128) -> (v128)
; RELAXED-NEXT:  # %bb.0:
; RELAXED-NEXT:    f64x2.relaxed_nmadd $push0=, $1, $0, $2
; RELAXED-NEXT:    return $pop0
;
; STRICT-LABEL: fsub_fmul_contract_2xf64:
; STRICT:         .functype fsub_fmul_contract_2xf64 (v128, v128, v128) -> (v128)
; STRICT-NEXT:  # %bb.0:
; STRICT-NEXT:    f64x2.mul $push0=, $1, $0
; STRICT-NEXT:    f64x2.sub $push1=, $2, $pop0
; STRICT-NEXT:    return $pop1
  %mul = fmul contract <2 x double> %b, %a
  %sub = fsub contract <2 x double> %c, %mul
  ret <2 x double> %sub
}

define float @fsub_fmul_contract_f32(float %a, float %b, float %c) {
; RELAXED-LABEL: fsub_fmul_contract_f32:
; RELAXED:         .functype fsub_fmul_contract_f32 (f32, f32, f32) -> (f32)
; RELAXED-NEXT:  # %bb.0:
; RELAXED-NEXT:    f32.mul $push0=, $1, $0
; RELAXED-NEXT:    f32.sub $push1=, $2, $pop0
; RELAXED-NEXT:    return $pop1
;
; STRICT-LABEL: fsub_fmul_contract_f32:
; STRICT:         .functype fsub_fmul_contract_f32 (f32, f32, f32) -> (f32)
; STRICT-NEXT:  # %bb.0:
; STRICT-NEXT:    f32.mul $push0=, $1, $0
; STRICT-NEXT:    f32.sub $push1=, $2, $pop0
; STRICT-NEXT:    return $pop1
  %mul = fmul contract float %b, %a
  %sub = fsub contract float %c, %mul
  ret float %sub
}

define <8 x half> @fmuladd_8xf16(<8 x half> %a, <8 x half> %b, <8 x half> %c) {
; RELAXED-LABEL: fmuladd_8xf16:
; RELAXED:         .functype fmuladd_8xf16 (v128, v128, v128) -> (v128)
; RELAXED-NEXT:  # %bb.0:
; RELAXED-NEXT:    f16x8.nmadd $push0=, $0, $1, $2
; RELAXED-NEXT:    return $pop0
;
; STRICT-LABEL: fmuladd_8xf16:
; STRICT:         .functype fmuladd_8xf16 (v128, v128, v128) -> (v128)
; STRICT-NEXT:  # %bb.0:
; STRICT-NEXT:    f16x8.nmadd $push0=, $0, $1, $2
; STRICT-NEXT:    return $pop0
  %fneg = fneg <8 x half> %a
  %fma = call <8 x half> @llvm.fmuladd(<8 x half> %fneg, <8 x half> %b, <8 x half> %c)
  ret <8 x half> %fma
}

define <4 x float> @fmuladd_4xf32(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; RELAXED-LABEL: fmuladd_4xf32:
; RELAXED:         .functype fmuladd_4xf32 (v128, v128, v128) -> (v128)
; RELAXED-NEXT:  # %bb.0:
; RELAXED-NEXT:    f32x4.relaxed_nmadd $push0=, $0, $1, $2
; RELAXED-NEXT:    return $pop0
;
; STRICT-LABEL: fmuladd_4xf32:
; STRICT:         .functype fmuladd_4xf32 (v128, v128, v128) -> (v128)
; STRICT-NEXT:  # %bb.0:
; STRICT-NEXT:    f32x4.mul $push0=, $0, $1
; STRICT-NEXT:    f32x4.sub $push1=, $2, $pop0
; STRICT-NEXT:    return $pop1
  %fneg = fneg <4 x float> %a
  %fma = call <4 x float> @llvm.fmuladd(<4 x float> %fneg, <4 x float> %b, <4 x float> %c)
  ret <4 x float> %fma
}

define <2 x double> @fmuladd_2xf64(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; RELAXED-LABEL: fmuladd_2xf64:
; RELAXED:         .functype fmuladd_2xf64 (v128, v128, v128) -> (v128)
; RELAXED-NEXT:  # %bb.0:
; RELAXED-NEXT:    f64x2.relaxed_nmadd $push0=, $0, $1, $2
; RELAXED-NEXT:    return $pop0
;
; STRICT-LABEL: fmuladd_2xf64:
; STRICT:         .functype fmuladd_2xf64 (v128, v128, v128) -> (v128)
; STRICT-NEXT:  # %bb.0:
; STRICT-NEXT:    f64x2.mul $push0=, $0, $1
; STRICT-NEXT:    f64x2.sub $push1=, $2, $pop0
; STRICT-NEXT:    return $pop1
  %fneg = fneg <2 x double> %a
  %fma = call <2 x double> @llvm.fmuladd(<2 x double> %fneg, <2 x double> %b, <2 x double> %c)
  ret <2 x double> %fma
}
