; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc < %s -mtriple=wasm32-unknown-unknown -mattr=+simd128,+relaxed-simd | FileCheck %s

; Test that fminnum and fminimumnum get transformed to relaxed_min

target triple = "wasm32"

define <4 x float> @test_minnum_f32x4(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: test_minnum_f32x4:
; CHECK:         .functype test_minnum_f32x4 (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f32x4.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %result = call <4 x float> @llvm.minnum.v4f32(<4 x float> %a, <4 x float> %b)
  ret <4 x float> %result
}

define <4 x float> @test_minimumnum_f32x4(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: test_minimumnum_f32x4:
; CHECK:         .functype test_minimumnum_f32x4 (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f32x4.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %result = call <4 x float> @llvm.minimumnum.v4f32(<4 x float> %a, <4 x float> %b)
  ret <4 x float> %result
}

define <2 x double> @test_minnum_f64x2(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_minnum_f64x2:
; CHECK:         .functype test_minnum_f64x2 (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f64x2.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %result = call <2 x double> @llvm.minnum.v2f64(<2 x double> %a, <2 x double> %b)
  ret <2 x double> %result
}

define <2 x double> @test_minimumnum_f64x2(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_minimumnum_f64x2:
; CHECK:         .functype test_minimumnum_f64x2 (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f64x2.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %result = call <2 x double> @llvm.minimumnum.v2f64(<2 x double> %a, <2 x double> %b)
  ret <2 x double> %result
}

define <4 x float> @test_pmin_v4f32_olt(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: test_pmin_v4f32_olt:
; CHECK:         .functype test_pmin_v4f32_olt (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f32x4.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp olt <4 x float> %y, %x
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x float> @test_pmin_v4f32_ole(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: test_pmin_v4f32_ole:
; CHECK:         .functype test_pmin_v4f32_ole (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f32x4.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp ole <4 x float> %y, %x
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x float> @test_pmin_v4f32_ogt(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: test_pmin_v4f32_ogt:
; CHECK:         .functype test_pmin_v4f32_ogt (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f32x4.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp ogt <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x float> @test_pmin_v4f32_oge(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: test_pmin_v4f32_oge:
; CHECK:         .functype test_pmin_v4f32_oge (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f32x4.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp oge <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

; For setlt
define <4 x float> @pmin_v4f32_fast_olt(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: pmin_v4f32_fast_olt:
; CHECK:         .functype pmin_v4f32_fast_olt (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp fast olt <4 x float> %y, %x
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

; For setle
define <4 x float> @test_pmin_v4f32_fast_ole(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: test_pmin_v4f32_fast_ole:
; CHECK:         .functype test_pmin_v4f32_fast_ole (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp fast ole <4 x float> %y, %x
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

; For setgt
define <4 x float> @test_pmin_v4f32_fast_ogt(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: test_pmin_v4f32_fast_ogt:
; CHECK:         .functype test_pmin_v4f32_fast_ogt (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f32x4.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp fast ogt <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

; For setge
define <4 x float> @test_pmin_v4f32_fast_oge(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: test_pmin_v4f32_fast_oge:
; CHECK:         .functype test_pmin_v4f32_fast_oge (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f32x4.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp fast oge <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x i32> @test_pmin_int_v4f32(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: test_pmin_int_v4f32:
; CHECK:         .functype test_pmin_int_v4f32 (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f32x4.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %fx = bitcast <4 x i32> %x to <4 x float>
  %fy = bitcast <4 x i32> %y to <4 x float>
  %c = fcmp olt <4 x float> %fy, %fx
  %a = select <4 x i1> %c, <4 x i32> %y, <4 x i32> %x
  ret <4 x i32> %a
}

define <2 x double> @test_pmin_v2f64_olt(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: test_pmin_v2f64_olt:
; CHECK:         .functype test_pmin_v2f64_olt (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f64x2.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp olt <2 x double> %y, %x
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

define <2 x double> @test_pmin_v2f64_ole(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: test_pmin_v2f64_ole:
; CHECK:         .functype test_pmin_v2f64_ole (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f64x2.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp ole <2 x double> %y, %x
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

define <2 x double> @test_pmin_v2f64_ogt(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: test_pmin_v2f64_ogt:
; CHECK:         .functype test_pmin_v2f64_ogt (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f64x2.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp ogt <2 x double> %x, %y
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

define <2 x double> @test_pmin_v2f64_oge(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: test_pmin_v2f64_oge:
; CHECK:         .functype test_pmin_v2f64_oge (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f64x2.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp oge <2 x double> %x, %y
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

; For setlt
define <2 x double> @pmin_v2f64_fast_olt(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: pmin_v2f64_fast_olt:
; CHECK:         .functype pmin_v2f64_fast_olt (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp fast olt <2 x double> %y, %x
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

; For setle
define <2 x double> @test_pmin_v2f64_fast_ole(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: test_pmin_v2f64_fast_ole:
; CHECK:         .functype test_pmin_v2f64_fast_ole (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp fast ole <2 x double> %y, %x
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

; For setgt
define <2 x double> @test_pmin_v2f64_fast_ogt(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: test_pmin_v2f64_fast_ogt:
; CHECK:         .functype test_pmin_v2f64_fast_ogt (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f64x2.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp fast ogt <2 x double> %x, %y
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

; For setge
define <2 x double> @test_pmin_v2f64_fast_oge(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: test_pmin_v2f64_fast_oge:
; CHECK:         .functype test_pmin_v2f64_fast_oge (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f64x2.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %c = fcmp fast oge <2 x double> %x, %y
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

define <2 x i64> @test_pmin_int_v2f64(<2 x i64> %x, <2 x i64> %y) {
; CHECK-LABEL: test_pmin_int_v2f64:
; CHECK:         .functype test_pmin_int_v2f64 (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    f64x2.relaxed_min
; CHECK-NEXT:    # fallthrough-return
  %fx = bitcast <2 x i64> %x to <2 x double>
  %fy = bitcast <2 x i64> %y to <2 x double>
  %c = fcmp olt <2 x double> %fy, %fx
  %a = select <2 x i1> %c, <2 x i64> %y, <2 x i64> %x
  ret <2 x i64> %a
}

declare <4 x float> @llvm.minnum.v4f32(<4 x float>, <4 x float>)
declare <4 x float> @llvm.fminimumnum.v4f32(<4 x float>, <4 x float>)
declare <2 x double> @llvm.minnum.v2f64(<2 x double>, <2 x double>)
declare <2 x double> @llvm.fminimumnum.v2f64(<2 x double>, <2 x double>)
