; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc < %s -O2 -mtriple=wasm32 -mattr=+simd128 | FileCheck %s

target triple = "wasm32-unknown-unknown"

; Test that adding two extended shuffles from the same vector that ends w/ an add converts to extadd_pairwise

define <8 x i16> @test_extadd_pairwise_i8x16_s(<16 x i8> %v) {
; CHECK-LABEL: test_extadd_pairwise_i8x16_s:
; CHECK:         .functype test_extadd_pairwise_i8x16_s (v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i16x8.extadd_pairwise_i8x16_s
; CHECK-NEXT:    # fallthrough-return
  %even = shufflevector <16 x i8> %v, <16 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %odd = shufflevector <16 x i8> %v, <16 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %even_ext = sext <8 x i8> %even to <8 x i16>
  %odd_ext = sext <8 x i8> %odd to <8 x i16>
  %result = add <8 x i16> %even_ext, %odd_ext
  ret <8 x i16> %result
}

define <8 x i16> @test_extadd_pairwise_i8x16_u(<16 x i8> %v) {
; CHECK-LABEL: test_extadd_pairwise_i8x16_u:
; CHECK:         .functype test_extadd_pairwise_i8x16_u (v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i16x8.extadd_pairwise_i8x16_u
; CHECK-NEXT:    # fallthrough-return
  %even = shufflevector <16 x i8> %v, <16 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %odd = shufflevector <16 x i8> %v, <16 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %even_ext = zext <8 x i8> %even to <8 x i16>
  %odd_ext = zext <8 x i8> %odd to <8 x i16>
  %result = add <8 x i16> %even_ext, %odd_ext
  ret <8 x i16> %result
}

define <4 x i32> @test_extadd_pairwise_i16x8_s(<8 x i16> %v) {
; CHECK-LABEL: test_extadd_pairwise_i16x8_s:
; CHECK:         .functype test_extadd_pairwise_i16x8_s (v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.extadd_pairwise_i16x8_s
; CHECK-NEXT:    # fallthrough-return
  %even = shufflevector <8 x i16> %v, <8 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %odd = shufflevector <8 x i16> %v, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %even_ext = sext <4 x i16> %even to <4 x i32>
  %odd_ext = sext <4 x i16> %odd to <4 x i32>
  %result = add <4 x i32> %even_ext, %odd_ext
  ret <4 x i32> %result
}

define <4 x i32> @test_extadd_pairwise_i16x8_u(<8 x i16> %v) {
; CHECK-LABEL: test_extadd_pairwise_i16x8_u:
; CHECK:         .functype test_extadd_pairwise_i16x8_u (v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.extadd_pairwise_i16x8_u
; CHECK-NEXT:    # fallthrough-return
  %even = shufflevector <8 x i16> %v, <8 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %odd = shufflevector <8 x i16> %v, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %even_ext = zext <4 x i16> %even to <4 x i32>
  %odd_ext = zext <4 x i16> %odd to <4 x i32>
  %result = add <4 x i32> %even_ext, %odd_ext
  ret <4 x i32> %result
}

; Negative test: shuffling mask doesn't fit pattern
define <4 x i32> @negative_test_extadd_pairwise_i16x8_u(<8 x i16> %v) {
; CHECK-LABEL: negative_test_extadd_pairwise_i16x8_u:
; CHECK:         .functype negative_test_extadd_pairwise_i16x8_u (v128) -> (v128)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 6, 7, 8, 9, 12, 13, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    i32x4.extend_low_i16x8_u
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 2, 3, 6, 7, 10, 11, 14, 15, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    i32x4.extend_low_i16x8_u
; CHECK-NEXT:    i32x4.add
; CHECK-NEXT:    # fallthrough-return
  %even = shufflevector <8 x i16> %v, <8 x i16> poison, <4 x i32> <i32 0, i32 3, i32 4, i32 6>
  %odd = shufflevector <8 x i16> %v, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %even_ext = zext <4 x i16> %even to <4 x i32>
  %odd_ext = zext <4 x i16> %odd to <4 x i32>
  %result = add <4 x i32> %even_ext, %odd_ext
  ret <4 x i32> %result
}
