; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -mattr=+simd128 | FileCheck %s --check-prefix=SIMD128
; RUN: llc < %s -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -mattr=+simd128 -fast-isel | FileCheck %s --check-prefix=SIMD128-FAST
; RUN: llc < %s -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers | FileCheck %s --check-prefix=NO-SIMD128
; RUN: llc < %s -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -fast-isel | FileCheck %s --check-prefix=NO-SIMD128-FAST

; check that a non-test run (including explicit locals pass) at least finishes
; RUN: llc < %s -O0 -mattr=+simd128
; RUN: llc < %s -O2 -mattr=+simd128

; Test that basic SIMD128 arithmetic operations assemble as expected.

target triple = "wasm32-unknown-unknown"

; ==============================================================================
; 16 x i8
; ==============================================================================
define <16 x i8> @add_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: add_v16i8:
; SIMD128:         .functype add_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v16i8:
; SIMD128-FAST:         .functype add_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v16i8:
; NO-SIMD128:         .functype add_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.add $push0=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop0
; NO-SIMD128-NEXT:    i32.add $push1=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop1
; NO-SIMD128-NEXT:    i32.add $push2=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop2
; NO-SIMD128-NEXT:    i32.add $push3=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop3
; NO-SIMD128-NEXT:    i32.add $push4=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop4
; NO-SIMD128-NEXT:    i32.add $push5=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop5
; NO-SIMD128-NEXT:    i32.add $push6=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop6
; NO-SIMD128-NEXT:    i32.add $push7=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop7
; NO-SIMD128-NEXT:    i32.add $push8=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop8
; NO-SIMD128-NEXT:    i32.add $push9=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop9
; NO-SIMD128-NEXT:    i32.add $push10=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop10
; NO-SIMD128-NEXT:    i32.add $push11=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop11
; NO-SIMD128-NEXT:    i32.add $push12=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop12
; NO-SIMD128-NEXT:    i32.add $push13=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop13
; NO-SIMD128-NEXT:    i32.add $push14=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop14
; NO-SIMD128-NEXT:    i32.add $push15=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop15
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v16i8:
; NO-SIMD128-FAST:         .functype add_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.add $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.add $push3=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.add $push7=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.add $push12=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.add $push13=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = add <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @sub_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: sub_v16i8:
; SIMD128:         .functype sub_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v16i8:
; SIMD128-FAST:         .functype sub_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v16i8:
; NO-SIMD128:         .functype sub_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.sub $push0=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop0
; NO-SIMD128-NEXT:    i32.sub $push1=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop1
; NO-SIMD128-NEXT:    i32.sub $push2=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop2
; NO-SIMD128-NEXT:    i32.sub $push3=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop3
; NO-SIMD128-NEXT:    i32.sub $push4=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop4
; NO-SIMD128-NEXT:    i32.sub $push5=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop5
; NO-SIMD128-NEXT:    i32.sub $push6=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop6
; NO-SIMD128-NEXT:    i32.sub $push7=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop7
; NO-SIMD128-NEXT:    i32.sub $push8=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop8
; NO-SIMD128-NEXT:    i32.sub $push9=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop9
; NO-SIMD128-NEXT:    i32.sub $push10=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop10
; NO-SIMD128-NEXT:    i32.sub $push11=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop11
; NO-SIMD128-NEXT:    i32.sub $push12=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop12
; NO-SIMD128-NEXT:    i32.sub $push13=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop13
; NO-SIMD128-NEXT:    i32.sub $push14=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop14
; NO-SIMD128-NEXT:    i32.sub $push15=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop15
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v16i8:
; NO-SIMD128-FAST:         .functype sub_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.sub $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.sub $push4=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.sub $push5=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.sub $push7=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.sub $push8=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.sub $push9=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.sub $push10=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.sub $push11=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.sub $push12=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.sub $push13=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.sub $push14=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.sub $push15=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @mul_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: mul_v16i8:
; SIMD128:         .functype mul_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extmul_low_i8x16_u $push1=, $0, $1
; SIMD128-NEXT:    i16x8.extmul_high_i8x16_u $push0=, $0, $1
; SIMD128-NEXT:    i8x16.shuffle $push2=, $pop1, $pop0, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30
; SIMD128-NEXT:    return $pop2
;
; SIMD128-FAST-LABEL: mul_v16i8:
; SIMD128-FAST:         .functype mul_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extmul_low_i8x16_u $push2=, $0, $1
; SIMD128-FAST-NEXT:    i16x8.extmul_high_i8x16_u $push1=, $0, $1
; SIMD128-FAST-NEXT:    i8x16.shuffle $push0=, $pop2, $pop1, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v16i8:
; NO-SIMD128:         .functype mul_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.mul $push0=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop0
; NO-SIMD128-NEXT:    i32.mul $push1=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop1
; NO-SIMD128-NEXT:    i32.mul $push2=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop2
; NO-SIMD128-NEXT:    i32.mul $push3=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop3
; NO-SIMD128-NEXT:    i32.mul $push4=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop4
; NO-SIMD128-NEXT:    i32.mul $push5=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop5
; NO-SIMD128-NEXT:    i32.mul $push6=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop6
; NO-SIMD128-NEXT:    i32.mul $push7=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop7
; NO-SIMD128-NEXT:    i32.mul $push8=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop8
; NO-SIMD128-NEXT:    i32.mul $push9=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop9
; NO-SIMD128-NEXT:    i32.mul $push10=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop10
; NO-SIMD128-NEXT:    i32.mul $push11=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop11
; NO-SIMD128-NEXT:    i32.mul $push12=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop12
; NO-SIMD128-NEXT:    i32.mul $push13=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop13
; NO-SIMD128-NEXT:    i32.mul $push14=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop14
; NO-SIMD128-NEXT:    i32.mul $push15=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop15
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v16i8:
; NO-SIMD128-FAST:         .functype mul_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.mul $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.mul $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.mul $push3=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.mul $push4=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.mul $push7=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.mul $push8=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.mul $push9=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.mul $push10=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.mul $push11=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.mul $push12=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.mul $push13=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.mul $push14=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.mul $push15=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = mul <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @min_s_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: min_s_v16i8:
; SIMD128:         .functype min_s_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.min_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_s_v16i8:
; SIMD128-FAST:         .functype min_s_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.min_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_s_v16i8:
; NO-SIMD128:         .functype min_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push1=, $16
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $32
; NO-SIMD128-NEXT:    i32.lt_s $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $16, $32, $pop2
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop3
; NO-SIMD128-NEXT:    i32.extend8_s $push5=, $15
; NO-SIMD128-NEXT:    i32.extend8_s $push4=, $31
; NO-SIMD128-NEXT:    i32.lt_s $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.select $push7=, $15, $31, $pop6
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop7
; NO-SIMD128-NEXT:    i32.extend8_s $push9=, $14
; NO-SIMD128-NEXT:    i32.extend8_s $push8=, $30
; NO-SIMD128-NEXT:    i32.lt_s $push10=, $pop9, $pop8
; NO-SIMD128-NEXT:    i32.select $push11=, $14, $30, $pop10
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop11
; NO-SIMD128-NEXT:    i32.extend8_s $push13=, $13
; NO-SIMD128-NEXT:    i32.extend8_s $push12=, $29
; NO-SIMD128-NEXT:    i32.lt_s $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.select $push15=, $13, $29, $pop14
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop15
; NO-SIMD128-NEXT:    i32.extend8_s $push17=, $12
; NO-SIMD128-NEXT:    i32.extend8_s $push16=, $28
; NO-SIMD128-NEXT:    i32.lt_s $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.select $push19=, $12, $28, $pop18
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop19
; NO-SIMD128-NEXT:    i32.extend8_s $push21=, $11
; NO-SIMD128-NEXT:    i32.extend8_s $push20=, $27
; NO-SIMD128-NEXT:    i32.lt_s $push22=, $pop21, $pop20
; NO-SIMD128-NEXT:    i32.select $push23=, $11, $27, $pop22
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop23
; NO-SIMD128-NEXT:    i32.extend8_s $push25=, $10
; NO-SIMD128-NEXT:    i32.extend8_s $push24=, $26
; NO-SIMD128-NEXT:    i32.lt_s $push26=, $pop25, $pop24
; NO-SIMD128-NEXT:    i32.select $push27=, $10, $26, $pop26
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop27
; NO-SIMD128-NEXT:    i32.extend8_s $push29=, $9
; NO-SIMD128-NEXT:    i32.extend8_s $push28=, $25
; NO-SIMD128-NEXT:    i32.lt_s $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.select $push31=, $9, $25, $pop30
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop31
; NO-SIMD128-NEXT:    i32.extend8_s $push33=, $8
; NO-SIMD128-NEXT:    i32.extend8_s $push32=, $24
; NO-SIMD128-NEXT:    i32.lt_s $push34=, $pop33, $pop32
; NO-SIMD128-NEXT:    i32.select $push35=, $8, $24, $pop34
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop35
; NO-SIMD128-NEXT:    i32.extend8_s $push37=, $7
; NO-SIMD128-NEXT:    i32.extend8_s $push36=, $23
; NO-SIMD128-NEXT:    i32.lt_s $push38=, $pop37, $pop36
; NO-SIMD128-NEXT:    i32.select $push39=, $7, $23, $pop38
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop39
; NO-SIMD128-NEXT:    i32.extend8_s $push41=, $6
; NO-SIMD128-NEXT:    i32.extend8_s $push40=, $22
; NO-SIMD128-NEXT:    i32.lt_s $push42=, $pop41, $pop40
; NO-SIMD128-NEXT:    i32.select $push43=, $6, $22, $pop42
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop43
; NO-SIMD128-NEXT:    i32.extend8_s $push45=, $5
; NO-SIMD128-NEXT:    i32.extend8_s $push44=, $21
; NO-SIMD128-NEXT:    i32.lt_s $push46=, $pop45, $pop44
; NO-SIMD128-NEXT:    i32.select $push47=, $5, $21, $pop46
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop47
; NO-SIMD128-NEXT:    i32.extend8_s $push49=, $4
; NO-SIMD128-NEXT:    i32.extend8_s $push48=, $20
; NO-SIMD128-NEXT:    i32.lt_s $push50=, $pop49, $pop48
; NO-SIMD128-NEXT:    i32.select $push51=, $4, $20, $pop50
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop51
; NO-SIMD128-NEXT:    i32.extend8_s $push53=, $3
; NO-SIMD128-NEXT:    i32.extend8_s $push52=, $19
; NO-SIMD128-NEXT:    i32.lt_s $push54=, $pop53, $pop52
; NO-SIMD128-NEXT:    i32.select $push55=, $3, $19, $pop54
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop55
; NO-SIMD128-NEXT:    i32.extend8_s $push57=, $2
; NO-SIMD128-NEXT:    i32.extend8_s $push56=, $18
; NO-SIMD128-NEXT:    i32.lt_s $push58=, $pop57, $pop56
; NO-SIMD128-NEXT:    i32.select $push59=, $2, $18, $pop58
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop59
; NO-SIMD128-NEXT:    i32.extend8_s $push61=, $1
; NO-SIMD128-NEXT:    i32.extend8_s $push60=, $17
; NO-SIMD128-NEXT:    i32.lt_s $push62=, $pop61, $pop60
; NO-SIMD128-NEXT:    i32.select $push63=, $1, $17, $pop62
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop63
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_s_v16i8:
; NO-SIMD128-FAST:         .functype min_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push0=, $17
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $1, $17, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push4=, $18
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $2, $18, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push9=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push8=, $19
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $3, $19, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push13=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push12=, $20
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $4, $20, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push17=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push16=, $21
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push18=, $pop17, $pop16
; NO-SIMD128-FAST-NEXT:    i32.select $push19=, $5, $21, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop19
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push21=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push20=, $22
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push22=, $pop21, $pop20
; NO-SIMD128-FAST-NEXT:    i32.select $push23=, $6, $22, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop23
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push25=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push24=, $23
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push26=, $pop25, $pop24
; NO-SIMD128-FAST-NEXT:    i32.select $push27=, $7, $23, $pop26
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop27
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push29=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push28=, $24
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.select $push31=, $8, $24, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop31
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push33=, $9
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push32=, $25
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push34=, $pop33, $pop32
; NO-SIMD128-FAST-NEXT:    i32.select $push35=, $9, $25, $pop34
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop35
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push37=, $10
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push36=, $26
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push38=, $pop37, $pop36
; NO-SIMD128-FAST-NEXT:    i32.select $push39=, $10, $26, $pop38
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop39
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push41=, $11
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push40=, $27
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push42=, $pop41, $pop40
; NO-SIMD128-FAST-NEXT:    i32.select $push43=, $11, $27, $pop42
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop43
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push45=, $12
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push44=, $28
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push46=, $pop45, $pop44
; NO-SIMD128-FAST-NEXT:    i32.select $push47=, $12, $28, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop47
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push49=, $13
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push48=, $29
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push50=, $pop49, $pop48
; NO-SIMD128-FAST-NEXT:    i32.select $push51=, $13, $29, $pop50
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop51
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push53=, $14
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push52=, $30
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push54=, $pop53, $pop52
; NO-SIMD128-FAST-NEXT:    i32.select $push55=, $14, $30, $pop54
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop55
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push57=, $15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push56=, $31
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push58=, $pop57, $pop56
; NO-SIMD128-FAST-NEXT:    i32.select $push59=, $15, $31, $pop58
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop59
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push61=, $16
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push60=, $32
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push62=, $pop61, $pop60
; NO-SIMD128-FAST-NEXT:    i32.select $push63=, $16, $32, $pop62
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop63
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp slt <16 x i8> %x, %y
  %a = select <16 x i1> %c, <16 x i8> %x, <16 x i8> %y
  ret <16 x i8> %a
}

define <16 x i8> @min_u_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: min_u_v16i8:
; SIMD128:         .functype min_u_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.min_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_u_v16i8:
; SIMD128-FAST:         .functype min_u_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.min_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_u_v16i8:
; NO-SIMD128:         .functype min_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $16, $pop0
; NO-SIMD128-NEXT:    i32.const $push95=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $32, $pop95
; NO-SIMD128-NEXT:    i32.lt_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.select $push4=, $16, $32, $pop3
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push94=, 255
; NO-SIMD128-NEXT:    i32.and $push6=, $15, $pop94
; NO-SIMD128-NEXT:    i32.const $push93=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $31, $pop93
; NO-SIMD128-NEXT:    i32.lt_u $push7=, $pop6, $pop5
; NO-SIMD128-NEXT:    i32.select $push8=, $15, $31, $pop7
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push92=, 255
; NO-SIMD128-NEXT:    i32.and $push10=, $14, $pop92
; NO-SIMD128-NEXT:    i32.const $push91=, 255
; NO-SIMD128-NEXT:    i32.and $push9=, $30, $pop91
; NO-SIMD128-NEXT:    i32.lt_u $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.select $push12=, $14, $30, $pop11
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push90=, 255
; NO-SIMD128-NEXT:    i32.and $push14=, $13, $pop90
; NO-SIMD128-NEXT:    i32.const $push89=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $29, $pop89
; NO-SIMD128-NEXT:    i32.lt_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.select $push16=, $13, $29, $pop15
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop16
; NO-SIMD128-NEXT:    i32.const $push88=, 255
; NO-SIMD128-NEXT:    i32.and $push18=, $12, $pop88
; NO-SIMD128-NEXT:    i32.const $push87=, 255
; NO-SIMD128-NEXT:    i32.and $push17=, $28, $pop87
; NO-SIMD128-NEXT:    i32.lt_u $push19=, $pop18, $pop17
; NO-SIMD128-NEXT:    i32.select $push20=, $12, $28, $pop19
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop20
; NO-SIMD128-NEXT:    i32.const $push86=, 255
; NO-SIMD128-NEXT:    i32.and $push22=, $11, $pop86
; NO-SIMD128-NEXT:    i32.const $push85=, 255
; NO-SIMD128-NEXT:    i32.and $push21=, $27, $pop85
; NO-SIMD128-NEXT:    i32.lt_u $push23=, $pop22, $pop21
; NO-SIMD128-NEXT:    i32.select $push24=, $11, $27, $pop23
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop24
; NO-SIMD128-NEXT:    i32.const $push84=, 255
; NO-SIMD128-NEXT:    i32.and $push26=, $10, $pop84
; NO-SIMD128-NEXT:    i32.const $push83=, 255
; NO-SIMD128-NEXT:    i32.and $push25=, $26, $pop83
; NO-SIMD128-NEXT:    i32.lt_u $push27=, $pop26, $pop25
; NO-SIMD128-NEXT:    i32.select $push28=, $10, $26, $pop27
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop28
; NO-SIMD128-NEXT:    i32.const $push82=, 255
; NO-SIMD128-NEXT:    i32.and $push30=, $9, $pop82
; NO-SIMD128-NEXT:    i32.const $push81=, 255
; NO-SIMD128-NEXT:    i32.and $push29=, $25, $pop81
; NO-SIMD128-NEXT:    i32.lt_u $push31=, $pop30, $pop29
; NO-SIMD128-NEXT:    i32.select $push32=, $9, $25, $pop31
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop32
; NO-SIMD128-NEXT:    i32.const $push80=, 255
; NO-SIMD128-NEXT:    i32.and $push34=, $8, $pop80
; NO-SIMD128-NEXT:    i32.const $push79=, 255
; NO-SIMD128-NEXT:    i32.and $push33=, $24, $pop79
; NO-SIMD128-NEXT:    i32.lt_u $push35=, $pop34, $pop33
; NO-SIMD128-NEXT:    i32.select $push36=, $8, $24, $pop35
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop36
; NO-SIMD128-NEXT:    i32.const $push78=, 255
; NO-SIMD128-NEXT:    i32.and $push38=, $7, $pop78
; NO-SIMD128-NEXT:    i32.const $push77=, 255
; NO-SIMD128-NEXT:    i32.and $push37=, $23, $pop77
; NO-SIMD128-NEXT:    i32.lt_u $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.select $push40=, $7, $23, $pop39
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop40
; NO-SIMD128-NEXT:    i32.const $push76=, 255
; NO-SIMD128-NEXT:    i32.and $push42=, $6, $pop76
; NO-SIMD128-NEXT:    i32.const $push75=, 255
; NO-SIMD128-NEXT:    i32.and $push41=, $22, $pop75
; NO-SIMD128-NEXT:    i32.lt_u $push43=, $pop42, $pop41
; NO-SIMD128-NEXT:    i32.select $push44=, $6, $22, $pop43
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop44
; NO-SIMD128-NEXT:    i32.const $push74=, 255
; NO-SIMD128-NEXT:    i32.and $push46=, $5, $pop74
; NO-SIMD128-NEXT:    i32.const $push73=, 255
; NO-SIMD128-NEXT:    i32.and $push45=, $21, $pop73
; NO-SIMD128-NEXT:    i32.lt_u $push47=, $pop46, $pop45
; NO-SIMD128-NEXT:    i32.select $push48=, $5, $21, $pop47
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop48
; NO-SIMD128-NEXT:    i32.const $push72=, 255
; NO-SIMD128-NEXT:    i32.and $push50=, $4, $pop72
; NO-SIMD128-NEXT:    i32.const $push71=, 255
; NO-SIMD128-NEXT:    i32.and $push49=, $20, $pop71
; NO-SIMD128-NEXT:    i32.lt_u $push51=, $pop50, $pop49
; NO-SIMD128-NEXT:    i32.select $push52=, $4, $20, $pop51
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop52
; NO-SIMD128-NEXT:    i32.const $push70=, 255
; NO-SIMD128-NEXT:    i32.and $push54=, $3, $pop70
; NO-SIMD128-NEXT:    i32.const $push69=, 255
; NO-SIMD128-NEXT:    i32.and $push53=, $19, $pop69
; NO-SIMD128-NEXT:    i32.lt_u $push55=, $pop54, $pop53
; NO-SIMD128-NEXT:    i32.select $push56=, $3, $19, $pop55
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop56
; NO-SIMD128-NEXT:    i32.const $push68=, 255
; NO-SIMD128-NEXT:    i32.and $push58=, $2, $pop68
; NO-SIMD128-NEXT:    i32.const $push67=, 255
; NO-SIMD128-NEXT:    i32.and $push57=, $18, $pop67
; NO-SIMD128-NEXT:    i32.lt_u $push59=, $pop58, $pop57
; NO-SIMD128-NEXT:    i32.select $push60=, $2, $18, $pop59
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop60
; NO-SIMD128-NEXT:    i32.const $push66=, 255
; NO-SIMD128-NEXT:    i32.and $push62=, $1, $pop66
; NO-SIMD128-NEXT:    i32.const $push65=, 255
; NO-SIMD128-NEXT:    i32.and $push61=, $17, $pop65
; NO-SIMD128-NEXT:    i32.lt_u $push63=, $pop62, $pop61
; NO-SIMD128-NEXT:    i32.select $push64=, $1, $17, $pop63
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop64
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_u_v16i8:
; NO-SIMD128-FAST:         .functype min_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop95
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.select $push4=, $1, $17, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $2, $pop94
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $18, $pop93
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.select $push8=, $2, $18, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $3, $pop92
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $19, $pop91
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.select $push12=, $3, $19, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $4, $pop90
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $20, $pop89
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.select $push16=, $4, $20, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $5, $pop88
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $21, $pop87
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push19=, $pop18, $pop17
; NO-SIMD128-FAST-NEXT:    i32.select $push20=, $5, $21, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push86=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $6, $pop86
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $22, $pop85
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push23=, $pop22, $pop21
; NO-SIMD128-FAST-NEXT:    i32.select $push24=, $6, $22, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push26=, $7, $pop84
; NO-SIMD128-FAST-NEXT:    i32.const $push83=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $23, $pop83
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push27=, $pop26, $pop25
; NO-SIMD128-FAST-NEXT:    i32.select $push28=, $7, $23, $pop27
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push82=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $8, $pop82
; NO-SIMD128-FAST-NEXT:    i32.const $push81=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $24, $pop81
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.select $push32=, $8, $24, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push80=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $9, $pop80
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push33=, $25, $pop79
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push35=, $pop34, $pop33
; NO-SIMD128-FAST-NEXT:    i32.select $push36=, $9, $25, $pop35
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push38=, $10, $pop78
; NO-SIMD128-FAST-NEXT:    i32.const $push77=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $26, $pop77
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push39=, $pop38, $pop37
; NO-SIMD128-FAST-NEXT:    i32.select $push40=, $10, $26, $pop39
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop40
; NO-SIMD128-FAST-NEXT:    i32.const $push76=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push42=, $11, $pop76
; NO-SIMD128-FAST-NEXT:    i32.const $push75=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push41=, $27, $pop75
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push43=, $pop42, $pop41
; NO-SIMD128-FAST-NEXT:    i32.select $push44=, $11, $27, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push74=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push46=, $12, $pop74
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push45=, $28, $pop73
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push47=, $pop46, $pop45
; NO-SIMD128-FAST-NEXT:    i32.select $push48=, $12, $28, $pop47
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push50=, $13, $pop72
; NO-SIMD128-FAST-NEXT:    i32.const $push71=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push49=, $29, $pop71
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push51=, $pop50, $pop49
; NO-SIMD128-FAST-NEXT:    i32.select $push52=, $13, $29, $pop51
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop52
; NO-SIMD128-FAST-NEXT:    i32.const $push70=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push54=, $14, $pop70
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push53=, $30, $pop69
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push55=, $pop54, $pop53
; NO-SIMD128-FAST-NEXT:    i32.select $push56=, $14, $30, $pop55
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop56
; NO-SIMD128-FAST-NEXT:    i32.const $push68=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push58=, $15, $pop68
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push57=, $31, $pop67
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push59=, $pop58, $pop57
; NO-SIMD128-FAST-NEXT:    i32.select $push60=, $15, $31, $pop59
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop60
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push62=, $16, $pop66
; NO-SIMD128-FAST-NEXT:    i32.const $push65=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push61=, $32, $pop65
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push63=, $pop62, $pop61
; NO-SIMD128-FAST-NEXT:    i32.select $push64=, $16, $32, $pop63
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop64
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ult <16 x i8> %x, %y
  %a = select <16 x i1> %c, <16 x i8> %x, <16 x i8> %y
  ret <16 x i8> %a
}

define <16 x i8> @max_s_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: max_s_v16i8:
; SIMD128:         .functype max_s_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.max_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_s_v16i8:
; SIMD128-FAST:         .functype max_s_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.max_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_s_v16i8:
; NO-SIMD128:         .functype max_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push1=, $16
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $32
; NO-SIMD128-NEXT:    i32.gt_s $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $16, $32, $pop2
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop3
; NO-SIMD128-NEXT:    i32.extend8_s $push5=, $15
; NO-SIMD128-NEXT:    i32.extend8_s $push4=, $31
; NO-SIMD128-NEXT:    i32.gt_s $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.select $push7=, $15, $31, $pop6
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop7
; NO-SIMD128-NEXT:    i32.extend8_s $push9=, $14
; NO-SIMD128-NEXT:    i32.extend8_s $push8=, $30
; NO-SIMD128-NEXT:    i32.gt_s $push10=, $pop9, $pop8
; NO-SIMD128-NEXT:    i32.select $push11=, $14, $30, $pop10
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop11
; NO-SIMD128-NEXT:    i32.extend8_s $push13=, $13
; NO-SIMD128-NEXT:    i32.extend8_s $push12=, $29
; NO-SIMD128-NEXT:    i32.gt_s $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.select $push15=, $13, $29, $pop14
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop15
; NO-SIMD128-NEXT:    i32.extend8_s $push17=, $12
; NO-SIMD128-NEXT:    i32.extend8_s $push16=, $28
; NO-SIMD128-NEXT:    i32.gt_s $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.select $push19=, $12, $28, $pop18
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop19
; NO-SIMD128-NEXT:    i32.extend8_s $push21=, $11
; NO-SIMD128-NEXT:    i32.extend8_s $push20=, $27
; NO-SIMD128-NEXT:    i32.gt_s $push22=, $pop21, $pop20
; NO-SIMD128-NEXT:    i32.select $push23=, $11, $27, $pop22
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop23
; NO-SIMD128-NEXT:    i32.extend8_s $push25=, $10
; NO-SIMD128-NEXT:    i32.extend8_s $push24=, $26
; NO-SIMD128-NEXT:    i32.gt_s $push26=, $pop25, $pop24
; NO-SIMD128-NEXT:    i32.select $push27=, $10, $26, $pop26
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop27
; NO-SIMD128-NEXT:    i32.extend8_s $push29=, $9
; NO-SIMD128-NEXT:    i32.extend8_s $push28=, $25
; NO-SIMD128-NEXT:    i32.gt_s $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.select $push31=, $9, $25, $pop30
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop31
; NO-SIMD128-NEXT:    i32.extend8_s $push33=, $8
; NO-SIMD128-NEXT:    i32.extend8_s $push32=, $24
; NO-SIMD128-NEXT:    i32.gt_s $push34=, $pop33, $pop32
; NO-SIMD128-NEXT:    i32.select $push35=, $8, $24, $pop34
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop35
; NO-SIMD128-NEXT:    i32.extend8_s $push37=, $7
; NO-SIMD128-NEXT:    i32.extend8_s $push36=, $23
; NO-SIMD128-NEXT:    i32.gt_s $push38=, $pop37, $pop36
; NO-SIMD128-NEXT:    i32.select $push39=, $7, $23, $pop38
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop39
; NO-SIMD128-NEXT:    i32.extend8_s $push41=, $6
; NO-SIMD128-NEXT:    i32.extend8_s $push40=, $22
; NO-SIMD128-NEXT:    i32.gt_s $push42=, $pop41, $pop40
; NO-SIMD128-NEXT:    i32.select $push43=, $6, $22, $pop42
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop43
; NO-SIMD128-NEXT:    i32.extend8_s $push45=, $5
; NO-SIMD128-NEXT:    i32.extend8_s $push44=, $21
; NO-SIMD128-NEXT:    i32.gt_s $push46=, $pop45, $pop44
; NO-SIMD128-NEXT:    i32.select $push47=, $5, $21, $pop46
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop47
; NO-SIMD128-NEXT:    i32.extend8_s $push49=, $4
; NO-SIMD128-NEXT:    i32.extend8_s $push48=, $20
; NO-SIMD128-NEXT:    i32.gt_s $push50=, $pop49, $pop48
; NO-SIMD128-NEXT:    i32.select $push51=, $4, $20, $pop50
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop51
; NO-SIMD128-NEXT:    i32.extend8_s $push53=, $3
; NO-SIMD128-NEXT:    i32.extend8_s $push52=, $19
; NO-SIMD128-NEXT:    i32.gt_s $push54=, $pop53, $pop52
; NO-SIMD128-NEXT:    i32.select $push55=, $3, $19, $pop54
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop55
; NO-SIMD128-NEXT:    i32.extend8_s $push57=, $2
; NO-SIMD128-NEXT:    i32.extend8_s $push56=, $18
; NO-SIMD128-NEXT:    i32.gt_s $push58=, $pop57, $pop56
; NO-SIMD128-NEXT:    i32.select $push59=, $2, $18, $pop58
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop59
; NO-SIMD128-NEXT:    i32.extend8_s $push61=, $1
; NO-SIMD128-NEXT:    i32.extend8_s $push60=, $17
; NO-SIMD128-NEXT:    i32.gt_s $push62=, $pop61, $pop60
; NO-SIMD128-NEXT:    i32.select $push63=, $1, $17, $pop62
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop63
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_s_v16i8:
; NO-SIMD128-FAST:         .functype max_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push0=, $17
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $1, $17, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push4=, $18
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $2, $18, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push9=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push8=, $19
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $3, $19, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push13=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push12=, $20
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $4, $20, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push17=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push16=, $21
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push18=, $pop17, $pop16
; NO-SIMD128-FAST-NEXT:    i32.select $push19=, $5, $21, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop19
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push21=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push20=, $22
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push22=, $pop21, $pop20
; NO-SIMD128-FAST-NEXT:    i32.select $push23=, $6, $22, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop23
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push25=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push24=, $23
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push26=, $pop25, $pop24
; NO-SIMD128-FAST-NEXT:    i32.select $push27=, $7, $23, $pop26
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop27
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push29=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push28=, $24
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.select $push31=, $8, $24, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop31
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push33=, $9
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push32=, $25
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push34=, $pop33, $pop32
; NO-SIMD128-FAST-NEXT:    i32.select $push35=, $9, $25, $pop34
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop35
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push37=, $10
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push36=, $26
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push38=, $pop37, $pop36
; NO-SIMD128-FAST-NEXT:    i32.select $push39=, $10, $26, $pop38
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop39
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push41=, $11
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push40=, $27
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push42=, $pop41, $pop40
; NO-SIMD128-FAST-NEXT:    i32.select $push43=, $11, $27, $pop42
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop43
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push45=, $12
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push44=, $28
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push46=, $pop45, $pop44
; NO-SIMD128-FAST-NEXT:    i32.select $push47=, $12, $28, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop47
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push49=, $13
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push48=, $29
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push50=, $pop49, $pop48
; NO-SIMD128-FAST-NEXT:    i32.select $push51=, $13, $29, $pop50
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop51
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push53=, $14
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push52=, $30
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push54=, $pop53, $pop52
; NO-SIMD128-FAST-NEXT:    i32.select $push55=, $14, $30, $pop54
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop55
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push57=, $15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push56=, $31
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push58=, $pop57, $pop56
; NO-SIMD128-FAST-NEXT:    i32.select $push59=, $15, $31, $pop58
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop59
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push61=, $16
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push60=, $32
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push62=, $pop61, $pop60
; NO-SIMD128-FAST-NEXT:    i32.select $push63=, $16, $32, $pop62
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop63
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp sgt <16 x i8> %x, %y
  %a = select <16 x i1> %c, <16 x i8> %x, <16 x i8> %y
  ret <16 x i8> %a
}

define <16 x i8> @max_u_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: max_u_v16i8:
; SIMD128:         .functype max_u_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.max_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_u_v16i8:
; SIMD128-FAST:         .functype max_u_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.max_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_u_v16i8:
; NO-SIMD128:         .functype max_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $16, $pop0
; NO-SIMD128-NEXT:    i32.const $push95=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $32, $pop95
; NO-SIMD128-NEXT:    i32.gt_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.select $push4=, $16, $32, $pop3
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push94=, 255
; NO-SIMD128-NEXT:    i32.and $push6=, $15, $pop94
; NO-SIMD128-NEXT:    i32.const $push93=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $31, $pop93
; NO-SIMD128-NEXT:    i32.gt_u $push7=, $pop6, $pop5
; NO-SIMD128-NEXT:    i32.select $push8=, $15, $31, $pop7
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push92=, 255
; NO-SIMD128-NEXT:    i32.and $push10=, $14, $pop92
; NO-SIMD128-NEXT:    i32.const $push91=, 255
; NO-SIMD128-NEXT:    i32.and $push9=, $30, $pop91
; NO-SIMD128-NEXT:    i32.gt_u $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.select $push12=, $14, $30, $pop11
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push90=, 255
; NO-SIMD128-NEXT:    i32.and $push14=, $13, $pop90
; NO-SIMD128-NEXT:    i32.const $push89=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $29, $pop89
; NO-SIMD128-NEXT:    i32.gt_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.select $push16=, $13, $29, $pop15
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop16
; NO-SIMD128-NEXT:    i32.const $push88=, 255
; NO-SIMD128-NEXT:    i32.and $push18=, $12, $pop88
; NO-SIMD128-NEXT:    i32.const $push87=, 255
; NO-SIMD128-NEXT:    i32.and $push17=, $28, $pop87
; NO-SIMD128-NEXT:    i32.gt_u $push19=, $pop18, $pop17
; NO-SIMD128-NEXT:    i32.select $push20=, $12, $28, $pop19
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop20
; NO-SIMD128-NEXT:    i32.const $push86=, 255
; NO-SIMD128-NEXT:    i32.and $push22=, $11, $pop86
; NO-SIMD128-NEXT:    i32.const $push85=, 255
; NO-SIMD128-NEXT:    i32.and $push21=, $27, $pop85
; NO-SIMD128-NEXT:    i32.gt_u $push23=, $pop22, $pop21
; NO-SIMD128-NEXT:    i32.select $push24=, $11, $27, $pop23
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop24
; NO-SIMD128-NEXT:    i32.const $push84=, 255
; NO-SIMD128-NEXT:    i32.and $push26=, $10, $pop84
; NO-SIMD128-NEXT:    i32.const $push83=, 255
; NO-SIMD128-NEXT:    i32.and $push25=, $26, $pop83
; NO-SIMD128-NEXT:    i32.gt_u $push27=, $pop26, $pop25
; NO-SIMD128-NEXT:    i32.select $push28=, $10, $26, $pop27
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop28
; NO-SIMD128-NEXT:    i32.const $push82=, 255
; NO-SIMD128-NEXT:    i32.and $push30=, $9, $pop82
; NO-SIMD128-NEXT:    i32.const $push81=, 255
; NO-SIMD128-NEXT:    i32.and $push29=, $25, $pop81
; NO-SIMD128-NEXT:    i32.gt_u $push31=, $pop30, $pop29
; NO-SIMD128-NEXT:    i32.select $push32=, $9, $25, $pop31
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop32
; NO-SIMD128-NEXT:    i32.const $push80=, 255
; NO-SIMD128-NEXT:    i32.and $push34=, $8, $pop80
; NO-SIMD128-NEXT:    i32.const $push79=, 255
; NO-SIMD128-NEXT:    i32.and $push33=, $24, $pop79
; NO-SIMD128-NEXT:    i32.gt_u $push35=, $pop34, $pop33
; NO-SIMD128-NEXT:    i32.select $push36=, $8, $24, $pop35
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop36
; NO-SIMD128-NEXT:    i32.const $push78=, 255
; NO-SIMD128-NEXT:    i32.and $push38=, $7, $pop78
; NO-SIMD128-NEXT:    i32.const $push77=, 255
; NO-SIMD128-NEXT:    i32.and $push37=, $23, $pop77
; NO-SIMD128-NEXT:    i32.gt_u $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.select $push40=, $7, $23, $pop39
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop40
; NO-SIMD128-NEXT:    i32.const $push76=, 255
; NO-SIMD128-NEXT:    i32.and $push42=, $6, $pop76
; NO-SIMD128-NEXT:    i32.const $push75=, 255
; NO-SIMD128-NEXT:    i32.and $push41=, $22, $pop75
; NO-SIMD128-NEXT:    i32.gt_u $push43=, $pop42, $pop41
; NO-SIMD128-NEXT:    i32.select $push44=, $6, $22, $pop43
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop44
; NO-SIMD128-NEXT:    i32.const $push74=, 255
; NO-SIMD128-NEXT:    i32.and $push46=, $5, $pop74
; NO-SIMD128-NEXT:    i32.const $push73=, 255
; NO-SIMD128-NEXT:    i32.and $push45=, $21, $pop73
; NO-SIMD128-NEXT:    i32.gt_u $push47=, $pop46, $pop45
; NO-SIMD128-NEXT:    i32.select $push48=, $5, $21, $pop47
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop48
; NO-SIMD128-NEXT:    i32.const $push72=, 255
; NO-SIMD128-NEXT:    i32.and $push50=, $4, $pop72
; NO-SIMD128-NEXT:    i32.const $push71=, 255
; NO-SIMD128-NEXT:    i32.and $push49=, $20, $pop71
; NO-SIMD128-NEXT:    i32.gt_u $push51=, $pop50, $pop49
; NO-SIMD128-NEXT:    i32.select $push52=, $4, $20, $pop51
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop52
; NO-SIMD128-NEXT:    i32.const $push70=, 255
; NO-SIMD128-NEXT:    i32.and $push54=, $3, $pop70
; NO-SIMD128-NEXT:    i32.const $push69=, 255
; NO-SIMD128-NEXT:    i32.and $push53=, $19, $pop69
; NO-SIMD128-NEXT:    i32.gt_u $push55=, $pop54, $pop53
; NO-SIMD128-NEXT:    i32.select $push56=, $3, $19, $pop55
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop56
; NO-SIMD128-NEXT:    i32.const $push68=, 255
; NO-SIMD128-NEXT:    i32.and $push58=, $2, $pop68
; NO-SIMD128-NEXT:    i32.const $push67=, 255
; NO-SIMD128-NEXT:    i32.and $push57=, $18, $pop67
; NO-SIMD128-NEXT:    i32.gt_u $push59=, $pop58, $pop57
; NO-SIMD128-NEXT:    i32.select $push60=, $2, $18, $pop59
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop60
; NO-SIMD128-NEXT:    i32.const $push66=, 255
; NO-SIMD128-NEXT:    i32.and $push62=, $1, $pop66
; NO-SIMD128-NEXT:    i32.const $push65=, 255
; NO-SIMD128-NEXT:    i32.and $push61=, $17, $pop65
; NO-SIMD128-NEXT:    i32.gt_u $push63=, $pop62, $pop61
; NO-SIMD128-NEXT:    i32.select $push64=, $1, $17, $pop63
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop64
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_u_v16i8:
; NO-SIMD128-FAST:         .functype max_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop95
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.select $push4=, $1, $17, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $2, $pop94
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $18, $pop93
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.select $push8=, $2, $18, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $3, $pop92
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $19, $pop91
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.select $push12=, $3, $19, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $4, $pop90
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $20, $pop89
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.select $push16=, $4, $20, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $5, $pop88
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $21, $pop87
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push19=, $pop18, $pop17
; NO-SIMD128-FAST-NEXT:    i32.select $push20=, $5, $21, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push86=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $6, $pop86
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $22, $pop85
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push23=, $pop22, $pop21
; NO-SIMD128-FAST-NEXT:    i32.select $push24=, $6, $22, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push26=, $7, $pop84
; NO-SIMD128-FAST-NEXT:    i32.const $push83=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $23, $pop83
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push27=, $pop26, $pop25
; NO-SIMD128-FAST-NEXT:    i32.select $push28=, $7, $23, $pop27
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push82=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $8, $pop82
; NO-SIMD128-FAST-NEXT:    i32.const $push81=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $24, $pop81
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.select $push32=, $8, $24, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push80=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $9, $pop80
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push33=, $25, $pop79
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push35=, $pop34, $pop33
; NO-SIMD128-FAST-NEXT:    i32.select $push36=, $9, $25, $pop35
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push38=, $10, $pop78
; NO-SIMD128-FAST-NEXT:    i32.const $push77=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $26, $pop77
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push39=, $pop38, $pop37
; NO-SIMD128-FAST-NEXT:    i32.select $push40=, $10, $26, $pop39
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop40
; NO-SIMD128-FAST-NEXT:    i32.const $push76=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push42=, $11, $pop76
; NO-SIMD128-FAST-NEXT:    i32.const $push75=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push41=, $27, $pop75
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push43=, $pop42, $pop41
; NO-SIMD128-FAST-NEXT:    i32.select $push44=, $11, $27, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push74=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push46=, $12, $pop74
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push45=, $28, $pop73
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push47=, $pop46, $pop45
; NO-SIMD128-FAST-NEXT:    i32.select $push48=, $12, $28, $pop47
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push50=, $13, $pop72
; NO-SIMD128-FAST-NEXT:    i32.const $push71=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push49=, $29, $pop71
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push51=, $pop50, $pop49
; NO-SIMD128-FAST-NEXT:    i32.select $push52=, $13, $29, $pop51
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop52
; NO-SIMD128-FAST-NEXT:    i32.const $push70=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push54=, $14, $pop70
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push53=, $30, $pop69
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push55=, $pop54, $pop53
; NO-SIMD128-FAST-NEXT:    i32.select $push56=, $14, $30, $pop55
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop56
; NO-SIMD128-FAST-NEXT:    i32.const $push68=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push58=, $15, $pop68
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push57=, $31, $pop67
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push59=, $pop58, $pop57
; NO-SIMD128-FAST-NEXT:    i32.select $push60=, $15, $31, $pop59
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop60
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push62=, $16, $pop66
; NO-SIMD128-FAST-NEXT:    i32.const $push65=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push61=, $32, $pop65
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push63=, $pop62, $pop61
; NO-SIMD128-FAST-NEXT:    i32.select $push64=, $16, $32, $pop63
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop64
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ugt <16 x i8> %x, %y
  %a = select <16 x i1> %c, <16 x i8> %x, <16 x i8> %y
  ret <16 x i8> %a
}

define <16 x i8> @avgr_u_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: avgr_u_v16i8:
; SIMD128:         .functype avgr_u_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.avgr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: avgr_u_v16i8:
; SIMD128-FAST:         .functype avgr_u_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.avgr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: avgr_u_v16i8:
; NO-SIMD128:         .functype avgr_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.add $push0=, $16, $32
; NO-SIMD128-NEXT:    i32.const $push1=, 1
; NO-SIMD128-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-NEXT:    i32.const $push3=, 254
; NO-SIMD128-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-NEXT:    i32.const $push111=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push5=, $pop4, $pop111
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop5
; NO-SIMD128-NEXT:    i32.add $push6=, $15, $31
; NO-SIMD128-NEXT:    i32.const $push110=, 1
; NO-SIMD128-NEXT:    i32.add $push7=, $pop6, $pop110
; NO-SIMD128-NEXT:    i32.const $push109=, 254
; NO-SIMD128-NEXT:    i32.and $push8=, $pop7, $pop109
; NO-SIMD128-NEXT:    i32.const $push108=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push9=, $pop8, $pop108
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop9
; NO-SIMD128-NEXT:    i32.add $push10=, $14, $30
; NO-SIMD128-NEXT:    i32.const $push107=, 1
; NO-SIMD128-NEXT:    i32.add $push11=, $pop10, $pop107
; NO-SIMD128-NEXT:    i32.const $push106=, 254
; NO-SIMD128-NEXT:    i32.and $push12=, $pop11, $pop106
; NO-SIMD128-NEXT:    i32.const $push105=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push13=, $pop12, $pop105
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop13
; NO-SIMD128-NEXT:    i32.add $push14=, $13, $29
; NO-SIMD128-NEXT:    i32.const $push104=, 1
; NO-SIMD128-NEXT:    i32.add $push15=, $pop14, $pop104
; NO-SIMD128-NEXT:    i32.const $push103=, 254
; NO-SIMD128-NEXT:    i32.and $push16=, $pop15, $pop103
; NO-SIMD128-NEXT:    i32.const $push102=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push17=, $pop16, $pop102
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop17
; NO-SIMD128-NEXT:    i32.add $push18=, $12, $28
; NO-SIMD128-NEXT:    i32.const $push101=, 1
; NO-SIMD128-NEXT:    i32.add $push19=, $pop18, $pop101
; NO-SIMD128-NEXT:    i32.const $push100=, 254
; NO-SIMD128-NEXT:    i32.and $push20=, $pop19, $pop100
; NO-SIMD128-NEXT:    i32.const $push99=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push21=, $pop20, $pop99
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop21
; NO-SIMD128-NEXT:    i32.add $push22=, $11, $27
; NO-SIMD128-NEXT:    i32.const $push98=, 1
; NO-SIMD128-NEXT:    i32.add $push23=, $pop22, $pop98
; NO-SIMD128-NEXT:    i32.const $push97=, 254
; NO-SIMD128-NEXT:    i32.and $push24=, $pop23, $pop97
; NO-SIMD128-NEXT:    i32.const $push96=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push25=, $pop24, $pop96
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop25
; NO-SIMD128-NEXT:    i32.add $push26=, $10, $26
; NO-SIMD128-NEXT:    i32.const $push95=, 1
; NO-SIMD128-NEXT:    i32.add $push27=, $pop26, $pop95
; NO-SIMD128-NEXT:    i32.const $push94=, 254
; NO-SIMD128-NEXT:    i32.and $push28=, $pop27, $pop94
; NO-SIMD128-NEXT:    i32.const $push93=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push29=, $pop28, $pop93
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop29
; NO-SIMD128-NEXT:    i32.add $push30=, $9, $25
; NO-SIMD128-NEXT:    i32.const $push92=, 1
; NO-SIMD128-NEXT:    i32.add $push31=, $pop30, $pop92
; NO-SIMD128-NEXT:    i32.const $push91=, 254
; NO-SIMD128-NEXT:    i32.and $push32=, $pop31, $pop91
; NO-SIMD128-NEXT:    i32.const $push90=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push33=, $pop32, $pop90
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop33
; NO-SIMD128-NEXT:    i32.add $push34=, $8, $24
; NO-SIMD128-NEXT:    i32.const $push89=, 1
; NO-SIMD128-NEXT:    i32.add $push35=, $pop34, $pop89
; NO-SIMD128-NEXT:    i32.const $push88=, 254
; NO-SIMD128-NEXT:    i32.and $push36=, $pop35, $pop88
; NO-SIMD128-NEXT:    i32.const $push87=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push37=, $pop36, $pop87
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop37
; NO-SIMD128-NEXT:    i32.add $push38=, $7, $23
; NO-SIMD128-NEXT:    i32.const $push86=, 1
; NO-SIMD128-NEXT:    i32.add $push39=, $pop38, $pop86
; NO-SIMD128-NEXT:    i32.const $push85=, 254
; NO-SIMD128-NEXT:    i32.and $push40=, $pop39, $pop85
; NO-SIMD128-NEXT:    i32.const $push84=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push41=, $pop40, $pop84
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop41
; NO-SIMD128-NEXT:    i32.add $push42=, $6, $22
; NO-SIMD128-NEXT:    i32.const $push83=, 1
; NO-SIMD128-NEXT:    i32.add $push43=, $pop42, $pop83
; NO-SIMD128-NEXT:    i32.const $push82=, 254
; NO-SIMD128-NEXT:    i32.and $push44=, $pop43, $pop82
; NO-SIMD128-NEXT:    i32.const $push81=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push45=, $pop44, $pop81
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop45
; NO-SIMD128-NEXT:    i32.add $push46=, $5, $21
; NO-SIMD128-NEXT:    i32.const $push80=, 1
; NO-SIMD128-NEXT:    i32.add $push47=, $pop46, $pop80
; NO-SIMD128-NEXT:    i32.const $push79=, 254
; NO-SIMD128-NEXT:    i32.and $push48=, $pop47, $pop79
; NO-SIMD128-NEXT:    i32.const $push78=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push49=, $pop48, $pop78
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop49
; NO-SIMD128-NEXT:    i32.add $push50=, $4, $20
; NO-SIMD128-NEXT:    i32.const $push77=, 1
; NO-SIMD128-NEXT:    i32.add $push51=, $pop50, $pop77
; NO-SIMD128-NEXT:    i32.const $push76=, 254
; NO-SIMD128-NEXT:    i32.and $push52=, $pop51, $pop76
; NO-SIMD128-NEXT:    i32.const $push75=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push53=, $pop52, $pop75
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop53
; NO-SIMD128-NEXT:    i32.add $push54=, $3, $19
; NO-SIMD128-NEXT:    i32.const $push74=, 1
; NO-SIMD128-NEXT:    i32.add $push55=, $pop54, $pop74
; NO-SIMD128-NEXT:    i32.const $push73=, 254
; NO-SIMD128-NEXT:    i32.and $push56=, $pop55, $pop73
; NO-SIMD128-NEXT:    i32.const $push72=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push57=, $pop56, $pop72
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop57
; NO-SIMD128-NEXT:    i32.add $push58=, $2, $18
; NO-SIMD128-NEXT:    i32.const $push71=, 1
; NO-SIMD128-NEXT:    i32.add $push59=, $pop58, $pop71
; NO-SIMD128-NEXT:    i32.const $push70=, 254
; NO-SIMD128-NEXT:    i32.and $push60=, $pop59, $pop70
; NO-SIMD128-NEXT:    i32.const $push69=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push61=, $pop60, $pop69
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop61
; NO-SIMD128-NEXT:    i32.add $push62=, $1, $17
; NO-SIMD128-NEXT:    i32.const $push68=, 1
; NO-SIMD128-NEXT:    i32.add $push63=, $pop62, $pop68
; NO-SIMD128-NEXT:    i32.const $push67=, 254
; NO-SIMD128-NEXT:    i32.and $push64=, $pop63, $pop67
; NO-SIMD128-NEXT:    i32.const $push66=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push65=, $pop64, $pop66
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop65
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: avgr_u_v16i8:
; NO-SIMD128-FAST:         .functype avgr_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push111=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop111
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.const $push110=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push7=, $pop6, $pop110
; NO-SIMD128-FAST-NEXT:    i32.const $push109=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $pop7, $pop109
; NO-SIMD128-FAST-NEXT:    i32.const $push108=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop108
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.const $push107=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $pop10, $pop107
; NO-SIMD128-FAST-NEXT:    i32.const $push106=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $pop11, $pop106
; NO-SIMD128-FAST-NEXT:    i32.const $push105=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push13=, $pop12, $pop105
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.const $push104=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $pop14, $pop104
; NO-SIMD128-FAST-NEXT:    i32.const $push103=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $pop15, $pop103
; NO-SIMD128-FAST-NEXT:    i32.const $push102=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push17=, $pop16, $pop102
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.const $push101=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $pop18, $pop101
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $pop19, $pop100
; NO-SIMD128-FAST-NEXT:    i32.const $push99=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push21=, $pop20, $pop99
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.const $push98=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push23=, $pop22, $pop98
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $pop23, $pop97
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push25=, $pop24, $pop96
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop25
; NO-SIMD128-FAST-NEXT:    i32.add $push26=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $pop26, $pop95
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop94
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push29=, $pop28, $pop93
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop29
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $pop30, $pop92
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push32=, $pop31, $pop91
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push33=, $pop32, $pop90
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop33
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push35=, $pop34, $pop89
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push36=, $pop35, $pop88
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push37=, $pop36, $pop87
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop37
; NO-SIMD128-FAST-NEXT:    i32.add $push38=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.const $push86=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $pop38, $pop86
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push40=, $pop39, $pop85
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push41=, $pop40, $pop84
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop41
; NO-SIMD128-FAST-NEXT:    i32.add $push42=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.const $push83=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push43=, $pop42, $pop83
; NO-SIMD128-FAST-NEXT:    i32.const $push82=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push44=, $pop43, $pop82
; NO-SIMD128-FAST-NEXT:    i32.const $push81=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push45=, $pop44, $pop81
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop45
; NO-SIMD128-FAST-NEXT:    i32.add $push46=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.const $push80=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push47=, $pop46, $pop80
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push48=, $pop47, $pop79
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push49=, $pop48, $pop78
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop49
; NO-SIMD128-FAST-NEXT:    i32.add $push50=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.const $push77=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push51=, $pop50, $pop77
; NO-SIMD128-FAST-NEXT:    i32.const $push76=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push52=, $pop51, $pop76
; NO-SIMD128-FAST-NEXT:    i32.const $push75=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push53=, $pop52, $pop75
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop53
; NO-SIMD128-FAST-NEXT:    i32.add $push54=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.const $push74=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push55=, $pop54, $pop74
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push56=, $pop55, $pop73
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push57=, $pop56, $pop72
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop57
; NO-SIMD128-FAST-NEXT:    i32.add $push58=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.const $push71=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push59=, $pop58, $pop71
; NO-SIMD128-FAST-NEXT:    i32.const $push70=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push60=, $pop59, $pop70
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push61=, $pop60, $pop69
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop61
; NO-SIMD128-FAST-NEXT:    i32.add $push62=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.const $push68=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push63=, $pop62, $pop68
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push64=, $pop63, $pop67
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push65=, $pop64, $pop66
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop65
; NO-SIMD128-FAST-NEXT:    return
  %a = add nuw <16 x i8> %x, %y
  %b = add nuw <16 x i8> %a, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1,
                              i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %c = udiv <16 x i8> %b, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2,
                           i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  ret <16 x i8> %c
}

define <16 x i8> @avgr_u_v16i8_zext(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: avgr_u_v16i8_zext:
; SIMD128:         .functype avgr_u_v16i8_zext (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.avgr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: avgr_u_v16i8_zext:
; SIMD128-FAST:         .functype avgr_u_v16i8_zext (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.avgr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: avgr_u_v16i8_zext:
; NO-SIMD128:         .functype avgr_u_v16i8_zext (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $16, $pop0
; NO-SIMD128-NEXT:    i32.const $push143=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $32, $pop143
; NO-SIMD128-NEXT:    i32.add $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.const $push4=, 1
; NO-SIMD128-NEXT:    i32.add $push5=, $pop3, $pop4
; NO-SIMD128-NEXT:    i32.const $push142=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push6=, $pop5, $pop142
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push141=, 255
; NO-SIMD128-NEXT:    i32.and $push8=, $15, $pop141
; NO-SIMD128-NEXT:    i32.const $push140=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $31, $pop140
; NO-SIMD128-NEXT:    i32.add $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.const $push139=, 1
; NO-SIMD128-NEXT:    i32.add $push10=, $pop9, $pop139
; NO-SIMD128-NEXT:    i32.const $push138=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push11=, $pop10, $pop138
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop11
; NO-SIMD128-NEXT:    i32.const $push137=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $14, $pop137
; NO-SIMD128-NEXT:    i32.const $push136=, 255
; NO-SIMD128-NEXT:    i32.and $push12=, $30, $pop136
; NO-SIMD128-NEXT:    i32.add $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.const $push135=, 1
; NO-SIMD128-NEXT:    i32.add $push15=, $pop14, $pop135
; NO-SIMD128-NEXT:    i32.const $push134=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push16=, $pop15, $pop134
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop16
; NO-SIMD128-NEXT:    i32.const $push133=, 255
; NO-SIMD128-NEXT:    i32.and $push18=, $13, $pop133
; NO-SIMD128-NEXT:    i32.const $push132=, 255
; NO-SIMD128-NEXT:    i32.and $push17=, $29, $pop132
; NO-SIMD128-NEXT:    i32.add $push19=, $pop18, $pop17
; NO-SIMD128-NEXT:    i32.const $push131=, 1
; NO-SIMD128-NEXT:    i32.add $push20=, $pop19, $pop131
; NO-SIMD128-NEXT:    i32.const $push130=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push21=, $pop20, $pop130
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop21
; NO-SIMD128-NEXT:    i32.const $push129=, 255
; NO-SIMD128-NEXT:    i32.and $push23=, $12, $pop129
; NO-SIMD128-NEXT:    i32.const $push128=, 255
; NO-SIMD128-NEXT:    i32.and $push22=, $28, $pop128
; NO-SIMD128-NEXT:    i32.add $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.const $push127=, 1
; NO-SIMD128-NEXT:    i32.add $push25=, $pop24, $pop127
; NO-SIMD128-NEXT:    i32.const $push126=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push26=, $pop25, $pop126
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop26
; NO-SIMD128-NEXT:    i32.const $push125=, 255
; NO-SIMD128-NEXT:    i32.and $push28=, $11, $pop125
; NO-SIMD128-NEXT:    i32.const $push124=, 255
; NO-SIMD128-NEXT:    i32.and $push27=, $27, $pop124
; NO-SIMD128-NEXT:    i32.add $push29=, $pop28, $pop27
; NO-SIMD128-NEXT:    i32.const $push123=, 1
; NO-SIMD128-NEXT:    i32.add $push30=, $pop29, $pop123
; NO-SIMD128-NEXT:    i32.const $push122=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push31=, $pop30, $pop122
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop31
; NO-SIMD128-NEXT:    i32.const $push121=, 255
; NO-SIMD128-NEXT:    i32.and $push33=, $10, $pop121
; NO-SIMD128-NEXT:    i32.const $push120=, 255
; NO-SIMD128-NEXT:    i32.and $push32=, $26, $pop120
; NO-SIMD128-NEXT:    i32.add $push34=, $pop33, $pop32
; NO-SIMD128-NEXT:    i32.const $push119=, 1
; NO-SIMD128-NEXT:    i32.add $push35=, $pop34, $pop119
; NO-SIMD128-NEXT:    i32.const $push118=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push36=, $pop35, $pop118
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop36
; NO-SIMD128-NEXT:    i32.const $push117=, 255
; NO-SIMD128-NEXT:    i32.and $push38=, $9, $pop117
; NO-SIMD128-NEXT:    i32.const $push116=, 255
; NO-SIMD128-NEXT:    i32.and $push37=, $25, $pop116
; NO-SIMD128-NEXT:    i32.add $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.const $push115=, 1
; NO-SIMD128-NEXT:    i32.add $push40=, $pop39, $pop115
; NO-SIMD128-NEXT:    i32.const $push114=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push41=, $pop40, $pop114
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop41
; NO-SIMD128-NEXT:    i32.const $push113=, 255
; NO-SIMD128-NEXT:    i32.and $push43=, $8, $pop113
; NO-SIMD128-NEXT:    i32.const $push112=, 255
; NO-SIMD128-NEXT:    i32.and $push42=, $24, $pop112
; NO-SIMD128-NEXT:    i32.add $push44=, $pop43, $pop42
; NO-SIMD128-NEXT:    i32.const $push111=, 1
; NO-SIMD128-NEXT:    i32.add $push45=, $pop44, $pop111
; NO-SIMD128-NEXT:    i32.const $push110=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push46=, $pop45, $pop110
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop46
; NO-SIMD128-NEXT:    i32.const $push109=, 255
; NO-SIMD128-NEXT:    i32.and $push48=, $7, $pop109
; NO-SIMD128-NEXT:    i32.const $push108=, 255
; NO-SIMD128-NEXT:    i32.and $push47=, $23, $pop108
; NO-SIMD128-NEXT:    i32.add $push49=, $pop48, $pop47
; NO-SIMD128-NEXT:    i32.const $push107=, 1
; NO-SIMD128-NEXT:    i32.add $push50=, $pop49, $pop107
; NO-SIMD128-NEXT:    i32.const $push106=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push51=, $pop50, $pop106
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop51
; NO-SIMD128-NEXT:    i32.const $push105=, 255
; NO-SIMD128-NEXT:    i32.and $push53=, $6, $pop105
; NO-SIMD128-NEXT:    i32.const $push104=, 255
; NO-SIMD128-NEXT:    i32.and $push52=, $22, $pop104
; NO-SIMD128-NEXT:    i32.add $push54=, $pop53, $pop52
; NO-SIMD128-NEXT:    i32.const $push103=, 1
; NO-SIMD128-NEXT:    i32.add $push55=, $pop54, $pop103
; NO-SIMD128-NEXT:    i32.const $push102=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push56=, $pop55, $pop102
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop56
; NO-SIMD128-NEXT:    i32.const $push101=, 255
; NO-SIMD128-NEXT:    i32.and $push58=, $5, $pop101
; NO-SIMD128-NEXT:    i32.const $push100=, 255
; NO-SIMD128-NEXT:    i32.and $push57=, $21, $pop100
; NO-SIMD128-NEXT:    i32.add $push59=, $pop58, $pop57
; NO-SIMD128-NEXT:    i32.const $push99=, 1
; NO-SIMD128-NEXT:    i32.add $push60=, $pop59, $pop99
; NO-SIMD128-NEXT:    i32.const $push98=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push61=, $pop60, $pop98
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop61
; NO-SIMD128-NEXT:    i32.const $push97=, 255
; NO-SIMD128-NEXT:    i32.and $push63=, $4, $pop97
; NO-SIMD128-NEXT:    i32.const $push96=, 255
; NO-SIMD128-NEXT:    i32.and $push62=, $20, $pop96
; NO-SIMD128-NEXT:    i32.add $push64=, $pop63, $pop62
; NO-SIMD128-NEXT:    i32.const $push95=, 1
; NO-SIMD128-NEXT:    i32.add $push65=, $pop64, $pop95
; NO-SIMD128-NEXT:    i32.const $push94=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push66=, $pop65, $pop94
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop66
; NO-SIMD128-NEXT:    i32.const $push93=, 255
; NO-SIMD128-NEXT:    i32.and $push68=, $3, $pop93
; NO-SIMD128-NEXT:    i32.const $push92=, 255
; NO-SIMD128-NEXT:    i32.and $push67=, $19, $pop92
; NO-SIMD128-NEXT:    i32.add $push69=, $pop68, $pop67
; NO-SIMD128-NEXT:    i32.const $push91=, 1
; NO-SIMD128-NEXT:    i32.add $push70=, $pop69, $pop91
; NO-SIMD128-NEXT:    i32.const $push90=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push71=, $pop70, $pop90
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop71
; NO-SIMD128-NEXT:    i32.const $push89=, 255
; NO-SIMD128-NEXT:    i32.and $push73=, $2, $pop89
; NO-SIMD128-NEXT:    i32.const $push88=, 255
; NO-SIMD128-NEXT:    i32.and $push72=, $18, $pop88
; NO-SIMD128-NEXT:    i32.add $push74=, $pop73, $pop72
; NO-SIMD128-NEXT:    i32.const $push87=, 1
; NO-SIMD128-NEXT:    i32.add $push75=, $pop74, $pop87
; NO-SIMD128-NEXT:    i32.const $push86=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push76=, $pop75, $pop86
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop76
; NO-SIMD128-NEXT:    i32.const $push85=, 255
; NO-SIMD128-NEXT:    i32.and $push78=, $1, $pop85
; NO-SIMD128-NEXT:    i32.const $push84=, 255
; NO-SIMD128-NEXT:    i32.and $push77=, $17, $pop84
; NO-SIMD128-NEXT:    i32.add $push79=, $pop78, $pop77
; NO-SIMD128-NEXT:    i32.const $push83=, 1
; NO-SIMD128-NEXT:    i32.add $push80=, $pop79, $pop83
; NO-SIMD128-NEXT:    i32.const $push82=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push81=, $pop80, $pop82
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop81
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: avgr_u_v16i8_zext:
; NO-SIMD128-FAST:         .functype avgr_u_v16i8_zext (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push143=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop143
; NO-SIMD128-FAST-NEXT:    i32.add $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $pop3, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push142=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $pop142
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push141=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $2, $pop141
; NO-SIMD128-FAST-NEXT:    i32.const $push140=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $18, $pop140
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push139=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $pop9, $pop139
; NO-SIMD128-FAST-NEXT:    i32.const $push138=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push11=, $pop10, $pop138
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push137=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $3, $pop137
; NO-SIMD128-FAST-NEXT:    i32.const $push136=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $19, $pop136
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push135=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $pop14, $pop135
; NO-SIMD128-FAST-NEXT:    i32.const $push134=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push16=, $pop15, $pop134
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push133=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $4, $pop133
; NO-SIMD128-FAST-NEXT:    i32.const $push132=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $20, $pop132
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $pop18, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push131=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push20=, $pop19, $pop131
; NO-SIMD128-FAST-NEXT:    i32.const $push130=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push21=, $pop20, $pop130
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push129=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $5, $pop129
; NO-SIMD128-FAST-NEXT:    i32.const $push128=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $21, $pop128
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push127=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push25=, $pop24, $pop127
; NO-SIMD128-FAST-NEXT:    i32.const $push126=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push26=, $pop25, $pop126
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push125=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $6, $pop125
; NO-SIMD128-FAST-NEXT:    i32.const $push124=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push27=, $22, $pop124
; NO-SIMD128-FAST-NEXT:    i32.add $push29=, $pop28, $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push123=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $pop29, $pop123
; NO-SIMD128-FAST-NEXT:    i32.const $push122=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push31=, $pop30, $pop122
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push121=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push33=, $7, $pop121
; NO-SIMD128-FAST-NEXT:    i32.const $push120=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push32=, $23, $pop120
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $pop33, $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push119=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push35=, $pop34, $pop119
; NO-SIMD128-FAST-NEXT:    i32.const $push118=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push36=, $pop35, $pop118
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push117=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push38=, $8, $pop117
; NO-SIMD128-FAST-NEXT:    i32.const $push116=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $24, $pop116
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $pop38, $pop37
; NO-SIMD128-FAST-NEXT:    i32.const $push115=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $pop39, $pop115
; NO-SIMD128-FAST-NEXT:    i32.const $push114=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push41=, $pop40, $pop114
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop41
; NO-SIMD128-FAST-NEXT:    i32.const $push113=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $9, $pop113
; NO-SIMD128-FAST-NEXT:    i32.const $push112=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push42=, $25, $pop112
; NO-SIMD128-FAST-NEXT:    i32.add $push44=, $pop43, $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push111=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push45=, $pop44, $pop111
; NO-SIMD128-FAST-NEXT:    i32.const $push110=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push46=, $pop45, $pop110
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push109=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push48=, $10, $pop109
; NO-SIMD128-FAST-NEXT:    i32.const $push108=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push47=, $26, $pop108
; NO-SIMD128-FAST-NEXT:    i32.add $push49=, $pop48, $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push107=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push50=, $pop49, $pop107
; NO-SIMD128-FAST-NEXT:    i32.const $push106=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push51=, $pop50, $pop106
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop51
; NO-SIMD128-FAST-NEXT:    i32.const $push105=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push53=, $11, $pop105
; NO-SIMD128-FAST-NEXT:    i32.const $push104=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push52=, $27, $pop104
; NO-SIMD128-FAST-NEXT:    i32.add $push54=, $pop53, $pop52
; NO-SIMD128-FAST-NEXT:    i32.const $push103=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push55=, $pop54, $pop103
; NO-SIMD128-FAST-NEXT:    i32.const $push102=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push56=, $pop55, $pop102
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop56
; NO-SIMD128-FAST-NEXT:    i32.const $push101=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push58=, $12, $pop101
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push57=, $28, $pop100
; NO-SIMD128-FAST-NEXT:    i32.add $push59=, $pop58, $pop57
; NO-SIMD128-FAST-NEXT:    i32.const $push99=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push60=, $pop59, $pop99
; NO-SIMD128-FAST-NEXT:    i32.const $push98=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push61=, $pop60, $pop98
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop61
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push63=, $13, $pop97
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push62=, $29, $pop96
; NO-SIMD128-FAST-NEXT:    i32.add $push64=, $pop63, $pop62
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push65=, $pop64, $pop95
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push66=, $pop65, $pop94
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop66
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push68=, $14, $pop93
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push67=, $30, $pop92
; NO-SIMD128-FAST-NEXT:    i32.add $push69=, $pop68, $pop67
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push70=, $pop69, $pop91
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push71=, $pop70, $pop90
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop71
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push73=, $15, $pop89
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push72=, $31, $pop88
; NO-SIMD128-FAST-NEXT:    i32.add $push74=, $pop73, $pop72
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push75=, $pop74, $pop87
; NO-SIMD128-FAST-NEXT:    i32.const $push86=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push76=, $pop75, $pop86
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop76
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push78=, $16, $pop85
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push77=, $32, $pop84
; NO-SIMD128-FAST-NEXT:    i32.add $push79=, $pop78, $pop77
; NO-SIMD128-FAST-NEXT:    i32.const $push83=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push80=, $pop79, $pop83
; NO-SIMD128-FAST-NEXT:    i32.const $push82=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push81=, $pop80, $pop82
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop81
; NO-SIMD128-FAST-NEXT:    return
  %x.zext = zext <16 x i8> %x to <16 x i16>
  %y.zext = zext <16 x i8> %y to <16 x i16>
  %a = add <16 x i16> %x.zext, %y.zext
  %b = add <16 x i16> %a, splat (i16 1)
  %c = lshr <16 x i16> %b, splat (i16 1)
  %c.trunc = trunc <16 x i16> %c to <16 x i8>
  ret <16 x i8> %c.trunc
}

define <8 x i16> @avgr_u_v8i16_zext(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: avgr_u_v8i16_zext:
; SIMD128:         .functype avgr_u_v8i16_zext (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.avgr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: avgr_u_v8i16_zext:
; SIMD128-FAST:         .functype avgr_u_v8i16_zext (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.avgr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: avgr_u_v8i16_zext:
; NO-SIMD128:         .functype avgr_u_v8i16_zext (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push2=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push71=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop71
; NO-SIMD128-NEXT:    i32.add $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.const $push4=, 1
; NO-SIMD128-NEXT:    i32.add $push5=, $pop3, $pop4
; NO-SIMD128-NEXT:    i32.const $push70=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push6=, $pop5, $pop70
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push69=, 65535
; NO-SIMD128-NEXT:    i32.and $push8=, $7, $pop69
; NO-SIMD128-NEXT:    i32.const $push68=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $15, $pop68
; NO-SIMD128-NEXT:    i32.add $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.const $push67=, 1
; NO-SIMD128-NEXT:    i32.add $push10=, $pop9, $pop67
; NO-SIMD128-NEXT:    i32.const $push66=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push11=, $pop10, $pop66
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop11
; NO-SIMD128-NEXT:    i32.const $push65=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $6, $pop65
; NO-SIMD128-NEXT:    i32.const $push64=, 65535
; NO-SIMD128-NEXT:    i32.and $push12=, $14, $pop64
; NO-SIMD128-NEXT:    i32.add $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.const $push63=, 1
; NO-SIMD128-NEXT:    i32.add $push15=, $pop14, $pop63
; NO-SIMD128-NEXT:    i32.const $push62=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push16=, $pop15, $pop62
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop16
; NO-SIMD128-NEXT:    i32.const $push61=, 65535
; NO-SIMD128-NEXT:    i32.and $push18=, $5, $pop61
; NO-SIMD128-NEXT:    i32.const $push60=, 65535
; NO-SIMD128-NEXT:    i32.and $push17=, $13, $pop60
; NO-SIMD128-NEXT:    i32.add $push19=, $pop18, $pop17
; NO-SIMD128-NEXT:    i32.const $push59=, 1
; NO-SIMD128-NEXT:    i32.add $push20=, $pop19, $pop59
; NO-SIMD128-NEXT:    i32.const $push58=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push21=, $pop20, $pop58
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop21
; NO-SIMD128-NEXT:    i32.const $push57=, 65535
; NO-SIMD128-NEXT:    i32.and $push23=, $4, $pop57
; NO-SIMD128-NEXT:    i32.const $push56=, 65535
; NO-SIMD128-NEXT:    i32.and $push22=, $12, $pop56
; NO-SIMD128-NEXT:    i32.add $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.const $push55=, 1
; NO-SIMD128-NEXT:    i32.add $push25=, $pop24, $pop55
; NO-SIMD128-NEXT:    i32.const $push54=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push26=, $pop25, $pop54
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop26
; NO-SIMD128-NEXT:    i32.const $push53=, 65535
; NO-SIMD128-NEXT:    i32.and $push28=, $3, $pop53
; NO-SIMD128-NEXT:    i32.const $push52=, 65535
; NO-SIMD128-NEXT:    i32.and $push27=, $11, $pop52
; NO-SIMD128-NEXT:    i32.add $push29=, $pop28, $pop27
; NO-SIMD128-NEXT:    i32.const $push51=, 1
; NO-SIMD128-NEXT:    i32.add $push30=, $pop29, $pop51
; NO-SIMD128-NEXT:    i32.const $push50=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push31=, $pop30, $pop50
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop31
; NO-SIMD128-NEXT:    i32.const $push49=, 65535
; NO-SIMD128-NEXT:    i32.and $push33=, $2, $pop49
; NO-SIMD128-NEXT:    i32.const $push48=, 65535
; NO-SIMD128-NEXT:    i32.and $push32=, $10, $pop48
; NO-SIMD128-NEXT:    i32.add $push34=, $pop33, $pop32
; NO-SIMD128-NEXT:    i32.const $push47=, 1
; NO-SIMD128-NEXT:    i32.add $push35=, $pop34, $pop47
; NO-SIMD128-NEXT:    i32.const $push46=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push36=, $pop35, $pop46
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop36
; NO-SIMD128-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-NEXT:    i32.and $push38=, $1, $pop45
; NO-SIMD128-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-NEXT:    i32.and $push37=, $9, $pop44
; NO-SIMD128-NEXT:    i32.add $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.const $push43=, 1
; NO-SIMD128-NEXT:    i32.add $push40=, $pop39, $pop43
; NO-SIMD128-NEXT:    i32.const $push42=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push41=, $pop40, $pop42
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop41
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: avgr_u_v8i16_zext:
; NO-SIMD128-FAST:         .functype avgr_u_v8i16_zext (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push71=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop71
; NO-SIMD128-FAST-NEXT:    i32.add $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $pop3, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push70=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $pop70
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $2, $pop69
; NO-SIMD128-FAST-NEXT:    i32.const $push68=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $10, $pop68
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $pop9, $pop67
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push11=, $pop10, $pop66
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push65=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $3, $pop65
; NO-SIMD128-FAST-NEXT:    i32.const $push64=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $11, $pop64
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push63=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $pop14, $pop63
; NO-SIMD128-FAST-NEXT:    i32.const $push62=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push16=, $pop15, $pop62
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $4, $pop61
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $12, $pop60
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $pop18, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push59=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push20=, $pop19, $pop59
; NO-SIMD128-FAST-NEXT:    i32.const $push58=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push21=, $pop20, $pop58
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push57=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $5, $pop57
; NO-SIMD128-FAST-NEXT:    i32.const $push56=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $13, $pop56
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push25=, $pop24, $pop55
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push26=, $pop25, $pop54
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $6, $pop53
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push27=, $14, $pop52
; NO-SIMD128-FAST-NEXT:    i32.add $push29=, $pop28, $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $pop29, $pop51
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push31=, $pop30, $pop50
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push33=, $7, $pop49
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push32=, $15, $pop48
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $pop33, $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push35=, $pop34, $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push36=, $pop35, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push38=, $8, $pop45
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $16, $pop44
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $pop38, $pop37
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $pop39, $pop43
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push41=, $pop40, $pop42
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop41
; NO-SIMD128-FAST-NEXT:    return
  %x.zext = zext <8 x i16> %x to <8 x i32>
  %y.zext = zext <8 x i16> %y to <8 x i32>
  %a = add <8 x i32> %x.zext, %y.zext
  %b = add <8 x i32> %a, splat (i32 1)
  %c = lshr <8 x i32> %b, splat (i32 1)
  %c.trunc = trunc <8 x i32> %c to <8 x i16>
  ret <8 x i16> %c.trunc
}
define void @avgr_undef_shuffle_lanes(ptr %res, <8 x i8> %a, <8 x i8> %b, <8 x i8> %c, <8 x i8> %d) {
; SIMD128-LABEL: avgr_undef_shuffle_lanes:
; SIMD128:         .functype avgr_undef_shuffle_lanes (i32, v128, v128, v128, v128) -> ()
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.avgr_u $push1=, $1, $2
; SIMD128-NEXT:    i16x8.extend_low_i8x16_u $push8=, $pop1
; SIMD128-NEXT:    local.tee $push7=, $2=, $pop8
; SIMD128-NEXT:    i8x16.avgr_u $push0=, $3, $4
; SIMD128-NEXT:    i16x8.extend_low_i8x16_u $push6=, $pop0
; SIMD128-NEXT:    local.tee $push5=, $4=, $pop6
; SIMD128-NEXT:    i8x16.shuffle $push3=, $pop7, $pop5, 0, 1, 16, 17, 2, 3, 18, 19, 4, 5, 20, 21, 6, 7, 22, 23
; SIMD128-NEXT:    i8x16.shuffle $push2=, $2, $4, 8, 9, 24, 25, 10, 11, 26, 27, 12, 13, 28, 29, 14, 15, 30, 31
; SIMD128-NEXT:    i8x16.narrow_i16x8_u $push4=, $pop3, $pop2
; SIMD128-NEXT:    v128.store 0($0):p2align=0, $pop4
; SIMD128-NEXT:    return
;
; SIMD128-FAST-LABEL: avgr_undef_shuffle_lanes:
; SIMD128-FAST:         .functype avgr_undef_shuffle_lanes (i32, v128, v128, v128, v128) -> ()
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.avgr_u $push1=, $1, $2
; SIMD128-FAST-NEXT:    i16x8.extend_low_i8x16_u $push8=, $pop1
; SIMD128-FAST-NEXT:    local.tee $push7=, $2=, $pop8
; SIMD128-FAST-NEXT:    i8x16.avgr_u $push0=, $3, $4
; SIMD128-FAST-NEXT:    i16x8.extend_low_i8x16_u $push6=, $pop0
; SIMD128-FAST-NEXT:    local.tee $push5=, $4=, $pop6
; SIMD128-FAST-NEXT:    i8x16.shuffle $push3=, $pop7, $pop5, 0, 1, 16, 17, 2, 3, 18, 19, 4, 5, 20, 21, 6, 7, 22, 23
; SIMD128-FAST-NEXT:    i8x16.shuffle $push2=, $2, $4, 8, 9, 24, 25, 10, 11, 26, 27, 12, 13, 28, 29, 14, 15, 30, 31
; SIMD128-FAST-NEXT:    i8x16.narrow_i16x8_u $push4=, $pop3, $pop2
; SIMD128-FAST-NEXT:    v128.store 0($0):p2align=0, $pop4
; SIMD128-FAST-NEXT:    return
;
; NO-SIMD128-LABEL: avgr_undef_shuffle_lanes:
; NO-SIMD128:         .functype avgr_undef_shuffle_lanes (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $24, $pop0
; NO-SIMD128-NEXT:    i32.const $push143=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $32, $pop143
; NO-SIMD128-NEXT:    i32.add $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.const $push4=, 1
; NO-SIMD128-NEXT:    i32.add $push5=, $pop3, $pop4
; NO-SIMD128-NEXT:    i32.const $push142=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push6=, $pop5, $pop142
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push141=, 255
; NO-SIMD128-NEXT:    i32.and $push8=, $8, $pop141
; NO-SIMD128-NEXT:    i32.const $push140=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $16, $pop140
; NO-SIMD128-NEXT:    i32.add $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.const $push139=, 1
; NO-SIMD128-NEXT:    i32.add $push10=, $pop9, $pop139
; NO-SIMD128-NEXT:    i32.const $push138=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push11=, $pop10, $pop138
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop11
; NO-SIMD128-NEXT:    i32.const $push137=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $23, $pop137
; NO-SIMD128-NEXT:    i32.const $push136=, 255
; NO-SIMD128-NEXT:    i32.and $push12=, $31, $pop136
; NO-SIMD128-NEXT:    i32.add $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.const $push135=, 1
; NO-SIMD128-NEXT:    i32.add $push15=, $pop14, $pop135
; NO-SIMD128-NEXT:    i32.const $push134=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push16=, $pop15, $pop134
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop16
; NO-SIMD128-NEXT:    i32.const $push133=, 255
; NO-SIMD128-NEXT:    i32.and $push18=, $7, $pop133
; NO-SIMD128-NEXT:    i32.const $push132=, 255
; NO-SIMD128-NEXT:    i32.and $push17=, $15, $pop132
; NO-SIMD128-NEXT:    i32.add $push19=, $pop18, $pop17
; NO-SIMD128-NEXT:    i32.const $push131=, 1
; NO-SIMD128-NEXT:    i32.add $push20=, $pop19, $pop131
; NO-SIMD128-NEXT:    i32.const $push130=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push21=, $pop20, $pop130
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop21
; NO-SIMD128-NEXT:    i32.const $push129=, 255
; NO-SIMD128-NEXT:    i32.and $push23=, $22, $pop129
; NO-SIMD128-NEXT:    i32.const $push128=, 255
; NO-SIMD128-NEXT:    i32.and $push22=, $30, $pop128
; NO-SIMD128-NEXT:    i32.add $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.const $push127=, 1
; NO-SIMD128-NEXT:    i32.add $push25=, $pop24, $pop127
; NO-SIMD128-NEXT:    i32.const $push126=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push26=, $pop25, $pop126
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop26
; NO-SIMD128-NEXT:    i32.const $push125=, 255
; NO-SIMD128-NEXT:    i32.and $push28=, $6, $pop125
; NO-SIMD128-NEXT:    i32.const $push124=, 255
; NO-SIMD128-NEXT:    i32.and $push27=, $14, $pop124
; NO-SIMD128-NEXT:    i32.add $push29=, $pop28, $pop27
; NO-SIMD128-NEXT:    i32.const $push123=, 1
; NO-SIMD128-NEXT:    i32.add $push30=, $pop29, $pop123
; NO-SIMD128-NEXT:    i32.const $push122=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push31=, $pop30, $pop122
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop31
; NO-SIMD128-NEXT:    i32.const $push121=, 255
; NO-SIMD128-NEXT:    i32.and $push33=, $21, $pop121
; NO-SIMD128-NEXT:    i32.const $push120=, 255
; NO-SIMD128-NEXT:    i32.and $push32=, $29, $pop120
; NO-SIMD128-NEXT:    i32.add $push34=, $pop33, $pop32
; NO-SIMD128-NEXT:    i32.const $push119=, 1
; NO-SIMD128-NEXT:    i32.add $push35=, $pop34, $pop119
; NO-SIMD128-NEXT:    i32.const $push118=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push36=, $pop35, $pop118
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop36
; NO-SIMD128-NEXT:    i32.const $push117=, 255
; NO-SIMD128-NEXT:    i32.and $push38=, $5, $pop117
; NO-SIMD128-NEXT:    i32.const $push116=, 255
; NO-SIMD128-NEXT:    i32.and $push37=, $13, $pop116
; NO-SIMD128-NEXT:    i32.add $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.const $push115=, 1
; NO-SIMD128-NEXT:    i32.add $push40=, $pop39, $pop115
; NO-SIMD128-NEXT:    i32.const $push114=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push41=, $pop40, $pop114
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop41
; NO-SIMD128-NEXT:    i32.const $push113=, 255
; NO-SIMD128-NEXT:    i32.and $push43=, $20, $pop113
; NO-SIMD128-NEXT:    i32.const $push112=, 255
; NO-SIMD128-NEXT:    i32.and $push42=, $28, $pop112
; NO-SIMD128-NEXT:    i32.add $push44=, $pop43, $pop42
; NO-SIMD128-NEXT:    i32.const $push111=, 1
; NO-SIMD128-NEXT:    i32.add $push45=, $pop44, $pop111
; NO-SIMD128-NEXT:    i32.const $push110=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push46=, $pop45, $pop110
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop46
; NO-SIMD128-NEXT:    i32.const $push109=, 255
; NO-SIMD128-NEXT:    i32.and $push48=, $4, $pop109
; NO-SIMD128-NEXT:    i32.const $push108=, 255
; NO-SIMD128-NEXT:    i32.and $push47=, $12, $pop108
; NO-SIMD128-NEXT:    i32.add $push49=, $pop48, $pop47
; NO-SIMD128-NEXT:    i32.const $push107=, 1
; NO-SIMD128-NEXT:    i32.add $push50=, $pop49, $pop107
; NO-SIMD128-NEXT:    i32.const $push106=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push51=, $pop50, $pop106
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop51
; NO-SIMD128-NEXT:    i32.const $push105=, 255
; NO-SIMD128-NEXT:    i32.and $push53=, $19, $pop105
; NO-SIMD128-NEXT:    i32.const $push104=, 255
; NO-SIMD128-NEXT:    i32.and $push52=, $27, $pop104
; NO-SIMD128-NEXT:    i32.add $push54=, $pop53, $pop52
; NO-SIMD128-NEXT:    i32.const $push103=, 1
; NO-SIMD128-NEXT:    i32.add $push55=, $pop54, $pop103
; NO-SIMD128-NEXT:    i32.const $push102=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push56=, $pop55, $pop102
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop56
; NO-SIMD128-NEXT:    i32.const $push101=, 255
; NO-SIMD128-NEXT:    i32.and $push58=, $3, $pop101
; NO-SIMD128-NEXT:    i32.const $push100=, 255
; NO-SIMD128-NEXT:    i32.and $push57=, $11, $pop100
; NO-SIMD128-NEXT:    i32.add $push59=, $pop58, $pop57
; NO-SIMD128-NEXT:    i32.const $push99=, 1
; NO-SIMD128-NEXT:    i32.add $push60=, $pop59, $pop99
; NO-SIMD128-NEXT:    i32.const $push98=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push61=, $pop60, $pop98
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop61
; NO-SIMD128-NEXT:    i32.const $push97=, 255
; NO-SIMD128-NEXT:    i32.and $push63=, $18, $pop97
; NO-SIMD128-NEXT:    i32.const $push96=, 255
; NO-SIMD128-NEXT:    i32.and $push62=, $26, $pop96
; NO-SIMD128-NEXT:    i32.add $push64=, $pop63, $pop62
; NO-SIMD128-NEXT:    i32.const $push95=, 1
; NO-SIMD128-NEXT:    i32.add $push65=, $pop64, $pop95
; NO-SIMD128-NEXT:    i32.const $push94=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push66=, $pop65, $pop94
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop66
; NO-SIMD128-NEXT:    i32.const $push93=, 255
; NO-SIMD128-NEXT:    i32.and $push68=, $2, $pop93
; NO-SIMD128-NEXT:    i32.const $push92=, 255
; NO-SIMD128-NEXT:    i32.and $push67=, $10, $pop92
; NO-SIMD128-NEXT:    i32.add $push69=, $pop68, $pop67
; NO-SIMD128-NEXT:    i32.const $push91=, 1
; NO-SIMD128-NEXT:    i32.add $push70=, $pop69, $pop91
; NO-SIMD128-NEXT:    i32.const $push90=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push71=, $pop70, $pop90
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop71
; NO-SIMD128-NEXT:    i32.const $push89=, 255
; NO-SIMD128-NEXT:    i32.and $push73=, $17, $pop89
; NO-SIMD128-NEXT:    i32.const $push88=, 255
; NO-SIMD128-NEXT:    i32.and $push72=, $25, $pop88
; NO-SIMD128-NEXT:    i32.add $push74=, $pop73, $pop72
; NO-SIMD128-NEXT:    i32.const $push87=, 1
; NO-SIMD128-NEXT:    i32.add $push75=, $pop74, $pop87
; NO-SIMD128-NEXT:    i32.const $push86=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push76=, $pop75, $pop86
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop76
; NO-SIMD128-NEXT:    i32.const $push85=, 255
; NO-SIMD128-NEXT:    i32.and $push78=, $1, $pop85
; NO-SIMD128-NEXT:    i32.const $push84=, 255
; NO-SIMD128-NEXT:    i32.and $push77=, $9, $pop84
; NO-SIMD128-NEXT:    i32.add $push79=, $pop78, $pop77
; NO-SIMD128-NEXT:    i32.const $push83=, 1
; NO-SIMD128-NEXT:    i32.add $push80=, $pop79, $pop83
; NO-SIMD128-NEXT:    i32.const $push82=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push81=, $pop80, $pop82
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop81
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: avgr_undef_shuffle_lanes:
; NO-SIMD128-FAST:         .functype avgr_undef_shuffle_lanes (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $17, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push143=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $25, $pop143
; NO-SIMD128-FAST-NEXT:    i32.add $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $pop3, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push142=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $pop142
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push141=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $1, $pop141
; NO-SIMD128-FAST-NEXT:    i32.const $push140=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $9, $pop140
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push139=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $pop9, $pop139
; NO-SIMD128-FAST-NEXT:    i32.const $push138=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push11=, $pop10, $pop138
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push137=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $18, $pop137
; NO-SIMD128-FAST-NEXT:    i32.const $push136=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $26, $pop136
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push135=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $pop14, $pop135
; NO-SIMD128-FAST-NEXT:    i32.const $push134=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push16=, $pop15, $pop134
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push133=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $2, $pop133
; NO-SIMD128-FAST-NEXT:    i32.const $push132=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $10, $pop132
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $pop18, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push131=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push20=, $pop19, $pop131
; NO-SIMD128-FAST-NEXT:    i32.const $push130=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push21=, $pop20, $pop130
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push129=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $19, $pop129
; NO-SIMD128-FAST-NEXT:    i32.const $push128=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $27, $pop128
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push127=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push25=, $pop24, $pop127
; NO-SIMD128-FAST-NEXT:    i32.const $push126=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push26=, $pop25, $pop126
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push125=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $3, $pop125
; NO-SIMD128-FAST-NEXT:    i32.const $push124=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push27=, $11, $pop124
; NO-SIMD128-FAST-NEXT:    i32.add $push29=, $pop28, $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push123=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $pop29, $pop123
; NO-SIMD128-FAST-NEXT:    i32.const $push122=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push31=, $pop30, $pop122
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push121=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push33=, $20, $pop121
; NO-SIMD128-FAST-NEXT:    i32.const $push120=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push32=, $28, $pop120
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $pop33, $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push119=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push35=, $pop34, $pop119
; NO-SIMD128-FAST-NEXT:    i32.const $push118=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push36=, $pop35, $pop118
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push117=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push38=, $4, $pop117
; NO-SIMD128-FAST-NEXT:    i32.const $push116=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $12, $pop116
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $pop38, $pop37
; NO-SIMD128-FAST-NEXT:    i32.const $push115=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $pop39, $pop115
; NO-SIMD128-FAST-NEXT:    i32.const $push114=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push41=, $pop40, $pop114
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop41
; NO-SIMD128-FAST-NEXT:    i32.const $push113=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $21, $pop113
; NO-SIMD128-FAST-NEXT:    i32.const $push112=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push42=, $29, $pop112
; NO-SIMD128-FAST-NEXT:    i32.add $push44=, $pop43, $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push111=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push45=, $pop44, $pop111
; NO-SIMD128-FAST-NEXT:    i32.const $push110=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push46=, $pop45, $pop110
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push109=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push48=, $5, $pop109
; NO-SIMD128-FAST-NEXT:    i32.const $push108=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push47=, $13, $pop108
; NO-SIMD128-FAST-NEXT:    i32.add $push49=, $pop48, $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push107=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push50=, $pop49, $pop107
; NO-SIMD128-FAST-NEXT:    i32.const $push106=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push51=, $pop50, $pop106
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop51
; NO-SIMD128-FAST-NEXT:    i32.const $push105=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push53=, $22, $pop105
; NO-SIMD128-FAST-NEXT:    i32.const $push104=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push52=, $30, $pop104
; NO-SIMD128-FAST-NEXT:    i32.add $push54=, $pop53, $pop52
; NO-SIMD128-FAST-NEXT:    i32.const $push103=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push55=, $pop54, $pop103
; NO-SIMD128-FAST-NEXT:    i32.const $push102=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push56=, $pop55, $pop102
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop56
; NO-SIMD128-FAST-NEXT:    i32.const $push101=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push58=, $6, $pop101
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push57=, $14, $pop100
; NO-SIMD128-FAST-NEXT:    i32.add $push59=, $pop58, $pop57
; NO-SIMD128-FAST-NEXT:    i32.const $push99=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push60=, $pop59, $pop99
; NO-SIMD128-FAST-NEXT:    i32.const $push98=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push61=, $pop60, $pop98
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop61
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push63=, $23, $pop97
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push62=, $31, $pop96
; NO-SIMD128-FAST-NEXT:    i32.add $push64=, $pop63, $pop62
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push65=, $pop64, $pop95
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push66=, $pop65, $pop94
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop66
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push68=, $7, $pop93
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push67=, $15, $pop92
; NO-SIMD128-FAST-NEXT:    i32.add $push69=, $pop68, $pop67
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push70=, $pop69, $pop91
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push71=, $pop70, $pop90
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop71
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push73=, $24, $pop89
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push72=, $32, $pop88
; NO-SIMD128-FAST-NEXT:    i32.add $push74=, $pop73, $pop72
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push75=, $pop74, $pop87
; NO-SIMD128-FAST-NEXT:    i32.const $push86=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push76=, $pop75, $pop86
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop76
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push78=, $8, $pop85
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push77=, $16, $pop84
; NO-SIMD128-FAST-NEXT:    i32.add $push79=, $pop78, $pop77
; NO-SIMD128-FAST-NEXT:    i32.const $push83=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push80=, $pop79, $pop83
; NO-SIMD128-FAST-NEXT:    i32.const $push82=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push81=, $pop80, $pop82
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop81
; NO-SIMD128-FAST-NEXT:    return
  %zext.0 = zext <8 x i8> %a to <8 x i16>
  %zext.1 = zext <8 x i8> %b to <8 x i16>
  %add.0 = add nuw nsw <8 x i16> %zext.0, splat (i16 1)
  %add.1 = add nuw nsw <8 x i16> %add.0, %zext.1
  %shift.0 = lshr <8 x i16> %add.1, splat (i16 1)
  %zext.2 = zext <8 x i8> %c to <8 x i16>
  %zext.3 = zext <8 x i8> %d to <8 x i16>
  %add.2 = add nuw nsw <8 x i16> %zext.2, splat (i16 1)
  %add.3 = add nuw nsw <8 x i16> %add.2, %zext.3
  %shift.1 = lshr <8 x i16> %add.3, splat (i16 1)
  %shuffle = shufflevector <8 x i16> %shift.0, <8 x i16> %shift.1, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  %trunc = trunc nuw <16 x i16> %shuffle to <16 x i8>
  store <16 x i8> %trunc, ptr %res, align 1
  ret void
}
define <16 x i8> @avgr_u_v16i8_wrap(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: avgr_u_v16i8_wrap:
; SIMD128:         .functype avgr_u_v16i8_wrap (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.add $push0=, $0, $1
; SIMD128-NEXT:    v128.const $push1=, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
; SIMD128-NEXT:    i8x16.add $push2=, $pop0, $pop1
; SIMD128-NEXT:    i32.const $push3=, 1
; SIMD128-NEXT:    i8x16.shr_u $push4=, $pop2, $pop3
; SIMD128-NEXT:    return $pop4
;
; SIMD128-FAST-LABEL: avgr_u_v16i8_wrap:
; SIMD128-FAST:         .functype avgr_u_v16i8_wrap (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.add $push2=, $0, $1
; SIMD128-FAST-NEXT:    v128.const $push3=, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
; SIMD128-FAST-NEXT:    i8x16.add $push1=, $pop2, $pop3
; SIMD128-FAST-NEXT:    i32.const $push4=, 1
; SIMD128-FAST-NEXT:    i8x16.shr_u $push0=, $pop1, $pop4
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: avgr_u_v16i8_wrap:
; NO-SIMD128:         .functype avgr_u_v16i8_wrap (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.add $push0=, $16, $32
; NO-SIMD128-NEXT:    i32.const $push1=, 1
; NO-SIMD128-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-NEXT:    i32.const $push3=, 254
; NO-SIMD128-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-NEXT:    i32.const $push111=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push5=, $pop4, $pop111
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop5
; NO-SIMD128-NEXT:    i32.add $push6=, $15, $31
; NO-SIMD128-NEXT:    i32.const $push110=, 1
; NO-SIMD128-NEXT:    i32.add $push7=, $pop6, $pop110
; NO-SIMD128-NEXT:    i32.const $push109=, 254
; NO-SIMD128-NEXT:    i32.and $push8=, $pop7, $pop109
; NO-SIMD128-NEXT:    i32.const $push108=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push9=, $pop8, $pop108
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop9
; NO-SIMD128-NEXT:    i32.add $push10=, $14, $30
; NO-SIMD128-NEXT:    i32.const $push107=, 1
; NO-SIMD128-NEXT:    i32.add $push11=, $pop10, $pop107
; NO-SIMD128-NEXT:    i32.const $push106=, 254
; NO-SIMD128-NEXT:    i32.and $push12=, $pop11, $pop106
; NO-SIMD128-NEXT:    i32.const $push105=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push13=, $pop12, $pop105
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop13
; NO-SIMD128-NEXT:    i32.add $push14=, $13, $29
; NO-SIMD128-NEXT:    i32.const $push104=, 1
; NO-SIMD128-NEXT:    i32.add $push15=, $pop14, $pop104
; NO-SIMD128-NEXT:    i32.const $push103=, 254
; NO-SIMD128-NEXT:    i32.and $push16=, $pop15, $pop103
; NO-SIMD128-NEXT:    i32.const $push102=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push17=, $pop16, $pop102
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop17
; NO-SIMD128-NEXT:    i32.add $push18=, $12, $28
; NO-SIMD128-NEXT:    i32.const $push101=, 1
; NO-SIMD128-NEXT:    i32.add $push19=, $pop18, $pop101
; NO-SIMD128-NEXT:    i32.const $push100=, 254
; NO-SIMD128-NEXT:    i32.and $push20=, $pop19, $pop100
; NO-SIMD128-NEXT:    i32.const $push99=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push21=, $pop20, $pop99
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop21
; NO-SIMD128-NEXT:    i32.add $push22=, $11, $27
; NO-SIMD128-NEXT:    i32.const $push98=, 1
; NO-SIMD128-NEXT:    i32.add $push23=, $pop22, $pop98
; NO-SIMD128-NEXT:    i32.const $push97=, 254
; NO-SIMD128-NEXT:    i32.and $push24=, $pop23, $pop97
; NO-SIMD128-NEXT:    i32.const $push96=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push25=, $pop24, $pop96
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop25
; NO-SIMD128-NEXT:    i32.add $push26=, $10, $26
; NO-SIMD128-NEXT:    i32.const $push95=, 1
; NO-SIMD128-NEXT:    i32.add $push27=, $pop26, $pop95
; NO-SIMD128-NEXT:    i32.const $push94=, 254
; NO-SIMD128-NEXT:    i32.and $push28=, $pop27, $pop94
; NO-SIMD128-NEXT:    i32.const $push93=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push29=, $pop28, $pop93
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop29
; NO-SIMD128-NEXT:    i32.add $push30=, $9, $25
; NO-SIMD128-NEXT:    i32.const $push92=, 1
; NO-SIMD128-NEXT:    i32.add $push31=, $pop30, $pop92
; NO-SIMD128-NEXT:    i32.const $push91=, 254
; NO-SIMD128-NEXT:    i32.and $push32=, $pop31, $pop91
; NO-SIMD128-NEXT:    i32.const $push90=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push33=, $pop32, $pop90
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop33
; NO-SIMD128-NEXT:    i32.add $push34=, $8, $24
; NO-SIMD128-NEXT:    i32.const $push89=, 1
; NO-SIMD128-NEXT:    i32.add $push35=, $pop34, $pop89
; NO-SIMD128-NEXT:    i32.const $push88=, 254
; NO-SIMD128-NEXT:    i32.and $push36=, $pop35, $pop88
; NO-SIMD128-NEXT:    i32.const $push87=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push37=, $pop36, $pop87
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop37
; NO-SIMD128-NEXT:    i32.add $push38=, $7, $23
; NO-SIMD128-NEXT:    i32.const $push86=, 1
; NO-SIMD128-NEXT:    i32.add $push39=, $pop38, $pop86
; NO-SIMD128-NEXT:    i32.const $push85=, 254
; NO-SIMD128-NEXT:    i32.and $push40=, $pop39, $pop85
; NO-SIMD128-NEXT:    i32.const $push84=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push41=, $pop40, $pop84
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop41
; NO-SIMD128-NEXT:    i32.add $push42=, $6, $22
; NO-SIMD128-NEXT:    i32.const $push83=, 1
; NO-SIMD128-NEXT:    i32.add $push43=, $pop42, $pop83
; NO-SIMD128-NEXT:    i32.const $push82=, 254
; NO-SIMD128-NEXT:    i32.and $push44=, $pop43, $pop82
; NO-SIMD128-NEXT:    i32.const $push81=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push45=, $pop44, $pop81
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop45
; NO-SIMD128-NEXT:    i32.add $push46=, $5, $21
; NO-SIMD128-NEXT:    i32.const $push80=, 1
; NO-SIMD128-NEXT:    i32.add $push47=, $pop46, $pop80
; NO-SIMD128-NEXT:    i32.const $push79=, 254
; NO-SIMD128-NEXT:    i32.and $push48=, $pop47, $pop79
; NO-SIMD128-NEXT:    i32.const $push78=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push49=, $pop48, $pop78
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop49
; NO-SIMD128-NEXT:    i32.add $push50=, $4, $20
; NO-SIMD128-NEXT:    i32.const $push77=, 1
; NO-SIMD128-NEXT:    i32.add $push51=, $pop50, $pop77
; NO-SIMD128-NEXT:    i32.const $push76=, 254
; NO-SIMD128-NEXT:    i32.and $push52=, $pop51, $pop76
; NO-SIMD128-NEXT:    i32.const $push75=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push53=, $pop52, $pop75
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop53
; NO-SIMD128-NEXT:    i32.add $push54=, $3, $19
; NO-SIMD128-NEXT:    i32.const $push74=, 1
; NO-SIMD128-NEXT:    i32.add $push55=, $pop54, $pop74
; NO-SIMD128-NEXT:    i32.const $push73=, 254
; NO-SIMD128-NEXT:    i32.and $push56=, $pop55, $pop73
; NO-SIMD128-NEXT:    i32.const $push72=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push57=, $pop56, $pop72
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop57
; NO-SIMD128-NEXT:    i32.add $push58=, $2, $18
; NO-SIMD128-NEXT:    i32.const $push71=, 1
; NO-SIMD128-NEXT:    i32.add $push59=, $pop58, $pop71
; NO-SIMD128-NEXT:    i32.const $push70=, 254
; NO-SIMD128-NEXT:    i32.and $push60=, $pop59, $pop70
; NO-SIMD128-NEXT:    i32.const $push69=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push61=, $pop60, $pop69
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop61
; NO-SIMD128-NEXT:    i32.add $push62=, $1, $17
; NO-SIMD128-NEXT:    i32.const $push68=, 1
; NO-SIMD128-NEXT:    i32.add $push63=, $pop62, $pop68
; NO-SIMD128-NEXT:    i32.const $push67=, 254
; NO-SIMD128-NEXT:    i32.and $push64=, $pop63, $pop67
; NO-SIMD128-NEXT:    i32.const $push66=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push65=, $pop64, $pop66
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop65
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: avgr_u_v16i8_wrap:
; NO-SIMD128-FAST:         .functype avgr_u_v16i8_wrap (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push111=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop111
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.const $push110=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push7=, $pop6, $pop110
; NO-SIMD128-FAST-NEXT:    i32.const $push109=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $pop7, $pop109
; NO-SIMD128-FAST-NEXT:    i32.const $push108=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop108
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.const $push107=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $pop10, $pop107
; NO-SIMD128-FAST-NEXT:    i32.const $push106=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $pop11, $pop106
; NO-SIMD128-FAST-NEXT:    i32.const $push105=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push13=, $pop12, $pop105
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.const $push104=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $pop14, $pop104
; NO-SIMD128-FAST-NEXT:    i32.const $push103=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $pop15, $pop103
; NO-SIMD128-FAST-NEXT:    i32.const $push102=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push17=, $pop16, $pop102
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.const $push101=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $pop18, $pop101
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $pop19, $pop100
; NO-SIMD128-FAST-NEXT:    i32.const $push99=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push21=, $pop20, $pop99
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.const $push98=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push23=, $pop22, $pop98
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $pop23, $pop97
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push25=, $pop24, $pop96
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop25
; NO-SIMD128-FAST-NEXT:    i32.add $push26=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $pop26, $pop95
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop94
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push29=, $pop28, $pop93
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop29
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $pop30, $pop92
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push32=, $pop31, $pop91
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push33=, $pop32, $pop90
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop33
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push35=, $pop34, $pop89
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push36=, $pop35, $pop88
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push37=, $pop36, $pop87
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop37
; NO-SIMD128-FAST-NEXT:    i32.add $push38=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.const $push86=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $pop38, $pop86
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push40=, $pop39, $pop85
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push41=, $pop40, $pop84
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop41
; NO-SIMD128-FAST-NEXT:    i32.add $push42=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.const $push83=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push43=, $pop42, $pop83
; NO-SIMD128-FAST-NEXT:    i32.const $push82=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push44=, $pop43, $pop82
; NO-SIMD128-FAST-NEXT:    i32.const $push81=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push45=, $pop44, $pop81
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop45
; NO-SIMD128-FAST-NEXT:    i32.add $push46=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.const $push80=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push47=, $pop46, $pop80
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push48=, $pop47, $pop79
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push49=, $pop48, $pop78
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop49
; NO-SIMD128-FAST-NEXT:    i32.add $push50=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.const $push77=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push51=, $pop50, $pop77
; NO-SIMD128-FAST-NEXT:    i32.const $push76=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push52=, $pop51, $pop76
; NO-SIMD128-FAST-NEXT:    i32.const $push75=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push53=, $pop52, $pop75
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop53
; NO-SIMD128-FAST-NEXT:    i32.add $push54=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.const $push74=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push55=, $pop54, $pop74
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push56=, $pop55, $pop73
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push57=, $pop56, $pop72
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop57
; NO-SIMD128-FAST-NEXT:    i32.add $push58=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.const $push71=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push59=, $pop58, $pop71
; NO-SIMD128-FAST-NEXT:    i32.const $push70=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push60=, $pop59, $pop70
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push61=, $pop60, $pop69
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop61
; NO-SIMD128-FAST-NEXT:    i32.add $push62=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.const $push68=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push63=, $pop62, $pop68
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push64=, $pop63, $pop67
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push65=, $pop64, $pop66
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop65
; NO-SIMD128-FAST-NEXT:    return
  %a = add <16 x i8> %x, %y
  %b = add <16 x i8> %a, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1,
                          i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %c = udiv <16 x i8> %b, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2,
                           i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  ret <16 x i8> %c
}

define <16 x i8> @abs_v16i8(<16 x i8> %x) {
; SIMD128-LABEL: abs_v16i8:
; SIMD128:         .functype abs_v16i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v16i8:
; SIMD128-FAST:         .functype abs_v16i8 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v16i8:
; NO-SIMD128:         .functype abs_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $16
; NO-SIMD128-NEXT:    i32.const $push1=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push95=, $pop0, $pop1
; NO-SIMD128-NEXT:    local.tee $push94=, $17=, $pop95
; NO-SIMD128-NEXT:    i32.xor $push2=, $16, $pop94
; NO-SIMD128-NEXT:    i32.sub $push3=, $pop2, $17
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop3
; NO-SIMD128-NEXT:    i32.extend8_s $push4=, $15
; NO-SIMD128-NEXT:    i32.const $push93=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push92=, $pop4, $pop93
; NO-SIMD128-NEXT:    local.tee $push91=, $16=, $pop92
; NO-SIMD128-NEXT:    i32.xor $push5=, $15, $pop91
; NO-SIMD128-NEXT:    i32.sub $push6=, $pop5, $16
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop6
; NO-SIMD128-NEXT:    i32.extend8_s $push7=, $14
; NO-SIMD128-NEXT:    i32.const $push90=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push89=, $pop7, $pop90
; NO-SIMD128-NEXT:    local.tee $push88=, $16=, $pop89
; NO-SIMD128-NEXT:    i32.xor $push8=, $14, $pop88
; NO-SIMD128-NEXT:    i32.sub $push9=, $pop8, $16
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop9
; NO-SIMD128-NEXT:    i32.extend8_s $push10=, $13
; NO-SIMD128-NEXT:    i32.const $push87=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push86=, $pop10, $pop87
; NO-SIMD128-NEXT:    local.tee $push85=, $16=, $pop86
; NO-SIMD128-NEXT:    i32.xor $push11=, $13, $pop85
; NO-SIMD128-NEXT:    i32.sub $push12=, $pop11, $16
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop12
; NO-SIMD128-NEXT:    i32.extend8_s $push13=, $12
; NO-SIMD128-NEXT:    i32.const $push84=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push83=, $pop13, $pop84
; NO-SIMD128-NEXT:    local.tee $push82=, $16=, $pop83
; NO-SIMD128-NEXT:    i32.xor $push14=, $12, $pop82
; NO-SIMD128-NEXT:    i32.sub $push15=, $pop14, $16
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop15
; NO-SIMD128-NEXT:    i32.extend8_s $push16=, $11
; NO-SIMD128-NEXT:    i32.const $push81=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push80=, $pop16, $pop81
; NO-SIMD128-NEXT:    local.tee $push79=, $16=, $pop80
; NO-SIMD128-NEXT:    i32.xor $push17=, $11, $pop79
; NO-SIMD128-NEXT:    i32.sub $push18=, $pop17, $16
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop18
; NO-SIMD128-NEXT:    i32.extend8_s $push19=, $10
; NO-SIMD128-NEXT:    i32.const $push78=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push77=, $pop19, $pop78
; NO-SIMD128-NEXT:    local.tee $push76=, $16=, $pop77
; NO-SIMD128-NEXT:    i32.xor $push20=, $10, $pop76
; NO-SIMD128-NEXT:    i32.sub $push21=, $pop20, $16
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop21
; NO-SIMD128-NEXT:    i32.extend8_s $push22=, $9
; NO-SIMD128-NEXT:    i32.const $push75=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push74=, $pop22, $pop75
; NO-SIMD128-NEXT:    local.tee $push73=, $16=, $pop74
; NO-SIMD128-NEXT:    i32.xor $push23=, $9, $pop73
; NO-SIMD128-NEXT:    i32.sub $push24=, $pop23, $16
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop24
; NO-SIMD128-NEXT:    i32.extend8_s $push25=, $8
; NO-SIMD128-NEXT:    i32.const $push72=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push71=, $pop25, $pop72
; NO-SIMD128-NEXT:    local.tee $push70=, $16=, $pop71
; NO-SIMD128-NEXT:    i32.xor $push26=, $8, $pop70
; NO-SIMD128-NEXT:    i32.sub $push27=, $pop26, $16
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop27
; NO-SIMD128-NEXT:    i32.extend8_s $push28=, $7
; NO-SIMD128-NEXT:    i32.const $push69=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push68=, $pop28, $pop69
; NO-SIMD128-NEXT:    local.tee $push67=, $16=, $pop68
; NO-SIMD128-NEXT:    i32.xor $push29=, $7, $pop67
; NO-SIMD128-NEXT:    i32.sub $push30=, $pop29, $16
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop30
; NO-SIMD128-NEXT:    i32.extend8_s $push31=, $6
; NO-SIMD128-NEXT:    i32.const $push66=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push65=, $pop31, $pop66
; NO-SIMD128-NEXT:    local.tee $push64=, $16=, $pop65
; NO-SIMD128-NEXT:    i32.xor $push32=, $6, $pop64
; NO-SIMD128-NEXT:    i32.sub $push33=, $pop32, $16
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop33
; NO-SIMD128-NEXT:    i32.extend8_s $push34=, $5
; NO-SIMD128-NEXT:    i32.const $push63=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push62=, $pop34, $pop63
; NO-SIMD128-NEXT:    local.tee $push61=, $16=, $pop62
; NO-SIMD128-NEXT:    i32.xor $push35=, $5, $pop61
; NO-SIMD128-NEXT:    i32.sub $push36=, $pop35, $16
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop36
; NO-SIMD128-NEXT:    i32.extend8_s $push37=, $4
; NO-SIMD128-NEXT:    i32.const $push60=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push59=, $pop37, $pop60
; NO-SIMD128-NEXT:    local.tee $push58=, $16=, $pop59
; NO-SIMD128-NEXT:    i32.xor $push38=, $4, $pop58
; NO-SIMD128-NEXT:    i32.sub $push39=, $pop38, $16
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop39
; NO-SIMD128-NEXT:    i32.extend8_s $push40=, $3
; NO-SIMD128-NEXT:    i32.const $push57=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push56=, $pop40, $pop57
; NO-SIMD128-NEXT:    local.tee $push55=, $16=, $pop56
; NO-SIMD128-NEXT:    i32.xor $push41=, $3, $pop55
; NO-SIMD128-NEXT:    i32.sub $push42=, $pop41, $16
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop42
; NO-SIMD128-NEXT:    i32.extend8_s $push43=, $2
; NO-SIMD128-NEXT:    i32.const $push54=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push53=, $pop43, $pop54
; NO-SIMD128-NEXT:    local.tee $push52=, $16=, $pop53
; NO-SIMD128-NEXT:    i32.xor $push44=, $2, $pop52
; NO-SIMD128-NEXT:    i32.sub $push45=, $pop44, $16
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop45
; NO-SIMD128-NEXT:    i32.extend8_s $push46=, $1
; NO-SIMD128-NEXT:    i32.const $push51=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push50=, $pop46, $pop51
; NO-SIMD128-NEXT:    local.tee $push49=, $16=, $pop50
; NO-SIMD128-NEXT:    i32.xor $push47=, $1, $pop49
; NO-SIMD128-NEXT:    i32.sub $push48=, $pop47, $16
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop48
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v16i8:
; NO-SIMD128-FAST:         .functype abs_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push0=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push95=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    local.tee $push94=, $17=, $pop95
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $1, $pop94
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $pop2, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push4=, $2
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push92=, $pop4, $pop93
; NO-SIMD128-FAST-NEXT:    local.tee $push91=, $1=, $pop92
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $2, $pop91
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push7=, $3
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push89=, $pop7, $pop90
; NO-SIMD128-FAST-NEXT:    local.tee $push88=, $2=, $pop89
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $3, $pop88
; NO-SIMD128-FAST-NEXT:    i32.sub $push9=, $pop8, $2
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push10=, $4
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push86=, $pop10, $pop87
; NO-SIMD128-FAST-NEXT:    local.tee $push85=, $3=, $pop86
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $4, $pop85
; NO-SIMD128-FAST-NEXT:    i32.sub $push12=, $pop11, $3
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push13=, $5
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push83=, $pop13, $pop84
; NO-SIMD128-FAST-NEXT:    local.tee $push82=, $4=, $pop83
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $5, $pop82
; NO-SIMD128-FAST-NEXT:    i32.sub $push15=, $pop14, $4
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push16=, $6
; NO-SIMD128-FAST-NEXT:    i32.const $push81=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push80=, $pop16, $pop81
; NO-SIMD128-FAST-NEXT:    local.tee $push79=, $5=, $pop80
; NO-SIMD128-FAST-NEXT:    i32.xor $push17=, $6, $pop79
; NO-SIMD128-FAST-NEXT:    i32.sub $push18=, $pop17, $5
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push19=, $7
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push77=, $pop19, $pop78
; NO-SIMD128-FAST-NEXT:    local.tee $push76=, $6=, $pop77
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $7, $pop76
; NO-SIMD128-FAST-NEXT:    i32.sub $push21=, $pop20, $6
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push22=, $8
; NO-SIMD128-FAST-NEXT:    i32.const $push75=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push74=, $pop22, $pop75
; NO-SIMD128-FAST-NEXT:    local.tee $push73=, $7=, $pop74
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $8, $pop73
; NO-SIMD128-FAST-NEXT:    i32.sub $push24=, $pop23, $7
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push25=, $9
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push71=, $pop25, $pop72
; NO-SIMD128-FAST-NEXT:    local.tee $push70=, $8=, $pop71
; NO-SIMD128-FAST-NEXT:    i32.xor $push26=, $9, $pop70
; NO-SIMD128-FAST-NEXT:    i32.sub $push27=, $pop26, $8
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop27
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push28=, $10
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push68=, $pop28, $pop69
; NO-SIMD128-FAST-NEXT:    local.tee $push67=, $9=, $pop68
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $10, $pop67
; NO-SIMD128-FAST-NEXT:    i32.sub $push30=, $pop29, $9
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop30
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push31=, $11
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push65=, $pop31, $pop66
; NO-SIMD128-FAST-NEXT:    local.tee $push64=, $10=, $pop65
; NO-SIMD128-FAST-NEXT:    i32.xor $push32=, $11, $pop64
; NO-SIMD128-FAST-NEXT:    i32.sub $push33=, $pop32, $10
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop33
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push34=, $12
; NO-SIMD128-FAST-NEXT:    i32.const $push63=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push62=, $pop34, $pop63
; NO-SIMD128-FAST-NEXT:    local.tee $push61=, $11=, $pop62
; NO-SIMD128-FAST-NEXT:    i32.xor $push35=, $12, $pop61
; NO-SIMD128-FAST-NEXT:    i32.sub $push36=, $pop35, $11
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop36
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push37=, $13
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push59=, $pop37, $pop60
; NO-SIMD128-FAST-NEXT:    local.tee $push58=, $12=, $pop59
; NO-SIMD128-FAST-NEXT:    i32.xor $push38=, $13, $pop58
; NO-SIMD128-FAST-NEXT:    i32.sub $push39=, $pop38, $12
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop39
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push40=, $14
; NO-SIMD128-FAST-NEXT:    i32.const $push57=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push56=, $pop40, $pop57
; NO-SIMD128-FAST-NEXT:    local.tee $push55=, $13=, $pop56
; NO-SIMD128-FAST-NEXT:    i32.xor $push41=, $14, $pop55
; NO-SIMD128-FAST-NEXT:    i32.sub $push42=, $pop41, $13
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop42
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push43=, $15
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push53=, $pop43, $pop54
; NO-SIMD128-FAST-NEXT:    local.tee $push52=, $14=, $pop53
; NO-SIMD128-FAST-NEXT:    i32.xor $push44=, $15, $pop52
; NO-SIMD128-FAST-NEXT:    i32.sub $push45=, $pop44, $14
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop45
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push46=, $16
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push50=, $pop46, $pop51
; NO-SIMD128-FAST-NEXT:    local.tee $push49=, $15=, $pop50
; NO-SIMD128-FAST-NEXT:    i32.xor $push47=, $16, $pop49
; NO-SIMD128-FAST-NEXT:    i32.sub $push48=, $pop47, $15
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop48
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <16 x i8> zeroinitializer, %x
  %b = icmp slt <16 x i8> %x, zeroinitializer
  %c = select <16 x i1> %b, <16 x i8> %a, <16 x i8> %x
  ret <16 x i8> %c
}

define <16 x i8> @neg_v16i8(<16 x i8> %x) {
; SIMD128-LABEL: neg_v16i8:
; SIMD128:         .functype neg_v16i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v16i8:
; SIMD128-FAST:         .functype neg_v16i8 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v16i8:
; NO-SIMD128:         .functype neg_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 0
; NO-SIMD128-NEXT:    i32.sub $push1=, $pop0, $16
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push31=, 0
; NO-SIMD128-NEXT:    i32.sub $push2=, $pop31, $15
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push30=, 0
; NO-SIMD128-NEXT:    i32.sub $push3=, $pop30, $14
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push29=, 0
; NO-SIMD128-NEXT:    i32.sub $push4=, $pop29, $13
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push28=, 0
; NO-SIMD128-NEXT:    i32.sub $push5=, $pop28, $12
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push27=, 0
; NO-SIMD128-NEXT:    i32.sub $push6=, $pop27, $11
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push26=, 0
; NO-SIMD128-NEXT:    i32.sub $push7=, $pop26, $10
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop7
; NO-SIMD128-NEXT:    i32.const $push25=, 0
; NO-SIMD128-NEXT:    i32.sub $push8=, $pop25, $9
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push24=, 0
; NO-SIMD128-NEXT:    i32.sub $push9=, $pop24, $8
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push23=, 0
; NO-SIMD128-NEXT:    i32.sub $push10=, $pop23, $7
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push22=, 0
; NO-SIMD128-NEXT:    i32.sub $push11=, $pop22, $6
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop11
; NO-SIMD128-NEXT:    i32.const $push21=, 0
; NO-SIMD128-NEXT:    i32.sub $push12=, $pop21, $5
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push20=, 0
; NO-SIMD128-NEXT:    i32.sub $push13=, $pop20, $4
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop13
; NO-SIMD128-NEXT:    i32.const $push19=, 0
; NO-SIMD128-NEXT:    i32.sub $push14=, $pop19, $3
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop14
; NO-SIMD128-NEXT:    i32.const $push18=, 0
; NO-SIMD128-NEXT:    i32.sub $push15=, $pop18, $2
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop15
; NO-SIMD128-NEXT:    i32.const $push17=, 0
; NO-SIMD128-NEXT:    i32.sub $push16=, $pop17, $1
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop16
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v16i8:
; NO-SIMD128-FAST:         .functype neg_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $pop31, $2
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $pop30, $3
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push4=, $pop29, $4
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push5=, $pop28, $5
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $pop27, $6
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push7=, $pop26, $7
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push25=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push8=, $pop25, $8
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push24=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push9=, $pop24, $9
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push10=, $pop23, $10
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push11=, $pop22, $11
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push12=, $pop21, $12
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push13=, $pop20, $13
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push14=, $pop19, $14
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push15=, $pop18, $15
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push16=, $pop17, $16
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <16 x i8> <i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0,
                      i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0>,
                     %x
  ret <16 x i8> %a
}

define <16 x i8> @shl_v16i8(<16 x i8> %v, i8 %x) {
; SIMD128-LABEL: shl_v16i8:
; SIMD128:         .functype shl_v16i8 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shl $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shl_v16i8:
; SIMD128-FAST:         .functype shl_v16i8 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.shl $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_v16i8:
; NO-SIMD128:         .functype shl_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push18=, $17, $pop0
; NO-SIMD128-NEXT:    local.tee $push17=, $17=, $pop18
; NO-SIMD128-NEXT:    i32.shl $push1=, $16, $pop17
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop1
; NO-SIMD128-NEXT:    i32.shl $push2=, $15, $17
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop2
; NO-SIMD128-NEXT:    i32.shl $push3=, $14, $17
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop3
; NO-SIMD128-NEXT:    i32.shl $push4=, $13, $17
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop4
; NO-SIMD128-NEXT:    i32.shl $push5=, $12, $17
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop5
; NO-SIMD128-NEXT:    i32.shl $push6=, $11, $17
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop6
; NO-SIMD128-NEXT:    i32.shl $push7=, $10, $17
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop7
; NO-SIMD128-NEXT:    i32.shl $push8=, $9, $17
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop8
; NO-SIMD128-NEXT:    i32.shl $push9=, $8, $17
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop9
; NO-SIMD128-NEXT:    i32.shl $push10=, $7, $17
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop10
; NO-SIMD128-NEXT:    i32.shl $push11=, $6, $17
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop11
; NO-SIMD128-NEXT:    i32.shl $push12=, $5, $17
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop12
; NO-SIMD128-NEXT:    i32.shl $push13=, $4, $17
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop13
; NO-SIMD128-NEXT:    i32.shl $push14=, $3, $17
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop14
; NO-SIMD128-NEXT:    i32.shl $push15=, $2, $17
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop15
; NO-SIMD128-NEXT:    i32.shl $push16=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop16
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_v16i8:
; NO-SIMD128-FAST:         .functype shl_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $17, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push17=, $17=, $pop18
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $2, $pop17
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $3, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.shl $push4=, $4, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.shl $push5=, $5, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $6, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.shl $push7=, $7, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.shl $push8=, $8, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.shl $push9=, $9, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.shl $push10=, $10, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.shl $push11=, $11, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.shl $push12=, $12, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.shl $push13=, $13, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.shl $push14=, $14, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.shl $push15=, $15, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.shl $push16=, $16, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <16 x i8> undef, i8 %x, i32 0
  %s = shufflevector <16 x i8> %t, <16 x i8> undef,
    <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0,
                i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = shl <16 x i8> %v, %s
  ret <16 x i8> %a
}

define <16 x i8> @shl_const_v16i8(<16 x i8> %v) {
; SIMD128-LABEL: shl_const_v16i8:
; SIMD128:         .functype shl_const_v16i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i8x16.shl $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shl_const_v16i8:
; SIMD128-FAST:         .functype shl_const_v16i8 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i8x16.shl $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_const_v16i8:
; NO-SIMD128:         .functype shl_const_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 5
; NO-SIMD128-NEXT:    i32.shl $push1=, $16, $pop0
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push31=, 5
; NO-SIMD128-NEXT:    i32.shl $push2=, $15, $pop31
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push30=, 5
; NO-SIMD128-NEXT:    i32.shl $push3=, $14, $pop30
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push29=, 5
; NO-SIMD128-NEXT:    i32.shl $push4=, $13, $pop29
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push28=, 5
; NO-SIMD128-NEXT:    i32.shl $push5=, $12, $pop28
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push27=, 5
; NO-SIMD128-NEXT:    i32.shl $push6=, $11, $pop27
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push26=, 5
; NO-SIMD128-NEXT:    i32.shl $push7=, $10, $pop26
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop7
; NO-SIMD128-NEXT:    i32.const $push25=, 5
; NO-SIMD128-NEXT:    i32.shl $push8=, $9, $pop25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push24=, 5
; NO-SIMD128-NEXT:    i32.shl $push9=, $8, $pop24
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push23=, 5
; NO-SIMD128-NEXT:    i32.shl $push10=, $7, $pop23
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push22=, 5
; NO-SIMD128-NEXT:    i32.shl $push11=, $6, $pop22
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop11
; NO-SIMD128-NEXT:    i32.const $push21=, 5
; NO-SIMD128-NEXT:    i32.shl $push12=, $5, $pop21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push20=, 5
; NO-SIMD128-NEXT:    i32.shl $push13=, $4, $pop20
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop13
; NO-SIMD128-NEXT:    i32.const $push19=, 5
; NO-SIMD128-NEXT:    i32.shl $push14=, $3, $pop19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop14
; NO-SIMD128-NEXT:    i32.const $push18=, 5
; NO-SIMD128-NEXT:    i32.shl $push15=, $2, $pop18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop15
; NO-SIMD128-NEXT:    i32.const $push17=, 5
; NO-SIMD128-NEXT:    i32.shl $push16=, $1, $pop17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop16
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_const_v16i8:
; NO-SIMD128-FAST:         .functype shl_const_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $2, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $3, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push4=, $4, $pop29
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push5=, $5, $pop28
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $6, $pop27
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push7=, $7, $pop26
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push25=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push8=, $8, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push24=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push9=, $9, $pop24
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push10=, $10, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push11=, $11, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push12=, $12, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push13=, $13, $pop20
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push14=, $14, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push15=, $15, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push16=, $16, $pop17
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <16 x i8> %v,
    <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5,
     i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5>
  ret <16 x i8> %a
}

define <16 x i8> @shl_vec_v16i8(<16 x i8> %v, <16 x i8> %x) {
; SIMD128-LABEL: shl_vec_v16i8:
; SIMD128:         .functype shl_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_u $push7=, $0, 0
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 7
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shl $push8=, $pop7, $pop6
; SIMD128-NEXT:    i8x16.splat $push9=, $pop8
; SIMD128-NEXT:    i8x16.extract_lane_u $push3=, $0, 1
; SIMD128-NEXT:    i8x16.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push95=, 7
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop95
; SIMD128-NEXT:    i32.shl $push4=, $pop3, $pop2
; SIMD128-NEXT:    i8x16.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i8x16.extract_lane_u $push13=, $0, 2
; SIMD128-NEXT:    i8x16.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push94=, 7
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop94
; SIMD128-NEXT:    i32.shl $push14=, $pop13, $pop12
; SIMD128-NEXT:    i8x16.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i8x16.extract_lane_u $push18=, $0, 3
; SIMD128-NEXT:    i8x16.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push93=, 7
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop93
; SIMD128-NEXT:    i32.shl $push19=, $pop18, $pop17
; SIMD128-NEXT:    i8x16.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i8x16.extract_lane_u $push23=, $0, 4
; SIMD128-NEXT:    i8x16.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push92=, 7
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop92
; SIMD128-NEXT:    i32.shl $push24=, $pop23, $pop22
; SIMD128-NEXT:    i8x16.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i8x16.extract_lane_u $push28=, $0, 5
; SIMD128-NEXT:    i8x16.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push91=, 7
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop91
; SIMD128-NEXT:    i32.shl $push29=, $pop28, $pop27
; SIMD128-NEXT:    i8x16.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i8x16.extract_lane_u $push33=, $0, 6
; SIMD128-NEXT:    i8x16.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push90=, 7
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop90
; SIMD128-NEXT:    i32.shl $push34=, $pop33, $pop32
; SIMD128-NEXT:    i8x16.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i8x16.extract_lane_u $push38=, $0, 7
; SIMD128-NEXT:    i8x16.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push89=, 7
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop89
; SIMD128-NEXT:    i32.shl $push39=, $pop38, $pop37
; SIMD128-NEXT:    i8x16.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    i8x16.extract_lane_u $push43=, $0, 8
; SIMD128-NEXT:    i8x16.extract_lane_u $push41=, $1, 8
; SIMD128-NEXT:    i32.const $push88=, 7
; SIMD128-NEXT:    i32.and $push42=, $pop41, $pop88
; SIMD128-NEXT:    i32.shl $push44=, $pop43, $pop42
; SIMD128-NEXT:    i8x16.replace_lane $push45=, $pop40, 8, $pop44
; SIMD128-NEXT:    i8x16.extract_lane_u $push48=, $0, 9
; SIMD128-NEXT:    i8x16.extract_lane_u $push46=, $1, 9
; SIMD128-NEXT:    i32.const $push87=, 7
; SIMD128-NEXT:    i32.and $push47=, $pop46, $pop87
; SIMD128-NEXT:    i32.shl $push49=, $pop48, $pop47
; SIMD128-NEXT:    i8x16.replace_lane $push50=, $pop45, 9, $pop49
; SIMD128-NEXT:    i8x16.extract_lane_u $push53=, $0, 10
; SIMD128-NEXT:    i8x16.extract_lane_u $push51=, $1, 10
; SIMD128-NEXT:    i32.const $push86=, 7
; SIMD128-NEXT:    i32.and $push52=, $pop51, $pop86
; SIMD128-NEXT:    i32.shl $push54=, $pop53, $pop52
; SIMD128-NEXT:    i8x16.replace_lane $push55=, $pop50, 10, $pop54
; SIMD128-NEXT:    i8x16.extract_lane_u $push58=, $0, 11
; SIMD128-NEXT:    i8x16.extract_lane_u $push56=, $1, 11
; SIMD128-NEXT:    i32.const $push85=, 7
; SIMD128-NEXT:    i32.and $push57=, $pop56, $pop85
; SIMD128-NEXT:    i32.shl $push59=, $pop58, $pop57
; SIMD128-NEXT:    i8x16.replace_lane $push60=, $pop55, 11, $pop59
; SIMD128-NEXT:    i8x16.extract_lane_u $push63=, $0, 12
; SIMD128-NEXT:    i8x16.extract_lane_u $push61=, $1, 12
; SIMD128-NEXT:    i32.const $push84=, 7
; SIMD128-NEXT:    i32.and $push62=, $pop61, $pop84
; SIMD128-NEXT:    i32.shl $push64=, $pop63, $pop62
; SIMD128-NEXT:    i8x16.replace_lane $push65=, $pop60, 12, $pop64
; SIMD128-NEXT:    i8x16.extract_lane_u $push68=, $0, 13
; SIMD128-NEXT:    i8x16.extract_lane_u $push66=, $1, 13
; SIMD128-NEXT:    i32.const $push83=, 7
; SIMD128-NEXT:    i32.and $push67=, $pop66, $pop83
; SIMD128-NEXT:    i32.shl $push69=, $pop68, $pop67
; SIMD128-NEXT:    i8x16.replace_lane $push70=, $pop65, 13, $pop69
; SIMD128-NEXT:    i8x16.extract_lane_u $push73=, $0, 14
; SIMD128-NEXT:    i8x16.extract_lane_u $push71=, $1, 14
; SIMD128-NEXT:    i32.const $push82=, 7
; SIMD128-NEXT:    i32.and $push72=, $pop71, $pop82
; SIMD128-NEXT:    i32.shl $push74=, $pop73, $pop72
; SIMD128-NEXT:    i8x16.replace_lane $push75=, $pop70, 14, $pop74
; SIMD128-NEXT:    i8x16.extract_lane_u $push78=, $0, 15
; SIMD128-NEXT:    i8x16.extract_lane_u $push76=, $1, 15
; SIMD128-NEXT:    i32.const $push81=, 7
; SIMD128-NEXT:    i32.and $push77=, $pop76, $pop81
; SIMD128-NEXT:    i32.shl $push79=, $pop78, $pop77
; SIMD128-NEXT:    i8x16.replace_lane $push80=, $pop75, 15, $pop79
; SIMD128-NEXT:    return $pop80
;
; SIMD128-FAST-LABEL: shl_vec_v16i8:
; SIMD128-FAST:         .functype shl_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push8=, $0, 0
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 7
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shl $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i8x16.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push4=, $0, 1
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push95=, 7
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop95
; SIMD128-FAST-NEXT:    i32.shl $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push14=, $0, 2
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push94=, 7
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop94
; SIMD128-FAST-NEXT:    i32.shl $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push19=, $0, 3
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push93=, 7
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop93
; SIMD128-FAST-NEXT:    i32.shl $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push24=, $0, 4
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push92=, 7
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop92
; SIMD128-FAST-NEXT:    i32.shl $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push29=, $0, 5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push91=, 7
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop91
; SIMD128-FAST-NEXT:    i32.shl $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push34=, $0, 6
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push90=, 7
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop90
; SIMD128-FAST-NEXT:    i32.shl $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push39=, $0, 7
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push89=, 7
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop89
; SIMD128-FAST-NEXT:    i32.shl $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push41=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push44=, $0, 8
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push42=, $1, 8
; SIMD128-FAST-NEXT:    i32.const $push88=, 7
; SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $pop88
; SIMD128-FAST-NEXT:    i32.shl $push45=, $pop44, $pop43
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push46=, $pop41, 8, $pop45
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push49=, $0, 9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push47=, $1, 9
; SIMD128-FAST-NEXT:    i32.const $push87=, 7
; SIMD128-FAST-NEXT:    i32.and $push48=, $pop47, $pop87
; SIMD128-FAST-NEXT:    i32.shl $push50=, $pop49, $pop48
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push51=, $pop46, 9, $pop50
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push54=, $0, 10
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push52=, $1, 10
; SIMD128-FAST-NEXT:    i32.const $push86=, 7
; SIMD128-FAST-NEXT:    i32.and $push53=, $pop52, $pop86
; SIMD128-FAST-NEXT:    i32.shl $push55=, $pop54, $pop53
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push56=, $pop51, 10, $pop55
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push59=, $0, 11
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push57=, $1, 11
; SIMD128-FAST-NEXT:    i32.const $push85=, 7
; SIMD128-FAST-NEXT:    i32.and $push58=, $pop57, $pop85
; SIMD128-FAST-NEXT:    i32.shl $push60=, $pop59, $pop58
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push61=, $pop56, 11, $pop60
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push64=, $0, 12
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push62=, $1, 12
; SIMD128-FAST-NEXT:    i32.const $push84=, 7
; SIMD128-FAST-NEXT:    i32.and $push63=, $pop62, $pop84
; SIMD128-FAST-NEXT:    i32.shl $push65=, $pop64, $pop63
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push66=, $pop61, 12, $pop65
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push69=, $0, 13
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push67=, $1, 13
; SIMD128-FAST-NEXT:    i32.const $push83=, 7
; SIMD128-FAST-NEXT:    i32.and $push68=, $pop67, $pop83
; SIMD128-FAST-NEXT:    i32.shl $push70=, $pop69, $pop68
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push71=, $pop66, 13, $pop70
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push74=, $0, 14
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push72=, $1, 14
; SIMD128-FAST-NEXT:    i32.const $push82=, 7
; SIMD128-FAST-NEXT:    i32.and $push73=, $pop72, $pop82
; SIMD128-FAST-NEXT:    i32.shl $push75=, $pop74, $pop73
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push76=, $pop71, 14, $pop75
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push79=, $0, 15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push77=, $1, 15
; SIMD128-FAST-NEXT:    i32.const $push81=, 7
; SIMD128-FAST-NEXT:    i32.and $push78=, $pop77, $pop81
; SIMD128-FAST-NEXT:    i32.shl $push80=, $pop79, $pop78
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push0=, $pop76, 15, $pop80
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_vec_v16i8:
; NO-SIMD128:         .functype shl_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $32, $pop0
; NO-SIMD128-NEXT:    i32.shl $push2=, $16, $pop1
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push47=, 255
; NO-SIMD128-NEXT:    i32.and $push3=, $31, $pop47
; NO-SIMD128-NEXT:    i32.shl $push4=, $15, $pop3
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push46=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $30, $pop46
; NO-SIMD128-NEXT:    i32.shl $push6=, $14, $pop5
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push45=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $29, $pop45
; NO-SIMD128-NEXT:    i32.shl $push8=, $13, $pop7
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push44=, 255
; NO-SIMD128-NEXT:    i32.and $push9=, $28, $pop44
; NO-SIMD128-NEXT:    i32.shl $push10=, $12, $pop9
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push43=, 255
; NO-SIMD128-NEXT:    i32.and $push11=, $27, $pop43
; NO-SIMD128-NEXT:    i32.shl $push12=, $11, $pop11
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push42=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $26, $pop42
; NO-SIMD128-NEXT:    i32.shl $push14=, $10, $pop13
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop14
; NO-SIMD128-NEXT:    i32.const $push41=, 255
; NO-SIMD128-NEXT:    i32.and $push15=, $25, $pop41
; NO-SIMD128-NEXT:    i32.shl $push16=, $9, $pop15
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop16
; NO-SIMD128-NEXT:    i32.const $push40=, 255
; NO-SIMD128-NEXT:    i32.and $push17=, $24, $pop40
; NO-SIMD128-NEXT:    i32.shl $push18=, $8, $pop17
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop18
; NO-SIMD128-NEXT:    i32.const $push39=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $23, $pop39
; NO-SIMD128-NEXT:    i32.shl $push20=, $7, $pop19
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop20
; NO-SIMD128-NEXT:    i32.const $push38=, 255
; NO-SIMD128-NEXT:    i32.and $push21=, $22, $pop38
; NO-SIMD128-NEXT:    i32.shl $push22=, $6, $pop21
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop22
; NO-SIMD128-NEXT:    i32.const $push37=, 255
; NO-SIMD128-NEXT:    i32.and $push23=, $21, $pop37
; NO-SIMD128-NEXT:    i32.shl $push24=, $5, $pop23
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop24
; NO-SIMD128-NEXT:    i32.const $push36=, 255
; NO-SIMD128-NEXT:    i32.and $push25=, $20, $pop36
; NO-SIMD128-NEXT:    i32.shl $push26=, $4, $pop25
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop26
; NO-SIMD128-NEXT:    i32.const $push35=, 255
; NO-SIMD128-NEXT:    i32.and $push27=, $19, $pop35
; NO-SIMD128-NEXT:    i32.shl $push28=, $3, $pop27
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop28
; NO-SIMD128-NEXT:    i32.const $push34=, 255
; NO-SIMD128-NEXT:    i32.and $push29=, $18, $pop34
; NO-SIMD128-NEXT:    i32.shl $push30=, $2, $pop29
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop30
; NO-SIMD128-NEXT:    i32.const $push33=, 255
; NO-SIMD128-NEXT:    i32.and $push31=, $17, $pop33
; NO-SIMD128-NEXT:    i32.shl $push32=, $1, $pop31
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop32
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_vec_v16i8:
; NO-SIMD128-FAST:         .functype shl_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop0
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $18, $pop47
; NO-SIMD128-FAST-NEXT:    i32.shl $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $19, $pop46
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $3, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $20, $pop45
; NO-SIMD128-FAST-NEXT:    i32.shl $push8=, $4, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $21, $pop44
; NO-SIMD128-FAST-NEXT:    i32.shl $push10=, $5, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $22, $pop43
; NO-SIMD128-FAST-NEXT:    i32.shl $push12=, $6, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $23, $pop42
; NO-SIMD128-FAST-NEXT:    i32.shl $push14=, $7, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $24, $pop41
; NO-SIMD128-FAST-NEXT:    i32.shl $push16=, $8, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $25, $pop40
; NO-SIMD128-FAST-NEXT:    i32.shl $push18=, $9, $pop17
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $26, $pop39
; NO-SIMD128-FAST-NEXT:    i32.shl $push20=, $10, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $27, $pop38
; NO-SIMD128-FAST-NEXT:    i32.shl $push22=, $11, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $28, $pop37
; NO-SIMD128-FAST-NEXT:    i32.shl $push24=, $12, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $29, $pop36
; NO-SIMD128-FAST-NEXT:    i32.shl $push26=, $13, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push27=, $30, $pop35
; NO-SIMD128-FAST-NEXT:    i32.shl $push28=, $14, $pop27
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $31, $pop34
; NO-SIMD128-FAST-NEXT:    i32.shl $push30=, $15, $pop29
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $32, $pop33
; NO-SIMD128-FAST-NEXT:    i32.shl $push32=, $16, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop32
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <16 x i8> %v, %x
  ret <16 x i8> %a
}

define <16 x i8> @shr_s_v16i8(<16 x i8> %v, i8 %x) {
; SIMD128-LABEL: shr_s_v16i8:
; SIMD128:         .functype shr_s_v16i8 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shr_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_s_v16i8:
; SIMD128-FAST:         .functype shr_s_v16i8 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.shr_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_v16i8:
; NO-SIMD128:         .functype shr_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push1=, $16
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push34=, $17, $pop0
; NO-SIMD128-NEXT:    local.tee $push33=, $17=, $pop34
; NO-SIMD128-NEXT:    i32.shr_s $push2=, $pop1, $pop33
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop2
; NO-SIMD128-NEXT:    i32.extend8_s $push3=, $15
; NO-SIMD128-NEXT:    i32.shr_s $push4=, $pop3, $17
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop4
; NO-SIMD128-NEXT:    i32.extend8_s $push5=, $14
; NO-SIMD128-NEXT:    i32.shr_s $push6=, $pop5, $17
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop6
; NO-SIMD128-NEXT:    i32.extend8_s $push7=, $13
; NO-SIMD128-NEXT:    i32.shr_s $push8=, $pop7, $17
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop8
; NO-SIMD128-NEXT:    i32.extend8_s $push9=, $12
; NO-SIMD128-NEXT:    i32.shr_s $push10=, $pop9, $17
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop10
; NO-SIMD128-NEXT:    i32.extend8_s $push11=, $11
; NO-SIMD128-NEXT:    i32.shr_s $push12=, $pop11, $17
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop12
; NO-SIMD128-NEXT:    i32.extend8_s $push13=, $10
; NO-SIMD128-NEXT:    i32.shr_s $push14=, $pop13, $17
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop14
; NO-SIMD128-NEXT:    i32.extend8_s $push15=, $9
; NO-SIMD128-NEXT:    i32.shr_s $push16=, $pop15, $17
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop16
; NO-SIMD128-NEXT:    i32.extend8_s $push17=, $8
; NO-SIMD128-NEXT:    i32.shr_s $push18=, $pop17, $17
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop18
; NO-SIMD128-NEXT:    i32.extend8_s $push19=, $7
; NO-SIMD128-NEXT:    i32.shr_s $push20=, $pop19, $17
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop20
; NO-SIMD128-NEXT:    i32.extend8_s $push21=, $6
; NO-SIMD128-NEXT:    i32.shr_s $push22=, $pop21, $17
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop22
; NO-SIMD128-NEXT:    i32.extend8_s $push23=, $5
; NO-SIMD128-NEXT:    i32.shr_s $push24=, $pop23, $17
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop24
; NO-SIMD128-NEXT:    i32.extend8_s $push25=, $4
; NO-SIMD128-NEXT:    i32.shr_s $push26=, $pop25, $17
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop26
; NO-SIMD128-NEXT:    i32.extend8_s $push27=, $3
; NO-SIMD128-NEXT:    i32.shr_s $push28=, $pop27, $17
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop28
; NO-SIMD128-NEXT:    i32.extend8_s $push29=, $2
; NO-SIMD128-NEXT:    i32.shr_s $push30=, $pop29, $17
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop30
; NO-SIMD128-NEXT:    i32.extend8_s $push31=, $1
; NO-SIMD128-NEXT:    i32.shr_s $push32=, $pop31, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop32
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_v16i8:
; NO-SIMD128-FAST:         .functype shr_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $17, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push33=, $1=, $pop34
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push2=, $pop1, $pop33
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push3=, $2
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push5=, $3
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push7=, $4
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push8=, $pop7, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push9=, $5
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push10=, $pop9, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push11=, $6
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push12=, $pop11, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push13=, $7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push14=, $pop13, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push15=, $8
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push16=, $pop15, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push17=, $9
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push18=, $pop17, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push19=, $10
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push20=, $pop19, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push21=, $11
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push22=, $pop21, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push23=, $12
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push24=, $pop23, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push25=, $13
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push26=, $pop25, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push27=, $14
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push28=, $pop27, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop28
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push29=, $15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push30=, $pop29, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop30
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push31=, $16
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push32=, $pop31, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop32
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <16 x i8> undef, i8 %x, i32 0
  %s = shufflevector <16 x i8> %t, <16 x i8> undef,
    <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0,
                i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = ashr <16 x i8> %v, %s
  ret <16 x i8> %a
}

define <16 x i8> @shr_s_vec_v16i8(<16 x i8> %v, <16 x i8> %x) {
; SIMD128-LABEL: shr_s_vec_v16i8:
; SIMD128:         .functype shr_s_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_s $push7=, $0, 0
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 7
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shr_s $push8=, $pop7, $pop6
; SIMD128-NEXT:    i8x16.splat $push9=, $pop8
; SIMD128-NEXT:    i8x16.extract_lane_s $push3=, $0, 1
; SIMD128-NEXT:    i8x16.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push95=, 7
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop95
; SIMD128-NEXT:    i32.shr_s $push4=, $pop3, $pop2
; SIMD128-NEXT:    i8x16.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i8x16.extract_lane_s $push13=, $0, 2
; SIMD128-NEXT:    i8x16.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push94=, 7
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop94
; SIMD128-NEXT:    i32.shr_s $push14=, $pop13, $pop12
; SIMD128-NEXT:    i8x16.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i8x16.extract_lane_s $push18=, $0, 3
; SIMD128-NEXT:    i8x16.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push93=, 7
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop93
; SIMD128-NEXT:    i32.shr_s $push19=, $pop18, $pop17
; SIMD128-NEXT:    i8x16.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i8x16.extract_lane_s $push23=, $0, 4
; SIMD128-NEXT:    i8x16.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push92=, 7
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop92
; SIMD128-NEXT:    i32.shr_s $push24=, $pop23, $pop22
; SIMD128-NEXT:    i8x16.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i8x16.extract_lane_s $push28=, $0, 5
; SIMD128-NEXT:    i8x16.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push91=, 7
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop91
; SIMD128-NEXT:    i32.shr_s $push29=, $pop28, $pop27
; SIMD128-NEXT:    i8x16.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i8x16.extract_lane_s $push33=, $0, 6
; SIMD128-NEXT:    i8x16.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push90=, 7
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop90
; SIMD128-NEXT:    i32.shr_s $push34=, $pop33, $pop32
; SIMD128-NEXT:    i8x16.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i8x16.extract_lane_s $push38=, $0, 7
; SIMD128-NEXT:    i8x16.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push89=, 7
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop89
; SIMD128-NEXT:    i32.shr_s $push39=, $pop38, $pop37
; SIMD128-NEXT:    i8x16.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    i8x16.extract_lane_s $push43=, $0, 8
; SIMD128-NEXT:    i8x16.extract_lane_u $push41=, $1, 8
; SIMD128-NEXT:    i32.const $push88=, 7
; SIMD128-NEXT:    i32.and $push42=, $pop41, $pop88
; SIMD128-NEXT:    i32.shr_s $push44=, $pop43, $pop42
; SIMD128-NEXT:    i8x16.replace_lane $push45=, $pop40, 8, $pop44
; SIMD128-NEXT:    i8x16.extract_lane_s $push48=, $0, 9
; SIMD128-NEXT:    i8x16.extract_lane_u $push46=, $1, 9
; SIMD128-NEXT:    i32.const $push87=, 7
; SIMD128-NEXT:    i32.and $push47=, $pop46, $pop87
; SIMD128-NEXT:    i32.shr_s $push49=, $pop48, $pop47
; SIMD128-NEXT:    i8x16.replace_lane $push50=, $pop45, 9, $pop49
; SIMD128-NEXT:    i8x16.extract_lane_s $push53=, $0, 10
; SIMD128-NEXT:    i8x16.extract_lane_u $push51=, $1, 10
; SIMD128-NEXT:    i32.const $push86=, 7
; SIMD128-NEXT:    i32.and $push52=, $pop51, $pop86
; SIMD128-NEXT:    i32.shr_s $push54=, $pop53, $pop52
; SIMD128-NEXT:    i8x16.replace_lane $push55=, $pop50, 10, $pop54
; SIMD128-NEXT:    i8x16.extract_lane_s $push58=, $0, 11
; SIMD128-NEXT:    i8x16.extract_lane_u $push56=, $1, 11
; SIMD128-NEXT:    i32.const $push85=, 7
; SIMD128-NEXT:    i32.and $push57=, $pop56, $pop85
; SIMD128-NEXT:    i32.shr_s $push59=, $pop58, $pop57
; SIMD128-NEXT:    i8x16.replace_lane $push60=, $pop55, 11, $pop59
; SIMD128-NEXT:    i8x16.extract_lane_s $push63=, $0, 12
; SIMD128-NEXT:    i8x16.extract_lane_u $push61=, $1, 12
; SIMD128-NEXT:    i32.const $push84=, 7
; SIMD128-NEXT:    i32.and $push62=, $pop61, $pop84
; SIMD128-NEXT:    i32.shr_s $push64=, $pop63, $pop62
; SIMD128-NEXT:    i8x16.replace_lane $push65=, $pop60, 12, $pop64
; SIMD128-NEXT:    i8x16.extract_lane_s $push68=, $0, 13
; SIMD128-NEXT:    i8x16.extract_lane_u $push66=, $1, 13
; SIMD128-NEXT:    i32.const $push83=, 7
; SIMD128-NEXT:    i32.and $push67=, $pop66, $pop83
; SIMD128-NEXT:    i32.shr_s $push69=, $pop68, $pop67
; SIMD128-NEXT:    i8x16.replace_lane $push70=, $pop65, 13, $pop69
; SIMD128-NEXT:    i8x16.extract_lane_s $push73=, $0, 14
; SIMD128-NEXT:    i8x16.extract_lane_u $push71=, $1, 14
; SIMD128-NEXT:    i32.const $push82=, 7
; SIMD128-NEXT:    i32.and $push72=, $pop71, $pop82
; SIMD128-NEXT:    i32.shr_s $push74=, $pop73, $pop72
; SIMD128-NEXT:    i8x16.replace_lane $push75=, $pop70, 14, $pop74
; SIMD128-NEXT:    i8x16.extract_lane_s $push78=, $0, 15
; SIMD128-NEXT:    i8x16.extract_lane_u $push76=, $1, 15
; SIMD128-NEXT:    i32.const $push81=, 7
; SIMD128-NEXT:    i32.and $push77=, $pop76, $pop81
; SIMD128-NEXT:    i32.shr_s $push79=, $pop78, $pop77
; SIMD128-NEXT:    i8x16.replace_lane $push80=, $pop75, 15, $pop79
; SIMD128-NEXT:    return $pop80
;
; SIMD128-FAST-LABEL: shr_s_vec_v16i8:
; SIMD128-FAST:         .functype shr_s_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push8=, $0, 0
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 7
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i8x16.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push4=, $0, 1
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push95=, 7
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop95
; SIMD128-FAST-NEXT:    i32.shr_s $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push14=, $0, 2
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push94=, 7
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop94
; SIMD128-FAST-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push19=, $0, 3
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push93=, 7
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop93
; SIMD128-FAST-NEXT:    i32.shr_s $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push24=, $0, 4
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push92=, 7
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop92
; SIMD128-FAST-NEXT:    i32.shr_s $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push29=, $0, 5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push91=, 7
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop91
; SIMD128-FAST-NEXT:    i32.shr_s $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push34=, $0, 6
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push90=, 7
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop90
; SIMD128-FAST-NEXT:    i32.shr_s $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push39=, $0, 7
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push89=, 7
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop89
; SIMD128-FAST-NEXT:    i32.shr_s $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push41=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push44=, $0, 8
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push42=, $1, 8
; SIMD128-FAST-NEXT:    i32.const $push88=, 7
; SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $pop88
; SIMD128-FAST-NEXT:    i32.shr_s $push45=, $pop44, $pop43
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push46=, $pop41, 8, $pop45
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push49=, $0, 9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push47=, $1, 9
; SIMD128-FAST-NEXT:    i32.const $push87=, 7
; SIMD128-FAST-NEXT:    i32.and $push48=, $pop47, $pop87
; SIMD128-FAST-NEXT:    i32.shr_s $push50=, $pop49, $pop48
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push51=, $pop46, 9, $pop50
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push54=, $0, 10
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push52=, $1, 10
; SIMD128-FAST-NEXT:    i32.const $push86=, 7
; SIMD128-FAST-NEXT:    i32.and $push53=, $pop52, $pop86
; SIMD128-FAST-NEXT:    i32.shr_s $push55=, $pop54, $pop53
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push56=, $pop51, 10, $pop55
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push59=, $0, 11
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push57=, $1, 11
; SIMD128-FAST-NEXT:    i32.const $push85=, 7
; SIMD128-FAST-NEXT:    i32.and $push58=, $pop57, $pop85
; SIMD128-FAST-NEXT:    i32.shr_s $push60=, $pop59, $pop58
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push61=, $pop56, 11, $pop60
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push64=, $0, 12
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push62=, $1, 12
; SIMD128-FAST-NEXT:    i32.const $push84=, 7
; SIMD128-FAST-NEXT:    i32.and $push63=, $pop62, $pop84
; SIMD128-FAST-NEXT:    i32.shr_s $push65=, $pop64, $pop63
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push66=, $pop61, 12, $pop65
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push69=, $0, 13
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push67=, $1, 13
; SIMD128-FAST-NEXT:    i32.const $push83=, 7
; SIMD128-FAST-NEXT:    i32.and $push68=, $pop67, $pop83
; SIMD128-FAST-NEXT:    i32.shr_s $push70=, $pop69, $pop68
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push71=, $pop66, 13, $pop70
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push74=, $0, 14
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push72=, $1, 14
; SIMD128-FAST-NEXT:    i32.const $push82=, 7
; SIMD128-FAST-NEXT:    i32.and $push73=, $pop72, $pop82
; SIMD128-FAST-NEXT:    i32.shr_s $push75=, $pop74, $pop73
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push76=, $pop71, 14, $pop75
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push79=, $0, 15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push77=, $1, 15
; SIMD128-FAST-NEXT:    i32.const $push81=, 7
; SIMD128-FAST-NEXT:    i32.and $push78=, $pop77, $pop81
; SIMD128-FAST-NEXT:    i32.shr_s $push80=, $pop79, $pop78
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push0=, $pop76, 15, $pop80
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_vec_v16i8:
; NO-SIMD128:         .functype shr_s_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push2=, $16
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $32, $pop0
; NO-SIMD128-NEXT:    i32.shr_s $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop3
; NO-SIMD128-NEXT:    i32.extend8_s $push5=, $15
; NO-SIMD128-NEXT:    i32.const $push63=, 255
; NO-SIMD128-NEXT:    i32.and $push4=, $31, $pop63
; NO-SIMD128-NEXT:    i32.shr_s $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop6
; NO-SIMD128-NEXT:    i32.extend8_s $push8=, $14
; NO-SIMD128-NEXT:    i32.const $push62=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $30, $pop62
; NO-SIMD128-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop9
; NO-SIMD128-NEXT:    i32.extend8_s $push11=, $13
; NO-SIMD128-NEXT:    i32.const $push61=, 255
; NO-SIMD128-NEXT:    i32.and $push10=, $29, $pop61
; NO-SIMD128-NEXT:    i32.shr_s $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop12
; NO-SIMD128-NEXT:    i32.extend8_s $push14=, $12
; NO-SIMD128-NEXT:    i32.const $push60=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $28, $pop60
; NO-SIMD128-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop15
; NO-SIMD128-NEXT:    i32.extend8_s $push17=, $11
; NO-SIMD128-NEXT:    i32.const $push59=, 255
; NO-SIMD128-NEXT:    i32.and $push16=, $27, $pop59
; NO-SIMD128-NEXT:    i32.shr_s $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop18
; NO-SIMD128-NEXT:    i32.extend8_s $push20=, $10
; NO-SIMD128-NEXT:    i32.const $push58=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $26, $pop58
; NO-SIMD128-NEXT:    i32.shr_s $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop21
; NO-SIMD128-NEXT:    i32.extend8_s $push23=, $9
; NO-SIMD128-NEXT:    i32.const $push57=, 255
; NO-SIMD128-NEXT:    i32.and $push22=, $25, $pop57
; NO-SIMD128-NEXT:    i32.shr_s $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop24
; NO-SIMD128-NEXT:    i32.extend8_s $push26=, $8
; NO-SIMD128-NEXT:    i32.const $push56=, 255
; NO-SIMD128-NEXT:    i32.and $push25=, $24, $pop56
; NO-SIMD128-NEXT:    i32.shr_s $push27=, $pop26, $pop25
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop27
; NO-SIMD128-NEXT:    i32.extend8_s $push29=, $7
; NO-SIMD128-NEXT:    i32.const $push55=, 255
; NO-SIMD128-NEXT:    i32.and $push28=, $23, $pop55
; NO-SIMD128-NEXT:    i32.shr_s $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop30
; NO-SIMD128-NEXT:    i32.extend8_s $push32=, $6
; NO-SIMD128-NEXT:    i32.const $push54=, 255
; NO-SIMD128-NEXT:    i32.and $push31=, $22, $pop54
; NO-SIMD128-NEXT:    i32.shr_s $push33=, $pop32, $pop31
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop33
; NO-SIMD128-NEXT:    i32.extend8_s $push35=, $5
; NO-SIMD128-NEXT:    i32.const $push53=, 255
; NO-SIMD128-NEXT:    i32.and $push34=, $21, $pop53
; NO-SIMD128-NEXT:    i32.shr_s $push36=, $pop35, $pop34
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop36
; NO-SIMD128-NEXT:    i32.extend8_s $push38=, $4
; NO-SIMD128-NEXT:    i32.const $push52=, 255
; NO-SIMD128-NEXT:    i32.and $push37=, $20, $pop52
; NO-SIMD128-NEXT:    i32.shr_s $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop39
; NO-SIMD128-NEXT:    i32.extend8_s $push41=, $3
; NO-SIMD128-NEXT:    i32.const $push51=, 255
; NO-SIMD128-NEXT:    i32.and $push40=, $19, $pop51
; NO-SIMD128-NEXT:    i32.shr_s $push42=, $pop41, $pop40
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop42
; NO-SIMD128-NEXT:    i32.extend8_s $push44=, $2
; NO-SIMD128-NEXT:    i32.const $push50=, 255
; NO-SIMD128-NEXT:    i32.and $push43=, $18, $pop50
; NO-SIMD128-NEXT:    i32.shr_s $push45=, $pop44, $pop43
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop45
; NO-SIMD128-NEXT:    i32.extend8_s $push47=, $1
; NO-SIMD128-NEXT:    i32.const $push49=, 255
; NO-SIMD128-NEXT:    i32.and $push46=, $17, $pop49
; NO-SIMD128-NEXT:    i32.shr_s $push48=, $pop47, $pop46
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop48
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_vec_v16i8:
; NO-SIMD128-FAST:         .functype shr_s_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push2=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.const $push63=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $18, $pop63
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push8=, $3
; NO-SIMD128-FAST-NEXT:    i32.const $push62=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $19, $pop62
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push11=, $4
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $20, $pop61
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push14=, $5
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $21, $pop60
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push17=, $6
; NO-SIMD128-FAST-NEXT:    i32.const $push59=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $22, $pop59
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push18=, $pop17, $pop16
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push20=, $7
; NO-SIMD128-FAST-NEXT:    i32.const $push58=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $23, $pop58
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push23=, $8
; NO-SIMD128-FAST-NEXT:    i32.const $push57=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $24, $pop57
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push26=, $9
; NO-SIMD128-FAST-NEXT:    i32.const $push56=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $25, $pop56
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push27=, $pop26, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop27
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push29=, $10
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $26, $pop55
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop30
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push32=, $11
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $27, $pop54
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push33=, $pop32, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop33
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push35=, $12
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $28, $pop53
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push36=, $pop35, $pop34
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop36
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push38=, $13
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $29, $pop52
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push39=, $pop38, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop39
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push41=, $14
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push40=, $30, $pop51
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push42=, $pop41, $pop40
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop42
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push44=, $15
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $31, $pop50
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push45=, $pop44, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop45
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push47=, $16
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push46=, $32, $pop49
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push48=, $pop47, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop48
; NO-SIMD128-FAST-NEXT:    return
  %a = ashr <16 x i8> %v, %x
  ret <16 x i8> %a
}

define <16 x i8> @shr_u_v16i8(<16 x i8> %v, i8 %x) {
; SIMD128-LABEL: shr_u_v16i8:
; SIMD128:         .functype shr_u_v16i8 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_u_v16i8:
; SIMD128-FAST:         .functype shr_u_v16i8 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.shr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_v16i8:
; NO-SIMD128:         .functype shr_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop0
; NO-SIMD128-NEXT:    i32.const $push50=, 255
; NO-SIMD128-NEXT:    i32.and $push49=, $17, $pop50
; NO-SIMD128-NEXT:    local.tee $push48=, $17=, $pop49
; NO-SIMD128-NEXT:    i32.shr_u $push2=, $pop1, $pop48
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push47=, 255
; NO-SIMD128-NEXT:    i32.and $push3=, $15, $pop47
; NO-SIMD128-NEXT:    i32.shr_u $push4=, $pop3, $17
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push46=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $14, $pop46
; NO-SIMD128-NEXT:    i32.shr_u $push6=, $pop5, $17
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push45=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $13, $pop45
; NO-SIMD128-NEXT:    i32.shr_u $push8=, $pop7, $17
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push44=, 255
; NO-SIMD128-NEXT:    i32.and $push9=, $12, $pop44
; NO-SIMD128-NEXT:    i32.shr_u $push10=, $pop9, $17
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push43=, 255
; NO-SIMD128-NEXT:    i32.and $push11=, $11, $pop43
; NO-SIMD128-NEXT:    i32.shr_u $push12=, $pop11, $17
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push42=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $10, $pop42
; NO-SIMD128-NEXT:    i32.shr_u $push14=, $pop13, $17
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop14
; NO-SIMD128-NEXT:    i32.const $push41=, 255
; NO-SIMD128-NEXT:    i32.and $push15=, $9, $pop41
; NO-SIMD128-NEXT:    i32.shr_u $push16=, $pop15, $17
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop16
; NO-SIMD128-NEXT:    i32.const $push40=, 255
; NO-SIMD128-NEXT:    i32.and $push17=, $8, $pop40
; NO-SIMD128-NEXT:    i32.shr_u $push18=, $pop17, $17
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop18
; NO-SIMD128-NEXT:    i32.const $push39=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $7, $pop39
; NO-SIMD128-NEXT:    i32.shr_u $push20=, $pop19, $17
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop20
; NO-SIMD128-NEXT:    i32.const $push38=, 255
; NO-SIMD128-NEXT:    i32.and $push21=, $6, $pop38
; NO-SIMD128-NEXT:    i32.shr_u $push22=, $pop21, $17
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop22
; NO-SIMD128-NEXT:    i32.const $push37=, 255
; NO-SIMD128-NEXT:    i32.and $push23=, $5, $pop37
; NO-SIMD128-NEXT:    i32.shr_u $push24=, $pop23, $17
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop24
; NO-SIMD128-NEXT:    i32.const $push36=, 255
; NO-SIMD128-NEXT:    i32.and $push25=, $4, $pop36
; NO-SIMD128-NEXT:    i32.shr_u $push26=, $pop25, $17
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop26
; NO-SIMD128-NEXT:    i32.const $push35=, 255
; NO-SIMD128-NEXT:    i32.and $push27=, $3, $pop35
; NO-SIMD128-NEXT:    i32.shr_u $push28=, $pop27, $17
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop28
; NO-SIMD128-NEXT:    i32.const $push34=, 255
; NO-SIMD128-NEXT:    i32.and $push29=, $2, $pop34
; NO-SIMD128-NEXT:    i32.shr_u $push30=, $pop29, $17
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop30
; NO-SIMD128-NEXT:    i32.const $push33=, 255
; NO-SIMD128-NEXT:    i32.and $push31=, $1, $pop33
; NO-SIMD128-NEXT:    i32.shr_u $push32=, $pop31, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop32
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_v16i8:
; NO-SIMD128-FAST:         .functype shr_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push49=, $17, $pop50
; NO-SIMD128-FAST-NEXT:    local.tee $push48=, $1=, $pop49
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push2=, $pop1, $pop48
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $2, $pop47
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $3, $pop46
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $4, $pop45
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push8=, $pop7, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $5, $pop44
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push10=, $pop9, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $6, $pop43
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push12=, $pop11, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $7, $pop42
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push14=, $pop13, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $8, $pop41
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push16=, $pop15, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $9, $pop40
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push18=, $pop17, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $10, $pop39
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push20=, $pop19, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $11, $pop38
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push22=, $pop21, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $12, $pop37
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push24=, $pop23, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $13, $pop36
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push26=, $pop25, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push27=, $14, $pop35
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push28=, $pop27, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $15, $pop34
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push30=, $pop29, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $16, $pop33
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push32=, $pop31, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop32
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <16 x i8> undef, i8 %x, i32 0
  %s = shufflevector <16 x i8> %t, <16 x i8> undef,
    <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0,
                i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = lshr <16 x i8> %v, %s
  ret <16 x i8> %a
}

define <16 x i8> @shr_u_vec_v16i8(<16 x i8> %v, <16 x i8> %x) {
; SIMD128-LABEL: shr_u_vec_v16i8:
; SIMD128:         .functype shr_u_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_u $push7=, $0, 0
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 7
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shr_u $push8=, $pop7, $pop6
; SIMD128-NEXT:    i8x16.splat $push9=, $pop8
; SIMD128-NEXT:    i8x16.extract_lane_u $push3=, $0, 1
; SIMD128-NEXT:    i8x16.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push95=, 7
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop95
; SIMD128-NEXT:    i32.shr_u $push4=, $pop3, $pop2
; SIMD128-NEXT:    i8x16.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i8x16.extract_lane_u $push13=, $0, 2
; SIMD128-NEXT:    i8x16.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push94=, 7
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop94
; SIMD128-NEXT:    i32.shr_u $push14=, $pop13, $pop12
; SIMD128-NEXT:    i8x16.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i8x16.extract_lane_u $push18=, $0, 3
; SIMD128-NEXT:    i8x16.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push93=, 7
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop93
; SIMD128-NEXT:    i32.shr_u $push19=, $pop18, $pop17
; SIMD128-NEXT:    i8x16.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i8x16.extract_lane_u $push23=, $0, 4
; SIMD128-NEXT:    i8x16.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push92=, 7
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop92
; SIMD128-NEXT:    i32.shr_u $push24=, $pop23, $pop22
; SIMD128-NEXT:    i8x16.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i8x16.extract_lane_u $push28=, $0, 5
; SIMD128-NEXT:    i8x16.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push91=, 7
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop91
; SIMD128-NEXT:    i32.shr_u $push29=, $pop28, $pop27
; SIMD128-NEXT:    i8x16.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i8x16.extract_lane_u $push33=, $0, 6
; SIMD128-NEXT:    i8x16.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push90=, 7
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop90
; SIMD128-NEXT:    i32.shr_u $push34=, $pop33, $pop32
; SIMD128-NEXT:    i8x16.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i8x16.extract_lane_u $push38=, $0, 7
; SIMD128-NEXT:    i8x16.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push89=, 7
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop89
; SIMD128-NEXT:    i32.shr_u $push39=, $pop38, $pop37
; SIMD128-NEXT:    i8x16.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    i8x16.extract_lane_u $push43=, $0, 8
; SIMD128-NEXT:    i8x16.extract_lane_u $push41=, $1, 8
; SIMD128-NEXT:    i32.const $push88=, 7
; SIMD128-NEXT:    i32.and $push42=, $pop41, $pop88
; SIMD128-NEXT:    i32.shr_u $push44=, $pop43, $pop42
; SIMD128-NEXT:    i8x16.replace_lane $push45=, $pop40, 8, $pop44
; SIMD128-NEXT:    i8x16.extract_lane_u $push48=, $0, 9
; SIMD128-NEXT:    i8x16.extract_lane_u $push46=, $1, 9
; SIMD128-NEXT:    i32.const $push87=, 7
; SIMD128-NEXT:    i32.and $push47=, $pop46, $pop87
; SIMD128-NEXT:    i32.shr_u $push49=, $pop48, $pop47
; SIMD128-NEXT:    i8x16.replace_lane $push50=, $pop45, 9, $pop49
; SIMD128-NEXT:    i8x16.extract_lane_u $push53=, $0, 10
; SIMD128-NEXT:    i8x16.extract_lane_u $push51=, $1, 10
; SIMD128-NEXT:    i32.const $push86=, 7
; SIMD128-NEXT:    i32.and $push52=, $pop51, $pop86
; SIMD128-NEXT:    i32.shr_u $push54=, $pop53, $pop52
; SIMD128-NEXT:    i8x16.replace_lane $push55=, $pop50, 10, $pop54
; SIMD128-NEXT:    i8x16.extract_lane_u $push58=, $0, 11
; SIMD128-NEXT:    i8x16.extract_lane_u $push56=, $1, 11
; SIMD128-NEXT:    i32.const $push85=, 7
; SIMD128-NEXT:    i32.and $push57=, $pop56, $pop85
; SIMD128-NEXT:    i32.shr_u $push59=, $pop58, $pop57
; SIMD128-NEXT:    i8x16.replace_lane $push60=, $pop55, 11, $pop59
; SIMD128-NEXT:    i8x16.extract_lane_u $push63=, $0, 12
; SIMD128-NEXT:    i8x16.extract_lane_u $push61=, $1, 12
; SIMD128-NEXT:    i32.const $push84=, 7
; SIMD128-NEXT:    i32.and $push62=, $pop61, $pop84
; SIMD128-NEXT:    i32.shr_u $push64=, $pop63, $pop62
; SIMD128-NEXT:    i8x16.replace_lane $push65=, $pop60, 12, $pop64
; SIMD128-NEXT:    i8x16.extract_lane_u $push68=, $0, 13
; SIMD128-NEXT:    i8x16.extract_lane_u $push66=, $1, 13
; SIMD128-NEXT:    i32.const $push83=, 7
; SIMD128-NEXT:    i32.and $push67=, $pop66, $pop83
; SIMD128-NEXT:    i32.shr_u $push69=, $pop68, $pop67
; SIMD128-NEXT:    i8x16.replace_lane $push70=, $pop65, 13, $pop69
; SIMD128-NEXT:    i8x16.extract_lane_u $push73=, $0, 14
; SIMD128-NEXT:    i8x16.extract_lane_u $push71=, $1, 14
; SIMD128-NEXT:    i32.const $push82=, 7
; SIMD128-NEXT:    i32.and $push72=, $pop71, $pop82
; SIMD128-NEXT:    i32.shr_u $push74=, $pop73, $pop72
; SIMD128-NEXT:    i8x16.replace_lane $push75=, $pop70, 14, $pop74
; SIMD128-NEXT:    i8x16.extract_lane_u $push78=, $0, 15
; SIMD128-NEXT:    i8x16.extract_lane_u $push76=, $1, 15
; SIMD128-NEXT:    i32.const $push81=, 7
; SIMD128-NEXT:    i32.and $push77=, $pop76, $pop81
; SIMD128-NEXT:    i32.shr_u $push79=, $pop78, $pop77
; SIMD128-NEXT:    i8x16.replace_lane $push80=, $pop75, 15, $pop79
; SIMD128-NEXT:    return $pop80
;
; SIMD128-FAST-LABEL: shr_u_vec_v16i8:
; SIMD128-FAST:         .functype shr_u_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push8=, $0, 0
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 7
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i8x16.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push4=, $0, 1
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push95=, 7
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop95
; SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push14=, $0, 2
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push94=, 7
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop94
; SIMD128-FAST-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push19=, $0, 3
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push93=, 7
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop93
; SIMD128-FAST-NEXT:    i32.shr_u $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push24=, $0, 4
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push92=, 7
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop92
; SIMD128-FAST-NEXT:    i32.shr_u $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push29=, $0, 5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push91=, 7
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop91
; SIMD128-FAST-NEXT:    i32.shr_u $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push34=, $0, 6
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push90=, 7
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop90
; SIMD128-FAST-NEXT:    i32.shr_u $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push39=, $0, 7
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push89=, 7
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop89
; SIMD128-FAST-NEXT:    i32.shr_u $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push41=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push44=, $0, 8
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push42=, $1, 8
; SIMD128-FAST-NEXT:    i32.const $push88=, 7
; SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $pop88
; SIMD128-FAST-NEXT:    i32.shr_u $push45=, $pop44, $pop43
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push46=, $pop41, 8, $pop45
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push49=, $0, 9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push47=, $1, 9
; SIMD128-FAST-NEXT:    i32.const $push87=, 7
; SIMD128-FAST-NEXT:    i32.and $push48=, $pop47, $pop87
; SIMD128-FAST-NEXT:    i32.shr_u $push50=, $pop49, $pop48
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push51=, $pop46, 9, $pop50
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push54=, $0, 10
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push52=, $1, 10
; SIMD128-FAST-NEXT:    i32.const $push86=, 7
; SIMD128-FAST-NEXT:    i32.and $push53=, $pop52, $pop86
; SIMD128-FAST-NEXT:    i32.shr_u $push55=, $pop54, $pop53
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push56=, $pop51, 10, $pop55
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push59=, $0, 11
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push57=, $1, 11
; SIMD128-FAST-NEXT:    i32.const $push85=, 7
; SIMD128-FAST-NEXT:    i32.and $push58=, $pop57, $pop85
; SIMD128-FAST-NEXT:    i32.shr_u $push60=, $pop59, $pop58
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push61=, $pop56, 11, $pop60
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push64=, $0, 12
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push62=, $1, 12
; SIMD128-FAST-NEXT:    i32.const $push84=, 7
; SIMD128-FAST-NEXT:    i32.and $push63=, $pop62, $pop84
; SIMD128-FAST-NEXT:    i32.shr_u $push65=, $pop64, $pop63
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push66=, $pop61, 12, $pop65
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push69=, $0, 13
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push67=, $1, 13
; SIMD128-FAST-NEXT:    i32.const $push83=, 7
; SIMD128-FAST-NEXT:    i32.and $push68=, $pop67, $pop83
; SIMD128-FAST-NEXT:    i32.shr_u $push70=, $pop69, $pop68
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push71=, $pop66, 13, $pop70
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push74=, $0, 14
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push72=, $1, 14
; SIMD128-FAST-NEXT:    i32.const $push82=, 7
; SIMD128-FAST-NEXT:    i32.and $push73=, $pop72, $pop82
; SIMD128-FAST-NEXT:    i32.shr_u $push75=, $pop74, $pop73
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push76=, $pop71, 14, $pop75
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push79=, $0, 15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push77=, $1, 15
; SIMD128-FAST-NEXT:    i32.const $push81=, 7
; SIMD128-FAST-NEXT:    i32.and $push78=, $pop77, $pop81
; SIMD128-FAST-NEXT:    i32.shr_u $push80=, $pop79, $pop78
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push0=, $pop76, 15, $pop80
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_vec_v16i8:
; NO-SIMD128:         .functype shr_u_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $16, $pop0
; NO-SIMD128-NEXT:    i32.const $push79=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $32, $pop79
; NO-SIMD128-NEXT:    i32.shr_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push78=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $15, $pop78
; NO-SIMD128-NEXT:    i32.const $push77=, 255
; NO-SIMD128-NEXT:    i32.and $push4=, $31, $pop77
; NO-SIMD128-NEXT:    i32.shr_u $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push76=, 255
; NO-SIMD128-NEXT:    i32.and $push8=, $14, $pop76
; NO-SIMD128-NEXT:    i32.const $push75=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $30, $pop75
; NO-SIMD128-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push74=, 255
; NO-SIMD128-NEXT:    i32.and $push11=, $13, $pop74
; NO-SIMD128-NEXT:    i32.const $push73=, 255
; NO-SIMD128-NEXT:    i32.and $push10=, $29, $pop73
; NO-SIMD128-NEXT:    i32.shr_u $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push72=, 255
; NO-SIMD128-NEXT:    i32.and $push14=, $12, $pop72
; NO-SIMD128-NEXT:    i32.const $push71=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $28, $pop71
; NO-SIMD128-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop15
; NO-SIMD128-NEXT:    i32.const $push70=, 255
; NO-SIMD128-NEXT:    i32.and $push17=, $11, $pop70
; NO-SIMD128-NEXT:    i32.const $push69=, 255
; NO-SIMD128-NEXT:    i32.and $push16=, $27, $pop69
; NO-SIMD128-NEXT:    i32.shr_u $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop18
; NO-SIMD128-NEXT:    i32.const $push68=, 255
; NO-SIMD128-NEXT:    i32.and $push20=, $10, $pop68
; NO-SIMD128-NEXT:    i32.const $push67=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $26, $pop67
; NO-SIMD128-NEXT:    i32.shr_u $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop21
; NO-SIMD128-NEXT:    i32.const $push66=, 255
; NO-SIMD128-NEXT:    i32.and $push23=, $9, $pop66
; NO-SIMD128-NEXT:    i32.const $push65=, 255
; NO-SIMD128-NEXT:    i32.and $push22=, $25, $pop65
; NO-SIMD128-NEXT:    i32.shr_u $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop24
; NO-SIMD128-NEXT:    i32.const $push64=, 255
; NO-SIMD128-NEXT:    i32.and $push26=, $8, $pop64
; NO-SIMD128-NEXT:    i32.const $push63=, 255
; NO-SIMD128-NEXT:    i32.and $push25=, $24, $pop63
; NO-SIMD128-NEXT:    i32.shr_u $push27=, $pop26, $pop25
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop27
; NO-SIMD128-NEXT:    i32.const $push62=, 255
; NO-SIMD128-NEXT:    i32.and $push29=, $7, $pop62
; NO-SIMD128-NEXT:    i32.const $push61=, 255
; NO-SIMD128-NEXT:    i32.and $push28=, $23, $pop61
; NO-SIMD128-NEXT:    i32.shr_u $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop30
; NO-SIMD128-NEXT:    i32.const $push60=, 255
; NO-SIMD128-NEXT:    i32.and $push32=, $6, $pop60
; NO-SIMD128-NEXT:    i32.const $push59=, 255
; NO-SIMD128-NEXT:    i32.and $push31=, $22, $pop59
; NO-SIMD128-NEXT:    i32.shr_u $push33=, $pop32, $pop31
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop33
; NO-SIMD128-NEXT:    i32.const $push58=, 255
; NO-SIMD128-NEXT:    i32.and $push35=, $5, $pop58
; NO-SIMD128-NEXT:    i32.const $push57=, 255
; NO-SIMD128-NEXT:    i32.and $push34=, $21, $pop57
; NO-SIMD128-NEXT:    i32.shr_u $push36=, $pop35, $pop34
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop36
; NO-SIMD128-NEXT:    i32.const $push56=, 255
; NO-SIMD128-NEXT:    i32.and $push38=, $4, $pop56
; NO-SIMD128-NEXT:    i32.const $push55=, 255
; NO-SIMD128-NEXT:    i32.and $push37=, $20, $pop55
; NO-SIMD128-NEXT:    i32.shr_u $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop39
; NO-SIMD128-NEXT:    i32.const $push54=, 255
; NO-SIMD128-NEXT:    i32.and $push41=, $3, $pop54
; NO-SIMD128-NEXT:    i32.const $push53=, 255
; NO-SIMD128-NEXT:    i32.and $push40=, $19, $pop53
; NO-SIMD128-NEXT:    i32.shr_u $push42=, $pop41, $pop40
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop42
; NO-SIMD128-NEXT:    i32.const $push52=, 255
; NO-SIMD128-NEXT:    i32.and $push44=, $2, $pop52
; NO-SIMD128-NEXT:    i32.const $push51=, 255
; NO-SIMD128-NEXT:    i32.and $push43=, $18, $pop51
; NO-SIMD128-NEXT:    i32.shr_u $push45=, $pop44, $pop43
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop45
; NO-SIMD128-NEXT:    i32.const $push50=, 255
; NO-SIMD128-NEXT:    i32.and $push47=, $1, $pop50
; NO-SIMD128-NEXT:    i32.const $push49=, 255
; NO-SIMD128-NEXT:    i32.and $push46=, $17, $pop49
; NO-SIMD128-NEXT:    i32.shr_u $push48=, $pop47, $pop46
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop48
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_vec_v16i8:
; NO-SIMD128-FAST:         .functype shr_u_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop79
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $2, $pop78
; NO-SIMD128-FAST-NEXT:    i32.const $push77=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $18, $pop77
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push76=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $3, $pop76
; NO-SIMD128-FAST-NEXT:    i32.const $push75=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $19, $pop75
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push74=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $4, $pop74
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $20, $pop73
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $5, $pop72
; NO-SIMD128-FAST-NEXT:    i32.const $push71=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $21, $pop71
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.const $push70=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $6, $pop70
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $22, $pop69
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push18=, $pop17, $pop16
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push68=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $7, $pop68
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $23, $pop67
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $8, $pop66
; NO-SIMD128-FAST-NEXT:    i32.const $push65=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $24, $pop65
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push64=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push26=, $9, $pop64
; NO-SIMD128-FAST-NEXT:    i32.const $push63=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $25, $pop63
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push27=, $pop26, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push62=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $10, $pop62
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $26, $pop61
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push32=, $11, $pop60
; NO-SIMD128-FAST-NEXT:    i32.const $push59=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $27, $pop59
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push33=, $pop32, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop33
; NO-SIMD128-FAST-NEXT:    i32.const $push58=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push35=, $12, $pop58
; NO-SIMD128-FAST-NEXT:    i32.const $push57=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $28, $pop57
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push36=, $pop35, $pop34
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push56=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push38=, $13, $pop56
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $29, $pop55
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push39=, $pop38, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop39
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push41=, $14, $pop54
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push40=, $30, $pop53
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push42=, $pop41, $pop40
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push44=, $15, $pop52
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $31, $pop51
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push45=, $pop44, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop45
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push47=, $16, $pop50
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push46=, $32, $pop49
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push48=, $pop47, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop48
; NO-SIMD128-FAST-NEXT:    return
  %a = lshr <16 x i8> %v, %x
  ret <16 x i8> %a
}

define <16 x i8> @and_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: and_v16i8:
; SIMD128:         .functype and_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.and $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: and_v16i8:
; SIMD128-FAST:         .functype and_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: and_v16i8:
; NO-SIMD128:         .functype and_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.and $push0=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop0
; NO-SIMD128-NEXT:    i32.and $push1=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop1
; NO-SIMD128-NEXT:    i32.and $push2=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop2
; NO-SIMD128-NEXT:    i32.and $push3=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop3
; NO-SIMD128-NEXT:    i32.and $push4=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop4
; NO-SIMD128-NEXT:    i32.and $push5=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop5
; NO-SIMD128-NEXT:    i32.and $push6=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop6
; NO-SIMD128-NEXT:    i32.and $push7=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop7
; NO-SIMD128-NEXT:    i32.and $push8=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop8
; NO-SIMD128-NEXT:    i32.and $push9=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop9
; NO-SIMD128-NEXT:    i32.and $push10=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop10
; NO-SIMD128-NEXT:    i32.and $push11=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop11
; NO-SIMD128-NEXT:    i32.and $push12=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop12
; NO-SIMD128-NEXT:    i32.and $push13=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop13
; NO-SIMD128-NEXT:    i32.and $push14=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop14
; NO-SIMD128-NEXT:    i32.and $push15=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop15
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: and_v16i8:
; NO-SIMD128-FAST:         .functype and_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.and $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = and <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @or_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: or_v16i8:
; SIMD128:         .functype or_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.or $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: or_v16i8:
; SIMD128-FAST:         .functype or_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.or $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: or_v16i8:
; NO-SIMD128:         .functype or_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.or $push0=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop0
; NO-SIMD128-NEXT:    i32.or $push1=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop1
; NO-SIMD128-NEXT:    i32.or $push2=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop2
; NO-SIMD128-NEXT:    i32.or $push3=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop3
; NO-SIMD128-NEXT:    i32.or $push4=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop4
; NO-SIMD128-NEXT:    i32.or $push5=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop5
; NO-SIMD128-NEXT:    i32.or $push6=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop6
; NO-SIMD128-NEXT:    i32.or $push7=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop7
; NO-SIMD128-NEXT:    i32.or $push8=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop8
; NO-SIMD128-NEXT:    i32.or $push9=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop9
; NO-SIMD128-NEXT:    i32.or $push10=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop10
; NO-SIMD128-NEXT:    i32.or $push11=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop11
; NO-SIMD128-NEXT:    i32.or $push12=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop12
; NO-SIMD128-NEXT:    i32.or $push13=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop13
; NO-SIMD128-NEXT:    i32.or $push14=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop14
; NO-SIMD128-NEXT:    i32.or $push15=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop15
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: or_v16i8:
; NO-SIMD128-FAST:         .functype or_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.or $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.or $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.or $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.or $push3=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.or $push4=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.or $push5=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.or $push6=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.or $push7=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.or $push8=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.or $push9=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.or $push10=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.or $push11=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.or $push12=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.or $push13=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.or $push14=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.or $push15=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = or <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @xor_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: xor_v16i8:
; SIMD128:         .functype xor_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: xor_v16i8:
; SIMD128-FAST:         .functype xor_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: xor_v16i8:
; NO-SIMD128:         .functype xor_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop0
; NO-SIMD128-NEXT:    i32.xor $push1=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop1
; NO-SIMD128-NEXT:    i32.xor $push2=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop2
; NO-SIMD128-NEXT:    i32.xor $push3=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop3
; NO-SIMD128-NEXT:    i32.xor $push4=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop4
; NO-SIMD128-NEXT:    i32.xor $push5=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop5
; NO-SIMD128-NEXT:    i32.xor $push6=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop6
; NO-SIMD128-NEXT:    i32.xor $push7=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop7
; NO-SIMD128-NEXT:    i32.xor $push8=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop8
; NO-SIMD128-NEXT:    i32.xor $push9=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop9
; NO-SIMD128-NEXT:    i32.xor $push10=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop10
; NO-SIMD128-NEXT:    i32.xor $push11=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop11
; NO-SIMD128-NEXT:    i32.xor $push12=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop12
; NO-SIMD128-NEXT:    i32.xor $push13=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop13
; NO-SIMD128-NEXT:    i32.xor $push14=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop14
; NO-SIMD128-NEXT:    i32.xor $push15=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop15
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: xor_v16i8:
; NO-SIMD128-FAST:         .functype xor_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.xor $push4=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.xor $push7=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @not_v16i8(<16 x i8> %x) {
; SIMD128-LABEL: not_v16i8:
; SIMD128:         .functype not_v16i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.not $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: not_v16i8:
; SIMD128-FAST:         .functype not_v16i8 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: not_v16i8:
; NO-SIMD128:         .functype not_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $16, $pop0
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push31=, -1
; NO-SIMD128-NEXT:    i32.xor $push2=, $15, $pop31
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push30=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $14, $pop30
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push29=, -1
; NO-SIMD128-NEXT:    i32.xor $push4=, $13, $pop29
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push28=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $12, $pop28
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push27=, -1
; NO-SIMD128-NEXT:    i32.xor $push6=, $11, $pop27
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push26=, -1
; NO-SIMD128-NEXT:    i32.xor $push7=, $10, $pop26
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop7
; NO-SIMD128-NEXT:    i32.const $push25=, -1
; NO-SIMD128-NEXT:    i32.xor $push8=, $9, $pop25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push24=, -1
; NO-SIMD128-NEXT:    i32.xor $push9=, $8, $pop24
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push23=, -1
; NO-SIMD128-NEXT:    i32.xor $push10=, $7, $pop23
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push22=, -1
; NO-SIMD128-NEXT:    i32.xor $push11=, $6, $pop22
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop11
; NO-SIMD128-NEXT:    i32.const $push21=, -1
; NO-SIMD128-NEXT:    i32.xor $push12=, $5, $pop21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push20=, -1
; NO-SIMD128-NEXT:    i32.xor $push13=, $4, $pop20
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop13
; NO-SIMD128-NEXT:    i32.const $push19=, -1
; NO-SIMD128-NEXT:    i32.xor $push14=, $3, $pop19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop14
; NO-SIMD128-NEXT:    i32.const $push18=, -1
; NO-SIMD128-NEXT:    i32.xor $push15=, $2, $pop18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop15
; NO-SIMD128-NEXT:    i32.const $push17=, -1
; NO-SIMD128-NEXT:    i32.xor $push16=, $1, $pop17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop16
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: not_v16i8:
; NO-SIMD128-FAST:         .functype not_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $2, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $3, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push4=, $4, $pop29
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $5, $pop28
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $6, $pop27
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push7=, $7, $pop26
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push25=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $8, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push24=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $9, $pop24
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $10, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $11, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $12, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $13, $pop20
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $14, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $15, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $16, $pop17
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <16 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1,
                          i8 -1, i8 -1, i8 -1, i8 -1,
                          i8 -1, i8 -1, i8 -1, i8 -1,
                          i8 -1, i8 -1, i8 -1, i8 -1>
  ret <16 x i8> %a
}

define <16 x i8> @andnot_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: andnot_v16i8:
; SIMD128:         .functype andnot_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.andnot $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: andnot_v16i8:
; SIMD128-FAST:         .functype andnot_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $1
; SIMD128-FAST-NEXT:    v128.and $push1=, $0, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: andnot_v16i8:
; NO-SIMD128:         .functype andnot_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $32, $pop0
; NO-SIMD128-NEXT:    i32.and $push2=, $16, $pop1
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push47=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $31, $pop47
; NO-SIMD128-NEXT:    i32.and $push4=, $15, $pop3
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push46=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $30, $pop46
; NO-SIMD128-NEXT:    i32.and $push6=, $14, $pop5
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push45=, -1
; NO-SIMD128-NEXT:    i32.xor $push7=, $29, $pop45
; NO-SIMD128-NEXT:    i32.and $push8=, $13, $pop7
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push44=, -1
; NO-SIMD128-NEXT:    i32.xor $push9=, $28, $pop44
; NO-SIMD128-NEXT:    i32.and $push10=, $12, $pop9
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push43=, -1
; NO-SIMD128-NEXT:    i32.xor $push11=, $27, $pop43
; NO-SIMD128-NEXT:    i32.and $push12=, $11, $pop11
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push42=, -1
; NO-SIMD128-NEXT:    i32.xor $push13=, $26, $pop42
; NO-SIMD128-NEXT:    i32.and $push14=, $10, $pop13
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop14
; NO-SIMD128-NEXT:    i32.const $push41=, -1
; NO-SIMD128-NEXT:    i32.xor $push15=, $25, $pop41
; NO-SIMD128-NEXT:    i32.and $push16=, $9, $pop15
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop16
; NO-SIMD128-NEXT:    i32.const $push40=, -1
; NO-SIMD128-NEXT:    i32.xor $push17=, $24, $pop40
; NO-SIMD128-NEXT:    i32.and $push18=, $8, $pop17
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop18
; NO-SIMD128-NEXT:    i32.const $push39=, -1
; NO-SIMD128-NEXT:    i32.xor $push19=, $23, $pop39
; NO-SIMD128-NEXT:    i32.and $push20=, $7, $pop19
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop20
; NO-SIMD128-NEXT:    i32.const $push38=, -1
; NO-SIMD128-NEXT:    i32.xor $push21=, $22, $pop38
; NO-SIMD128-NEXT:    i32.and $push22=, $6, $pop21
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop22
; NO-SIMD128-NEXT:    i32.const $push37=, -1
; NO-SIMD128-NEXT:    i32.xor $push23=, $21, $pop37
; NO-SIMD128-NEXT:    i32.and $push24=, $5, $pop23
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop24
; NO-SIMD128-NEXT:    i32.const $push36=, -1
; NO-SIMD128-NEXT:    i32.xor $push25=, $20, $pop36
; NO-SIMD128-NEXT:    i32.and $push26=, $4, $pop25
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop26
; NO-SIMD128-NEXT:    i32.const $push35=, -1
; NO-SIMD128-NEXT:    i32.xor $push27=, $19, $pop35
; NO-SIMD128-NEXT:    i32.and $push28=, $3, $pop27
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop28
; NO-SIMD128-NEXT:    i32.const $push34=, -1
; NO-SIMD128-NEXT:    i32.xor $push29=, $18, $pop34
; NO-SIMD128-NEXT:    i32.and $push30=, $2, $pop29
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop30
; NO-SIMD128-NEXT:    i32.const $push33=, -1
; NO-SIMD128-NEXT:    i32.xor $push31=, $17, $pop33
; NO-SIMD128-NEXT:    i32.and $push32=, $1, $pop31
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop32
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: andnot_v16i8:
; NO-SIMD128-FAST:         .functype andnot_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $17, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $18, $pop47
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $19, $pop46
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $3, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push7=, $20, $pop45
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $4, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $21, $pop44
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $5, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $22, $pop43
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $6, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $23, $pop42
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $7, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $24, $pop41
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $8, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push17=, $25, $pop40
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $9, $pop17
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push19=, $26, $pop39
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $10, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push21=, $27, $pop38
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $11, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $28, $pop37
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $12, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push25=, $29, $pop36
; NO-SIMD128-FAST-NEXT:    i32.and $push26=, $13, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push27=, $30, $pop35
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $14, $pop27
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $31, $pop34
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $15, $pop29
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push31=, $32, $pop33
; NO-SIMD128-FAST-NEXT:    i32.and $push32=, $16, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop32
; NO-SIMD128-FAST-NEXT:    return
 %inv_y = xor <16 x i8> %y,
   <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1,
    i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
 %a = and <16 x i8> %x, %inv_y
 ret <16 x i8> %a
}

define <16 x i8> @bitselect_v16i8(<16 x i8> %c, <16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: bitselect_v16i8:
; SIMD128:         .functype bitselect_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_v16i8:
; SIMD128-FAST:         .functype bitselect_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop2, $2
; SIMD128-FAST-NEXT:    v128.or $push1=, $pop0, $pop3
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: bitselect_v16i8:
; NO-SIMD128:         .functype bitselect_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $32, $48
; NO-SIMD128-NEXT:    i32.and $push1=, $pop0, $16
; NO-SIMD128-NEXT:    i32.xor $push2=, $pop1, $48
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop2
; NO-SIMD128-NEXT:    i32.xor $push3=, $31, $47
; NO-SIMD128-NEXT:    i32.and $push4=, $pop3, $15
; NO-SIMD128-NEXT:    i32.xor $push5=, $pop4, $47
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop5
; NO-SIMD128-NEXT:    i32.xor $push6=, $30, $46
; NO-SIMD128-NEXT:    i32.and $push7=, $pop6, $14
; NO-SIMD128-NEXT:    i32.xor $push8=, $pop7, $46
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop8
; NO-SIMD128-NEXT:    i32.xor $push9=, $29, $45
; NO-SIMD128-NEXT:    i32.and $push10=, $pop9, $13
; NO-SIMD128-NEXT:    i32.xor $push11=, $pop10, $45
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop11
; NO-SIMD128-NEXT:    i32.xor $push12=, $28, $44
; NO-SIMD128-NEXT:    i32.and $push13=, $pop12, $12
; NO-SIMD128-NEXT:    i32.xor $push14=, $pop13, $44
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop14
; NO-SIMD128-NEXT:    i32.xor $push15=, $27, $43
; NO-SIMD128-NEXT:    i32.and $push16=, $pop15, $11
; NO-SIMD128-NEXT:    i32.xor $push17=, $pop16, $43
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop17
; NO-SIMD128-NEXT:    i32.xor $push18=, $26, $42
; NO-SIMD128-NEXT:    i32.and $push19=, $pop18, $10
; NO-SIMD128-NEXT:    i32.xor $push20=, $pop19, $42
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop20
; NO-SIMD128-NEXT:    i32.xor $push21=, $25, $41
; NO-SIMD128-NEXT:    i32.and $push22=, $pop21, $9
; NO-SIMD128-NEXT:    i32.xor $push23=, $pop22, $41
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop23
; NO-SIMD128-NEXT:    i32.xor $push24=, $24, $40
; NO-SIMD128-NEXT:    i32.and $push25=, $pop24, $8
; NO-SIMD128-NEXT:    i32.xor $push26=, $pop25, $40
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop26
; NO-SIMD128-NEXT:    i32.xor $push27=, $23, $39
; NO-SIMD128-NEXT:    i32.and $push28=, $pop27, $7
; NO-SIMD128-NEXT:    i32.xor $push29=, $pop28, $39
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop29
; NO-SIMD128-NEXT:    i32.xor $push30=, $22, $38
; NO-SIMD128-NEXT:    i32.and $push31=, $pop30, $6
; NO-SIMD128-NEXT:    i32.xor $push32=, $pop31, $38
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop32
; NO-SIMD128-NEXT:    i32.xor $push33=, $21, $37
; NO-SIMD128-NEXT:    i32.and $push34=, $pop33, $5
; NO-SIMD128-NEXT:    i32.xor $push35=, $pop34, $37
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop35
; NO-SIMD128-NEXT:    i32.xor $push36=, $20, $36
; NO-SIMD128-NEXT:    i32.and $push37=, $pop36, $4
; NO-SIMD128-NEXT:    i32.xor $push38=, $pop37, $36
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop38
; NO-SIMD128-NEXT:    i32.xor $push39=, $19, $35
; NO-SIMD128-NEXT:    i32.and $push40=, $pop39, $3
; NO-SIMD128-NEXT:    i32.xor $push41=, $pop40, $35
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop41
; NO-SIMD128-NEXT:    i32.xor $push42=, $18, $34
; NO-SIMD128-NEXT:    i32.and $push43=, $pop42, $2
; NO-SIMD128-NEXT:    i32.xor $push44=, $pop43, $34
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop44
; NO-SIMD128-NEXT:    i32.xor $push45=, $17, $33
; NO-SIMD128-NEXT:    i32.and $push46=, $pop45, $1
; NO-SIMD128-NEXT:    i32.xor $push47=, $pop46, $33
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop47
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_v16i8:
; NO-SIMD128-FAST:         .functype bitselect_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $17, $33
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $pop1, $33
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $18, $34
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $pop4, $34
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $19, $35
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $3
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $35
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $20, $36
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $pop9, $4
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $pop10, $36
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $21, $37
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $5
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $pop13, $37
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $22, $38
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $pop15, $6
; NO-SIMD128-FAST-NEXT:    i32.xor $push17=, $pop16, $38
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push18=, $23, $39
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $pop18, $7
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $pop19, $39
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.xor $push21=, $24, $40
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $pop21, $8
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $pop22, $40
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop23
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $25, $41
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $pop24, $9
; NO-SIMD128-FAST-NEXT:    i32.xor $push26=, $pop25, $41
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.xor $push27=, $26, $42
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $10
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $pop28, $42
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop29
; NO-SIMD128-FAST-NEXT:    i32.xor $push30=, $27, $43
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $pop30, $11
; NO-SIMD128-FAST-NEXT:    i32.xor $push32=, $pop31, $43
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop32
; NO-SIMD128-FAST-NEXT:    i32.xor $push33=, $28, $44
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $pop33, $12
; NO-SIMD128-FAST-NEXT:    i32.xor $push35=, $pop34, $44
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop35
; NO-SIMD128-FAST-NEXT:    i32.xor $push36=, $29, $45
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $pop36, $13
; NO-SIMD128-FAST-NEXT:    i32.xor $push38=, $pop37, $45
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop38
; NO-SIMD128-FAST-NEXT:    i32.xor $push39=, $30, $46
; NO-SIMD128-FAST-NEXT:    i32.and $push40=, $pop39, $14
; NO-SIMD128-FAST-NEXT:    i32.xor $push41=, $pop40, $46
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop41
; NO-SIMD128-FAST-NEXT:    i32.xor $push42=, $31, $47
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $15
; NO-SIMD128-FAST-NEXT:    i32.xor $push44=, $pop43, $47
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop44
; NO-SIMD128-FAST-NEXT:    i32.xor $push45=, $32, $48
; NO-SIMD128-FAST-NEXT:    i32.and $push46=, $pop45, $16
; NO-SIMD128-FAST-NEXT:    i32.xor $push47=, $pop46, $48
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop47
; NO-SIMD128-FAST-NEXT:    return
  %masked_v1 = and <16 x i8> %c, %v1
  %inv_mask = xor <16 x i8> %c,
    <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1,
     i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %masked_v2 = and <16 x i8> %inv_mask, %v2
  %a = or <16 x i8> %masked_v1, %masked_v2
  ret <16 x i8> %a
}

define <16 x i8> @bitselect_xor_v16i8(<16 x i8> %c, <16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: bitselect_xor_v16i8:
; SIMD128:         .functype bitselect_xor_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_v16i8:
; SIMD128-FAST:         .functype bitselect_xor_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push2=, $1, $2
; SIMD128-FAST-NEXT:    v128.and $push1=, $pop2, $0
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop1, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_v16i8:
; NO-SIMD128:         .functype bitselect_xor_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $32, $48
; NO-SIMD128-NEXT:    i32.and $push1=, $pop0, $16
; NO-SIMD128-NEXT:    i32.xor $push2=, $pop1, $48
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop2
; NO-SIMD128-NEXT:    i32.xor $push3=, $31, $47
; NO-SIMD128-NEXT:    i32.and $push4=, $pop3, $15
; NO-SIMD128-NEXT:    i32.xor $push5=, $pop4, $47
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop5
; NO-SIMD128-NEXT:    i32.xor $push6=, $30, $46
; NO-SIMD128-NEXT:    i32.and $push7=, $pop6, $14
; NO-SIMD128-NEXT:    i32.xor $push8=, $pop7, $46
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop8
; NO-SIMD128-NEXT:    i32.xor $push9=, $29, $45
; NO-SIMD128-NEXT:    i32.and $push10=, $pop9, $13
; NO-SIMD128-NEXT:    i32.xor $push11=, $pop10, $45
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop11
; NO-SIMD128-NEXT:    i32.xor $push12=, $28, $44
; NO-SIMD128-NEXT:    i32.and $push13=, $pop12, $12
; NO-SIMD128-NEXT:    i32.xor $push14=, $pop13, $44
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop14
; NO-SIMD128-NEXT:    i32.xor $push15=, $27, $43
; NO-SIMD128-NEXT:    i32.and $push16=, $pop15, $11
; NO-SIMD128-NEXT:    i32.xor $push17=, $pop16, $43
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop17
; NO-SIMD128-NEXT:    i32.xor $push18=, $26, $42
; NO-SIMD128-NEXT:    i32.and $push19=, $pop18, $10
; NO-SIMD128-NEXT:    i32.xor $push20=, $pop19, $42
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop20
; NO-SIMD128-NEXT:    i32.xor $push21=, $25, $41
; NO-SIMD128-NEXT:    i32.and $push22=, $pop21, $9
; NO-SIMD128-NEXT:    i32.xor $push23=, $pop22, $41
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop23
; NO-SIMD128-NEXT:    i32.xor $push24=, $24, $40
; NO-SIMD128-NEXT:    i32.and $push25=, $pop24, $8
; NO-SIMD128-NEXT:    i32.xor $push26=, $pop25, $40
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop26
; NO-SIMD128-NEXT:    i32.xor $push27=, $23, $39
; NO-SIMD128-NEXT:    i32.and $push28=, $pop27, $7
; NO-SIMD128-NEXT:    i32.xor $push29=, $pop28, $39
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop29
; NO-SIMD128-NEXT:    i32.xor $push30=, $22, $38
; NO-SIMD128-NEXT:    i32.and $push31=, $pop30, $6
; NO-SIMD128-NEXT:    i32.xor $push32=, $pop31, $38
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop32
; NO-SIMD128-NEXT:    i32.xor $push33=, $21, $37
; NO-SIMD128-NEXT:    i32.and $push34=, $pop33, $5
; NO-SIMD128-NEXT:    i32.xor $push35=, $pop34, $37
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop35
; NO-SIMD128-NEXT:    i32.xor $push36=, $20, $36
; NO-SIMD128-NEXT:    i32.and $push37=, $pop36, $4
; NO-SIMD128-NEXT:    i32.xor $push38=, $pop37, $36
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop38
; NO-SIMD128-NEXT:    i32.xor $push39=, $19, $35
; NO-SIMD128-NEXT:    i32.and $push40=, $pop39, $3
; NO-SIMD128-NEXT:    i32.xor $push41=, $pop40, $35
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop41
; NO-SIMD128-NEXT:    i32.xor $push42=, $18, $34
; NO-SIMD128-NEXT:    i32.and $push43=, $pop42, $2
; NO-SIMD128-NEXT:    i32.xor $push44=, $pop43, $34
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop44
; NO-SIMD128-NEXT:    i32.xor $push45=, $17, $33
; NO-SIMD128-NEXT:    i32.and $push46=, $pop45, $1
; NO-SIMD128-NEXT:    i32.xor $push47=, $pop46, $33
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop47
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_v16i8:
; NO-SIMD128-FAST:         .functype bitselect_xor_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $17, $33
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $pop1, $33
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $18, $34
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $pop4, $34
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $19, $35
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $3
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $35
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $20, $36
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $pop9, $4
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $pop10, $36
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $21, $37
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $5
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $pop13, $37
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $22, $38
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $pop15, $6
; NO-SIMD128-FAST-NEXT:    i32.xor $push17=, $pop16, $38
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push18=, $23, $39
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $pop18, $7
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $pop19, $39
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.xor $push21=, $24, $40
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $pop21, $8
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $pop22, $40
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop23
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $25, $41
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $pop24, $9
; NO-SIMD128-FAST-NEXT:    i32.xor $push26=, $pop25, $41
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.xor $push27=, $26, $42
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $10
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $pop28, $42
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop29
; NO-SIMD128-FAST-NEXT:    i32.xor $push30=, $27, $43
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $pop30, $11
; NO-SIMD128-FAST-NEXT:    i32.xor $push32=, $pop31, $43
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop32
; NO-SIMD128-FAST-NEXT:    i32.xor $push33=, $28, $44
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $pop33, $12
; NO-SIMD128-FAST-NEXT:    i32.xor $push35=, $pop34, $44
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop35
; NO-SIMD128-FAST-NEXT:    i32.xor $push36=, $29, $45
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $pop36, $13
; NO-SIMD128-FAST-NEXT:    i32.xor $push38=, $pop37, $45
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop38
; NO-SIMD128-FAST-NEXT:    i32.xor $push39=, $30, $46
; NO-SIMD128-FAST-NEXT:    i32.and $push40=, $pop39, $14
; NO-SIMD128-FAST-NEXT:    i32.xor $push41=, $pop40, $46
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop41
; NO-SIMD128-FAST-NEXT:    i32.xor $push42=, $31, $47
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $15
; NO-SIMD128-FAST-NEXT:    i32.xor $push44=, $pop43, $47
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop44
; NO-SIMD128-FAST-NEXT:    i32.xor $push45=, $32, $48
; NO-SIMD128-FAST-NEXT:    i32.and $push46=, $pop45, $16
; NO-SIMD128-FAST-NEXT:    i32.xor $push47=, $pop46, $48
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop47
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <16 x i8> %v1, %v2
 %and = and <16 x i8> %xor1, %c
 %a = xor <16 x i8> %and, %v2
 ret <16 x i8> %a
}

define <16 x i8> @bitselect_xor_reversed_v16i8(<16 x i8> %c, <16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: bitselect_xor_reversed_v16i8:
; SIMD128:         .functype bitselect_xor_reversed_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $2, $1, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_reversed_v16i8:
; SIMD128-FAST:         .functype bitselect_xor_reversed_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push1=, $1, $2
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop1, $pop2
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop3, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_reversed_v16i8:
; NO-SIMD128:         .functype bitselect_xor_reversed_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push2=, $32, $48
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $16, $pop0
; NO-SIMD128-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.xor $push4=, $pop3, $48
; NO-SIMD128-NEXT:    i32.store8 15($0), $pop4
; NO-SIMD128-NEXT:    i32.xor $push6=, $31, $47
; NO-SIMD128-NEXT:    i32.const $push79=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $15, $pop79
; NO-SIMD128-NEXT:    i32.and $push7=, $pop6, $pop5
; NO-SIMD128-NEXT:    i32.xor $push8=, $pop7, $47
; NO-SIMD128-NEXT:    i32.store8 14($0), $pop8
; NO-SIMD128-NEXT:    i32.xor $push10=, $30, $46
; NO-SIMD128-NEXT:    i32.const $push78=, -1
; NO-SIMD128-NEXT:    i32.xor $push9=, $14, $pop78
; NO-SIMD128-NEXT:    i32.and $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.xor $push12=, $pop11, $46
; NO-SIMD128-NEXT:    i32.store8 13($0), $pop12
; NO-SIMD128-NEXT:    i32.xor $push14=, $29, $45
; NO-SIMD128-NEXT:    i32.const $push77=, -1
; NO-SIMD128-NEXT:    i32.xor $push13=, $13, $pop77
; NO-SIMD128-NEXT:    i32.and $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.xor $push16=, $pop15, $45
; NO-SIMD128-NEXT:    i32.store8 12($0), $pop16
; NO-SIMD128-NEXT:    i32.xor $push18=, $28, $44
; NO-SIMD128-NEXT:    i32.const $push76=, -1
; NO-SIMD128-NEXT:    i32.xor $push17=, $12, $pop76
; NO-SIMD128-NEXT:    i32.and $push19=, $pop18, $pop17
; NO-SIMD128-NEXT:    i32.xor $push20=, $pop19, $44
; NO-SIMD128-NEXT:    i32.store8 11($0), $pop20
; NO-SIMD128-NEXT:    i32.xor $push22=, $27, $43
; NO-SIMD128-NEXT:    i32.const $push75=, -1
; NO-SIMD128-NEXT:    i32.xor $push21=, $11, $pop75
; NO-SIMD128-NEXT:    i32.and $push23=, $pop22, $pop21
; NO-SIMD128-NEXT:    i32.xor $push24=, $pop23, $43
; NO-SIMD128-NEXT:    i32.store8 10($0), $pop24
; NO-SIMD128-NEXT:    i32.xor $push26=, $26, $42
; NO-SIMD128-NEXT:    i32.const $push74=, -1
; NO-SIMD128-NEXT:    i32.xor $push25=, $10, $pop74
; NO-SIMD128-NEXT:    i32.and $push27=, $pop26, $pop25
; NO-SIMD128-NEXT:    i32.xor $push28=, $pop27, $42
; NO-SIMD128-NEXT:    i32.store8 9($0), $pop28
; NO-SIMD128-NEXT:    i32.xor $push30=, $25, $41
; NO-SIMD128-NEXT:    i32.const $push73=, -1
; NO-SIMD128-NEXT:    i32.xor $push29=, $9, $pop73
; NO-SIMD128-NEXT:    i32.and $push31=, $pop30, $pop29
; NO-SIMD128-NEXT:    i32.xor $push32=, $pop31, $41
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop32
; NO-SIMD128-NEXT:    i32.xor $push34=, $24, $40
; NO-SIMD128-NEXT:    i32.const $push72=, -1
; NO-SIMD128-NEXT:    i32.xor $push33=, $8, $pop72
; NO-SIMD128-NEXT:    i32.and $push35=, $pop34, $pop33
; NO-SIMD128-NEXT:    i32.xor $push36=, $pop35, $40
; NO-SIMD128-NEXT:    i32.store8 7($0), $pop36
; NO-SIMD128-NEXT:    i32.xor $push38=, $23, $39
; NO-SIMD128-NEXT:    i32.const $push71=, -1
; NO-SIMD128-NEXT:    i32.xor $push37=, $7, $pop71
; NO-SIMD128-NEXT:    i32.and $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.xor $push40=, $pop39, $39
; NO-SIMD128-NEXT:    i32.store8 6($0), $pop40
; NO-SIMD128-NEXT:    i32.xor $push42=, $22, $38
; NO-SIMD128-NEXT:    i32.const $push70=, -1
; NO-SIMD128-NEXT:    i32.xor $push41=, $6, $pop70
; NO-SIMD128-NEXT:    i32.and $push43=, $pop42, $pop41
; NO-SIMD128-NEXT:    i32.xor $push44=, $pop43, $38
; NO-SIMD128-NEXT:    i32.store8 5($0), $pop44
; NO-SIMD128-NEXT:    i32.xor $push46=, $21, $37
; NO-SIMD128-NEXT:    i32.const $push69=, -1
; NO-SIMD128-NEXT:    i32.xor $push45=, $5, $pop69
; NO-SIMD128-NEXT:    i32.and $push47=, $pop46, $pop45
; NO-SIMD128-NEXT:    i32.xor $push48=, $pop47, $37
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop48
; NO-SIMD128-NEXT:    i32.xor $push50=, $20, $36
; NO-SIMD128-NEXT:    i32.const $push68=, -1
; NO-SIMD128-NEXT:    i32.xor $push49=, $4, $pop68
; NO-SIMD128-NEXT:    i32.and $push51=, $pop50, $pop49
; NO-SIMD128-NEXT:    i32.xor $push52=, $pop51, $36
; NO-SIMD128-NEXT:    i32.store8 3($0), $pop52
; NO-SIMD128-NEXT:    i32.xor $push54=, $19, $35
; NO-SIMD128-NEXT:    i32.const $push67=, -1
; NO-SIMD128-NEXT:    i32.xor $push53=, $3, $pop67
; NO-SIMD128-NEXT:    i32.and $push55=, $pop54, $pop53
; NO-SIMD128-NEXT:    i32.xor $push56=, $pop55, $35
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop56
; NO-SIMD128-NEXT:    i32.xor $push58=, $18, $34
; NO-SIMD128-NEXT:    i32.const $push66=, -1
; NO-SIMD128-NEXT:    i32.xor $push57=, $2, $pop66
; NO-SIMD128-NEXT:    i32.and $push59=, $pop58, $pop57
; NO-SIMD128-NEXT:    i32.xor $push60=, $pop59, $34
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop60
; NO-SIMD128-NEXT:    i32.xor $push62=, $17, $33
; NO-SIMD128-NEXT:    i32.const $push65=, -1
; NO-SIMD128-NEXT:    i32.xor $push61=, $1, $pop65
; NO-SIMD128-NEXT:    i32.and $push63=, $pop62, $pop61
; NO-SIMD128-NEXT:    i32.xor $push64=, $pop63, $33
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop64
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_reversed_v16i8:
; NO-SIMD128-FAST:         .functype bitselect_xor_reversed_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $17, $33
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push4=, $pop3, $33
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $18, $34
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $2, $pop79
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $34
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $19, $35
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $3, $pop78
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $pop11, $35
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $20, $36
; NO-SIMD128-FAST-NEXT:    i32.const $push77=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $4, $pop77
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $pop15, $36
; NO-SIMD128-FAST-NEXT:    i32.store8 3($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.xor $push18=, $21, $37
; NO-SIMD128-FAST-NEXT:    i32.const $push76=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push17=, $5, $pop76
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $pop18, $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $pop19, $37
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.xor $push22=, $22, $38
; NO-SIMD128-FAST-NEXT:    i32.const $push75=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push21=, $6, $pop75
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop21
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $pop23, $38
; NO-SIMD128-FAST-NEXT:    i32.store8 5($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.xor $push26=, $23, $39
; NO-SIMD128-FAST-NEXT:    i32.const $push74=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push25=, $7, $pop74
; NO-SIMD128-FAST-NEXT:    i32.and $push27=, $pop26, $pop25
; NO-SIMD128-FAST-NEXT:    i32.xor $push28=, $pop27, $39
; NO-SIMD128-FAST-NEXT:    i32.store8 6($0), $pop28
; NO-SIMD128-FAST-NEXT:    i32.xor $push30=, $24, $40
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $8, $pop73
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.xor $push32=, $pop31, $40
; NO-SIMD128-FAST-NEXT:    i32.store8 7($0), $pop32
; NO-SIMD128-FAST-NEXT:    i32.xor $push34=, $25, $41
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push33=, $9, $pop72
; NO-SIMD128-FAST-NEXT:    i32.and $push35=, $pop34, $pop33
; NO-SIMD128-FAST-NEXT:    i32.xor $push36=, $pop35, $41
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop36
; NO-SIMD128-FAST-NEXT:    i32.xor $push38=, $26, $42
; NO-SIMD128-FAST-NEXT:    i32.const $push71=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push37=, $10, $pop71
; NO-SIMD128-FAST-NEXT:    i32.and $push39=, $pop38, $pop37
; NO-SIMD128-FAST-NEXT:    i32.xor $push40=, $pop39, $42
; NO-SIMD128-FAST-NEXT:    i32.store8 9($0), $pop40
; NO-SIMD128-FAST-NEXT:    i32.xor $push42=, $27, $43
; NO-SIMD128-FAST-NEXT:    i32.const $push70=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push41=, $11, $pop70
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $pop41
; NO-SIMD128-FAST-NEXT:    i32.xor $push44=, $pop43, $43
; NO-SIMD128-FAST-NEXT:    i32.store8 10($0), $pop44
; NO-SIMD128-FAST-NEXT:    i32.xor $push46=, $28, $44
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push45=, $12, $pop69
; NO-SIMD128-FAST-NEXT:    i32.and $push47=, $pop46, $pop45
; NO-SIMD128-FAST-NEXT:    i32.xor $push48=, $pop47, $44
; NO-SIMD128-FAST-NEXT:    i32.store8 11($0), $pop48
; NO-SIMD128-FAST-NEXT:    i32.xor $push50=, $29, $45
; NO-SIMD128-FAST-NEXT:    i32.const $push68=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push49=, $13, $pop68
; NO-SIMD128-FAST-NEXT:    i32.and $push51=, $pop50, $pop49
; NO-SIMD128-FAST-NEXT:    i32.xor $push52=, $pop51, $45
; NO-SIMD128-FAST-NEXT:    i32.store8 12($0), $pop52
; NO-SIMD128-FAST-NEXT:    i32.xor $push54=, $30, $46
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push53=, $14, $pop67
; NO-SIMD128-FAST-NEXT:    i32.and $push55=, $pop54, $pop53
; NO-SIMD128-FAST-NEXT:    i32.xor $push56=, $pop55, $46
; NO-SIMD128-FAST-NEXT:    i32.store8 13($0), $pop56
; NO-SIMD128-FAST-NEXT:    i32.xor $push58=, $31, $47
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push57=, $15, $pop66
; NO-SIMD128-FAST-NEXT:    i32.and $push59=, $pop58, $pop57
; NO-SIMD128-FAST-NEXT:    i32.xor $push60=, $pop59, $47
; NO-SIMD128-FAST-NEXT:    i32.store8 14($0), $pop60
; NO-SIMD128-FAST-NEXT:    i32.xor $push62=, $32, $48
; NO-SIMD128-FAST-NEXT:    i32.const $push65=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push61=, $16, $pop65
; NO-SIMD128-FAST-NEXT:    i32.and $push63=, $pop62, $pop61
; NO-SIMD128-FAST-NEXT:    i32.xor $push64=, $pop63, $48
; NO-SIMD128-FAST-NEXT:    i32.store8 15($0), $pop64
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <16 x i8> %v1, %v2
 %notc = xor <16 x i8> %c, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1,
                            i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
 %and = and <16 x i8> %xor1, %notc
 %a = xor <16 x i8> %and, %v2
 ret <16 x i8> %a
}

; ==============================================================================
; 8 x i16
; ==============================================================================
define <8 x i16> @add_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: add_v8i16:
; SIMD128:         .functype add_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v8i16:
; SIMD128-FAST:         .functype add_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v8i16:
; NO-SIMD128:         .functype add_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.add $push0=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop0
; NO-SIMD128-NEXT:    i32.add $push1=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop1
; NO-SIMD128-NEXT:    i32.add $push2=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop2
; NO-SIMD128-NEXT:    i32.add $push3=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop3
; NO-SIMD128-NEXT:    i32.add $push4=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop4
; NO-SIMD128-NEXT:    i32.add $push5=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop5
; NO-SIMD128-NEXT:    i32.add $push6=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-NEXT:    i32.add $push7=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v8i16:
; NO-SIMD128-FAST:         .functype add_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.add $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.add $push3=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.add $push7=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %a = add <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @sub_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: sub_v8i16:
; SIMD128:         .functype sub_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v8i16:
; SIMD128-FAST:         .functype sub_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v8i16:
; NO-SIMD128:         .functype sub_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.sub $push0=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop0
; NO-SIMD128-NEXT:    i32.sub $push1=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop1
; NO-SIMD128-NEXT:    i32.sub $push2=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop2
; NO-SIMD128-NEXT:    i32.sub $push3=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop3
; NO-SIMD128-NEXT:    i32.sub $push4=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop4
; NO-SIMD128-NEXT:    i32.sub $push5=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop5
; NO-SIMD128-NEXT:    i32.sub $push6=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-NEXT:    i32.sub $push7=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v8i16:
; NO-SIMD128-FAST:         .functype sub_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.sub $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.sub $push4=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.sub $push5=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.sub $push7=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @mul_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: mul_v8i16:
; SIMD128:         .functype mul_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.mul $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: mul_v8i16:
; SIMD128-FAST:         .functype mul_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.mul $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v8i16:
; NO-SIMD128:         .functype mul_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.mul $push0=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop0
; NO-SIMD128-NEXT:    i32.mul $push1=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop1
; NO-SIMD128-NEXT:    i32.mul $push2=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop2
; NO-SIMD128-NEXT:    i32.mul $push3=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop3
; NO-SIMD128-NEXT:    i32.mul $push4=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop4
; NO-SIMD128-NEXT:    i32.mul $push5=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop5
; NO-SIMD128-NEXT:    i32.mul $push6=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-NEXT:    i32.mul $push7=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v8i16:
; NO-SIMD128-FAST:         .functype mul_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.mul $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.mul $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.mul $push3=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.mul $push4=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.mul $push7=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %a = mul <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @min_s_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: min_s_v8i16:
; SIMD128:         .functype min_s_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.min_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_s_v8i16:
; SIMD128-FAST:         .functype min_s_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.min_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_s_v8i16:
; NO-SIMD128:         .functype min_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push1=, $8
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $16
; NO-SIMD128-NEXT:    i32.lt_s $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $8, $16, $pop2
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop3
; NO-SIMD128-NEXT:    i32.extend16_s $push5=, $7
; NO-SIMD128-NEXT:    i32.extend16_s $push4=, $15
; NO-SIMD128-NEXT:    i32.lt_s $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.select $push7=, $7, $15, $pop6
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop7
; NO-SIMD128-NEXT:    i32.extend16_s $push9=, $6
; NO-SIMD128-NEXT:    i32.extend16_s $push8=, $14
; NO-SIMD128-NEXT:    i32.lt_s $push10=, $pop9, $pop8
; NO-SIMD128-NEXT:    i32.select $push11=, $6, $14, $pop10
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop11
; NO-SIMD128-NEXT:    i32.extend16_s $push13=, $5
; NO-SIMD128-NEXT:    i32.extend16_s $push12=, $13
; NO-SIMD128-NEXT:    i32.lt_s $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.select $push15=, $5, $13, $pop14
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop15
; NO-SIMD128-NEXT:    i32.extend16_s $push17=, $4
; NO-SIMD128-NEXT:    i32.extend16_s $push16=, $12
; NO-SIMD128-NEXT:    i32.lt_s $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.select $push19=, $4, $12, $pop18
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop19
; NO-SIMD128-NEXT:    i32.extend16_s $push21=, $3
; NO-SIMD128-NEXT:    i32.extend16_s $push20=, $11
; NO-SIMD128-NEXT:    i32.lt_s $push22=, $pop21, $pop20
; NO-SIMD128-NEXT:    i32.select $push23=, $3, $11, $pop22
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop23
; NO-SIMD128-NEXT:    i32.extend16_s $push25=, $2
; NO-SIMD128-NEXT:    i32.extend16_s $push24=, $10
; NO-SIMD128-NEXT:    i32.lt_s $push26=, $pop25, $pop24
; NO-SIMD128-NEXT:    i32.select $push27=, $2, $10, $pop26
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop27
; NO-SIMD128-NEXT:    i32.extend16_s $push29=, $1
; NO-SIMD128-NEXT:    i32.extend16_s $push28=, $9
; NO-SIMD128-NEXT:    i32.lt_s $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.select $push31=, $1, $9, $pop30
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop31
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_s_v8i16:
; NO-SIMD128-FAST:         .functype min_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push0=, $9
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $1, $9, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push4=, $10
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $2, $10, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push9=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push8=, $11
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $3, $11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push13=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push12=, $12
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $4, $12, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push17=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push16=, $13
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push18=, $pop17, $pop16
; NO-SIMD128-FAST-NEXT:    i32.select $push19=, $5, $13, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop19
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push21=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push20=, $14
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push22=, $pop21, $pop20
; NO-SIMD128-FAST-NEXT:    i32.select $push23=, $6, $14, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop23
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push25=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push24=, $15
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push26=, $pop25, $pop24
; NO-SIMD128-FAST-NEXT:    i32.select $push27=, $7, $15, $pop26
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop27
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push29=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push28=, $16
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.select $push31=, $8, $16, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop31
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp slt <8 x i16> %x, %y
  %a = select <8 x i1> %c, <8 x i16> %x, <8 x i16> %y
  ret <8 x i16> %a
}

define <8 x i16> @min_u_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: min_u_v8i16:
; SIMD128:         .functype min_u_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.min_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_u_v8i16:
; SIMD128-FAST:         .functype min_u_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.min_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_u_v8i16:
; NO-SIMD128:         .functype min_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push2=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push47=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop47
; NO-SIMD128-NEXT:    i32.lt_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.select $push4=, $8, $16, $pop3
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push46=, 65535
; NO-SIMD128-NEXT:    i32.and $push6=, $7, $pop46
; NO-SIMD128-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $15, $pop45
; NO-SIMD128-NEXT:    i32.lt_u $push7=, $pop6, $pop5
; NO-SIMD128-NEXT:    i32.select $push8=, $7, $15, $pop7
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-NEXT:    i32.and $push10=, $6, $pop44
; NO-SIMD128-NEXT:    i32.const $push43=, 65535
; NO-SIMD128-NEXT:    i32.and $push9=, $14, $pop43
; NO-SIMD128-NEXT:    i32.lt_u $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.select $push12=, $6, $14, $pop11
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push42=, 65535
; NO-SIMD128-NEXT:    i32.and $push14=, $5, $pop42
; NO-SIMD128-NEXT:    i32.const $push41=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $13, $pop41
; NO-SIMD128-NEXT:    i32.lt_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.select $push16=, $5, $13, $pop15
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop16
; NO-SIMD128-NEXT:    i32.const $push40=, 65535
; NO-SIMD128-NEXT:    i32.and $push18=, $4, $pop40
; NO-SIMD128-NEXT:    i32.const $push39=, 65535
; NO-SIMD128-NEXT:    i32.and $push17=, $12, $pop39
; NO-SIMD128-NEXT:    i32.lt_u $push19=, $pop18, $pop17
; NO-SIMD128-NEXT:    i32.select $push20=, $4, $12, $pop19
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop20
; NO-SIMD128-NEXT:    i32.const $push38=, 65535
; NO-SIMD128-NEXT:    i32.and $push22=, $3, $pop38
; NO-SIMD128-NEXT:    i32.const $push37=, 65535
; NO-SIMD128-NEXT:    i32.and $push21=, $11, $pop37
; NO-SIMD128-NEXT:    i32.lt_u $push23=, $pop22, $pop21
; NO-SIMD128-NEXT:    i32.select $push24=, $3, $11, $pop23
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop24
; NO-SIMD128-NEXT:    i32.const $push36=, 65535
; NO-SIMD128-NEXT:    i32.and $push26=, $2, $pop36
; NO-SIMD128-NEXT:    i32.const $push35=, 65535
; NO-SIMD128-NEXT:    i32.and $push25=, $10, $pop35
; NO-SIMD128-NEXT:    i32.lt_u $push27=, $pop26, $pop25
; NO-SIMD128-NEXT:    i32.select $push28=, $2, $10, $pop27
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop28
; NO-SIMD128-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-NEXT:    i32.and $push30=, $1, $pop34
; NO-SIMD128-NEXT:    i32.const $push33=, 65535
; NO-SIMD128-NEXT:    i32.and $push29=, $9, $pop33
; NO-SIMD128-NEXT:    i32.lt_u $push31=, $pop30, $pop29
; NO-SIMD128-NEXT:    i32.select $push32=, $1, $9, $pop31
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop32
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_u_v8i16:
; NO-SIMD128-FAST:         .functype min_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop47
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.select $push4=, $1, $9, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $2, $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $10, $pop45
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.select $push8=, $2, $10, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $3, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $11, $pop43
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.select $push12=, $3, $11, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $4, $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $12, $pop41
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.select $push16=, $4, $12, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $5, $pop40
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $13, $pop39
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push19=, $pop18, $pop17
; NO-SIMD128-FAST-NEXT:    i32.select $push20=, $5, $13, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $6, $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $14, $pop37
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push23=, $pop22, $pop21
; NO-SIMD128-FAST-NEXT:    i32.select $push24=, $6, $14, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push26=, $7, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $15, $pop35
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push27=, $pop26, $pop25
; NO-SIMD128-FAST-NEXT:    i32.select $push28=, $7, $15, $pop27
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $8, $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $16, $pop33
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.select $push32=, $8, $16, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop32
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ult <8 x i16> %x, %y
  %a = select <8 x i1> %c, <8 x i16> %x, <8 x i16> %y
  ret <8 x i16> %a
}

define <8 x i16> @max_s_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: max_s_v8i16:
; SIMD128:         .functype max_s_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.max_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_s_v8i16:
; SIMD128-FAST:         .functype max_s_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.max_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_s_v8i16:
; NO-SIMD128:         .functype max_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push1=, $8
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $16
; NO-SIMD128-NEXT:    i32.gt_s $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $8, $16, $pop2
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop3
; NO-SIMD128-NEXT:    i32.extend16_s $push5=, $7
; NO-SIMD128-NEXT:    i32.extend16_s $push4=, $15
; NO-SIMD128-NEXT:    i32.gt_s $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.select $push7=, $7, $15, $pop6
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop7
; NO-SIMD128-NEXT:    i32.extend16_s $push9=, $6
; NO-SIMD128-NEXT:    i32.extend16_s $push8=, $14
; NO-SIMD128-NEXT:    i32.gt_s $push10=, $pop9, $pop8
; NO-SIMD128-NEXT:    i32.select $push11=, $6, $14, $pop10
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop11
; NO-SIMD128-NEXT:    i32.extend16_s $push13=, $5
; NO-SIMD128-NEXT:    i32.extend16_s $push12=, $13
; NO-SIMD128-NEXT:    i32.gt_s $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.select $push15=, $5, $13, $pop14
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop15
; NO-SIMD128-NEXT:    i32.extend16_s $push17=, $4
; NO-SIMD128-NEXT:    i32.extend16_s $push16=, $12
; NO-SIMD128-NEXT:    i32.gt_s $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.select $push19=, $4, $12, $pop18
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop19
; NO-SIMD128-NEXT:    i32.extend16_s $push21=, $3
; NO-SIMD128-NEXT:    i32.extend16_s $push20=, $11
; NO-SIMD128-NEXT:    i32.gt_s $push22=, $pop21, $pop20
; NO-SIMD128-NEXT:    i32.select $push23=, $3, $11, $pop22
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop23
; NO-SIMD128-NEXT:    i32.extend16_s $push25=, $2
; NO-SIMD128-NEXT:    i32.extend16_s $push24=, $10
; NO-SIMD128-NEXT:    i32.gt_s $push26=, $pop25, $pop24
; NO-SIMD128-NEXT:    i32.select $push27=, $2, $10, $pop26
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop27
; NO-SIMD128-NEXT:    i32.extend16_s $push29=, $1
; NO-SIMD128-NEXT:    i32.extend16_s $push28=, $9
; NO-SIMD128-NEXT:    i32.gt_s $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.select $push31=, $1, $9, $pop30
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop31
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_s_v8i16:
; NO-SIMD128-FAST:         .functype max_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push0=, $9
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $1, $9, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push4=, $10
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $2, $10, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push9=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push8=, $11
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $3, $11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push13=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push12=, $12
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $4, $12, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push17=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push16=, $13
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push18=, $pop17, $pop16
; NO-SIMD128-FAST-NEXT:    i32.select $push19=, $5, $13, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop19
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push21=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push20=, $14
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push22=, $pop21, $pop20
; NO-SIMD128-FAST-NEXT:    i32.select $push23=, $6, $14, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop23
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push25=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push24=, $15
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push26=, $pop25, $pop24
; NO-SIMD128-FAST-NEXT:    i32.select $push27=, $7, $15, $pop26
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop27
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push29=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push28=, $16
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.select $push31=, $8, $16, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop31
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp sgt <8 x i16> %x, %y
  %a = select <8 x i1> %c, <8 x i16> %x, <8 x i16> %y
  ret <8 x i16> %a
}

define <8 x i16> @max_u_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: max_u_v8i16:
; SIMD128:         .functype max_u_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.max_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_u_v8i16:
; SIMD128-FAST:         .functype max_u_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.max_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_u_v8i16:
; NO-SIMD128:         .functype max_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push2=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push47=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop47
; NO-SIMD128-NEXT:    i32.gt_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.select $push4=, $8, $16, $pop3
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push46=, 65535
; NO-SIMD128-NEXT:    i32.and $push6=, $7, $pop46
; NO-SIMD128-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $15, $pop45
; NO-SIMD128-NEXT:    i32.gt_u $push7=, $pop6, $pop5
; NO-SIMD128-NEXT:    i32.select $push8=, $7, $15, $pop7
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-NEXT:    i32.and $push10=, $6, $pop44
; NO-SIMD128-NEXT:    i32.const $push43=, 65535
; NO-SIMD128-NEXT:    i32.and $push9=, $14, $pop43
; NO-SIMD128-NEXT:    i32.gt_u $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.select $push12=, $6, $14, $pop11
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push42=, 65535
; NO-SIMD128-NEXT:    i32.and $push14=, $5, $pop42
; NO-SIMD128-NEXT:    i32.const $push41=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $13, $pop41
; NO-SIMD128-NEXT:    i32.gt_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.select $push16=, $5, $13, $pop15
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop16
; NO-SIMD128-NEXT:    i32.const $push40=, 65535
; NO-SIMD128-NEXT:    i32.and $push18=, $4, $pop40
; NO-SIMD128-NEXT:    i32.const $push39=, 65535
; NO-SIMD128-NEXT:    i32.and $push17=, $12, $pop39
; NO-SIMD128-NEXT:    i32.gt_u $push19=, $pop18, $pop17
; NO-SIMD128-NEXT:    i32.select $push20=, $4, $12, $pop19
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop20
; NO-SIMD128-NEXT:    i32.const $push38=, 65535
; NO-SIMD128-NEXT:    i32.and $push22=, $3, $pop38
; NO-SIMD128-NEXT:    i32.const $push37=, 65535
; NO-SIMD128-NEXT:    i32.and $push21=, $11, $pop37
; NO-SIMD128-NEXT:    i32.gt_u $push23=, $pop22, $pop21
; NO-SIMD128-NEXT:    i32.select $push24=, $3, $11, $pop23
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop24
; NO-SIMD128-NEXT:    i32.const $push36=, 65535
; NO-SIMD128-NEXT:    i32.and $push26=, $2, $pop36
; NO-SIMD128-NEXT:    i32.const $push35=, 65535
; NO-SIMD128-NEXT:    i32.and $push25=, $10, $pop35
; NO-SIMD128-NEXT:    i32.gt_u $push27=, $pop26, $pop25
; NO-SIMD128-NEXT:    i32.select $push28=, $2, $10, $pop27
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop28
; NO-SIMD128-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-NEXT:    i32.and $push30=, $1, $pop34
; NO-SIMD128-NEXT:    i32.const $push33=, 65535
; NO-SIMD128-NEXT:    i32.and $push29=, $9, $pop33
; NO-SIMD128-NEXT:    i32.gt_u $push31=, $pop30, $pop29
; NO-SIMD128-NEXT:    i32.select $push32=, $1, $9, $pop31
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop32
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_u_v8i16:
; NO-SIMD128-FAST:         .functype max_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop47
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.select $push4=, $1, $9, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $2, $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $10, $pop45
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.select $push8=, $2, $10, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $3, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $11, $pop43
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.select $push12=, $3, $11, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $4, $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $12, $pop41
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.select $push16=, $4, $12, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $5, $pop40
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $13, $pop39
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push19=, $pop18, $pop17
; NO-SIMD128-FAST-NEXT:    i32.select $push20=, $5, $13, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $6, $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $14, $pop37
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push23=, $pop22, $pop21
; NO-SIMD128-FAST-NEXT:    i32.select $push24=, $6, $14, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push26=, $7, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $15, $pop35
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push27=, $pop26, $pop25
; NO-SIMD128-FAST-NEXT:    i32.select $push28=, $7, $15, $pop27
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $8, $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $16, $pop33
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.select $push32=, $8, $16, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop32
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ugt <8 x i16> %x, %y
  %a = select <8 x i1> %c, <8 x i16> %x, <8 x i16> %y
  ret <8 x i16> %a
}

define <8 x i16> @avgr_u_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: avgr_u_v8i16:
; SIMD128:         .functype avgr_u_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.avgr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: avgr_u_v8i16:
; SIMD128-FAST:         .functype avgr_u_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.avgr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: avgr_u_v8i16:
; NO-SIMD128:         .functype avgr_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.add $push0=, $8, $16
; NO-SIMD128-NEXT:    i32.const $push1=, 1
; NO-SIMD128-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-NEXT:    i32.const $push3=, 65534
; NO-SIMD128-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-NEXT:    i32.const $push55=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push5=, $pop4, $pop55
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop5
; NO-SIMD128-NEXT:    i32.add $push6=, $7, $15
; NO-SIMD128-NEXT:    i32.const $push54=, 1
; NO-SIMD128-NEXT:    i32.add $push7=, $pop6, $pop54
; NO-SIMD128-NEXT:    i32.const $push53=, 65534
; NO-SIMD128-NEXT:    i32.and $push8=, $pop7, $pop53
; NO-SIMD128-NEXT:    i32.const $push52=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push9=, $pop8, $pop52
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop9
; NO-SIMD128-NEXT:    i32.add $push10=, $6, $14
; NO-SIMD128-NEXT:    i32.const $push51=, 1
; NO-SIMD128-NEXT:    i32.add $push11=, $pop10, $pop51
; NO-SIMD128-NEXT:    i32.const $push50=, 65534
; NO-SIMD128-NEXT:    i32.and $push12=, $pop11, $pop50
; NO-SIMD128-NEXT:    i32.const $push49=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push13=, $pop12, $pop49
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop13
; NO-SIMD128-NEXT:    i32.add $push14=, $5, $13
; NO-SIMD128-NEXT:    i32.const $push48=, 1
; NO-SIMD128-NEXT:    i32.add $push15=, $pop14, $pop48
; NO-SIMD128-NEXT:    i32.const $push47=, 65534
; NO-SIMD128-NEXT:    i32.and $push16=, $pop15, $pop47
; NO-SIMD128-NEXT:    i32.const $push46=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push17=, $pop16, $pop46
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop17
; NO-SIMD128-NEXT:    i32.add $push18=, $4, $12
; NO-SIMD128-NEXT:    i32.const $push45=, 1
; NO-SIMD128-NEXT:    i32.add $push19=, $pop18, $pop45
; NO-SIMD128-NEXT:    i32.const $push44=, 65534
; NO-SIMD128-NEXT:    i32.and $push20=, $pop19, $pop44
; NO-SIMD128-NEXT:    i32.const $push43=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push21=, $pop20, $pop43
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop21
; NO-SIMD128-NEXT:    i32.add $push22=, $3, $11
; NO-SIMD128-NEXT:    i32.const $push42=, 1
; NO-SIMD128-NEXT:    i32.add $push23=, $pop22, $pop42
; NO-SIMD128-NEXT:    i32.const $push41=, 65534
; NO-SIMD128-NEXT:    i32.and $push24=, $pop23, $pop41
; NO-SIMD128-NEXT:    i32.const $push40=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push25=, $pop24, $pop40
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop25
; NO-SIMD128-NEXT:    i32.add $push26=, $2, $10
; NO-SIMD128-NEXT:    i32.const $push39=, 1
; NO-SIMD128-NEXT:    i32.add $push27=, $pop26, $pop39
; NO-SIMD128-NEXT:    i32.const $push38=, 65534
; NO-SIMD128-NEXT:    i32.and $push28=, $pop27, $pop38
; NO-SIMD128-NEXT:    i32.const $push37=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push29=, $pop28, $pop37
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop29
; NO-SIMD128-NEXT:    i32.add $push30=, $1, $9
; NO-SIMD128-NEXT:    i32.const $push36=, 1
; NO-SIMD128-NEXT:    i32.add $push31=, $pop30, $pop36
; NO-SIMD128-NEXT:    i32.const $push35=, 65534
; NO-SIMD128-NEXT:    i32.and $push32=, $pop31, $pop35
; NO-SIMD128-NEXT:    i32.const $push34=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push33=, $pop32, $pop34
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop33
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: avgr_u_v8i16:
; NO-SIMD128-FAST:         .functype avgr_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop55
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push7=, $pop6, $pop54
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $pop7, $pop53
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop52
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $pop10, $pop51
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $pop11, $pop50
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push13=, $pop12, $pop49
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $pop14, $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $pop15, $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push17=, $pop16, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $pop18, $pop45
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $pop19, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push21=, $pop20, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push23=, $pop22, $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $pop23, $pop41
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push25=, $pop24, $pop40
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop25
; NO-SIMD128-FAST-NEXT:    i32.add $push26=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $pop26, $pop39
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push29=, $pop28, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop29
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $pop30, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push32=, $pop31, $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push33=, $pop32, $pop34
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop33
; NO-SIMD128-FAST-NEXT:    return
  %a = add nuw <8 x i16> %x, %y
  %b = add nuw <8 x i16> %a, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %c = udiv <8 x i16> %b, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  ret <8 x i16> %c
}

define <8 x i16> @avgr_u_v8i16_wrap(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: avgr_u_v8i16_wrap:
; SIMD128:         .functype avgr_u_v8i16_wrap (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.add $push0=, $0, $1
; SIMD128-NEXT:    v128.const $push1=, 1, 1, 1, 1, 1, 1, 1, 1
; SIMD128-NEXT:    i16x8.add $push2=, $pop0, $pop1
; SIMD128-NEXT:    i32.const $push3=, 1
; SIMD128-NEXT:    i16x8.shr_u $push4=, $pop2, $pop3
; SIMD128-NEXT:    return $pop4
;
; SIMD128-FAST-LABEL: avgr_u_v8i16_wrap:
; SIMD128-FAST:         .functype avgr_u_v8i16_wrap (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.add $push2=, $0, $1
; SIMD128-FAST-NEXT:    v128.const $push3=, 1, 1, 1, 1, 1, 1, 1, 1
; SIMD128-FAST-NEXT:    i16x8.add $push1=, $pop2, $pop3
; SIMD128-FAST-NEXT:    i32.const $push4=, 1
; SIMD128-FAST-NEXT:    i16x8.shr_u $push0=, $pop1, $pop4
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: avgr_u_v8i16_wrap:
; NO-SIMD128:         .functype avgr_u_v8i16_wrap (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.add $push0=, $8, $16
; NO-SIMD128-NEXT:    i32.const $push1=, 1
; NO-SIMD128-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-NEXT:    i32.const $push3=, 65534
; NO-SIMD128-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-NEXT:    i32.const $push55=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push5=, $pop4, $pop55
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop5
; NO-SIMD128-NEXT:    i32.add $push6=, $7, $15
; NO-SIMD128-NEXT:    i32.const $push54=, 1
; NO-SIMD128-NEXT:    i32.add $push7=, $pop6, $pop54
; NO-SIMD128-NEXT:    i32.const $push53=, 65534
; NO-SIMD128-NEXT:    i32.and $push8=, $pop7, $pop53
; NO-SIMD128-NEXT:    i32.const $push52=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push9=, $pop8, $pop52
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop9
; NO-SIMD128-NEXT:    i32.add $push10=, $6, $14
; NO-SIMD128-NEXT:    i32.const $push51=, 1
; NO-SIMD128-NEXT:    i32.add $push11=, $pop10, $pop51
; NO-SIMD128-NEXT:    i32.const $push50=, 65534
; NO-SIMD128-NEXT:    i32.and $push12=, $pop11, $pop50
; NO-SIMD128-NEXT:    i32.const $push49=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push13=, $pop12, $pop49
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop13
; NO-SIMD128-NEXT:    i32.add $push14=, $5, $13
; NO-SIMD128-NEXT:    i32.const $push48=, 1
; NO-SIMD128-NEXT:    i32.add $push15=, $pop14, $pop48
; NO-SIMD128-NEXT:    i32.const $push47=, 65534
; NO-SIMD128-NEXT:    i32.and $push16=, $pop15, $pop47
; NO-SIMD128-NEXT:    i32.const $push46=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push17=, $pop16, $pop46
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop17
; NO-SIMD128-NEXT:    i32.add $push18=, $4, $12
; NO-SIMD128-NEXT:    i32.const $push45=, 1
; NO-SIMD128-NEXT:    i32.add $push19=, $pop18, $pop45
; NO-SIMD128-NEXT:    i32.const $push44=, 65534
; NO-SIMD128-NEXT:    i32.and $push20=, $pop19, $pop44
; NO-SIMD128-NEXT:    i32.const $push43=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push21=, $pop20, $pop43
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop21
; NO-SIMD128-NEXT:    i32.add $push22=, $3, $11
; NO-SIMD128-NEXT:    i32.const $push42=, 1
; NO-SIMD128-NEXT:    i32.add $push23=, $pop22, $pop42
; NO-SIMD128-NEXT:    i32.const $push41=, 65534
; NO-SIMD128-NEXT:    i32.and $push24=, $pop23, $pop41
; NO-SIMD128-NEXT:    i32.const $push40=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push25=, $pop24, $pop40
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop25
; NO-SIMD128-NEXT:    i32.add $push26=, $2, $10
; NO-SIMD128-NEXT:    i32.const $push39=, 1
; NO-SIMD128-NEXT:    i32.add $push27=, $pop26, $pop39
; NO-SIMD128-NEXT:    i32.const $push38=, 65534
; NO-SIMD128-NEXT:    i32.and $push28=, $pop27, $pop38
; NO-SIMD128-NEXT:    i32.const $push37=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push29=, $pop28, $pop37
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop29
; NO-SIMD128-NEXT:    i32.add $push30=, $1, $9
; NO-SIMD128-NEXT:    i32.const $push36=, 1
; NO-SIMD128-NEXT:    i32.add $push31=, $pop30, $pop36
; NO-SIMD128-NEXT:    i32.const $push35=, 65534
; NO-SIMD128-NEXT:    i32.and $push32=, $pop31, $pop35
; NO-SIMD128-NEXT:    i32.const $push34=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push33=, $pop32, $pop34
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop33
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: avgr_u_v8i16_wrap:
; NO-SIMD128-FAST:         .functype avgr_u_v8i16_wrap (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop55
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push7=, $pop6, $pop54
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $pop7, $pop53
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop52
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $pop10, $pop51
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $pop11, $pop50
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push13=, $pop12, $pop49
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $pop14, $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $pop15, $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push17=, $pop16, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $pop18, $pop45
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $pop19, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push21=, $pop20, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push23=, $pop22, $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $pop23, $pop41
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push25=, $pop24, $pop40
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop25
; NO-SIMD128-FAST-NEXT:    i32.add $push26=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $pop26, $pop39
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push29=, $pop28, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop29
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $pop30, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push32=, $pop31, $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push33=, $pop32, $pop34
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop33
; NO-SIMD128-FAST-NEXT:    return
  %a = add <8 x i16> %x, %y
  %b = add <8 x i16> %a, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %c = udiv <8 x i16> %b, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  ret <8 x i16> %c
}

define <8 x i16> @abs_v8i16(<8 x i16> %x) {
; SIMD128-LABEL: abs_v8i16:
; SIMD128:         .functype abs_v8i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v8i16:
; SIMD128-FAST:         .functype abs_v8i16 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v8i16:
; NO-SIMD128:         .functype abs_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $8
; NO-SIMD128-NEXT:    i32.const $push1=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push47=, $pop0, $pop1
; NO-SIMD128-NEXT:    local.tee $push46=, $9=, $pop47
; NO-SIMD128-NEXT:    i32.xor $push2=, $8, $pop46
; NO-SIMD128-NEXT:    i32.sub $push3=, $pop2, $9
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop3
; NO-SIMD128-NEXT:    i32.extend16_s $push4=, $7
; NO-SIMD128-NEXT:    i32.const $push45=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push44=, $pop4, $pop45
; NO-SIMD128-NEXT:    local.tee $push43=, $8=, $pop44
; NO-SIMD128-NEXT:    i32.xor $push5=, $7, $pop43
; NO-SIMD128-NEXT:    i32.sub $push6=, $pop5, $8
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop6
; NO-SIMD128-NEXT:    i32.extend16_s $push7=, $6
; NO-SIMD128-NEXT:    i32.const $push42=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push41=, $pop7, $pop42
; NO-SIMD128-NEXT:    local.tee $push40=, $8=, $pop41
; NO-SIMD128-NEXT:    i32.xor $push8=, $6, $pop40
; NO-SIMD128-NEXT:    i32.sub $push9=, $pop8, $8
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop9
; NO-SIMD128-NEXT:    i32.extend16_s $push10=, $5
; NO-SIMD128-NEXT:    i32.const $push39=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push38=, $pop10, $pop39
; NO-SIMD128-NEXT:    local.tee $push37=, $8=, $pop38
; NO-SIMD128-NEXT:    i32.xor $push11=, $5, $pop37
; NO-SIMD128-NEXT:    i32.sub $push12=, $pop11, $8
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop12
; NO-SIMD128-NEXT:    i32.extend16_s $push13=, $4
; NO-SIMD128-NEXT:    i32.const $push36=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push35=, $pop13, $pop36
; NO-SIMD128-NEXT:    local.tee $push34=, $8=, $pop35
; NO-SIMD128-NEXT:    i32.xor $push14=, $4, $pop34
; NO-SIMD128-NEXT:    i32.sub $push15=, $pop14, $8
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop15
; NO-SIMD128-NEXT:    i32.extend16_s $push16=, $3
; NO-SIMD128-NEXT:    i32.const $push33=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push32=, $pop16, $pop33
; NO-SIMD128-NEXT:    local.tee $push31=, $8=, $pop32
; NO-SIMD128-NEXT:    i32.xor $push17=, $3, $pop31
; NO-SIMD128-NEXT:    i32.sub $push18=, $pop17, $8
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop18
; NO-SIMD128-NEXT:    i32.extend16_s $push19=, $2
; NO-SIMD128-NEXT:    i32.const $push30=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push29=, $pop19, $pop30
; NO-SIMD128-NEXT:    local.tee $push28=, $8=, $pop29
; NO-SIMD128-NEXT:    i32.xor $push20=, $2, $pop28
; NO-SIMD128-NEXT:    i32.sub $push21=, $pop20, $8
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop21
; NO-SIMD128-NEXT:    i32.extend16_s $push22=, $1
; NO-SIMD128-NEXT:    i32.const $push27=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push26=, $pop22, $pop27
; NO-SIMD128-NEXT:    local.tee $push25=, $8=, $pop26
; NO-SIMD128-NEXT:    i32.xor $push23=, $1, $pop25
; NO-SIMD128-NEXT:    i32.sub $push24=, $pop23, $8
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop24
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v8i16:
; NO-SIMD128-FAST:         .functype abs_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push0=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push47=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    local.tee $push46=, $9=, $pop47
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $1, $pop46
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $pop2, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push4=, $2
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push44=, $pop4, $pop45
; NO-SIMD128-FAST-NEXT:    local.tee $push43=, $1=, $pop44
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $2, $pop43
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push7=, $3
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push41=, $pop7, $pop42
; NO-SIMD128-FAST-NEXT:    local.tee $push40=, $2=, $pop41
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $3, $pop40
; NO-SIMD128-FAST-NEXT:    i32.sub $push9=, $pop8, $2
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push10=, $4
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push38=, $pop10, $pop39
; NO-SIMD128-FAST-NEXT:    local.tee $push37=, $3=, $pop38
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $4, $pop37
; NO-SIMD128-FAST-NEXT:    i32.sub $push12=, $pop11, $3
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push13=, $5
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push35=, $pop13, $pop36
; NO-SIMD128-FAST-NEXT:    local.tee $push34=, $4=, $pop35
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $5, $pop34
; NO-SIMD128-FAST-NEXT:    i32.sub $push15=, $pop14, $4
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push16=, $6
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push32=, $pop16, $pop33
; NO-SIMD128-FAST-NEXT:    local.tee $push31=, $5=, $pop32
; NO-SIMD128-FAST-NEXT:    i32.xor $push17=, $6, $pop31
; NO-SIMD128-FAST-NEXT:    i32.sub $push18=, $pop17, $5
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push19=, $7
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push29=, $pop19, $pop30
; NO-SIMD128-FAST-NEXT:    local.tee $push28=, $6=, $pop29
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $7, $pop28
; NO-SIMD128-FAST-NEXT:    i32.sub $push21=, $pop20, $6
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push22=, $8
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push26=, $pop22, $pop27
; NO-SIMD128-FAST-NEXT:    local.tee $push25=, $7=, $pop26
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $8, $pop25
; NO-SIMD128-FAST-NEXT:    i32.sub $push24=, $pop23, $7
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop24
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <8 x i16> zeroinitializer, %x
  %b = icmp slt <8 x i16> %x, zeroinitializer
  %c = select <8 x i1> %b, <8 x i16> %a, <8 x i16> %x
  ret <8 x i16> %c
}

define <8 x i16> @neg_v8i16(<8 x i16> %x) {
; SIMD128-LABEL: neg_v8i16:
; SIMD128:         .functype neg_v8i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v8i16:
; SIMD128-FAST:         .functype neg_v8i16 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v8i16:
; NO-SIMD128:         .functype neg_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 0
; NO-SIMD128-NEXT:    i32.sub $push1=, $pop0, $8
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push15=, 0
; NO-SIMD128-NEXT:    i32.sub $push2=, $pop15, $7
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push14=, 0
; NO-SIMD128-NEXT:    i32.sub $push3=, $pop14, $6
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push13=, 0
; NO-SIMD128-NEXT:    i32.sub $push4=, $pop13, $5
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push12=, 0
; NO-SIMD128-NEXT:    i32.sub $push5=, $pop12, $4
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push11=, 0
; NO-SIMD128-NEXT:    i32.sub $push6=, $pop11, $3
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push10=, 0
; NO-SIMD128-NEXT:    i32.sub $push7=, $pop10, $2
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop7
; NO-SIMD128-NEXT:    i32.const $push9=, 0
; NO-SIMD128-NEXT:    i32.sub $push8=, $pop9, $1
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v8i16:
; NO-SIMD128-FAST:         .functype neg_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push15=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $pop15, $2
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $pop14, $3
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push4=, $pop13, $4
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push12=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push5=, $pop12, $5
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $pop11, $6
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push7=, $pop10, $7
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push8=, $pop9, $8
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <8 x i16> <i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0>,
                     %x
  ret <8 x i16> %a
}

define <8 x i16> @shl_v8i16(<8 x i16> %v, i16 %x) {
; SIMD128-LABEL: shl_v8i16:
; SIMD128:         .functype shl_v8i16 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.shl $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shl_v8i16:
; SIMD128-FAST:         .functype shl_v8i16 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.shl $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_v8i16:
; NO-SIMD128:         .functype shl_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push10=, $9, $pop0
; NO-SIMD128-NEXT:    local.tee $push9=, $9=, $pop10
; NO-SIMD128-NEXT:    i32.shl $push1=, $8, $pop9
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop1
; NO-SIMD128-NEXT:    i32.shl $push2=, $7, $9
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop2
; NO-SIMD128-NEXT:    i32.shl $push3=, $6, $9
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop3
; NO-SIMD128-NEXT:    i32.shl $push4=, $5, $9
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop4
; NO-SIMD128-NEXT:    i32.shl $push5=, $4, $9
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop5
; NO-SIMD128-NEXT:    i32.shl $push6=, $3, $9
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-NEXT:    i32.shl $push7=, $2, $9
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop7
; NO-SIMD128-NEXT:    i32.shl $push8=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_v8i16:
; NO-SIMD128-FAST:         .functype shl_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push9=, $9=, $pop10
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $2, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $3, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.shl $push4=, $4, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.shl $push5=, $5, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $6, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.shl $push7=, $7, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.shl $push8=, $8, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <8 x i16> undef, i16 %x, i32 0
  %s = shufflevector <8 x i16> %t, <8 x i16> undef,
    <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = shl <8 x i16> %v, %s
  ret <8 x i16> %a
}

define <8 x i16> @shl_const_v8i16(<8 x i16> %v) {
; SIMD128-LABEL: shl_const_v8i16:
; SIMD128:         .functype shl_const_v8i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i16x8.shl $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shl_const_v8i16:
; SIMD128-FAST:         .functype shl_const_v8i16 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i16x8.shl $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_const_v8i16:
; NO-SIMD128:         .functype shl_const_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 5
; NO-SIMD128-NEXT:    i32.shl $push1=, $8, $pop0
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push15=, 5
; NO-SIMD128-NEXT:    i32.shl $push2=, $7, $pop15
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push14=, 5
; NO-SIMD128-NEXT:    i32.shl $push3=, $6, $pop14
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push13=, 5
; NO-SIMD128-NEXT:    i32.shl $push4=, $5, $pop13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push12=, 5
; NO-SIMD128-NEXT:    i32.shl $push5=, $4, $pop12
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push11=, 5
; NO-SIMD128-NEXT:    i32.shl $push6=, $3, $pop11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push10=, 5
; NO-SIMD128-NEXT:    i32.shl $push7=, $2, $pop10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop7
; NO-SIMD128-NEXT:    i32.const $push9=, 5
; NO-SIMD128-NEXT:    i32.shl $push8=, $1, $pop9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_const_v8i16:
; NO-SIMD128-FAST:         .functype shl_const_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push15=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $2, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $3, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push4=, $4, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push12=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push5=, $5, $pop12
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $6, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push7=, $7, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push8=, $8, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <8 x i16> %v,
    <i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5>
  ret <8 x i16> %a
}

define <8 x i16> @shl_vec_v8i16(<8 x i16> %v, <8 x i16> %x) {
; SIMD128-LABEL: shl_vec_v8i16:
; SIMD128:         .functype shl_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_u $push7=, $0, 0
; SIMD128-NEXT:    i16x8.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 15
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shl $push8=, $pop7, $pop6
; SIMD128-NEXT:    i16x8.splat $push9=, $pop8
; SIMD128-NEXT:    i16x8.extract_lane_u $push3=, $0, 1
; SIMD128-NEXT:    i16x8.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push47=, 15
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop47
; SIMD128-NEXT:    i32.shl $push4=, $pop3, $pop2
; SIMD128-NEXT:    i16x8.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i16x8.extract_lane_u $push13=, $0, 2
; SIMD128-NEXT:    i16x8.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push46=, 15
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop46
; SIMD128-NEXT:    i32.shl $push14=, $pop13, $pop12
; SIMD128-NEXT:    i16x8.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i16x8.extract_lane_u $push18=, $0, 3
; SIMD128-NEXT:    i16x8.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push45=, 15
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop45
; SIMD128-NEXT:    i32.shl $push19=, $pop18, $pop17
; SIMD128-NEXT:    i16x8.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i16x8.extract_lane_u $push23=, $0, 4
; SIMD128-NEXT:    i16x8.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push44=, 15
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop44
; SIMD128-NEXT:    i32.shl $push24=, $pop23, $pop22
; SIMD128-NEXT:    i16x8.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i16x8.extract_lane_u $push28=, $0, 5
; SIMD128-NEXT:    i16x8.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push43=, 15
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop43
; SIMD128-NEXT:    i32.shl $push29=, $pop28, $pop27
; SIMD128-NEXT:    i16x8.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i16x8.extract_lane_u $push33=, $0, 6
; SIMD128-NEXT:    i16x8.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push42=, 15
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop42
; SIMD128-NEXT:    i32.shl $push34=, $pop33, $pop32
; SIMD128-NEXT:    i16x8.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i16x8.extract_lane_u $push38=, $0, 7
; SIMD128-NEXT:    i16x8.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push41=, 15
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop41
; SIMD128-NEXT:    i32.shl $push39=, $pop38, $pop37
; SIMD128-NEXT:    i16x8.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    return $pop40
;
; SIMD128-FAST-LABEL: shl_vec_v8i16:
; SIMD128-FAST:         .functype shl_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push8=, $0, 0
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 15
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shl $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i16x8.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push4=, $0, 1
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push47=, 15
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop47
; SIMD128-FAST-NEXT:    i32.shl $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push14=, $0, 2
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push46=, 15
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop46
; SIMD128-FAST-NEXT:    i32.shl $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push19=, $0, 3
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push45=, 15
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop45
; SIMD128-FAST-NEXT:    i32.shl $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push24=, $0, 4
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push44=, 15
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop44
; SIMD128-FAST-NEXT:    i32.shl $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push29=, $0, 5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push43=, 15
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop43
; SIMD128-FAST-NEXT:    i32.shl $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push34=, $0, 6
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push42=, 15
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop42
; SIMD128-FAST-NEXT:    i32.shl $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push39=, $0, 7
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push41=, 15
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop41
; SIMD128-FAST-NEXT:    i32.shl $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push0=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_vec_v8i16:
; NO-SIMD128:         .functype shl_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop0
; NO-SIMD128-NEXT:    i32.shl $push2=, $8, $pop1
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push23=, 65535
; NO-SIMD128-NEXT:    i32.and $push3=, $15, $pop23
; NO-SIMD128-NEXT:    i32.shl $push4=, $7, $pop3
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push22=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $14, $pop22
; NO-SIMD128-NEXT:    i32.shl $push6=, $6, $pop5
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push21=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $13, $pop21
; NO-SIMD128-NEXT:    i32.shl $push8=, $5, $pop7
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push20=, 65535
; NO-SIMD128-NEXT:    i32.and $push9=, $12, $pop20
; NO-SIMD128-NEXT:    i32.shl $push10=, $4, $pop9
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-NEXT:    i32.and $push11=, $11, $pop19
; NO-SIMD128-NEXT:    i32.shl $push12=, $3, $pop11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $10, $pop18
; NO-SIMD128-NEXT:    i32.shl $push14=, $2, $pop13
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop14
; NO-SIMD128-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-NEXT:    i32.and $push15=, $9, $pop17
; NO-SIMD128-NEXT:    i32.shl $push16=, $1, $pop15
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop16
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_vec_v8i16:
; NO-SIMD128-FAST:         .functype shl_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $10, $pop23
; NO-SIMD128-FAST-NEXT:    i32.shl $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $11, $pop22
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $3, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $12, $pop21
; NO-SIMD128-FAST-NEXT:    i32.shl $push8=, $4, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $13, $pop20
; NO-SIMD128-FAST-NEXT:    i32.shl $push10=, $5, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $14, $pop19
; NO-SIMD128-FAST-NEXT:    i32.shl $push12=, $6, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $15, $pop18
; NO-SIMD128-FAST-NEXT:    i32.shl $push14=, $7, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $16, $pop17
; NO-SIMD128-FAST-NEXT:    i32.shl $push16=, $8, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <8 x i16> %v, %x
  ret <8 x i16> %a
}

define <8 x i16> @shr_s_v8i16(<8 x i16> %v, i16 %x) {
; SIMD128-LABEL: shr_s_v8i16:
; SIMD128:         .functype shr_s_v8i16 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.shr_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_s_v8i16:
; SIMD128-FAST:         .functype shr_s_v8i16 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.shr_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_v8i16:
; NO-SIMD128:         .functype shr_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push1=, $8
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push18=, $9, $pop0
; NO-SIMD128-NEXT:    local.tee $push17=, $9=, $pop18
; NO-SIMD128-NEXT:    i32.shr_s $push2=, $pop1, $pop17
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop2
; NO-SIMD128-NEXT:    i32.extend16_s $push3=, $7
; NO-SIMD128-NEXT:    i32.shr_s $push4=, $pop3, $9
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop4
; NO-SIMD128-NEXT:    i32.extend16_s $push5=, $6
; NO-SIMD128-NEXT:    i32.shr_s $push6=, $pop5, $9
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop6
; NO-SIMD128-NEXT:    i32.extend16_s $push7=, $5
; NO-SIMD128-NEXT:    i32.shr_s $push8=, $pop7, $9
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop8
; NO-SIMD128-NEXT:    i32.extend16_s $push9=, $4
; NO-SIMD128-NEXT:    i32.shr_s $push10=, $pop9, $9
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop10
; NO-SIMD128-NEXT:    i32.extend16_s $push11=, $3
; NO-SIMD128-NEXT:    i32.shr_s $push12=, $pop11, $9
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop12
; NO-SIMD128-NEXT:    i32.extend16_s $push13=, $2
; NO-SIMD128-NEXT:    i32.shr_s $push14=, $pop13, $9
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop14
; NO-SIMD128-NEXT:    i32.extend16_s $push15=, $1
; NO-SIMD128-NEXT:    i32.shr_s $push16=, $pop15, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop16
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_v8i16:
; NO-SIMD128-FAST:         .functype shr_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push17=, $1=, $pop18
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push2=, $pop1, $pop17
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push3=, $2
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push5=, $3
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push7=, $4
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push8=, $pop7, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push9=, $5
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push10=, $pop9, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push11=, $6
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push12=, $pop11, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push13=, $7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push14=, $pop13, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push15=, $8
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push16=, $pop15, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <8 x i16> undef, i16 %x, i32 0
  %s = shufflevector <8 x i16> %t, <8 x i16> undef,
    <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = ashr <8 x i16> %v, %s
  ret <8 x i16> %a
}

define <8 x i16> @shr_s_vec_v8i16(<8 x i16> %v, <8 x i16> %x) {
; SIMD128-LABEL: shr_s_vec_v8i16:
; SIMD128:         .functype shr_s_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_s $push7=, $0, 0
; SIMD128-NEXT:    i16x8.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 15
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shr_s $push8=, $pop7, $pop6
; SIMD128-NEXT:    i16x8.splat $push9=, $pop8
; SIMD128-NEXT:    i16x8.extract_lane_s $push3=, $0, 1
; SIMD128-NEXT:    i16x8.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push47=, 15
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop47
; SIMD128-NEXT:    i32.shr_s $push4=, $pop3, $pop2
; SIMD128-NEXT:    i16x8.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i16x8.extract_lane_s $push13=, $0, 2
; SIMD128-NEXT:    i16x8.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push46=, 15
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop46
; SIMD128-NEXT:    i32.shr_s $push14=, $pop13, $pop12
; SIMD128-NEXT:    i16x8.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i16x8.extract_lane_s $push18=, $0, 3
; SIMD128-NEXT:    i16x8.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push45=, 15
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop45
; SIMD128-NEXT:    i32.shr_s $push19=, $pop18, $pop17
; SIMD128-NEXT:    i16x8.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i16x8.extract_lane_s $push23=, $0, 4
; SIMD128-NEXT:    i16x8.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push44=, 15
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop44
; SIMD128-NEXT:    i32.shr_s $push24=, $pop23, $pop22
; SIMD128-NEXT:    i16x8.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i16x8.extract_lane_s $push28=, $0, 5
; SIMD128-NEXT:    i16x8.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push43=, 15
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop43
; SIMD128-NEXT:    i32.shr_s $push29=, $pop28, $pop27
; SIMD128-NEXT:    i16x8.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i16x8.extract_lane_s $push33=, $0, 6
; SIMD128-NEXT:    i16x8.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push42=, 15
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop42
; SIMD128-NEXT:    i32.shr_s $push34=, $pop33, $pop32
; SIMD128-NEXT:    i16x8.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i16x8.extract_lane_s $push38=, $0, 7
; SIMD128-NEXT:    i16x8.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push41=, 15
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop41
; SIMD128-NEXT:    i32.shr_s $push39=, $pop38, $pop37
; SIMD128-NEXT:    i16x8.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    return $pop40
;
; SIMD128-FAST-LABEL: shr_s_vec_v8i16:
; SIMD128-FAST:         .functype shr_s_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push8=, $0, 0
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 15
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i16x8.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push4=, $0, 1
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push47=, 15
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop47
; SIMD128-FAST-NEXT:    i32.shr_s $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push14=, $0, 2
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push46=, 15
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop46
; SIMD128-FAST-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push19=, $0, 3
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push45=, 15
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop45
; SIMD128-FAST-NEXT:    i32.shr_s $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push24=, $0, 4
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push44=, 15
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop44
; SIMD128-FAST-NEXT:    i32.shr_s $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push29=, $0, 5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push43=, 15
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop43
; SIMD128-FAST-NEXT:    i32.shr_s $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push34=, $0, 6
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push42=, 15
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop42
; SIMD128-FAST-NEXT:    i32.shr_s $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push39=, $0, 7
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push41=, 15
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop41
; SIMD128-FAST-NEXT:    i32.shr_s $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push0=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_vec_v8i16:
; NO-SIMD128:         .functype shr_s_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push2=, $8
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop0
; NO-SIMD128-NEXT:    i32.shr_s $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop3
; NO-SIMD128-NEXT:    i32.extend16_s $push5=, $7
; NO-SIMD128-NEXT:    i32.const $push31=, 65535
; NO-SIMD128-NEXT:    i32.and $push4=, $15, $pop31
; NO-SIMD128-NEXT:    i32.shr_s $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop6
; NO-SIMD128-NEXT:    i32.extend16_s $push8=, $6
; NO-SIMD128-NEXT:    i32.const $push30=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $14, $pop30
; NO-SIMD128-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop9
; NO-SIMD128-NEXT:    i32.extend16_s $push11=, $5
; NO-SIMD128-NEXT:    i32.const $push29=, 65535
; NO-SIMD128-NEXT:    i32.and $push10=, $13, $pop29
; NO-SIMD128-NEXT:    i32.shr_s $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop12
; NO-SIMD128-NEXT:    i32.extend16_s $push14=, $4
; NO-SIMD128-NEXT:    i32.const $push28=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $12, $pop28
; NO-SIMD128-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop15
; NO-SIMD128-NEXT:    i32.extend16_s $push17=, $3
; NO-SIMD128-NEXT:    i32.const $push27=, 65535
; NO-SIMD128-NEXT:    i32.and $push16=, $11, $pop27
; NO-SIMD128-NEXT:    i32.shr_s $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop18
; NO-SIMD128-NEXT:    i32.extend16_s $push20=, $2
; NO-SIMD128-NEXT:    i32.const $push26=, 65535
; NO-SIMD128-NEXT:    i32.and $push19=, $10, $pop26
; NO-SIMD128-NEXT:    i32.shr_s $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop21
; NO-SIMD128-NEXT:    i32.extend16_s $push23=, $1
; NO-SIMD128-NEXT:    i32.const $push25=, 65535
; NO-SIMD128-NEXT:    i32.and $push22=, $9, $pop25
; NO-SIMD128-NEXT:    i32.shr_s $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop24
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_vec_v8i16:
; NO-SIMD128-FAST:         .functype shr_s_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push2=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $10, $pop31
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push8=, $3
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $11, $pop30
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push11=, $4
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $12, $pop29
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push14=, $5
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $13, $pop28
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push17=, $6
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $14, $pop27
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push18=, $pop17, $pop16
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push20=, $7
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $15, $pop26
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push23=, $8
; NO-SIMD128-FAST-NEXT:    i32.const $push25=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $16, $pop25
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop24
; NO-SIMD128-FAST-NEXT:    return
  %a = ashr <8 x i16> %v, %x
  ret <8 x i16> %a
}

define <8 x i16> @shr_u_v8i16(<8 x i16> %v, i16 %x) {
; SIMD128-LABEL: shr_u_v8i16:
; SIMD128:         .functype shr_u_v8i16 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.shr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_u_v8i16:
; SIMD128-FAST:         .functype shr_u_v8i16 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.shr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_v8i16:
; NO-SIMD128:         .functype shr_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push26=, 65535
; NO-SIMD128-NEXT:    i32.and $push25=, $9, $pop26
; NO-SIMD128-NEXT:    local.tee $push24=, $9=, $pop25
; NO-SIMD128-NEXT:    i32.shr_u $push2=, $pop1, $pop24
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push23=, 65535
; NO-SIMD128-NEXT:    i32.and $push3=, $7, $pop23
; NO-SIMD128-NEXT:    i32.shr_u $push4=, $pop3, $9
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push22=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $6, $pop22
; NO-SIMD128-NEXT:    i32.shr_u $push6=, $pop5, $9
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push21=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $5, $pop21
; NO-SIMD128-NEXT:    i32.shr_u $push8=, $pop7, $9
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push20=, 65535
; NO-SIMD128-NEXT:    i32.and $push9=, $4, $pop20
; NO-SIMD128-NEXT:    i32.shr_u $push10=, $pop9, $9
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-NEXT:    i32.and $push11=, $3, $pop19
; NO-SIMD128-NEXT:    i32.shr_u $push12=, $pop11, $9
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $2, $pop18
; NO-SIMD128-NEXT:    i32.shr_u $push14=, $pop13, $9
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop14
; NO-SIMD128-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-NEXT:    i32.and $push15=, $1, $pop17
; NO-SIMD128-NEXT:    i32.shr_u $push16=, $pop15, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop16
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_v8i16:
; NO-SIMD128-FAST:         .functype shr_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $9, $pop26
; NO-SIMD128-FAST-NEXT:    local.tee $push24=, $1=, $pop25
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push2=, $pop1, $pop24
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $2, $pop23
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $3, $pop22
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $4, $pop21
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push8=, $pop7, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $5, $pop20
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push10=, $pop9, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $6, $pop19
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push12=, $pop11, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $7, $pop18
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push14=, $pop13, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $8, $pop17
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push16=, $pop15, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <8 x i16> undef, i16 %x, i32 0
  %s = shufflevector <8 x i16> %t, <8 x i16> undef,
    <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = lshr <8 x i16> %v, %s
  ret <8 x i16> %a
}

define <8 x i16> @shr_u_vec_v8i16(<8 x i16> %v, <8 x i16> %x) {
; SIMD128-LABEL: shr_u_vec_v8i16:
; SIMD128:         .functype shr_u_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_u $push7=, $0, 0
; SIMD128-NEXT:    i16x8.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 15
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shr_u $push8=, $pop7, $pop6
; SIMD128-NEXT:    i16x8.splat $push9=, $pop8
; SIMD128-NEXT:    i16x8.extract_lane_u $push3=, $0, 1
; SIMD128-NEXT:    i16x8.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push47=, 15
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop47
; SIMD128-NEXT:    i32.shr_u $push4=, $pop3, $pop2
; SIMD128-NEXT:    i16x8.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i16x8.extract_lane_u $push13=, $0, 2
; SIMD128-NEXT:    i16x8.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push46=, 15
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop46
; SIMD128-NEXT:    i32.shr_u $push14=, $pop13, $pop12
; SIMD128-NEXT:    i16x8.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i16x8.extract_lane_u $push18=, $0, 3
; SIMD128-NEXT:    i16x8.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push45=, 15
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop45
; SIMD128-NEXT:    i32.shr_u $push19=, $pop18, $pop17
; SIMD128-NEXT:    i16x8.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i16x8.extract_lane_u $push23=, $0, 4
; SIMD128-NEXT:    i16x8.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push44=, 15
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop44
; SIMD128-NEXT:    i32.shr_u $push24=, $pop23, $pop22
; SIMD128-NEXT:    i16x8.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i16x8.extract_lane_u $push28=, $0, 5
; SIMD128-NEXT:    i16x8.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push43=, 15
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop43
; SIMD128-NEXT:    i32.shr_u $push29=, $pop28, $pop27
; SIMD128-NEXT:    i16x8.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i16x8.extract_lane_u $push33=, $0, 6
; SIMD128-NEXT:    i16x8.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push42=, 15
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop42
; SIMD128-NEXT:    i32.shr_u $push34=, $pop33, $pop32
; SIMD128-NEXT:    i16x8.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i16x8.extract_lane_u $push38=, $0, 7
; SIMD128-NEXT:    i16x8.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push41=, 15
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop41
; SIMD128-NEXT:    i32.shr_u $push39=, $pop38, $pop37
; SIMD128-NEXT:    i16x8.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    return $pop40
;
; SIMD128-FAST-LABEL: shr_u_vec_v8i16:
; SIMD128-FAST:         .functype shr_u_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push8=, $0, 0
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 15
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i16x8.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push4=, $0, 1
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push47=, 15
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop47
; SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push14=, $0, 2
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push46=, 15
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop46
; SIMD128-FAST-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push19=, $0, 3
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push45=, 15
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop45
; SIMD128-FAST-NEXT:    i32.shr_u $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push24=, $0, 4
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push44=, 15
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop44
; SIMD128-FAST-NEXT:    i32.shr_u $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push29=, $0, 5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push43=, 15
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop43
; SIMD128-FAST-NEXT:    i32.shr_u $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push34=, $0, 6
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push42=, 15
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop42
; SIMD128-FAST-NEXT:    i32.shr_u $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push39=, $0, 7
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push41=, 15
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop41
; SIMD128-FAST-NEXT:    i32.shr_u $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push0=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_vec_v8i16:
; NO-SIMD128:         .functype shr_u_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push2=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push39=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop39
; NO-SIMD128-NEXT:    i32.shr_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push38=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $7, $pop38
; NO-SIMD128-NEXT:    i32.const $push37=, 65535
; NO-SIMD128-NEXT:    i32.and $push4=, $15, $pop37
; NO-SIMD128-NEXT:    i32.shr_u $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push36=, 65535
; NO-SIMD128-NEXT:    i32.and $push8=, $6, $pop36
; NO-SIMD128-NEXT:    i32.const $push35=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $14, $pop35
; NO-SIMD128-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-NEXT:    i32.and $push11=, $5, $pop34
; NO-SIMD128-NEXT:    i32.const $push33=, 65535
; NO-SIMD128-NEXT:    i32.and $push10=, $13, $pop33
; NO-SIMD128-NEXT:    i32.shr_u $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push32=, 65535
; NO-SIMD128-NEXT:    i32.and $push14=, $4, $pop32
; NO-SIMD128-NEXT:    i32.const $push31=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $12, $pop31
; NO-SIMD128-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop15
; NO-SIMD128-NEXT:    i32.const $push30=, 65535
; NO-SIMD128-NEXT:    i32.and $push17=, $3, $pop30
; NO-SIMD128-NEXT:    i32.const $push29=, 65535
; NO-SIMD128-NEXT:    i32.and $push16=, $11, $pop29
; NO-SIMD128-NEXT:    i32.shr_u $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop18
; NO-SIMD128-NEXT:    i32.const $push28=, 65535
; NO-SIMD128-NEXT:    i32.and $push20=, $2, $pop28
; NO-SIMD128-NEXT:    i32.const $push27=, 65535
; NO-SIMD128-NEXT:    i32.and $push19=, $10, $pop27
; NO-SIMD128-NEXT:    i32.shr_u $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop21
; NO-SIMD128-NEXT:    i32.const $push26=, 65535
; NO-SIMD128-NEXT:    i32.and $push23=, $1, $pop26
; NO-SIMD128-NEXT:    i32.const $push25=, 65535
; NO-SIMD128-NEXT:    i32.and $push22=, $9, $pop25
; NO-SIMD128-NEXT:    i32.shr_u $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop24
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_vec_v8i16:
; NO-SIMD128-FAST:         .functype shr_u_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop39
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $2, $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $10, $pop37
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $3, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $11, $pop35
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $4, $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $12, $pop33
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $5, $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $13, $pop31
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $6, $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $14, $pop29
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push18=, $pop17, $pop16
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $7, $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $15, $pop27
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $8, $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push25=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $16, $pop25
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop24
; NO-SIMD128-FAST-NEXT:    return
  %a = lshr <8 x i16> %v, %x
  ret <8 x i16> %a
}

define <8 x i16> @and_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: and_v8i16:
; SIMD128:         .functype and_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.and $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: and_v8i16:
; SIMD128-FAST:         .functype and_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: and_v8i16:
; NO-SIMD128:         .functype and_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.and $push0=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop0
; NO-SIMD128-NEXT:    i32.and $push1=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop1
; NO-SIMD128-NEXT:    i32.and $push2=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop2
; NO-SIMD128-NEXT:    i32.and $push3=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop3
; NO-SIMD128-NEXT:    i32.and $push4=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop4
; NO-SIMD128-NEXT:    i32.and $push5=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop5
; NO-SIMD128-NEXT:    i32.and $push6=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-NEXT:    i32.and $push7=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: and_v8i16:
; NO-SIMD128-FAST:         .functype and_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.and $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %a = and <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @or_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: or_v8i16:
; SIMD128:         .functype or_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.or $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: or_v8i16:
; SIMD128-FAST:         .functype or_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.or $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: or_v8i16:
; NO-SIMD128:         .functype or_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.or $push0=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop0
; NO-SIMD128-NEXT:    i32.or $push1=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop1
; NO-SIMD128-NEXT:    i32.or $push2=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop2
; NO-SIMD128-NEXT:    i32.or $push3=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop3
; NO-SIMD128-NEXT:    i32.or $push4=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop4
; NO-SIMD128-NEXT:    i32.or $push5=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop5
; NO-SIMD128-NEXT:    i32.or $push6=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-NEXT:    i32.or $push7=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: or_v8i16:
; NO-SIMD128-FAST:         .functype or_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.or $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.or $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.or $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.or $push3=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.or $push4=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.or $push5=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.or $push6=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.or $push7=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %a = or <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @xor_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: xor_v8i16:
; SIMD128:         .functype xor_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: xor_v8i16:
; SIMD128-FAST:         .functype xor_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: xor_v8i16:
; NO-SIMD128:         .functype xor_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop0
; NO-SIMD128-NEXT:    i32.xor $push1=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop1
; NO-SIMD128-NEXT:    i32.xor $push2=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop2
; NO-SIMD128-NEXT:    i32.xor $push3=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop3
; NO-SIMD128-NEXT:    i32.xor $push4=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop4
; NO-SIMD128-NEXT:    i32.xor $push5=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop5
; NO-SIMD128-NEXT:    i32.xor $push6=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-NEXT:    i32.xor $push7=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: xor_v8i16:
; NO-SIMD128-FAST:         .functype xor_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.xor $push4=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.xor $push7=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @not_v8i16(<8 x i16> %x) {
; SIMD128-LABEL: not_v8i16:
; SIMD128:         .functype not_v8i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.not $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: not_v8i16:
; SIMD128-FAST:         .functype not_v8i16 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: not_v8i16:
; NO-SIMD128:         .functype not_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $8, $pop0
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push15=, -1
; NO-SIMD128-NEXT:    i32.xor $push2=, $7, $pop15
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push14=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $6, $pop14
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push13=, -1
; NO-SIMD128-NEXT:    i32.xor $push4=, $5, $pop13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push12=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $4, $pop12
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push11=, -1
; NO-SIMD128-NEXT:    i32.xor $push6=, $3, $pop11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push10=, -1
; NO-SIMD128-NEXT:    i32.xor $push7=, $2, $pop10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop7
; NO-SIMD128-NEXT:    i32.const $push9=, -1
; NO-SIMD128-NEXT:    i32.xor $push8=, $1, $pop9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: not_v8i16:
; NO-SIMD128-FAST:         .functype not_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push15=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $2, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $3, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push4=, $4, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push12=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $5, $pop12
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $6, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push7=, $7, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $8, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <8 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1,
                          i16 -1, i16 -1, i16 -1, i16 -1>
  ret <8 x i16> %a
}

define <8 x i16> @andnot_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: andnot_v8i16:
; SIMD128:         .functype andnot_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.andnot $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: andnot_v8i16:
; SIMD128-FAST:         .functype andnot_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $1
; SIMD128-FAST-NEXT:    v128.and $push1=, $0, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: andnot_v8i16:
; NO-SIMD128:         .functype andnot_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $16, $pop0
; NO-SIMD128-NEXT:    i32.and $push2=, $8, $pop1
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push23=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $15, $pop23
; NO-SIMD128-NEXT:    i32.and $push4=, $7, $pop3
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push22=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $14, $pop22
; NO-SIMD128-NEXT:    i32.and $push6=, $6, $pop5
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push21=, -1
; NO-SIMD128-NEXT:    i32.xor $push7=, $13, $pop21
; NO-SIMD128-NEXT:    i32.and $push8=, $5, $pop7
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push20=, -1
; NO-SIMD128-NEXT:    i32.xor $push9=, $12, $pop20
; NO-SIMD128-NEXT:    i32.and $push10=, $4, $pop9
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push19=, -1
; NO-SIMD128-NEXT:    i32.xor $push11=, $11, $pop19
; NO-SIMD128-NEXT:    i32.and $push12=, $3, $pop11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push18=, -1
; NO-SIMD128-NEXT:    i32.xor $push13=, $10, $pop18
; NO-SIMD128-NEXT:    i32.and $push14=, $2, $pop13
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop14
; NO-SIMD128-NEXT:    i32.const $push17=, -1
; NO-SIMD128-NEXT:    i32.xor $push15=, $9, $pop17
; NO-SIMD128-NEXT:    i32.and $push16=, $1, $pop15
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop16
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: andnot_v8i16:
; NO-SIMD128-FAST:         .functype andnot_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $10, $pop23
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $11, $pop22
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $3, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push7=, $12, $pop21
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $4, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $13, $pop20
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $5, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $14, $pop19
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $6, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $15, $pop18
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $7, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $16, $pop17
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $8, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop16
; NO-SIMD128-FAST-NEXT:    return
 %inv_y = xor <8 x i16> %y,
   <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
 %a = and <8 x i16> %x, %inv_y
 ret <8 x i16> %a
}

define <8 x i16> @bitselect_v8i16(<8 x i16> %c, <8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: bitselect_v8i16:
; SIMD128:         .functype bitselect_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_v8i16:
; SIMD128-FAST:         .functype bitselect_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $1, $0
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $2, $pop2
; SIMD128-FAST-NEXT:    v128.or $push1=, $pop0, $pop3
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: bitselect_v8i16:
; NO-SIMD128:         .functype bitselect_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $16, $24
; NO-SIMD128-NEXT:    i32.and $push1=, $pop0, $8
; NO-SIMD128-NEXT:    i32.xor $push2=, $pop1, $24
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop2
; NO-SIMD128-NEXT:    i32.xor $push3=, $15, $23
; NO-SIMD128-NEXT:    i32.and $push4=, $pop3, $7
; NO-SIMD128-NEXT:    i32.xor $push5=, $pop4, $23
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop5
; NO-SIMD128-NEXT:    i32.xor $push6=, $14, $22
; NO-SIMD128-NEXT:    i32.and $push7=, $pop6, $6
; NO-SIMD128-NEXT:    i32.xor $push8=, $pop7, $22
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop8
; NO-SIMD128-NEXT:    i32.xor $push9=, $13, $21
; NO-SIMD128-NEXT:    i32.and $push10=, $pop9, $5
; NO-SIMD128-NEXT:    i32.xor $push11=, $pop10, $21
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop11
; NO-SIMD128-NEXT:    i32.xor $push12=, $12, $20
; NO-SIMD128-NEXT:    i32.and $push13=, $pop12, $4
; NO-SIMD128-NEXT:    i32.xor $push14=, $pop13, $20
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop14
; NO-SIMD128-NEXT:    i32.xor $push15=, $11, $19
; NO-SIMD128-NEXT:    i32.and $push16=, $pop15, $3
; NO-SIMD128-NEXT:    i32.xor $push17=, $pop16, $19
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop17
; NO-SIMD128-NEXT:    i32.xor $push18=, $10, $18
; NO-SIMD128-NEXT:    i32.and $push19=, $pop18, $2
; NO-SIMD128-NEXT:    i32.xor $push20=, $pop19, $18
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop20
; NO-SIMD128-NEXT:    i32.xor $push21=, $9, $17
; NO-SIMD128-NEXT:    i32.and $push22=, $pop21, $1
; NO-SIMD128-NEXT:    i32.xor $push23=, $pop22, $17
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop23
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_v8i16:
; NO-SIMD128-FAST:         .functype bitselect_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $9, $17
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $pop1, $17
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $10, $18
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $pop4, $18
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $11, $19
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $3
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $19
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $12, $20
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $pop9, $4
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $pop10, $20
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $13, $21
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $5
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $pop13, $21
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $14, $22
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $pop15, $6
; NO-SIMD128-FAST-NEXT:    i32.xor $push17=, $pop16, $22
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push18=, $15, $23
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $pop18, $7
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $pop19, $23
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.xor $push21=, $16, $24
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $pop21, $8
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $pop22, $24
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop23
; NO-SIMD128-FAST-NEXT:    return
  %masked_v1 = and <8 x i16> %v1, %c
  %inv_mask = xor <8 x i16>
    <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>,
    %c
  %masked_v2 = and <8 x i16> %v2, %inv_mask
  %a = or <8 x i16> %masked_v1, %masked_v2
  ret <8 x i16> %a
}

define <8 x i16> @bitselect_xor_v8i16(<8 x i16> %c, <8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: bitselect_xor_v8i16:
; SIMD128:         .functype bitselect_xor_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_v8i16:
; SIMD128-FAST:         .functype bitselect_xor_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push2=, $1, $2
; SIMD128-FAST-NEXT:    v128.and $push1=, $pop2, $0
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop1, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_v8i16:
; NO-SIMD128:         .functype bitselect_xor_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $16, $24
; NO-SIMD128-NEXT:    i32.and $push1=, $pop0, $8
; NO-SIMD128-NEXT:    i32.xor $push2=, $pop1, $24
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop2
; NO-SIMD128-NEXT:    i32.xor $push3=, $15, $23
; NO-SIMD128-NEXT:    i32.and $push4=, $pop3, $7
; NO-SIMD128-NEXT:    i32.xor $push5=, $pop4, $23
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop5
; NO-SIMD128-NEXT:    i32.xor $push6=, $14, $22
; NO-SIMD128-NEXT:    i32.and $push7=, $pop6, $6
; NO-SIMD128-NEXT:    i32.xor $push8=, $pop7, $22
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop8
; NO-SIMD128-NEXT:    i32.xor $push9=, $13, $21
; NO-SIMD128-NEXT:    i32.and $push10=, $pop9, $5
; NO-SIMD128-NEXT:    i32.xor $push11=, $pop10, $21
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop11
; NO-SIMD128-NEXT:    i32.xor $push12=, $12, $20
; NO-SIMD128-NEXT:    i32.and $push13=, $pop12, $4
; NO-SIMD128-NEXT:    i32.xor $push14=, $pop13, $20
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop14
; NO-SIMD128-NEXT:    i32.xor $push15=, $11, $19
; NO-SIMD128-NEXT:    i32.and $push16=, $pop15, $3
; NO-SIMD128-NEXT:    i32.xor $push17=, $pop16, $19
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop17
; NO-SIMD128-NEXT:    i32.xor $push18=, $10, $18
; NO-SIMD128-NEXT:    i32.and $push19=, $pop18, $2
; NO-SIMD128-NEXT:    i32.xor $push20=, $pop19, $18
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop20
; NO-SIMD128-NEXT:    i32.xor $push21=, $9, $17
; NO-SIMD128-NEXT:    i32.and $push22=, $pop21, $1
; NO-SIMD128-NEXT:    i32.xor $push23=, $pop22, $17
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop23
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_v8i16:
; NO-SIMD128-FAST:         .functype bitselect_xor_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $9, $17
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $pop1, $17
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $10, $18
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $pop4, $18
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $11, $19
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $3
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $19
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $12, $20
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $pop9, $4
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $pop10, $20
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $13, $21
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $5
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $pop13, $21
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $14, $22
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $pop15, $6
; NO-SIMD128-FAST-NEXT:    i32.xor $push17=, $pop16, $22
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push18=, $15, $23
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $pop18, $7
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $pop19, $23
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.xor $push21=, $16, $24
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $pop21, $8
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $pop22, $24
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop23
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <8 x i16> %v1, %v2
 %and = and <8 x i16> %xor1, %c
 %a = xor <8 x i16> %and, %v2
 ret <8 x i16> %a
}

define <8 x i16> @bitselect_xor_reversed_v8i16(<8 x i16> %c, <8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: bitselect_xor_reversed_v8i16:
; SIMD128:         .functype bitselect_xor_reversed_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $2, $1, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_reversed_v8i16:
; SIMD128-FAST:         .functype bitselect_xor_reversed_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push1=, $1, $2
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop1, $pop2
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop3, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_reversed_v8i16:
; NO-SIMD128:         .functype bitselect_xor_reversed_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push2=, $16, $24
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $8, $pop0
; NO-SIMD128-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.xor $push4=, $pop3, $24
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop4
; NO-SIMD128-NEXT:    i32.xor $push6=, $15, $23
; NO-SIMD128-NEXT:    i32.const $push39=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $7, $pop39
; NO-SIMD128-NEXT:    i32.and $push7=, $pop6, $pop5
; NO-SIMD128-NEXT:    i32.xor $push8=, $pop7, $23
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop8
; NO-SIMD128-NEXT:    i32.xor $push10=, $14, $22
; NO-SIMD128-NEXT:    i32.const $push38=, -1
; NO-SIMD128-NEXT:    i32.xor $push9=, $6, $pop38
; NO-SIMD128-NEXT:    i32.and $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.xor $push12=, $pop11, $22
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop12
; NO-SIMD128-NEXT:    i32.xor $push14=, $13, $21
; NO-SIMD128-NEXT:    i32.const $push37=, -1
; NO-SIMD128-NEXT:    i32.xor $push13=, $5, $pop37
; NO-SIMD128-NEXT:    i32.and $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.xor $push16=, $pop15, $21
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop16
; NO-SIMD128-NEXT:    i32.xor $push18=, $12, $20
; NO-SIMD128-NEXT:    i32.const $push36=, -1
; NO-SIMD128-NEXT:    i32.xor $push17=, $4, $pop36
; NO-SIMD128-NEXT:    i32.and $push19=, $pop18, $pop17
; NO-SIMD128-NEXT:    i32.xor $push20=, $pop19, $20
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop20
; NO-SIMD128-NEXT:    i32.xor $push22=, $11, $19
; NO-SIMD128-NEXT:    i32.const $push35=, -1
; NO-SIMD128-NEXT:    i32.xor $push21=, $3, $pop35
; NO-SIMD128-NEXT:    i32.and $push23=, $pop22, $pop21
; NO-SIMD128-NEXT:    i32.xor $push24=, $pop23, $19
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop24
; NO-SIMD128-NEXT:    i32.xor $push26=, $10, $18
; NO-SIMD128-NEXT:    i32.const $push34=, -1
; NO-SIMD128-NEXT:    i32.xor $push25=, $2, $pop34
; NO-SIMD128-NEXT:    i32.and $push27=, $pop26, $pop25
; NO-SIMD128-NEXT:    i32.xor $push28=, $pop27, $18
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop28
; NO-SIMD128-NEXT:    i32.xor $push30=, $9, $17
; NO-SIMD128-NEXT:    i32.const $push33=, -1
; NO-SIMD128-NEXT:    i32.xor $push29=, $1, $pop33
; NO-SIMD128-NEXT:    i32.and $push31=, $pop30, $pop29
; NO-SIMD128-NEXT:    i32.xor $push32=, $pop31, $17
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop32
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_reversed_v8i16:
; NO-SIMD128-FAST:         .functype bitselect_xor_reversed_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $9, $17
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push4=, $pop3, $17
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $10, $18
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $2, $pop39
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $18
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $11, $19
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $3, $pop38
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $pop11, $19
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $12, $20
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $4, $pop37
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $pop15, $20
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.xor $push18=, $13, $21
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push17=, $5, $pop36
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $pop18, $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $pop19, $21
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.xor $push22=, $14, $22
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push21=, $6, $pop35
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop21
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $pop23, $22
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop24
; NO-SIMD128-FAST-NEXT:    i32.xor $push26=, $15, $23
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push25=, $7, $pop34
; NO-SIMD128-FAST-NEXT:    i32.and $push27=, $pop26, $pop25
; NO-SIMD128-FAST-NEXT:    i32.xor $push28=, $pop27, $23
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop28
; NO-SIMD128-FAST-NEXT:    i32.xor $push30=, $16, $24
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $8, $pop33
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.xor $push32=, $pop31, $24
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop32
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <8 x i16> %v1, %v2
 %notc = xor <8 x i16> %c, <i16 -1, i16 -1, i16 -1, i16 -1,
                            i16 -1, i16 -1, i16 -1, i16 -1>
 %and = and <8 x i16> %xor1, %notc
 %a = xor <8 x i16> %and, %v2
 ret <8 x i16> %a
}

define <8 x i16> @extmul_low_s_v8i16(<16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: extmul_low_s_v8i16:
; SIMD128:         .functype extmul_low_s_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extmul_low_i8x16_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_s_v8i16:
; SIMD128-FAST:         .functype extmul_low_s_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extend_low_i8x16_s $push0=, $0
; SIMD128-FAST-NEXT:    i16x8.extend_low_i8x16_s $push1=, $1
; SIMD128-FAST-NEXT:    i16x8.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_s_v8i16:
; NO-SIMD128:         .functype extmul_low_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push1=, $8
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $24
; NO-SIMD128-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop2
; NO-SIMD128-NEXT:    i32.extend8_s $push4=, $7
; NO-SIMD128-NEXT:    i32.extend8_s $push3=, $23
; NO-SIMD128-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop5
; NO-SIMD128-NEXT:    i32.extend8_s $push7=, $6
; NO-SIMD128-NEXT:    i32.extend8_s $push6=, $22
; NO-SIMD128-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop8
; NO-SIMD128-NEXT:    i32.extend8_s $push10=, $5
; NO-SIMD128-NEXT:    i32.extend8_s $push9=, $21
; NO-SIMD128-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop11
; NO-SIMD128-NEXT:    i32.extend8_s $push13=, $4
; NO-SIMD128-NEXT:    i32.extend8_s $push12=, $20
; NO-SIMD128-NEXT:    i32.mul $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop14
; NO-SIMD128-NEXT:    i32.extend8_s $push16=, $3
; NO-SIMD128-NEXT:    i32.extend8_s $push15=, $19
; NO-SIMD128-NEXT:    i32.mul $push17=, $pop16, $pop15
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop17
; NO-SIMD128-NEXT:    i32.extend8_s $push19=, $2
; NO-SIMD128-NEXT:    i32.extend8_s $push18=, $18
; NO-SIMD128-NEXT:    i32.mul $push20=, $pop19, $pop18
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop20
; NO-SIMD128-NEXT:    i32.extend8_s $push22=, $1
; NO-SIMD128-NEXT:    i32.extend8_s $push21=, $17
; NO-SIMD128-NEXT:    i32.mul $push23=, $pop22, $pop21
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop23
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_s_v8i16:
; NO-SIMD128-FAST:         .functype extmul_low_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push0=, $17
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push4=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push3=, $18
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push7=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push6=, $19
; NO-SIMD128-FAST-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push10=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push9=, $20
; NO-SIMD128-FAST-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push13=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push12=, $21
; NO-SIMD128-FAST-NEXT:    i32.mul $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push16=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push15=, $22
; NO-SIMD128-FAST-NEXT:    i32.mul $push17=, $pop16, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push19=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push18=, $23
; NO-SIMD128-FAST-NEXT:    i32.mul $push20=, $pop19, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push22=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push21=, $24
; NO-SIMD128-FAST-NEXT:    i32.mul $push23=, $pop22, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop23
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <16 x i8> %v1, <16 x i8> undef,
           <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %low2 = shufflevector <16 x i8> %v2, <16 x i8> undef,
           <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %extended1 = sext <8 x i8> %low1 to <8 x i16>
  %extended2 = sext <8 x i8> %low2 to <8 x i16>
  %a = mul <8 x i16> %extended1, %extended2
  ret <8 x i16> %a
}

define <8 x i16> @extmul_high_s_v8i16(<16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: extmul_high_s_v8i16:
; SIMD128:         .functype extmul_high_s_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extmul_high_i8x16_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_s_v8i16:
; SIMD128-FAST:         .functype extmul_high_s_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extend_high_i8x16_s $push0=, $0
; SIMD128-FAST-NEXT:    i16x8.extend_high_i8x16_s $push1=, $1
; SIMD128-FAST-NEXT:    i16x8.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_s_v8i16:
; NO-SIMD128:         .functype extmul_high_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push1=, $16
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $32
; NO-SIMD128-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop2
; NO-SIMD128-NEXT:    i32.extend8_s $push4=, $15
; NO-SIMD128-NEXT:    i32.extend8_s $push3=, $31
; NO-SIMD128-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop5
; NO-SIMD128-NEXT:    i32.extend8_s $push7=, $14
; NO-SIMD128-NEXT:    i32.extend8_s $push6=, $30
; NO-SIMD128-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop8
; NO-SIMD128-NEXT:    i32.extend8_s $push10=, $13
; NO-SIMD128-NEXT:    i32.extend8_s $push9=, $29
; NO-SIMD128-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop11
; NO-SIMD128-NEXT:    i32.extend8_s $push13=, $12
; NO-SIMD128-NEXT:    i32.extend8_s $push12=, $28
; NO-SIMD128-NEXT:    i32.mul $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop14
; NO-SIMD128-NEXT:    i32.extend8_s $push16=, $11
; NO-SIMD128-NEXT:    i32.extend8_s $push15=, $27
; NO-SIMD128-NEXT:    i32.mul $push17=, $pop16, $pop15
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop17
; NO-SIMD128-NEXT:    i32.extend8_s $push19=, $10
; NO-SIMD128-NEXT:    i32.extend8_s $push18=, $26
; NO-SIMD128-NEXT:    i32.mul $push20=, $pop19, $pop18
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop20
; NO-SIMD128-NEXT:    i32.extend8_s $push22=, $9
; NO-SIMD128-NEXT:    i32.extend8_s $push21=, $25
; NO-SIMD128-NEXT:    i32.mul $push23=, $pop22, $pop21
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop23
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_s_v8i16:
; NO-SIMD128-FAST:         .functype extmul_high_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push1=, $9
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push0=, $25
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push4=, $10
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push3=, $26
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push7=, $11
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push6=, $27
; NO-SIMD128-FAST-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push10=, $12
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push9=, $28
; NO-SIMD128-FAST-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push13=, $13
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push12=, $29
; NO-SIMD128-FAST-NEXT:    i32.mul $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop14
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push16=, $14
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push15=, $30
; NO-SIMD128-FAST-NEXT:    i32.mul $push17=, $pop16, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push19=, $15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push18=, $31
; NO-SIMD128-FAST-NEXT:    i32.mul $push20=, $pop19, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop20
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push22=, $16
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push21=, $32
; NO-SIMD128-FAST-NEXT:    i32.mul $push23=, $pop22, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop23
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <16 x i8> %v1, <16 x i8> undef,
           <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %high2 = shufflevector <16 x i8> %v2, <16 x i8> undef,
           <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %extended1 = sext <8 x i8> %high1 to <8 x i16>
  %extended2 = sext <8 x i8> %high2 to <8 x i16>
  %a = mul <8 x i16> %extended1, %extended2
  ret <8 x i16> %a
}

define <8 x i16> @extmul_low_u_v8i16(<16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: extmul_low_u_v8i16:
; SIMD128:         .functype extmul_low_u_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extmul_low_i8x16_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_u_v8i16:
; SIMD128-FAST:         .functype extmul_low_u_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extend_low_i8x16_u $push0=, $0
; SIMD128-FAST-NEXT:    i16x8.extend_low_i8x16_u $push1=, $1
; SIMD128-FAST-NEXT:    i16x8.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_u_v8i16:
; NO-SIMD128:         .functype extmul_low_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push39=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $24, $pop39
; NO-SIMD128-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push38=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $7, $pop38
; NO-SIMD128-NEXT:    i32.const $push37=, 255
; NO-SIMD128-NEXT:    i32.and $push4=, $23, $pop37
; NO-SIMD128-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push36=, 255
; NO-SIMD128-NEXT:    i32.and $push8=, $6, $pop36
; NO-SIMD128-NEXT:    i32.const $push35=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $22, $pop35
; NO-SIMD128-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push34=, 255
; NO-SIMD128-NEXT:    i32.and $push11=, $5, $pop34
; NO-SIMD128-NEXT:    i32.const $push33=, 255
; NO-SIMD128-NEXT:    i32.and $push10=, $21, $pop33
; NO-SIMD128-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push32=, 255
; NO-SIMD128-NEXT:    i32.and $push14=, $4, $pop32
; NO-SIMD128-NEXT:    i32.const $push31=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $20, $pop31
; NO-SIMD128-NEXT:    i32.mul $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop15
; NO-SIMD128-NEXT:    i32.const $push30=, 255
; NO-SIMD128-NEXT:    i32.and $push17=, $3, $pop30
; NO-SIMD128-NEXT:    i32.const $push29=, 255
; NO-SIMD128-NEXT:    i32.and $push16=, $19, $pop29
; NO-SIMD128-NEXT:    i32.mul $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop18
; NO-SIMD128-NEXT:    i32.const $push28=, 255
; NO-SIMD128-NEXT:    i32.and $push20=, $2, $pop28
; NO-SIMD128-NEXT:    i32.const $push27=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $18, $pop27
; NO-SIMD128-NEXT:    i32.mul $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop21
; NO-SIMD128-NEXT:    i32.const $push26=, 255
; NO-SIMD128-NEXT:    i32.and $push23=, $1, $pop26
; NO-SIMD128-NEXT:    i32.const $push25=, 255
; NO-SIMD128-NEXT:    i32.and $push22=, $17, $pop25
; NO-SIMD128-NEXT:    i32.mul $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop24
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_u_v8i16:
; NO-SIMD128-FAST:         .functype extmul_low_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop39
; NO-SIMD128-FAST-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $2, $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $18, $pop37
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $3, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $19, $pop35
; NO-SIMD128-FAST-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $4, $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $20, $pop33
; NO-SIMD128-FAST-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $5, $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $21, $pop31
; NO-SIMD128-FAST-NEXT:    i32.mul $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $6, $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $22, $pop29
; NO-SIMD128-FAST-NEXT:    i32.mul $push18=, $pop17, $pop16
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $7, $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $23, $pop27
; NO-SIMD128-FAST-NEXT:    i32.mul $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $8, $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push25=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $24, $pop25
; NO-SIMD128-FAST-NEXT:    i32.mul $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop24
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <16 x i8> %v1, <16 x i8> undef,
           <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %low2 = shufflevector <16 x i8> %v2, <16 x i8> undef,
           <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %extended1 = zext <8 x i8> %low1 to <8 x i16>
  %extended2 = zext <8 x i8> %low2 to <8 x i16>
  %a = mul <8 x i16> %extended1, %extended2
  ret <8 x i16> %a
}

define <8 x i16> @extmul_high_u_v8i16(<16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: extmul_high_u_v8i16:
; SIMD128:         .functype extmul_high_u_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extmul_high_i8x16_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_u_v8i16:
; SIMD128-FAST:         .functype extmul_high_u_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extend_high_i8x16_u $push0=, $0
; SIMD128-FAST-NEXT:    i16x8.extend_high_i8x16_u $push1=, $1
; SIMD128-FAST-NEXT:    i16x8.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_u_v8i16:
; NO-SIMD128:         .functype extmul_high_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $16, $pop0
; NO-SIMD128-NEXT:    i32.const $push39=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $32, $pop39
; NO-SIMD128-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store16 14($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push38=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $15, $pop38
; NO-SIMD128-NEXT:    i32.const $push37=, 255
; NO-SIMD128-NEXT:    i32.and $push4=, $31, $pop37
; NO-SIMD128-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store16 12($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push36=, 255
; NO-SIMD128-NEXT:    i32.and $push8=, $14, $pop36
; NO-SIMD128-NEXT:    i32.const $push35=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $30, $pop35
; NO-SIMD128-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store16 10($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push34=, 255
; NO-SIMD128-NEXT:    i32.and $push11=, $13, $pop34
; NO-SIMD128-NEXT:    i32.const $push33=, 255
; NO-SIMD128-NEXT:    i32.and $push10=, $29, $pop33
; NO-SIMD128-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push32=, 255
; NO-SIMD128-NEXT:    i32.and $push14=, $12, $pop32
; NO-SIMD128-NEXT:    i32.const $push31=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $28, $pop31
; NO-SIMD128-NEXT:    i32.mul $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store16 6($0), $pop15
; NO-SIMD128-NEXT:    i32.const $push30=, 255
; NO-SIMD128-NEXT:    i32.and $push17=, $11, $pop30
; NO-SIMD128-NEXT:    i32.const $push29=, 255
; NO-SIMD128-NEXT:    i32.and $push16=, $27, $pop29
; NO-SIMD128-NEXT:    i32.mul $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop18
; NO-SIMD128-NEXT:    i32.const $push28=, 255
; NO-SIMD128-NEXT:    i32.and $push20=, $10, $pop28
; NO-SIMD128-NEXT:    i32.const $push27=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $26, $pop27
; NO-SIMD128-NEXT:    i32.mul $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop21
; NO-SIMD128-NEXT:    i32.const $push26=, 255
; NO-SIMD128-NEXT:    i32.and $push23=, $9, $pop26
; NO-SIMD128-NEXT:    i32.const $push25=, 255
; NO-SIMD128-NEXT:    i32.and $push22=, $25, $pop25
; NO-SIMD128-NEXT:    i32.mul $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop24
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_u_v8i16:
; NO-SIMD128-FAST:         .functype extmul_high_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $25, $pop39
; NO-SIMD128-FAST-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $10, $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $26, $pop37
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $11, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $27, $pop35
; NO-SIMD128-FAST-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $12, $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $28, $pop33
; NO-SIMD128-FAST-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 6($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $13, $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $29, $pop31
; NO-SIMD128-FAST-NEXT:    i32.mul $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop15
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $14, $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.mul $push18=, $pop17, $pop16
; NO-SIMD128-FAST-NEXT:    i32.store16 10($0), $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $15, $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $31, $pop27
; NO-SIMD128-FAST-NEXT:    i32.mul $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 12($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $16, $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push25=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $32, $pop25
; NO-SIMD128-FAST-NEXT:    i32.mul $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store16 14($0), $pop24
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <16 x i8> %v1, <16 x i8> undef,
           <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %high2 = shufflevector <16 x i8> %v2, <16 x i8> undef,
           <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %extended1 = zext <8 x i8> %high1 to <8 x i16>
  %extended2 = zext <8 x i8> %high2 to <8 x i16>
  %a = mul <8 x i16> %extended1, %extended2
  ret <8 x i16> %a
}

; ==============================================================================
; 4 x i32
; ==============================================================================
define <4 x i32> @add_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: add_v4i32:
; SIMD128:         .functype add_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v4i32:
; SIMD128-FAST:         .functype add_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v4i32:
; NO-SIMD128:         .functype add_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.add $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.add $push1=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.add $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.add $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v4i32:
; NO-SIMD128-FAST:         .functype add_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.add $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.add $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = add <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @sub_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: sub_v4i32:
; SIMD128:         .functype sub_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v4i32:
; SIMD128-FAST:         .functype sub_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v4i32:
; NO-SIMD128:         .functype sub_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.sub $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.sub $push1=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.sub $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.sub $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v4i32:
; NO-SIMD128-FAST:         .functype sub_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.sub $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @mul_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: mul_v4i32:
; SIMD128:         .functype mul_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.mul $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: mul_v4i32:
; SIMD128-FAST:         .functype mul_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.mul $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v4i32:
; NO-SIMD128:         .functype mul_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.mul $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.mul $push1=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.mul $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.mul $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v4i32:
; NO-SIMD128-FAST:         .functype mul_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.mul $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.mul $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.mul $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = mul <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @min_s_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: min_s_v4i32:
; SIMD128:         .functype min_s_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.min_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_s_v4i32:
; SIMD128-FAST:         .functype min_s_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.min_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_s_v4i32:
; NO-SIMD128:         .functype min_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.lt_s $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.select $push1=, $4, $8, $pop0
; NO-SIMD128-NEXT:    i32.store 12($0), $pop1
; NO-SIMD128-NEXT:    i32.lt_s $push2=, $3, $7
; NO-SIMD128-NEXT:    i32.select $push3=, $3, $7, $pop2
; NO-SIMD128-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-NEXT:    i32.lt_s $push4=, $2, $6
; NO-SIMD128-NEXT:    i32.select $push5=, $2, $6, $pop4
; NO-SIMD128-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-NEXT:    i32.lt_s $push6=, $1, $5
; NO-SIMD128-NEXT:    i32.select $push7=, $1, $5, $pop6
; NO-SIMD128-NEXT:    i32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_s_v4i32:
; NO-SIMD128-FAST:         .functype min_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp slt <4 x i32> %x, %y
  %a = select <4 x i1> %c, <4 x i32> %x, <4 x i32> %y
  ret <4 x i32> %a
}

define <4 x i32> @min_u_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: min_u_v4i32:
; SIMD128:         .functype min_u_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.min_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_u_v4i32:
; SIMD128-FAST:         .functype min_u_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.min_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_u_v4i32:
; NO-SIMD128:         .functype min_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.lt_u $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.select $push1=, $4, $8, $pop0
; NO-SIMD128-NEXT:    i32.store 12($0), $pop1
; NO-SIMD128-NEXT:    i32.lt_u $push2=, $3, $7
; NO-SIMD128-NEXT:    i32.select $push3=, $3, $7, $pop2
; NO-SIMD128-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-NEXT:    i32.lt_u $push4=, $2, $6
; NO-SIMD128-NEXT:    i32.select $push5=, $2, $6, $pop4
; NO-SIMD128-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-NEXT:    i32.lt_u $push6=, $1, $5
; NO-SIMD128-NEXT:    i32.select $push7=, $1, $5, $pop6
; NO-SIMD128-NEXT:    i32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_u_v4i32:
; NO-SIMD128-FAST:         .functype min_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ult <4 x i32> %x, %y
  %a = select <4 x i1> %c, <4 x i32> %x, <4 x i32> %y
  ret <4 x i32> %a
}

define <4 x i32> @max_s_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: max_s_v4i32:
; SIMD128:         .functype max_s_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.max_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_s_v4i32:
; SIMD128-FAST:         .functype max_s_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.max_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_s_v4i32:
; NO-SIMD128:         .functype max_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.gt_s $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.select $push1=, $4, $8, $pop0
; NO-SIMD128-NEXT:    i32.store 12($0), $pop1
; NO-SIMD128-NEXT:    i32.gt_s $push2=, $3, $7
; NO-SIMD128-NEXT:    i32.select $push3=, $3, $7, $pop2
; NO-SIMD128-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-NEXT:    i32.gt_s $push4=, $2, $6
; NO-SIMD128-NEXT:    i32.select $push5=, $2, $6, $pop4
; NO-SIMD128-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-NEXT:    i32.gt_s $push6=, $1, $5
; NO-SIMD128-NEXT:    i32.select $push7=, $1, $5, $pop6
; NO-SIMD128-NEXT:    i32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_s_v4i32:
; NO-SIMD128-FAST:         .functype max_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp sgt <4 x i32> %x, %y
  %a = select <4 x i1> %c, <4 x i32> %x, <4 x i32> %y
  ret <4 x i32> %a
}

define <4 x i32> @max_u_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: max_u_v4i32:
; SIMD128:         .functype max_u_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.max_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_u_v4i32:
; SIMD128-FAST:         .functype max_u_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.max_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_u_v4i32:
; NO-SIMD128:         .functype max_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.gt_u $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.select $push1=, $4, $8, $pop0
; NO-SIMD128-NEXT:    i32.store 12($0), $pop1
; NO-SIMD128-NEXT:    i32.gt_u $push2=, $3, $7
; NO-SIMD128-NEXT:    i32.select $push3=, $3, $7, $pop2
; NO-SIMD128-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-NEXT:    i32.gt_u $push4=, $2, $6
; NO-SIMD128-NEXT:    i32.select $push5=, $2, $6, $pop4
; NO-SIMD128-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-NEXT:    i32.gt_u $push6=, $1, $5
; NO-SIMD128-NEXT:    i32.select $push7=, $1, $5, $pop6
; NO-SIMD128-NEXT:    i32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_u_v4i32:
; NO-SIMD128-FAST:         .functype max_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ugt <4 x i32> %x, %y
  %a = select <4 x i1> %c, <4 x i32> %x, <4 x i32> %y
  ret <4 x i32> %a
}

define <4 x i32> @abs_v4i32(<4 x i32> %x) {
; SIMD128-LABEL: abs_v4i32:
; SIMD128:         .functype abs_v4i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v4i32:
; SIMD128-FAST:         .functype abs_v4i32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v4i32:
; NO-SIMD128:         .functype abs_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 31
; NO-SIMD128-NEXT:    i32.shr_s $push19=, $4, $pop0
; NO-SIMD128-NEXT:    local.tee $push18=, $5=, $pop19
; NO-SIMD128-NEXT:    i32.xor $push1=, $4, $pop18
; NO-SIMD128-NEXT:    i32.sub $push2=, $pop1, $5
; NO-SIMD128-NEXT:    i32.store 12($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push17=, 31
; NO-SIMD128-NEXT:    i32.shr_s $push16=, $3, $pop17
; NO-SIMD128-NEXT:    local.tee $push15=, $4=, $pop16
; NO-SIMD128-NEXT:    i32.xor $push3=, $3, $pop15
; NO-SIMD128-NEXT:    i32.sub $push4=, $pop3, $4
; NO-SIMD128-NEXT:    i32.store 8($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push14=, 31
; NO-SIMD128-NEXT:    i32.shr_s $push13=, $2, $pop14
; NO-SIMD128-NEXT:    local.tee $push12=, $4=, $pop13
; NO-SIMD128-NEXT:    i32.xor $push5=, $2, $pop12
; NO-SIMD128-NEXT:    i32.sub $push6=, $pop5, $4
; NO-SIMD128-NEXT:    i32.store 4($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push11=, 31
; NO-SIMD128-NEXT:    i32.shr_s $push10=, $1, $pop11
; NO-SIMD128-NEXT:    local.tee $push9=, $4=, $pop10
; NO-SIMD128-NEXT:    i32.xor $push7=, $1, $pop9
; NO-SIMD128-NEXT:    i32.sub $push8=, $pop7, $4
; NO-SIMD128-NEXT:    i32.store 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v4i32:
; NO-SIMD128-FAST:         .functype abs_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 31
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push19=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push18=, $5=, $pop19
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop18
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $pop1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 31
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push16=, $2, $pop17
; NO-SIMD128-FAST-NEXT:    local.tee $push15=, $1=, $pop16
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $2, $pop15
; NO-SIMD128-FAST-NEXT:    i32.sub $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 31
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push13=, $3, $pop14
; NO-SIMD128-FAST-NEXT:    local.tee $push12=, $2=, $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $3, $pop12
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $pop5, $2
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, 31
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push10=, $4, $pop11
; NO-SIMD128-FAST-NEXT:    local.tee $push9=, $3=, $pop10
; NO-SIMD128-FAST-NEXT:    i32.xor $push7=, $4, $pop9
; NO-SIMD128-FAST-NEXT:    i32.sub $push8=, $pop7, $3
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <4 x i32> zeroinitializer, %x
  %b = icmp slt <4 x i32> %x, zeroinitializer
  %c = select <4 x i1> %b, <4 x i32> %a, <4 x i32> %x
  ret <4 x i32> %c
}

define <4 x i32> @neg_v4i32(<4 x i32> %x) {
; SIMD128-LABEL: neg_v4i32:
; SIMD128:         .functype neg_v4i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v4i32:
; SIMD128-FAST:         .functype neg_v4i32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v4i32:
; NO-SIMD128:         .functype neg_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 0
; NO-SIMD128-NEXT:    i32.sub $push1=, $pop0, $4
; NO-SIMD128-NEXT:    i32.store 12($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push7=, 0
; NO-SIMD128-NEXT:    i32.sub $push2=, $pop7, $3
; NO-SIMD128-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push6=, 0
; NO-SIMD128-NEXT:    i32.sub $push3=, $pop6, $2
; NO-SIMD128-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 0
; NO-SIMD128-NEXT:    i32.sub $push4=, $pop5, $1
; NO-SIMD128-NEXT:    i32.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v4i32:
; NO-SIMD128-FAST:         .functype neg_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $pop7, $2
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push6=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $pop6, $3
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push5=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push4=, $pop5, $4
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <4 x i32> <i32 0, i32 0, i32 0, i32 0>, %x
  ret <4 x i32> %a
}

define <4 x i32> @shl_v4i32(<4 x i32> %v, i32 %x) {
; SIMD128-LABEL: shl_v4i32:
; SIMD128:         .functype shl_v4i32 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.shl $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shl_v4i32:
; SIMD128-FAST:         .functype shl_v4i32 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.shl $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_v4i32:
; NO-SIMD128:         .functype shl_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shl $push0=, $4, $5
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.shl $push1=, $3, $5
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.shl $push2=, $2, $5
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.shl $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_v4i32:
; NO-SIMD128-FAST:         .functype shl_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shl $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $2, $5
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $3, $5
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $4, $5
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <4 x i32> undef, i32 %x, i32 0
  %s = shufflevector <4 x i32> %t, <4 x i32> undef,
    <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %a = shl <4 x i32> %v, %s
  ret <4 x i32> %a
}

define <4 x i32> @shl_const_v4i32(<4 x i32> %v) {
; SIMD128-LABEL: shl_const_v4i32:
; SIMD128:         .functype shl_const_v4i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i32x4.shl $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shl_const_v4i32:
; SIMD128-FAST:         .functype shl_const_v4i32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i32x4.shl $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_const_v4i32:
; NO-SIMD128:         .functype shl_const_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 5
; NO-SIMD128-NEXT:    i32.shl $push1=, $4, $pop0
; NO-SIMD128-NEXT:    i32.store 12($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push7=, 5
; NO-SIMD128-NEXT:    i32.shl $push2=, $3, $pop7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push6=, 5
; NO-SIMD128-NEXT:    i32.shl $push3=, $2, $pop6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 5
; NO-SIMD128-NEXT:    i32.shl $push4=, $1, $pop5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_const_v4i32:
; NO-SIMD128-FAST:         .functype shl_const_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $2, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push6=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $3, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push5=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push4=, $4, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <4 x i32> %v, <i32 5, i32 5, i32 5, i32 5>
  ret <4 x i32> %a
}

define <4 x i32> @shl_vec_v4i32(<4 x i32> %v, <4 x i32> %x) {
; SIMD128-LABEL: shl_vec_v4i32:
; SIMD128:         .functype shl_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i32.shl $push5=, $pop4, $pop3
; SIMD128-NEXT:    i32x4.splat $push6=, $pop5
; SIMD128-NEXT:    i32x4.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i32x4.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i32.shl $push2=, $pop1, $pop0
; SIMD128-NEXT:    i32x4.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    i32x4.extract_lane $push9=, $0, 2
; SIMD128-NEXT:    i32x4.extract_lane $push8=, $1, 2
; SIMD128-NEXT:    i32.shl $push10=, $pop9, $pop8
; SIMD128-NEXT:    i32x4.replace_lane $push11=, $pop7, 2, $pop10
; SIMD128-NEXT:    i32x4.extract_lane $push13=, $0, 3
; SIMD128-NEXT:    i32x4.extract_lane $push12=, $1, 3
; SIMD128-NEXT:    i32.shl $push14=, $pop13, $pop12
; SIMD128-NEXT:    i32x4.replace_lane $push15=, $pop11, 3, $pop14
; SIMD128-NEXT:    return $pop15
;
; SIMD128-FAST-LABEL: shl_vec_v4i32:
; SIMD128-FAST:         .functype shl_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i32.shl $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i32x4.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.shl $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push8=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push10=, $0, 2
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push9=, $1, 2
; SIMD128-FAST-NEXT:    i32.shl $push11=, $pop10, $pop9
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push12=, $pop8, 2, $pop11
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push14=, $0, 3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push13=, $1, 3
; SIMD128-FAST-NEXT:    i32.shl $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push0=, $pop12, 3, $pop15
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_vec_v4i32:
; NO-SIMD128:         .functype shl_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shl $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.shl $push1=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.shl $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.shl $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_vec_v4i32:
; NO-SIMD128-FAST:         .functype shl_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shl $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <4 x i32> %v, %x
  ret <4 x i32> %a
}

define <4 x i32> @shr_s_v4i32(<4 x i32> %v, i32 %x) {
; SIMD128-LABEL: shr_s_v4i32:
; SIMD128:         .functype shr_s_v4i32 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.shr_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_s_v4i32:
; SIMD128-FAST:         .functype shr_s_v4i32 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.shr_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_v4i32:
; NO-SIMD128:         .functype shr_s_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shr_s $push0=, $4, $5
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.shr_s $push1=, $3, $5
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.shr_s $push2=, $2, $5
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.shr_s $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_v4i32:
; NO-SIMD128-FAST:         .functype shr_s_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push1=, $2, $5
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push2=, $3, $5
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push3=, $4, $5
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <4 x i32> undef, i32 %x, i32 0
  %s = shufflevector <4 x i32> %t, <4 x i32> undef,
    <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %a = ashr <4 x i32> %v, %s
  ret <4 x i32> %a
}

define <4 x i32> @shr_s_vec_v4i32(<4 x i32> %v, <4 x i32> %x) {
; SIMD128-LABEL: shr_s_vec_v4i32:
; SIMD128:         .functype shr_s_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i32.shr_s $push5=, $pop4, $pop3
; SIMD128-NEXT:    i32x4.splat $push6=, $pop5
; SIMD128-NEXT:    i32x4.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i32x4.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i32.shr_s $push2=, $pop1, $pop0
; SIMD128-NEXT:    i32x4.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    i32x4.extract_lane $push9=, $0, 2
; SIMD128-NEXT:    i32x4.extract_lane $push8=, $1, 2
; SIMD128-NEXT:    i32.shr_s $push10=, $pop9, $pop8
; SIMD128-NEXT:    i32x4.replace_lane $push11=, $pop7, 2, $pop10
; SIMD128-NEXT:    i32x4.extract_lane $push13=, $0, 3
; SIMD128-NEXT:    i32x4.extract_lane $push12=, $1, 3
; SIMD128-NEXT:    i32.shr_s $push14=, $pop13, $pop12
; SIMD128-NEXT:    i32x4.replace_lane $push15=, $pop11, 3, $pop14
; SIMD128-NEXT:    return $pop15
;
; SIMD128-FAST-LABEL: shr_s_vec_v4i32:
; SIMD128-FAST:         .functype shr_s_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i32.shr_s $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i32x4.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.shr_s $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push8=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push10=, $0, 2
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push9=, $1, 2
; SIMD128-FAST-NEXT:    i32.shr_s $push11=, $pop10, $pop9
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push12=, $pop8, 2, $pop11
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push14=, $0, 3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push13=, $1, 3
; SIMD128-FAST-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push0=, $pop12, 3, $pop15
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_vec_v4i32:
; NO-SIMD128:         .functype shr_s_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shr_s $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.shr_s $push1=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.shr_s $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.shr_s $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_vec_v4i32:
; NO-SIMD128-FAST:         .functype shr_s_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = ashr <4 x i32> %v, %x
  ret <4 x i32> %a
}

define <4 x i32> @shr_u_v4i32(<4 x i32> %v, i32 %x) {
; SIMD128-LABEL: shr_u_v4i32:
; SIMD128:         .functype shr_u_v4i32 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.shr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_u_v4i32:
; SIMD128-FAST:         .functype shr_u_v4i32 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.shr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_v4i32:
; NO-SIMD128:         .functype shr_u_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shr_u $push0=, $4, $5
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.shr_u $push1=, $3, $5
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.shr_u $push2=, $2, $5
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.shr_u $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_v4i32:
; NO-SIMD128-FAST:         .functype shr_u_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push1=, $2, $5
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push2=, $3, $5
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push3=, $4, $5
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <4 x i32> undef, i32 %x, i32 0
  %s = shufflevector <4 x i32> %t, <4 x i32> undef,
    <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %a = lshr <4 x i32> %v, %s
  ret <4 x i32> %a
}

define <4 x i32> @shr_u_vec_v4i32(<4 x i32> %v, <4 x i32> %x) {
; SIMD128-LABEL: shr_u_vec_v4i32:
; SIMD128:         .functype shr_u_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i32.shr_u $push5=, $pop4, $pop3
; SIMD128-NEXT:    i32x4.splat $push6=, $pop5
; SIMD128-NEXT:    i32x4.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i32x4.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i32.shr_u $push2=, $pop1, $pop0
; SIMD128-NEXT:    i32x4.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    i32x4.extract_lane $push9=, $0, 2
; SIMD128-NEXT:    i32x4.extract_lane $push8=, $1, 2
; SIMD128-NEXT:    i32.shr_u $push10=, $pop9, $pop8
; SIMD128-NEXT:    i32x4.replace_lane $push11=, $pop7, 2, $pop10
; SIMD128-NEXT:    i32x4.extract_lane $push13=, $0, 3
; SIMD128-NEXT:    i32x4.extract_lane $push12=, $1, 3
; SIMD128-NEXT:    i32.shr_u $push14=, $pop13, $pop12
; SIMD128-NEXT:    i32x4.replace_lane $push15=, $pop11, 3, $pop14
; SIMD128-NEXT:    return $pop15
;
; SIMD128-FAST-LABEL: shr_u_vec_v4i32:
; SIMD128-FAST:         .functype shr_u_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i32x4.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.shr_u $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push8=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push10=, $0, 2
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push9=, $1, 2
; SIMD128-FAST-NEXT:    i32.shr_u $push11=, $pop10, $pop9
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push12=, $pop8, 2, $pop11
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push14=, $0, 3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push13=, $1, 3
; SIMD128-FAST-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push0=, $pop12, 3, $pop15
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_vec_v4i32:
; NO-SIMD128:         .functype shr_u_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shr_u $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.shr_u $push1=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.shr_u $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.shr_u $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_vec_v4i32:
; NO-SIMD128-FAST:         .functype shr_u_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = lshr <4 x i32> %v, %x
  ret <4 x i32> %a
}

define <4 x i32> @and_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: and_v4i32:
; SIMD128:         .functype and_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.and $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: and_v4i32:
; SIMD128-FAST:         .functype and_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: and_v4i32:
; NO-SIMD128:         .functype and_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.and $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.and $push1=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.and $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.and $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: and_v4i32:
; NO-SIMD128-FAST:         .functype and_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.and $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = and <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @or_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: or_v4i32:
; SIMD128:         .functype or_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.or $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: or_v4i32:
; SIMD128-FAST:         .functype or_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.or $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: or_v4i32:
; NO-SIMD128:         .functype or_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.or $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.or $push1=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.or $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.or $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: or_v4i32:
; NO-SIMD128-FAST:         .functype or_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.or $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.or $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.or $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.or $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = or <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @xor_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: xor_v4i32:
; SIMD128:         .functype xor_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: xor_v4i32:
; SIMD128-FAST:         .functype xor_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: xor_v4i32:
; NO-SIMD128:         .functype xor_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.store 12($0), $pop0
; NO-SIMD128-NEXT:    i32.xor $push1=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.xor $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.xor $push3=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: xor_v4i32:
; NO-SIMD128-FAST:         .functype xor_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @not_v4i32(<4 x i32> %x) {
; SIMD128-LABEL: not_v4i32:
; SIMD128:         .functype not_v4i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.not $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: not_v4i32:
; SIMD128-FAST:         .functype not_v4i32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: not_v4i32:
; NO-SIMD128:         .functype not_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $4, $pop0
; NO-SIMD128-NEXT:    i32.store 12($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push7=, -1
; NO-SIMD128-NEXT:    i32.xor $push2=, $3, $pop7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push6=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $2, $pop6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, -1
; NO-SIMD128-NEXT:    i32.xor $push4=, $1, $pop5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: not_v4i32:
; NO-SIMD128-FAST:         .functype not_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $2, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push6=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $3, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push5=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push4=, $4, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  ret <4 x i32> %a
}

define <4 x i32> @andnot_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: andnot_v4i32:
; SIMD128:         .functype andnot_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.andnot $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: andnot_v4i32:
; SIMD128-FAST:         .functype andnot_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $1
; SIMD128-FAST-NEXT:    v128.and $push1=, $0, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: andnot_v4i32:
; NO-SIMD128:         .functype andnot_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $8, $pop0
; NO-SIMD128-NEXT:    i32.and $push2=, $4, $pop1
; NO-SIMD128-NEXT:    i32.store 12($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push11=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $7, $pop11
; NO-SIMD128-NEXT:    i32.and $push4=, $3, $pop3
; NO-SIMD128-NEXT:    i32.store 8($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push10=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $6, $pop10
; NO-SIMD128-NEXT:    i32.and $push6=, $2, $pop5
; NO-SIMD128-NEXT:    i32.store 4($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push9=, -1
; NO-SIMD128-NEXT:    i32.xor $push7=, $5, $pop9
; NO-SIMD128-NEXT:    i32.and $push8=, $1, $pop7
; NO-SIMD128-NEXT:    i32.store 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: andnot_v4i32:
; NO-SIMD128-FAST:         .functype andnot_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $6, $pop11
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $7, $pop10
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $3, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push7=, $8, $pop9
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $4, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
 %inv_y = xor <4 x i32> %y, <i32 -1, i32 -1, i32 -1, i32 -1>
 %a = and <4 x i32> %x, %inv_y
 ret <4 x i32> %a
}

define <4 x i32> @bitselect_v4i32(<4 x i32> %c, <4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: bitselect_v4i32:
; SIMD128:         .functype bitselect_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_v4i32:
; SIMD128-FAST:         .functype bitselect_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop2, $2
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    v128.or $push1=, $pop3, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: bitselect_v4i32:
; NO-SIMD128:         .functype bitselect_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $8, $12
; NO-SIMD128-NEXT:    i32.and $push1=, $pop0, $4
; NO-SIMD128-NEXT:    i32.xor $push2=, $pop1, $12
; NO-SIMD128-NEXT:    i32.store 12($0), $pop2
; NO-SIMD128-NEXT:    i32.xor $push3=, $7, $11
; NO-SIMD128-NEXT:    i32.and $push4=, $pop3, $3
; NO-SIMD128-NEXT:    i32.xor $push5=, $pop4, $11
; NO-SIMD128-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-NEXT:    i32.xor $push6=, $6, $10
; NO-SIMD128-NEXT:    i32.and $push7=, $pop6, $2
; NO-SIMD128-NEXT:    i32.xor $push8=, $pop7, $10
; NO-SIMD128-NEXT:    i32.store 4($0), $pop8
; NO-SIMD128-NEXT:    i32.xor $push9=, $5, $9
; NO-SIMD128-NEXT:    i32.and $push10=, $pop9, $1
; NO-SIMD128-NEXT:    i32.xor $push11=, $pop10, $9
; NO-SIMD128-NEXT:    i32.store 0($0), $pop11
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_v4i32:
; NO-SIMD128-FAST:         .functype bitselect_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $5, $9
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $pop1, $9
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $6, $10
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $pop4, $10
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $7, $11
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $3
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $11
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $8, $12
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $pop9, $4
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $pop10, $12
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop11
; NO-SIMD128-FAST-NEXT:    return
  %masked_v1 = and <4 x i32> %c, %v1
  %inv_mask = xor <4 x i32> <i32 -1, i32 -1, i32 -1, i32 -1>, %c
  %masked_v2 = and <4 x i32> %inv_mask, %v2
  %a = or <4 x i32> %masked_v2, %masked_v1
  ret <4 x i32> %a
}

define <4 x i32> @bitselect_xor_v4i32(<4 x i32> %c, <4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: bitselect_xor_v4i32:
; SIMD128:         .functype bitselect_xor_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_v4i32:
; SIMD128-FAST:         .functype bitselect_xor_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push2=, $1, $2
; SIMD128-FAST-NEXT:    v128.and $push1=, $pop2, $0
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop1, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_v4i32:
; NO-SIMD128:         .functype bitselect_xor_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $8, $12
; NO-SIMD128-NEXT:    i32.and $push1=, $pop0, $4
; NO-SIMD128-NEXT:    i32.xor $push2=, $pop1, $12
; NO-SIMD128-NEXT:    i32.store 12($0), $pop2
; NO-SIMD128-NEXT:    i32.xor $push3=, $7, $11
; NO-SIMD128-NEXT:    i32.and $push4=, $pop3, $3
; NO-SIMD128-NEXT:    i32.xor $push5=, $pop4, $11
; NO-SIMD128-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-NEXT:    i32.xor $push6=, $6, $10
; NO-SIMD128-NEXT:    i32.and $push7=, $pop6, $2
; NO-SIMD128-NEXT:    i32.xor $push8=, $pop7, $10
; NO-SIMD128-NEXT:    i32.store 4($0), $pop8
; NO-SIMD128-NEXT:    i32.xor $push9=, $5, $9
; NO-SIMD128-NEXT:    i32.and $push10=, $pop9, $1
; NO-SIMD128-NEXT:    i32.xor $push11=, $pop10, $9
; NO-SIMD128-NEXT:    i32.store 0($0), $pop11
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_v4i32:
; NO-SIMD128-FAST:         .functype bitselect_xor_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $5, $9
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $pop1, $9
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $6, $10
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $pop4, $10
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $7, $11
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $3
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $11
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $8, $12
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $pop9, $4
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $pop10, $12
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop11
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <4 x i32> %v1, %v2
 %and = and <4 x i32> %xor1, %c
 %a = xor <4 x i32> %and, %v2
 ret <4 x i32> %a
}

define <4 x i32> @bitselect_xor_reversed_v4i32(<4 x i32> %c, <4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: bitselect_xor_reversed_v4i32:
; SIMD128:         .functype bitselect_xor_reversed_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $2, $1, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_reversed_v4i32:
; SIMD128-FAST:         .functype bitselect_xor_reversed_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push1=, $1, $2
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop1, $pop2
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop3, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_reversed_v4i32:
; NO-SIMD128:         .functype bitselect_xor_reversed_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push2=, $8, $12
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $4, $pop0
; NO-SIMD128-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.xor $push4=, $pop3, $12
; NO-SIMD128-NEXT:    i32.store 12($0), $pop4
; NO-SIMD128-NEXT:    i32.xor $push6=, $7, $11
; NO-SIMD128-NEXT:    i32.const $push19=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $3, $pop19
; NO-SIMD128-NEXT:    i32.and $push7=, $pop6, $pop5
; NO-SIMD128-NEXT:    i32.xor $push8=, $pop7, $11
; NO-SIMD128-NEXT:    i32.store 8($0), $pop8
; NO-SIMD128-NEXT:    i32.xor $push10=, $6, $10
; NO-SIMD128-NEXT:    i32.const $push18=, -1
; NO-SIMD128-NEXT:    i32.xor $push9=, $2, $pop18
; NO-SIMD128-NEXT:    i32.and $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.xor $push12=, $pop11, $10
; NO-SIMD128-NEXT:    i32.store 4($0), $pop12
; NO-SIMD128-NEXT:    i32.xor $push14=, $5, $9
; NO-SIMD128-NEXT:    i32.const $push17=, -1
; NO-SIMD128-NEXT:    i32.xor $push13=, $1, $pop17
; NO-SIMD128-NEXT:    i32.and $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.xor $push16=, $pop15, $9
; NO-SIMD128-NEXT:    i32.store 0($0), $pop16
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_reversed_v4i32:
; NO-SIMD128-FAST:         .functype bitselect_xor_reversed_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $5, $9
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push4=, $pop3, $9
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $6, $10
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $2, $pop19
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $10
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $7, $11
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $3, $pop18
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $pop11, $11
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $8, $12
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $4, $pop17
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $pop15, $12
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop16
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <4 x i32> %v1, %v2
 %notc = xor <4 x i32> %c, <i32 -1, i32 -1, i32 -1, i32 -1>
 %and = and <4 x i32> %xor1, %notc
 %a = xor <4 x i32> %and, %v2
 ret <4 x i32> %a
}

define <4 x i32> @extmul_low_s_v4i32(<8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: extmul_low_s_v4i32:
; SIMD128:         .functype extmul_low_s_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extmul_low_i16x8_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_s_v4i32:
; SIMD128-FAST:         .functype extmul_low_s_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extend_low_i16x8_s $push0=, $0
; SIMD128-FAST-NEXT:    i32x4.extend_low_i16x8_s $push1=, $1
; SIMD128-FAST-NEXT:    i32x4.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_s_v4i32:
; NO-SIMD128:         .functype extmul_low_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push1=, $4
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $12
; NO-SIMD128-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.store 12($0), $pop2
; NO-SIMD128-NEXT:    i32.extend16_s $push4=, $3
; NO-SIMD128-NEXT:    i32.extend16_s $push3=, $11
; NO-SIMD128-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-NEXT:    i32.extend16_s $push7=, $2
; NO-SIMD128-NEXT:    i32.extend16_s $push6=, $10
; NO-SIMD128-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop8
; NO-SIMD128-NEXT:    i32.extend16_s $push10=, $1
; NO-SIMD128-NEXT:    i32.extend16_s $push9=, $9
; NO-SIMD128-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.store 0($0), $pop11
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_s_v4i32:
; NO-SIMD128-FAST:         .functype extmul_low_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push0=, $9
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push4=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push3=, $10
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push7=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push6=, $11
; NO-SIMD128-FAST-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push10=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push9=, $12
; NO-SIMD128-FAST-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop11
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <8 x i16> %v1, <8 x i16> undef,
           <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %low2 = shufflevector <8 x i16> %v2, <8 x i16> undef,
           <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extended1 = sext <4 x i16> %low1 to <4 x i32>
  %extended2 = sext <4 x i16> %low2 to <4 x i32>
  %a = mul <4 x i32> %extended1, %extended2
  ret <4 x i32> %a
}

define <4 x i32> @extmul_high_s_v4i32(<8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: extmul_high_s_v4i32:
; SIMD128:         .functype extmul_high_s_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extmul_high_i16x8_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_s_v4i32:
; SIMD128-FAST:         .functype extmul_high_s_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extend_high_i16x8_s $push0=, $0
; SIMD128-FAST-NEXT:    i32x4.extend_high_i16x8_s $push1=, $1
; SIMD128-FAST-NEXT:    i32x4.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_s_v4i32:
; NO-SIMD128:         .functype extmul_high_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push1=, $8
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $16
; NO-SIMD128-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.store 12($0), $pop2
; NO-SIMD128-NEXT:    i32.extend16_s $push4=, $7
; NO-SIMD128-NEXT:    i32.extend16_s $push3=, $15
; NO-SIMD128-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-NEXT:    i32.extend16_s $push7=, $6
; NO-SIMD128-NEXT:    i32.extend16_s $push6=, $14
; NO-SIMD128-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop8
; NO-SIMD128-NEXT:    i32.extend16_s $push10=, $5
; NO-SIMD128-NEXT:    i32.extend16_s $push9=, $13
; NO-SIMD128-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.store 0($0), $pop11
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_s_v4i32:
; NO-SIMD128-FAST:         .functype extmul_high_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push1=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push0=, $13
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push4=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push3=, $14
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push7=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push6=, $15
; NO-SIMD128-FAST-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push10=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push9=, $16
; NO-SIMD128-FAST-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop11
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <8 x i16> %v1, <8 x i16> undef,
           <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %high2 = shufflevector <8 x i16> %v2, <8 x i16> undef,
           <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %extended1 = sext <4 x i16> %high1 to <4 x i32>
  %extended2 = sext <4 x i16> %high2 to <4 x i32>
  %a = mul <4 x i32> %extended1, %extended2
  ret <4 x i32> %a
}

define <4 x i32> @extmul_low_u_v4i32(<8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: extmul_low_u_v4i32:
; SIMD128:         .functype extmul_low_u_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extmul_low_i16x8_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_u_v4i32:
; SIMD128-FAST:         .functype extmul_low_u_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extend_low_i16x8_u $push0=, $0
; SIMD128-FAST-NEXT:    i32x4.extend_low_i16x8_u $push1=, $1
; SIMD128-FAST-NEXT:    i32x4.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_u_v4i32:
; NO-SIMD128:         .functype extmul_low_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push2=, $4, $pop0
; NO-SIMD128-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $12, $pop19
; NO-SIMD128-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $3, $pop18
; NO-SIMD128-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-NEXT:    i32.and $push4=, $11, $pop17
; NO-SIMD128-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store 8($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push16=, 65535
; NO-SIMD128-NEXT:    i32.and $push8=, $2, $pop16
; NO-SIMD128-NEXT:    i32.const $push15=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $10, $pop15
; NO-SIMD128-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store 4($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push14=, 65535
; NO-SIMD128-NEXT:    i32.and $push11=, $1, $pop14
; NO-SIMD128-NEXT:    i32.const $push13=, 65535
; NO-SIMD128-NEXT:    i32.and $push10=, $9, $pop13
; NO-SIMD128-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store 0($0), $pop12
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_u_v4i32:
; NO-SIMD128-FAST:         .functype extmul_low_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop19
; NO-SIMD128-FAST-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $2, $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $10, $pop17
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push16=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $3, $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push15=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $11, $pop15
; NO-SIMD128-FAST-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $4, $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $12, $pop13
; NO-SIMD128-FAST-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop12
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <8 x i16> %v1, <8 x i16> undef,
           <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %low2 = shufflevector <8 x i16> %v2, <8 x i16> undef,
           <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extended1 = zext <4 x i16> %low1 to <4 x i32>
  %extended2 = zext <4 x i16> %low2 to <4 x i32>
  %a = mul <4 x i32> %extended1, %extended2
  ret <4 x i32> %a
}

define <4 x i32> @extmul_high_u_v4i32(<8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: extmul_high_u_v4i32:
; SIMD128:         .functype extmul_high_u_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extmul_high_i16x8_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_u_v4i32:
; SIMD128-FAST:         .functype extmul_high_u_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extend_high_i16x8_u $push0=, $0
; SIMD128-FAST-NEXT:    i32x4.extend_high_i16x8_u $push1=, $1
; SIMD128-FAST-NEXT:    i32x4.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_u_v4i32:
; NO-SIMD128:         .functype extmul_high_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push2=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop19
; NO-SIMD128-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $7, $pop18
; NO-SIMD128-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-NEXT:    i32.and $push4=, $15, $pop17
; NO-SIMD128-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store 8($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push16=, 65535
; NO-SIMD128-NEXT:    i32.and $push8=, $6, $pop16
; NO-SIMD128-NEXT:    i32.const $push15=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $14, $pop15
; NO-SIMD128-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store 4($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push14=, 65535
; NO-SIMD128-NEXT:    i32.and $push11=, $5, $pop14
; NO-SIMD128-NEXT:    i32.const $push13=, 65535
; NO-SIMD128-NEXT:    i32.and $push10=, $13, $pop13
; NO-SIMD128-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store 0($0), $pop12
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_u_v4i32:
; NO-SIMD128-FAST:         .functype extmul_high_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $13, $pop19
; NO-SIMD128-FAST-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $6, $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $14, $pop17
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push16=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $7, $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push15=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $15, $pop15
; NO-SIMD128-FAST-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $8, $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $16, $pop13
; NO-SIMD128-FAST-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop12
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <8 x i16> %v1, <8 x i16> undef,
           <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %high2 = shufflevector <8 x i16> %v2, <8 x i16> undef,
           <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %extended1 = zext <4 x i16> %high1 to <4 x i32>
  %extended2 = zext <4 x i16> %high2 to <4 x i32>
  %a = mul <4 x i32> %extended1, %extended2
  ret <4 x i32> %a
}

; ==============================================================================
; 2 x i64
; ==============================================================================
define <2 x i64> @add_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: add_v2i64:
; SIMD128:         .functype add_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v2i64:
; SIMD128-FAST:         .functype add_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v2i64:
; NO-SIMD128:         .functype add_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.add $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.add $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v2i64:
; NO-SIMD128-FAST:         .functype add_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.add $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.add $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = add <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @sub_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: sub_v2i64:
; SIMD128:         .functype sub_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v2i64:
; SIMD128-FAST:         .functype sub_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v2i64:
; NO-SIMD128:         .functype sub_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.sub $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.sub $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v2i64:
; NO-SIMD128-FAST:         .functype sub_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.sub $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.sub $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @mul_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: mul_v2i64:
; SIMD128:         .functype mul_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.mul $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: mul_v2i64:
; SIMD128-FAST:         .functype mul_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.mul $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v2i64:
; NO-SIMD128:         .functype mul_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.mul $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.mul $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v2i64:
; NO-SIMD128-FAST:         .functype mul_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.mul $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.mul $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = mul <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @abs_v2i64(<2 x i64> %x) {
; SIMD128-LABEL: abs_v2i64:
; SIMD128:         .functype abs_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v2i64:
; SIMD128-FAST:         .functype abs_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v2i64:
; NO-SIMD128:         .functype abs_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 63
; NO-SIMD128-NEXT:    i64.shr_s $push9=, $2, $pop0
; NO-SIMD128-NEXT:    local.tee $push8=, $3=, $pop9
; NO-SIMD128-NEXT:    i64.xor $push1=, $2, $pop8
; NO-SIMD128-NEXT:    i64.sub $push2=, $pop1, $3
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.const $push7=, 63
; NO-SIMD128-NEXT:    i64.shr_s $push6=, $1, $pop7
; NO-SIMD128-NEXT:    local.tee $push5=, $2=, $pop6
; NO-SIMD128-NEXT:    i64.xor $push3=, $1, $pop5
; NO-SIMD128-NEXT:    i64.sub $push4=, $pop3, $2
; NO-SIMD128-NEXT:    i64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v2i64:
; NO-SIMD128-FAST:         .functype abs_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 63
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push9=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push8=, $3=, $pop9
; NO-SIMD128-FAST-NEXT:    i64.xor $push1=, $1, $pop8
; NO-SIMD128-FAST-NEXT:    i64.sub $push2=, $pop1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.const $push7=, 63
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push6=, $2, $pop7
; NO-SIMD128-FAST-NEXT:    local.tee $push5=, $1=, $pop6
; NO-SIMD128-FAST-NEXT:    i64.xor $push3=, $2, $pop5
; NO-SIMD128-FAST-NEXT:    i64.sub $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <2 x i64> zeroinitializer, %x
  %b = icmp slt <2 x i64> %x, zeroinitializer
  %c = select <2 x i1> %b, <2 x i64> %a, <2 x i64> %x
  ret <2 x i64> %c
}

define <2 x i64> @neg_v2i64(<2 x i64> %x) {
; SIMD128-LABEL: neg_v2i64:
; SIMD128:         .functype neg_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v2i64:
; SIMD128-FAST:         .functype neg_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v2i64:
; NO-SIMD128:         .functype neg_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 0
; NO-SIMD128-NEXT:    i64.sub $push1=, $pop0, $2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-NEXT:    i64.const $push3=, 0
; NO-SIMD128-NEXT:    i64.sub $push2=, $pop3, $1
; NO-SIMD128-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v2i64:
; NO-SIMD128-FAST:         .functype neg_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 0
; NO-SIMD128-FAST-NEXT:    i64.sub $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i64.const $push3=, 0
; NO-SIMD128-FAST-NEXT:    i64.sub $push2=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <2 x i64> <i64 0, i64 0>, %x
  ret <2 x i64> %a
}

define <2 x i64> @shl_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shl_v2i64:
; SIMD128:         .functype shl_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shl $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shl_v2i64:
; SIMD128-FAST:         .functype shl_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shl $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_v2i64:
; NO-SIMD128:         .functype shl_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shl $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shl $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_v2i64:
; NO-SIMD128-FAST:         .functype shl_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shl $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shl $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = zext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = shl <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shl_sext_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shl_sext_v2i64:
; SIMD128:         .functype shl_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shl $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shl_sext_v2i64:
; SIMD128-FAST:         .functype shl_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shl $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_sext_v2i64:
; NO-SIMD128:         .functype shl_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shl $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shl $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_sext_v2i64:
; NO-SIMD128-FAST:         .functype shl_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shl $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shl $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = sext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = shl <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shl_noext_v2i64(<2 x i64> %v, i64 %x) {
; SIMD128-LABEL: shl_noext_v2i64:
; SIMD128:         .functype shl_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.wrap_i64 $push0=, $1
; SIMD128-NEXT:    i64x2.shl $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shl_noext_v2i64:
; SIMD128-FAST:         .functype shl_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.wrap_i64 $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.shl $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_noext_v2i64:
; NO-SIMD128:         .functype shl_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shl $push0=, $2, $3
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shl $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_noext_v2i64:
; NO-SIMD128-FAST:         .functype shl_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shl $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shl $push1=, $2, $3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <2 x i64> undef, i64 %x, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = shl <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shl_const_v2i64(<2 x i64> %v) {
; SIMD128-LABEL: shl_const_v2i64:
; SIMD128:         .functype shl_const_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i64x2.shl $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shl_const_v2i64:
; SIMD128-FAST:         .functype shl_const_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i64x2.shl $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_const_v2i64:
; NO-SIMD128:         .functype shl_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 5
; NO-SIMD128-NEXT:    i64.shl $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-NEXT:    i64.const $push3=, 5
; NO-SIMD128-NEXT:    i64.shl $push2=, $1, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_const_v2i64:
; NO-SIMD128-FAST:         .functype shl_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i64.shl $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i64.const $push3=, 5
; NO-SIMD128-FAST-NEXT:    i64.shl $push2=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <2 x i64> %v, <i64 5, i64 5>
  ret <2 x i64> %a
}

define <2 x i64> @shl_vec_v2i64(<2 x i64> %v, <2 x i64> %x) {
; SIMD128-LABEL: shl_vec_v2i64:
; SIMD128:         .functype shl_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i64x2.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i64.shl $push5=, $pop4, $pop3
; SIMD128-NEXT:    i64x2.splat $push6=, $pop5
; SIMD128-NEXT:    i64x2.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i64x2.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i64.shl $push2=, $pop1, $pop0
; SIMD128-NEXT:    i64x2.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    return $pop7
;
; SIMD128-FAST-LABEL: shl_vec_v2i64:
; SIMD128-FAST:         .functype shl_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i64.shl $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i64x2.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i64.shl $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i64x2.replace_lane $push0=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_vec_v2i64:
; NO-SIMD128:         .functype shl_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shl $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shl $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_vec_v2i64:
; NO-SIMD128-FAST:         .functype shl_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shl $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shl $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <2 x i64> %v, %x
  ret <2 x i64> %a
}

define <2 x i64> @shr_s_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shr_s_v2i64:
; SIMD128:         .functype shr_s_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shr_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_s_v2i64:
; SIMD128-FAST:         .functype shr_s_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shr_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_v2i64:
; NO-SIMD128:         .functype shr_s_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shr_s $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_s $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_v2i64:
; NO-SIMD128-FAST:         .functype shr_s_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = zext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = ashr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_s_sext_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shr_s_sext_v2i64:
; SIMD128:         .functype shr_s_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shr_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_s_sext_v2i64:
; SIMD128-FAST:         .functype shr_s_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shr_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_sext_v2i64:
; NO-SIMD128:         .functype shr_s_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shr_s $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_s $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_sext_v2i64:
; NO-SIMD128-FAST:         .functype shr_s_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = sext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = ashr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_s_noext_v2i64(<2 x i64> %v, i64 %x) {
; SIMD128-LABEL: shr_s_noext_v2i64:
; SIMD128:         .functype shr_s_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.wrap_i64 $push0=, $1
; SIMD128-NEXT:    i64x2.shr_s $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shr_s_noext_v2i64:
; SIMD128-FAST:         .functype shr_s_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.wrap_i64 $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.shr_s $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_noext_v2i64:
; NO-SIMD128:         .functype shr_s_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shr_s $push0=, $2, $3
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_s $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_noext_v2i64:
; NO-SIMD128-FAST:         .functype shr_s_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push1=, $2, $3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <2 x i64> undef, i64 %x, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = ashr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_s_const_v2i64(<2 x i64> %v) {
; SIMD128-LABEL: shr_s_const_v2i64:
; SIMD128:         .functype shr_s_const_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i64x2.shr_s $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shr_s_const_v2i64:
; SIMD128-FAST:         .functype shr_s_const_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i64x2.shr_s $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_const_v2i64:
; NO-SIMD128:         .functype shr_s_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 5
; NO-SIMD128-NEXT:    i64.shr_s $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-NEXT:    i64.const $push3=, 5
; NO-SIMD128-NEXT:    i64.shr_s $push2=, $1, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_const_v2i64:
; NO-SIMD128-FAST:         .functype shr_s_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i64.const $push3=, 5
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push2=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    return
  %a = ashr <2 x i64> %v, <i64 5, i64 5>
  ret <2 x i64> %a
}

define <2 x i64> @shr_s_vec_v2i64(<2 x i64> %v, <2 x i64> %x) {
; SIMD128-LABEL: shr_s_vec_v2i64:
; SIMD128:         .functype shr_s_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i64x2.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i64.shr_s $push5=, $pop4, $pop3
; SIMD128-NEXT:    i64x2.splat $push6=, $pop5
; SIMD128-NEXT:    i64x2.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i64x2.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i64.shr_s $push2=, $pop1, $pop0
; SIMD128-NEXT:    i64x2.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    return $pop7
;
; SIMD128-FAST-LABEL: shr_s_vec_v2i64:
; SIMD128-FAST:         .functype shr_s_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i64.shr_s $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i64x2.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i64.shr_s $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i64x2.replace_lane $push0=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_vec_v2i64:
; NO-SIMD128:         .functype shr_s_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shr_s $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_s $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_vec_v2i64:
; NO-SIMD128-FAST:         .functype shr_s_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = ashr <2 x i64> %v, %x
  ret <2 x i64> %a
}

define <2 x i64> @shr_u_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shr_u_v2i64:
; SIMD128:         .functype shr_u_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_u_v2i64:
; SIMD128-FAST:         .functype shr_u_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_v2i64:
; NO-SIMD128:         .functype shr_u_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shr_u $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_u $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_v2i64:
; NO-SIMD128-FAST:         .functype shr_u_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = zext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = lshr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_u_sext_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shr_u_sext_v2i64:
; SIMD128:         .functype shr_u_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_u_sext_v2i64:
; SIMD128-FAST:         .functype shr_u_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_sext_v2i64:
; NO-SIMD128:         .functype shr_u_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shr_u $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_u $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_sext_v2i64:
; NO-SIMD128-FAST:         .functype shr_u_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = sext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = lshr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_u_noext_v2i64(<2 x i64> %v, i64 %x) {
; SIMD128-LABEL: shr_u_noext_v2i64:
; SIMD128:         .functype shr_u_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.wrap_i64 $push0=, $1
; SIMD128-NEXT:    i64x2.shr_u $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shr_u_noext_v2i64:
; SIMD128-FAST:         .functype shr_u_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.wrap_i64 $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.shr_u $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_noext_v2i64:
; NO-SIMD128:         .functype shr_u_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shr_u $push0=, $2, $3
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_u $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_noext_v2i64:
; NO-SIMD128-FAST:         .functype shr_u_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push1=, $2, $3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <2 x i64> undef, i64 %x, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = lshr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_u_const_v2i64(<2 x i64> %v) {
; SIMD128-LABEL: shr_u_const_v2i64:
; SIMD128:         .functype shr_u_const_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i64x2.shr_u $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shr_u_const_v2i64:
; SIMD128-FAST:         .functype shr_u_const_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i64x2.shr_u $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_const_v2i64:
; NO-SIMD128:         .functype shr_u_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 5
; NO-SIMD128-NEXT:    i64.shr_u $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-NEXT:    i64.const $push3=, 5
; NO-SIMD128-NEXT:    i64.shr_u $push2=, $1, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_const_v2i64:
; NO-SIMD128-FAST:         .functype shr_u_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i64.const $push3=, 5
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push2=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    return
  %a = lshr <2 x i64> %v, <i64 5, i64 5>
  ret <2 x i64> %a
}

define <2 x i64> @shr_u_vec_v2i64(<2 x i64> %v, <2 x i64> %x) {
; SIMD128-LABEL: shr_u_vec_v2i64:
; SIMD128:         .functype shr_u_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i64x2.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i64.shr_u $push5=, $pop4, $pop3
; SIMD128-NEXT:    i64x2.splat $push6=, $pop5
; SIMD128-NEXT:    i64x2.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i64x2.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i64.shr_u $push2=, $pop1, $pop0
; SIMD128-NEXT:    i64x2.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    return $pop7
;
; SIMD128-FAST-LABEL: shr_u_vec_v2i64:
; SIMD128-FAST:         .functype shr_u_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i64.shr_u $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i64x2.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i64.shr_u $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i64x2.replace_lane $push0=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_vec_v2i64:
; NO-SIMD128:         .functype shr_u_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shr_u $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_u $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_vec_v2i64:
; NO-SIMD128-FAST:         .functype shr_u_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = lshr <2 x i64> %v, %x
  ret <2 x i64> %a
}

define <2 x i64> @and_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: and_v2i64:
; SIMD128:         .functype and_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.and $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: and_v2i64:
; SIMD128-FAST:         .functype and_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: and_v2i64:
; NO-SIMD128:         .functype and_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.and $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.and $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: and_v2i64:
; NO-SIMD128-FAST:         .functype and_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.and $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.and $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = and <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @or_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: or_v2i64:
; SIMD128:         .functype or_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.or $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: or_v2i64:
; SIMD128-FAST:         .functype or_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.or $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: or_v2i64:
; NO-SIMD128:         .functype or_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.or $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.or $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: or_v2i64:
; NO-SIMD128-FAST:         .functype or_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.or $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.or $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = or <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @xor_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: xor_v2i64:
; SIMD128:         .functype xor_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: xor_v2i64:
; SIMD128-FAST:         .functype xor_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: xor_v2i64:
; NO-SIMD128:         .functype xor_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.xor $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.xor $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: xor_v2i64:
; NO-SIMD128-FAST:         .functype xor_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.xor $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.xor $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @not_v2i64(<2 x i64> %x) {
; SIMD128-LABEL: not_v2i64:
; SIMD128:         .functype not_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.not $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: not_v2i64:
; SIMD128-FAST:         .functype not_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: not_v2i64:
; NO-SIMD128:         .functype not_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, -1
; NO-SIMD128-NEXT:    i64.xor $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-NEXT:    i64.const $push3=, -1
; NO-SIMD128-NEXT:    i64.xor $push2=, $1, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: not_v2i64:
; NO-SIMD128-FAST:         .functype not_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i64.const $push3=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push2=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <2 x i64> %x, <i64 -1, i64 -1>
  ret <2 x i64> %a
}

define <2 x i64> @andnot_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: andnot_v2i64:
; SIMD128:         .functype andnot_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.andnot $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: andnot_v2i64:
; SIMD128-FAST:         .functype andnot_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $1
; SIMD128-FAST-NEXT:    v128.and $push1=, $0, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: andnot_v2i64:
; NO-SIMD128:         .functype andnot_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, -1
; NO-SIMD128-NEXT:    i64.xor $push1=, $4, $pop0
; NO-SIMD128-NEXT:    i64.and $push2=, $2, $pop1
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.const $push5=, -1
; NO-SIMD128-NEXT:    i64.xor $push3=, $3, $pop5
; NO-SIMD128-NEXT:    i64.and $push4=, $1, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: andnot_v2i64:
; NO-SIMD128-FAST:         .functype andnot_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push1=, $3, $pop0
; NO-SIMD128-FAST-NEXT:    i64.and $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.const $push5=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push3=, $4, $pop5
; NO-SIMD128-FAST-NEXT:    i64.and $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
 %inv_y = xor <2 x i64> %y, <i64 -1, i64 -1>
 %a = and <2 x i64> %x, %inv_y
 ret <2 x i64> %a
}

define <2 x i64> @bitselect_v2i64(<2 x i64> %c, <2 x i64> %v1, <2 x i64> %v2) {
; SIMD128-LABEL: bitselect_v2i64:
; SIMD128:         .functype bitselect_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_v2i64:
; SIMD128-FAST:         .functype bitselect_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $2, $pop2
; SIMD128-FAST-NEXT:    v128.and $push0=, $1, $0
; SIMD128-FAST-NEXT:    v128.or $push1=, $pop3, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: bitselect_v2i64:
; NO-SIMD128:         .functype bitselect_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.xor $push0=, $4, $6
; NO-SIMD128-NEXT:    i64.and $push1=, $pop0, $2
; NO-SIMD128-NEXT:    i64.xor $push2=, $pop1, $6
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.xor $push3=, $3, $5
; NO-SIMD128-NEXT:    i64.and $push4=, $pop3, $1
; NO-SIMD128-NEXT:    i64.xor $push5=, $pop4, $5
; NO-SIMD128-NEXT:    i64.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_v2i64:
; NO-SIMD128-FAST:         .functype bitselect_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.xor $push0=, $3, $5
; NO-SIMD128-FAST-NEXT:    i64.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i64.xor $push2=, $pop1, $5
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.xor $push3=, $4, $6
; NO-SIMD128-FAST-NEXT:    i64.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i64.xor $push5=, $pop4, $6
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %masked_v1 = and <2 x i64> %v1, %c
  %inv_mask = xor <2 x i64> <i64 -1, i64 -1>, %c
  %masked_v2 = and <2 x i64> %v2, %inv_mask
  %a = or <2 x i64> %masked_v2, %masked_v1
  ret <2 x i64> %a
}

define <2 x i64> @bitselect_xor_v2i64(<2 x i64> %c, <2 x i64> %v1, <2 x i64> %v2) {
; SIMD128-LABEL: bitselect_xor_v2i64:
; SIMD128:         .functype bitselect_xor_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_v2i64:
; SIMD128-FAST:         .functype bitselect_xor_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push2=, $1, $2
; SIMD128-FAST-NEXT:    v128.and $push1=, $pop2, $0
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop1, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_v2i64:
; NO-SIMD128:         .functype bitselect_xor_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.xor $push0=, $4, $6
; NO-SIMD128-NEXT:    i64.and $push1=, $pop0, $2
; NO-SIMD128-NEXT:    i64.xor $push2=, $pop1, $6
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.xor $push3=, $3, $5
; NO-SIMD128-NEXT:    i64.and $push4=, $pop3, $1
; NO-SIMD128-NEXT:    i64.xor $push5=, $pop4, $5
; NO-SIMD128-NEXT:    i64.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_v2i64:
; NO-SIMD128-FAST:         .functype bitselect_xor_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.xor $push0=, $3, $5
; NO-SIMD128-FAST-NEXT:    i64.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i64.xor $push2=, $pop1, $5
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.xor $push3=, $4, $6
; NO-SIMD128-FAST-NEXT:    i64.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i64.xor $push5=, $pop4, $6
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <2 x i64> %v1, %v2
 %and = and <2 x i64> %xor1, %c
 %a = xor <2 x i64> %and, %v2
 ret <2 x i64> %a
}

define <2 x i64> @bitselect_xor_reversed_v2i64(<2 x i64> %c, <2 x i64> %v1, <2 x i64> %v2) {
; SIMD128-LABEL: bitselect_xor_reversed_v2i64:
; SIMD128:         .functype bitselect_xor_reversed_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $2, $1, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_reversed_v2i64:
; SIMD128-FAST:         .functype bitselect_xor_reversed_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push1=, $1, $2
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop1, $pop2
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop3, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_reversed_v2i64:
; NO-SIMD128:         .functype bitselect_xor_reversed_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.xor $push2=, $4, $6
; NO-SIMD128-NEXT:    i64.const $push0=, -1
; NO-SIMD128-NEXT:    i64.xor $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i64.and $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i64.xor $push4=, $pop3, $6
; NO-SIMD128-NEXT:    i64.store 8($0), $pop4
; NO-SIMD128-NEXT:    i64.xor $push6=, $3, $5
; NO-SIMD128-NEXT:    i64.const $push9=, -1
; NO-SIMD128-NEXT:    i64.xor $push5=, $1, $pop9
; NO-SIMD128-NEXT:    i64.and $push7=, $pop6, $pop5
; NO-SIMD128-NEXT:    i64.xor $push8=, $pop7, $5
; NO-SIMD128-NEXT:    i64.store 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_reversed_v2i64:
; NO-SIMD128-FAST:         .functype bitselect_xor_reversed_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.xor $push2=, $3, $5
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.and $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i64.xor $push4=, $pop3, $5
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i64.xor $push6=, $4, $6
; NO-SIMD128-FAST-NEXT:    i64.const $push9=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push5=, $2, $pop9
; NO-SIMD128-FAST-NEXT:    i64.and $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i64.xor $push8=, $pop7, $6
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <2 x i64> %v1, %v2
 %notc = xor <2 x i64> %c, <i64 -1, i64 -1>
 %and = and <2 x i64> %xor1, %notc
 %a = xor <2 x i64> %and, %v2
 ret <2 x i64> %a
}

define <2 x i64> @extmul_low_s_v2i64(<4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: extmul_low_s_v2i64:
; SIMD128:         .functype extmul_low_s_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extmul_low_i32x4_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_s_v2i64:
; SIMD128-FAST:         .functype extmul_low_s_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extend_low_i32x4_s $push0=, $0
; SIMD128-FAST-NEXT:    i64x2.extend_low_i32x4_s $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_s_v2i64:
; NO-SIMD128:         .functype extmul_low_s_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_s $push1=, $2
; NO-SIMD128-NEXT:    i64.extend_i32_s $push0=, $6
; NO-SIMD128-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.extend_i32_s $push4=, $1
; NO-SIMD128-NEXT:    i64.extend_i32_s $push3=, $5
; NO-SIMD128-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_s_v2i64:
; NO-SIMD128-FAST:         .functype extmul_low_s_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push0=, $5
; NO-SIMD128-FAST-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push4=, $2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push3=, $6
; NO-SIMD128-FAST-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <4 x i32> %v1, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %low2 = shufflevector <4 x i32> %v2, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %extended1 = sext <2 x i32> %low1 to <2 x i64>
  %extended2 = sext <2 x i32> %low2 to <2 x i64>
  %a = mul <2 x i64> %extended1, %extended2
  ret <2 x i64> %a
}

define <2 x i64> @extmul_high_s_v2i64(<4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: extmul_high_s_v2i64:
; SIMD128:         .functype extmul_high_s_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extmul_high_i32x4_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_s_v2i64:
; SIMD128-FAST:         .functype extmul_high_s_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extend_high_i32x4_s $push0=, $0
; SIMD128-FAST-NEXT:    i64x2.extend_high_i32x4_s $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_s_v2i64:
; NO-SIMD128:         .functype extmul_high_s_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_s $push1=, $4
; NO-SIMD128-NEXT:    i64.extend_i32_s $push0=, $8
; NO-SIMD128-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.extend_i32_s $push4=, $3
; NO-SIMD128-NEXT:    i64.extend_i32_s $push3=, $7
; NO-SIMD128-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_s_v2i64:
; NO-SIMD128-FAST:         .functype extmul_high_s_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push1=, $3
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push0=, $7
; NO-SIMD128-FAST-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push4=, $4
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push3=, $8
; NO-SIMD128-FAST-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <4 x i32> %v1, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %high2 = shufflevector <4 x i32> %v2, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %extended1 = sext <2 x i32> %high1 to <2 x i64>
  %extended2 = sext <2 x i32> %high2 to <2 x i64>
  %a = mul <2 x i64> %extended1, %extended2
  ret <2 x i64> %a
}

define <2 x i64> @extmul_low_u_v2i64(<4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: extmul_low_u_v2i64:
; SIMD128:         .functype extmul_low_u_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extmul_low_i32x4_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_u_v2i64:
; SIMD128-FAST:         .functype extmul_low_u_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extend_low_i32x4_u $push0=, $0
; SIMD128-FAST-NEXT:    i64x2.extend_low_i32x4_u $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_u_v2i64:
; NO-SIMD128:         .functype extmul_low_u_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_u $push1=, $2
; NO-SIMD128-NEXT:    i64.extend_i32_u $push0=, $6
; NO-SIMD128-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.extend_i32_u $push4=, $1
; NO-SIMD128-NEXT:    i64.extend_i32_u $push3=, $5
; NO-SIMD128-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_u_v2i64:
; NO-SIMD128-FAST:         .functype extmul_low_u_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push1=, $1
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push0=, $5
; NO-SIMD128-FAST-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push4=, $2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push3=, $6
; NO-SIMD128-FAST-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <4 x i32> %v1, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %low2 = shufflevector <4 x i32> %v2, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %extended1 = zext <2 x i32> %low1 to <2 x i64>
  %extended2 = zext <2 x i32> %low2 to <2 x i64>
  %a = mul <2 x i64> %extended1, %extended2
  ret <2 x i64> %a
}

define <2 x i64> @extmul_high_u_v2i64(<4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: extmul_high_u_v2i64:
; SIMD128:         .functype extmul_high_u_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extmul_high_i32x4_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_u_v2i64:
; SIMD128-FAST:         .functype extmul_high_u_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extend_high_i32x4_u $push0=, $0
; SIMD128-FAST-NEXT:    i64x2.extend_high_i32x4_u $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_u_v2i64:
; NO-SIMD128:         .functype extmul_high_u_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_u $push1=, $4
; NO-SIMD128-NEXT:    i64.extend_i32_u $push0=, $8
; NO-SIMD128-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.extend_i32_u $push4=, $3
; NO-SIMD128-NEXT:    i64.extend_i32_u $push3=, $7
; NO-SIMD128-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_u_v2i64:
; NO-SIMD128-FAST:         .functype extmul_high_u_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push1=, $3
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push0=, $7
; NO-SIMD128-FAST-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push4=, $4
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push3=, $8
; NO-SIMD128-FAST-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <4 x i32> %v1, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %high2 = shufflevector <4 x i32> %v2, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %extended1 = zext <2 x i32> %high1 to <2 x i64>
  %extended2 = zext <2 x i32> %high2 to <2 x i64>
  %a = mul <2 x i64> %extended1, %extended2
  ret <2 x i64> %a
}

; ==============================================================================
; 4 x float
; ==============================================================================
define <4 x float> @neg_v4f32(<4 x float> %x) {
  ; nsz makes this semantically equivalent to flipping sign bit
; SIMD128-LABEL: neg_v4f32:
; SIMD128:         .functype neg_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v4f32:
; SIMD128-FAST:         .functype neg_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v4f32:
; NO-SIMD128:         .functype neg_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.neg $push0=, $4
; NO-SIMD128-NEXT:    f32.store 12($0), $pop0
; NO-SIMD128-NEXT:    f32.neg $push1=, $3
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.neg $push2=, $2
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.neg $push3=, $1
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v4f32:
; NO-SIMD128-FAST:         .functype neg_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.neg $push0=, $1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.neg $push1=, $2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.neg $push2=, $3
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.neg $push3=, $4
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = fsub nsz <4 x float> <float 0.0, float 0.0, float 0.0, float 0.0>, %x
  ret <4 x float> %a
}

declare <4 x float> @llvm.fabs.v4f32(<4 x float>) nounwind readnone
define <4 x float> @abs_v4f32(<4 x float> %x) {
; SIMD128-LABEL: abs_v4f32:
; SIMD128:         .functype abs_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v4f32:
; SIMD128-FAST:         .functype abs_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v4f32:
; NO-SIMD128:         .functype abs_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.abs $push0=, $4
; NO-SIMD128-NEXT:    f32.store 12($0), $pop0
; NO-SIMD128-NEXT:    f32.abs $push1=, $3
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.abs $push2=, $2
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.abs $push3=, $1
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v4f32:
; NO-SIMD128-FAST:         .functype abs_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.abs $push0=, $1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.abs $push1=, $2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.abs $push2=, $3
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.abs $push3=, $4
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.fabs.v4f32(<4 x float> %x)
  ret <4 x float> %a
}

define <4 x float> @min_unordered_v4f32(<4 x float> %x) {
; SIMD128-LABEL: min_unordered_v4f32:
; SIMD128:         .functype min_unordered_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f32x4.pmin $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: min_unordered_v4f32:
; SIMD128-FAST:         .functype min_unordered_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_unordered_v4f32:
; NO-SIMD128:         .functype min_unordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.gt $push1=, $4, $pop15
; NO-SIMD128-NEXT:    f32.select $push2=, $pop0, $4, $pop1
; NO-SIMD128-NEXT:    f32.store 12($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.gt $push3=, $3, $pop13
; NO-SIMD128-NEXT:    f32.select $push4=, $pop14, $3, $pop3
; NO-SIMD128-NEXT:    f32.store 8($0), $pop4
; NO-SIMD128-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.gt $push5=, $2, $pop11
; NO-SIMD128-NEXT:    f32.select $push6=, $pop12, $2, $pop5
; NO-SIMD128-NEXT:    f32.store 4($0), $pop6
; NO-SIMD128-NEXT:    f32.const $push10=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push9=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.gt $push7=, $1, $pop9
; NO-SIMD128-NEXT:    f32.select $push8=, $pop10, $1, $pop7
; NO-SIMD128-NEXT:    f32.store 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_unordered_v4f32:
; NO-SIMD128-FAST:         .functype min_unordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.gt $push1=, $1, $pop15
; NO-SIMD128-FAST-NEXT:    f32.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.gt $push3=, $2, $pop13
; NO-SIMD128-FAST-NEXT:    f32.select $push4=, $pop14, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.gt $push5=, $3, $pop11
; NO-SIMD128-FAST-NEXT:    f32.select $push6=, $pop12, $3, $pop5
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    f32.const $push10=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push9=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.gt $push7=, $4, $pop9
; NO-SIMD128-FAST-NEXT:    f32.select $push8=, $pop10, $4, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp ule <4 x float> %x, <float 5., float 5., float 5., float 5.>
  %a = select <4 x i1> %cmps, <4 x float> %x,
    <4 x float> <float 5., float 5., float 5., float 5.>
  ret <4 x float> %a
}

define <4 x float> @max_unordered_v4f32(<4 x float> %x) {
; SIMD128-LABEL: max_unordered_v4f32:
; SIMD128:         .functype max_unordered_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f32x4.pmax $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: max_unordered_v4f32:
; SIMD128-FAST:         .functype max_unordered_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_unordered_v4f32:
; NO-SIMD128:         .functype max_unordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.lt $push1=, $4, $pop15
; NO-SIMD128-NEXT:    f32.select $push2=, $pop0, $4, $pop1
; NO-SIMD128-NEXT:    f32.store 12($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.lt $push3=, $3, $pop13
; NO-SIMD128-NEXT:    f32.select $push4=, $pop14, $3, $pop3
; NO-SIMD128-NEXT:    f32.store 8($0), $pop4
; NO-SIMD128-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.lt $push5=, $2, $pop11
; NO-SIMD128-NEXT:    f32.select $push6=, $pop12, $2, $pop5
; NO-SIMD128-NEXT:    f32.store 4($0), $pop6
; NO-SIMD128-NEXT:    f32.const $push10=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push9=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.lt $push7=, $1, $pop9
; NO-SIMD128-NEXT:    f32.select $push8=, $pop10, $1, $pop7
; NO-SIMD128-NEXT:    f32.store 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_unordered_v4f32:
; NO-SIMD128-FAST:         .functype max_unordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.lt $push1=, $1, $pop15
; NO-SIMD128-FAST-NEXT:    f32.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.lt $push3=, $2, $pop13
; NO-SIMD128-FAST-NEXT:    f32.select $push4=, $pop14, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.lt $push5=, $3, $pop11
; NO-SIMD128-FAST-NEXT:    f32.select $push6=, $pop12, $3, $pop5
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    f32.const $push10=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push9=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.lt $push7=, $4, $pop9
; NO-SIMD128-FAST-NEXT:    f32.select $push8=, $pop10, $4, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp uge <4 x float> %x, <float 5., float 5., float 5., float 5.>
  %a = select <4 x i1> %cmps, <4 x float> %x,
    <4 x float> <float 5., float 5., float 5., float 5.>
  ret <4 x float> %a
}

define <4 x float> @min_ordered_v4f32(<4 x float> %x) {
; SIMD128-LABEL: min_ordered_v4f32:
; SIMD128:         .functype min_ordered_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f32x4.pmin $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: min_ordered_v4f32:
; SIMD128-FAST:         .functype min_ordered_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_ordered_v4f32:
; NO-SIMD128:         .functype min_ordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.ge $push1=, $4, $pop15
; NO-SIMD128-NEXT:    f32.select $push2=, $pop0, $4, $pop1
; NO-SIMD128-NEXT:    f32.store 12($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.ge $push3=, $3, $pop13
; NO-SIMD128-NEXT:    f32.select $push4=, $pop14, $3, $pop3
; NO-SIMD128-NEXT:    f32.store 8($0), $pop4
; NO-SIMD128-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.ge $push5=, $2, $pop11
; NO-SIMD128-NEXT:    f32.select $push6=, $pop12, $2, $pop5
; NO-SIMD128-NEXT:    f32.store 4($0), $pop6
; NO-SIMD128-NEXT:    f32.const $push10=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push9=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.ge $push7=, $1, $pop9
; NO-SIMD128-NEXT:    f32.select $push8=, $pop10, $1, $pop7
; NO-SIMD128-NEXT:    f32.store 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_ordered_v4f32:
; NO-SIMD128-FAST:         .functype min_ordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.ge $push1=, $1, $pop15
; NO-SIMD128-FAST-NEXT:    f32.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.ge $push3=, $2, $pop13
; NO-SIMD128-FAST-NEXT:    f32.select $push4=, $pop14, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.ge $push5=, $3, $pop11
; NO-SIMD128-FAST-NEXT:    f32.select $push6=, $pop12, $3, $pop5
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    f32.const $push10=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push9=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.ge $push7=, $4, $pop9
; NO-SIMD128-FAST-NEXT:    f32.select $push8=, $pop10, $4, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp ole <4 x float> <float 5., float 5., float 5., float 5.>, %x
  %a = select <4 x i1> %cmps,
    <4 x float> <float 5., float 5., float 5., float 5.>, <4 x float> %x
  ret <4 x float> %a
}

define <4 x float> @max_ordered_v4f32(<4 x float> %x) {
; SIMD128-LABEL: max_ordered_v4f32:
; SIMD128:         .functype max_ordered_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f32x4.pmax $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: max_ordered_v4f32:
; SIMD128-FAST:         .functype max_ordered_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_ordered_v4f32:
; NO-SIMD128:         .functype max_ordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.le $push1=, $4, $pop15
; NO-SIMD128-NEXT:    f32.select $push2=, $pop0, $4, $pop1
; NO-SIMD128-NEXT:    f32.store 12($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.le $push3=, $3, $pop13
; NO-SIMD128-NEXT:    f32.select $push4=, $pop14, $3, $pop3
; NO-SIMD128-NEXT:    f32.store 8($0), $pop4
; NO-SIMD128-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.le $push5=, $2, $pop11
; NO-SIMD128-NEXT:    f32.select $push6=, $pop12, $2, $pop5
; NO-SIMD128-NEXT:    f32.store 4($0), $pop6
; NO-SIMD128-NEXT:    f32.const $push10=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push9=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.le $push7=, $1, $pop9
; NO-SIMD128-NEXT:    f32.select $push8=, $pop10, $1, $pop7
; NO-SIMD128-NEXT:    f32.store 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_ordered_v4f32:
; NO-SIMD128-FAST:         .functype max_ordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.le $push1=, $1, $pop15
; NO-SIMD128-FAST-NEXT:    f32.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.le $push3=, $2, $pop13
; NO-SIMD128-FAST-NEXT:    f32.select $push4=, $pop14, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.le $push5=, $3, $pop11
; NO-SIMD128-FAST-NEXT:    f32.select $push6=, $pop12, $3, $pop5
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    f32.const $push10=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push9=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.le $push7=, $4, $pop9
; NO-SIMD128-FAST-NEXT:    f32.select $push8=, $pop10, $4, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp oge <4 x float> <float 5., float 5., float 5., float 5.>, %x
  %a = select <4 x i1> %cmps,
    <4 x float> <float 5., float 5., float 5., float 5.>, <4 x float> %x
  ret <4 x float> %a
}

declare <4 x float> @llvm.minimum.v4f32(<4 x float>, <4 x float>)
define <4 x float> @min_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: min_intrinsic_v4f32:
; SIMD128:         .functype min_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.min $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_intrinsic_v4f32:
; SIMD128-FAST:         .functype min_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.min $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_intrinsic_v4f32:
; NO-SIMD128:         .functype min_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.min $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.store 12($0), $pop0
; NO-SIMD128-NEXT:    f32.min $push1=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.min $push2=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.min $push3=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype min_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.min $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.min $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.min $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.min $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.minimum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

declare <4 x float> @llvm.minnum.v4f32(<4 x float>, <4 x float>)
define <4 x float> @minnum_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: minnum_intrinsic_v4f32:
; SIMD128:         .functype minnum_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-NEXT:    local.tee $push26=, $3=, $pop27
; SIMD128-NEXT:    f32x4.extract_lane $push25=, $1, 0
; SIMD128-NEXT:    local.tee $push24=, $2=, $pop25
; SIMD128-NEXT:    f32.lt $push2=, $3, $2
; SIMD128-NEXT:    f32.select $push3=, $pop26, $pop24, $pop2
; SIMD128-NEXT:    f32x4.splat $push4=, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push23=, $0, 1
; SIMD128-NEXT:    local.tee $push22=, $3=, $pop23
; SIMD128-NEXT:    f32x4.extract_lane $push21=, $1, 1
; SIMD128-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-NEXT:    f32.lt $push0=, $3, $2
; SIMD128-NEXT:    f32.select $push1=, $pop22, $pop20, $pop0
; SIMD128-NEXT:    f32x4.replace_lane $push5=, $pop4, 1, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push19=, $0, 2
; SIMD128-NEXT:    local.tee $push18=, $3=, $pop19
; SIMD128-NEXT:    f32x4.extract_lane $push17=, $1, 2
; SIMD128-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-NEXT:    f32.lt $push6=, $3, $2
; SIMD128-NEXT:    f32.select $push7=, $pop18, $pop16, $pop6
; SIMD128-NEXT:    f32x4.replace_lane $push8=, $pop5, 2, $pop7
; SIMD128-NEXT:    f32x4.extract_lane $push15=, $0, 3
; SIMD128-NEXT:    local.tee $push14=, $3=, $pop15
; SIMD128-NEXT:    f32x4.extract_lane $push13=, $1, 3
; SIMD128-NEXT:    local.tee $push12=, $2=, $pop13
; SIMD128-NEXT:    f32.lt $push9=, $3, $2
; SIMD128-NEXT:    f32.select $push10=, $pop14, $pop12, $pop9
; SIMD128-NEXT:    f32x4.replace_lane $push11=, $pop8, 3, $pop10
; SIMD128-NEXT:    return $pop11
;
; SIMD128-FAST-LABEL: minnum_intrinsic_v4f32:
; SIMD128-FAST:         .functype minnum_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-FAST-NEXT:    local.tee $push26=, $3=, $pop27
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push25=, $1, 0
; SIMD128-FAST-NEXT:    local.tee $push24=, $2=, $pop25
; SIMD128-FAST-NEXT:    f32.lt $push3=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push4=, $pop26, $pop24, $pop3
; SIMD128-FAST-NEXT:    f32x4.splat $push5=, $pop4
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push23=, $0, 1
; SIMD128-FAST-NEXT:    local.tee $push22=, $3=, $pop23
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push21=, $1, 1
; SIMD128-FAST-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-FAST-NEXT:    f32.lt $push1=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push2=, $pop22, $pop20, $pop1
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push6=, $pop5, 1, $pop2
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push19=, $0, 2
; SIMD128-FAST-NEXT:    local.tee $push18=, $3=, $pop19
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push17=, $1, 2
; SIMD128-FAST-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-FAST-NEXT:    f32.lt $push7=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push8=, $pop18, $pop16, $pop7
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push9=, $pop6, 2, $pop8
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push15=, $0, 3
; SIMD128-FAST-NEXT:    local.tee $push14=, $3=, $pop15
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push13=, $1, 3
; SIMD128-FAST-NEXT:    local.tee $push12=, $2=, $pop13
; SIMD128-FAST-NEXT:    f32.lt $push10=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push11=, $pop14, $pop12, $pop10
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push0=, $pop9, 3, $pop11
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: minnum_intrinsic_v4f32:
; NO-SIMD128:         .functype minnum_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.lt $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.select $push1=, $4, $8, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.lt $push2=, $3, $7
; NO-SIMD128-NEXT:    f32.select $push3=, $3, $7, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.lt $push4=, $2, $6
; NO-SIMD128-NEXT:    f32.select $push5=, $2, $6, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.lt $push6=, $1, $5
; NO-SIMD128-NEXT:    f32.select $push7=, $1, $5, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: minnum_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype minnum_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.lt $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.lt $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.lt $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.lt $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @minnum_nsz_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: minnum_nsz_intrinsic_v4f32:
; SIMD128:         .functype minnum_nsz_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.min $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: minnum_nsz_intrinsic_v4f32:
; SIMD128-FAST:         .functype minnum_nsz_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.min $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: minnum_nsz_intrinsic_v4f32:
; NO-SIMD128:         .functype minnum_nsz_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.min $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.store 12($0), $pop0
; NO-SIMD128-NEXT:    f32.min $push1=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.min $push2=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.min $push3=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: minnum_nsz_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype minnum_nsz_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.min $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.min $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.min $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.min $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan nsz <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @fminnumv432_non_zero_intrinsic(<4 x float> %x) {
; SIMD128-LABEL: fminnumv432_non_zero_intrinsic:
; SIMD128:         .functype fminnumv432_non_zero_intrinsic (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, -0x1p0, -0x1p0, -0x1p0, -0x1p0
; SIMD128-NEXT:    f32x4.min $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: fminnumv432_non_zero_intrinsic:
; SIMD128-FAST:         .functype fminnumv432_non_zero_intrinsic (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, -0x1p0, -0x1p0, -0x1p0, -0x1p0
; SIMD128-FAST-NEXT:    f32x4.min $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: fminnumv432_non_zero_intrinsic:
; NO-SIMD128:         .functype fminnumv432_non_zero_intrinsic (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-NEXT:    f32.min $push1=, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.const $push7=, -0x1p0
; NO-SIMD128-NEXT:    f32.min $push2=, $3, $pop7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push6=, -0x1p0
; NO-SIMD128-NEXT:    f32.min $push3=, $2, $pop6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-NEXT:    f32.const $push5=, -0x1p0
; NO-SIMD128-NEXT:    f32.min $push4=, $1, $pop5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: fminnumv432_non_zero_intrinsic:
; NO-SIMD128-FAST:         .functype fminnumv432_non_zero_intrinsic (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.min $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.const $push7=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.min $push2=, $2, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push6=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.min $push3=, $3, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.const $push5=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.min $push4=, $4, $pop5
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float><float -1.0, float -1.0, float -1.0, float -1.0>)
  ret <4 x float> %a
}

define <4 x float> @fminnumv432_one_zero_intrinsic(<4 x float> %x) {
; SIMD128-LABEL: fminnumv432_one_zero_intrinsic:
; SIMD128:         .functype fminnumv432_one_zero_intrinsic (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-NEXT:    local.tee $push26=, $1=, $pop27
; SIMD128-NEXT:    f32.const $push3=, -0x1p0
; SIMD128-NEXT:    f32.const $push25=, -0x1p0
; SIMD128-NEXT:    f32.lt $push4=, $1, $pop25
; SIMD128-NEXT:    f32.select $push5=, $pop26, $pop3, $pop4
; SIMD128-NEXT:    f32x4.splat $push6=, $pop5
; SIMD128-NEXT:    f32x4.extract_lane $push24=, $0, 1
; SIMD128-NEXT:    local.tee $push23=, $1=, $pop24
; SIMD128-NEXT:    f32.const $push0=, 0x0p0
; SIMD128-NEXT:    f32.const $push22=, 0x0p0
; SIMD128-NEXT:    f32.lt $push1=, $1, $pop22
; SIMD128-NEXT:    f32.select $push2=, $pop23, $pop0, $pop1
; SIMD128-NEXT:    f32x4.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    f32x4.extract_lane $push21=, $0, 2
; SIMD128-NEXT:    local.tee $push20=, $1=, $pop21
; SIMD128-NEXT:    f32.const $push19=, -0x1p0
; SIMD128-NEXT:    f32.const $push18=, -0x1p0
; SIMD128-NEXT:    f32.lt $push8=, $1, $pop18
; SIMD128-NEXT:    f32.select $push9=, $pop20, $pop19, $pop8
; SIMD128-NEXT:    f32x4.replace_lane $push10=, $pop7, 2, $pop9
; SIMD128-NEXT:    f32x4.extract_lane $push17=, $0, 3
; SIMD128-NEXT:    local.tee $push16=, $1=, $pop17
; SIMD128-NEXT:    f32.const $push15=, -0x1p0
; SIMD128-NEXT:    f32.const $push14=, -0x1p0
; SIMD128-NEXT:    f32.lt $push11=, $1, $pop14
; SIMD128-NEXT:    f32.select $push12=, $pop16, $pop15, $pop11
; SIMD128-NEXT:    f32x4.replace_lane $push13=, $pop10, 3, $pop12
; SIMD128-NEXT:    return $pop13
;
; SIMD128-FAST-LABEL: fminnumv432_one_zero_intrinsic:
; SIMD128-FAST:         .functype fminnumv432_one_zero_intrinsic (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-FAST-NEXT:    local.tee $push26=, $1=, $pop27
; SIMD128-FAST-NEXT:    f32.const $push4=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push25=, -0x1p0
; SIMD128-FAST-NEXT:    f32.lt $push5=, $1, $pop25
; SIMD128-FAST-NEXT:    f32.select $push6=, $pop26, $pop4, $pop5
; SIMD128-FAST-NEXT:    f32x4.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push24=, $0, 1
; SIMD128-FAST-NEXT:    local.tee $push23=, $1=, $pop24
; SIMD128-FAST-NEXT:    f32.const $push1=, 0x0p0
; SIMD128-FAST-NEXT:    f32.const $push22=, 0x0p0
; SIMD128-FAST-NEXT:    f32.lt $push2=, $1, $pop22
; SIMD128-FAST-NEXT:    f32.select $push3=, $pop23, $pop1, $pop2
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push8=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push21=, $0, 2
; SIMD128-FAST-NEXT:    local.tee $push20=, $1=, $pop21
; SIMD128-FAST-NEXT:    f32.const $push19=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push18=, -0x1p0
; SIMD128-FAST-NEXT:    f32.lt $push9=, $1, $pop18
; SIMD128-FAST-NEXT:    f32.select $push10=, $pop20, $pop19, $pop9
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push11=, $pop8, 2, $pop10
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push17=, $0, 3
; SIMD128-FAST-NEXT:    local.tee $push16=, $1=, $pop17
; SIMD128-FAST-NEXT:    f32.const $push15=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push14=, -0x1p0
; SIMD128-FAST-NEXT:    f32.lt $push12=, $1, $pop14
; SIMD128-FAST-NEXT:    f32.select $push13=, $pop16, $pop15, $pop12
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push0=, $pop11, 3, $pop13
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: fminnumv432_one_zero_intrinsic:
; NO-SIMD128:         .functype fminnumv432_one_zero_intrinsic (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-NEXT:    f32.min $push1=, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-NEXT:    f32.min $push2=, $3, $pop9
; NO-SIMD128-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push3=, 0x0p0
; NO-SIMD128-NEXT:    f32.const $push8=, 0x0p0
; NO-SIMD128-NEXT:    f32.lt $push4=, $2, $pop8
; NO-SIMD128-NEXT:    f32.select $push5=, $2, $pop3, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.const $push7=, -0x1p0
; NO-SIMD128-NEXT:    f32.min $push6=, $1, $pop7
; NO-SIMD128-NEXT:    f32.store 0($0), $pop6
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: fminnumv432_one_zero_intrinsic:
; NO-SIMD128-FAST:         .functype fminnumv432_one_zero_intrinsic (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.min $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.min $push2=, $3, $pop9
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push3=, 0x0p0
; NO-SIMD128-FAST-NEXT:    f32.const $push8=, 0x0p0
; NO-SIMD128-FAST-NEXT:    f32.lt $push4=, $2, $pop8
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $2, $pop3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.const $push7=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.min $push6=, $4, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop6
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float><float -1.0, float 0.0, float -1.0, float -1.0>)
  ret <4 x float> %a
}

declare <4 x float> @llvm.maximum.v4f32(<4 x float>, <4 x float>)
define <4 x float> @max_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: max_intrinsic_v4f32:
; SIMD128:         .functype max_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.max $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_intrinsic_v4f32:
; SIMD128-FAST:         .functype max_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.max $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_intrinsic_v4f32:
; NO-SIMD128:         .functype max_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.max $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.store 12($0), $pop0
; NO-SIMD128-NEXT:    f32.max $push1=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.max $push2=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.max $push3=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype max_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.max $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.max $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.max $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.max $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.maximum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

declare <4 x float> @llvm.maxnum.v4f32(<4 x float>, <4 x float>)
define <4 x float> @maxnum_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: maxnum_intrinsic_v4f32:
; SIMD128:         .functype maxnum_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-NEXT:    local.tee $push26=, $3=, $pop27
; SIMD128-NEXT:    f32x4.extract_lane $push25=, $1, 0
; SIMD128-NEXT:    local.tee $push24=, $2=, $pop25
; SIMD128-NEXT:    f32.gt $push2=, $3, $2
; SIMD128-NEXT:    f32.select $push3=, $pop26, $pop24, $pop2
; SIMD128-NEXT:    f32x4.splat $push4=, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push23=, $0, 1
; SIMD128-NEXT:    local.tee $push22=, $3=, $pop23
; SIMD128-NEXT:    f32x4.extract_lane $push21=, $1, 1
; SIMD128-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-NEXT:    f32.gt $push0=, $3, $2
; SIMD128-NEXT:    f32.select $push1=, $pop22, $pop20, $pop0
; SIMD128-NEXT:    f32x4.replace_lane $push5=, $pop4, 1, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push19=, $0, 2
; SIMD128-NEXT:    local.tee $push18=, $3=, $pop19
; SIMD128-NEXT:    f32x4.extract_lane $push17=, $1, 2
; SIMD128-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-NEXT:    f32.gt $push6=, $3, $2
; SIMD128-NEXT:    f32.select $push7=, $pop18, $pop16, $pop6
; SIMD128-NEXT:    f32x4.replace_lane $push8=, $pop5, 2, $pop7
; SIMD128-NEXT:    f32x4.extract_lane $push15=, $0, 3
; SIMD128-NEXT:    local.tee $push14=, $3=, $pop15
; SIMD128-NEXT:    f32x4.extract_lane $push13=, $1, 3
; SIMD128-NEXT:    local.tee $push12=, $2=, $pop13
; SIMD128-NEXT:    f32.gt $push9=, $3, $2
; SIMD128-NEXT:    f32.select $push10=, $pop14, $pop12, $pop9
; SIMD128-NEXT:    f32x4.replace_lane $push11=, $pop8, 3, $pop10
; SIMD128-NEXT:    return $pop11
;
; SIMD128-FAST-LABEL: maxnum_intrinsic_v4f32:
; SIMD128-FAST:         .functype maxnum_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-FAST-NEXT:    local.tee $push26=, $3=, $pop27
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push25=, $1, 0
; SIMD128-FAST-NEXT:    local.tee $push24=, $2=, $pop25
; SIMD128-FAST-NEXT:    f32.gt $push3=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push4=, $pop26, $pop24, $pop3
; SIMD128-FAST-NEXT:    f32x4.splat $push5=, $pop4
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push23=, $0, 1
; SIMD128-FAST-NEXT:    local.tee $push22=, $3=, $pop23
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push21=, $1, 1
; SIMD128-FAST-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-FAST-NEXT:    f32.gt $push1=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push2=, $pop22, $pop20, $pop1
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push6=, $pop5, 1, $pop2
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push19=, $0, 2
; SIMD128-FAST-NEXT:    local.tee $push18=, $3=, $pop19
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push17=, $1, 2
; SIMD128-FAST-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-FAST-NEXT:    f32.gt $push7=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push8=, $pop18, $pop16, $pop7
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push9=, $pop6, 2, $pop8
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push15=, $0, 3
; SIMD128-FAST-NEXT:    local.tee $push14=, $3=, $pop15
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push13=, $1, 3
; SIMD128-FAST-NEXT:    local.tee $push12=, $2=, $pop13
; SIMD128-FAST-NEXT:    f32.gt $push10=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push11=, $pop14, $pop12, $pop10
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push0=, $pop9, 3, $pop11
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: maxnum_intrinsic_v4f32:
; NO-SIMD128:         .functype maxnum_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.gt $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.select $push1=, $4, $8, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.gt $push2=, $3, $7
; NO-SIMD128-NEXT:    f32.select $push3=, $3, $7, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.gt $push4=, $2, $6
; NO-SIMD128-NEXT:    f32.select $push5=, $2, $6, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.gt $push6=, $1, $5
; NO-SIMD128-NEXT:    f32.select $push7=, $1, $5, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: maxnum_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype maxnum_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.gt $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.gt $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.gt $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.gt $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @maxnum_nsz_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: maxnum_nsz_intrinsic_v4f32:
; SIMD128:         .functype maxnum_nsz_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.max $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: maxnum_nsz_intrinsic_v4f32:
; SIMD128-FAST:         .functype maxnum_nsz_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.max $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: maxnum_nsz_intrinsic_v4f32:
; NO-SIMD128:         .functype maxnum_nsz_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.max $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.store 12($0), $pop0
; NO-SIMD128-NEXT:    f32.max $push1=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.max $push2=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.max $push3=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: maxnum_nsz_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype maxnum_nsz_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.max $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.max $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.max $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.max $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan nsz <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @maxnum_one_zero_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: maxnum_one_zero_intrinsic_v4f32:
; SIMD128:         .functype maxnum_one_zero_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-NEXT:    local.tee $push26=, $2=, $pop27
; SIMD128-NEXT:    f32.const $push3=, -0x1p0
; SIMD128-NEXT:    f32.const $push25=, -0x1p0
; SIMD128-NEXT:    f32.gt $push4=, $2, $pop25
; SIMD128-NEXT:    f32.select $push5=, $pop26, $pop3, $pop4
; SIMD128-NEXT:    f32x4.splat $push6=, $pop5
; SIMD128-NEXT:    f32x4.extract_lane $push24=, $0, 1
; SIMD128-NEXT:    local.tee $push23=, $2=, $pop24
; SIMD128-NEXT:    f32.const $push0=, 0x0p0
; SIMD128-NEXT:    f32.const $push22=, 0x0p0
; SIMD128-NEXT:    f32.gt $push1=, $2, $pop22
; SIMD128-NEXT:    f32.select $push2=, $pop23, $pop0, $pop1
; SIMD128-NEXT:    f32x4.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    f32x4.extract_lane $push21=, $0, 2
; SIMD128-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-NEXT:    f32.const $push19=, -0x1p0
; SIMD128-NEXT:    f32.const $push18=, -0x1p0
; SIMD128-NEXT:    f32.gt $push8=, $2, $pop18
; SIMD128-NEXT:    f32.select $push9=, $pop20, $pop19, $pop8
; SIMD128-NEXT:    f32x4.replace_lane $push10=, $pop7, 2, $pop9
; SIMD128-NEXT:    f32x4.extract_lane $push17=, $0, 3
; SIMD128-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-NEXT:    f32.const $push15=, -0x1p0
; SIMD128-NEXT:    f32.const $push14=, -0x1p0
; SIMD128-NEXT:    f32.gt $push11=, $2, $pop14
; SIMD128-NEXT:    f32.select $push12=, $pop16, $pop15, $pop11
; SIMD128-NEXT:    f32x4.replace_lane $push13=, $pop10, 3, $pop12
; SIMD128-NEXT:    return $pop13
;
; SIMD128-FAST-LABEL: maxnum_one_zero_intrinsic_v4f32:
; SIMD128-FAST:         .functype maxnum_one_zero_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-FAST-NEXT:    local.tee $push26=, $2=, $pop27
; SIMD128-FAST-NEXT:    f32.const $push4=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push25=, -0x1p0
; SIMD128-FAST-NEXT:    f32.gt $push5=, $2, $pop25
; SIMD128-FAST-NEXT:    f32.select $push6=, $pop26, $pop4, $pop5
; SIMD128-FAST-NEXT:    f32x4.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push24=, $0, 1
; SIMD128-FAST-NEXT:    local.tee $push23=, $2=, $pop24
; SIMD128-FAST-NEXT:    f32.const $push1=, 0x0p0
; SIMD128-FAST-NEXT:    f32.const $push22=, 0x0p0
; SIMD128-FAST-NEXT:    f32.gt $push2=, $2, $pop22
; SIMD128-FAST-NEXT:    f32.select $push3=, $pop23, $pop1, $pop2
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push8=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push21=, $0, 2
; SIMD128-FAST-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-FAST-NEXT:    f32.const $push19=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push18=, -0x1p0
; SIMD128-FAST-NEXT:    f32.gt $push9=, $2, $pop18
; SIMD128-FAST-NEXT:    f32.select $push10=, $pop20, $pop19, $pop9
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push11=, $pop8, 2, $pop10
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push17=, $0, 3
; SIMD128-FAST-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-FAST-NEXT:    f32.const $push15=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push14=, -0x1p0
; SIMD128-FAST-NEXT:    f32.gt $push12=, $2, $pop14
; SIMD128-FAST-NEXT:    f32.select $push13=, $pop16, $pop15, $pop12
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push0=, $pop11, 3, $pop13
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: maxnum_one_zero_intrinsic_v4f32:
; NO-SIMD128:         .functype maxnum_one_zero_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-NEXT:    f32.max $push1=, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-NEXT:    f32.max $push2=, $3, $pop9
; NO-SIMD128-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push3=, 0x0p0
; NO-SIMD128-NEXT:    f32.const $push8=, 0x0p0
; NO-SIMD128-NEXT:    f32.gt $push4=, $2, $pop8
; NO-SIMD128-NEXT:    f32.select $push5=, $2, $pop3, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.const $push7=, -0x1p0
; NO-SIMD128-NEXT:    f32.max $push6=, $1, $pop7
; NO-SIMD128-NEXT:    f32.store 0($0), $pop6
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: maxnum_one_zero_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype maxnum_one_zero_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.max $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.max $push2=, $3, $pop9
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push3=, 0x0p0
; NO-SIMD128-FAST-NEXT:    f32.const $push8=, 0x0p0
; NO-SIMD128-FAST-NEXT:    f32.gt $push4=, $2, $pop8
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $2, $pop3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.const $push7=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.max $push6=, $4, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop6
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float><float -1.0, float 0.0, float -1.0, float -1.0>)
  ret <4 x float> %a
}

define <4 x float> @maxnum_non_zero_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: maxnum_non_zero_intrinsic_v4f32:
; SIMD128:         .functype maxnum_non_zero_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, -0x1p0, 0x1p0, -0x1p0, -0x1p0
; SIMD128-NEXT:    f32x4.max $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: maxnum_non_zero_intrinsic_v4f32:
; SIMD128-FAST:         .functype maxnum_non_zero_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, -0x1p0, 0x1p0, -0x1p0, -0x1p0
; SIMD128-FAST-NEXT:    f32x4.max $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: maxnum_non_zero_intrinsic_v4f32:
; NO-SIMD128:         .functype maxnum_non_zero_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-NEXT:    f32.max $push1=, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.const $push7=, -0x1p0
; NO-SIMD128-NEXT:    f32.max $push2=, $3, $pop7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push3=, 0x1p0
; NO-SIMD128-NEXT:    f32.max $push4=, $2, $pop3
; NO-SIMD128-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-NEXT:    f32.const $push6=, -0x1p0
; NO-SIMD128-NEXT:    f32.max $push5=, $1, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: maxnum_non_zero_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype maxnum_non_zero_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.max $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.const $push2=, 0x1p0
; NO-SIMD128-FAST-NEXT:    f32.max $push3=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.const $push7=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.max $push4=, $3, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    f32.const $push6=, -0x1p0
; NO-SIMD128-FAST-NEXT:    f32.max $push5=, $4, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float><float -1.0, float 1.0, float -1.0, float -1.0>)
  ret <4 x float> %a
}

define <4 x float> @min_const_intrinsic_v4f32() {
; SIMD128-LABEL: min_const_intrinsic_v4f32:
; SIMD128:         .functype min_const_intrinsic_v4f32 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_const_intrinsic_v4f32:
; SIMD128-FAST:         .functype min_const_intrinsic_v4f32 () -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_const_intrinsic_v4f32:
; NO-SIMD128:         .functype min_const_intrinsic_v4f32 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 4656722015785320448
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 4656722015785320448
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_const_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype min_const_intrinsic_v4f32 (i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 4656722015785320448
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.const $push1=, 4656722015785320448
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.minimum.v4f32(
    <4 x float> <float 42., float 42., float 42., float 42.>,
    <4 x float> <float 5., float 5., float 5., float 5.>
  )
  ret <4 x float> %a
}

define <4 x float> @max_const_intrinsic_v4f32() {
; SIMD128-LABEL: max_const_intrinsic_v4f32:
; SIMD128:         .functype max_const_intrinsic_v4f32 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.5p5, 0x1.5p5, 0x1.5p5, 0x1.5p5
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_const_intrinsic_v4f32:
; SIMD128-FAST:         .functype max_const_intrinsic_v4f32 () -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push0=, 0x1.5p5, 0x1.5p5, 0x1.5p5, 0x1.5p5
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_const_intrinsic_v4f32:
; NO-SIMD128:         .functype max_const_intrinsic_v4f32 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 4767060206681587712
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 4767060206681587712
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_const_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype max_const_intrinsic_v4f32 (i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 4767060206681587712
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.const $push1=, 4767060206681587712
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.maximum.v4f32(
    <4 x float> <float 42., float 42., float 42., float 42.>,
    <4 x float> <float 5., float 5., float 5., float 5.>
  )
  ret <4 x float> %a
}

define <4 x float> @pmin_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmin_v4f32:
; SIMD128:         .functype pmin_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_v4f32:
; SIMD128-FAST:         .functype pmin_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_v4f32:
; NO-SIMD128:         .functype pmin_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.lt $push0=, $8, $4
; NO-SIMD128-NEXT:    f32.select $push1=, $8, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.lt $push2=, $7, $3
; NO-SIMD128-NEXT:    f32.select $push3=, $7, $3, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.lt $push4=, $6, $2
; NO-SIMD128-NEXT:    f32.select $push5=, $6, $2, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.lt $push6=, $5, $1
; NO-SIMD128-NEXT:    f32.select $push7=, $5, $1, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_v4f32:
; NO-SIMD128-FAST:         .functype pmin_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.lt $push0=, $5, $1
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $5, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.lt $push2=, $6, $2
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.lt $push4=, $7, $3
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $7, $3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.lt $push6=, $8, $4
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp olt <4 x float> %y, %x
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x float> @pmin_v4f32_fast_olt(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmin_v4f32_fast_olt:
; SIMD128:         .functype pmin_v4f32_fast_olt (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmin $push0=, $1, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_v4f32_fast_olt:
; SIMD128-FAST:         .functype pmin_v4f32_fast_olt (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $1, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_v4f32_fast_olt:
; NO-SIMD128:         .functype pmin_v4f32_fast_olt (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.lt $push0=, $8, $4
; NO-SIMD128-NEXT:    f32.select $push1=, $8, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.lt $push2=, $7, $3
; NO-SIMD128-NEXT:    f32.select $push3=, $7, $3, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.lt $push4=, $6, $2
; NO-SIMD128-NEXT:    f32.select $push5=, $6, $2, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.lt $push6=, $5, $1
; NO-SIMD128-NEXT:    f32.select $push7=, $5, $1, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_v4f32_fast_olt:
; NO-SIMD128-FAST:         .functype pmin_v4f32_fast_olt (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.lt $push0=, $5, $1
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $5, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.lt $push2=, $6, $2
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.lt $push4=, $7, $3
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $7, $3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.lt $push6=, $8, $4
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp fast olt <4 x float> %y, %x
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x float> @pmin_v4f32_fast_ogt(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmin_v4f32_fast_ogt:
; SIMD128:         .functype pmin_v4f32_fast_ogt (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_v4f32_fast_ogt:
; SIMD128-FAST:         .functype pmin_v4f32_fast_ogt (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_v4f32_fast_ogt:
; NO-SIMD128:         .functype pmin_v4f32_fast_ogt (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.gt $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.select $push1=, $8, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.gt $push2=, $3, $7
; NO-SIMD128-NEXT:    f32.select $push3=, $7, $3, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.gt $push4=, $2, $6
; NO-SIMD128-NEXT:    f32.select $push5=, $6, $2, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.gt $push6=, $1, $5
; NO-SIMD128-NEXT:    f32.select $push7=, $5, $1, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_v4f32_fast_ogt:
; NO-SIMD128-FAST:         .functype pmin_v4f32_fast_ogt (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.gt $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $5, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.gt $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.gt $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $7, $3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.gt $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp fast ogt <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x float> @pmin_v4f32_fast_ole(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmin_v4f32_fast_ole:
; SIMD128:         .functype pmin_v4f32_fast_ole (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmin $push0=, $1, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_v4f32_fast_ole:
; SIMD128-FAST:         .functype pmin_v4f32_fast_ole (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $1, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_v4f32_fast_ole:
; NO-SIMD128:         .functype pmin_v4f32_fast_ole (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.le $push0=, $8, $4
; NO-SIMD128-NEXT:    f32.select $push1=, $8, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.le $push2=, $7, $3
; NO-SIMD128-NEXT:    f32.select $push3=, $7, $3, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.le $push4=, $6, $2
; NO-SIMD128-NEXT:    f32.select $push5=, $6, $2, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.le $push6=, $5, $1
; NO-SIMD128-NEXT:    f32.select $push7=, $5, $1, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_v4f32_fast_ole:
; NO-SIMD128-FAST:         .functype pmin_v4f32_fast_ole (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.le $push0=, $5, $1
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $5, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.le $push2=, $6, $2
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.le $push4=, $7, $3
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $7, $3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.le $push6=, $8, $4
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp fast ole <4 x float> %y, %x
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x float> @pmin_v4f32_fast_oge(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmin_v4f32_fast_oge:
; SIMD128:         .functype pmin_v4f32_fast_oge (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_v4f32_fast_oge:
; SIMD128-FAST:         .functype pmin_v4f32_fast_oge (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_v4f32_fast_oge:
; NO-SIMD128:         .functype pmin_v4f32_fast_oge (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.ge $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.select $push1=, $8, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.ge $push2=, $3, $7
; NO-SIMD128-NEXT:    f32.select $push3=, $7, $3, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.ge $push4=, $2, $6
; NO-SIMD128-NEXT:    f32.select $push5=, $6, $2, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.ge $push6=, $1, $5
; NO-SIMD128-NEXT:    f32.select $push7=, $5, $1, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_v4f32_fast_oge:
; NO-SIMD128-FAST:         .functype pmin_v4f32_fast_oge (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.ge $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $5, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.ge $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.ge $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $7, $3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.ge $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp fast oge <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x i32> @pmin_int_v4f32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: pmin_int_v4f32:
; SIMD128:         .functype pmin_int_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_int_v4f32:
; SIMD128-FAST:         .functype pmin_int_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_int_v4f32:
; NO-SIMD128:         .functype pmin_int_v4f32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push1=, $8
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push0=, $4
; NO-SIMD128-NEXT:    f32.lt $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $8, $4, $pop2
; NO-SIMD128-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push5=, $7
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push4=, $3
; NO-SIMD128-NEXT:    f32.lt $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.select $push7=, $7, $3, $pop6
; NO-SIMD128-NEXT:    i32.store 8($0), $pop7
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push9=, $6
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push8=, $2
; NO-SIMD128-NEXT:    f32.lt $push10=, $pop9, $pop8
; NO-SIMD128-NEXT:    i32.select $push11=, $6, $2, $pop10
; NO-SIMD128-NEXT:    i32.store 4($0), $pop11
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push13=, $5
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push12=, $1
; NO-SIMD128-NEXT:    f32.lt $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.select $push15=, $5, $1, $pop14
; NO-SIMD128-NEXT:    i32.store 0($0), $pop15
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_int_v4f32:
; NO-SIMD128-FAST:         .functype pmin_int_v4f32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push1=, $5
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push0=, $1
; NO-SIMD128-FAST-NEXT:    f32.lt $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $5, $1, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push5=, $6
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push4=, $2
; NO-SIMD128-FAST-NEXT:    f32.lt $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $6, $2, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop7
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push9=, $7
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push8=, $3
; NO-SIMD128-FAST-NEXT:    f32.lt $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $7, $3, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop11
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push13=, $8
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push12=, $4
; NO-SIMD128-FAST-NEXT:    f32.lt $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $8, $4, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %fx = bitcast <4 x i32> %x to <4 x float>
  %fy = bitcast <4 x i32> %y to <4 x float>
  %c = fcmp olt <4 x float> %fy, %fx
  %a = select <4 x i1> %c, <4 x i32> %y, <4 x i32> %x
  ret <4 x i32> %a
}

define <4 x float> @pmax_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmax_v4f32:
; SIMD128:         .functype pmax_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_v4f32:
; SIMD128-FAST:         .functype pmax_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_v4f32:
; NO-SIMD128:         .functype pmax_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.lt $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.select $push1=, $8, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.lt $push2=, $3, $7
; NO-SIMD128-NEXT:    f32.select $push3=, $7, $3, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.lt $push4=, $2, $6
; NO-SIMD128-NEXT:    f32.select $push5=, $6, $2, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.lt $push6=, $1, $5
; NO-SIMD128-NEXT:    f32.select $push7=, $5, $1, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_v4f32:
; NO-SIMD128-FAST:         .functype pmax_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.lt $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $5, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.lt $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.lt $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $7, $3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.lt $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp olt <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x float> @pmax_v4f32_fast_ogt(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmax_v4f32_fast_ogt:
; SIMD128:         .functype pmax_v4f32_fast_ogt (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_v4f32_fast_ogt:
; SIMD128-FAST:         .functype pmax_v4f32_fast_ogt (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_v4f32_fast_ogt:
; NO-SIMD128:         .functype pmax_v4f32_fast_ogt (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.gt $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.select $push1=, $4, $8, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.gt $push2=, $3, $7
; NO-SIMD128-NEXT:    f32.select $push3=, $3, $7, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.gt $push4=, $2, $6
; NO-SIMD128-NEXT:    f32.select $push5=, $2, $6, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.gt $push6=, $1, $5
; NO-SIMD128-NEXT:    f32.select $push7=, $1, $5, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_v4f32_fast_ogt:
; NO-SIMD128-FAST:         .functype pmax_v4f32_fast_ogt (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.gt $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.gt $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.gt $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.gt $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp fast ogt <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %x, <4 x float> %y
  ret <4 x float> %a
}

define <4 x float> @pmax_v4f32_fast_olt(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmax_v4f32_fast_olt:
; SIMD128:         .functype pmax_v4f32_fast_olt (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_v4f32_fast_olt:
; SIMD128-FAST:         .functype pmax_v4f32_fast_olt (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_v4f32_fast_olt:
; NO-SIMD128:         .functype pmax_v4f32_fast_olt (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.lt $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.select $push1=, $8, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.lt $push2=, $3, $7
; NO-SIMD128-NEXT:    f32.select $push3=, $7, $3, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.lt $push4=, $2, $6
; NO-SIMD128-NEXT:    f32.select $push5=, $6, $2, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.lt $push6=, $1, $5
; NO-SIMD128-NEXT:    f32.select $push7=, $5, $1, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_v4f32_fast_olt:
; NO-SIMD128-FAST:         .functype pmax_v4f32_fast_olt (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.lt $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $5, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.lt $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.lt $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $7, $3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.lt $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp fast olt <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x float> @pmax_v4f32_fast_oge(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmax_v4f32_fast_oge:
; SIMD128:         .functype pmax_v4f32_fast_oge (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_v4f32_fast_oge:
; SIMD128-FAST:         .functype pmax_v4f32_fast_oge (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_v4f32_fast_oge:
; NO-SIMD128:         .functype pmax_v4f32_fast_oge (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.ge $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.select $push1=, $4, $8, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.ge $push2=, $3, $7
; NO-SIMD128-NEXT:    f32.select $push3=, $3, $7, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.ge $push4=, $2, $6
; NO-SIMD128-NEXT:    f32.select $push5=, $2, $6, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.ge $push6=, $1, $5
; NO-SIMD128-NEXT:    f32.select $push7=, $1, $5, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_v4f32_fast_oge:
; NO-SIMD128-FAST:         .functype pmax_v4f32_fast_oge (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.ge $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.ge $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.ge $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.ge $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp fast oge <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %x, <4 x float> %y
  ret <4 x float> %a
}

define <4 x float> @pmax_v4f32_fast_ole(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmax_v4f32_fast_ole:
; SIMD128:         .functype pmax_v4f32_fast_ole (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_v4f32_fast_ole:
; SIMD128-FAST:         .functype pmax_v4f32_fast_ole (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_v4f32_fast_ole:
; NO-SIMD128:         .functype pmax_v4f32_fast_ole (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.le $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.select $push1=, $8, $4, $pop0
; NO-SIMD128-NEXT:    f32.store 12($0), $pop1
; NO-SIMD128-NEXT:    f32.le $push2=, $3, $7
; NO-SIMD128-NEXT:    f32.select $push3=, $7, $3, $pop2
; NO-SIMD128-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-NEXT:    f32.le $push4=, $2, $6
; NO-SIMD128-NEXT:    f32.select $push5=, $6, $2, $pop4
; NO-SIMD128-NEXT:    f32.store 4($0), $pop5
; NO-SIMD128-NEXT:    f32.le $push6=, $1, $5
; NO-SIMD128-NEXT:    f32.select $push7=, $5, $1, $pop6
; NO-SIMD128-NEXT:    f32.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_v4f32_fast_ole:
; NO-SIMD128-FAST:         .functype pmax_v4f32_fast_ole (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.le $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $5, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.le $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.le $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $7, $3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    f32.le $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp fast ole <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x i32> @pmax_int_v4f32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: pmax_int_v4f32:
; SIMD128:         .functype pmax_int_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_int_v4f32:
; SIMD128-FAST:         .functype pmax_int_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_int_v4f32:
; NO-SIMD128:         .functype pmax_int_v4f32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push1=, $4
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push0=, $8
; NO-SIMD128-NEXT:    f32.lt $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $8, $4, $pop2
; NO-SIMD128-NEXT:    i32.store 12($0), $pop3
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push5=, $3
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push4=, $7
; NO-SIMD128-NEXT:    f32.lt $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.select $push7=, $7, $3, $pop6
; NO-SIMD128-NEXT:    i32.store 8($0), $pop7
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push9=, $2
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push8=, $6
; NO-SIMD128-NEXT:    f32.lt $push10=, $pop9, $pop8
; NO-SIMD128-NEXT:    i32.select $push11=, $6, $2, $pop10
; NO-SIMD128-NEXT:    i32.store 4($0), $pop11
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push13=, $1
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push12=, $5
; NO-SIMD128-NEXT:    f32.lt $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.select $push15=, $5, $1, $pop14
; NO-SIMD128-NEXT:    i32.store 0($0), $pop15
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_int_v4f32:
; NO-SIMD128-FAST:         .functype pmax_int_v4f32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push1=, $1
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push0=, $5
; NO-SIMD128-FAST-NEXT:    f32.lt $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $5, $1, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push5=, $2
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push4=, $6
; NO-SIMD128-FAST-NEXT:    f32.lt $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $6, $2, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop7
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push9=, $3
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push8=, $7
; NO-SIMD128-FAST-NEXT:    f32.lt $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $7, $3, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop11
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push13=, $4
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push12=, $8
; NO-SIMD128-FAST-NEXT:    f32.lt $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $8, $4, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store 12($0), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %fx = bitcast <4 x i32> %x to <4 x float>
  %fy = bitcast <4 x i32> %y to <4 x float>
  %c = fcmp olt <4 x float> %fx, %fy
  %a = select <4 x i1> %c, <4 x i32> %y, <4 x i32> %x
  ret <4 x i32> %a
}

define <4 x float> @add_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: add_v4f32:
; SIMD128:         .functype add_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v4f32:
; SIMD128-FAST:         .functype add_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v4f32:
; NO-SIMD128:         .functype add_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.add $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.store 12($0), $pop0
; NO-SIMD128-NEXT:    f32.add $push1=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.add $push2=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.add $push3=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v4f32:
; NO-SIMD128-FAST:         .functype add_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.add $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.add $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.add $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.add $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = fadd <4 x float> %x, %y
  ret <4 x float> %a
}

define <4 x float> @sub_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: sub_v4f32:
; SIMD128:         .functype sub_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v4f32:
; SIMD128-FAST:         .functype sub_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v4f32:
; NO-SIMD128:         .functype sub_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.sub $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.store 12($0), $pop0
; NO-SIMD128-NEXT:    f32.sub $push1=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.sub $push2=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.sub $push3=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v4f32:
; NO-SIMD128-FAST:         .functype sub_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.sub $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.sub $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.sub $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.sub $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = fsub <4 x float> %x, %y
  ret <4 x float> %a
}

define <4 x float> @div_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: div_v4f32:
; SIMD128:         .functype div_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.div $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: div_v4f32:
; SIMD128-FAST:         .functype div_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.div $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: div_v4f32:
; NO-SIMD128:         .functype div_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.div $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.store 12($0), $pop0
; NO-SIMD128-NEXT:    f32.div $push1=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.div $push2=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.div $push3=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: div_v4f32:
; NO-SIMD128-FAST:         .functype div_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.div $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.div $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.div $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.div $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = fdiv <4 x float> %x, %y
  ret <4 x float> %a
}

define <4 x float> @mul_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: mul_v4f32:
; SIMD128:         .functype mul_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.mul $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: mul_v4f32:
; SIMD128-FAST:         .functype mul_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.mul $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v4f32:
; NO-SIMD128:         .functype mul_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.mul $push0=, $4, $8
; NO-SIMD128-NEXT:    f32.store 12($0), $pop0
; NO-SIMD128-NEXT:    f32.mul $push1=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.mul $push2=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.mul $push3=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v4f32:
; NO-SIMD128-FAST:         .functype mul_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.mul $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.mul $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.mul $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.mul $push3=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = fmul <4 x float> %x, %y
  ret <4 x float> %a
}

declare <4 x float> @llvm.sqrt.v4f32(<4 x float> %x)
define <4 x float> @sqrt_v4f32(<4 x float> %x) {
; SIMD128-LABEL: sqrt_v4f32:
; SIMD128:         .functype sqrt_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.sqrt $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sqrt_v4f32:
; SIMD128-FAST:         .functype sqrt_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.sqrt $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sqrt_v4f32:
; NO-SIMD128:         .functype sqrt_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.sqrt $push0=, $4
; NO-SIMD128-NEXT:    f32.store 12($0), $pop0
; NO-SIMD128-NEXT:    f32.sqrt $push1=, $3
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.sqrt $push2=, $2
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.sqrt $push3=, $1
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sqrt_v4f32:
; NO-SIMD128-FAST:         .functype sqrt_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.sqrt $push0=, $1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.sqrt $push1=, $2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.sqrt $push2=, $3
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.sqrt $push3=, $4
; NO-SIMD128-FAST-NEXT:    f32.store 12($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.sqrt.v4f32(<4 x float> %x)
  ret <4 x float> %a
}

; ==============================================================================
; 2 x double
; ==============================================================================
define <2 x double> @neg_v2f64(<2 x double> %x) {
  ; nsz makes this semantically equivalent to flipping sign bit
; SIMD128-LABEL: neg_v2f64:
; SIMD128:         .functype neg_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v2f64:
; SIMD128-FAST:         .functype neg_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v2f64:
; NO-SIMD128:         .functype neg_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.neg $push0=, $2
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.neg $push1=, $1
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v2f64:
; NO-SIMD128-FAST:         .functype neg_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.neg $push0=, $1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.neg $push1=, $2
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = fsub nsz <2 x double> <double 0., double 0.>, %x
  ret <2 x double> %a
}

declare <2 x double> @llvm.fabs.v2f64(<2 x double>) nounwind readnone
define <2 x double> @abs_v2f64(<2 x double> %x) {
; SIMD128-LABEL: abs_v2f64:
; SIMD128:         .functype abs_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v2f64:
; SIMD128-FAST:         .functype abs_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v2f64:
; NO-SIMD128:         .functype abs_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.abs $push0=, $2
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.abs $push1=, $1
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v2f64:
; NO-SIMD128-FAST:         .functype abs_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.abs $push0=, $1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.abs $push1=, $2
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.fabs.v2f64(<2 x double> %x)
  ret <2 x double> %a
}

define <2 x double> @min_unordered_v2f64(<2 x double> %x) {
; SIMD128-LABEL: min_unordered_v2f64:
; SIMD128:         .functype min_unordered_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f64x2.pmin $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: min_unordered_v2f64:
; SIMD128-FAST:         .functype min_unordered_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f64x2.pmin $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_unordered_v2f64:
; NO-SIMD128:         .functype min_unordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.gt $push1=, $2, $pop7
; NO-SIMD128-NEXT:    f64.select $push2=, $pop0, $2, $pop1
; NO-SIMD128-NEXT:    f64.store 8($0), $pop2
; NO-SIMD128-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.gt $push3=, $1, $pop5
; NO-SIMD128-NEXT:    f64.select $push4=, $pop6, $1, $pop3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_unordered_v2f64:
; NO-SIMD128-FAST:         .functype min_unordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.gt $push1=, $1, $pop7
; NO-SIMD128-FAST-NEXT:    f64.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.gt $push3=, $2, $pop5
; NO-SIMD128-FAST-NEXT:    f64.select $push4=, $pop6, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp ule <2 x double> %x, <double 5., double 5.>
  %a = select <2 x i1> %cmps, <2 x double> %x,
    <2 x double> <double 5., double 5.>
  ret <2 x double> %a
}

define <2 x double> @max_unordered_v2f64(<2 x double> %x) {
; SIMD128-LABEL: max_unordered_v2f64:
; SIMD128:         .functype max_unordered_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f64x2.pmax $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: max_unordered_v2f64:
; SIMD128-FAST:         .functype max_unordered_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f64x2.pmax $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_unordered_v2f64:
; NO-SIMD128:         .functype max_unordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.lt $push1=, $2, $pop7
; NO-SIMD128-NEXT:    f64.select $push2=, $pop0, $2, $pop1
; NO-SIMD128-NEXT:    f64.store 8($0), $pop2
; NO-SIMD128-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.lt $push3=, $1, $pop5
; NO-SIMD128-NEXT:    f64.select $push4=, $pop6, $1, $pop3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_unordered_v2f64:
; NO-SIMD128-FAST:         .functype max_unordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.lt $push1=, $1, $pop7
; NO-SIMD128-FAST-NEXT:    f64.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.lt $push3=, $2, $pop5
; NO-SIMD128-FAST-NEXT:    f64.select $push4=, $pop6, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp uge <2 x double> %x, <double 5., double 5.>
  %a = select <2 x i1> %cmps, <2 x double> %x,
    <2 x double> <double 5., double 5.>
  ret <2 x double> %a
}

define <2 x double> @min_ordered_v2f64(<2 x double> %x) {
; SIMD128-LABEL: min_ordered_v2f64:
; SIMD128:         .functype min_ordered_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f64x2.pmin $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: min_ordered_v2f64:
; SIMD128-FAST:         .functype min_ordered_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f64x2.pmin $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_ordered_v2f64:
; NO-SIMD128:         .functype min_ordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.ge $push1=, $2, $pop7
; NO-SIMD128-NEXT:    f64.select $push2=, $pop0, $2, $pop1
; NO-SIMD128-NEXT:    f64.store 8($0), $pop2
; NO-SIMD128-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.ge $push3=, $1, $pop5
; NO-SIMD128-NEXT:    f64.select $push4=, $pop6, $1, $pop3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_ordered_v2f64:
; NO-SIMD128-FAST:         .functype min_ordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.ge $push1=, $1, $pop7
; NO-SIMD128-FAST-NEXT:    f64.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.ge $push3=, $2, $pop5
; NO-SIMD128-FAST-NEXT:    f64.select $push4=, $pop6, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp ole <2 x double> <double 5., double 5.>, %x
  %a = select <2 x i1> %cmps, <2 x double> <double 5., double 5.>,
    <2 x double> %x
  ret <2 x double> %a
}

define <2 x double> @max_ordered_v2f64(<2 x double> %x) {
; SIMD128-LABEL: max_ordered_v2f64:
; SIMD128:         .functype max_ordered_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f64x2.pmax $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: max_ordered_v2f64:
; SIMD128-FAST:         .functype max_ordered_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f64x2.pmax $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_ordered_v2f64:
; NO-SIMD128:         .functype max_ordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.le $push1=, $2, $pop7
; NO-SIMD128-NEXT:    f64.select $push2=, $pop0, $2, $pop1
; NO-SIMD128-NEXT:    f64.store 8($0), $pop2
; NO-SIMD128-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.le $push3=, $1, $pop5
; NO-SIMD128-NEXT:    f64.select $push4=, $pop6, $1, $pop3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_ordered_v2f64:
; NO-SIMD128-FAST:         .functype max_ordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.le $push1=, $1, $pop7
; NO-SIMD128-FAST-NEXT:    f64.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.le $push3=, $2, $pop5
; NO-SIMD128-FAST-NEXT:    f64.select $push4=, $pop6, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp oge <2 x double> <double 5., double 5.>, %x
  %a = select <2 x i1> %cmps, <2 x double> <double 5., double 5.>,
    <2 x double> %x
  ret <2 x double> %a
}

declare <2 x double> @llvm.minimum.v2f64(<2 x double>, <2 x double>)
define <2 x double> @min_intrinsic_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: min_intrinsic_v2f64:
; SIMD128:         .functype min_intrinsic_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.min $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_intrinsic_v2f64:
; SIMD128-FAST:         .functype min_intrinsic_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.min $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_intrinsic_v2f64:
; NO-SIMD128:         .functype min_intrinsic_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.min $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.min $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_intrinsic_v2f64:
; NO-SIMD128-FAST:         .functype min_intrinsic_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.min $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.min $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.minimum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %a
}

declare <2 x double> @llvm.maximum.v2f64(<2 x double>, <2 x double>)
define <2 x double> @max_intrinsic_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: max_intrinsic_v2f64:
; SIMD128:         .functype max_intrinsic_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.max $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_intrinsic_v2f64:
; SIMD128-FAST:         .functype max_intrinsic_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.max $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_intrinsic_v2f64:
; NO-SIMD128:         .functype max_intrinsic_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.max $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.max $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_intrinsic_v2f64:
; NO-SIMD128-FAST:         .functype max_intrinsic_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.max $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.max $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.maximum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %a
}

define <2 x double> @min_const_intrinsic_v2f64() {
; SIMD128-LABEL: min_const_intrinsic_v2f64:
; SIMD128:         .functype min_const_intrinsic_v2f64 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_const_intrinsic_v2f64:
; SIMD128-FAST:         .functype min_const_intrinsic_v2f64 () -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_const_intrinsic_v2f64:
; NO-SIMD128:         .functype min_const_intrinsic_v2f64 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 4617315517961601024
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 4617315517961601024
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_const_intrinsic_v2f64:
; NO-SIMD128-FAST:         .functype min_const_intrinsic_v2f64 (i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 4617315517961601024
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.const $push1=, 4617315517961601024
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.minimum.v2f64(
    <2 x double> <double 42., double 42.>,
    <2 x double> <double 5., double 5.>
  )
  ret <2 x double> %a
}

define <2 x double> @max_const_intrinsic_v2f64() {
; SIMD128-LABEL: max_const_intrinsic_v2f64:
; SIMD128:         .functype max_const_intrinsic_v2f64 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.5p5, 0x1.5p5
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_const_intrinsic_v2f64:
; SIMD128-FAST:         .functype max_const_intrinsic_v2f64 () -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push0=, 0x1.5p5, 0x1.5p5
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_const_intrinsic_v2f64:
; NO-SIMD128:         .functype max_const_intrinsic_v2f64 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 4631107791820423168
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 4631107791820423168
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_const_intrinsic_v2f64:
; NO-SIMD128-FAST:         .functype max_const_intrinsic_v2f64 (i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 4631107791820423168
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.const $push1=, 4631107791820423168
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.maximum.v2f64(
    <2 x double> <double 42., double 42.>,
    <2 x double> <double 5., double 5.>
  )
  ret <2 x double> %a
}

define <2 x double> @pmin_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: pmin_v2f64:
; SIMD128:         .functype pmin_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.pmin $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_v2f64:
; SIMD128-FAST:         .functype pmin_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.pmin $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_v2f64:
; NO-SIMD128:         .functype pmin_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.lt $push0=, $4, $2
; NO-SIMD128-NEXT:    f64.select $push1=, $4, $2, $pop0
; NO-SIMD128-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-NEXT:    f64.lt $push2=, $3, $1
; NO-SIMD128-NEXT:    f64.select $push3=, $3, $1, $pop2
; NO-SIMD128-NEXT:    f64.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_v2f64:
; NO-SIMD128-FAST:         .functype pmin_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.lt $push0=, $3, $1
; NO-SIMD128-FAST-NEXT:    f64.select $push1=, $3, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f64.lt $push2=, $4, $2
; NO-SIMD128-FAST-NEXT:    f64.select $push3=, $4, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp olt <2 x double> %y, %x
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

define <2 x i64> @pmin_int_v2f64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: pmin_int_v2f64:
; SIMD128:         .functype pmin_int_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.pmin $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_int_v2f64:
; SIMD128-FAST:         .functype pmin_int_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.pmin $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_int_v2f64:
; NO-SIMD128:         .functype pmin_int_v2f64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push1=, $4
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push0=, $2
; NO-SIMD128-NEXT:    f64.lt $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.select $push3=, $4, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop3
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push5=, $3
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push4=, $1
; NO-SIMD128-NEXT:    f64.lt $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i64.select $push7=, $3, $1, $pop6
; NO-SIMD128-NEXT:    i64.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_int_v2f64:
; NO-SIMD128-FAST:         .functype pmin_int_v2f64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push1=, $3
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push0=, $1
; NO-SIMD128-FAST-NEXT:    f64.lt $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.select $push3=, $3, $1, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push5=, $4
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push4=, $2
; NO-SIMD128-FAST-NEXT:    f64.lt $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i64.select $push7=, $4, $2, $pop6
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %fx = bitcast <2 x i64> %x to <2 x double>
  %fy = bitcast <2 x i64> %y to <2 x double>
  %c = fcmp olt <2 x double> %fy, %fx
  %a = select <2 x i1> %c, <2 x i64> %y, <2 x i64> %x
  ret <2 x i64> %a
}

define <2 x double> @pmax_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: pmax_v2f64:
; SIMD128:         .functype pmax_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_v2f64:
; SIMD128-FAST:         .functype pmax_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_v2f64:
; NO-SIMD128:         .functype pmax_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.lt $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.select $push1=, $4, $2, $pop0
; NO-SIMD128-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-NEXT:    f64.lt $push2=, $1, $3
; NO-SIMD128-NEXT:    f64.select $push3=, $3, $1, $pop2
; NO-SIMD128-NEXT:    f64.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_v2f64:
; NO-SIMD128-FAST:         .functype pmax_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.lt $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.select $push1=, $3, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f64.lt $push2=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.select $push3=, $4, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp olt <2 x double> %x, %y
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

define <2 x i64> @pmax_int_v2f64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: pmax_int_v2f64:
; SIMD128:         .functype pmax_int_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_int_v2f64:
; SIMD128-FAST:         .functype pmax_int_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_int_v2f64:
; NO-SIMD128:         .functype pmax_int_v2f64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push1=, $2
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push0=, $4
; NO-SIMD128-NEXT:    f64.lt $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.select $push3=, $4, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop3
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push5=, $1
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push4=, $3
; NO-SIMD128-NEXT:    f64.lt $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i64.select $push7=, $3, $1, $pop6
; NO-SIMD128-NEXT:    i64.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_int_v2f64:
; NO-SIMD128-FAST:         .functype pmax_int_v2f64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push1=, $1
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push0=, $3
; NO-SIMD128-FAST-NEXT:    f64.lt $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.select $push3=, $3, $1, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push5=, $2
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push4=, $4
; NO-SIMD128-FAST-NEXT:    f64.lt $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i64.select $push7=, $4, $2, $pop6
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %fx = bitcast <2 x i64> %x to <2 x double>
  %fy = bitcast <2 x i64> %y to <2 x double>
  %c = fcmp olt <2 x double> %fx, %fy
  %a = select <2 x i1> %c, <2 x i64> %y, <2 x i64> %x
  ret <2 x i64> %a
}

define <2 x double> @add_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: add_v2f64:
; SIMD128:         .functype add_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v2f64:
; SIMD128-FAST:         .functype add_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v2f64:
; NO-SIMD128:         .functype add_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.add $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.add $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v2f64:
; NO-SIMD128-FAST:         .functype add_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.add $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.add $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = fadd <2 x double> %x, %y
  ret <2 x double> %a
}

define <2 x double> @sub_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: sub_v2f64:
; SIMD128:         .functype sub_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v2f64:
; SIMD128-FAST:         .functype sub_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v2f64:
; NO-SIMD128:         .functype sub_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.sub $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.sub $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v2f64:
; NO-SIMD128-FAST:         .functype sub_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.sub $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.sub $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = fsub <2 x double> %x, %y
  ret <2 x double> %a
}

define <2 x double> @div_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: div_v2f64:
; SIMD128:         .functype div_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.div $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: div_v2f64:
; SIMD128-FAST:         .functype div_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.div $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: div_v2f64:
; NO-SIMD128:         .functype div_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.div $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.div $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: div_v2f64:
; NO-SIMD128-FAST:         .functype div_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.div $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.div $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = fdiv <2 x double> %x, %y
  ret <2 x double> %a
}

define <2 x double> @mul_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: mul_v2f64:
; SIMD128:         .functype mul_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.mul $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: mul_v2f64:
; SIMD128-FAST:         .functype mul_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.mul $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v2f64:
; NO-SIMD128:         .functype mul_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.mul $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.mul $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v2f64:
; NO-SIMD128-FAST:         .functype mul_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.mul $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.mul $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = fmul <2 x double> %x, %y
  ret <2 x double> %a
}

declare <2 x double> @llvm.sqrt.v2f64(<2 x double> %x)
define <2 x double> @sqrt_v2f64(<2 x double> %x) {
; SIMD128-LABEL: sqrt_v2f64:
; SIMD128:         .functype sqrt_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.sqrt $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sqrt_v2f64:
; SIMD128-FAST:         .functype sqrt_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.sqrt $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sqrt_v2f64:
; NO-SIMD128:         .functype sqrt_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.sqrt $push0=, $2
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.sqrt $push1=, $1
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sqrt_v2f64:
; NO-SIMD128-FAST:         .functype sqrt_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.sqrt $push0=, $1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.sqrt $push1=, $2
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %x)
  ret <2 x double> %a
}
