; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc < %s -verify-machineinstrs -mattr=+simd128 | FileCheck %s

target triple = "wasm32-unknown-unknown"

declare <8 x i32> @llvm.smin.v8i32(<8 x i32>, <8 x i32>) #2
declare <8 x i32> @llvm.smax.v8i32(<8 x i32>, <8 x i32>) #2

define <16 x i8> @i16_signed(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: i16_signed:
; CHECK:         .functype i16_signed (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %bb2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i8x16.narrow_i16x8_s
; CHECK-NEXT:    # fallthrough-return
bb2:
  %0 = shufflevector <8 x i16> %a, <8 x i16> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1 = tail call <16 x i16> @llvm.smax.v16i16(<16 x i16> %0, <16 x i16> splat (i16 -128))
  %2 = tail call <16 x i16> @llvm.smin.v16i16(<16 x i16> %1, <16 x i16> splat (i16 127))
  %3 = trunc nsw <16 x i16> %2 to <16 x i8>
  ret <16 x i8> %3
  ret <16 x i8> %3
}

define <8 x i16> @i32_signed(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: i32_signed:
; CHECK:         .functype i32_signed (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %bb2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i16x8.narrow_i32x4_s
; CHECK-NEXT:    # fallthrough-return
bb2:
  %0 = shufflevector <4 x i32> %a, <4 x i32> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1 = tail call <8 x i32> @llvm.smax.v8i32(<8 x i32> %0, <8 x i32> splat (i32 -32768))
  %2 = tail call <8 x i32> @llvm.smin.v8i32(<8 x i32> %1, <8 x i32> splat (i32 32767))
  %3 = trunc nsw <8 x i32> %2 to <8 x i16>
  ret <8 x i16> %3
}

define <8 x i16> @i32_signed_flipped(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: i32_signed_flipped:
; CHECK:         .functype i32_signed_flipped (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %bb2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i16x8.narrow_i32x4_s
; CHECK-NEXT:    # fallthrough-return
bb2:
  %0 = shufflevector <4 x i32> %a, <4 x i32> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1 = tail call <8 x i32> @llvm.smin.v8i32(<8 x i32> splat (i32 32767), <8 x i32> %0)
  %2 = tail call <8 x i32> @llvm.smax.v8i32(<8 x i32> splat (i32 -32768), <8 x i32> %1)
  %3 = trunc nsw <8 x i32> %2 to <8 x i16>
  ret <8 x i16> %3
}

define <16 x i8> @i16_unsigned(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: i16_unsigned:
; CHECK:         .functype i16_unsigned (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %bb2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i8x16.narrow_i16x8_u
; CHECK-NEXT:    # fallthrough-return
bb2:
  %0 = shufflevector <8 x i16> %a, <8 x i16> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %1 = tail call <16 x i16> @llvm.umin.v16i16(<16 x i16> %0, <16 x i16> splat (i16 255))
  %2 = trunc nuw <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <8 x i16> @i32_unsigned(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: i32_unsigned:
; CHECK:         .functype i32_unsigned (v128, v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %bb2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i16x8.narrow_i32x4_u
; CHECK-NEXT:    # fallthrough-return
bb2:
  %0 = shufflevector <4 x i32> %a, <4 x i32> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1 = tail call <8 x i32> @llvm.umin.v8i32(<8 x i32> %0, <8 x i32> splat (i32 65535))
  %2 = trunc nsw <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}
