; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s --mtriple=wasm32-unknown-unknown -mcpu=mvp -mattr=+reference-types -mattr=+gc -verify-machineinstrs | FileCheck --check-prefixes CHECK,CHK32 %s
; RUN: llc < %s --mtriple=wasm64-unknown-unknown -mcpu=mvp -mattr=+reference-types -mattr=+gc -verify-machineinstrs | FileCheck --check-prefixes CHECK,CHK64 %s

define void @test_fpsig_void_void(ptr noundef %func) local_unnamed_addr #0 {
; CHECK-LABEL: test_fpsig_void_void:
; CHK32:         .functype test_fpsig_void_void (i32) -> ()
; CHK64:         .functype test_fpsig_void_void (i64) -> ()
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHK64-NEXT:    i32.wrap_i64
; CHECK-NEXT:    table.get __indirect_function_table
; CHECK-NEXT:    ref.test () -> ()
; CHECK-NEXT:    call use
; CHECK-NEXT:    # fallthrough-return
entry:
  %res = tail call i32 (ptr, ...) @llvm.wasm.ref.test.func(ptr %func)
  tail call void @use(i32 noundef %res) #3
  ret void
}

define void @test_fpsig_return_i32(ptr noundef %func) local_unnamed_addr #0 {
; CHECK-LABEL: test_fpsig_return_i32:
; CHK32:         .functype test_fpsig_return_i32 (i32) -> ()
; CHK64:         .functype test_fpsig_return_i32 (i64) -> ()
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHK64-NEXT:    i32.wrap_i64
; CHECK-NEXT:    table.get __indirect_function_table
; CHECK-NEXT:    ref.test () -> (i32)
; CHECK-NEXT:    call use
; CHECK-NEXT:    # fallthrough-return
entry:
  %res = tail call i32 (ptr, ...) @llvm.wasm.ref.test.func(ptr %func, i32 poison)
  tail call void @use(i32 noundef %res) #3
  ret void
}

define void @test_fpsig_return_i64(ptr noundef %func) local_unnamed_addr #0 {
; CHECK-LABEL: test_fpsig_return_i64:
; CHK32:         .functype test_fpsig_return_i64 (i32) -> ()
; CHK64:         .functype test_fpsig_return_i64 (i64) -> ()
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHK64-NEXT:    i32.wrap_i64
; CHECK-NEXT:    table.get __indirect_function_table
; CHECK-NEXT:    ref.test () -> (i64)
; CHECK-NEXT:    call use
; CHECK-NEXT:    # fallthrough-return
entry:
  %res = tail call i32 (ptr, ...) @llvm.wasm.ref.test.func(ptr %func, i64 poison)
  tail call void @use(i32 noundef %res) #3
  ret void
}

define void @test_fpsig_return_f32(ptr noundef %func) local_unnamed_addr #0 {
; CHECK-LABEL: test_fpsig_return_f32:
; CHK32:         .functype test_fpsig_return_f32 (i32) -> ()
; CHK64:         .functype test_fpsig_return_f32 (i64) -> ()
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHK64-NEXT:    i32.wrap_i64
; CHECK-NEXT:    table.get __indirect_function_table
; CHECK-NEXT:    ref.test () -> (f32)
; CHECK-NEXT:    call use
; CHECK-NEXT:    # fallthrough-return
entry:
  %res = tail call i32 (ptr, ...) @llvm.wasm.ref.test.func(ptr %func, float poison)
  tail call void @use(i32 noundef %res) #3
  ret void
}

define void @test_fpsig_return_f64(ptr noundef %func) local_unnamed_addr #0 {
; CHECK-LABEL: test_fpsig_return_f64:
; CHK32:         .functype test_fpsig_return_f64 (i32) -> ()
; CHK64:         .functype test_fpsig_return_f64 (i64) -> ()
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHK64-NEXT:    i32.wrap_i64
; CHECK-NEXT:    table.get __indirect_function_table
; CHECK-NEXT:    ref.test () -> (f64)
; CHECK-NEXT:    call use
; CHECK-NEXT:    # fallthrough-return
entry:
  %res = tail call i32 (ptr, ...) @llvm.wasm.ref.test.func(ptr %func, double poison)
  tail call void @use(i32 noundef %res) #3
  ret void
}


define void @test_fpsig_param_i32(ptr noundef %func) local_unnamed_addr #0 {
; CHECK-LABEL: test_fpsig_param_i32:
; CHK32:         .functype test_fpsig_param_i32 (i32) -> ()
; CHK64:         .functype test_fpsig_param_i32 (i64) -> ()
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHK64-NEXT:    i32.wrap_i64
; CHECK-NEXT:    table.get __indirect_function_table
; CHECK-NEXT:    ref.test (f64) -> ()
; CHECK-NEXT:    call use
; CHECK-NEXT:    # fallthrough-return
entry:
  %res = tail call i32 (ptr, ...) @llvm.wasm.ref.test.func(ptr %func, token poison, double poison)
  tail call void @use(i32 noundef %res) #3
  ret void
}


define void @test_fpsig_multiple_params_and_returns(ptr noundef %func) local_unnamed_addr #0 {
; CHECK-LABEL: test_fpsig_multiple_params_and_returns:
; CHK32:         .functype test_fpsig_multiple_params_and_returns (i32) -> ()
; CHK64:         .functype test_fpsig_multiple_params_and_returns (i64) -> ()
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHK64-NEXT:    i32.wrap_i64
; CHECK-NEXT:    table.get __indirect_function_table
; CHECK-NEXT:    ref.test (i64, f32, i64) -> (i32, i64, f32, f64)
; CHECK-NEXT:    call use
; CHECK-NEXT:    # fallthrough-return
entry:
  %res = tail call i32 (ptr, ...) @llvm.wasm.ref.test.func(ptr %func, i32 poison, i64 poison, float poison, double poison, token poison, i64 poison, float poison, i64 poison)
  tail call void @use(i32 noundef %res) #3
  ret void
}


define void @test_fpsig_ptrs(ptr noundef %func) local_unnamed_addr #0 {
; CHECK-LABEL: test_fpsig_ptrs:
; CHK32:         .functype test_fpsig_ptrs (i32) -> ()
; CHK64:         .functype test_fpsig_ptrs (i64) -> ()
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHK64-NEXT:    i32.wrap_i64
; CHECK-NEXT:    table.get __indirect_function_table
; CHK32-NEXT:    ref.test (i32, i32) -> (i32)
; CHK64-NEXT:    ref.test (i64, i64) -> (i64)
; CHECK-NEXT:    call use
; CHECK-NEXT:    # fallthrough-return
entry:
  %res = tail call i32 (ptr, ...) @llvm.wasm.ref.test.func(ptr %func, ptr poison, token poison, ptr poison, ptr poison)
  tail call void @use(i32 noundef %res) #3
  ret void
}

define void @test_reference_types(ptr noundef %func) local_unnamed_addr #0 {
; CHECK-LABEL: test_reference_types:
; CHK32:         .functype test_reference_types (i32) -> ()
; CHK64:         .functype test_reference_types (i64) -> ()
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHK64-NEXT:    i32.wrap_i64
; CHECK-NEXT:    table.get __indirect_function_table
; CHECK-NEXT:    ref.test (funcref, externref) -> (externref)
; CHECK-NEXT:    call use
; CHECK-NEXT:    # fallthrough-return
entry:
  %res = tail call i32 (ptr, ...) @llvm.wasm.ref.test.func(ptr %func, ptr addrspace(10) poison, token poison, ptr addrspace(20) poison, ptr addrspace(10) poison)
  tail call void @use(i32 noundef %res) #3
  ret void
}

declare void @use(i32 noundef) local_unnamed_addr #1
