; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py

; Tests for lrint and llrint, with both i32 and i64 checked.

; RUN: sed 's/ITy/i32/g' %s | llc -mtriple=wasm32-unknown-unknown | FileCheck %s
; RUN: sed 's/ITy/i64/g' %s | llc -mtriple=wasm32-unknown-unknown | FileCheck %s

define ITy @test_lrint_ixx_f16(half %x) nounwind {
; CHECK-LABEL: test_lrint_ixx_f16:
; CHECK:         call lrintf
  %res = tail call ITy @llvm.lrint.ITy.f16(half %x)
  ret ITy %res
}

define ITy @test_llrint_ixx_f16(half %x) nounwind {
; CHECK-LABEL: test_llrint_ixx_f16:
; CHECK:         call llrintf
  %res = tail call ITy @llvm.llrint.ITy.f16(half %x)
  ret ITy %res
}

define ITy @test_lrint_ixx_f32(float %x) nounwind {
; CHECK-LABEL: test_lrint_ixx_f32:
; CHECK:         call lrintf
  %res = tail call ITy @llvm.lrint.ITy.f32(float %x)
  ret ITy %res
}

define ITy @test_llrint_ixx_f32(float %x) nounwind {
; CHECK-LABEL: test_llrint_ixx_f32:
; CHECK:         call llrintf
  %res = tail call ITy @llvm.llrint.ITy.f32(float %x)
  ret ITy %res
}

define ITy @test_lrint_ixx_f64(double %x) nounwind {
; CHECK-LABEL: test_lrint_ixx_f64:
; CHECK:         call lrint
  %res = tail call ITy @llvm.lrint.ITy.f64(double %x)
  ret ITy %res
}

define ITy @test_llrint_ixx_f64(double %x) nounwind {
; CHECK-LABEL: test_llrint_ixx_f64:
; CHECK:         call llrint
  %res = tail call ITy @llvm.llrint.ITy.f64(double %x)
  ret ITy %res
}

define ITy @test_lrint_ixx_f128(fp128 %x) nounwind {
; CHECK-LABEL: test_lrint_ixx_f128:
; CHECK:         call lrintl
  %res = tail call ITy @llvm.lrint.ITy.f128(fp128 %x)
  ret ITy %res
}

define ITy @test_llrint_ixx_f128(fp128 %x) nounwind {
; CHECK-LABEL: test_llrint_ixx_f128:
; CHECK:         call llrintl
  %res = tail call ITy @llvm.llrint.ITy.f128(fp128 %x)
  ret ITy %res
}
