; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -wasm-lower-em-ehsjlj -wasm-enable-sjlj -mtriple=wasm32-unknown-emscripten < %s | FileCheck %s

@buf = external global i8
declare i32 @setjmp(ptr) returns_twice
declare void @dummy()

define void @test_static() {
; CHECK-LABEL: define void @test_static() personality ptr @__gxx_wasm_personality_v0 {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[X:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[FUNCTIONINVOCATIONID:%.*]] = alloca i32, align 4
; CHECK-NEXT:    br label %[[SETJMP_DISPATCH:.*]]
; CHECK:       [[SETJMP_DISPATCH]]:
; CHECK-NEXT:    [[VAL1:%.*]] = phi i32 [ [[VAL:%.*]], %[[IF_END:.*]] ], [ undef, %[[ENTRY]] ]
; CHECK-NEXT:    [[LABEL_PHI:%.*]] = phi i32 [ [[LABEL:%.*]], %[[IF_END]] ], [ -1, %[[ENTRY]] ]
; CHECK-NEXT:    switch i32 [[LABEL_PHI]], label %[[ENTRY_SPLIT:.*]] [
; CHECK-NEXT:      i32 1, label %[[ENTRY_SPLIT_SPLIT:.*]]
; CHECK-NEXT:    ]
; CHECK:       [[ENTRY_SPLIT]]:
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(ptr [[X]])
; CHECK-NEXT:    call void @__wasm_setjmp(ptr @buf, i32 1, ptr [[FUNCTIONINVOCATIONID]])
; CHECK-NEXT:    br label %[[ENTRY_SPLIT_SPLIT]]
; CHECK:       [[ENTRY_SPLIT_SPLIT]]:
; CHECK-NEXT:    [[SETJMP_RET:%.*]] = phi i32 [ 0, %[[ENTRY_SPLIT]] ], [ [[VAL1]], %[[SETJMP_DISPATCH]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[SETJMP_RET]], 0
; CHECK-NEXT:    br i1 [[CMP]], label %[[IF:.*]], label %[[ELSE:.*]]
; CHECK:       [[IF]]:
; CHECK-NEXT:    invoke void @dummy()
; CHECK-NEXT:            to [[DOTNOEXC:label %.*]] unwind label %[[CATCH_DISPATCH_LONGJMP:.*]]
; CHECK:       [[_NOEXC:.*:]]
; CHECK-NEXT:    ret void
; CHECK:       [[ELSE]]:
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(ptr [[X]])
; CHECK-NEXT:    ret void
; CHECK:       [[CATCH_DISPATCH_LONGJMP]]:
; CHECK-NEXT:    [[TMP0:%.*]] = catchswitch within none [label %catch.longjmp] unwind to caller
; CHECK:       [[CATCH_LONGJMP:.*:]]
; CHECK-NEXT:    [[TMP1:%.*]] = catchpad within [[TMP0]] []
; CHECK-NEXT:    [[THROWN:%.*]] = call ptr @llvm.wasm.catch(i32 1)
; CHECK-NEXT:    [[ENV_GEP:%.*]] = getelementptr { ptr, i32 }, ptr [[THROWN]], i32 0, i32 0
; CHECK-NEXT:    [[VAL_GEP:%.*]] = getelementptr { ptr, i32 }, ptr [[THROWN]], i32 0, i32 1
; CHECK-NEXT:    [[ENV:%.*]] = load ptr, ptr [[ENV_GEP]], align 4
; CHECK-NEXT:    [[VAL]] = load i32, ptr [[VAL_GEP]], align 4
; CHECK-NEXT:    [[LABEL]] = call i32 @__wasm_setjmp_test(ptr [[ENV]], ptr [[FUNCTIONINVOCATIONID]]) [ "funclet"(token [[TMP1]]) ]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[LABEL]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label %[[IF_THEN:.*]], label %[[IF_END]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    call void @__wasm_longjmp(ptr [[ENV]], i32 [[VAL]]) [ "funclet"(token [[TMP1]]) ]
; CHECK-NEXT:    unreachable
; CHECK:       [[IF_END]]:
; CHECK-NEXT:    catchret from [[TMP1]] to label %[[SETJMP_DISPATCH]]
;
entry:
  %x = alloca i32, align 4
  call void @llvm.lifetime.start.p0(ptr %x)
  %call = call i32 @setjmp(ptr @buf) returns_twice
  %cmp = icmp eq i32 %call, 0
  br i1 %cmp, label %if, label %else

if:
  call void @dummy()
  ret void

else:
  call void @llvm.lifetime.end.p0(ptr %x)
  ret void
}

define void @test_dynamic(i32 %size) {
; CHECK-LABEL: define void @test_dynamic(
; CHECK-SAME: i32 [[SIZE:%.*]]) personality ptr @__gxx_wasm_personality_v0 {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[FUNCTIONINVOCATIONID:%.*]] = alloca i32, align 4
; CHECK-NEXT:    br label %[[SETJMP_DISPATCH:.*]]
; CHECK:       [[SETJMP_DISPATCH]]:
; CHECK-NEXT:    [[VAL1:%.*]] = phi i32 [ [[VAL:%.*]], %[[IF_END:.*]] ], [ undef, %[[ENTRY]] ]
; CHECK-NEXT:    [[LABEL_PHI:%.*]] = phi i32 [ [[LABEL:%.*]], %[[IF_END]] ], [ -1, %[[ENTRY]] ]
; CHECK-NEXT:    switch i32 [[LABEL_PHI]], label %[[ENTRY_SPLIT:.*]] [
; CHECK-NEXT:      i32 1, label %[[ENTRY_SPLIT_SPLIT:.*]]
; CHECK-NEXT:    ]
; CHECK:       [[ENTRY_SPLIT]]:
; CHECK-NEXT:    [[X:%.*]] = alloca i32, i32 [[SIZE]], align 4
; CHECK-NEXT:    call void @__wasm_setjmp(ptr @buf, i32 1, ptr [[FUNCTIONINVOCATIONID]])
; CHECK-NEXT:    br label %[[ENTRY_SPLIT_SPLIT]]
; CHECK:       [[ENTRY_SPLIT_SPLIT]]:
; CHECK-NEXT:    [[SETJMP_RET:%.*]] = phi i32 [ 0, %[[ENTRY_SPLIT]] ], [ [[VAL1]], %[[SETJMP_DISPATCH]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[SETJMP_RET]], 0
; CHECK-NEXT:    br i1 [[CMP]], label %[[IF:.*]], label %[[ELSE:.*]]
; CHECK:       [[IF]]:
; CHECK-NEXT:    invoke void @dummy()
; CHECK-NEXT:            to [[DOTNOEXC:label %.*]] unwind label %[[CATCH_DISPATCH_LONGJMP:.*]]
; CHECK:       [[_NOEXC:.*:]]
; CHECK-NEXT:    ret void
; CHECK:       [[ELSE]]:
; CHECK-NEXT:    ret void
; CHECK:       [[CATCH_DISPATCH_LONGJMP]]:
; CHECK-NEXT:    [[TMP0:%.*]] = catchswitch within none [label %catch.longjmp] unwind to caller
; CHECK:       [[CATCH_LONGJMP:.*:]]
; CHECK-NEXT:    [[TMP1:%.*]] = catchpad within [[TMP0]] []
; CHECK-NEXT:    [[THROWN:%.*]] = call ptr @llvm.wasm.catch(i32 1)
; CHECK-NEXT:    [[ENV_GEP:%.*]] = getelementptr { ptr, i32 }, ptr [[THROWN]], i32 0, i32 0
; CHECK-NEXT:    [[VAL_GEP:%.*]] = getelementptr { ptr, i32 }, ptr [[THROWN]], i32 0, i32 1
; CHECK-NEXT:    [[ENV:%.*]] = load ptr, ptr [[ENV_GEP]], align 4
; CHECK-NEXT:    [[VAL]] = load i32, ptr [[VAL_GEP]], align 4
; CHECK-NEXT:    [[LABEL]] = call i32 @__wasm_setjmp_test(ptr [[ENV]], ptr [[FUNCTIONINVOCATIONID]]) [ "funclet"(token [[TMP1]]) ]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[LABEL]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label %[[IF_THEN:.*]], label %[[IF_END]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    call void @__wasm_longjmp(ptr [[ENV]], i32 [[VAL]]) [ "funclet"(token [[TMP1]]) ]
; CHECK-NEXT:    unreachable
; CHECK:       [[IF_END]]:
; CHECK-NEXT:    catchret from [[TMP1]] to label %[[SETJMP_DISPATCH]]
;
entry:
  %x = alloca i32, i32 %size, align 4
  call void @llvm.lifetime.start.p0(ptr %x)
  %call = call i32 @setjmp(ptr @buf) returns_twice
  %cmp = icmp eq i32 %call, 0
  br i1 %cmp, label %if, label %else

if:
  call void @dummy()
  ret void

else:
  call void @llvm.lifetime.end.p0(ptr %x)
  ret void
}
