; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=wasm32-unknown-unknown < %s | FileCheck -check-prefixes=CHECK,WASM32 %s
; RUN: llc -mtriple=wasm64-unknown-unknown < %s | FileCheck -check-prefixes=CHECK,WASM64 %s

define { half, half } @test_sincos_f16(half %a) #0 {
; WASM32-LABEL: test_sincos_f16:
; WASM32:         .functype test_sincos_f16 (i32, i32) -> ()
; WASM32-NEXT:    .local f32
; WASM32-NEXT:  # %bb.0:
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call __extendhfsf2
; WASM32-NEXT:    local.tee 2
; WASM32-NEXT:    call cosf
; WASM32-NEXT:    call __truncsfhf2
; WASM32-NEXT:    i32.store16 2
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call sinf
; WASM32-NEXT:    call __truncsfhf2
; WASM32-NEXT:    i32.store16 0
; WASM32-NEXT:    # fallthrough-return
;
; WASM64-LABEL: test_sincos_f16:
; WASM64:         .functype test_sincos_f16 (i64, i32) -> ()
; WASM64-NEXT:    .local f32
; WASM64-NEXT:  # %bb.0:
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call __extendhfsf2
; WASM64-NEXT:    local.tee 2
; WASM64-NEXT:    call cosf
; WASM64-NEXT:    call __truncsfhf2
; WASM64-NEXT:    i32.store16 2
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call sinf
; WASM64-NEXT:    call __truncsfhf2
; WASM64-NEXT:    i32.store16 0
; WASM64-NEXT:    # fallthrough-return
  %result = call { half, half } @llvm.sincos.f16(half %a)
  ret { half, half } %result
}

define half @test_sincos_f16_only_use_sin(half %a) #0 {
; CHECK-LABEL: test_sincos_f16_only_use_sin:
; CHECK:         .functype test_sincos_f16_only_use_sin (i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call sinf
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    # fallthrough-return
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.0 = extractvalue { half, half } %result, 0
  ret half %result.0
}

define half @test_sincos_f16_only_use_cos(half %a) #0 {
; CHECK-LABEL: test_sincos_f16_only_use_cos:
; CHECK:         .functype test_sincos_f16_only_use_cos (i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call cosf
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    # fallthrough-return
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.1 = extractvalue { half, half } %result, 1
  ret half %result.1
}

define { <2 x half>, <2 x half> } @test_sincos_v2f16(<2 x half> %a) #0 {
; WASM32-LABEL: test_sincos_v2f16:
; WASM32:         .functype test_sincos_v2f16 (i32, i32, i32) -> ()
; WASM32-NEXT:    .local f32, f32
; WASM32-NEXT:  # %bb.0:
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call __extendhfsf2
; WASM32-NEXT:    local.tee 3
; WASM32-NEXT:    call cosf
; WASM32-NEXT:    call __truncsfhf2
; WASM32-NEXT:    i32.store16 6
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call __extendhfsf2
; WASM32-NEXT:    local.tee 4
; WASM32-NEXT:    call cosf
; WASM32-NEXT:    call __truncsfhf2
; WASM32-NEXT:    i32.store16 4
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    call sinf
; WASM32-NEXT:    call __truncsfhf2
; WASM32-NEXT:    i32.store16 2
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 4
; WASM32-NEXT:    call sinf
; WASM32-NEXT:    call __truncsfhf2
; WASM32-NEXT:    i32.store16 0
; WASM32-NEXT:    # fallthrough-return
;
; WASM64-LABEL: test_sincos_v2f16:
; WASM64:         .functype test_sincos_v2f16 (i64, i32, i32) -> ()
; WASM64-NEXT:    .local f32, f32
; WASM64-NEXT:  # %bb.0:
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call __extendhfsf2
; WASM64-NEXT:    local.tee 3
; WASM64-NEXT:    call cosf
; WASM64-NEXT:    call __truncsfhf2
; WASM64-NEXT:    i32.store16 6
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call __extendhfsf2
; WASM64-NEXT:    local.tee 4
; WASM64-NEXT:    call cosf
; WASM64-NEXT:    call __truncsfhf2
; WASM64-NEXT:    i32.store16 4
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    call sinf
; WASM64-NEXT:    call __truncsfhf2
; WASM64-NEXT:    i32.store16 2
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 4
; WASM64-NEXT:    call sinf
; WASM64-NEXT:    call __truncsfhf2
; WASM64-NEXT:    i32.store16 0
; WASM64-NEXT:    # fallthrough-return
  %result = call { <2 x half>, <2 x half> } @llvm.sincos.v2f16(<2 x half> %a)
  ret { <2 x half>, <2 x half> } %result
}

define { float, float } @test_sincos_f32(float %a) #0 {
; WASM32-LABEL: test_sincos_f32:
; WASM32:         .functype test_sincos_f32 (i32, f32) -> ()
; WASM32-NEXT:  # %bb.0:
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call cosf
; WASM32-NEXT:    f32.store 4
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call sinf
; WASM32-NEXT:    f32.store 0
; WASM32-NEXT:    # fallthrough-return
;
; WASM64-LABEL: test_sincos_f32:
; WASM64:         .functype test_sincos_f32 (i64, f32) -> ()
; WASM64-NEXT:  # %bb.0:
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call cosf
; WASM64-NEXT:    f32.store 4
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call sinf
; WASM64-NEXT:    f32.store 0
; WASM64-NEXT:    # fallthrough-return
  %result = call { float, float } @llvm.sincos.f32(float %a)
  ret { float, float } %result
}

define { <2 x float>, <2 x float> } @test_sincos_v2f32(<2 x float> %a) #0 {
; WASM32-LABEL: test_sincos_v2f32:
; WASM32:         .functype test_sincos_v2f32 (i32, f32, f32) -> ()
; WASM32-NEXT:  # %bb.0:
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call cosf
; WASM32-NEXT:    f32.store 12
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call cosf
; WASM32-NEXT:    f32.store 8
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call sinf
; WASM32-NEXT:    f32.store 4
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call sinf
; WASM32-NEXT:    f32.store 0
; WASM32-NEXT:    # fallthrough-return
;
; WASM64-LABEL: test_sincos_v2f32:
; WASM64:         .functype test_sincos_v2f32 (i64, f32, f32) -> ()
; WASM64-NEXT:  # %bb.0:
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call cosf
; WASM64-NEXT:    f32.store 12
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call cosf
; WASM64-NEXT:    f32.store 8
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call sinf
; WASM64-NEXT:    f32.store 4
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call sinf
; WASM64-NEXT:    f32.store 0
; WASM64-NEXT:    # fallthrough-return
  %result = call { <2 x float>, <2 x float> } @llvm.sincos.v2f32(<2 x float> %a)
  ret { <2 x float>, <2 x float> } %result
}

define { <3 x float>, <3 x float> } @test_sincos_v3f32(<3 x float> %a) #0 {
; WASM32-LABEL: test_sincos_v3f32:
; WASM32:         .functype test_sincos_v3f32 (i32, f32, f32, f32) -> ()
; WASM32-NEXT:  # %bb.0:
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    call cosf
; WASM32-NEXT:    f32.store 24
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    call sinf
; WASM32-NEXT:    f32.store 8
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call cosf
; WASM32-NEXT:    local.set 3
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call cosf
; WASM32-NEXT:    i32.reinterpret_f32
; WASM32-NEXT:    i64.extend_i32_u
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    i32.reinterpret_f32
; WASM32-NEXT:    i64.extend_i32_u
; WASM32-NEXT:    i64.const 32
; WASM32-NEXT:    i64.shl
; WASM32-NEXT:    i64.or
; WASM32-NEXT:    i64.store 16
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call sinf
; WASM32-NEXT:    local.set 3
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call sinf
; WASM32-NEXT:    i32.reinterpret_f32
; WASM32-NEXT:    i64.extend_i32_u
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    i32.reinterpret_f32
; WASM32-NEXT:    i64.extend_i32_u
; WASM32-NEXT:    i64.const 32
; WASM32-NEXT:    i64.shl
; WASM32-NEXT:    i64.or
; WASM32-NEXT:    i64.store 0
; WASM32-NEXT:    # fallthrough-return
;
; WASM64-LABEL: test_sincos_v3f32:
; WASM64:         .functype test_sincos_v3f32 (i64, f32, f32, f32) -> ()
; WASM64-NEXT:  # %bb.0:
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    call cosf
; WASM64-NEXT:    f32.store 24
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    call sinf
; WASM64-NEXT:    f32.store 8
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call cosf
; WASM64-NEXT:    local.set 3
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call cosf
; WASM64-NEXT:    i32.reinterpret_f32
; WASM64-NEXT:    i64.extend_i32_u
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    i32.reinterpret_f32
; WASM64-NEXT:    i64.extend_i32_u
; WASM64-NEXT:    i64.const 32
; WASM64-NEXT:    i64.shl
; WASM64-NEXT:    i64.or
; WASM64-NEXT:    i64.store 16
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call sinf
; WASM64-NEXT:    local.set 3
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call sinf
; WASM64-NEXT:    i32.reinterpret_f32
; WASM64-NEXT:    i64.extend_i32_u
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    i32.reinterpret_f32
; WASM64-NEXT:    i64.extend_i32_u
; WASM64-NEXT:    i64.const 32
; WASM64-NEXT:    i64.shl
; WASM64-NEXT:    i64.or
; WASM64-NEXT:    i64.store 0
; WASM64-NEXT:    # fallthrough-return
  %result = call { <3 x float>, <3 x float> } @llvm.sincos.v3f32(<3 x float> %a)
  ret { <3 x float>, <3 x float> } %result
}

define { double, double } @test_sincos_f64(double %a) #0 {
; WASM32-LABEL: test_sincos_f64:
; WASM32:         .functype test_sincos_f64 (i32, f64) -> ()
; WASM32-NEXT:  # %bb.0:
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call cos
; WASM32-NEXT:    f64.store 8
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call sin
; WASM32-NEXT:    f64.store 0
; WASM32-NEXT:    # fallthrough-return
;
; WASM64-LABEL: test_sincos_f64:
; WASM64:         .functype test_sincos_f64 (i64, f64) -> ()
; WASM64-NEXT:  # %bb.0:
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call cos
; WASM64-NEXT:    f64.store 8
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call sin
; WASM64-NEXT:    f64.store 0
; WASM64-NEXT:    # fallthrough-return
  %result = call { double, double } @llvm.sincos.f64(double %a)
  ret { double, double } %result
}

define { <2 x double>, <2 x double> } @test_sincos_v2f64(<2 x double> %a) #0 {
; WASM32-LABEL: test_sincos_v2f64:
; WASM32:         .functype test_sincos_v2f64 (i32, f64, f64) -> ()
; WASM32-NEXT:  # %bb.0:
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call cos
; WASM32-NEXT:    f64.store 24
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call cos
; WASM32-NEXT:    f64.store 16
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call sin
; WASM32-NEXT:    f64.store 8
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    call sin
; WASM32-NEXT:    f64.store 0
; WASM32-NEXT:    # fallthrough-return
;
; WASM64-LABEL: test_sincos_v2f64:
; WASM64:         .functype test_sincos_v2f64 (i64, f64, f64) -> ()
; WASM64-NEXT:  # %bb.0:
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call cos
; WASM64-NEXT:    f64.store 24
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call cos
; WASM64-NEXT:    f64.store 16
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call sin
; WASM64-NEXT:    f64.store 8
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    call sin
; WASM64-NEXT:    f64.store 0
; WASM64-NEXT:    # fallthrough-return
  %result = call { <2 x double>, <2 x double> } @llvm.sincos.v2f64(<2 x double> %a)
  ret { <2 x double>, <2 x double> } %result
}

define { fp128, fp128 } @test_sincos_f128(fp128 %a) #0 {
; WASM32-LABEL: test_sincos_f128:
; WASM32:         .functype test_sincos_f128 (i32, i64, i64) -> ()
; WASM32-NEXT:    .local i32
; WASM32-NEXT:  # %bb.0:
; WASM32-NEXT:    global.get __stack_pointer
; WASM32-NEXT:    i32.const 32
; WASM32-NEXT:    i32.sub
; WASM32-NEXT:    local.tee 3
; WASM32-NEXT:    global.set __stack_pointer
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call cosl
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    i32.const 16
; WASM32-NEXT:    i32.add
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call sinl
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    i64.load 8
; WASM32-NEXT:    i64.store 24
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    i64.load 0
; WASM32-NEXT:    i64.store 16
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    i64.load 24
; WASM32-NEXT:    i64.store 8
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    i64.load 16
; WASM32-NEXT:    i64.store 0
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    i32.const 32
; WASM32-NEXT:    i32.add
; WASM32-NEXT:    global.set __stack_pointer
; WASM32-NEXT:    # fallthrough-return
;
; WASM64-LABEL: test_sincos_f128:
; WASM64:         .functype test_sincos_f128 (i64, i64, i64) -> ()
; WASM64-NEXT:    .local i64
; WASM64-NEXT:  # %bb.0:
; WASM64-NEXT:    global.get __stack_pointer
; WASM64-NEXT:    i64.const 32
; WASM64-NEXT:    i64.sub
; WASM64-NEXT:    local.tee 3
; WASM64-NEXT:    global.set __stack_pointer
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call cosl
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    i64.const 16
; WASM64-NEXT:    i64.add
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call sinl
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    i64.load 8
; WASM64-NEXT:    i64.store 24
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    i64.load 0
; WASM64-NEXT:    i64.store 16
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    i64.load 24
; WASM64-NEXT:    i64.store 8
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    i64.load 16
; WASM64-NEXT:    i64.store 0
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    i64.const 32
; WASM64-NEXT:    i64.add
; WASM64-NEXT:    global.set __stack_pointer
; WASM64-NEXT:    # fallthrough-return
  %result = call { fp128, fp128 } @llvm.sincos.f128(fp128 %a)
  ret { fp128, fp128 } %result
}

define { <2 x fp128>, <2 x fp128> } @test_sincos_v2f128(<2 x fp128> %a) #0 {
; WASM32-LABEL: test_sincos_v2f128:
; WASM32:         .functype test_sincos_v2f128 (i32, i64, i64, i64, i64) -> ()
; WASM32-NEXT:    .local i32
; WASM32-NEXT:  # %bb.0:
; WASM32-NEXT:    global.get __stack_pointer
; WASM32-NEXT:    i32.const 64
; WASM32-NEXT:    i32.sub
; WASM32-NEXT:    local.tee 5
; WASM32-NEXT:    global.set __stack_pointer
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i32.const 32
; WASM32-NEXT:    i32.add
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    local.get 4
; WASM32-NEXT:    call cosl
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call cosl
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i32.const 48
; WASM32-NEXT:    i32.add
; WASM32-NEXT:    local.get 3
; WASM32-NEXT:    local.get 4
; WASM32-NEXT:    call sinl
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i32.const 16
; WASM32-NEXT:    i32.add
; WASM32-NEXT:    local.get 1
; WASM32-NEXT:    local.get 2
; WASM32-NEXT:    call sinl
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i64.load 40
; WASM32-NEXT:    i64.store 56
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i64.load 32
; WASM32-NEXT:    i64.store 48
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i64.load 8
; WASM32-NEXT:    i64.store 40
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i64.load 0
; WASM32-NEXT:    i64.store 32
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i64.load 56
; WASM32-NEXT:    i64.store 24
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i64.load 48
; WASM32-NEXT:    i64.store 16
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i64.load 24
; WASM32-NEXT:    i64.store 8
; WASM32-NEXT:    local.get 0
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i64.load 16
; WASM32-NEXT:    i64.store 0
; WASM32-NEXT:    local.get 5
; WASM32-NEXT:    i32.const 64
; WASM32-NEXT:    i32.add
; WASM32-NEXT:    global.set __stack_pointer
; WASM32-NEXT:    # fallthrough-return
;
; WASM64-LABEL: test_sincos_v2f128:
; WASM64:         .functype test_sincos_v2f128 (i64, i64, i64, i64, i64) -> ()
; WASM64-NEXT:    .local i64
; WASM64-NEXT:  # %bb.0:
; WASM64-NEXT:    global.get __stack_pointer
; WASM64-NEXT:    i64.const 64
; WASM64-NEXT:    i64.sub
; WASM64-NEXT:    local.tee 5
; WASM64-NEXT:    global.set __stack_pointer
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.const 32
; WASM64-NEXT:    i64.add
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    local.get 4
; WASM64-NEXT:    call cosl
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call cosl
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.const 48
; WASM64-NEXT:    i64.add
; WASM64-NEXT:    local.get 3
; WASM64-NEXT:    local.get 4
; WASM64-NEXT:    call sinl
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.const 16
; WASM64-NEXT:    i64.add
; WASM64-NEXT:    local.get 1
; WASM64-NEXT:    local.get 2
; WASM64-NEXT:    call sinl
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.load 40
; WASM64-NEXT:    i64.store 56
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.load 32
; WASM64-NEXT:    i64.store 48
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.load 8
; WASM64-NEXT:    i64.store 40
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.load 0
; WASM64-NEXT:    i64.store 32
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.load 56
; WASM64-NEXT:    i64.store 24
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.load 48
; WASM64-NEXT:    i64.store 16
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.load 24
; WASM64-NEXT:    i64.store 8
; WASM64-NEXT:    local.get 0
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.load 16
; WASM64-NEXT:    i64.store 0
; WASM64-NEXT:    local.get 5
; WASM64-NEXT:    i64.const 64
; WASM64-NEXT:    i64.add
; WASM64-NEXT:    global.set __stack_pointer
; WASM64-NEXT:    # fallthrough-return
  %result = call { <2 x fp128>, <2 x fp128> } @llvm.sincos.v2f128(<2 x fp128> %a)
  ret { <2 x fp128>, <2 x fp128> } %result
}

attributes #0 = { nounwind }
