; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr5 \
; RUN:   -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=PWR5
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr6 \
; RUN:   -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=PWR6
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr7 \
; RUN:   -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=PWR7
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr8 \
; RUN:   -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=PWR8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr9 \
; RUN:   -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=PWR9

define <16 x i8> @ugt_1_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ugt_1_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    vspltisb v3, -1
; PWR5-NEXT:    vaddubm v3, v2, v3
; PWR5-NEXT:    vand v2, v2, v3
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    vcmpgtub v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_1_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    vspltisb v3, -1
; PWR6-NEXT:    vaddubm v3, v2, v3
; PWR6-NEXT:    vand v2, v2, v3
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    vcmpgtub v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_1_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, -1
; PWR7-NEXT:    vaddubm v3, v2, v3
; PWR7-NEXT:    xxland v2, v2, v3
; PWR7-NEXT:    xxlxor v3, v3, v3
; PWR7-NEXT:    vcmpgtub v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_1_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 1
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_1_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 1
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ugt <16 x i8> %2, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <16 x i8> @ult_2_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ult_2_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    vspltisb v3, -1
; PWR5-NEXT:    vaddubm v3, v2, v3
; PWR5-NEXT:    vand v2, v2, v3
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    vcmpequb v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_2_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    vspltisb v3, -1
; PWR6-NEXT:    vaddubm v3, v2, v3
; PWR6-NEXT:    vand v2, v2, v3
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    vcmpequb v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_2_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, -1
; PWR7-NEXT:    vaddubm v3, v2, v3
; PWR7-NEXT:    xxland v2, v2, v3
; PWR7-NEXT:    xxlxor v3, v3, v3
; PWR7-NEXT:    vcmpequb v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_2_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 2
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_2_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 2
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ult <16 x i8> %2, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <16 x i8> @ugt_2_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ugt_2_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI2_0@toc@ha
; PWR5-NEXT:    vspltisb v3, 1
; PWR5-NEXT:    addi r3, r3, .LCPI2_0@toc@l
; PWR5-NEXT:    vsrb v3, v2, v3
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI2_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI2_1@toc@l
; PWR5-NEXT:    vspltisb v5, 2
; PWR5-NEXT:    vand v3, v3, v4
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    vsububm v2, v2, v3
; PWR5-NEXT:    vand v3, v2, v4
; PWR5-NEXT:    vsrb v2, v2, v5
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 4
; PWR5-NEXT:    vaddubm v2, v3, v2
; PWR5-NEXT:    vsrb v3, v2, v4
; PWR5-NEXT:    vspltisb v4, 15
; PWR5-NEXT:    vaddubm v2, v2, v3
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vcmpgtub v2, v2, v5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_2_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI2_0@toc@ha
; PWR6-NEXT:    vspltisb v3, 1
; PWR6-NEXT:    addi r3, r3, .LCPI2_0@toc@l
; PWR6-NEXT:    vsrb v3, v2, v3
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI2_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI2_1@toc@l
; PWR6-NEXT:    vspltisb v5, 2
; PWR6-NEXT:    vand v3, v3, v4
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    vsububm v2, v2, v3
; PWR6-NEXT:    vand v3, v2, v4
; PWR6-NEXT:    vsrb v2, v2, v5
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 4
; PWR6-NEXT:    vaddubm v2, v3, v2
; PWR6-NEXT:    vsrb v3, v2, v4
; PWR6-NEXT:    vspltisb v4, 15
; PWR6-NEXT:    vaddubm v2, v2, v3
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vcmpgtub v2, v2, v5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_2_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI2_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI2_0@toc@l
; PWR7-NEXT:    vspltisb v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI2_1@toc@ha
; PWR7-NEXT:    vspltisb v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI2_1@toc@l
; PWR7-NEXT:    vsrb v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsububm v2, v2, v3
; PWR7-NEXT:    xxland v3, v2, vs0
; PWR7-NEXT:    vsrb v2, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    vaddubm v2, v3, v2
; PWR7-NEXT:    vsrb v3, v2, v5
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vcmpgtub v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_2_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 2
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_2_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 2
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ugt <16 x i8> %2, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <16 x i8> @ult_3_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ult_3_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI3_0@toc@ha
; PWR5-NEXT:    vspltisb v3, 1
; PWR5-NEXT:    addi r3, r3, .LCPI3_0@toc@l
; PWR5-NEXT:    vsrb v3, v2, v3
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI3_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI3_1@toc@l
; PWR5-NEXT:    vspltisb v5, 2
; PWR5-NEXT:    vand v3, v3, v4
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    vsububm v2, v2, v3
; PWR5-NEXT:    vand v3, v2, v4
; PWR5-NEXT:    vsrb v2, v2, v5
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 4
; PWR5-NEXT:    vaddubm v2, v3, v2
; PWR5-NEXT:    vsrb v3, v2, v4
; PWR5-NEXT:    vspltisb v4, 15
; PWR5-NEXT:    vaddubm v2, v2, v3
; PWR5-NEXT:    vspltisb v3, 3
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vcmpgtub v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_3_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI3_0@toc@ha
; PWR6-NEXT:    vspltisb v3, 1
; PWR6-NEXT:    addi r3, r3, .LCPI3_0@toc@l
; PWR6-NEXT:    vsrb v3, v2, v3
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI3_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI3_1@toc@l
; PWR6-NEXT:    vspltisb v5, 2
; PWR6-NEXT:    vand v3, v3, v4
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    vsububm v2, v2, v3
; PWR6-NEXT:    vand v3, v2, v4
; PWR6-NEXT:    vsrb v2, v2, v5
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 4
; PWR6-NEXT:    vaddubm v2, v3, v2
; PWR6-NEXT:    vsrb v3, v2, v4
; PWR6-NEXT:    vspltisb v4, 15
; PWR6-NEXT:    vaddubm v2, v2, v3
; PWR6-NEXT:    vspltisb v3, 3
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vcmpgtub v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_3_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI3_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI3_0@toc@l
; PWR7-NEXT:    vspltisb v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI3_1@toc@ha
; PWR7-NEXT:    vspltisb v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI3_1@toc@l
; PWR7-NEXT:    vsrb v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 3
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsububm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v5
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vcmpgtub v2, v1, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_3_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 3
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_3_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 3
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ult <16 x i8> %2, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <16 x i8> @ugt_3_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ugt_3_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI4_0@toc@ha
; PWR5-NEXT:    vspltisb v3, 1
; PWR5-NEXT:    addi r3, r3, .LCPI4_0@toc@l
; PWR5-NEXT:    vsrb v3, v2, v3
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI4_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI4_1@toc@l
; PWR5-NEXT:    vspltisb v5, 2
; PWR5-NEXT:    vand v3, v3, v4
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    vsububm v2, v2, v3
; PWR5-NEXT:    vand v3, v2, v4
; PWR5-NEXT:    vsrb v2, v2, v5
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 4
; PWR5-NEXT:    vaddubm v2, v3, v2
; PWR5-NEXT:    vsrb v3, v2, v4
; PWR5-NEXT:    vspltisb v4, 15
; PWR5-NEXT:    vaddubm v2, v2, v3
; PWR5-NEXT:    vspltisb v3, 3
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vcmpgtub v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_3_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI4_0@toc@ha
; PWR6-NEXT:    vspltisb v3, 1
; PWR6-NEXT:    addi r3, r3, .LCPI4_0@toc@l
; PWR6-NEXT:    vsrb v3, v2, v3
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI4_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI4_1@toc@l
; PWR6-NEXT:    vspltisb v5, 2
; PWR6-NEXT:    vand v3, v3, v4
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    vsububm v2, v2, v3
; PWR6-NEXT:    vand v3, v2, v4
; PWR6-NEXT:    vsrb v2, v2, v5
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 4
; PWR6-NEXT:    vaddubm v2, v3, v2
; PWR6-NEXT:    vsrb v3, v2, v4
; PWR6-NEXT:    vspltisb v4, 15
; PWR6-NEXT:    vaddubm v2, v2, v3
; PWR6-NEXT:    vspltisb v3, 3
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vcmpgtub v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_3_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI4_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI4_0@toc@l
; PWR7-NEXT:    vspltisb v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI4_1@toc@ha
; PWR7-NEXT:    vspltisb v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI4_1@toc@l
; PWR7-NEXT:    vsrb v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 3
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsububm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v5
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vcmpgtub v2, v2, v1
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_3_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 3
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_3_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 3
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ugt <16 x i8> %2, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <16 x i8> @ult_4_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ult_4_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; PWR5-NEXT:    vspltisb v3, 1
; PWR5-NEXT:    addi r3, r3, .LCPI5_0@toc@l
; PWR5-NEXT:    vsrb v3, v2, v3
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI5_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI5_1@toc@l
; PWR5-NEXT:    vspltisb v5, 2
; PWR5-NEXT:    vand v3, v3, v4
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    vsububm v2, v2, v3
; PWR5-NEXT:    vand v3, v2, v4
; PWR5-NEXT:    vsrb v2, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 4
; PWR5-NEXT:    vaddubm v2, v3, v2
; PWR5-NEXT:    vsrb v3, v2, v4
; PWR5-NEXT:    vaddubm v2, v2, v3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vcmpgtub v2, v4, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_4_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; PWR6-NEXT:    vspltisb v3, 1
; PWR6-NEXT:    addi r3, r3, .LCPI5_0@toc@l
; PWR6-NEXT:    vsrb v3, v2, v3
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI5_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI5_1@toc@l
; PWR6-NEXT:    vspltisb v5, 2
; PWR6-NEXT:    vand v3, v3, v4
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    vsububm v2, v2, v3
; PWR6-NEXT:    vand v3, v2, v4
; PWR6-NEXT:    vsrb v2, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 4
; PWR6-NEXT:    vaddubm v2, v3, v2
; PWR6-NEXT:    vsrb v3, v2, v4
; PWR6-NEXT:    vaddubm v2, v2, v3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vcmpgtub v2, v4, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_4_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI5_0@toc@l
; PWR7-NEXT:    vspltisb v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI5_1@toc@ha
; PWR7-NEXT:    vspltisb v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI5_1@toc@l
; PWR7-NEXT:    vsrb v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsububm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v5
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vcmpgtub v2, v5, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_4_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 4
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_4_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 4
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ult <16 x i8> %2, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <16 x i8> @ugt_4_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ugt_4_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI6_0@toc@ha
; PWR5-NEXT:    vspltisb v3, 1
; PWR5-NEXT:    addi r3, r3, .LCPI6_0@toc@l
; PWR5-NEXT:    vsrb v3, v2, v3
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI6_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI6_1@toc@l
; PWR5-NEXT:    vspltisb v5, 2
; PWR5-NEXT:    vand v3, v3, v4
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    vsububm v2, v2, v3
; PWR5-NEXT:    vand v3, v2, v4
; PWR5-NEXT:    vsrb v2, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 4
; PWR5-NEXT:    vaddubm v2, v3, v2
; PWR5-NEXT:    vsrb v3, v2, v4
; PWR5-NEXT:    vaddubm v2, v2, v3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vcmpgtub v2, v2, v4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_4_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI6_0@toc@ha
; PWR6-NEXT:    vspltisb v3, 1
; PWR6-NEXT:    addi r3, r3, .LCPI6_0@toc@l
; PWR6-NEXT:    vsrb v3, v2, v3
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI6_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI6_1@toc@l
; PWR6-NEXT:    vspltisb v5, 2
; PWR6-NEXT:    vand v3, v3, v4
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    vsububm v2, v2, v3
; PWR6-NEXT:    vand v3, v2, v4
; PWR6-NEXT:    vsrb v2, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 4
; PWR6-NEXT:    vaddubm v2, v3, v2
; PWR6-NEXT:    vsrb v3, v2, v4
; PWR6-NEXT:    vaddubm v2, v2, v3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vcmpgtub v2, v2, v4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_4_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI6_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI6_0@toc@l
; PWR7-NEXT:    vspltisb v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI6_1@toc@ha
; PWR7-NEXT:    vspltisb v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI6_1@toc@l
; PWR7-NEXT:    vsrb v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsububm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v5
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vcmpgtub v2, v2, v5
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_4_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 4
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_4_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 4
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ugt <16 x i8> %2, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <16 x i8> @ult_5_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ult_5_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; PWR5-NEXT:    vspltisb v3, 1
; PWR5-NEXT:    addi r3, r3, .LCPI7_0@toc@l
; PWR5-NEXT:    vsrb v3, v2, v3
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI7_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI7_1@toc@l
; PWR5-NEXT:    vspltisb v5, 2
; PWR5-NEXT:    vand v3, v3, v4
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    vsububm v2, v2, v3
; PWR5-NEXT:    vand v3, v2, v4
; PWR5-NEXT:    vsrb v2, v2, v5
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 4
; PWR5-NEXT:    vaddubm v2, v3, v2
; PWR5-NEXT:    vsrb v3, v2, v4
; PWR5-NEXT:    vspltisb v4, 15
; PWR5-NEXT:    vaddubm v2, v2, v3
; PWR5-NEXT:    vspltisb v3, 5
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vcmpgtub v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_5_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; PWR6-NEXT:    vspltisb v3, 1
; PWR6-NEXT:    addi r3, r3, .LCPI7_0@toc@l
; PWR6-NEXT:    vsrb v3, v2, v3
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI7_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI7_1@toc@l
; PWR6-NEXT:    vspltisb v5, 2
; PWR6-NEXT:    vand v3, v3, v4
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    vsububm v2, v2, v3
; PWR6-NEXT:    vand v3, v2, v4
; PWR6-NEXT:    vsrb v2, v2, v5
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 4
; PWR6-NEXT:    vaddubm v2, v3, v2
; PWR6-NEXT:    vsrb v3, v2, v4
; PWR6-NEXT:    vspltisb v4, 15
; PWR6-NEXT:    vaddubm v2, v2, v3
; PWR6-NEXT:    vspltisb v3, 5
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vcmpgtub v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_5_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI7_0@toc@l
; PWR7-NEXT:    vspltisb v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI7_1@toc@ha
; PWR7-NEXT:    vspltisb v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI7_1@toc@l
; PWR7-NEXT:    vsrb v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 5
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsububm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v5
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vcmpgtub v2, v1, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_5_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 5
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_5_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 5
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ult <16 x i8> %2, <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <16 x i8> @ugt_5_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ugt_5_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI8_0@toc@ha
; PWR5-NEXT:    vspltisb v3, 1
; PWR5-NEXT:    addi r3, r3, .LCPI8_0@toc@l
; PWR5-NEXT:    vsrb v3, v2, v3
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI8_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI8_1@toc@l
; PWR5-NEXT:    vspltisb v5, 2
; PWR5-NEXT:    vand v3, v3, v4
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    vsububm v2, v2, v3
; PWR5-NEXT:    vand v3, v2, v4
; PWR5-NEXT:    vsrb v2, v2, v5
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 4
; PWR5-NEXT:    vaddubm v2, v3, v2
; PWR5-NEXT:    vsrb v3, v2, v4
; PWR5-NEXT:    vspltisb v4, 15
; PWR5-NEXT:    vaddubm v2, v2, v3
; PWR5-NEXT:    vspltisb v3, 5
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vcmpgtub v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_5_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI8_0@toc@ha
; PWR6-NEXT:    vspltisb v3, 1
; PWR6-NEXT:    addi r3, r3, .LCPI8_0@toc@l
; PWR6-NEXT:    vsrb v3, v2, v3
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI8_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI8_1@toc@l
; PWR6-NEXT:    vspltisb v5, 2
; PWR6-NEXT:    vand v3, v3, v4
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    vsububm v2, v2, v3
; PWR6-NEXT:    vand v3, v2, v4
; PWR6-NEXT:    vsrb v2, v2, v5
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 4
; PWR6-NEXT:    vaddubm v2, v3, v2
; PWR6-NEXT:    vsrb v3, v2, v4
; PWR6-NEXT:    vspltisb v4, 15
; PWR6-NEXT:    vaddubm v2, v2, v3
; PWR6-NEXT:    vspltisb v3, 5
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vcmpgtub v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_5_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI8_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI8_0@toc@l
; PWR7-NEXT:    vspltisb v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI8_1@toc@ha
; PWR7-NEXT:    vspltisb v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI8_1@toc@l
; PWR7-NEXT:    vsrb v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 5
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsububm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v5
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vcmpgtub v2, v2, v1
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_5_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 5
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_5_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 5
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ugt <16 x i8> %2, <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <16 x i8> @ult_6_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ult_6_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI9_0@toc@ha
; PWR5-NEXT:    vspltisb v3, 1
; PWR5-NEXT:    addi r3, r3, .LCPI9_0@toc@l
; PWR5-NEXT:    vsrb v3, v2, v3
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI9_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI9_1@toc@l
; PWR5-NEXT:    vspltisb v5, 2
; PWR5-NEXT:    vand v3, v3, v4
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    vsububm v2, v2, v3
; PWR5-NEXT:    vand v3, v2, v4
; PWR5-NEXT:    vsrb v2, v2, v5
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 4
; PWR5-NEXT:    vaddubm v2, v3, v2
; PWR5-NEXT:    vsrb v3, v2, v4
; PWR5-NEXT:    vspltisb v4, 15
; PWR5-NEXT:    vaddubm v2, v2, v3
; PWR5-NEXT:    vspltisb v3, 6
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vcmpgtub v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_6_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI9_0@toc@ha
; PWR6-NEXT:    vspltisb v3, 1
; PWR6-NEXT:    addi r3, r3, .LCPI9_0@toc@l
; PWR6-NEXT:    vsrb v3, v2, v3
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI9_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI9_1@toc@l
; PWR6-NEXT:    vspltisb v5, 2
; PWR6-NEXT:    vand v3, v3, v4
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    vsububm v2, v2, v3
; PWR6-NEXT:    vand v3, v2, v4
; PWR6-NEXT:    vsrb v2, v2, v5
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 4
; PWR6-NEXT:    vaddubm v2, v3, v2
; PWR6-NEXT:    vsrb v3, v2, v4
; PWR6-NEXT:    vspltisb v4, 15
; PWR6-NEXT:    vaddubm v2, v2, v3
; PWR6-NEXT:    vspltisb v3, 6
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vcmpgtub v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_6_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI9_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI9_0@toc@l
; PWR7-NEXT:    vspltisb v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI9_1@toc@ha
; PWR7-NEXT:    vspltisb v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI9_1@toc@l
; PWR7-NEXT:    vsrb v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 6
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsububm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v5
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vcmpgtub v2, v1, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_6_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 6
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_6_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 6
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ult <16 x i8> %2, <i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <16 x i8> @ugt_6_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ugt_6_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI10_0@toc@ha
; PWR5-NEXT:    vspltisb v3, 1
; PWR5-NEXT:    addi r3, r3, .LCPI10_0@toc@l
; PWR5-NEXT:    vsrb v3, v2, v3
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI10_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI10_1@toc@l
; PWR5-NEXT:    vspltisb v5, 2
; PWR5-NEXT:    vand v3, v3, v4
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    vsububm v2, v2, v3
; PWR5-NEXT:    vand v3, v2, v4
; PWR5-NEXT:    vsrb v2, v2, v5
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 4
; PWR5-NEXT:    vaddubm v2, v3, v2
; PWR5-NEXT:    vsrb v3, v2, v4
; PWR5-NEXT:    vspltisb v4, 15
; PWR5-NEXT:    vaddubm v2, v2, v3
; PWR5-NEXT:    vspltisb v3, 6
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vcmpgtub v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_6_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI10_0@toc@ha
; PWR6-NEXT:    vspltisb v3, 1
; PWR6-NEXT:    addi r3, r3, .LCPI10_0@toc@l
; PWR6-NEXT:    vsrb v3, v2, v3
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI10_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI10_1@toc@l
; PWR6-NEXT:    vspltisb v5, 2
; PWR6-NEXT:    vand v3, v3, v4
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    vsububm v2, v2, v3
; PWR6-NEXT:    vand v3, v2, v4
; PWR6-NEXT:    vsrb v2, v2, v5
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 4
; PWR6-NEXT:    vaddubm v2, v3, v2
; PWR6-NEXT:    vsrb v3, v2, v4
; PWR6-NEXT:    vspltisb v4, 15
; PWR6-NEXT:    vaddubm v2, v2, v3
; PWR6-NEXT:    vspltisb v3, 6
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vcmpgtub v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_6_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI10_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI10_0@toc@l
; PWR7-NEXT:    vspltisb v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI10_1@toc@ha
; PWR7-NEXT:    vspltisb v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI10_1@toc@l
; PWR7-NEXT:    vsrb v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 6
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsububm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v5
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vcmpgtub v2, v2, v1
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_6_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 6
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_6_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 6
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ugt <16 x i8> %2, <i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <16 x i8> @ult_7_v16i8(<16 x i8> %0) {
; PWR5-LABEL: ult_7_v16i8:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI11_0@toc@ha
; PWR5-NEXT:    vspltisb v3, 1
; PWR5-NEXT:    addi r3, r3, .LCPI11_0@toc@l
; PWR5-NEXT:    vsrb v3, v2, v3
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI11_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI11_1@toc@l
; PWR5-NEXT:    vspltisb v5, 2
; PWR5-NEXT:    vand v3, v3, v4
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    vsububm v2, v2, v3
; PWR5-NEXT:    vand v3, v2, v4
; PWR5-NEXT:    vsrb v2, v2, v5
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 4
; PWR5-NEXT:    vaddubm v2, v3, v2
; PWR5-NEXT:    vsrb v3, v2, v4
; PWR5-NEXT:    vspltisb v4, 15
; PWR5-NEXT:    vaddubm v2, v2, v3
; PWR5-NEXT:    vspltisb v3, 7
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vcmpgtub v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_7_v16i8:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI11_0@toc@ha
; PWR6-NEXT:    vspltisb v3, 1
; PWR6-NEXT:    addi r3, r3, .LCPI11_0@toc@l
; PWR6-NEXT:    vsrb v3, v2, v3
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI11_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI11_1@toc@l
; PWR6-NEXT:    vspltisb v5, 2
; PWR6-NEXT:    vand v3, v3, v4
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    vsububm v2, v2, v3
; PWR6-NEXT:    vand v3, v2, v4
; PWR6-NEXT:    vsrb v2, v2, v5
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 4
; PWR6-NEXT:    vaddubm v2, v3, v2
; PWR6-NEXT:    vsrb v3, v2, v4
; PWR6-NEXT:    vspltisb v4, 15
; PWR6-NEXT:    vaddubm v2, v2, v3
; PWR6-NEXT:    vspltisb v3, 7
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vcmpgtub v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_7_v16i8:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI11_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI11_0@toc@l
; PWR7-NEXT:    vspltisb v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI11_1@toc@ha
; PWR7-NEXT:    vspltisb v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI11_1@toc@l
; PWR7-NEXT:    vsrb v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 7
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsububm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    vsrb v3, v2, v5
; PWR7-NEXT:    vaddubm v2, v2, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vcmpgtub v2, v1, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_7_v16i8:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisb v3, 7
; PWR8-NEXT:    vpopcntb v2, v2
; PWR8-NEXT:    vcmpgtub v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_7_v16i8:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 7
; PWR9-NEXT:    vpopcntb v2, v2
; PWR9-NEXT:    vcmpgtub v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %0)
  %3 = icmp ult <16 x i8> %2, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %4 = sext <16 x i1> %3 to <16 x i8>
  ret <16 x i8> %4
}

define <8 x i16> @ugt_1_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_1_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    vspltisb v3, -1
; PWR5-NEXT:    vadduhm v3, v2, v3
; PWR5-NEXT:    vand v2, v2, v3
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_1_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    vspltisb v3, -1
; PWR6-NEXT:    vadduhm v3, v2, v3
; PWR6-NEXT:    vand v2, v2, v3
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_1_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, -1
; PWR7-NEXT:    vadduhm v3, v2, v3
; PWR7-NEXT:    xxland v2, v2, v3
; PWR7-NEXT:    xxlxor v3, v3, v3
; PWR7-NEXT:    vcmpgtuh v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_1_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 1
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_1_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 1
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_2_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_2_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    vspltisb v3, -1
; PWR5-NEXT:    vadduhm v3, v2, v3
; PWR5-NEXT:    vand v2, v2, v3
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    vcmpequh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_2_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    vspltisb v3, -1
; PWR6-NEXT:    vadduhm v3, v2, v3
; PWR6-NEXT:    vand v2, v2, v3
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    vcmpequh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_2_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, -1
; PWR7-NEXT:    vadduhm v3, v2, v3
; PWR7-NEXT:    xxland v2, v2, v3
; PWR7-NEXT:    xxlxor v3, v3, v3
; PWR7-NEXT:    vcmpequh v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_2_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 2
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_2_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 2
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_2_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_2_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI14_0@toc@ha
; PWR5-NEXT:    vspltish v3, 1
; PWR5-NEXT:    addi r3, r3, .LCPI14_0@toc@l
; PWR5-NEXT:    vsrh v3, v2, v3
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI14_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI14_1@toc@l
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vand v3, v3, v4
; PWR5-NEXT:    lvx v4, 0, r3
; PWR5-NEXT:    vsubuhm v2, v2, v3
; PWR5-NEXT:    vand v3, v2, v4
; PWR5-NEXT:    vsrh v2, v2, v5
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vadduhm v2, v3, v2
; PWR5-NEXT:    vspltish v3, 4
; PWR5-NEXT:    vsrh v3, v2, v3
; PWR5-NEXT:    vadduhm v2, v2, v3
; PWR5-NEXT:    vspltisb v3, 15
; PWR5-NEXT:    vxor v4, v4, v4
; PWR5-NEXT:    vand v2, v2, v3
; PWR5-NEXT:    vspltisb v3, 1
; PWR5-NEXT:    vmladduhm v2, v2, v3, v4
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vcmpgtuh v2, v2, v5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_2_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI14_0@toc@ha
; PWR6-NEXT:    vspltish v3, 1
; PWR6-NEXT:    addi r3, r3, .LCPI14_0@toc@l
; PWR6-NEXT:    vsrh v3, v2, v3
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI14_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI14_1@toc@l
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vand v3, v3, v4
; PWR6-NEXT:    lvx v4, 0, r3
; PWR6-NEXT:    vsubuhm v2, v2, v3
; PWR6-NEXT:    vand v3, v2, v4
; PWR6-NEXT:    vsrh v2, v2, v5
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vadduhm v2, v3, v2
; PWR6-NEXT:    vspltish v3, 4
; PWR6-NEXT:    vsrh v3, v2, v3
; PWR6-NEXT:    vadduhm v2, v2, v3
; PWR6-NEXT:    vspltisb v3, 15
; PWR6-NEXT:    vxor v4, v4, v4
; PWR6-NEXT:    vand v2, v2, v3
; PWR6-NEXT:    vspltisb v3, 1
; PWR6-NEXT:    vmladduhm v2, v2, v3, v4
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vcmpgtuh v2, v2, v5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_2_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI14_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI14_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI14_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI14_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    xxland v3, v2, vs0
; PWR7-NEXT:    vsrh v2, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    vadduhm v2, v3, v2
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_2_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 2
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_2_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 2
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_3_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_3_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI15_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI15_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI15_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI15_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 3
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_3_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI15_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI15_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI15_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI15_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 3
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_3_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI15_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI15_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI15_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI15_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 3
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_3_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 3
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_3_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 3
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_3_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_3_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI16_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI16_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI16_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI16_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 3
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_3_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI16_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI16_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI16_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI16_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 3
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_3_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI16_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI16_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI16_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI16_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 3
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v7
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_3_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 3
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_3_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 3
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_4_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_4_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI17_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI17_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI17_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI17_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 15
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vcmpgtuh v2, v5, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_4_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI17_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI17_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI17_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI17_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 15
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vcmpgtuh v2, v5, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_4_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI17_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI17_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI17_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI17_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v5, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_4_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 4
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_4_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 4
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_4_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_4_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI18_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI18_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI18_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI18_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 15
; PWR5-NEXT:    vand v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vcmpgtuh v2, v2, v5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_4_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI18_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI18_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI18_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI18_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 15
; PWR6-NEXT:    vand v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vcmpgtuh v2, v2, v5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_4_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI18_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI18_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI18_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI18_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v5
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_4_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 4
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_4_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 4
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_5_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_5_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI19_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI19_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI19_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI19_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 5
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_5_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI19_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI19_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI19_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI19_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 5
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_5_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI19_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI19_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI19_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI19_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 5
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_5_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 5
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_5_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 5
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_5_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_5_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI20_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI20_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI20_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI20_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 5
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_5_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI20_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI20_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI20_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI20_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 5
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_5_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI20_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI20_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI20_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI20_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 5
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v7
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_5_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 5
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_5_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 5
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_6_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_6_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI21_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI21_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI21_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI21_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 6
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_6_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI21_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI21_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI21_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI21_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 6
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_6_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI21_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI21_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI21_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI21_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 6
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_6_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 6
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_6_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 6
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_6_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_6_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI22_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI22_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI22_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI22_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 6
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_6_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI22_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI22_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI22_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI22_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 6
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_6_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI22_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI22_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI22_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI22_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 6
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v7
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_6_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 6
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_6_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 6
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_7_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_7_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI23_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI23_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI23_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI23_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 7
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_7_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI23_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI23_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI23_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI23_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 7
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_7_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI23_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI23_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI23_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI23_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 7
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_7_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 7
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_7_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 7
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_7_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_7_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI24_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI24_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI24_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI24_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 7
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_7_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI24_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI24_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI24_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI24_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 7
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_7_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI24_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI24_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI24_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI24_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 7
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v7
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_7_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 7
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_7_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 7
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_8_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_8_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI25_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI25_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI25_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI25_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_8_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI25_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI25_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI25_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI25_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_8_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI25_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI25_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI25_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI25_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v6, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_8_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 8
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_8_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 8
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_8_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_8_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI26_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI26_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI26_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI26_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_8_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI26_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI26_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI26_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI26_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_8_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI26_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI26_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI26_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI26_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v6
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_8_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 8
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_8_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 8
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_9_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_9_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI27_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI27_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI27_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI27_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 9
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_9_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI27_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI27_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI27_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI27_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 9
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_9_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI27_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI27_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI27_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI27_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 9
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_9_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 9
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_9_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 9
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_9_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_9_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI28_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI28_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI28_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI28_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 9
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_9_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI28_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI28_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI28_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI28_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 9
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_9_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI28_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI28_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI28_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI28_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 9
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v7
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_9_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 9
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_9_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 9
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_10_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_10_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI29_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI29_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI29_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI29_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 10
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_10_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI29_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI29_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI29_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI29_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 10
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_10_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI29_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI29_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI29_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI29_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 10
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_10_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 10
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_10_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 10
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_10_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_10_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI30_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI30_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI30_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI30_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 10
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_10_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI30_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI30_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI30_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI30_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 10
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_10_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI30_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI30_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI30_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI30_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 10
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v7
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_10_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 10
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_10_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 10
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_11_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_11_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI31_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI31_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI31_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI31_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 11
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_11_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI31_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI31_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI31_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI31_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 11
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_11_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI31_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI31_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI31_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI31_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 11
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_11_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 11
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_11_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 11
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_11_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_11_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI32_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI32_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI32_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI32_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 11
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_11_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI32_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI32_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI32_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI32_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 11
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_11_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI32_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI32_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI32_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI32_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 11
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v7
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_11_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 11
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_11_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 11
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_12_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_12_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI33_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI33_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI33_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI33_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 12
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_12_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI33_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI33_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI33_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI33_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 12
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_12_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI33_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI33_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI33_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI33_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_12_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 12
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_12_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 12
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_12_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_12_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI34_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI34_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI34_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI34_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 12
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_12_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI34_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI34_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI34_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI34_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 12
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_12_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI34_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI34_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI34_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI34_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v7
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_12_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 12
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_12_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 12
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_13_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_13_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI35_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI35_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI35_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI35_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 13
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_13_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI35_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI35_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI35_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI35_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 13
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_13_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI35_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI35_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI35_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI35_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 13
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_13_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 13
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_13_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 13
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_13_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_13_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI36_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI36_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI36_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI36_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 13
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_13_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI36_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI36_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI36_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI36_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 13
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_13_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI36_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI36_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI36_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI36_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 13
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v7
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_13_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 13
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_13_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 13
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_14_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_14_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI37_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI37_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI37_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI37_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 14
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_14_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI37_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI37_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI37_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI37_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 14
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_14_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI37_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI37_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI37_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI37_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 14
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_14_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 14
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_14_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 14
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ugt_14_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ugt_14_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI38_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI38_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI38_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI38_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 14
; PWR5-NEXT:    vcmpgtuh v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_14_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI38_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI38_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI38_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI38_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 14
; PWR6-NEXT:    vcmpgtuh v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_14_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI38_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI38_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI38_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI38_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 14
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v2, v7
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_14_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 14
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_14_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 14
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ugt <8 x i16> %2, <i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <8 x i16> @ult_15_v8i16(<8 x i16> %0) {
; PWR5-LABEL: ult_15_v8i16:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI39_0@toc@ha
; PWR5-NEXT:    vspltish v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI39_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI39_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI39_1@toc@l
; PWR5-NEXT:    vsrh v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 2
; PWR5-NEXT:    vsubuhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    vspltish v5, 4
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vsrh v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduhm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vmladduhm v2, v2, v4, v3
; PWR5-NEXT:    vspltish v3, 8
; PWR5-NEXT:    vsrh v2, v2, v3
; PWR5-NEXT:    vspltish v3, 15
; PWR5-NEXT:    vcmpgtuh v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_15_v8i16:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI39_0@toc@ha
; PWR6-NEXT:    vspltish v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI39_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI39_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI39_1@toc@l
; PWR6-NEXT:    vsrh v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 2
; PWR6-NEXT:    vsubuhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    vspltish v5, 4
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vsrh v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduhm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vmladduhm v2, v2, v4, v3
; PWR6-NEXT:    vspltish v3, 8
; PWR6-NEXT:    vsrh v2, v2, v3
; PWR6-NEXT:    vspltish v3, 15
; PWR6-NEXT:    vcmpgtuh v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_15_v8i16:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltish v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI39_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI39_0@toc@l
; PWR7-NEXT:    vspltish v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI39_1@toc@ha
; PWR7-NEXT:    vspltish v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI39_1@toc@l
; PWR7-NEXT:    vsrh v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltish v6, 8
; PWR7-NEXT:    vspltish v7, 15
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vsrh v3, v2, v5
; PWR7-NEXT:    vadduhm v2, v2, v3
; PWR7-NEXT:    vxor v3, v3, v3
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmladduhm v2, v2, v1, v3
; PWR7-NEXT:    vsrh v2, v2, v6
; PWR7-NEXT:    vcmpgtuh v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_15_v8i16:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltish v3, 15
; PWR8-NEXT:    vpopcnth v2, v2
; PWR8-NEXT:    vcmpgtuh v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_15_v8i16:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltish v3, 15
; PWR9-NEXT:    vpopcnth v2, v2
; PWR9-NEXT:    vcmpgtuh v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %0)
  %3 = icmp ult <8 x i16> %2, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %4 = sext <8 x i1> %3 to <8 x i16>
  ret <8 x i16> %4
}

define <4 x i32> @ugt_1_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_1_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    vspltisb v3, -1
; PWR5-NEXT:    vadduwm v3, v2, v3
; PWR5-NEXT:    vand v2, v2, v3
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_1_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    vspltisb v3, -1
; PWR6-NEXT:    vadduwm v3, v2, v3
; PWR6-NEXT:    vand v2, v2, v3
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_1_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, -1
; PWR7-NEXT:    vadduwm v3, v2, v3
; PWR7-NEXT:    xxland v2, v2, v3
; PWR7-NEXT:    xxlxor v3, v3, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_1_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 1
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_1_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 1
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 1, i32 1, i32 1, i32 1>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_2_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_2_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    vspltisb v3, -1
; PWR5-NEXT:    vadduwm v3, v2, v3
; PWR5-NEXT:    vand v2, v2, v3
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    vcmpequw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_2_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    vspltisb v3, -1
; PWR6-NEXT:    vadduwm v3, v2, v3
; PWR6-NEXT:    vand v2, v2, v3
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    vcmpequw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_2_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisb v3, -1
; PWR7-NEXT:    vadduwm v3, v2, v3
; PWR7-NEXT:    xxland v2, v2, v3
; PWR7-NEXT:    xxlxor v3, v3, v3
; PWR7-NEXT:    vcmpequw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_2_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 2
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_2_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 2
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 2, i32 2, i32 2, i32 2>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_2_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_2_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI42_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI42_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI42_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI42_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v1, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v1, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vcmpgtuw v2, v2, v0
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_2_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI42_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI42_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI42_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI42_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v1, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v1, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vcmpgtuw v2, v2, v0
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_2_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI42_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI42_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI42_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI42_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    xxland v3, v2, vs0
; PWR7-NEXT:    vsrw v2, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    vadduwm v2, v3, v2
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_2_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 2
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_2_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 2
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 2, i32 2, i32 2, i32 2>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_3_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_3_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI43_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI43_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI43_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI43_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 3
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_3_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI43_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI43_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI43_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI43_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 3
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_3_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI43_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI43_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI43_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI43_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 3
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v4, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_3_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 3
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_3_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 3, i32 3, i32 3, i32 3>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_3_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_3_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI44_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI44_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI44_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI44_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 3
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_3_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI44_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI44_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI44_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI44_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 3
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_3_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI44_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI44_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI44_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI44_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 3
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_3_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 3
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_3_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 3, i32 3, i32 3, i32 3>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_4_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_4_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI45_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI45_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI45_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI45_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vspltisb v0, 15
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v0
; PWR5-NEXT:    vspltisw v0, -16
; PWR5-NEXT:    vrlw v1, v4, v0
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v1, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v0
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vcmpgtuw v2, v5, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_4_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI45_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI45_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI45_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI45_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vspltisb v0, 15
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v0
; PWR6-NEXT:    vspltisw v0, -16
; PWR6-NEXT:    vrlw v1, v4, v0
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v1, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v0
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vcmpgtuw v2, v5, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_4_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI45_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI45_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI45_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI45_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v5, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_4_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 4
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_4_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 4
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 4, i32 4, i32 4, i32 4>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_4_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_4_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI46_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI46_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI46_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI46_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vspltisb v0, 15
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v0
; PWR5-NEXT:    vspltisw v0, -16
; PWR5-NEXT:    vrlw v1, v4, v0
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v1, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v0
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vcmpgtuw v2, v2, v5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_4_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI46_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI46_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI46_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI46_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vspltisb v0, 15
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v0
; PWR6-NEXT:    vspltisw v0, -16
; PWR6-NEXT:    vrlw v1, v4, v0
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v1, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v0
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vcmpgtuw v2, v2, v5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_4_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI46_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI46_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI46_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI46_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v5
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_4_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 4
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_4_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 4
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 4, i32 4, i32 4, i32 4>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_5_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_5_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI47_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI47_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI47_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI47_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 5
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_5_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI47_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI47_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI47_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI47_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 5
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_5_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI47_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI47_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI47_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI47_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 5
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v4, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_5_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 5
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_5_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 5
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 5, i32 5, i32 5, i32 5>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_5_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_5_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI48_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI48_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI48_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI48_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 5
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_5_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI48_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI48_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI48_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI48_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 5
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_5_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI48_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI48_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI48_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI48_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 5
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_5_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 5
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_5_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 5
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 5, i32 5, i32 5, i32 5>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_6_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_6_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI49_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI49_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI49_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI49_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 6
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_6_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI49_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI49_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI49_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI49_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 6
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_6_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI49_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI49_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI49_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI49_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 6
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v4, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_6_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 6
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_6_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 6
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 6, i32 6, i32 6, i32 6>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_6_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_6_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI50_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI50_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI50_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI50_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 6
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_6_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI50_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI50_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI50_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI50_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 6
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_6_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI50_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI50_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI50_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI50_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 6
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_6_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 6
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_6_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 6
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 6, i32 6, i32 6, i32 6>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_7_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_7_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI51_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI51_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI51_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI51_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 7
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_7_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI51_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI51_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI51_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI51_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 7
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_7_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI51_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI51_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI51_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI51_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v4, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_7_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 7
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_7_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 7
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 7, i32 7, i32 7, i32 7>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_7_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_7_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI52_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI52_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI52_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI52_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 7
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_7_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI52_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI52_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI52_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI52_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 7
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_7_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI52_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI52_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI52_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI52_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_7_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 7
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_7_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 7
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 7, i32 7, i32 7, i32 7>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_8_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_8_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI53_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI53_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI53_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI53_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 8
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_8_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI53_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI53_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI53_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI53_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 8
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_8_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI53_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI53_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI53_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI53_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 8
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v4, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_8_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 8
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_8_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 8
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 8, i32 8, i32 8, i32 8>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_8_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_8_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI54_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI54_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI54_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI54_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 8
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_8_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI54_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI54_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI54_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI54_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 8
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_8_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI54_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI54_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI54_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI54_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 8
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_8_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 8
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_8_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 8
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 8, i32 8, i32 8, i32 8>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_9_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_9_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI55_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI55_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI55_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI55_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 9
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_9_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI55_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI55_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI55_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI55_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 9
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_9_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI55_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI55_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI55_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI55_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 9
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v4, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_9_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 9
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_9_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 9
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 9, i32 9, i32 9, i32 9>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_9_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_9_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI56_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI56_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI56_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI56_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 9
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_9_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI56_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI56_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI56_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI56_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 9
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_9_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI56_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI56_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI56_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI56_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 9
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_9_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 9
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_9_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 9
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 9, i32 9, i32 9, i32 9>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_10_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_10_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI57_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI57_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI57_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI57_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 10
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_10_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI57_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI57_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI57_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI57_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 10
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_10_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI57_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI57_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI57_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI57_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 10
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v4, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_10_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 10
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_10_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 10
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 10, i32 10, i32 10, i32 10>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_10_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_10_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI58_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI58_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI58_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI58_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 10
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_10_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI58_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI58_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI58_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI58_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 10
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_10_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI58_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI58_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI58_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI58_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 10
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_10_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 10
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_10_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 10
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 10, i32 10, i32 10, i32 10>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_11_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_11_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI59_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI59_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI59_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI59_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 11
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_11_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI59_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI59_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI59_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI59_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 11
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_11_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI59_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI59_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI59_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI59_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 11
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v4, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_11_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 11
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_11_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 11
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 11, i32 11, i32 11, i32 11>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_11_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_11_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI60_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI60_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI60_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI60_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 11
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_11_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI60_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI60_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI60_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI60_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 11
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_11_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI60_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI60_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI60_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI60_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 11
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_11_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 11
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_11_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 11
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 11, i32 11, i32 11, i32 11>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_12_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_12_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI61_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI61_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI61_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI61_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v5, v3, v3
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v5
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_12_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI61_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI61_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI61_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI61_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v5, v3, v3
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v5
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_12_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI61_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI61_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI61_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI61_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v7, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_12_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 12
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_12_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 12
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 12, i32 12, i32 12, i32 12>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_12_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_12_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI62_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI62_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI62_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI62_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v5, v3, v3
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v5
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_12_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI62_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI62_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI62_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI62_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v5, v3, v3
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v5
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_12_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI62_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI62_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI62_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI62_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v7
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_12_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 12
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_12_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 12
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 12, i32 12, i32 12, i32 12>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_13_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_13_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI63_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI63_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI63_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI63_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 13
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_13_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI63_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI63_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI63_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI63_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 13
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_13_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI63_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI63_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI63_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI63_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 13
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v4, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_13_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 13
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_13_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 13
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 13, i32 13, i32 13, i32 13>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_13_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_13_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI64_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI64_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI64_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI64_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 13
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_13_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI64_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI64_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI64_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI64_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 13
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_13_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI64_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI64_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI64_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI64_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 13
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_13_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 13
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_13_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 13
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 13, i32 13, i32 13, i32 13>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_14_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_14_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI65_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI65_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI65_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI65_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 14
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_14_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI65_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI65_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI65_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI65_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 14
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_14_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI65_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI65_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI65_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI65_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 14
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v4, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_14_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 14
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_14_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 14
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 14, i32 14, i32 14, i32 14>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_14_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_14_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI66_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI66_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI66_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI66_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 14
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_14_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI66_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI66_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI66_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI66_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 14
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_14_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI66_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI66_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI66_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI66_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 14
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_14_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 14
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_14_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 14
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 14, i32 14, i32 14, i32 14>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_15_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_15_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI67_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI67_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI67_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI67_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 15
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_15_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI67_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI67_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI67_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI67_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 15
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_15_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI67_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI67_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI67_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI67_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 15
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v4, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_15_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 15
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_15_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 15
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 15, i32 15, i32 15, i32 15>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_15_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_15_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI68_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI68_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI68_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI68_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 15
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_15_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI68_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI68_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI68_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI68_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 15
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_15_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI68_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI68_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI68_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI68_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vspltisw v4, 15
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v4
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_15_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 15
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_15_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vspltisw v3, 15
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 15, i32 15, i32 15, i32 15>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_16_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_16_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI69_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI69_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI69_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI69_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 8
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_16_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI69_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI69_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI69_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI69_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 8
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_16_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI69_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI69_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI69_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI69_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 8
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_16_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 8
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_16_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 16
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 16, i32 16, i32 16, i32 16>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_16_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_16_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI70_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI70_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI70_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI70_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 8
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_16_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI70_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI70_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI70_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI70_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 8
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_16_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI70_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI70_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI70_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI70_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 8
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_16_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 8
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_16_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 16
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 16, i32 16, i32 16, i32 16>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_17_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_17_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI71_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI71_0@toc@l
; PWR5-NEXT:    lvx v0, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI71_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI71_1@toc@l
; PWR5-NEXT:    vspltisw v1, 2
; PWR5-NEXT:    vsrw v5, v2, v4
; PWR5-NEXT:    vand v5, v5, v0
; PWR5-NEXT:    lvx v0, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v5
; PWR5-NEXT:    vand v5, v2, v0
; PWR5-NEXT:    vsrw v2, v2, v1
; PWR5-NEXT:    vand v2, v2, v0
; PWR5-NEXT:    vspltisw v0, 4
; PWR5-NEXT:    vadduwm v2, v5, v2
; PWR5-NEXT:    vsrw v5, v2, v0
; PWR5-NEXT:    vspltisb v0, 15
; PWR5-NEXT:    vadduwm v2, v2, v5
; PWR5-NEXT:    vspltisb v5, 1
; PWR5-NEXT:    vand v2, v2, v0
; PWR5-NEXT:    vspltisw v0, -16
; PWR5-NEXT:    vrlw v1, v5, v0
; PWR5-NEXT:    vmulouh v5, v2, v5
; PWR5-NEXT:    vmsumuhm v2, v2, v1, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v0
; PWR5-NEXT:    vadduwm v2, v5, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vsubuwm v3, v4, v0
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_17_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI71_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI71_0@toc@l
; PWR6-NEXT:    lvx v0, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI71_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI71_1@toc@l
; PWR6-NEXT:    vspltisw v1, 2
; PWR6-NEXT:    vsrw v5, v2, v4
; PWR6-NEXT:    vand v5, v5, v0
; PWR6-NEXT:    lvx v0, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v5
; PWR6-NEXT:    vand v5, v2, v0
; PWR6-NEXT:    vsrw v2, v2, v1
; PWR6-NEXT:    vand v2, v2, v0
; PWR6-NEXT:    vspltisw v0, 4
; PWR6-NEXT:    vadduwm v2, v5, v2
; PWR6-NEXT:    vsrw v5, v2, v0
; PWR6-NEXT:    vspltisb v0, 15
; PWR6-NEXT:    vadduwm v2, v2, v5
; PWR6-NEXT:    vspltisb v5, 1
; PWR6-NEXT:    vand v2, v2, v0
; PWR6-NEXT:    vspltisw v0, -16
; PWR6-NEXT:    vrlw v1, v5, v0
; PWR6-NEXT:    vmulouh v5, v2, v5
; PWR6-NEXT:    vmsumuhm v2, v2, v1, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v0
; PWR6-NEXT:    vadduwm v2, v5, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vsubuwm v3, v4, v0
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_17_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI71_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI71_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI71_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI71_1@toc@l
; PWR7-NEXT:    vsrw v8, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vsubuwm v3, v3, v6
; PWR7-NEXT:    xxland v8, v8, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v8
; PWR7-NEXT:    vsrw v4, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v4, v4, vs0
; PWR7-NEXT:    vadduwm v2, v2, v4
; PWR7-NEXT:    vsrw v4, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v4
; PWR7-NEXT:    vrlw v4, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v4, v2, v4, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v4, v4, v6
; PWR7-NEXT:    vadduwm v2, v2, v4
; PWR7-NEXT:    vadduwm v4, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v4
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_17_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 1
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_17_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 17
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 17, i32 17, i32 17, i32 17>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_17_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_17_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI72_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI72_0@toc@l
; PWR5-NEXT:    lvx v0, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI72_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI72_1@toc@l
; PWR5-NEXT:    vspltisw v1, 2
; PWR5-NEXT:    vsrw v5, v2, v4
; PWR5-NEXT:    vand v5, v5, v0
; PWR5-NEXT:    lvx v0, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v5
; PWR5-NEXT:    vand v5, v2, v0
; PWR5-NEXT:    vsrw v2, v2, v1
; PWR5-NEXT:    vand v2, v2, v0
; PWR5-NEXT:    vspltisw v0, 4
; PWR5-NEXT:    vadduwm v2, v5, v2
; PWR5-NEXT:    vsrw v5, v2, v0
; PWR5-NEXT:    vspltisb v0, 15
; PWR5-NEXT:    vadduwm v2, v2, v5
; PWR5-NEXT:    vspltisb v5, 1
; PWR5-NEXT:    vand v2, v2, v0
; PWR5-NEXT:    vspltisw v0, -16
; PWR5-NEXT:    vrlw v1, v5, v0
; PWR5-NEXT:    vmulouh v5, v2, v5
; PWR5-NEXT:    vmsumuhm v2, v2, v1, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v0
; PWR5-NEXT:    vadduwm v2, v5, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vsubuwm v3, v4, v0
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_17_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI72_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI72_0@toc@l
; PWR6-NEXT:    lvx v0, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI72_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI72_1@toc@l
; PWR6-NEXT:    vspltisw v1, 2
; PWR6-NEXT:    vsrw v5, v2, v4
; PWR6-NEXT:    vand v5, v5, v0
; PWR6-NEXT:    lvx v0, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v5
; PWR6-NEXT:    vand v5, v2, v0
; PWR6-NEXT:    vsrw v2, v2, v1
; PWR6-NEXT:    vand v2, v2, v0
; PWR6-NEXT:    vspltisw v0, 4
; PWR6-NEXT:    vadduwm v2, v5, v2
; PWR6-NEXT:    vsrw v5, v2, v0
; PWR6-NEXT:    vspltisb v0, 15
; PWR6-NEXT:    vadduwm v2, v2, v5
; PWR6-NEXT:    vspltisb v5, 1
; PWR6-NEXT:    vand v2, v2, v0
; PWR6-NEXT:    vspltisw v0, -16
; PWR6-NEXT:    vrlw v1, v5, v0
; PWR6-NEXT:    vmulouh v5, v2, v5
; PWR6-NEXT:    vmsumuhm v2, v2, v1, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v0
; PWR6-NEXT:    vadduwm v2, v5, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vsubuwm v3, v4, v0
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_17_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI72_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI72_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI72_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI72_1@toc@l
; PWR7-NEXT:    vsrw v8, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vsubuwm v3, v3, v6
; PWR7-NEXT:    xxland v8, v8, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v8
; PWR7-NEXT:    vsrw v4, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxland v4, v4, vs0
; PWR7-NEXT:    vadduwm v2, v2, v4
; PWR7-NEXT:    vsrw v4, v2, v5
; PWR7-NEXT:    xxlxor v5, v5, v5
; PWR7-NEXT:    vadduwm v2, v2, v4
; PWR7-NEXT:    vrlw v4, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v4, v2, v4, v5
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v4, v4, v6
; PWR7-NEXT:    vadduwm v2, v2, v4
; PWR7-NEXT:    vadduwm v4, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v4
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_17_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 1
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_17_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 17
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 17, i32 17, i32 17, i32 17>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_18_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_18_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI73_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI73_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI73_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI73_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 9
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_18_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI73_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI73_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI73_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI73_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 9
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_18_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI73_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI73_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI73_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI73_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 9
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_18_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 9
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_18_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 18
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 18, i32 18, i32 18, i32 18>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_18_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_18_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI74_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI74_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI74_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI74_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 9
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_18_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI74_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI74_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI74_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI74_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 9
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_18_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI74_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI74_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI74_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI74_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 9
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_18_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 9
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_18_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 18
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 18, i32 18, i32 18, i32 18>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_19_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_19_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI75_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI75_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI75_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI75_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 3
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_19_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI75_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI75_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI75_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI75_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 3
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_19_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI75_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI75_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI75_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI75_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 3
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_19_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 3
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_19_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 19
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 19, i32 19, i32 19, i32 19>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_19_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_19_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI76_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI76_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI76_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI76_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 3
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_19_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI76_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI76_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI76_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI76_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 3
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_19_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI76_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI76_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI76_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI76_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 3
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_19_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 3
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_19_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 19
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 19, i32 19, i32 19, i32 19>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_20_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_20_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI77_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI77_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI77_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI77_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 10
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_20_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI77_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI77_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI77_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI77_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 10
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_20_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI77_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI77_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI77_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI77_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 10
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_20_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 10
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_20_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 20
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 20, i32 20, i32 20, i32 20>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_20_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_20_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI78_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI78_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI78_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI78_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 10
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_20_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI78_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI78_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI78_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI78_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 10
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_20_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI78_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI78_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI78_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI78_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 10
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_20_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 10
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_20_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 20
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 20, i32 20, i32 20, i32 20>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_21_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_21_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI79_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI79_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI79_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI79_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 5
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_21_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI79_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI79_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI79_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI79_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 5
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_21_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI79_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI79_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI79_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI79_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 5
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_21_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 5
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_21_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 21
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 21, i32 21, i32 21, i32 21>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_21_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_21_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI80_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI80_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI80_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI80_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 5
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_21_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI80_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI80_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI80_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI80_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 5
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_21_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI80_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI80_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI80_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI80_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 5
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_21_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 5
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_21_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 21
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 21, i32 21, i32 21, i32 21>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_22_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_22_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI81_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI81_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI81_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI81_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 11
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_22_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI81_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI81_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI81_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI81_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 11
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_22_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI81_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI81_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI81_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI81_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 11
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_22_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 11
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_22_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 22
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 22, i32 22, i32 22, i32 22>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_22_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_22_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI82_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI82_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI82_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI82_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 11
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_22_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI82_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI82_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI82_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI82_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 11
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_22_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI82_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI82_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI82_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI82_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 11
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_22_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 11
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_22_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 22
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 22, i32 22, i32 22, i32 22>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_23_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_23_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI83_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI83_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI83_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI83_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 7
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_23_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI83_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI83_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI83_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI83_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 7
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_23_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI83_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI83_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI83_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI83_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 7
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_23_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 7
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_23_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 23
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 23, i32 23, i32 23, i32 23>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_23_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_23_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI84_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI84_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI84_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI84_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 7
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_23_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI84_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI84_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI84_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI84_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 7
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_23_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI84_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI84_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI84_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI84_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 7
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_23_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 7
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_23_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 23
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 23, i32 23, i32 23, i32 23>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_24_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_24_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI85_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI85_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI85_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI85_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_24_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI85_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI85_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI85_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI85_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_24_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI85_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI85_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI85_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI85_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_24_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 12
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_24_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 24
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 24, i32 24, i32 24, i32 24>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_24_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_24_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI86_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI86_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI86_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI86_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_24_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI86_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI86_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI86_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI86_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_24_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI86_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI86_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI86_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI86_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_24_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 12
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_24_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 24
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 24, i32 24, i32 24, i32 24>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_25_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_25_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI87_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI87_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI87_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI87_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 9
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_25_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI87_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI87_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI87_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI87_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 9
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_25_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI87_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI87_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI87_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI87_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 9
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_25_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 9
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_25_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 25
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 25, i32 25, i32 25, i32 25>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_25_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_25_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI88_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI88_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI88_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI88_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 9
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_25_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI88_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI88_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI88_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI88_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 9
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_25_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI88_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI88_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI88_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI88_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 9
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_25_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 9
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_25_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 25
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 25, i32 25, i32 25, i32 25>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_26_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_26_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI89_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI89_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI89_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI89_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 13
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_26_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI89_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI89_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI89_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI89_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 13
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_26_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI89_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI89_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI89_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI89_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 13
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_26_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 13
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_26_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 26
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 26, i32 26, i32 26, i32 26>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_26_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_26_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI90_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI90_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI90_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI90_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 13
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_26_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI90_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI90_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI90_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI90_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 13
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_26_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI90_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI90_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI90_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI90_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 13
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_26_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 13
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_26_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 26
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 26, i32 26, i32 26, i32 26>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_27_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_27_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI91_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI91_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI91_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI91_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 11
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_27_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI91_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI91_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI91_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI91_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 11
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_27_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI91_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI91_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI91_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI91_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 11
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_27_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 11
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_27_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 27
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 27, i32 27, i32 27, i32 27>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_27_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_27_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI92_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI92_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI92_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI92_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 11
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_27_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI92_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI92_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI92_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI92_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 11
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_27_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI92_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI92_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI92_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI92_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 11
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_27_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 11
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_27_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 27
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 27, i32 27, i32 27, i32 27>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_28_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_28_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI93_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI93_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI93_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI93_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 14
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_28_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI93_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI93_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI93_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI93_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 14
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_28_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI93_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI93_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI93_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI93_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 14
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_28_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 14
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_28_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 28
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 28, i32 28, i32 28, i32 28>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_28_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_28_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI94_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI94_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI94_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI94_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 14
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_28_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI94_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI94_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI94_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI94_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 14
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_28_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI94_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI94_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI94_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI94_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 14
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_28_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 14
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_28_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 28
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 28, i32 28, i32 28, i32 28>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_29_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_29_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI95_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI95_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI95_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI95_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 13
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_29_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI95_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI95_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI95_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI95_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 13
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_29_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI95_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI95_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI95_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI95_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 13
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_29_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 13
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_29_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 29
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 29, i32 29, i32 29, i32 29>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_29_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_29_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI96_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI96_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI96_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI96_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 13
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_29_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI96_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI96_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI96_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI96_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 13
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_29_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI96_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI96_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI96_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI96_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 13
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_29_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 13
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_29_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 29
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 29, i32 29, i32 29, i32 29>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_30_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_30_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI97_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI97_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI97_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI97_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 15
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_30_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI97_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI97_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI97_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI97_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 15
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_30_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI97_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI97_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI97_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI97_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 15
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_30_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 15
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_30_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 30
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 30, i32 30, i32 30, i32 30>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ugt_30_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ugt_30_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI98_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI98_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI98_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI98_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 15
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vcmpgtuw v2, v2, v3
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_30_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI98_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI98_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI98_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI98_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 15
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vcmpgtuw v2, v2, v3
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_30_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI98_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI98_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI98_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI98_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 15
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v8, v8
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_30_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 15
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vadduwm v3, v3, v3
; PWR8-NEXT:    vcmpgtuw v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_30_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 30
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ugt <4 x i32> %2, <i32 30, i32 30, i32 30, i32 30>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <4 x i32> @ult_31_v4i32(<4 x i32> %0) {
; PWR5-LABEL: ult_31_v4i32:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addis r3, r2, .LCPI99_0@toc@ha
; PWR5-NEXT:    vspltisw v4, 1
; PWR5-NEXT:    vxor v3, v3, v3
; PWR5-NEXT:    addi r3, r3, .LCPI99_0@toc@l
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    addis r3, r2, .LCPI99_1@toc@ha
; PWR5-NEXT:    addi r3, r3, .LCPI99_1@toc@l
; PWR5-NEXT:    vspltisw v0, 2
; PWR5-NEXT:    vsrw v4, v2, v4
; PWR5-NEXT:    vand v4, v4, v5
; PWR5-NEXT:    lvx v5, 0, r3
; PWR5-NEXT:    vsubuwm v2, v2, v4
; PWR5-NEXT:    vand v4, v2, v5
; PWR5-NEXT:    vsrw v2, v2, v0
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, 4
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v4, v2, v5
; PWR5-NEXT:    vspltisb v5, 15
; PWR5-NEXT:    vadduwm v2, v2, v4
; PWR5-NEXT:    vspltisb v4, 1
; PWR5-NEXT:    vand v2, v2, v5
; PWR5-NEXT:    vspltisw v5, -16
; PWR5-NEXT:    vrlw v0, v4, v5
; PWR5-NEXT:    vmulouh v4, v2, v4
; PWR5-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR5-NEXT:    vspltisw v3, 12
; PWR5-NEXT:    vadduwm v3, v3, v3
; PWR5-NEXT:    vslw v2, v2, v5
; PWR5-NEXT:    vadduwm v2, v4, v2
; PWR5-NEXT:    vsrw v2, v2, v3
; PWR5-NEXT:    vspltisw v3, 15
; PWR5-NEXT:    vsubuwm v3, v3, v5
; PWR5-NEXT:    vcmpgtuw v2, v3, v2
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_31_v4i32:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addis r3, r2, .LCPI99_0@toc@ha
; PWR6-NEXT:    vspltisw v4, 1
; PWR6-NEXT:    vxor v3, v3, v3
; PWR6-NEXT:    addi r3, r3, .LCPI99_0@toc@l
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    addis r3, r2, .LCPI99_1@toc@ha
; PWR6-NEXT:    addi r3, r3, .LCPI99_1@toc@l
; PWR6-NEXT:    vspltisw v0, 2
; PWR6-NEXT:    vsrw v4, v2, v4
; PWR6-NEXT:    vand v4, v4, v5
; PWR6-NEXT:    lvx v5, 0, r3
; PWR6-NEXT:    vsubuwm v2, v2, v4
; PWR6-NEXT:    vand v4, v2, v5
; PWR6-NEXT:    vsrw v2, v2, v0
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, 4
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v4, v2, v5
; PWR6-NEXT:    vspltisb v5, 15
; PWR6-NEXT:    vadduwm v2, v2, v4
; PWR6-NEXT:    vspltisb v4, 1
; PWR6-NEXT:    vand v2, v2, v5
; PWR6-NEXT:    vspltisw v5, -16
; PWR6-NEXT:    vrlw v0, v4, v5
; PWR6-NEXT:    vmulouh v4, v2, v4
; PWR6-NEXT:    vmsumuhm v2, v2, v0, v3
; PWR6-NEXT:    vspltisw v3, 12
; PWR6-NEXT:    vadduwm v3, v3, v3
; PWR6-NEXT:    vslw v2, v2, v5
; PWR6-NEXT:    vadduwm v2, v4, v2
; PWR6-NEXT:    vsrw v2, v2, v3
; PWR6-NEXT:    vspltisw v3, 15
; PWR6-NEXT:    vsubuwm v3, v3, v5
; PWR6-NEXT:    vcmpgtuw v2, v3, v2
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_31_v4i32:
; PWR7:       # %bb.0:
; PWR7-NEXT:    vspltisw v3, 1
; PWR7-NEXT:    addis r3, r2, .LCPI99_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI99_0@toc@l
; PWR7-NEXT:    vspltisw v4, 2
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI99_1@toc@ha
; PWR7-NEXT:    vspltisw v5, 4
; PWR7-NEXT:    addi r3, r3, .LCPI99_1@toc@l
; PWR7-NEXT:    vsrw v3, v2, v3
; PWR7-NEXT:    vspltisb v0, 15
; PWR7-NEXT:    vspltisb v1, 1
; PWR7-NEXT:    vspltisw v6, -16
; PWR7-NEXT:    vspltisw v7, 12
; PWR7-NEXT:    vspltisw v8, 15
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    vsubuwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v4
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    xxlxor v4, v4, v4
; PWR7-NEXT:    xxland v3, v3, vs0
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vsrw v3, v2, v5
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vrlw v3, v1, v6
; PWR7-NEXT:    xxland v2, v2, v0
; PWR7-NEXT:    vmsumuhm v3, v2, v3, v4
; PWR7-NEXT:    vmulouh v2, v2, v1
; PWR7-NEXT:    vslw v3, v3, v6
; PWR7-NEXT:    vadduwm v2, v2, v3
; PWR7-NEXT:    vadduwm v3, v7, v7
; PWR7-NEXT:    vsrw v2, v2, v3
; PWR7-NEXT:    vsubuwm v3, v8, v6
; PWR7-NEXT:    vcmpgtuw v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_31_v4i32:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, -16
; PWR8-NEXT:    vspltisw v4, 15
; PWR8-NEXT:    vpopcntw v2, v2
; PWR8-NEXT:    vsubuwm v3, v4, v3
; PWR8-NEXT:    vcmpgtuw v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_31_v4i32:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 31
; PWR9-NEXT:    vpopcntw v2, v2
; PWR9-NEXT:    vextsb2w v3, v3
; PWR9-NEXT:    vcmpgtuw v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %0)
  %3 = icmp ult <4 x i32> %2, <i32 31, i32 31, i32 31, i32 31>
  %4 = sext <4 x i1> %3 to <4 x i32>
  ret <4 x i32> %4
}

define <2 x i64> @ugt_1_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_1_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addi r5, r3, -1
; PWR5-NEXT:    addi r6, r4, -1
; PWR5-NEXT:    and r3, r3, r5
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    subfic r3, r3, 0
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subfic r4, r4, 0
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_1_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addi r5, r3, -1
; PWR6-NEXT:    addi r6, r4, -1
; PWR6-NEXT:    and r3, r3, r5
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    subfic r3, r3, 0
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subfic r4, r4, 0
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_1_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    xxlxor v3, v3, v3
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r3, -24(r1)
; PWR7-NEXT:    addi r3, r3, -1
; PWR7-NEXT:    std r3, -8(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    addi r3, r3, -1
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI100_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI100_0@toc@l
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    vcmpgtuw v2, v2, v3
; PWR7-NEXT:    lxvw4x v3, 0, r3
; PWR7-NEXT:    vperm v3, v2, v2, v3
; PWR7-NEXT:    xxlor v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_1_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 1
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_1_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 1
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 1, i64 1>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_2_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_2_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    addi r5, r3, -1
; PWR5-NEXT:    addi r6, r4, -1
; PWR5-NEXT:    and r3, r3, r5
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    addic r3, r3, -1
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    addic r4, r4, -1
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_2_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    addi r5, r3, -1
; PWR6-NEXT:    addi r6, r4, -1
; PWR6-NEXT:    and r3, r3, r5
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    addic r3, r3, -1
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    addic r4, r4, -1
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_2_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    xxlxor v3, v3, v3
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r3, -24(r1)
; PWR7-NEXT:    addi r3, r3, -1
; PWR7-NEXT:    std r3, -8(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    addi r3, r3, -1
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvw4x vs0, 0, r3
; PWR7-NEXT:    addis r3, r2, .LCPI101_0@toc@ha
; PWR7-NEXT:    addi r3, r3, .LCPI101_0@toc@l
; PWR7-NEXT:    xxland v2, v2, vs0
; PWR7-NEXT:    vcmpequw v2, v2, v3
; PWR7-NEXT:    lxvw4x v3, 0, r3
; PWR7-NEXT:    vperm v3, v2, v2, v3
; PWR7-NEXT:    xxland v2, v3, v2
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_2_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 2
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_2_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 2
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 2, i64 2>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_2_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_2_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 2
; PWR5-NEXT:    subfic r3, r3, 2
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 2
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_2_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 2
; PWR6-NEXT:    subfic r3, r3, 2
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 2
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_2_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 2
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 2
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_2_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 2
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_2_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 2
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 2, i64 2>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_3_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_3_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 3
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_3_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 3
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_3_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 3
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 3
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_3_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 3
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_3_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 3
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 3, i64 3>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_3_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_3_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 3
; PWR5-NEXT:    subfic r3, r3, 3
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 3
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_3_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 3
; PWR6-NEXT:    subfic r3, r3, 3
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 3
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_3_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 3
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 3
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_3_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 3
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_3_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 3
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 3, i64 3>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_4_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_4_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 4
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_4_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 4
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_4_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 4
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 4
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_4_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 4
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_4_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 4
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 4, i64 4>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_4_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_4_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 4
; PWR5-NEXT:    subfic r3, r3, 4
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 4
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_4_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 4
; PWR6-NEXT:    subfic r3, r3, 4
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 4
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_4_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 4
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 4
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_4_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 4
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_4_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 4
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 4, i64 4>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_5_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_5_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 5
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_5_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 5
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_5_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 5
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 5
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_5_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 5
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_5_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 5
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 5, i64 5>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_5_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_5_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 5
; PWR5-NEXT:    subfic r3, r3, 5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 5
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_5_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 5
; PWR6-NEXT:    subfic r3, r3, 5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 5
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_5_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 5
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 5
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_5_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 5
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_5_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 5
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 5, i64 5>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_6_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_6_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 6
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_6_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 6
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_6_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 6
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 6
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_6_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 6
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_6_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 6
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 6, i64 6>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_6_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_6_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 6
; PWR5-NEXT:    subfic r3, r3, 6
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 6
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_6_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 6
; PWR6-NEXT:    subfic r3, r3, 6
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 6
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_6_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 6
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 6
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_6_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 6
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_6_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 6
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 6, i64 6>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_7_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_7_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 7
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_7_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 7
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_7_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 7
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 7
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_7_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 7
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_7_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 7
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 7, i64 7>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_7_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_7_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 7
; PWR5-NEXT:    subfic r3, r3, 7
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 7
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_7_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 7
; PWR6-NEXT:    subfic r3, r3, 7
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 7
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_7_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 7
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 7
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_7_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 7
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_7_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 7
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 7, i64 7>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_8_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_8_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 8
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_8_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 8
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_8_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 8
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 8
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_8_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 8
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_8_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 8
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 8, i64 8>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_8_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_8_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 8
; PWR5-NEXT:    subfic r3, r3, 8
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 8
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_8_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 8
; PWR6-NEXT:    subfic r3, r3, 8
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 8
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_8_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 8
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 8
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_8_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 8
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_8_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 8
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 8, i64 8>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_9_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_9_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 9
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_9_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 9
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_9_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 9
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 9
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_9_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 9
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_9_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 9
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 9, i64 9>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_9_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_9_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 9
; PWR5-NEXT:    subfic r3, r3, 9
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 9
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_9_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 9
; PWR6-NEXT:    subfic r3, r3, 9
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 9
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_9_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 9
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 9
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_9_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 9
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_9_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 9
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 9, i64 9>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_10_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_10_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 10
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_10_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 10
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_10_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 10
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 10
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_10_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 10
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_10_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 10
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 10, i64 10>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_10_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_10_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 10
; PWR5-NEXT:    subfic r3, r3, 10
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 10
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_10_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 10
; PWR6-NEXT:    subfic r3, r3, 10
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 10
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_10_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 10
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 10
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_10_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 10
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_10_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 10
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 10, i64 10>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_11_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_11_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 11
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_11_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 11
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_11_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 11
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 11
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_11_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 11
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_11_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 11
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 11, i64 11>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_11_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_11_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 11
; PWR5-NEXT:    subfic r3, r3, 11
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 11
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_11_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 11
; PWR6-NEXT:    subfic r3, r3, 11
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 11
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_11_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 11
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 11
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_11_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 11
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_11_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 11
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 11, i64 11>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_12_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_12_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 12
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_12_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 12
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_12_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 12
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 12
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_12_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 12
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_12_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 12
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 12, i64 12>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_12_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_12_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 12
; PWR5-NEXT:    subfic r3, r3, 12
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 12
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_12_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 12
; PWR6-NEXT:    subfic r3, r3, 12
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 12
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_12_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 12
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 12
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_12_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 12
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_12_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 12
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 12, i64 12>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_13_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_13_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 13
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_13_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 13
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_13_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 13
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 13
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_13_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 13
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_13_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 13
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 13, i64 13>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_13_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_13_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 13
; PWR5-NEXT:    subfic r3, r3, 13
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 13
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_13_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 13
; PWR6-NEXT:    subfic r3, r3, 13
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 13
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_13_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 13
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 13
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_13_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 13
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_13_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 13
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 13, i64 13>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_14_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_14_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 14
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_14_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 14
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_14_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 14
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 14
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_14_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 14
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_14_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 14
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 14, i64 14>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_14_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_14_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 14
; PWR5-NEXT:    subfic r3, r3, 14
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 14
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_14_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 14
; PWR6-NEXT:    subfic r3, r3, 14
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 14
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_14_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 14
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 14
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_14_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 14
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_14_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 14
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 14, i64 14>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_15_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_15_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 15
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_15_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 15
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_15_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 15
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 15
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_15_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 15
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_15_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 15
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 15, i64 15>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_15_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_15_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 15
; PWR5-NEXT:    subfic r3, r3, 15
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 15
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_15_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 15
; PWR6-NEXT:    subfic r3, r3, 15
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 15
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_15_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 15
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 15
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_15_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    vspltisw v3, 15
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    vupklsw v3, v3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_15_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    vspltisw v3, 15
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vupklsw v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 15, i64 15>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_16_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_16_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 16
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_16_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 16
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_16_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 16
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 16
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_16_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI129_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI129_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_16_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 16
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 16, i64 16>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_16_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_16_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 16
; PWR5-NEXT:    subfic r3, r3, 16
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 16
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_16_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 16
; PWR6-NEXT:    subfic r3, r3, 16
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 16
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_16_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 16
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 16
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_16_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI130_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI130_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_16_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 16
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 16, i64 16>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_17_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_17_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 17
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_17_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 17
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_17_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 17
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 17
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_17_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI131_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI131_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_17_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 17
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 17, i64 17>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_17_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_17_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 17
; PWR5-NEXT:    subfic r3, r3, 17
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 17
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_17_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 17
; PWR6-NEXT:    subfic r3, r3, 17
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 17
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_17_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 17
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 17
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_17_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI132_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI132_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_17_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 17
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 17, i64 17>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_18_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_18_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 18
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_18_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 18
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_18_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 18
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 18
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_18_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI133_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI133_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_18_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 18
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 18, i64 18>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_18_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_18_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 18
; PWR5-NEXT:    subfic r3, r3, 18
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 18
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_18_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 18
; PWR6-NEXT:    subfic r3, r3, 18
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 18
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_18_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 18
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 18
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_18_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI134_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI134_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_18_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 18
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 18, i64 18>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_19_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_19_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 19
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_19_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 19
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_19_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 19
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 19
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_19_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI135_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI135_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_19_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 19
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 19, i64 19>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_19_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_19_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 19
; PWR5-NEXT:    subfic r3, r3, 19
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 19
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_19_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 19
; PWR6-NEXT:    subfic r3, r3, 19
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 19
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_19_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 19
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 19
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_19_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI136_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI136_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_19_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 19
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 19, i64 19>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_20_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_20_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 20
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_20_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 20
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_20_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 20
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 20
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_20_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI137_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI137_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_20_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 20
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 20, i64 20>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_20_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_20_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 20
; PWR5-NEXT:    subfic r3, r3, 20
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 20
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_20_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 20
; PWR6-NEXT:    subfic r3, r3, 20
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 20
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_20_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 20
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 20
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_20_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI138_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI138_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_20_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 20
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 20, i64 20>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_21_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_21_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 21
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_21_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 21
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_21_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 21
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 21
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_21_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI139_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI139_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_21_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 21
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 21, i64 21>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_21_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_21_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 21
; PWR5-NEXT:    subfic r3, r3, 21
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 21
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_21_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 21
; PWR6-NEXT:    subfic r3, r3, 21
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 21
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_21_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 21
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 21
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_21_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI140_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI140_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_21_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 21
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 21, i64 21>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_22_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_22_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 22
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_22_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 22
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_22_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 22
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 22
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_22_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI141_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI141_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_22_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 22
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 22, i64 22>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_22_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_22_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 22
; PWR5-NEXT:    subfic r3, r3, 22
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 22
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_22_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 22
; PWR6-NEXT:    subfic r3, r3, 22
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 22
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_22_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 22
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 22
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_22_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI142_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI142_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_22_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 22
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 22, i64 22>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_23_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_23_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 23
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_23_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 23
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_23_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 23
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 23
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_23_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI143_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI143_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_23_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 23
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 23, i64 23>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_23_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_23_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 23
; PWR5-NEXT:    subfic r3, r3, 23
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 23
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_23_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 23
; PWR6-NEXT:    subfic r3, r3, 23
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 23
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_23_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 23
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 23
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_23_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI144_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI144_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_23_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 23
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 23, i64 23>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_24_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_24_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 24
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_24_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 24
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_24_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 24
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 24
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_24_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI145_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI145_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_24_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 24
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 24, i64 24>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_24_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_24_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 24
; PWR5-NEXT:    subfic r3, r3, 24
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 24
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_24_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 24
; PWR6-NEXT:    subfic r3, r3, 24
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 24
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_24_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 24
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 24
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_24_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI146_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI146_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_24_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 24
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 24, i64 24>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_25_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_25_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 25
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_25_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 25
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_25_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 25
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 25
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_25_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI147_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI147_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_25_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 25
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 25, i64 25>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_25_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_25_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 25
; PWR5-NEXT:    subfic r3, r3, 25
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 25
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_25_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 25
; PWR6-NEXT:    subfic r3, r3, 25
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 25
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_25_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 25
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 25
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_25_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI148_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI148_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_25_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 25
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 25, i64 25>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_26_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_26_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 26
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_26_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 26
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_26_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 26
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 26
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_26_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI149_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI149_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_26_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 26
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 26, i64 26>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_26_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_26_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 26
; PWR5-NEXT:    subfic r3, r3, 26
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 26
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_26_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 26
; PWR6-NEXT:    subfic r3, r3, 26
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 26
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_26_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 26
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 26
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_26_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI150_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI150_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_26_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 26
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 26, i64 26>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_27_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_27_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 27
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_27_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 27
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_27_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 27
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 27
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_27_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI151_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI151_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_27_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 27
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 27, i64 27>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_27_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_27_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 27
; PWR5-NEXT:    subfic r3, r3, 27
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 27
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_27_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 27
; PWR6-NEXT:    subfic r3, r3, 27
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 27
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_27_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 27
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 27
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_27_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI152_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI152_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_27_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 27
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 27, i64 27>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_28_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_28_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 28
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_28_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 28
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_28_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 28
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 28
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_28_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI153_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI153_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_28_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 28
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 28, i64 28>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_28_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_28_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 28
; PWR5-NEXT:    subfic r3, r3, 28
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 28
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_28_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 28
; PWR6-NEXT:    subfic r3, r3, 28
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 28
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_28_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 28
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 28
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_28_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI154_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI154_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_28_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 28
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 28, i64 28>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_29_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_29_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 29
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_29_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 29
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_29_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 29
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 29
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_29_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI155_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI155_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_29_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 29
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 29, i64 29>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_29_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_29_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 29
; PWR5-NEXT:    subfic r3, r3, 29
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 29
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_29_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 29
; PWR6-NEXT:    subfic r3, r3, 29
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 29
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_29_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 29
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 29
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_29_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI156_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI156_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_29_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 29
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 29, i64 29>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_30_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_30_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 30
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_30_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 30
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_30_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 30
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 30
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_30_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI157_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI157_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_30_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 30
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 30, i64 30>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_30_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_30_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 30
; PWR5-NEXT:    subfic r3, r3, 30
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 30
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_30_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 30
; PWR6-NEXT:    subfic r3, r3, 30
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 30
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_30_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 30
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 30
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_30_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI158_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI158_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_30_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 30
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 30, i64 30>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_31_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_31_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 31
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_31_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 31
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_31_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 31
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 31
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_31_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI159_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI159_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_31_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 31
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 31, i64 31>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_31_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_31_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 31
; PWR5-NEXT:    subfic r3, r3, 31
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 31
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_31_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 31
; PWR6-NEXT:    subfic r3, r3, 31
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 31
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_31_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 31
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 31
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_31_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI160_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI160_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_31_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 31
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 31, i64 31>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_32_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_32_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 32
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_32_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 32
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_32_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 32
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 32
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_32_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI161_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI161_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_32_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 32
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 32, i64 32>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_32_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_32_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 32
; PWR5-NEXT:    subfic r3, r3, 32
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 32
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_32_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 32
; PWR6-NEXT:    subfic r3, r3, 32
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 32
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_32_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 32
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 32
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_32_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI162_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI162_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_32_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 32
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 32, i64 32>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_33_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_33_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 33
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_33_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 33
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_33_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 33
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 33
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_33_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI163_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI163_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_33_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 33
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 33, i64 33>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_33_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_33_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 33
; PWR5-NEXT:    subfic r3, r3, 33
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 33
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_33_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 33
; PWR6-NEXT:    subfic r3, r3, 33
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 33
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_33_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 33
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 33
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_33_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI164_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI164_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_33_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 33
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 33, i64 33>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_34_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_34_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 34
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_34_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 34
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_34_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 34
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 34
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_34_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI165_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI165_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_34_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 34
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 34, i64 34>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_34_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_34_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 34
; PWR5-NEXT:    subfic r3, r3, 34
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 34
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_34_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 34
; PWR6-NEXT:    subfic r3, r3, 34
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 34
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_34_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 34
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 34
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_34_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI166_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI166_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_34_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 34
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 34, i64 34>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_35_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_35_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 35
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_35_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 35
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_35_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 35
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 35
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_35_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI167_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI167_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_35_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 35
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 35, i64 35>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_35_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_35_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 35
; PWR5-NEXT:    subfic r3, r3, 35
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 35
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_35_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 35
; PWR6-NEXT:    subfic r3, r3, 35
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 35
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_35_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 35
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 35
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_35_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI168_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI168_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_35_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 35
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 35, i64 35>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_36_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_36_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 36
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_36_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 36
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_36_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 36
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 36
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_36_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI169_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI169_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_36_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 36
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 36, i64 36>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_36_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_36_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 36
; PWR5-NEXT:    subfic r3, r3, 36
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 36
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_36_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 36
; PWR6-NEXT:    subfic r3, r3, 36
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 36
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_36_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 36
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 36
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_36_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI170_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI170_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_36_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 36
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 36, i64 36>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_37_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_37_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 37
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_37_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 37
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_37_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 37
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 37
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_37_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI171_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI171_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_37_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 37
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 37, i64 37>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_37_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_37_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 37
; PWR5-NEXT:    subfic r3, r3, 37
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 37
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_37_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 37
; PWR6-NEXT:    subfic r3, r3, 37
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 37
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_37_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 37
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 37
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_37_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI172_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI172_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_37_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 37
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 37, i64 37>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_38_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_38_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 38
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_38_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 38
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_38_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 38
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 38
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_38_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI173_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI173_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_38_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 38
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 38, i64 38>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_38_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_38_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 38
; PWR5-NEXT:    subfic r3, r3, 38
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 38
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_38_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 38
; PWR6-NEXT:    subfic r3, r3, 38
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 38
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_38_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 38
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 38
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_38_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI174_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI174_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_38_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 38
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 38, i64 38>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_39_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_39_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 39
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_39_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 39
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_39_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 39
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 39
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_39_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI175_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI175_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_39_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 39
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 39, i64 39>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_39_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_39_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 39
; PWR5-NEXT:    subfic r3, r3, 39
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 39
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_39_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 39
; PWR6-NEXT:    subfic r3, r3, 39
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 39
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_39_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 39
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 39
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_39_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI176_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI176_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_39_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 39
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 39, i64 39>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_40_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_40_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 40
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_40_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 40
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_40_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 40
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 40
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_40_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI177_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI177_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_40_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 40
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 40, i64 40>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_40_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_40_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 40
; PWR5-NEXT:    subfic r3, r3, 40
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 40
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_40_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 40
; PWR6-NEXT:    subfic r3, r3, 40
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 40
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_40_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 40
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 40
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_40_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI178_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI178_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_40_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 40
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 40, i64 40>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_41_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_41_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 41
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_41_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 41
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_41_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 41
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 41
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_41_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI179_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI179_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_41_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 41
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 41, i64 41>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_41_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_41_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 41
; PWR5-NEXT:    subfic r3, r3, 41
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 41
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_41_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 41
; PWR6-NEXT:    subfic r3, r3, 41
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 41
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_41_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 41
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 41
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_41_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI180_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI180_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_41_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 41
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 41, i64 41>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_42_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_42_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 42
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_42_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 42
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_42_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 42
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 42
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_42_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI181_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI181_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_42_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 42
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 42, i64 42>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_42_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_42_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 42
; PWR5-NEXT:    subfic r3, r3, 42
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 42
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_42_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 42
; PWR6-NEXT:    subfic r3, r3, 42
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 42
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_42_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 42
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 42
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_42_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI182_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI182_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_42_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 42
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 42, i64 42>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_43_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_43_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 43
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_43_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 43
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_43_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 43
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 43
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_43_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI183_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI183_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_43_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 43
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 43, i64 43>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_43_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_43_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 43
; PWR5-NEXT:    subfic r3, r3, 43
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 43
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_43_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 43
; PWR6-NEXT:    subfic r3, r3, 43
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 43
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_43_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 43
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 43
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_43_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI184_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI184_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_43_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 43
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 43, i64 43>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_44_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_44_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 44
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_44_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 44
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_44_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 44
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 44
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_44_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI185_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI185_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_44_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 44
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 44, i64 44>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_44_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_44_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 44
; PWR5-NEXT:    subfic r3, r3, 44
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 44
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_44_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 44
; PWR6-NEXT:    subfic r3, r3, 44
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 44
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_44_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 44
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 44
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_44_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI186_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI186_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_44_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 44
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 44, i64 44>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_45_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_45_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 45
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_45_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 45
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_45_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 45
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 45
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_45_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI187_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI187_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_45_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 45
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 45, i64 45>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_45_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_45_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 45
; PWR5-NEXT:    subfic r3, r3, 45
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 45
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_45_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 45
; PWR6-NEXT:    subfic r3, r3, 45
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 45
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_45_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 45
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 45
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_45_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI188_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI188_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_45_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 45
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 45, i64 45>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_46_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_46_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 46
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_46_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 46
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_46_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 46
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 46
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_46_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI189_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI189_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_46_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 46
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 46, i64 46>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_46_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_46_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 46
; PWR5-NEXT:    subfic r3, r3, 46
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 46
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_46_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 46
; PWR6-NEXT:    subfic r3, r3, 46
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 46
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_46_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 46
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 46
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_46_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI190_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI190_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_46_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 46
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 46, i64 46>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_47_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_47_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 47
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_47_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 47
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_47_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 47
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 47
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_47_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI191_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI191_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_47_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 47
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 47, i64 47>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_47_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_47_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 47
; PWR5-NEXT:    subfic r3, r3, 47
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 47
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_47_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 47
; PWR6-NEXT:    subfic r3, r3, 47
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 47
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_47_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 47
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 47
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_47_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI192_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI192_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_47_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 47
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 47, i64 47>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_48_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_48_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 48
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_48_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 48
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_48_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 48
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 48
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_48_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI193_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI193_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_48_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 48
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 48, i64 48>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_48_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_48_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 48
; PWR5-NEXT:    subfic r3, r3, 48
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 48
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_48_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 48
; PWR6-NEXT:    subfic r3, r3, 48
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 48
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_48_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 48
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 48
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_48_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI194_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI194_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_48_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 48
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 48, i64 48>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_49_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_49_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 49
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_49_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 49
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_49_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 49
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 49
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_49_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI195_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI195_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_49_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 49
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 49, i64 49>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_49_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_49_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 49
; PWR5-NEXT:    subfic r3, r3, 49
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 49
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_49_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 49
; PWR6-NEXT:    subfic r3, r3, 49
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 49
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_49_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 49
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 49
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_49_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI196_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI196_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_49_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 49
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 49, i64 49>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_50_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_50_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 50
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_50_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 50
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_50_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 50
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 50
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_50_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI197_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI197_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_50_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 50
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 50, i64 50>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_50_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_50_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 50
; PWR5-NEXT:    subfic r3, r3, 50
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 50
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_50_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 50
; PWR6-NEXT:    subfic r3, r3, 50
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 50
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_50_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 50
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 50
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_50_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI198_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI198_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_50_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 50
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 50, i64 50>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_51_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_51_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 51
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_51_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 51
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_51_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 51
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 51
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_51_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI199_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI199_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_51_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 51
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 51, i64 51>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_51_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_51_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 51
; PWR5-NEXT:    subfic r3, r3, 51
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 51
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_51_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 51
; PWR6-NEXT:    subfic r3, r3, 51
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 51
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_51_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 51
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 51
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_51_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI200_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI200_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_51_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 51
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 51, i64 51>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_52_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_52_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 52
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_52_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 52
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_52_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 52
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 52
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_52_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI201_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI201_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_52_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 52
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 52, i64 52>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_52_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_52_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 52
; PWR5-NEXT:    subfic r3, r3, 52
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 52
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_52_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 52
; PWR6-NEXT:    subfic r3, r3, 52
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 52
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_52_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 52
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 52
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_52_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI202_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI202_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_52_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 52
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 52, i64 52>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_53_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_53_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 53
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_53_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 53
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_53_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 53
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 53
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_53_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI203_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI203_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_53_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 53
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 53, i64 53>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_53_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_53_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 53
; PWR5-NEXT:    subfic r3, r3, 53
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 53
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_53_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 53
; PWR6-NEXT:    subfic r3, r3, 53
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 53
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_53_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 53
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 53
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_53_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI204_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI204_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_53_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 53
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 53, i64 53>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_54_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_54_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 54
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_54_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 54
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_54_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 54
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 54
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_54_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI205_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI205_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_54_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 54
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 54, i64 54>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_54_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_54_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 54
; PWR5-NEXT:    subfic r3, r3, 54
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 54
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_54_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 54
; PWR6-NEXT:    subfic r3, r3, 54
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 54
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_54_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 54
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 54
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_54_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI206_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI206_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_54_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 54
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 54, i64 54>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_55_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_55_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 55
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_55_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 55
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_55_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 55
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 55
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_55_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI207_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI207_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_55_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 55
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 55, i64 55>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_55_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_55_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 55
; PWR5-NEXT:    subfic r3, r3, 55
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 55
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_55_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 55
; PWR6-NEXT:    subfic r3, r3, 55
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 55
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_55_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 55
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 55
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_55_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI208_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI208_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_55_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 55
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 55, i64 55>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_56_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_56_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_56_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_56_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 56
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 56
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_56_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI209_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI209_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_56_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 56
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 56, i64 56>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_56_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_56_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 56
; PWR5-NEXT:    subfic r3, r3, 56
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 56
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_56_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 56
; PWR6-NEXT:    subfic r3, r3, 56
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 56
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_56_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 56
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 56
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_56_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI210_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI210_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_56_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 56
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 56, i64 56>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_57_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_57_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 57
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_57_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 57
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_57_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 57
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 57
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_57_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI211_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI211_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_57_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 57
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 57, i64 57>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_57_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_57_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 57
; PWR5-NEXT:    subfic r3, r3, 57
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 57
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_57_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 57
; PWR6-NEXT:    subfic r3, r3, 57
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 57
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_57_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 57
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 57
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_57_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI212_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI212_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_57_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 57
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 57, i64 57>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_58_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_58_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 58
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_58_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 58
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_58_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 58
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 58
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_58_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI213_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI213_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_58_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 58
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 58, i64 58>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_58_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_58_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 58
; PWR5-NEXT:    subfic r3, r3, 58
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 58
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_58_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 58
; PWR6-NEXT:    subfic r3, r3, 58
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 58
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_58_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 58
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 58
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_58_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI214_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI214_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_58_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 58
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 58, i64 58>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_59_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_59_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 59
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_59_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 59
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_59_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 59
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 59
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_59_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI215_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI215_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_59_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 59
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 59, i64 59>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_59_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_59_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 59
; PWR5-NEXT:    subfic r3, r3, 59
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 59
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_59_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 59
; PWR6-NEXT:    subfic r3, r3, 59
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 59
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_59_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 59
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 59
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_59_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI216_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI216_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_59_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 59
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 59, i64 59>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_60_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_60_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 60
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_60_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 60
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_60_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 60
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 60
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_60_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI217_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI217_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_60_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 60
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 60, i64 60>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_60_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_60_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 60
; PWR5-NEXT:    subfic r3, r3, 60
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 60
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_60_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 60
; PWR6-NEXT:    subfic r3, r3, 60
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 60
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_60_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 60
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 60
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_60_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI218_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI218_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_60_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 60
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 60, i64 60>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_61_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_61_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 61
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_61_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 61
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_61_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 61
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 61
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_61_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI219_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI219_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_61_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 61
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 61, i64 61>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_61_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_61_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 61
; PWR5-NEXT:    subfic r3, r3, 61
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 61
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_61_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 61
; PWR6-NEXT:    subfic r3, r3, 61
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 61
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_61_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 61
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 61
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_61_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI220_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI220_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_61_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 61
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 61, i64 61>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_62_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_62_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 62
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_62_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 62
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_62_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 62
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 62
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_62_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI221_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI221_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_62_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 62
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 62, i64 62>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ugt_62_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ugt_62_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    li r5, 62
; PWR5-NEXT:    subfic r3, r3, 62
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r5, r5
; PWR5-NEXT:    subfic r4, r4, 62
; PWR5-NEXT:    subfe r4, r5, r5
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ugt_62_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    li r5, 62
; PWR6-NEXT:    subfic r3, r3, 62
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r5, r5
; PWR6-NEXT:    subfic r4, r4, 62
; PWR6-NEXT:    subfe r4, r5, r5
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ugt_62_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 62
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    iselgt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 62
; PWR7-NEXT:    iselgt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ugt_62_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI222_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI222_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v2, v3
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ugt_62_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 62
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v2, v3
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ugt <2 x i64> %2, <i64 62, i64 62>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @ult_63_v2i64(<2 x i64> %0) {
; PWR5-LABEL: ult_63_v2i64:
; PWR5:       # %bb.0:
; PWR5-NEXT:    lis r5, 21845
; PWR5-NEXT:    lis r6, 13107
; PWR5-NEXT:    ori r5, r5, 21845
; PWR5-NEXT:    rotldi r8, r4, 63
; PWR5-NEXT:    rotldi r9, r3, 63
; PWR5-NEXT:    rldimi r5, r5, 32, 0
; PWR5-NEXT:    and r8, r8, r5
; PWR5-NEXT:    and r5, r9, r5
; PWR5-NEXT:    ori r6, r6, 13107
; PWR5-NEXT:    sub r3, r3, r5
; PWR5-NEXT:    rldimi r6, r6, 32, 0
; PWR5-NEXT:    sub r4, r4, r8
; PWR5-NEXT:    and r8, r3, r6
; PWR5-NEXT:    rotldi r3, r3, 62
; PWR5-NEXT:    and r3, r3, r6
; PWR5-NEXT:    lis r7, 3855
; PWR5-NEXT:    and r5, r4, r6
; PWR5-NEXT:    rotldi r4, r4, 62
; PWR5-NEXT:    add r3, r8, r3
; PWR5-NEXT:    lis r9, 257
; PWR5-NEXT:    ori r7, r7, 3855
; PWR5-NEXT:    and r4, r4, r6
; PWR5-NEXT:    rldicl r6, r3, 60, 4
; PWR5-NEXT:    ori r9, r9, 257
; PWR5-NEXT:    rldimi r7, r7, 32, 0
; PWR5-NEXT:    add r4, r5, r4
; PWR5-NEXT:    add r3, r3, r6
; PWR5-NEXT:    rldimi r9, r9, 32, 0
; PWR5-NEXT:    rldicl r5, r4, 60, 4
; PWR5-NEXT:    and r3, r3, r7
; PWR5-NEXT:    add r4, r4, r5
; PWR5-NEXT:    mulld r3, r3, r9
; PWR5-NEXT:    and r4, r4, r7
; PWR5-NEXT:    rldicl r3, r3, 8, 56
; PWR5-NEXT:    li r5, 63
; PWR5-NEXT:    mulld r4, r4, r9
; PWR5-NEXT:    subc r6, r3, r5
; PWR5-NEXT:    rldicl r4, r4, 8, 56
; PWR5-NEXT:    subfe r3, r3, r3
; PWR5-NEXT:    subc r5, r4, r5
; PWR5-NEXT:    subfe r4, r4, r4
; PWR5-NEXT:    blr
;
; PWR6-LABEL: ult_63_v2i64:
; PWR6:       # %bb.0:
; PWR6-NEXT:    lis r5, 21845
; PWR6-NEXT:    lis r6, 13107
; PWR6-NEXT:    ori r5, r5, 21845
; PWR6-NEXT:    rotldi r8, r4, 63
; PWR6-NEXT:    rotldi r9, r3, 63
; PWR6-NEXT:    rldimi r5, r5, 32, 0
; PWR6-NEXT:    and r8, r8, r5
; PWR6-NEXT:    and r5, r9, r5
; PWR6-NEXT:    ori r6, r6, 13107
; PWR6-NEXT:    sub r3, r3, r5
; PWR6-NEXT:    rldimi r6, r6, 32, 0
; PWR6-NEXT:    sub r4, r4, r8
; PWR6-NEXT:    and r8, r3, r6
; PWR6-NEXT:    rotldi r3, r3, 62
; PWR6-NEXT:    and r3, r3, r6
; PWR6-NEXT:    lis r7, 3855
; PWR6-NEXT:    and r5, r4, r6
; PWR6-NEXT:    rotldi r4, r4, 62
; PWR6-NEXT:    add r3, r8, r3
; PWR6-NEXT:    lis r9, 257
; PWR6-NEXT:    ori r7, r7, 3855
; PWR6-NEXT:    and r4, r4, r6
; PWR6-NEXT:    rldicl r6, r3, 60, 4
; PWR6-NEXT:    ori r9, r9, 257
; PWR6-NEXT:    rldimi r7, r7, 32, 0
; PWR6-NEXT:    add r4, r5, r4
; PWR6-NEXT:    add r3, r3, r6
; PWR6-NEXT:    rldimi r9, r9, 32, 0
; PWR6-NEXT:    rldicl r5, r4, 60, 4
; PWR6-NEXT:    and r3, r3, r7
; PWR6-NEXT:    add r4, r4, r5
; PWR6-NEXT:    mulld r3, r3, r9
; PWR6-NEXT:    and r4, r4, r7
; PWR6-NEXT:    rldicl r3, r3, 8, 56
; PWR6-NEXT:    li r5, 63
; PWR6-NEXT:    mulld r4, r4, r9
; PWR6-NEXT:    subc r6, r3, r5
; PWR6-NEXT:    rldicl r4, r4, 8, 56
; PWR6-NEXT:    subfe r3, r3, r3
; PWR6-NEXT:    subc r5, r4, r5
; PWR6-NEXT:    subfe r4, r4, r4
; PWR6-NEXT:    blr
;
; PWR7-LABEL: ult_63_v2i64:
; PWR7:       # %bb.0:
; PWR7-NEXT:    addi r3, r1, -32
; PWR7-NEXT:    li r5, -1
; PWR7-NEXT:    stxvd2x v2, 0, r3
; PWR7-NEXT:    ld r4, -24(r1)
; PWR7-NEXT:    ld r3, -32(r1)
; PWR7-NEXT:    popcntd r4, r4
; PWR7-NEXT:    popcntd r3, r3
; PWR7-NEXT:    cmpldi r4, 63
; PWR7-NEXT:    li r4, 0
; PWR7-NEXT:    isellt r6, r5, r4
; PWR7-NEXT:    cmpldi r3, 63
; PWR7-NEXT:    isellt r3, r5, r4
; PWR7-NEXT:    std r6, -8(r1)
; PWR7-NEXT:    std r3, -16(r1)
; PWR7-NEXT:    addi r3, r1, -16
; PWR7-NEXT:    lxvd2x v2, 0, r3
; PWR7-NEXT:    blr
;
; PWR8-LABEL: ult_63_v2i64:
; PWR8:       # %bb.0:
; PWR8-NEXT:    addis r3, r2, .LCPI223_0@toc@ha
; PWR8-NEXT:    vpopcntd v2, v2
; PWR8-NEXT:    addi r3, r3, .LCPI223_0@toc@l
; PWR8-NEXT:    lxvd2x v3, 0, r3
; PWR8-NEXT:    vcmpgtud v2, v3, v2
; PWR8-NEXT:    blr
;
; PWR9-LABEL: ult_63_v2i64:
; PWR9:       # %bb.0:
; PWR9-NEXT:    xxspltib v3, 63
; PWR9-NEXT:    vpopcntd v2, v2
; PWR9-NEXT:    vextsb2d v3, v3
; PWR9-NEXT:    vcmpgtud v2, v3, v2
; PWR9-NEXT:    blr
  %2 = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %0)
  %3 = icmp ult <2 x i64> %2, <i64 63, i64 63>
  %4 = sext <2 x i1> %3 to <2 x i64>
  ret <2 x i64> %4
}

declare <16 x i8> @llvm.ctpop.v16i8(<16 x i8>)
declare <8 x i16> @llvm.ctpop.v8i16(<8 x i16>)
declare <4 x i32> @llvm.ctpop.v4i32(<4 x i32>)
declare <2 x i64> @llvm.ctpop.v2i64(<2 x i64>)
