; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=mips64 -relocation-model=static -mattr=+noabicalls \
; RUN:  -verify-machineinstrs < %s | FileCheck %s

declare i64 @llvm.read_register.i64(metadata)

define i64 @get_zero() {
; CHECK-LABEL: get_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $zero
  %1 = call i64 @llvm.read_register.i64(metadata !0)
  ret i64 %1
}

define i64 @get_at() {
; CHECK-LABEL: get_at:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $1, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $1
  call void @llvm.write_register.i64(metadata !{!"$1"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !1)
  ret i64 %1
}

define i64 @get_v0() {
; CHECK-LABEL: get_v0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
  call void @llvm.write_register.i64(metadata !{!"$2"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !2)
  ret i64 %1
}

define i64 @get_v1() {
; CHECK-LABEL: get_v1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $3, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $3
  call void @llvm.write_register.i64(metadata !{!"$3"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !3)
  ret i64 %1
}

define i64 @get_a0() {
; CHECK-LABEL: get_a0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $4, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $4
  call void @llvm.write_register.i64(metadata !{!"$4"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !4)
  ret i64 %1
}

define i64 @get_a1() {
; CHECK-LABEL: get_a1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $5, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $5
  call void @llvm.write_register.i64(metadata !{!"$5"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !5)
  ret i64 %1
}

define i64 @get_a2() {
; CHECK-LABEL: get_a2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $6, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $6
  call void @llvm.write_register.i64(metadata !{!"$6"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !6)
  ret i64 %1
}

define i64 @get_a3() {
; CHECK-LABEL: get_a3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $7, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $7
  call void @llvm.write_register.i64(metadata !{!"$7"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !7)
  ret i64 %1
}

define i64 @get_t0() {
; CHECK-LABEL: get_t0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $12, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $12
  call void @llvm.write_register.i64(metadata !{!"$12"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !8)
  ret i64 %1
}

define i64 @get_t1() {
; CHECK-LABEL: get_t1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $13, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $13
  call void @llvm.write_register.i64(metadata !{!"$13"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !9)
  ret i64 %1
}

define i64 @get_t2() {
; CHECK-LABEL: get_t2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $14, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $14
  call void @llvm.write_register.i64(metadata !{!"$14"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !10)
  ret i64 %1
}

define i64 @get_t3() {
; CHECK-LABEL: get_t3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $15, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $15
  call void @llvm.write_register.i64(metadata !{!"$15"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !11)
  ret i64 %1
}

define i64 @get_t4() {
; CHECK-LABEL: get_t4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $12, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $12
  call void @llvm.write_register.i64(metadata !{!"$12"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !12)
  ret i64 %1
}

define i64 @get_t5() {
; CHECK-LABEL: get_t5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $13, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $13
  call void @llvm.write_register.i64(metadata !{!"$13"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !13)
  ret i64 %1
}

define i64 @get_t6() {
; CHECK-LABEL: get_t6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $14, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $14
  call void @llvm.write_register.i64(metadata !{!"$14"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !14)
  ret i64 %1
}

define i64 @get_t7() {
; CHECK-LABEL: get_t7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $15, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $15
  call void @llvm.write_register.i64(metadata !{!"$15"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !15)
  ret i64 %1
}

define i64 @get_s0() {
; CHECK-LABEL: get_s0:
; CHECK:       # %bb.0:
; CHECK:         addiu $16, $zero, 0
; CHECK-NEXT:    move $2, $16
  call void @llvm.write_register.i64(metadata !{!"$16"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !16)
  ret i64 %1
}

define i64 @get_s1() {
; CHECK-LABEL: get_s1:
; CHECK:       # %bb.0:
; CHECK:         addiu $17, $zero, 0
; CHECK-NEXT:    move $2, $17
  call void @llvm.write_register.i64(metadata !{!"$17"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !17)
  ret i64 %1
}

define i64 @get_s2() {
; CHECK-LABEL: get_s2:
; CHECK:       # %bb.0:
; CHECK:         addiu $18, $zero, 0
; CHECK-NEXT:    move $2, $18
  call void @llvm.write_register.i64(metadata !{!"$18"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !18)
  ret i64 %1
}

define i64 @get_s3() {
; CHECK-LABEL: get_s3:
; CHECK:       # %bb.0:
; CHECK:         addiu $19, $zero, 0
; CHECK-NEXT:    move $2, $19
  call void @llvm.write_register.i64(metadata !{!"$19"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !19)
  ret i64 %1
}

define i64 @get_s4() {
; CHECK-LABEL: get_s4:
; CHECK:       # %bb.0:
; CHECK:         addiu $20, $zero, 0
; CHECK-NEXT:    move $2, $20
  call void @llvm.write_register.i64(metadata !{!"$20"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !20)
  ret i64 %1
}

define i64 @get_s5() {
; CHECK-LABEL: get_s5:
; CHECK:       # %bb.0:
; CHECK:         addiu $21, $zero, 0
; CHECK-NEXT:    move $2, $21
  call void @llvm.write_register.i64(metadata !{!"$21"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !21)
  ret i64 %1
}

define i64 @get_s6() {
; CHECK-LABEL: get_s6:
; CHECK:       # %bb.0:
; CHECK:         addiu $22, $zero, 0
; CHECK-NEXT:    move $2, $22
  call void @llvm.write_register.i64(metadata !{!"$22"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !22)
  ret i64 %1
}

define i64 @get_s7() {
; CHECK-LABEL: get_s7:
; CHECK:       # %bb.0:
; CHECK:         addiu $23, $zero, 0
; CHECK-NEXT:    move $2, $23
  call void @llvm.write_register.i64(metadata !{!"$23"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !23)
  ret i64 %1
}

define i64 @get_t8() {
; CHECK-LABEL: get_t8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $24, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $24
  call void @llvm.write_register.i64(metadata !{!"$24"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !24)
  ret i64 %1
}

define i64 @get_t9() {
; CHECK-LABEL: get_t9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiu $25, $zero, 0
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $25
  call void @llvm.write_register.i64(metadata !{!"$25"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !25)
  ret i64 %1
}

define i64 @get_k0() {
; CHECK-LABEL: get_k0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $26
  %1 = call i64 @llvm.read_register.i64(metadata !26)
  ret i64 %1
}

define i64 @get_k1() {
; CHECK-LABEL: get_k1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $27
  %1 = call i64 @llvm.read_register.i64(metadata !27)
  ret i64 %1
}

define i64 @get_$gp() {
; CHECK-LABEL: get_$gp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $gp
  %1 = call i64 @llvm.read_register.i64(metadata !28)
  ret i64 %1
}

define i64 @get_sp() {
; CHECK-LABEL: get_sp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $sp
  %1 = call i64 @llvm.read_register.i64(metadata !29)
  ret i64 %1
}

define i64 @get_fp() {
; CHECK-LABEL: get_fp:
; CHECK:       # %bb.0:
; CHECK:         addiu $fp, $zero, 0
; CHECK-NEXT:    move $2, $fp
  call void @llvm.write_register.i64(metadata !{!"$30"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !30)
  ret i64 %1
}

define i64 @get_ra() {
; CHECK-LABEL: get_ra:
; CHECK:       # %bb.0:
; CHECK:         addiu $ra, $zero, 0
; CHECK-NEXT:    move $2, $ra
  call void @llvm.write_register.i64(metadata !{!"$31"}, i64 0)
  %1 = call i64 @llvm.read_register.i64(metadata !31)
  ret i64 %1
}

!llvm.named.register = !{!0, !1, !2, !3, !4, !5, !6, !7, !8, !9, !10, !11, !12, !13, !14, !15, !16, !17, !18, !19, !20, !21, !22, !23, !24, !25, !26, !27, !28, !29, !30, !31}

!0 = !{!"$zero"}
!1 = !{!"$at"}
!2 = !{!"$v0"}
!3 = !{!"$v1"}
!4 = !{!"$a0"}
!5 = !{!"$a1"}
!6 = !{!"$a2"}
!7 = !{!"$a3"}
!8 = !{!"$t0"}
!9 = !{!"$t1"}
!10 = !{!"$t2"}
!11 = !{!"$t3"}
!12 = !{!"$t4"}
!13 = !{!"$t5"}
!14 = !{!"$t6"}
!15 = !{!"$t7"}
!16 = !{!"$s0"}
!17 = !{!"$s1"}
!18 = !{!"$s2"}
!19 = !{!"$s3"}
!20 = !{!"$s4"}
!21 = !{!"$s5"}
!22 = !{!"$s6"}
!23 = !{!"$s7"}
!24 = !{!"$t8"}
!25 = !{!"$t9"}
!26 = !{!"$k0"}
!27 = !{!"$k1"}
!28 = !{!"$gp"}
!29 = !{!"$sp"}
!30 = !{!"$fp"}
!31 = !{!"$ra"}
