//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// SQLVulnerabilityAssessmentScanResultsServer is a fake server for instances of the armsecurity.SQLVulnerabilityAssessmentScanResultsClient type.
type SQLVulnerabilityAssessmentScanResultsServer struct {
	// Get is the fake for method SQLVulnerabilityAssessmentScanResultsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scanID string, scanResultID string, workspaceID string, resourceID string, options *armsecurity.SQLVulnerabilityAssessmentScanResultsClientGetOptions) (resp azfake.Responder[armsecurity.SQLVulnerabilityAssessmentScanResultsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method SQLVulnerabilityAssessmentScanResultsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, scanID string, workspaceID string, resourceID string, options *armsecurity.SQLVulnerabilityAssessmentScanResultsClientListOptions) (resp azfake.Responder[armsecurity.SQLVulnerabilityAssessmentScanResultsClientListResponse], errResp azfake.ErrorResponder)
}

// NewSQLVulnerabilityAssessmentScanResultsServerTransport creates a new instance of SQLVulnerabilityAssessmentScanResultsServerTransport with the provided implementation.
// The returned SQLVulnerabilityAssessmentScanResultsServerTransport instance is connected to an instance of armsecurity.SQLVulnerabilityAssessmentScanResultsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLVulnerabilityAssessmentScanResultsServerTransport(srv *SQLVulnerabilityAssessmentScanResultsServer) *SQLVulnerabilityAssessmentScanResultsServerTransport {
	return &SQLVulnerabilityAssessmentScanResultsServerTransport{srv: srv}
}

// SQLVulnerabilityAssessmentScanResultsServerTransport connects instances of armsecurity.SQLVulnerabilityAssessmentScanResultsClient to instances of SQLVulnerabilityAssessmentScanResultsServer.
// Don't use this type directly, use NewSQLVulnerabilityAssessmentScanResultsServerTransport instead.
type SQLVulnerabilityAssessmentScanResultsServerTransport struct {
	srv *SQLVulnerabilityAssessmentScanResultsServer
}

// Do implements the policy.Transporter interface for SQLVulnerabilityAssessmentScanResultsServerTransport.
func (s *SQLVulnerabilityAssessmentScanResultsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLVulnerabilityAssessmentScanResultsClient.Get":
		resp, err = s.dispatchGet(req)
	case "SQLVulnerabilityAssessmentScanResultsClient.List":
		resp, err = s.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLVulnerabilityAssessmentScanResultsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/sqlVulnerabilityAssessments/default/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scanResults/(?P<scanResultId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	scanResultIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanResultId")])
	if err != nil {
		return nil, err
	}
	workspaceIDParam, err := url.QueryUnescape(qp.Get("workspaceId"))
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), scanIDParam, scanResultIDParam, workspaceIDParam, resourceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScanResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLVulnerabilityAssessmentScanResultsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if s.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/sqlVulnerabilityAssessments/default/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scanResults`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	workspaceIDParam, err := url.QueryUnescape(qp.Get("workspaceId"))
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.List(req.Context(), scanIDParam, workspaceIDParam, resourceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScanResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
