//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resourcemover/armresourcemover"
	"net/http"
)

// OperationsDiscoveryServer is a fake server for instances of the armresourcemover.OperationsDiscoveryClient type.
type OperationsDiscoveryServer struct {
	// Get is the fake for method OperationsDiscoveryClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, options *armresourcemover.OperationsDiscoveryClientGetOptions) (resp azfake.Responder[armresourcemover.OperationsDiscoveryClientGetResponse], errResp azfake.ErrorResponder)
}

// NewOperationsDiscoveryServerTransport creates a new instance of OperationsDiscoveryServerTransport with the provided implementation.
// The returned OperationsDiscoveryServerTransport instance is connected to an instance of armresourcemover.OperationsDiscoveryClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewOperationsDiscoveryServerTransport(srv *OperationsDiscoveryServer) *OperationsDiscoveryServerTransport {
	return &OperationsDiscoveryServerTransport{srv: srv}
}

// OperationsDiscoveryServerTransport connects instances of armresourcemover.OperationsDiscoveryClient to instances of OperationsDiscoveryServer.
// Don't use this type directly, use NewOperationsDiscoveryServerTransport instead.
type OperationsDiscoveryServerTransport struct {
	srv *OperationsDiscoveryServer
}

// Do implements the policy.Transporter interface for OperationsDiscoveryServerTransport.
func (o *OperationsDiscoveryServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "OperationsDiscoveryClient.Get":
		resp, err = o.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (o *OperationsDiscoveryServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if o.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	respr, errRespr := o.srv.Get(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OperationsDiscoveryCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
