//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpowerbidedicated

import "time"

// AutoScaleVCore - Represents an instance of an auto scale v-core resource.
type AutoScaleVCore struct {
	// REQUIRED; Location of the PowerBI Dedicated resource.
	Location *string

	// REQUIRED; The SKU of the auto scale v-core resource.
	SKU *AutoScaleVCoreSKU

	// Properties of an auto scale v-core resource.
	Properties *AutoScaleVCoreProperties

	// Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string

	// READ-ONLY; An identifier that represents the PowerBI Dedicated resource.
	ID *string

	// READ-ONLY; The name of the PowerBI Dedicated resource.
	Name *string

	// READ-ONLY; The type of the PowerBI Dedicated resource.
	Type *string
}

// AutoScaleVCoreListResult - An array of auto scale v-core resources.
type AutoScaleVCoreListResult struct {
	// REQUIRED; An array of auto scale v-core resources.
	Value []*AutoScaleVCore
}

// AutoScaleVCoreMutableProperties - An object that represents a set of mutable auto scale v-core resource properties.
type AutoScaleVCoreMutableProperties struct {
	// The maximum capacity of an auto scale v-core resource.
	CapacityLimit *int32
}

// AutoScaleVCoreProperties - Properties of an auto scale v-core resource.
type AutoScaleVCoreProperties struct {
	// The maximum capacity of an auto scale v-core resource.
	CapacityLimit *int32

	// The object ID of the capacity resource associated with the auto scale v-core resource.
	CapacityObjectID *string

	// READ-ONLY; The current deployment state of an auto scale v-core resource. The provisioningState is to indicate states for
	// resource provisioning.
	ProvisioningState *VCoreProvisioningState
}

// AutoScaleVCoreSKU - Represents the SKU name and Azure pricing tier for auto scale v-core resource.
type AutoScaleVCoreSKU struct {
	// REQUIRED; Name of the SKU level.
	Name *string

	// The capacity of an auto scale v-core resource.
	Capacity *int32

	// The name of the Azure pricing tier to which the SKU applies.
	Tier *VCoreSKUTier
}

// AutoScaleVCoreUpdateParameters - Update request specification
type AutoScaleVCoreUpdateParameters struct {
	// Properties of the update operation request.
	Properties *AutoScaleVCoreMutableProperties

	// The SKU of the auto scale v-core resource.
	SKU *AutoScaleVCoreSKU

	// Key-value pairs of additional provisioning properties.
	Tags map[string]*string
}

// CapacitySKU - Represents the SKU name and Azure pricing tier for PowerBI Dedicated capacity resource.
type CapacitySKU struct {
	// REQUIRED; Name of the SKU level.
	Name *string

	// The capacity of the SKU.
	Capacity *int32

	// The name of the Azure pricing tier to which the SKU applies.
	Tier *CapacitySKUTier
}

// CheckCapacityNameAvailabilityParameters - Details of capacity name request body.
type CheckCapacityNameAvailabilityParameters struct {
	// Name for checking availability.
	Name *string

	// The resource type of PowerBI dedicated.
	Type *string
}

// CheckCapacityNameAvailabilityResult - The checking result of capacity name availability.
type CheckCapacityNameAvailabilityResult struct {
	// The detailed message of the request unavailability.
	Message *string

	// Indicator of availability of the capacity name.
	NameAvailable *bool

	// The reason of unavailability.
	Reason *string
}

// DedicatedCapacities - An array of Dedicated capacities resources.
type DedicatedCapacities struct {
	// REQUIRED; An array of Dedicated capacities resources.
	Value []*DedicatedCapacity
}

// DedicatedCapacity - Represents an instance of a Dedicated Capacity resource.
type DedicatedCapacity struct {
	// REQUIRED; Location of the PowerBI Dedicated resource.
	Location *string

	// REQUIRED; The SKU of the PowerBI Dedicated capacity resource.
	SKU *CapacitySKU

	// Properties of the provision operation request.
	Properties *DedicatedCapacityProperties

	// Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string

	// READ-ONLY; An identifier that represents the PowerBI Dedicated resource.
	ID *string

	// READ-ONLY; The name of the PowerBI Dedicated resource.
	Name *string

	// READ-ONLY; The type of the PowerBI Dedicated resource.
	Type *string
}

// DedicatedCapacityAdministrators - An array of administrator user identities
type DedicatedCapacityAdministrators struct {
	// An array of administrator user identities.
	Members []*string
}

// DedicatedCapacityMutableProperties - An object that represents a set of mutable Dedicated capacity resource properties.
type DedicatedCapacityMutableProperties struct {
	// A collection of Dedicated capacity administrators
	Administration *DedicatedCapacityAdministrators

	// Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used.
	// Learn More
	// [https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2]
	Mode *Mode

	// READ-ONLY; Capacity name
	FriendlyName *string

	// READ-ONLY; Tenant ID for the capacity. Used for creating Pro Plus capacity.
	TenantID *string
}

// DedicatedCapacityProperties - Properties of Dedicated Capacity resource.
type DedicatedCapacityProperties struct {
	// A collection of Dedicated capacity administrators
	Administration *DedicatedCapacityAdministrators

	// Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used.
	// Learn More
	// [https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2]
	Mode *Mode

	// READ-ONLY; Capacity name
	FriendlyName *string

	// READ-ONLY; The current deployment state of PowerBI Dedicated resource. The provisioningState is to indicate states for
	// resource provisioning.
	ProvisioningState *CapacityProvisioningState

	// READ-ONLY; The current state of PowerBI Dedicated resource. The state is to indicate more states outside of resource provisioning.
	State *State

	// READ-ONLY; Tenant ID for the capacity. Used for creating Pro Plus capacity.
	TenantID *string
}

// DedicatedCapacityUpdateParameters - Provision request specification
type DedicatedCapacityUpdateParameters struct {
	// Properties of the provision operation request.
	Properties *DedicatedCapacityMutableProperties

	// The SKU of the Dedicated capacity resource.
	SKU *CapacitySKU

	// Key-value pairs of additional provisioning properties.
	Tags map[string]*string
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// The error object
	Error *ErrorResponseError
}

// ErrorResponseError - The error object
type ErrorResponseError struct {
	// Error code
	Code *string

	// Error message indicating why the operation failed.
	Message *string
}

// LogSpecification - Log specification for exposing diagnostic logs to shoebox.
type LogSpecification struct {
	// Localizable name of the log
	DisplayName *string

	// READ-ONLY; Blob duration for the log
	BlobDuration *string

	// READ-ONLY; Name of the log
	Name *string
}

// MetricSpecification - Metric specification for exposing performance metrics to shoebox.
type MetricSpecification struct {
	// For describing multi dimensional metrics
	Dimensions []*MetricSpecificationDimensionsItem

	// Localizable description of metric
	DisplayDescription *string

	// Localizable metric name
	DisplayName *string

	// READ-ONLY; Aggregation type for the metric
	AggregationType *string

	// READ-ONLY; Pattern used to filter the metric
	MetricFilterPattern *string

	// READ-ONLY; Metric name
	Name *string

	// READ-ONLY; Unit for the metric
	Unit *string
}

type MetricSpecificationDimensionsItem struct {
	// Localizable dimension of the metric
	DisplayName *string

	// READ-ONLY; Dimension of the metric
	Name *string
}

// Operation - Capacities REST API operation.
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Additional properties to expose performance metrics to shoebox.
	Properties *OperationProperties

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string

	// READ-ONLY; Origin of the operation.
	Origin *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Localized description of the operation.
	Description *string

	// READ-ONLY; Operation type: create, update, delete, etc.
	Operation *string

	// READ-ONLY; Service provider: Microsoft.PowerBIDedicated.
	Provider *string

	// READ-ONLY; Resource on which the operation is performed: capacity, etc.
	Resource *string
}

// OperationListResult - Result listing capacities. It contains a list of operations and a URL link to get the next set of
// results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string

	// READ-ONLY; List of capacities supported by the Microsoft.PowerBIDedicated resource provider.
	Value []*Operation
}

// OperationProperties - Additional properties to expose performance metrics to shoebox.
type OperationProperties struct {
	// Service specification for exposing performance metrics to shoebox.
	ServiceSpecification *ServiceSpecification
}

// Resource - Represents an instance of an PowerBI Dedicated resource.
type Resource struct {
	// REQUIRED; Location of the PowerBI Dedicated resource.
	Location *string

	// Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string

	// READ-ONLY; An identifier that represents the PowerBI Dedicated resource.
	ID *string

	// READ-ONLY; The name of the PowerBI Dedicated resource.
	Name *string

	// READ-ONLY; The type of the PowerBI Dedicated resource.
	Type *string
}

// SKUDetailsForExistingResource - An object that represents SKU details for existing resources
type SKUDetailsForExistingResource struct {
	// The resource type
	ResourceType *string

	// The SKU in SKU details for existing resources.
	SKU *CapacitySKU
}

// SKUEnumerationForExistingResourceResult - An object that represents enumerating SKUs for existing resources
type SKUEnumerationForExistingResourceResult struct {
	// The collection of available SKUs for existing resources
	Value []*SKUDetailsForExistingResource
}

// SKUEnumerationForNewResourceResult - An object that represents enumerating SKUs for new resources
type SKUEnumerationForNewResourceResult struct {
	// The collection of available SKUs for new resources
	Value []*CapacitySKU
}

// ServiceSpecification - Service specification for exposing performance metrics to shoebox.
type ServiceSpecification struct {
	// Log specifications for exposing diagnostic logs to shoebox.
	LogSpecifications []*LogSpecification

	// Metric specifications for exposing performance metrics to shoebox.
	MetricSpecifications []*MetricSpecification
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC)
	CreatedAt *time.Time

	// An identifier for the identity that created the resource
	CreatedBy *string

	// The type of identity that created the resource
	CreatedByType *IdentityType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// An identifier for the identity that last modified the resource
	LastModifiedBy *string

	// The type of identity that last modified the resource
	LastModifiedByType *IdentityType
}
