//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpostgresqlflexibleservers

import "time"

// ActiveDirectoryAdministrator - Represents an Active Directory administrator.
type ActiveDirectoryAdministrator struct {
	// REQUIRED; Properties of the active directory administrator.
	Properties *AdministratorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ActiveDirectoryAdministratorAdd - Represents an Active Directory administrator.
type ActiveDirectoryAdministratorAdd struct {
	// Properties of the active directory administrator.
	Properties *AdministratorPropertiesForAdd
}

// AdminCredentials - Server admin credentials.
type AdminCredentials struct {
	// REQUIRED; Password for source server.
	SourceServerPassword *string

	// REQUIRED; Password for target server.
	TargetServerPassword *string
}

// AdministratorListResult - A list of active directory administrators.
type AdministratorListResult struct {
	// The link used to get the next page of active directory.
	NextLink *string

	// The list of active directory administrators
	Value []*ActiveDirectoryAdministrator
}

// AdministratorProperties - The properties of an Active Directory administrator.
type AdministratorProperties struct {
	// The objectId of the Active Directory administrator.
	ObjectID *string

	// Active Directory administrator principal name.
	PrincipalName *string

	// The principal type used to represent the type of Active Directory Administrator.
	PrincipalType *PrincipalType

	// The tenantId of the Active Directory administrator.
	TenantID *string
}

// AdministratorPropertiesForAdd - The properties of an Active Directory administrator.
type AdministratorPropertiesForAdd struct {
	// Active Directory administrator principal name.
	PrincipalName *string

	// The principal type used to represent the type of Active Directory Administrator.
	PrincipalType *PrincipalType

	// The tenantId of the Active Directory administrator.
	TenantID *string
}

// AuthConfig - Authentication configuration properties of a server
type AuthConfig struct {
	// If Enabled, Azure Active Directory authentication is enabled.
	ActiveDirectoryAuth *ActiveDirectoryAuthEnum

	// If Enabled, Password authentication is enabled.
	PasswordAuth *PasswordAuthEnum

	// Tenant id of the server.
	TenantID *string
}

// Backup properties of a server
type Backup struct {
	// Backup retention days for the server.
	BackupRetentionDays *int32

	// A value indicating whether Geo-Redundant backup is enabled on the server.
	GeoRedundantBackup *GeoRedundantBackupEnum

	// READ-ONLY; The earliest restore point time (ISO8601 format) for server.
	EarliestRestoreDate *time.Time
}

// BackupSettings - The settings for the long term backup.
type BackupSettings struct {
	// REQUIRED; Backup Name for the current backup
	BackupName *string
}

// BackupStoreDetails - Details about the target where the backup content will be stored.
type BackupStoreDetails struct {
	// REQUIRED; List of SAS uri of storage containers where backup data is to be streamed/copied.
	SasURIList []*string
}

// CapabilitiesListResult - Capability for the PostgreSQL server
type CapabilitiesListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; A list of supported capabilities.
	Value []*FlexibleServerCapability
}

// CheckNameAvailabilityRequest - The check availability request body.
type CheckNameAvailabilityRequest struct {
	// The name of the resource for which availability needs to be checked.
	Name *string

	// The resource type.
	Type *string
}

// Configuration - Represents a Configuration.
type Configuration struct {
	// The properties of a configuration.
	Properties *ConfigurationProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ConfigurationForUpdate - Represents a Configuration.
type ConfigurationForUpdate struct {
	// The properties of a configuration.
	Properties *ConfigurationProperties
}

// ConfigurationListResult - A list of server configurations.
type ConfigurationListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of server configurations.
	Value []*Configuration
}

// ConfigurationProperties - The properties of a configuration.
type ConfigurationProperties struct {
	// Source of the configuration.
	Source *string

	// Value of the configuration.
	Value *string

	// READ-ONLY; Allowed values of the configuration.
	AllowedValues *string

	// READ-ONLY; Data type of the configuration.
	DataType *ConfigurationDataType

	// READ-ONLY; Default value of the configuration.
	DefaultValue *string

	// READ-ONLY; Description of the configuration.
	Description *string

	// READ-ONLY; Configuration documentation link.
	DocumentationLink *string

	// READ-ONLY; Configuration is pending restart or not.
	IsConfigPendingRestart *bool

	// READ-ONLY; Configuration dynamic or static.
	IsDynamicConfig *bool

	// READ-ONLY; Configuration read-only or not.
	IsReadOnly *bool

	// READ-ONLY; Configuration unit.
	Unit *string
}

// DataEncryption - Data encryption properties of a server
type DataEncryption struct {
	// Geo-backup encryption key status for Data encryption enabled server.
	GeoBackupEncryptionKeyStatus *KeyStatusEnum

	// URI for the key in keyvault for data encryption for geo-backup of server.
	GeoBackupKeyURI *string

	// Resource Id for the User assigned identity to be used for data encryption for geo-backup of server.
	GeoBackupUserAssignedIdentityID *string

	// Primary encryption key status for Data encryption enabled server.
	PrimaryEncryptionKeyStatus *KeyStatusEnum

	// URI for the key in keyvault for data encryption of the primary server.
	PrimaryKeyURI *string

	// Resource Id for the User assigned identity to be used for data encryption of the primary server.
	PrimaryUserAssignedIdentityID *string

	// Data encryption type to depict if it is System Managed vs Azure Key vault.
	Type *ArmServerKeyType
}

// Database - Represents a Database.
type Database struct {
	// The properties of a database.
	Properties *DatabaseProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DatabaseListResult - A List of databases.
type DatabaseListResult struct {
	// The link used to get the next page of databases.
	NextLink *string

	// The list of databases housed in a server
	Value []*Database
}

// DatabaseProperties - The properties of a database.
type DatabaseProperties struct {
	// The charset of the database.
	Charset *string

	// The collation of the database.
	Collation *string
}

// DbLevelValidationStatus - Validation status summary for an individual database
type DbLevelValidationStatus struct {
	// Name of the database
	DatabaseName *string

	// End date-time of a database level validation
	EndedOn *time.Time

	// Start date-time of a database level validation
	StartedOn *time.Time

	// Summary of database level validations
	Summary []*ValidationSummaryItem
}

// DbMigrationStatus - Migration status of an individual database
type DbMigrationStatus struct {
	// CDC applied changes counter
	AppliedChanges *int32

	// CDC delete counter
	CdcDeleteCounter *int32

	// CDC insert counter
	CdcInsertCounter *int32

	// CDC update counter
	CdcUpdateCounter *int32

	// Name of the database
	DatabaseName *string

	// End date-time of a migration state
	EndedOn *time.Time

	// Number of tables loaded during the migration of a DB
	FullLoadCompletedTables *int32

	// Number of tables errored out during the migration of a DB
	FullLoadErroredTables *int32

	// Number of tables loading during the migration of a DB
	FullLoadLoadingTables *int32

	// Number of tables queued for the migration of a DB
	FullLoadQueuedTables *int32

	// CDC incoming changes counter
	IncomingChanges *int32

	// Lag in seconds between source and target during online phase
	Latency *int32

	// Error message, if any, for the migration state
	Message *string

	// Migration operation of an individual database
	MigrationOperation *string

	// Migration db state of an individual database
	MigrationState *MigrationDbState

	// Start date-time of a migration state
	StartedOn *time.Time
}

// DbServerMetadata - Database server metadata.
type DbServerMetadata struct {
	// SKU for the database server. This object is empty for PG single server
	SKU *ServerSKU

	// Storage size in MB for database server
	StorageMb *int32

	// Version for database engine
	Version *string

	// READ-ONLY; Location of database server
	Location *string
}

// DelegatedSubnetUsage - Delegated subnet usage data.
type DelegatedSubnetUsage struct {
	// READ-ONLY; Name of the delegated subnet for which IP addresses are in use
	SubnetName *string

	// READ-ONLY; Number of IP addresses used by the delegated subnet
	Usage *int64
}

// FastProvisioningEditionCapability - Represents capability of a fast provisioning edition
type FastProvisioningEditionCapability struct {
	// READ-ONLY; The reason for the capability not being available.
	Reason *string

	// READ-ONLY; Count of servers in cache matching the spec
	ServerCount *int32

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus

	// READ-ONLY; Fast provisioning supported sku name
	SupportedSKU *string

	// READ-ONLY; Fast provisioning supported version
	SupportedServerVersions *string

	// READ-ONLY; Fast provisioning supported storage in Gb
	SupportedStorageGb *int32

	// READ-ONLY; Fast provisioning supported tier name
	SupportedTier *string
}

// FirewallRule - Represents a server firewall rule.
type FirewallRule struct {
	// REQUIRED; The properties of a firewall rule.
	Properties *FirewallRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FirewallRuleListResult - A list of firewall rules.
type FirewallRuleListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of firewall rules in a server.
	Value []*FirewallRule
}

// FirewallRuleProperties - The properties of a server firewall rule.
type FirewallRuleProperties struct {
	// REQUIRED; The end IP address of the server firewall rule. Must be IPv4 format.
	EndIPAddress *string

	// REQUIRED; The start IP address of the server firewall rule. Must be IPv4 format.
	StartIPAddress *string
}

// FlexibleServerCapability - Capability for the PostgreSQL server
type FlexibleServerCapability struct {
	// Name of flexible servers capability
	Name *string

	// READ-ONLY; Gets a value indicating whether fast provisioning is supported. "Enabled" means fast provisioning is supported.
	// "Disabled" stands for fast provisioning is not supported.
	FastProvisioningSupported *FastProvisioningSupportedEnum

	// READ-ONLY; Determines if geo-backup is supported in this region. "Enabled" means geo-backup is supported. "Disabled" stands
	// for geo-back is not supported.
	GeoBackupSupported *GeoBackupSupportedEnum

	// READ-ONLY; A value indicating whether online resize is supported in this region for the given subscription. "Enabled" means
	// storage online resize is supported. "Disabled" means storage online resize is not
	// supported.
	OnlineResizeSupported *OnlineResizeSupportedEnum

	// READ-ONLY; The reason for the capability not being available.
	Reason *string

	// READ-ONLY; A value indicating whether this region is restricted. "Enabled" means region is restricted. "Disabled" stands
	// for region is not restricted.
	Restricted *RestrictedEnum

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus

	// READ-ONLY; A value indicating whether storage auto-grow is supported in this region. "Enabled" means storage auto-grow
	// is supported. "Disabled" stands for storage auto-grow is not supported.
	StorageAutoGrowthSupported *StorageAutoGrowthSupportedEnum

	// READ-ONLY; List of supported server editions for fast provisioning
	SupportedFastProvisioningEditions []*FastProvisioningEditionCapability

	// READ-ONLY; List of supported flexible server editions
	SupportedServerEditions []*FlexibleServerEditionCapability

	// READ-ONLY; The list of server versions supported for this capability.
	SupportedServerVersions []*ServerVersionCapability

	// READ-ONLY; A value indicating whether Zone Redundant HA and Geo-backup is supported in this region. "Enabled" means zone
	// redundant HA and geo-backup is supported. "Disabled" stands for zone redundant HA and
	// geo-backup is not supported.
	ZoneRedundantHaAndGeoBackupSupported *ZoneRedundantHaAndGeoBackupSupportedEnum

	// READ-ONLY; A value indicating whether Zone Redundant HA is supported in this region. "Enabled" means zone redundant HA
	// is supported. "Disabled" stands for zone redundant HA is not supported.
	ZoneRedundantHaSupported *ZoneRedundantHaSupportedEnum
}

// FlexibleServerEditionCapability - Flexible server edition capabilities.
type FlexibleServerEditionCapability struct {
	// READ-ONLY; Default sku name for the server edition
	DefaultSKUName *string

	// READ-ONLY; Server edition name
	Name *string

	// READ-ONLY; The reason for the capability not being available.
	Reason *string

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus

	// READ-ONLY; List of supported server SKUs.
	SupportedServerSKUs []*ServerSKUCapability

	// READ-ONLY; The list of editions supported by this server edition.
	SupportedStorageEditions []*StorageEditionCapability
}

// HighAvailability - High availability properties of a server
type HighAvailability struct {
	// The HA mode for the server.
	Mode *HighAvailabilityMode

	// availability zone information of the standby.
	StandbyAvailabilityZone *string

	// READ-ONLY; A state of a HA server that is visible to user.
	State *ServerHAState
}

// LogFile - Represents a logFile.
type LogFile struct {
	// The properties of a logFile.
	Properties *LogFileProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LogFileListResult - A List of logFiles.
type LogFileListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of logFiles in a server
	Value []*LogFile
}

// LogFileProperties - The properties of a logFile.
type LogFileProperties struct {
	// Creation timestamp of the log file.
	CreatedTime *time.Time

	// Last modified timestamp of the log file.
	LastModifiedTime *time.Time

	// The size in kb of the logFile.
	SizeInKb *int64

	// Type of the log file.
	Type *string

	// The url to download the log file from.
	URL *string
}

// LtrBackupOperationResponseProperties - Response for the backup request.
type LtrBackupOperationResponseProperties struct {
	// REQUIRED; Start time of the operation.
	StartTime *time.Time

	// REQUIRED; Service-set extensible enum indicating the status of operation
	Status *ExecutionStatus

	// Metadata to be stored in RP. Store everything that will be required to perform a successful restore using this Recovery
	// point. e.g. Versions, DataFormat etc
	BackupMetadata *string

	// Name of Backup operation
	BackupName *string

	// Data transferred in bytes
	DataTransferredInBytes *int64

	// Size of datasource in bytes
	DatasourceSizeInBytes *int64

	// End time of the operation.
	EndTime *time.Time

	// PercentageCompleted
	PercentComplete *float64

	// READ-ONLY; The error code.
	ErrorCode *string

	// READ-ONLY; The error message.
	ErrorMessage *string
}

// LtrBackupRequest - The request that is made for a long term retention backup.
type LtrBackupRequest struct {
	// REQUIRED; Backup Settings
	BackupSettings *BackupSettings

	// REQUIRED; Backup store detail for target server
	TargetDetails *BackupStoreDetails
}

// LtrBackupResponse - Response for the LTR backup API call
type LtrBackupResponse struct {
	// Long Term Retention Backup Operation Resource Properties
	Properties *LtrBackupOperationResponseProperties
}

// LtrPreBackupRequest - A request that is made for pre-backup.
type LtrPreBackupRequest struct {
	// REQUIRED; Backup Settings
	BackupSettings *BackupSettings
}

// LtrPreBackupResponse - Response for the LTR pre-backup API call
type LtrPreBackupResponse struct {
	// REQUIRED; Additional Properties for the pre backup response
	Properties *LtrPreBackupResponseProperties
}

// LtrPreBackupResponseProperties - Response for the pre-backup request.
type LtrPreBackupResponseProperties struct {
	// REQUIRED; Number of storage containers the plugin will use during backup. More than one containers may be used for size
	// limitations, parallelism, or redundancy etc.
	NumberOfContainers *int32
}

// LtrServerBackupOperation - Response for the LTR backup Operation API call
type LtrServerBackupOperation struct {
	// Long Term Retention Backup Operation Resource Properties
	Properties *LtrBackupOperationResponseProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LtrServerBackupOperationList - A list of long term retention backup operations for server.
type LtrServerBackupOperationList struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of long term retention server backup operations
	Value []*LtrServerBackupOperation
}

// MaintenanceWindow - Maintenance window properties of a server.
type MaintenanceWindow struct {
	// indicates whether custom window is enabled or disabled
	CustomWindow *string

	// day of week for maintenance window
	DayOfWeek *int32

	// start hour for maintenance window
	StartHour *int32

	// start minute for maintenance window
	StartMinute *int32
}

// MigrationNameAvailabilityResource - Represents a migration name's availability.
type MigrationNameAvailabilityResource struct {
	// REQUIRED; The resource name to verify.
	Name *string

	// REQUIRED; The type of the resource.
	Type *string

	// READ-ONLY; Migration name availability message.
	Message *string

	// READ-ONLY; Indicates whether the resource name is available.
	NameAvailable *bool

	// READ-ONLY; Migration name availability reason
	Reason *MigrationNameAvailabilityReason
}

// MigrationResource - Represents a migration resource.
type MigrationResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Migration resource properties.
	Properties *MigrationResourceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MigrationResourceForPatch - Represents a migration resource for patch.
type MigrationResourceForPatch struct {
	// Migration resource properties.
	Properties *MigrationResourcePropertiesForPatch

	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string
}

// MigrationResourceListResult - A list of migration resources.
type MigrationResourceListResult struct {
	// READ-ONLY; The link used to get the next page of migrations.
	NextLink *string

	// READ-ONLY; A list of migration resources.
	Value []*MigrationResource
}

// MigrationResourceProperties - Migration resource properties.
type MigrationResourceProperties struct {
	// To trigger cancel for entire migration we need to send this flag as True
	Cancel *CancelEnum

	// When you want to trigger cancel for specific databases send cancel flag as True and database names in this array
	DbsToCancelMigrationOn []*string

	// Number of databases to migrate
	DbsToMigrate []*string

	// When you want to trigger cutover for specific databases send triggerCutover flag as True and database names in this array
	DbsToTriggerCutoverOn []*string

	// There are two types of migration modes Online and Offline
	MigrationMode *MigrationMode

	// This indicates the supported Migration option for the migration
	MigrationOption *MigrationOption

	// End time in UTC for migration window
	MigrationWindowEndTimeInUTC *time.Time

	// Start time in UTC for migration window
	MigrationWindowStartTimeInUTC *time.Time

	// Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the migration
	// workflow will wait for a confirmation, if it detects that the database
	// already exists.
	OverwriteDbsInTarget *OverwriteDbsInTargetEnum

	// SSL modes for migration. Default SSL mode for PostgreSQLSingleServer is VerifyFull and Prefer for other source types
	SSLMode *SSLMode

	// Migration secret parameters
	SecretParameters *MigrationSecretParameters

	// Indicates whether to setup LogicalReplicationOnSourceDb, if needed
	SetupLogicalReplicationOnSourceDbIfNeeded *LogicalReplicationOnSourceDbEnum

	// Source server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it
	// for connection
	SourceDbServerFullyQualifiedDomainName *string

	// ResourceId of the source database server in case the sourceType is PostgreSQLSingleServer. For other source types this
	// should be ipaddress:port@username or hostname:port@username
	SourceDbServerResourceID *string

	// migration source server type : OnPremises, AWS, GCP, AzureVM or PostgreSQLSingleServer
	SourceType *SourceType

	// Indicates whether the data migration should start right away
	StartDataMigration *StartDataMigrationEnum

	// Target server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it
	// for connection
	TargetDbServerFullyQualifiedDomainName *string

	// To trigger cutover for entire migration we need to send this flag as True
	TriggerCutover *TriggerCutoverEnum

	// READ-ONLY; Current status of migration
	CurrentStatus *MigrationStatus

	// READ-ONLY; ID for migration, a GUID.
	MigrationID *string

	// READ-ONLY; Metadata of the source database server
	SourceDbServerMetadata *DbServerMetadata

	// READ-ONLY; Metadata of the target database server
	TargetDbServerMetadata *DbServerMetadata

	// READ-ONLY; ResourceId of the source database server
	TargetDbServerResourceID *string
}

// MigrationResourcePropertiesForPatch - Migration resource properties for patch.
type MigrationResourcePropertiesForPatch struct {
	// To trigger cancel for entire migration we need to send this flag as True
	Cancel *CancelEnum

	// When you want to trigger cancel for specific databases send cancel flag as True and database names in this array
	DbsToCancelMigrationOn []*string

	// Number of databases to migrate
	DbsToMigrate []*string

	// When you want to trigger cutover for specific databases send triggerCutover flag as True and database names in this array
	DbsToTriggerCutoverOn []*string

	// There are two types of migration modes Online and Offline
	MigrationMode *MigrationMode

	// Start time in UTC for migration window
	MigrationWindowStartTimeInUTC *time.Time

	// Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the migration
	// workflow will wait for a confirmation, if it detects that the database
	// already exists.
	OverwriteDbsInTarget *OverwriteDbsInTargetEnum

	// Migration secret parameters
	SecretParameters *MigrationSecretParameters

	// Indicates whether to setup LogicalReplicationOnSourceDb, if needed
	SetupLogicalReplicationOnSourceDbIfNeeded *LogicalReplicationOnSourceDbEnum

	// Source server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it
	// for connection
	SourceDbServerFullyQualifiedDomainName *string

	// ResourceId of the source database server
	SourceDbServerResourceID *string

	// Indicates whether the data migration should start right away
	StartDataMigration *StartDataMigrationEnum

	// Target server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it
	// for connection
	TargetDbServerFullyQualifiedDomainName *string

	// To trigger cutover for entire migration we need to send this flag as True
	TriggerCutover *TriggerCutoverEnum
}

// MigrationSecretParameters - Migration secret parameters.
type MigrationSecretParameters struct {
	// REQUIRED; Admin credentials for source and target servers
	AdminCredentials *AdminCredentials

	// Gets or sets the username for the source server. This user need not be an admin.
	SourceServerUsername *string

	// Gets or sets the username for the target server. This user need not be an admin.
	TargetServerUsername *string
}

// MigrationStatus - Migration status.
type MigrationStatus struct {
	// READ-ONLY; Current Migration sub state details.
	CurrentSubStateDetails *MigrationSubStateDetails

	// READ-ONLY; Error message, if any, for the migration state
	Error *string

	// READ-ONLY; State of migration
	State *MigrationState
}

// MigrationSubStateDetails - Migration sub state details.
type MigrationSubStateDetails struct {
	// Dictionary of
	DbDetails map[string]*DbMigrationStatus

	// Details for the validation for migration
	ValidationDetails *ValidationDetails

	// READ-ONLY; Migration sub state.
	CurrentSubState *MigrationSubState
}

// NameAvailability - Represents a resource name availability.
type NameAvailability struct {
	// Detailed reason why the given name is available.
	Message *string

	// Indicates if the resource name is available.
	NameAvailable *bool

	// The reason why the given name is not available.
	Reason *CheckNameAvailabilityReason

	// READ-ONLY; name of the PostgreSQL server.
	Name *string

	// READ-ONLY; type of the server
	Type *string
}

// NameProperty - Name property for quota usage
type NameProperty struct {
	// Localized name
	LocalizedValue *string

	// Name value
	Value *string
}

// Network properties of a server.
type Network struct {
	// Delegated subnet arm resource id. This is required to be passed during create, in case we want the server to be VNET injected,
	// i.e. Private access server. During update, pass this only if we want to
	// update the value for Private DNS zone.
	DelegatedSubnetResourceID *string

	// Private dns zone arm resource id. This is required to be passed during create, in case we want the server to be VNET injected,
	// i.e. Private access server. During update, pass this only if we want to
	// update the value for Private DNS zone.
	PrivateDNSZoneArmResourceID *string

	// public network access is enabled or not
	PublicNetworkAccess *ServerPublicNetworkAccessState
}

// Operation - REST API operation definition.
type Operation struct {
	// Indicates whether the operation is a data action
	IsDataAction *bool

	// READ-ONLY; The localized display information for this particular operation or action.
	Display *OperationDisplay

	// READ-ONLY; The name of the operation being performed on this particular object.
	Name *string

	// READ-ONLY; The intended executor of the operation.
	Origin *OperationOrigin

	// READ-ONLY; Additional descriptions for the operation.
	Properties map[string]any
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// READ-ONLY; Operation description.
	Description *string

	// READ-ONLY; Localized friendly name for the operation.
	Operation *string

	// READ-ONLY; Operation resource provider name.
	Provider *string

	// READ-ONLY; Resource on which the operation is performed.
	Resource *string
}

// OperationListResult - A list of resource provider operations.
type OperationListResult struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of available operation details
	Value []*Operation
}

// PrivateEndpoint - The private endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for private endpoint.
	ID *string
}

// PrivateEndpointConnection - The private endpoint connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	// READ-ONLY; The URL to get the next set of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The private endpoint resource.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The group ids for the private endpoint resource.
	GroupIDs []*string

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource.
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// QuotaUsage - Quota usage for flexible servers
type QuotaUsage struct {
	// Current Quota usage value
	CurrentValue *int64

	// Fully qualified ARM resource Id
	ID *string

	// Quota limit
	Limit *int64

	// Name of quota usage for flexible servers
	Name *NameProperty

	// Quota unit
	Unit *string
}

// QuotaUsagesListResult - Capability for the PostgreSQL server
type QuotaUsagesListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; A list of quota usages.
	Value []*QuotaUsage
}

// Replica properties of a server
type Replica struct {
	// Sets the promote mode for a replica server. This is a write only property.
	PromoteMode *ReadReplicaPromoteMode

	// Sets the promote options for a replica server. This is a write only property.
	PromoteOption *ReplicationPromoteOption

	// Used to indicate role of the server in replication set.
	Role *ReplicationRole

	// READ-ONLY; Replicas allowed for a server.
	Capacity *int32

	// READ-ONLY; Gets the replication state of a replica server. This property is returned only for replicas api call. Supported
	// values are Active, Catchup, Provisioning, Updating, Broken, Reconfiguring
	ReplicationState *ReplicationState
}

// RestartParameter - Represents server restart parameters.
type RestartParameter struct {
	// Failover mode.
	FailoverMode *FailoverMode

	// Indicates whether to restart the server with failover.
	RestartWithFailover *bool
}

// SKU - Sku information related properties of a server.
type SKU struct {
	// REQUIRED; The name of the sku, typically, tier + family + cores, e.g. StandardD4sv3.
	Name *string

	// REQUIRED; The tier of the particular SKU, e.g. Burstable.
	Tier *SKUTier
}

// Server - Represents a server.
type Server struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Describes the identity of the application.
	Identity *UserAssignedIdentity

	// Properties of the server.
	Properties *ServerProperties

	// The SKU (pricing tier) of the server.
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerBackup - Server backup properties
type ServerBackup struct {
	// The properties of a server backup.
	Properties *ServerBackupProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerBackupListResult - A list of server backups.
type ServerBackupListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of backups of a server.
	Value []*ServerBackup
}

// ServerBackupProperties - The properties of a server backup.
type ServerBackupProperties struct {
	// Backup type.
	BackupType *Origin

	// Backup completed time (ISO8601 format).
	CompletedTime *time.Time

	// Backup source
	Source *string
}

// ServerForUpdate - Represents a server to be updated.
type ServerForUpdate struct {
	// Describes the identity of the application.
	Identity *UserAssignedIdentity

	// Properties of the server.
	Properties *ServerPropertiesForUpdate

	// The SKU (pricing tier) of the server.
	SKU *SKU

	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string
}

// ServerListResult - A list of servers.
type ServerListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of flexible servers
	Value []*Server
}

// ServerProperties - The properties of a server.
type ServerProperties struct {
	// The administrator's login name of a server. Can only be specified when the server is being created (and is required for
	// creation).
	AdministratorLogin *string

	// The administrator login password (required for server creation).
	AdministratorLoginPassword *string

	// AuthConfig properties of a server.
	AuthConfig *AuthConfig

	// availability zone information of the server.
	AvailabilityZone *string

	// Backup properties of a server.
	Backup *Backup

	// The mode to create a new PostgreSQL server.
	CreateMode *CreateMode

	// Data encryption properties of a server.
	DataEncryption *DataEncryption

	// High availability properties of a server.
	HighAvailability *HighAvailability

	// Maintenance window properties of a server.
	MaintenanceWindow *MaintenanceWindow

	// Network properties of a server. This Network property is required to be passed only in case you want the server to be Private
	// access server.
	Network *Network

	// Restore point creation time (ISO8601 format), specifying the time to restore from. It's required when 'createMode' is 'PointInTimeRestore'
	// or 'GeoRestore' or 'ReviveDropped'.
	PointInTimeUTC *time.Time

	// Replica properties of a server. These Replica properties are required to be passed only in case you want to Promote a server.
	Replica *Replica

	// Replication role of the server
	ReplicationRole *ReplicationRole

	// The source server resource ID to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore'
	// or 'Replica' or 'ReviveDropped'. This property is returned only for Replica
	// server
	SourceServerResourceID *string

	// Storage properties of a server.
	Storage *Storage

	// PostgreSQL Server version.
	Version *ServerVersion

	// READ-ONLY; The fully qualified domain name of a server.
	FullyQualifiedDomainName *string

	// READ-ONLY; The minor version of the server.
	MinorVersion *string

	// READ-ONLY; List of private endpoint connections associated with the specified resource.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; Replicas allowed for a server.
	ReplicaCapacity *int32

	// READ-ONLY; A state of a server that is visible to user.
	State *ServerState
}

type ServerPropertiesForUpdate struct {
	// The password of the administrator login.
	AdministratorLoginPassword *string

	// AuthConfig properties of a server.
	AuthConfig *AuthConfig

	// Backup properties of a server.
	Backup *Backup

	// The mode to update a new PostgreSQL server.
	CreateMode *CreateModeForUpdate

	// Data encryption properties of a server.
	DataEncryption *DataEncryption

	// High availability properties of a server.
	HighAvailability *HighAvailability

	// Maintenance window properties of a server.
	MaintenanceWindow *MaintenanceWindow

	// Network properties of a server. These are required to be passed only in case if server is a private access server.
	Network *Network

	// Replica properties of a server. These Replica properties are required to be passed only in case you want to Promote a server.
	Replica *Replica

	// Replication role of the server
	ReplicationRole *ReplicationRole

	// Storage properties of a server.
	Storage *Storage

	// PostgreSQL Server version. Version 16 is currently not supported for MVU.
	Version *ServerVersion
}

// ServerSKU - Sku information related properties of a server.
type ServerSKU struct {
	// The name of the sku, typically, tier + family + cores, e.g. StandardD4sv3.
	Name *string

	// The tier of the particular SKU, e.g. Burstable.
	Tier *SKUTier
}

// ServerSKUCapability - Sku capability
type ServerSKUCapability struct {
	// READ-ONLY; Sku name
	Name *string

	// READ-ONLY; The reason for the capability not being available.
	Reason *string

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus

	// READ-ONLY; Supported high availability mode
	SupportedHaMode []*HaMode

	// READ-ONLY; Supported IOPS
	SupportedIops *int32

	// READ-ONLY; Supported memory per vCore in MB
	SupportedMemoryPerVcoreMb *int64

	// READ-ONLY; List of supported Availability Zones. E.g. "1", "2", "3"
	SupportedZones []*string

	// READ-ONLY; Supported vCores
	VCores *int32
}

// ServerThreatProtectionListResult - A list of the server's Advanced Threat Protection settings.
type ServerThreatProtectionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*ServerThreatProtectionSettingsModel
}

// ServerThreatProtectionProperties - Properties of server Threat Protection state.
type ServerThreatProtectionProperties struct {
	// REQUIRED; Specifies the state of the Threat Protection, whether it is enabled or disabled or a state has not been applied
	// yet on the specific server.
	State *ThreatProtectionState

	// READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *time.Time
}

// ServerThreatProtectionSettingsModel - Server's Advanced Threat Protection settings.
type ServerThreatProtectionSettingsModel struct {
	// Advanced Threat Protection properties.
	Properties *ServerThreatProtectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerVersionCapability - Server version capabilities.
type ServerVersionCapability struct {
	// READ-ONLY; Server version
	Name *string

	// READ-ONLY; The reason for the capability not being available.
	Reason *string

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus

	// READ-ONLY; Supported servers versions to upgrade
	SupportedVersionsToUpgrade []*string
}

// Storage properties of a server
type Storage struct {
	// Flag to enable / disable Storage Auto grow for flexible server.
	AutoGrow *StorageAutoGrow

	// Storage tier IOPS quantity. This property is required to be set for storage Type PremiumV2_LRS
	Iops *int32

	// Max storage allowed for a server.
	StorageSizeGB *int32

	// Storage throughput for the server. This is required to be set for storage Type PremiumV2_LRS
	Throughput *int32

	// Name of storage tier for IOPS.
	Tier *AzureManagedDiskPerformanceTiers

	// Storage type for the server. Allowed values are PremiumLRS and PremiumV2LRS, and default is Premium_LRS if not specified
	Type *StorageType
}

// StorageEditionCapability - Storage edition capability
type StorageEditionCapability struct {
	// READ-ONLY; Default storage size in MB for storage edition
	DefaultStorageSizeMb *int64

	// READ-ONLY; Storage edition name
	Name *string

	// READ-ONLY; The reason for the capability not being available.
	Reason *string

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus

	// READ-ONLY; Flexible server supported storage range in MB
	SupportedStorageMb []*StorageMbCapability
}

// StorageMbCapability - storage size in MB capability
type StorageMbCapability struct {
	// READ-ONLY; Default tier for IOPS
	DefaultIopsTier *string

	// READ-ONLY; Maximum value of Storage size in MB
	MaximumStorageSizeMb *int64

	// READ-ONLY; The reason for the capability not being available.
	Reason *string

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus

	// READ-ONLY; Storage size in MB
	StorageSizeMb *int64

	// READ-ONLY; Supported IOPS
	SupportedIops *int32

	// READ-ONLY; List of available options to upgrade the storage performance
	SupportedIopsTiers []*StorageTierCapability

	// READ-ONLY; Maximum IOPS supported by this #Vcores or PremiumV2_LRS Storage Size
	SupportedMaximumIops *int32

	// READ-ONLY; Maximum values of throughput in MB/s
	SupportedMaximumThroughput *int32

	// READ-ONLY; Values of throughput in MB/s
	SupportedThroughput *int32
}

// StorageTierCapability - Represents capability of a storage tier
type StorageTierCapability struct {
	// READ-ONLY; Supported IOPS for this storage tier
	Iops *int32

	// READ-ONLY; Name to represent Storage tier capability
	Name *string

	// READ-ONLY; The reason for the capability not being available.
	Reason *string

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UserAssignedIdentity - Information describing the identities associated with this application.
type UserAssignedIdentity struct {
	// REQUIRED; the types of identities associated with this resource; currently restricted to 'None and UserAssigned'
	Type *IdentityType

	// represents user assigned identities map.
	UserAssignedIdentities map[string]*UserIdentity

	// READ-ONLY; Tenant id of the server.
	TenantID *string
}

// UserIdentity - Describes a single user-assigned identity associated with the application.
type UserIdentity struct {
	// the client identifier of the Service Principal which this identity represents.
	ClientID *string

	// the object identifier of the Service Principal which this identity represents.
	PrincipalID *string
}

// ValidationDetails - Details for the validation for migration
type ValidationDetails struct {
	// Details of server level validations
	DbLevelValidationDetails []*DbLevelValidationStatus

	// Details of server level validations
	ServerLevelValidationDetails []*ValidationSummaryItem

	// Validation status for migration
	Status *ValidationState

	// Validation End date-time in UTC
	ValidationEndTimeInUTC *time.Time

	// Validation Start date-time in UTC
	ValidationStartTimeInUTC *time.Time
}

// ValidationMessage - Validation message object
type ValidationMessage struct {
	// Validation message string
	Message *string

	// Severity of validation message
	State *ValidationState
}

// ValidationSummaryItem - Validation summary object
type ValidationSummaryItem struct {
	// Validation messages
	Messages []*ValidationMessage

	// Validation status for migration
	State *ValidationState

	// Validation type
	Type *string
}

// VirtualEndpointResource - Represents a virtual endpoint for a server.
type VirtualEndpointResource struct {
	// Properties of the virtual endpoint resource.
	Properties *VirtualEndpointResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VirtualEndpointResourceForPatch - Represents a virtual endpoint for a server.
type VirtualEndpointResourceForPatch struct {
	// Properties of the virtual endpoint resource.
	Properties *VirtualEndpointResourceProperties
}

// VirtualEndpointResourceProperties - The properties of a virtual endpoint.
type VirtualEndpointResourceProperties struct {
	// The endpoint type for the virtual endpoint.
	EndpointType *VirtualEndpointType

	// List of members for a virtual endpoint
	Members []*string

	// READ-ONLY; List of virtual endpoints for a server
	VirtualEndpoints []*string
}

// VirtualEndpointsListResult - A list of virtual endpoints.
type VirtualEndpointsListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of virtual endpoints
	Value []*VirtualEndpointResource
}

// VirtualNetworkSubnetUsageParameter - Virtual network subnet usage parameter
type VirtualNetworkSubnetUsageParameter struct {
	// Virtual network resource id.
	VirtualNetworkArmResourceID *string
}

// VirtualNetworkSubnetUsageResult - Virtual network subnet usage data.
type VirtualNetworkSubnetUsageResult struct {
	// READ-ONLY
	DelegatedSubnetsUsage []*DelegatedSubnetUsage

	// READ-ONLY; location of the delegated subnet usage
	Location *string

	// READ-ONLY; subscriptionId of the delegated subnet usage
	SubscriptionID *string
}
