//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armkeyvault

import "time"

// AccessPolicyEntry - An identity that have access to the key vault. All identities in the array must use the same tenant
// ID as the key vault's tenant ID.
type AccessPolicyEntry struct {
	// REQUIRED; The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault.
	// The object ID must be unique for the list of access policies.
	ObjectID *string

	// REQUIRED; Permissions the identity has for keys, secrets and certificates.
	Permissions *Permissions

	// REQUIRED; The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *string

	// Application ID of the client making request on behalf of a principal
	ApplicationID *string
}

type Action struct {
	// The type of action.
	Type *KeyRotationPolicyActionType
}

// CheckMhsmNameAvailabilityParameters - The parameters used to check the availability of the managed hsm name.
type CheckMhsmNameAvailabilityParameters struct {
	// REQUIRED; The managed hsm name.
	Name *string
}

// CheckMhsmNameAvailabilityResult - The CheckMhsmNameAvailability operation response.
type CheckMhsmNameAvailabilityResult struct {
	// READ-ONLY; An error message explaining the Reason value in more detail.
	Message *string

	// READ-ONLY; A boolean value that indicates whether the name is available for you to use. If true, the name is available.
	// If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool

	// READ-ONLY; The reason that a managed hsm name could not be used. The reason element is only returned if NameAvailable is
	// false.
	Reason *Reason
}

// CheckNameAvailabilityResult - The CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	// READ-ONLY; An error message explaining the Reason value in more detail.
	Message *string

	// READ-ONLY; A boolean value that indicates whether the name is available for you to use. If true, the name is available.
	// If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool

	// READ-ONLY; The reason that a vault name could not be used. The Reason element is only returned if NameAvailable is false.
	Reason *Reason
}

type DeletedManagedHsm struct {
	// Properties of the deleted managed HSM
	Properties *DeletedManagedHsmProperties

	// READ-ONLY; The Azure Resource Manager resource ID for the deleted managed HSM Pool.
	ID *string

	// READ-ONLY; The name of the managed HSM Pool.
	Name *string

	// READ-ONLY; The resource type of the managed HSM Pool.
	Type *string
}

// DeletedManagedHsmListResult - List of deleted managed HSM Pools
type DeletedManagedHsmListResult struct {
	// The URL to get the next set of deleted managed HSM Pools.
	NextLink *string

	// The list of deleted managed HSM Pools.
	Value []*DeletedManagedHsm
}

// DeletedManagedHsmProperties - Properties of the deleted managed HSM.
type DeletedManagedHsmProperties struct {
	// READ-ONLY; The deleted date.
	DeletionDate *time.Time

	// READ-ONLY; The location of the original managed HSM.
	Location *string

	// READ-ONLY; The resource id of the original managed HSM.
	MhsmID *string

	// READ-ONLY; Purge protection status of the original managed HSM.
	PurgeProtectionEnabled *bool

	// READ-ONLY; The scheduled purged date.
	ScheduledPurgeDate *time.Time

	// READ-ONLY; Tags of the original managed HSM.
	Tags map[string]*string
}

// DeletedVault - Deleted vault information with extended details.
type DeletedVault struct {
	// Properties of the vault
	Properties *DeletedVaultProperties

	// READ-ONLY; The resource ID for the deleted key vault.
	ID *string

	// READ-ONLY; The name of the key vault.
	Name *string

	// READ-ONLY; The resource type of the key vault.
	Type *string
}

// DeletedVaultListResult - List of vaults
type DeletedVaultListResult struct {
	// The URL to get the next set of deleted vaults.
	NextLink *string

	// The list of deleted vaults.
	Value []*DeletedVault
}

// DeletedVaultProperties - Properties of the deleted vault.
type DeletedVaultProperties struct {
	// READ-ONLY; The deleted date.
	DeletionDate *time.Time

	// READ-ONLY; The location of the original vault.
	Location *string

	// READ-ONLY; Purge protection status of the original vault.
	PurgeProtectionEnabled *bool

	// READ-ONLY; The scheduled purged date.
	ScheduledPurgeDate *time.Time

	// READ-ONLY; Tags of the original vault.
	Tags map[string]*string

	// READ-ONLY; The resource id of the original vault.
	VaultID *string
}

// DimensionProperties - Type of operation: get, read, delete, etc.
type DimensionProperties struct {
	// Display name of dimension.
	DisplayName *string

	// Name of dimension.
	Name *string

	// Property to specify whether the dimension should be exported for Shoebox.
	ToBeExportedForShoebox *bool
}

// IPRule - A rule governing the accessibility of a vault from a specific ip address or ip range.
type IPRule struct {
	// REQUIRED; An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses
	// that start with 124.56.78).
	Value *string
}

// Key - The key resource.
type Key struct {
	// REQUIRED; The properties of the key.
	Properties *KeyProperties

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string

	// READ-ONLY; Azure location of the key vault resource.
	Location *string

	// READ-ONLY; Name of the key vault resource.
	Name *string

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string

	// READ-ONLY; Resource type of the key vault resource.
	Type *string
}

// KeyAttributes - The object attributes managed by the Azure Key Vault service.
type KeyAttributes struct {
	// Determines whether or not the object is enabled.
	Enabled *bool

	// Expiry date in seconds since 1970-01-01T00:00:00Z.
	Expires *int64

	// Indicates if the private key can be exported.
	Exportable *bool

	// Not before date in seconds since 1970-01-01T00:00:00Z.
	NotBefore *int64

	// READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *int64

	// READ-ONLY; The deletion recovery level currently in effect for the object. If it contains 'Purgeable', then the object
	// can be permanently deleted by a privileged user; otherwise, only the system can purge the
	// object at the end of the retention interval.
	RecoveryLevel *DeletionRecoveryLevel

	// READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *int64
}

// KeyCreateParameters - The parameters used to create a key.
type KeyCreateParameters struct {
	// REQUIRED; The properties of the key to be created.
	Properties *KeyProperties

	// The tags that will be assigned to the key.
	Tags map[string]*string
}

// KeyListResult - The page of keys.
type KeyListResult struct {
	// The URL to get the next page of keys.
	NextLink *string

	// The key resources.
	Value []*Key
}

// KeyProperties - The properties of the key.
type KeyProperties struct {
	// The attributes of the key.
	Attributes *KeyAttributes

	// The elliptic curve name. For valid values, see JsonWebKeyCurveName.
	CurveName *JSONWebKeyCurveName
	KeyOps    []*JSONWebKeyOperation

	// The key size in bits. For example: 2048, 3072, or 4096 for RSA.
	KeySize *int32

	// The type of the key. For valid values, see JsonWebKeyType.
	Kty *JSONWebKeyType

	// Key release policy in response. It will be used for both output and input. Omitted if empty
	ReleasePolicy *KeyReleasePolicy

	// Key rotation policy in response. It will be used for both output and input. Omitted if empty
	RotationPolicy *RotationPolicy

	// READ-ONLY; The URI to retrieve the current version of the key.
	KeyURI *string

	// READ-ONLY; The URI to retrieve the specific version of the key.
	KeyURIWithVersion *string
}

type KeyReleasePolicy struct {
	// Content type and version of key release policy
	ContentType *string

	// Blob encoding the policy rules under which the key can be released.
	Data []byte
}

type KeyRotationPolicyAttributes struct {
	// The expiration time for the new key version. It should be in ISO8601 format. Eg: 'P90D', 'P1Y'.
	ExpiryTime *string

	// READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *int64

	// READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *int64
}

type LifetimeAction struct {
	// The action of key rotation policy lifetimeAction.
	Action *Action

	// The trigger of key rotation policy lifetimeAction.
	Trigger *Trigger
}

// LogSpecification - Log specification of operation.
type LogSpecification struct {
	// Blob duration of specification.
	BlobDuration *string

	// Display name of log specification.
	DisplayName *string

	// Name of log specification.
	Name *string
}

// MHSMGeoReplicatedRegion - A region that this managed HSM Pool has been extended to.
type MHSMGeoReplicatedRegion struct {
	// A boolean value that indicates whether the region is the primary region or a secondary region.
	IsPrimary *bool

	// Name of the geo replicated region.
	Name *string

	// READ-ONLY; Provisioning state of the geo replicated region.
	ProvisioningState *GeoReplicationRegionProvisioningState
}

// MHSMIPRule - A rule governing the accessibility of a managed HSM pool from a specific IP address or IP range.
type MHSMIPRule struct {
	// REQUIRED; An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses
	// that start with 124.56.78).
	Value *string
}

// MHSMNetworkRuleSet - A set of rules governing the network accessibility of a managed hsm pool.
type MHSMNetworkRuleSet struct {
	// Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'. If not specified the default is 'AzureServices'.
	Bypass *NetworkRuleBypassOptions

	// The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property
	// has been evaluated.
	DefaultAction *NetworkRuleAction

	// The list of IP address rules.
	IPRules []*MHSMIPRule

	// The list of virtual network rules.
	VirtualNetworkRules []*MHSMVirtualNetworkRule
}

// MHSMPrivateEndpoint - Private endpoint object properties.
type MHSMPrivateEndpoint struct {
	// READ-ONLY; Full identifier of the private endpoint resource.
	ID *string
}

// MHSMPrivateEndpointConnection - Private endpoint connection resource.
type MHSMPrivateEndpointConnection struct {
	// Modified whenever there is a change in the state of private endpoint connection.
	Etag *string

	// Managed service identity (system assigned and/or user assigned identities)
	Identity *ManagedServiceIdentity

	// The supported Azure location where the managed HSM Pool should be created.
	Location *string

	// Resource properties.
	Properties *MHSMPrivateEndpointConnectionProperties

	// SKU details
	SKU *ManagedHsmSKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string

	// READ-ONLY; The name of the managed HSM Pool.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the key vault resource.
	SystemData *SystemData

	// READ-ONLY; The resource type of the managed HSM Pool.
	Type *string
}

// MHSMPrivateEndpointConnectionItem - Private endpoint connection item.
type MHSMPrivateEndpointConnectionItem struct {
	// Modified whenever there is a change in the state of private endpoint connection.
	Etag *string

	// Id of private endpoint connection.
	ID *string

	// Private endpoint connection properties.
	Properties *MHSMPrivateEndpointConnectionProperties
}

// MHSMPrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type MHSMPrivateEndpointConnectionProperties struct {
	// Properties of the private endpoint object.
	PrivateEndpoint *MHSMPrivateEndpoint

	// Approval state of the private link connection.
	PrivateLinkServiceConnectionState *MHSMPrivateLinkServiceConnectionState

	// Provisioning state of the private endpoint connection.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// MHSMPrivateEndpointConnectionsListResult - List of private endpoint connections associated with a managed HSM Pools
type MHSMPrivateEndpointConnectionsListResult struct {
	// The URL to get the next set of managed HSM Pools.
	NextLink *string

	// The private endpoint connection associated with a managed HSM Pools.
	Value []*MHSMPrivateEndpointConnection
}

// MHSMPrivateLinkResource - A private link resource
type MHSMPrivateLinkResource struct {
	// Managed service identity (system assigned and/or user assigned identities)
	Identity *ManagedServiceIdentity

	// The supported Azure location where the managed HSM Pool should be created.
	Location *string

	// Resource properties.
	Properties *MHSMPrivateLinkResourceProperties

	// SKU details
	SKU *ManagedHsmSKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string

	// READ-ONLY; The name of the managed HSM Pool.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the key vault resource.
	SystemData *SystemData

	// READ-ONLY; The resource type of the managed HSM Pool.
	Type *string
}

// MHSMPrivateLinkResourceListResult - A list of private link resources
type MHSMPrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*MHSMPrivateLinkResource
}

// MHSMPrivateLinkResourceProperties - Properties of a private link resource.
type MHSMPrivateLinkResourceProperties struct {
	// Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string

	// READ-ONLY; Group identifier of private link resource.
	GroupID *string

	// READ-ONLY; Required member names of private link resource.
	RequiredMembers []*string
}

// MHSMPrivateLinkServiceConnectionState - An object that represents the approval state of the private link connection.
type MHSMPrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *ActionsRequired

	// The reason for approval or rejection.
	Description *string

	// Indicates whether the connection has been approved, rejected or removed by the key vault owner.
	Status *PrivateEndpointServiceConnectionStatus
}

// MHSMRegionsListResult - List of regions associated with a managed HSM Pools
type MHSMRegionsListResult struct {
	// The URL to get the next set of managed HSM Pools.
	NextLink *string

	// The region associated with a managed HSM Pools.
	Value []*MHSMGeoReplicatedRegion
}

// MHSMVirtualNetworkRule - A rule governing the accessibility of a managed hsm pool from a specific virtual network.
type MHSMVirtualNetworkRule struct {
	// REQUIRED; Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
	ID *string
}

// ManagedHSMSecurityDomainProperties - The security domain properties of the managed hsm.
type ManagedHSMSecurityDomainProperties struct {
	// READ-ONLY; Activation Status
	ActivationStatus *ActivationStatus

	// READ-ONLY; Activation Status Message.
	ActivationStatusMessage *string
}

// ManagedHsm - Resource information with extended details.
type ManagedHsm struct {
	// Managed service identity (system assigned and/or user assigned identities)
	Identity *ManagedServiceIdentity

	// The supported Azure location where the managed HSM Pool should be created.
	Location *string

	// Properties of the managed HSM
	Properties *ManagedHsmProperties

	// SKU details
	SKU *ManagedHsmSKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string

	// READ-ONLY; The name of the managed HSM Pool.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the key vault resource.
	SystemData *SystemData

	// READ-ONLY; The resource type of the managed HSM Pool.
	Type *string
}

type ManagedHsmAction struct {
	// The type of action.
	Type *KeyRotationPolicyActionType
}

// ManagedHsmKey - The key resource.
type ManagedHsmKey struct {
	// REQUIRED; The properties of the key.
	Properties *ManagedHsmKeyProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ManagedHsmKeyAttributes - The object attributes managed by the Azure Key Vault service.
type ManagedHsmKeyAttributes struct {
	// Determines whether or not the object is enabled.
	Enabled *bool

	// Expiry date in seconds since 1970-01-01T00:00:00Z.
	Expires *int64

	// Indicates if the private key can be exported.
	Exportable *bool

	// Not before date in seconds since 1970-01-01T00:00:00Z.
	NotBefore *int64

	// READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *int64

	// READ-ONLY; The deletion recovery level currently in effect for the object. If it contains 'Purgeable', then the object
	// can be permanently deleted by a privileged user; otherwise, only the system can purge the
	// object at the end of the retention interval.
	RecoveryLevel *DeletionRecoveryLevel

	// READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *int64
}

// ManagedHsmKeyCreateParameters - The parameters used to create a key.
type ManagedHsmKeyCreateParameters struct {
	// REQUIRED; The properties of the key to be created.
	Properties *ManagedHsmKeyProperties

	// The tags that will be assigned to the key.
	Tags map[string]*string
}

// ManagedHsmKeyListResult - The page of keys.
type ManagedHsmKeyListResult struct {
	// The URL to get the next page of keys.
	NextLink *string

	// The key resources.
	Value []*ManagedHsmKey
}

// ManagedHsmKeyProperties - The properties of the key.
type ManagedHsmKeyProperties struct {
	// The attributes of the key.
	Attributes *ManagedHsmKeyAttributes

	// The elliptic curve name. For valid values, see JsonWebKeyCurveName.
	CurveName *JSONWebKeyCurveName
	KeyOps    []*JSONWebKeyOperation

	// The key size in bits. For example: 2048, 3072, or 4096 for RSA.
	KeySize *int32

	// The type of the key. For valid values, see JsonWebKeyType.
	Kty *JSONWebKeyType

	// Key release policy in response. It will be used for both output and input. Omitted if empty
	ReleasePolicy *ManagedHsmKeyReleasePolicy

	// Key rotation policy in response. It will be used for both output and input. Omitted if empty
	RotationPolicy *ManagedHsmRotationPolicy

	// READ-ONLY; The URI to retrieve the current version of the key.
	KeyURI *string

	// READ-ONLY; The URI to retrieve the specific version of the key.
	KeyURIWithVersion *string
}

type ManagedHsmKeyReleasePolicy struct {
	// Content type and version of key release policy
	ContentType *string

	// Blob encoding the policy rules under which the key can be released.
	Data []byte
}

type ManagedHsmKeyRotationPolicyAttributes struct {
	// The expiration time for the new key version. It should be in ISO8601 format. Eg: 'P90D', 'P1Y'.
	ExpiryTime *string

	// READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *int64

	// READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *int64
}

type ManagedHsmLifetimeAction struct {
	// The action of key rotation policy lifetimeAction.
	Action *ManagedHsmAction

	// The trigger of key rotation policy lifetimeAction.
	Trigger *ManagedHsmTrigger
}

// ManagedHsmListResult - List of managed HSM Pools
type ManagedHsmListResult struct {
	// The URL to get the next set of managed HSM Pools.
	NextLink *string

	// The list of managed HSM Pools.
	Value []*ManagedHsm
}

// ManagedHsmProperties - Properties of the managed HSM Pool
type ManagedHsmProperties struct {
	// The create mode to indicate whether the resource is being created or is being recovered from a deleted resource.
	CreateMode *CreateMode

	// Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true
	// activates protection against purge for this managed HSM pool and its content -
	// only the Managed HSM service may initiate a hard, irrecoverable deletion. Enabling this functionality is irreversible.
	EnablePurgeProtection *bool

	// Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. Soft delete is enabled
	// by default for all managed HSMs and is immutable.
	EnableSoftDelete *bool

	// Array of initial administrators object ids for this managed hsm pool.
	InitialAdminObjectIDs []*string

	// Rules governing the accessibility of the key vault from specific network locations.
	NetworkACLs *MHSMNetworkRuleSet

	// Control permission to the managed HSM from public networks.
	PublicNetworkAccess *PublicNetworkAccess

	// List of all regions associated with the managed hsm pool.
	Regions []*MHSMGeoReplicatedRegion

	// Soft deleted data retention days. When you delete an HSM or a key, it will remain recoverable for the configured retention
	// period or for a default period of 90 days. It accepts values between 7 and
	// 90.
	SoftDeleteRetentionInDays *int32

	// The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool.
	TenantID *string

	// READ-ONLY; The URI of the managed hsm pool for performing operations on keys.
	HsmURI *string

	// READ-ONLY; List of private endpoint connections associated with the managed hsm pool.
	PrivateEndpointConnections []*MHSMPrivateEndpointConnectionItem

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The scheduled purge date in UTC.
	ScheduledPurgeDate *time.Time

	// READ-ONLY; Managed HSM security domain properties.
	SecurityDomainProperties *ManagedHSMSecurityDomainProperties

	// READ-ONLY; Resource Status Message.
	StatusMessage *string
}

type ManagedHsmRotationPolicy struct {
	// The attributes of key rotation policy.
	Attributes *ManagedHsmKeyRotationPolicyAttributes

	// The lifetimeActions for key rotation action.
	LifetimeActions []*ManagedHsmLifetimeAction
}

// ManagedHsmSKU - SKU details
type ManagedHsmSKU struct {
	// REQUIRED; SKU Family of the managed HSM Pool
	Family *ManagedHsmSKUFamily

	// REQUIRED; SKU of the managed HSM Pool
	Name *ManagedHsmSKUName
}

type ManagedHsmTrigger struct {
	// The time duration after key creation to rotate the key. It only applies to rotate. It will be in ISO 8601 duration format.
	// Eg: 'P90D', 'P1Y'.
	TimeAfterCreate *string

	// The time duration before key expiring to rotate or notify. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
	TimeBeforeExpiry *string
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// MetricSpecification - Metric specification of operation.
type MetricSpecification struct {
	// The metric aggregation type. Possible values include: 'Average', 'Count', 'Total'.
	AggregationType *string

	// The dimensions of metric
	Dimensions []*DimensionProperties

	// Display description of metric specification.
	DisplayDescription *string

	// Display name of metric specification.
	DisplayName *string

	// Property to specify whether to fill gap with zero.
	FillGapWithZero *bool

	// The internal metric name.
	InternalMetricName *string

	// The metric lock aggregation type.
	LockAggregationType *string

	// Name of metric specification.
	Name *string

	// The supported aggregation types for the metrics.
	SupportedAggregationTypes []*string

	// The supported time grain types for the metrics.
	SupportedTimeGrainTypes []*string

	// The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
	Unit *string
}

// NetworkRuleSet - A set of rules governing the network accessibility of a vault.
type NetworkRuleSet struct {
	// Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'. If not specified the default is 'AzureServices'.
	Bypass *NetworkRuleBypassOptions

	// The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property
	// has been evaluated.
	DefaultAction *NetworkRuleAction

	// The list of IP address rules.
	IPRules []*IPRule

	// The list of virtual network rules.
	VirtualNetworkRules []*VirtualNetworkRule
}

// Operation - Key Vault REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay

	// Property to specify whether the action is a data action.
	IsDataAction *bool

	// Operation name: {provider}/{resource}/{operation}
	Name *string

	// Properties of operation, include metric specifications.
	OperationProperties *OperationProperties

	// The origin of operations.
	Origin *string
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of operation.
	Description *string

	// Type of operation: get, read, delete, etc.
	Operation *string

	// Service provider: Microsoft Key Vault.
	Provider *string

	// Resource on which the operation is performed etc.
	Resource *string
}

// OperationListResult - Result of the request to list Storage operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// The URL to get the next set of operations.
	NextLink *string

	// List of Storage operations supported by the Storage resource provider.
	Value []*Operation
}

// OperationProperties - Properties of operation, include metric specifications.
type OperationProperties struct {
	// One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification
}

// Permissions the identity has for keys, secrets, certificates and storage.
type Permissions struct {
	// Permissions to certificates
	Certificates []*CertificatePermissions

	// Permissions to keys
	Keys []*KeyPermissions

	// Permissions to secrets
	Secrets []*SecretPermissions

	// Permissions to storage accounts
	Storage []*StoragePermissions
}

// PrivateEndpoint - Private endpoint object properties.
type PrivateEndpoint struct {
	// READ-ONLY; Full identifier of the private endpoint resource.
	ID *string
}

// PrivateEndpointConnection - Private endpoint connection resource.
type PrivateEndpointConnection struct {
	// Modified whenever there is a change in the state of private endpoint connection.
	Etag *string

	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string

	// READ-ONLY; Azure location of the key vault resource.
	Location *string

	// READ-ONLY; Name of the key vault resource.
	Name *string

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string

	// READ-ONLY; Resource type of the key vault resource.
	Type *string
}

// PrivateEndpointConnectionItem - Private endpoint connection item.
type PrivateEndpointConnectionItem struct {
	// Modified whenever there is a change in the state of private endpoint connection.
	Etag *string

	// Id of private endpoint connection.
	ID *string

	// Private endpoint connection properties.
	Properties *PrivateEndpointConnectionProperties
}

// PrivateEndpointConnectionListResult - List of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	// The URL to get the next set of private endpoint connections.
	NextLink *string

	// The list of private endpoint connections.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// Properties of the private endpoint object.
	PrivateEndpoint *PrivateEndpoint

	// Approval state of the private link connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// Provisioning state of the private endpoint connection.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string

	// READ-ONLY; Azure location of the key vault resource.
	Location *string

	// READ-ONLY; Name of the key vault resource.
	Name *string

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string

	// READ-ONLY; Resource type of the key vault resource.
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string

	// READ-ONLY; Group identifier of private link resource.
	GroupID *string

	// READ-ONLY; Required member names of private link resource.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - An object that represents the approval state of the private link connection.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *ActionsRequired

	// The reason for approval or rejection.
	Description *string

	// Indicates whether the connection has been approved, rejected or removed by the key vault owner.
	Status *PrivateEndpointServiceConnectionStatus
}

// Resource - Key Vault resource
type Resource struct {
	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string

	// READ-ONLY; Azure location of the key vault resource.
	Location *string

	// READ-ONLY; Name of the key vault resource.
	Name *string

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string

	// READ-ONLY; Resource type of the key vault resource.
	Type *string
}

// ResourceListResult - List of vault resources.
type ResourceListResult struct {
	// The URL to get the next set of vault resources.
	NextLink *string

	// The list of vault resources.
	Value []*Resource
}

type RotationPolicy struct {
	// The attributes of key rotation policy.
	Attributes *KeyRotationPolicyAttributes

	// The lifetimeActions for key rotation action.
	LifetimeActions []*LifetimeAction
}

// SKU details
type SKU struct {
	// REQUIRED; SKU family name
	Family *SKUFamily

	// REQUIRED; SKU name to specify whether the key vault is a standard vault or a premium vault.
	Name *SKUName
}

// Secret - Resource information with extended details.
type Secret struct {
	// REQUIRED; Properties of the secret
	Properties *SecretProperties

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string

	// READ-ONLY; Azure location of the key vault resource.
	Location *string

	// READ-ONLY; Name of the key vault resource.
	Name *string

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string

	// READ-ONLY; Resource type of the key vault resource.
	Type *string
}

// SecretAttributes - The secret management attributes.
type SecretAttributes struct {
	// Determines whether the object is enabled.
	Enabled *bool

	// Expiry date in seconds since 1970-01-01T00:00:00Z.
	Expires *time.Time

	// Not before date in seconds since 1970-01-01T00:00:00Z.
	NotBefore *time.Time

	// READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *time.Time

	// READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *time.Time
}

// SecretCreateOrUpdateParameters - Parameters for creating or updating a secret
type SecretCreateOrUpdateParameters struct {
	// REQUIRED; Properties of the secret
	Properties *SecretProperties

	// The tags that will be assigned to the secret.
	Tags map[string]*string
}

// SecretListResult - List of secrets
type SecretListResult struct {
	// The URL to get the next set of secrets.
	NextLink *string

	// The list of secrets.
	Value []*Secret
}

// SecretPatchParameters - Parameters for patching a secret
type SecretPatchParameters struct {
	// Properties of the secret
	Properties *SecretPatchProperties

	// The tags that will be assigned to the secret.
	Tags map[string]*string
}

// SecretPatchProperties - Properties of the secret
type SecretPatchProperties struct {
	// The attributes of the secret.
	Attributes *SecretAttributes

	// The content type of the secret.
	ContentType *string

	// The value of the secret.
	Value *string
}

// SecretProperties - Properties of the secret
type SecretProperties struct {
	// The attributes of the secret.
	Attributes *SecretAttributes

	// The content type of the secret.
	ContentType *string

	// The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using this model are is intended
	// for internal use in ARM deployments. Users should use the data-plane REST
	// service for interaction with vault secrets.
	Value *string

	// READ-ONLY; The URI to retrieve the current version of the secret.
	SecretURI *string

	// READ-ONLY; The URI to retrieve the specific version of the secret.
	SecretURIWithVersion *string
}

// ServiceSpecification - One property of operation, include log specifications.
type ServiceSpecification struct {
	// Log specifications of operation.
	LogSpecifications []*LogSpecification

	// Metric specifications of operation.
	MetricSpecifications []*MetricSpecification
}

// SystemData - Metadata pertaining to creation and last modification of the key vault resource.
type SystemData struct {
	// The timestamp of the key vault resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the key vault resource.
	CreatedBy *string

	// The type of identity that created the key vault resource.
	CreatedByType *IdentityType

	// The timestamp of the key vault resource last modification (UTC).
	LastModifiedAt *time.Time

	// The identity that last modified the key vault resource.
	LastModifiedBy *string

	// The type of identity that last modified the key vault resource.
	LastModifiedByType *IdentityType
}

type Trigger struct {
	// The time duration after key creation to rotate the key. It only applies to rotate. It will be in ISO 8601 duration format.
	// Eg: 'P90D', 'P1Y'.
	TimeAfterCreate *string

	// The time duration before key expiring to rotate or notify. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
	TimeBeforeExpiry *string
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}

// Vault - Resource information with extended details.
type Vault struct {
	// REQUIRED; Properties of the vault
	Properties *VaultProperties

	// Azure location of the key vault resource.
	Location *string

	// Tags assigned to the key vault resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string

	// READ-ONLY; Name of the key vault resource.
	Name *string

	// READ-ONLY; System metadata for the key vault.
	SystemData *SystemData

	// READ-ONLY; Resource type of the key vault resource.
	Type *string
}

// VaultAccessPolicyParameters - Parameters for updating the access policy in a vault
type VaultAccessPolicyParameters struct {
	// REQUIRED; Properties of the access policy
	Properties *VaultAccessPolicyProperties

	// READ-ONLY; The resource id of the access policy.
	ID *string

	// READ-ONLY; The resource type of the access policy.
	Location *string

	// READ-ONLY; The resource name of the access policy.
	Name *string

	// READ-ONLY; The resource name of the access policy.
	Type *string
}

// VaultAccessPolicyProperties - Properties of the vault access policy
type VaultAccessPolicyProperties struct {
	// REQUIRED; An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same
	// tenant ID as the key vault's tenant ID.
	AccessPolicies []*AccessPolicyEntry
}

// VaultCheckNameAvailabilityParameters - The parameters used to check the availability of the vault name.
type VaultCheckNameAvailabilityParameters struct {
	// REQUIRED; The vault name.
	Name *string

	// CONSTANT; The type of resource, Microsoft.KeyVault/vaults
	// Field has constant value "Microsoft.KeyVault/vaults", any specified value is ignored.
	Type *string
}

// VaultCreateOrUpdateParameters - Parameters for creating or updating a vault
type VaultCreateOrUpdateParameters struct {
	// REQUIRED; The supported Azure location where the key vault should be created.
	Location *string

	// REQUIRED; Properties of the vault
	Properties *VaultProperties

	// The tags that will be assigned to the key vault.
	Tags map[string]*string
}

// VaultListResult - List of vaults
type VaultListResult struct {
	// The URL to get the next set of vaults.
	NextLink *string

	// The list of vaults.
	Value []*Vault
}

// VaultPatchParameters - Parameters for creating or updating a vault
type VaultPatchParameters struct {
	// Properties of the vault
	Properties *VaultPatchProperties

	// The tags that will be assigned to the key vault.
	Tags map[string]*string
}

// VaultPatchProperties - Properties of the vault
type VaultPatchProperties struct {
	// An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same tenant
	// ID as the key vault's tenant ID.
	AccessPolicies []*AccessPolicyEntry

	// The vault's create mode to indicate whether the vault need to be recovered or not.
	CreateMode *CreateMode

	// Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates
	// protection against purge for this vault and its content - only the Key Vault
	// service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling
	// this functionality is irreversible - that is, the property does not accept
	// false as its value.
	EnablePurgeProtection *bool

	// Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC)
	// for authorization of data actions, and the access policies specified in vault
	// properties will be ignored. When false, the key vault will use the access policies specified in vault properties, and any
	// policy stored on Azure Resource Manager will be ignored. If null or not
	// specified, the value of this property will not change.
	EnableRbacAuthorization *bool

	// Property to specify whether the 'soft delete' functionality is enabled for this key vault. Once set to true, it cannot
	// be reverted to false.
	EnableSoftDelete *bool

	// Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key
	// vault.
	EnabledForDeployment *bool

	// Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
	EnabledForDiskEncryption *bool

	// Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
	EnabledForTemplateDeployment *bool

	// A collection of rules governing the accessibility of the vault from specific network locations.
	NetworkACLs *NetworkRuleSet

	// Property to specify whether the vault will accept traffic from public internet. If set to 'disabled' all traffic except
	// private endpoint traffic and that that originates from trusted services will be
	// blocked. This will override the set firewall rules, meaning that even if the firewall rules are present we will not honor
	// the rules.
	PublicNetworkAccess *string

	// SKU details
	SKU *SKU

	// softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32

	// The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *string
}

// VaultProperties - Properties of the vault
type VaultProperties struct {
	// REQUIRED; SKU details
	SKU *SKU

	// REQUIRED; The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *string

	// An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant
	// ID as the key vault's tenant ID. When createMode is set to recover, access
	// policies are not required. Otherwise, access policies are required.
	AccessPolicies []*AccessPolicyEntry

	// The vault's create mode to indicate whether the vault need to be recovered or not.
	CreateMode *CreateMode

	// Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates
	// protection against purge for this vault and its content - only the Key Vault
	// service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling
	// this functionality is irreversible - that is, the property does not accept
	// false as its value.
	EnablePurgeProtection *bool

	// Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC)
	// for authorization of data actions, and the access policies specified in vault
	// properties will be ignored. When false, the key vault will use the access policies specified in vault properties, and any
	// policy stored on Azure Resource Manager will be ignored. If null or not
	// specified, the vault is created with the default value of false. Note that management actions are always authorized with
	// RBAC.
	EnableRbacAuthorization *bool

	// Property to specify whether the 'soft delete' functionality is enabled for this key vault. If it's not set to any value(true
	// or false) when creating new key vault, it will be set to true by default.
	// Once set to true, it cannot be reverted to false.
	EnableSoftDelete *bool

	// Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key
	// vault.
	EnabledForDeployment *bool

	// Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
	EnabledForDiskEncryption *bool

	// Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
	EnabledForTemplateDeployment *bool

	// Rules governing the accessibility of the key vault from specific network locations.
	NetworkACLs *NetworkRuleSet

	// Provisioning state of the vault.
	ProvisioningState *VaultProvisioningState

	// Property to specify whether the vault will accept traffic from public internet. If set to 'disabled' all traffic except
	// private endpoint traffic and that that originates from trusted services will be
	// blocked. This will override the set firewall rules, meaning that even if the firewall rules are present we will not honor
	// the rules.
	PublicNetworkAccess *string

	// softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32

	// The URI of the vault for performing operations on keys and secrets.
	VaultURI *string

	// READ-ONLY; The resource id of HSM Pool.
	HsmPoolResourceID *string

	// READ-ONLY; List of private endpoint connections associated with the key vault.
	PrivateEndpointConnections []*PrivateEndpointConnectionItem
}

// VirtualNetworkRule - A rule governing the accessibility of a vault from a specific virtual network.
type VirtualNetworkRule struct {
	// REQUIRED; Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
	ID *string

	// Property to specify whether NRP will ignore the check if parent subnet has serviceEndpoints configured.
	IgnoreMissingVnetServiceEndpoint *bool
}
