//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhdinsight

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ScriptActionsClient contains the methods for the ScriptActions group.
// Don't use this type directly, use NewScriptActionsClient() instead.
type ScriptActionsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewScriptActionsClient creates a new instance of ScriptActionsClient with the specified values.
//   - subscriptionID - The subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID
//     forms part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewScriptActionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ScriptActionsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ScriptActionsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Delete - Deletes a specified persisted script action of the cluster.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-15-preview
//   - resourceGroupName - The name of the resource group.
//   - clusterName - The name of the cluster.
//   - scriptName - The name of the script.
//   - options - ScriptActionsClientDeleteOptions contains the optional parameters for the ScriptActionsClient.Delete method.
func (client *ScriptActionsClient) Delete(ctx context.Context, resourceGroupName string, clusterName string, scriptName string, options *ScriptActionsClientDeleteOptions) (ScriptActionsClientDeleteResponse, error) {
	var err error
	const operationName = "ScriptActionsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, clusterName, scriptName, options)
	if err != nil {
		return ScriptActionsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScriptActionsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ScriptActionsClientDeleteResponse{}, err
	}
	return ScriptActionsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ScriptActionsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, scriptName string, options *ScriptActionsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/scriptActions/{scriptName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	if scriptName == "" {
		return nil, errors.New("parameter scriptName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scriptName}", url.PathEscape(scriptName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetExecutionAsyncOperationStatus - Gets the async operation status of execution operation.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-15-preview
//   - resourceGroupName - The name of the resource group.
//   - clusterName - The name of the cluster.
//   - operationID - The long running operation id.
//   - options - ScriptActionsClientGetExecutionAsyncOperationStatusOptions contains the optional parameters for the ScriptActionsClient.GetExecutionAsyncOperationStatus
//     method.
func (client *ScriptActionsClient) GetExecutionAsyncOperationStatus(ctx context.Context, resourceGroupName string, clusterName string, operationID string, options *ScriptActionsClientGetExecutionAsyncOperationStatusOptions) (ScriptActionsClientGetExecutionAsyncOperationStatusResponse, error) {
	var err error
	const operationName = "ScriptActionsClient.GetExecutionAsyncOperationStatus"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getExecutionAsyncOperationStatusCreateRequest(ctx, resourceGroupName, clusterName, operationID, options)
	if err != nil {
		return ScriptActionsClientGetExecutionAsyncOperationStatusResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScriptActionsClientGetExecutionAsyncOperationStatusResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ScriptActionsClientGetExecutionAsyncOperationStatusResponse{}, err
	}
	resp, err := client.getExecutionAsyncOperationStatusHandleResponse(httpResp)
	return resp, err
}

// getExecutionAsyncOperationStatusCreateRequest creates the GetExecutionAsyncOperationStatus request.
func (client *ScriptActionsClient) getExecutionAsyncOperationStatusCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, operationID string, options *ScriptActionsClientGetExecutionAsyncOperationStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/executeScriptActions/azureasyncoperations/{operationId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getExecutionAsyncOperationStatusHandleResponse handles the GetExecutionAsyncOperationStatus response.
func (client *ScriptActionsClient) getExecutionAsyncOperationStatusHandleResponse(resp *http.Response) (ScriptActionsClientGetExecutionAsyncOperationStatusResponse, error) {
	result := ScriptActionsClientGetExecutionAsyncOperationStatusResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AsyncOperationResult); err != nil {
		return ScriptActionsClientGetExecutionAsyncOperationStatusResponse{}, err
	}
	return result, nil
}

// GetExecutionDetail - Gets the script execution detail for the given script execution ID.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-15-preview
//   - resourceGroupName - The name of the resource group.
//   - clusterName - The name of the cluster.
//   - scriptExecutionID - The script execution Id
//   - options - ScriptActionsClientGetExecutionDetailOptions contains the optional parameters for the ScriptActionsClient.GetExecutionDetail
//     method.
func (client *ScriptActionsClient) GetExecutionDetail(ctx context.Context, resourceGroupName string, clusterName string, scriptExecutionID string, options *ScriptActionsClientGetExecutionDetailOptions) (ScriptActionsClientGetExecutionDetailResponse, error) {
	var err error
	const operationName = "ScriptActionsClient.GetExecutionDetail"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getExecutionDetailCreateRequest(ctx, resourceGroupName, clusterName, scriptExecutionID, options)
	if err != nil {
		return ScriptActionsClientGetExecutionDetailResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScriptActionsClientGetExecutionDetailResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ScriptActionsClientGetExecutionDetailResponse{}, err
	}
	resp, err := client.getExecutionDetailHandleResponse(httpResp)
	return resp, err
}

// getExecutionDetailCreateRequest creates the GetExecutionDetail request.
func (client *ScriptActionsClient) getExecutionDetailCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, scriptExecutionID string, options *ScriptActionsClientGetExecutionDetailOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/scriptExecutionHistory/{scriptExecutionId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	if scriptExecutionID == "" {
		return nil, errors.New("parameter scriptExecutionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scriptExecutionId}", url.PathEscape(scriptExecutionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getExecutionDetailHandleResponse handles the GetExecutionDetail response.
func (client *ScriptActionsClient) getExecutionDetailHandleResponse(resp *http.Response) (ScriptActionsClientGetExecutionDetailResponse, error) {
	result := ScriptActionsClientGetExecutionDetailResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RuntimeScriptActionDetail); err != nil {
		return ScriptActionsClientGetExecutionDetailResponse{}, err
	}
	return result, nil
}

// NewListByClusterPager - Lists all the persisted script actions for the specified cluster.
//
// Generated from API version 2023-04-15-preview
//   - resourceGroupName - The name of the resource group.
//   - clusterName - The name of the cluster.
//   - options - ScriptActionsClientListByClusterOptions contains the optional parameters for the ScriptActionsClient.NewListByClusterPager
//     method.
func (client *ScriptActionsClient) NewListByClusterPager(resourceGroupName string, clusterName string, options *ScriptActionsClientListByClusterOptions) *runtime.Pager[ScriptActionsClientListByClusterResponse] {
	return runtime.NewPager(runtime.PagingHandler[ScriptActionsClientListByClusterResponse]{
		More: func(page ScriptActionsClientListByClusterResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ScriptActionsClientListByClusterResponse) (ScriptActionsClientListByClusterResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ScriptActionsClient.NewListByClusterPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByClusterCreateRequest(ctx, resourceGroupName, clusterName, options)
			}, nil)
			if err != nil {
				return ScriptActionsClientListByClusterResponse{}, err
			}
			return client.listByClusterHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByClusterCreateRequest creates the ListByCluster request.
func (client *ScriptActionsClient) listByClusterCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, options *ScriptActionsClientListByClusterOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/scriptActions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByClusterHandleResponse handles the ListByCluster response.
func (client *ScriptActionsClient) listByClusterHandleResponse(resp *http.Response) (ScriptActionsClientListByClusterResponse, error) {
	result := ScriptActionsClientListByClusterResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScriptActionsList); err != nil {
		return ScriptActionsClientListByClusterResponse{}, err
	}
	return result, nil
}
