//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdataboxedge_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/databoxedge/armdataboxedge"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/GetDiagnosticProactiveLogCollectionSettings.json
func ExampleDiagnosticSettingsClient_GetDiagnosticProactiveLogCollectionSettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDiagnosticSettingsClient().GetDiagnosticProactiveLogCollectionSettings(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DiagnosticProactiveLogCollectionSettings = armdataboxedge.DiagnosticProactiveLogCollectionSettings{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("dataBoxEdgeDevices/diagnosticSettings"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/diagnosticProactiveLogCollectionSettings/default"),
	// 	Properties: &armdataboxedge.ProactiveLogCollectionSettingsProperties{
	// 		UserConsent: to.Ptr(armdataboxedge.ProactiveDiagnosticsConsentEnabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/UpdateDiagnosticProactiveLogCollectionSettings.json
func ExampleDiagnosticSettingsClient_BeginUpdateDiagnosticProactiveLogCollectionSettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDiagnosticSettingsClient().BeginUpdateDiagnosticProactiveLogCollectionSettings(ctx, "testedgedevice", "GroupForEdgeAutomation", armdataboxedge.DiagnosticProactiveLogCollectionSettings{
		Properties: &armdataboxedge.ProactiveLogCollectionSettingsProperties{
			UserConsent: to.Ptr(armdataboxedge.ProactiveDiagnosticsConsentEnabled),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DiagnosticProactiveLogCollectionSettings = armdataboxedge.DiagnosticProactiveLogCollectionSettings{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices/diagnosticSettings"),
	// 	ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourceGroups/GroupForDataBoxEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/dbe-autobot-5428209/diagnosticProactiveLogCollectionSettings/default"),
	// 	Properties: &armdataboxedge.ProactiveLogCollectionSettingsProperties{
	// 		UserConsent: to.Ptr(armdataboxedge.ProactiveDiagnosticsConsentDisabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/GetDiagnosticRemoteSupportSettings.json
func ExampleDiagnosticSettingsClient_GetDiagnosticRemoteSupportSettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDiagnosticSettingsClient().GetDiagnosticRemoteSupportSettings(ctx, "testedgedevice", "GroupForEdgeAutomation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DiagnosticRemoteSupportSettings = armdataboxedge.DiagnosticRemoteSupportSettings{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("dataBoxEdgeDevices/diagnosticSettings"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/diagnosticRemoteSupportSettings/default"),
	// 	Properties: &armdataboxedge.DiagnosticRemoteSupportSettingsProperties{
	// 		RemoteSupportSettingsList: []*armdataboxedge.RemoteSupportSettings{
	// 			{
	// 				AccessLevel: to.Ptr(armdataboxedge.AccessLevelReadWrite),
	// 				ExpirationTimeStampInUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-07T00:00:00.000Z"); return t}()),
	// 				RemoteApplicationType: to.Ptr(armdataboxedge.RemoteApplicationTypeLocalUI),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/UpdateDiagnosticRemoteSupportSettings.json
func ExampleDiagnosticSettingsClient_BeginUpdateDiagnosticRemoteSupportSettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataboxedge.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDiagnosticSettingsClient().BeginUpdateDiagnosticRemoteSupportSettings(ctx, "testedgedevice", "GroupForEdgeAutomation", armdataboxedge.DiagnosticRemoteSupportSettings{
		Properties: &armdataboxedge.DiagnosticRemoteSupportSettingsProperties{
			RemoteSupportSettingsList: []*armdataboxedge.RemoteSupportSettings{
				{
					AccessLevel:              to.Ptr(armdataboxedge.AccessLevelReadWrite),
					ExpirationTimeStampInUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-07T00:00:00.000Z"); return t }()),
					RemoteApplicationType:    to.Ptr(armdataboxedge.RemoteApplicationTypePowershell),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DiagnosticRemoteSupportSettings = armdataboxedge.DiagnosticRemoteSupportSettings{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.DataBoxEdge/dataBoxEdgeDevices/diagnosticSettings"),
	// 	ID: to.Ptr("/subscriptions/0d44739e-0563-474f-97e7-24a0cdb23b29/resourceGroups/GroupForDataBoxEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/dbe-autobot-154c8a4/diagnosticRemoteSupportSettings/default"),
	// 	Properties: &armdataboxedge.DiagnosticRemoteSupportSettingsProperties{
	// 		RemoteSupportSettingsList: []*armdataboxedge.RemoteSupportSettings{
	// 			{
	// 				AccessLevel: to.Ptr(armdataboxedge.AccessLevelReadWrite),
	// 				ExpirationTimeStampInUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2500-09-14T00:00:00.000Z"); return t}()),
	// 				RemoteApplicationType: to.Ptr(armdataboxedge.RemoteApplicationTypePowershell),
	// 		}},
	// 	},
	// }
}
