//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/avs/armavs"
	"net/http"
	"net/url"
	"regexp"
)

// VirtualMachinesServer is a fake server for instances of the armavs.VirtualMachinesClient type.
type VirtualMachinesServer struct {
	// Get is the fake for method VirtualMachinesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string, virtualMachineID string, options *armavs.VirtualMachinesClientGetOptions) (resp azfake.Responder[armavs.VirtualMachinesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method VirtualMachinesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, privateCloudName string, clusterName string, options *armavs.VirtualMachinesClientListOptions) (resp azfake.PagerResponder[armavs.VirtualMachinesClientListResponse])

	// BeginRestrictMovement is the fake for method VirtualMachinesClient.BeginRestrictMovement
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginRestrictMovement func(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string, virtualMachineID string, restrictMovement armavs.VirtualMachineRestrictMovement, options *armavs.VirtualMachinesClientBeginRestrictMovementOptions) (resp azfake.PollerResponder[armavs.VirtualMachinesClientRestrictMovementResponse], errResp azfake.ErrorResponder)
}

// NewVirtualMachinesServerTransport creates a new instance of VirtualMachinesServerTransport with the provided implementation.
// The returned VirtualMachinesServerTransport instance is connected to an instance of armavs.VirtualMachinesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVirtualMachinesServerTransport(srv *VirtualMachinesServer) *VirtualMachinesServerTransport {
	return &VirtualMachinesServerTransport{
		srv:                   srv,
		newListPager:          newTracker[azfake.PagerResponder[armavs.VirtualMachinesClientListResponse]](),
		beginRestrictMovement: newTracker[azfake.PollerResponder[armavs.VirtualMachinesClientRestrictMovementResponse]](),
	}
}

// VirtualMachinesServerTransport connects instances of armavs.VirtualMachinesClient to instances of VirtualMachinesServer.
// Don't use this type directly, use NewVirtualMachinesServerTransport instead.
type VirtualMachinesServerTransport struct {
	srv                   *VirtualMachinesServer
	newListPager          *tracker[azfake.PagerResponder[armavs.VirtualMachinesClientListResponse]]
	beginRestrictMovement *tracker[azfake.PollerResponder[armavs.VirtualMachinesClientRestrictMovementResponse]]
}

// Do implements the policy.Transporter interface for VirtualMachinesServerTransport.
func (v *VirtualMachinesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VirtualMachinesClient.Get":
		resp, err = v.dispatchGet(req)
	case "VirtualMachinesClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	case "VirtualMachinesClient.BeginRestrictMovement":
		resp, err = v.dispatchBeginRestrictMovement(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualMachineId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	virtualMachineIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceGroupNameParam, privateCloudNameParam, clusterNameParam, virtualMachineIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VirtualMachine, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListPager(resourceGroupNameParam, privateCloudNameParam, clusterNameParam, nil)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armavs.VirtualMachinesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginRestrictMovement(req *http.Request) (*http.Response, error) {
	if v.srv.BeginRestrictMovement == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestrictMovement not implemented")}
	}
	beginRestrictMovement := v.beginRestrictMovement.get(req)
	if beginRestrictMovement == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualMachineId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restrictMovement`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.VirtualMachineRestrictMovement](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		virtualMachineIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginRestrictMovement(req.Context(), resourceGroupNameParam, privateCloudNameParam, clusterNameParam, virtualMachineIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestrictMovement = &respr
		v.beginRestrictMovement.add(req, beginRestrictMovement)
	}

	resp, err := server.PollerResponderNext(beginRestrictMovement, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		v.beginRestrictMovement.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestrictMovement) {
		v.beginRestrictMovement.remove(req)
	}

	return resp, nil
}
