#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment
        self.key_macro = [
            [1, "KEY_LEFTCTRL"],
            [1, "KEY_G"],
            [0.05, "sleep"],
            [0, "KEY_G"],
            [0, "KEY_LEFTCTRL"],
        ]

    def shutdown(self):
        pass

    def get_description(self):
        return "No description found"

    def run(self):
        self.env["runtime"]["InputManager"].send_keys(self.key_macro)

    def set_callback(self, callback):
        pass
