// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2025  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Logger_h__
#define __Logger_h__

/** \file
 * This module provides a globale 'log' object that can be used like std::cout.
 * It supports indentation levels and can be configured to print messages
 * only up to a certain level. */

#include <sstream>
#include <iostream>

namespace ACxx {

  enum LoggerEnd { endlog };

  class Logger {
    int level_ = 0;
    int verbosity_ = 0;
    std::ostream *out_ = &std::cout;
    std::ostringstream msg_;
  public:

    template<typename T> Logger &operator << (const T &obj) {
      msg_ << obj;
      return (Logger&)*this;
    }

    Logger &operator << (LoggerEnd obj);

    /** Change the output stream object.
     * \param out The new stream. */
    void set_output_stream(std::ostream &out) { out_ = &out; }

    /** Set the verbosity level.
     * \param verbose The verbosity level. */
    void verbosity(int v) {
      verbosity_ = v;
    }
    /** Get the verbosity level.
     * \return The verbosity level. */
    int verbosity() const {
      return verbosity_;
    }
    /** Increase the current level starting at 0. */
    void operator ++(int) {
      level_++;
    }
    /** Decrease the current level starting at 0. */
    void operator --(int) {
      level_--;
    }

  };

  extern Logger logger; // the global Logger instance for this project
}

#endif /* __Logger_h__ */
