#ifndef MSIO_TYPES
#define MSIO_TYPES

class AntennaInfo;
class BandInfo;
class FieldInfo;
class TimeFrequencyData;
class TimeFrequencyImager;
class FitsFile;

#define NUM_T_IS_FLOAT

#ifdef NUM_T_IS_FLOAT
typedef float num_t;

#define M_PIn M_PI

#else  // NOT NUM_T_IS_FLOAT

typedef double num_t;

#define M_PIn M_PI

#endif

// numl_t is the numeric type for high precision, intermediate calculations
typedef long double numl_t;

// M_PIl is not defined on some OS-X systems
#ifndef M_PIl
#define M_PIl 3.1415926535897932384626433832795029L /* pi */
#endif
#define M_PInl M_PIl

enum DataKind {
  ObservedData,
  CorrectedData,
  ResidualData,
  ModelData,
  WeightData
};

class ParmTable;

enum BaselineIOMode {
  DirectReadMode,
  ReorderingReadMode,
  MemoryReadMode,
  AutoReadMode
};

#endif  // MSIO_TYPES
