#include "rangeinputdialog.h"

RangeInputDialog::RangeInputDialog(Gtk::Window& parent,
                                   const std::string& question,
                                   double default_start, double default_end)
    : Gtk::MessageDialog(parent, question, false, Gtk::MessageType::QUESTION,
                         Gtk::ButtonsType::OK_CANCEL, true) {
  std::ostringstream start_str;
  start_str << default_start;
  start_range_.set_text(start_str.str());

  box_.append(start_range_);
  box_.append(dash_label_);

  std::ostringstream end_str;
  end_str << default_end;
  end_range_.set_text(end_str.str());

  box_.append(end_range_);
  Gtk::Box* box = get_content_area();
  box->append(box_);
}

double RangeInputDialog::GetStart() const {
  return std::atof(start_range_.get_text().c_str());
}

double RangeInputDialog::GetEnd() const {
  return std::atof(end_range_.get_text().c_str());
}
